/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.core.resources;

import griffon.core.CallableWithArgs;
import griffon.core.editors.PropertyEditorResolver;
import griffon.core.resources.NoSuchResourceException;
import griffon.core.resources.ResourceResolver;
import griffon.util.GriffonNameUtils;
import java.beans.PropertyEditor;
import java.text.MessageFormat;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AbstractResourceResolver
implements ResourceResolver {
    protected static final String ERROR_KEY_BLANK = "Argument 'key' must not be blank";
    protected static final String ERROR_LOCALE_NULL = "Argument 'locale' must not be null";
    protected static final String ERROR_ARGS_NULL = "Argument 'args' must not be null";
    protected static final String ERROR_RESOURCE_NULL = "Argument 'resource' must not be null";
    protected static final Object[] EMPTY_OBJECT_ARGS = new Object[0];

    @Override
    @Nonnull
    public Object resolveResource(@Nonnull String string) throws NoSuchResourceException {
        return this.resolveResource(string, EMPTY_OBJECT_ARGS, Locale.getDefault());
    }

    @Override
    @Nonnull
    public Object resolveResource(@Nonnull String string, @Nonnull Locale locale) throws NoSuchResourceException {
        return this.resolveResource(string, EMPTY_OBJECT_ARGS, locale);
    }

    @Override
    @Nonnull
    public Object resolveResource(@Nonnull String string, @Nonnull Object[] objectArray) throws NoSuchResourceException {
        return this.resolveResource(string, objectArray, Locale.getDefault());
    }

    @Override
    @Nonnull
    public Object resolveResource(@Nonnull String string, @Nonnull Object[] objectArray, @Nonnull Locale locale) throws NoSuchResourceException {
        GriffonNameUtils.requireNonBlank(string, ERROR_KEY_BLANK);
        Objects.requireNonNull(objectArray, ERROR_ARGS_NULL);
        Objects.requireNonNull(locale, ERROR_LOCALE_NULL);
        Object object = this.resolveResourceValue(string, locale);
        Object object2 = this.evalResourceWithArguments(object, objectArray);
        if (object2 != null) {
            return object2;
        }
        throw new NoSuchResourceException(string, locale);
    }

    @Override
    @Nonnull
    public Object resolveResource(@Nonnull String string, @Nonnull List<?> list) throws NoSuchResourceException {
        return this.resolveResource(string, this.toObjectArray(list), Locale.getDefault());
    }

    @Override
    @Nonnull
    public Object resolveResource(@Nonnull String string, @Nonnull List<?> list, @Nonnull Locale locale) throws NoSuchResourceException {
        return this.resolveResource(string, this.toObjectArray(list), locale);
    }

    @Override
    @Nullable
    public Object resolveResource(@Nonnull String string, @Nullable Object object) {
        return this.resolveResource(string, EMPTY_OBJECT_ARGS, Locale.getDefault(), object);
    }

    @Override
    @Nullable
    public Object resolveResource(@Nonnull String string, @Nonnull Locale locale, @Nullable Object object) {
        return this.resolveResource(string, EMPTY_OBJECT_ARGS, locale, object);
    }

    @Override
    @Nullable
    public Object resolveResource(@Nonnull String string, @Nonnull Object[] objectArray, @Nullable Object object) {
        return this.resolveResource(string, objectArray, Locale.getDefault(), object);
    }

    @Override
    @Nullable
    public Object resolveResource(@Nonnull String string, @Nonnull Object[] objectArray, @Nonnull Locale locale, @Nullable Object object) {
        try {
            return this.resolveResource(string, objectArray, locale);
        }
        catch (NoSuchResourceException noSuchResourceException) {
            return null == object ? string : object;
        }
    }

    @Override
    @Nullable
    public Object resolveResource(@Nonnull String string, @Nonnull List<?> list, @Nullable Object object) {
        return this.resolveResource(string, this.toObjectArray(list), Locale.getDefault(), object);
    }

    @Override
    @Nullable
    public Object resolveResource(@Nonnull String string, @Nonnull List<?> list, @Nonnull Locale locale, @Nullable Object object) {
        return this.resolveResource(string, this.toObjectArray(list), locale, object);
    }

    @Override
    @Nonnull
    public Object resolveResource(@Nonnull String string, @Nonnull Map<String, Object> map) throws NoSuchResourceException {
        return this.resolveResource(string, map, Locale.getDefault());
    }

    @Override
    @Nonnull
    public Object resolveResource(@Nonnull String string, @Nonnull Map<String, Object> map, @Nonnull Locale locale) throws NoSuchResourceException {
        GriffonNameUtils.requireNonBlank(string, ERROR_KEY_BLANK);
        Objects.requireNonNull(map, ERROR_ARGS_NULL);
        Objects.requireNonNull(locale, ERROR_LOCALE_NULL);
        Object object = this.resolveResourceValue(string, locale);
        Object object2 = this.evalResourceWithArguments(object, map);
        if (object2 != null) {
            return object2;
        }
        throw new NoSuchResourceException(string, locale);
    }

    @Override
    @Nullable
    public Object resolveResource(@Nonnull String string, @Nonnull Map<String, Object> map, @Nullable Object object) {
        return this.resolveResource(string, map, Locale.getDefault(), object);
    }

    @Override
    @Nullable
    public Object resolveResource(@Nonnull String string, @Nonnull Map<String, Object> map, @Nonnull Locale locale, @Nullable Object object) {
        try {
            return this.resolveResource(string, map, locale);
        }
        catch (NoSuchResourceException noSuchResourceException) {
            return null == object ? string : object;
        }
    }

    @Override
    @Nullable
    public <T> T resolveResourceConverted(@Nonnull String string, @Nonnull List<?> list, @Nullable T t, @Nonnull Class<T> clazz) {
        return this.convertValue(this.resolveResource(string, list, t), clazz);
    }

    @Override
    @Nullable
    public <T> T resolveResourceConverted(@Nonnull String string, @Nonnull List<?> list, @Nonnull Locale locale, @Nullable T t, @Nonnull Class<T> clazz) {
        return this.convertValue(this.resolveResource(string, list, locale, t), clazz);
    }

    @Override
    @Nonnull
    public <T> T resolveResourceConverted(@Nonnull String string, @Nonnull List<?> list, @Nonnull Locale locale, @Nonnull Class<T> clazz) throws NoSuchResourceException {
        return this.convertValue(this.resolveResource(string, list, locale), clazz);
    }

    @Override
    @Nonnull
    public <T> T resolveResourceConverted(@Nonnull String string, @Nonnull List<?> list, @Nonnull Class<T> clazz) throws NoSuchResourceException {
        return this.convertValue(this.resolveResource(string, list), clazz);
    }

    @Override
    @Nullable
    public <T> T resolveResourceConverted(@Nonnull String string, @Nonnull Map<String, Object> map, @Nullable T t, @Nonnull Class<T> clazz) {
        return this.convertValue(this.resolveResource(string, map, t), clazz);
    }

    @Override
    @Nullable
    public <T> T resolveResourceConverted(@Nonnull String string, @Nonnull Map<String, Object> map, @Nonnull Locale locale, @Nullable T t, @Nonnull Class<T> clazz) {
        return this.convertValue(this.resolveResource(string, map, locale, t), clazz);
    }

    @Override
    @Nonnull
    public <T> T resolveResourceConverted(@Nonnull String string, @Nonnull Map<String, Object> map, @Nonnull Locale locale, @Nonnull Class<T> clazz) throws NoSuchResourceException {
        return this.convertValue(this.resolveResource(string, map, locale), clazz);
    }

    @Override
    @Nonnull
    public <T> T resolveResourceConverted(@Nonnull String string, @Nonnull Map<String, Object> map, @Nonnull Class<T> clazz) throws NoSuchResourceException {
        return this.convertValue(this.resolveResource(string, map), clazz);
    }

    @Override
    @Nullable
    public <T> T resolveResourceConverted(@Nonnull String string, @Nonnull Object[] objectArray, @Nullable T t, @Nonnull Class<T> clazz) {
        return this.convertValue(this.resolveResource(string, objectArray, t), clazz);
    }

    @Override
    @Nullable
    public <T> T resolveResourceConverted(@Nonnull String string, @Nonnull Object[] objectArray, @Nonnull Locale locale, @Nullable T t, @Nonnull Class<T> clazz) {
        return this.convertValue(this.resolveResource(string, objectArray, locale, t), clazz);
    }

    @Override
    @Nonnull
    public <T> T resolveResourceConverted(@Nonnull String string, @Nonnull Object[] objectArray, @Nonnull Locale locale, @Nonnull Class<T> clazz) throws NoSuchResourceException {
        return this.convertValue(this.resolveResource(string, objectArray, locale), clazz);
    }

    @Override
    @Nonnull
    public <T> T resolveResourceConverted(@Nonnull String string, @Nonnull Object[] objectArray, @Nonnull Class<T> clazz) throws NoSuchResourceException {
        return this.convertValue(this.resolveResource(string, objectArray), clazz);
    }

    @Override
    @Nullable
    public <T> T resolveResourceConverted(@Nonnull String string, @Nullable T t, @Nonnull Class<T> clazz) {
        return this.convertValue(this.resolveResource(string, t), clazz);
    }

    @Override
    @Nullable
    public <T> T resolveResourceConverted(@Nonnull String string, @Nonnull Locale locale, @Nullable T t, @Nonnull Class<T> clazz) {
        return this.convertValue(this.resolveResource(string, locale, t), clazz);
    }

    @Override
    @Nonnull
    public <T> T resolveResourceConverted(@Nonnull String string, @Nonnull Locale locale, @Nonnull Class<T> clazz) throws NoSuchResourceException {
        return this.convertValue(this.resolveResource(string, locale), clazz);
    }

    @Override
    @Nonnull
    public <T> T resolveResourceConverted(@Nonnull String string, @Nonnull Class<T> clazz) throws NoSuchResourceException {
        return this.convertValue(this.resolveResource(string), clazz);
    }

    @Override
    @Nonnull
    public Object resolveResourceValue(@Nonnull String string, @Nonnull Locale locale) throws NoSuchResourceException {
        GriffonNameUtils.requireNonBlank(string, ERROR_KEY_BLANK);
        Objects.requireNonNull(locale, ERROR_LOCALE_NULL);
        try {
            String string2;
            Object object = this.doResolveResourceValue(string, locale);
            if (object instanceof CharSequence && (string2 = object.toString()).length() >= 4 && string2.startsWith("@[") && string2.endsWith("]")) {
                String string3 = string2.substring(2, string2.length() - 1);
                object = this.resolveResourceValue(string3, locale);
            }
            return object;
        }
        catch (MissingResourceException missingResourceException) {
            throw new NoSuchResourceException(string, locale);
        }
    }

    @Override
    @Nonnull
    public String formatResource(@Nonnull String string, @Nonnull List<?> list) {
        Objects.requireNonNull(string, ERROR_RESOURCE_NULL);
        Objects.requireNonNull(list, ERROR_ARGS_NULL);
        return this.formatResource(string, list.toArray(new Object[list.size()]));
    }

    @Override
    @Nonnull
    public String formatResource(@Nonnull String string, @Nonnull Object[] objectArray) {
        Objects.requireNonNull(string, ERROR_RESOURCE_NULL);
        Objects.requireNonNull(objectArray, ERROR_ARGS_NULL);
        if (objectArray.length == 0) {
            return string;
        }
        return MessageFormat.format(string, objectArray);
    }

    @Override
    @Nonnull
    public String formatResource(@Nonnull String string, @Nonnull Map<String, Object> map) {
        Objects.requireNonNull(string, ERROR_RESOURCE_NULL);
        Objects.requireNonNull(map, ERROR_ARGS_NULL);
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String string2 = entry.getKey();
            String string3 = entry.getValue() != null ? entry.getValue().toString() : null;
            if (string3 == null) continue;
            string = string.replace("{:" + string2 + "}", string3);
        }
        return string;
    }

    @Nonnull
    protected abstract Object doResolveResourceValue(@Nonnull String var1, @Nonnull Locale var2) throws NoSuchResourceException;

    @Nullable
    protected Object evalResourceWithArguments(@Nonnull Object object, @Nonnull Object[] objectArray) {
        if (object instanceof CallableWithArgs) {
            CallableWithArgs callableWithArgs = (CallableWithArgs)object;
            return callableWithArgs.call(objectArray);
        }
        if (object instanceof CharSequence) {
            return this.formatResource(String.valueOf(object), objectArray);
        }
        return object;
    }

    @Nullable
    protected Object evalResourceWithArguments(@Nonnull Object object, @Nonnull Map<String, Object> map) {
        if (object instanceof CallableWithArgs) {
            CallableWithArgs callableWithArgs = (CallableWithArgs)object;
            return callableWithArgs.call(map);
        }
        if (object instanceof CharSequence) {
            return this.formatResource(String.valueOf(object), map);
        }
        return object;
    }

    @Nonnull
    protected Object[] toObjectArray(@Nonnull List<?> list) {
        if (list.isEmpty()) {
            return EMPTY_OBJECT_ARGS;
        }
        return list.toArray(new Object[list.size()]);
    }

    protected <T> T convertValue(@Nullable Object object, @Nonnull Class<T> clazz) {
        if (object != null) {
            if (clazz.isAssignableFrom(object.getClass())) {
                return (T)object;
            }
            PropertyEditor propertyEditor = PropertyEditorResolver.findEditor(clazz);
            propertyEditor.setValue(object);
            return (T)propertyEditor.getValue();
        }
        return null;
    }
}

