/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.core.resources;

import griffon.core.resources.NoSuchResourceException;
import griffon.core.resources.ResourceResolver;
import griffon.util.GriffonClassUtils;
import griffon.util.GriffonNameUtils;
import java.util.Collection;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.codehaus.griffon.runtime.core.resources.AbstractResourceResolver;

public class CompositeResourceResolver
extends AbstractResourceResolver {
    private final ResourceResolver[] resourceResolvers;

    public CompositeResourceResolver(@Nonnull Collection<ResourceResolver> collection) {
        this(CompositeResourceResolver.toResourceResolverArray(collection));
    }

    public CompositeResourceResolver(@Nonnull ResourceResolver[] resourceResolverArray) {
        this.resourceResolvers = Objects.requireNonNull(resourceResolverArray, "Argument 'resourceResolvers' must not be null");
    }

    private static ResourceResolver[] toResourceResolverArray(@Nonnull Collection<ResourceResolver> collection) {
        Objects.requireNonNull(collection, "Argument 'resourceResolvers' must not be null");
        GriffonClassUtils.requireNonEmpty(collection, "Argument 'resourceResolvers' must not be empty");
        return collection.toArray(new ResourceResolver[collection.size()]);
    }

    @Override
    @Nonnull
    protected Object doResolveResourceValue(@Nonnull String string, @Nonnull Locale locale) throws NoSuchResourceException {
        GriffonNameUtils.requireNonBlank(string, "Argument 'key' must not be blank");
        Objects.requireNonNull(locale, "Argument 'locale' must not be null");
        for (ResourceResolver resourceResolver : this.resourceResolvers) {
            try {
                return resourceResolver.resolveResourceValue(string, locale);
            }
            catch (NoSuchResourceException noSuchResourceException) {
            }
        }
        throw new NoSuchResourceException(string, locale);
    }
}

