/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.core.resources;

import griffon.core.resources.NoSuchResourceException;
import griffon.util.CompositeResourceBundleBuilder;
import griffon.util.GriffonNameUtils;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import org.codehaus.griffon.runtime.core.resources.AbstractResourceResolver;

public class DefaultResourceResolver
extends AbstractResourceResolver {
    private final String basename;
    private final Map<Locale, ResourceBundle> bundles = new ConcurrentHashMap<Locale, ResourceBundle>();
    private final CompositeResourceBundleBuilder compositeResourceBundleBuilder;

    public DefaultResourceResolver(@Nonnull CompositeResourceBundleBuilder compositeResourceBundleBuilder, @Nonnull String string) {
        this.compositeResourceBundleBuilder = Objects.requireNonNull(compositeResourceBundleBuilder, "Argument 'builder' must not be null");
        this.basename = GriffonNameUtils.requireNonBlank(string, "Argument 'basename' must not be blank");
    }

    @Nonnull
    public String getBasename() {
        return this.basename;
    }

    @Override
    @Nonnull
    protected Object doResolveResourceValue(@Nonnull String string, @Nonnull Locale locale) throws NoSuchResourceException {
        GriffonNameUtils.requireNonBlank(string, "Argument 'key' must not be blank");
        Objects.requireNonNull(locale, "Argument 'locale' must not be null");
        return this.getBundle(locale).getObject(string);
    }

    @Nonnull
    protected ResourceBundle getBundle(@Nonnull Locale locale) {
        Objects.requireNonNull(locale, "Argument 'locale' must not be null");
        ResourceBundle resourceBundle = this.bundles.get(locale);
        if (null == resourceBundle) {
            resourceBundle = this.compositeResourceBundleBuilder.create(this.basename, locale);
            this.bundles.put(locale, resourceBundle);
        }
        return resourceBundle;
    }
}

