/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.core.storage;

import griffon.core.Configuration;
import griffon.core.GriffonApplication;
import griffon.core.storage.ObjectFactory;
import griffon.util.ConfigUtils;
import griffon.util.GriffonNameUtils;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.inject.Inject;

public abstract class AbstractObjectFactory<T>
implements ObjectFactory<T> {
    private final Configuration configuration;
    private final GriffonApplication application;

    @Inject
    public AbstractObjectFactory(@Nonnull Configuration configuration, @Nonnull GriffonApplication griffonApplication) {
        this.configuration = Objects.requireNonNull(configuration, "Argument 'configuration' must not be null");
        this.application = Objects.requireNonNull(griffonApplication, "Argument 'application' must not be null");
    }

    @Nonnull
    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Nonnull
    public GriffonApplication getApplication() {
        return this.application;
    }

    @Nonnull
    protected abstract String getSingleKey();

    @Nonnull
    protected abstract String getPluralKey();

    protected void event(@Nonnull String string, @Nonnull List<?> list) {
        this.application.getEventRouter().publishEvent(string, list);
    }

    @Nonnull
    protected Map<String, Object> narrowConfig(@Nonnull String string) {
        GriffonNameUtils.requireNonBlank(string, "Argument 'name' must not be blank");
        if ("default".equals(string) && this.configuration.containsKey(this.getSingleKey())) {
            return (Map)this.configuration.get(this.getSingleKey());
        }
        if (this.configuration.containsKey(this.getPluralKey())) {
            Map map = (Map)this.configuration.get(this.getPluralKey());
            return ConfigUtils.getConfigValue(map, string, Collections.emptyMap());
        }
        return Collections.emptyMap();
    }
}

