/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.core.storage;

import griffon.core.storage.ObjectStorage;
import griffon.util.GriffonNameUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DefaultObjectStorage<T>
implements ObjectStorage<T> {
    private static final String DEFAULT_KEY = "default";
    private final Map<String, T> instances = new ConcurrentHashMap<String, T>();

    @Override
    @Nonnull
    public String[] getKeys() {
        Set<String> set = this.instances.keySet();
        return set.toArray(new String[set.size()]);
    }

    @Override
    @Nonnull
    public Collection<T> getValues() {
        LinkedHashSet<T> linkedHashSet = new LinkedHashSet<T>();
        linkedHashSet.addAll(this.instances.values());
        return Collections.unmodifiableSet(linkedHashSet);
    }

    @Override
    @Nullable
    public T get(@Nonnull String string) {
        return this.instances.get(this.resolveKey(string));
    }

    @Override
    @Nullable
    public T remove(@Nonnull String string) {
        return this.instances.remove(this.resolveKey(string));
    }

    @Override
    public void set(@Nonnull String string, @Nonnull T t) {
        this.instances.put(this.resolveKey(string), Objects.requireNonNull(t, "Argument 'instance' must not be null"));
    }

    @Override
    public boolean contains(@Nonnull String string) {
        return this.instances.containsKey(this.resolveKey(string));
    }

    @Nonnull
    private String resolveKey(@Nonnull String string) {
        return GriffonNameUtils.isBlank(string) ? DEFAULT_KEY : string.trim();
    }
}

