/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.core.threading;

import griffon.core.threading.ThreadingHandler;
import griffon.core.threading.UIThreadManager;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;

public abstract class AbstractThreadingHandler
implements ThreadingHandler {
    private UIThreadManager uiThreadManager;

    @Inject
    public void setUIThreadManager(@Nonnull UIThreadManager uIThreadManager) {
        this.uiThreadManager = Objects.requireNonNull(uIThreadManager, "Argument 'uiThreadManager' must not be null");
    }

    @Override
    public boolean isUIThread() {
        return this.uiThreadManager.isUIThread();
    }

    @Override
    public void runInsideUIAsync(@Nonnull Runnable runnable) {
        this.uiThreadManager.runInsideUIAsync(runnable);
    }

    @Override
    public void runInsideUISync(@Nonnull Runnable runnable) {
        this.uiThreadManager.runInsideUISync(runnable);
    }

    @Override
    public void runOutsideUI(@Nonnull Runnable runnable) {
        this.uiThreadManager.runOutsideUI(runnable);
    }

    @Override
    @Nonnull
    public <R> Future<R> runFuture(@Nonnull ExecutorService executorService, @Nonnull Callable<R> callable) {
        return this.uiThreadManager.runFuture(executorService, callable);
    }

    @Override
    @Nonnull
    public <R> Future<R> runFuture(@Nonnull Callable<R> callable) {
        return this.uiThreadManager.runFuture(callable);
    }

    @Override
    @Nullable
    public <R> R runInsideUISync(@Nonnull Callable<R> callable) {
        return this.uiThreadManager.runInsideUISync(callable);
    }
}

