/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.core.threading;

import griffon.core.ExceptionHandler;
import griffon.core.ExecutorServiceManager;
import griffon.core.threading.UIThreadManager;
import griffon.exceptions.GriffonException;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;

public abstract class AbstractUIThreadManager
implements UIThreadManager {
    protected static final String ERROR_RUNNABLE_NULL = "Argument 'runnable' must not be null";
    protected static final String ERROR_CALLABLE_NULL = "Argument 'callable' must not be null";
    private ExecutorServiceManager executorServiceManager;
    @Inject
    @Named(value="defaultExecutorService")
    private ExecutorService executorService;
    @Inject
    private ExceptionHandler exceptionHandler;

    @Inject
    public void setExecutorServiceManager(@Nonnull ExecutorServiceManager executorServiceManager) {
        Objects.requireNonNull(executorServiceManager, "Argument 'executorServiceManager' must not be null");
        if (this.executorServiceManager != null) {
            this.executorServiceManager.remove(this.executorService);
        }
        this.executorServiceManager = executorServiceManager;
        this.executorServiceManager.add(this.executorService);
    }

    @Override
    @Nonnull
    public <R> Future<R> runFuture(@Nonnull Callable<R> callable) {
        Objects.requireNonNull(callable, ERROR_CALLABLE_NULL);
        return this.runFuture(this.executorService, callable);
    }

    @Override
    @Nonnull
    public <R> Future<R> runFuture(@Nonnull ExecutorService executorService, @Nonnull Callable<R> callable) {
        Objects.requireNonNull(executorService, "Argument 'executorService' must not be null");
        Objects.requireNonNull(callable, ERROR_CALLABLE_NULL);
        return executorService.submit(callable);
    }

    @Override
    public void runOutsideUI(final @Nonnull Runnable runnable) {
        Objects.requireNonNull(runnable, ERROR_RUNNABLE_NULL);
        if (!this.isUIThread()) {
            runnable.run();
        } else {
            this.executorService.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        runnable.run();
                    }
                    catch (Throwable throwable) {
                        AbstractUIThreadManager.this.exceptionHandler.uncaughtException(Thread.currentThread(), throwable);
                    }
                }
            });
        }
    }

    @Override
    @Nullable
    public <R> R runInsideUISync(@Nonnull Callable<R> callable) {
        Objects.requireNonNull(callable, ERROR_CALLABLE_NULL);
        FutureTask<R> futureTask = new FutureTask<R>(callable);
        this.runInsideUISync(futureTask);
        try {
            return futureTask.get();
        }
        catch (InterruptedException | ExecutionException exception) {
            throw new GriffonException("An error occurred while executing a task inside the UI thread", exception);
        }
    }
}

