/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.core.view;

import griffon.core.ApplicationEvent;
import griffon.core.GriffonApplication;
import griffon.core.env.ApplicationPhase;
import griffon.core.event.EventRouter;
import griffon.core.view.WindowDisplayHandler;
import griffon.core.view.WindowManager;
import griffon.exceptions.InstanceNotFoundException;
import griffon.util.GriffonNameUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractWindowManager<W>
implements WindowManager<W> {
    protected static final String ERROR_NAME_BLANK = "Argument 'name' must not be blank";
    protected static final String ERROR_WINDOW_NULL = "Argument 'window' must not be null";
    private static final Logger LOG = LoggerFactory.getLogger(AbstractWindowManager.class);
    private final Map<String, W> windows = Collections.synchronizedMap(new LinkedHashMap());
    private final GriffonApplication application;
    private final WindowDisplayHandler<W> windowDisplayHandler;

    @Inject
    public AbstractWindowManager(@Nonnull GriffonApplication griffonApplication, @Nonnull WindowDisplayHandler<W> windowDisplayHandler) {
        this.application = Objects.requireNonNull(griffonApplication, "Argument 'application' must not be null");
        Objects.requireNonNull(griffonApplication.getConfiguration(), "Argument 'application.configuration' must not be null");
        Objects.requireNonNull(griffonApplication.getUIThreadManager(), "Argument 'application.uiThreadManager' must not be null");
        this.windowDisplayHandler = Objects.requireNonNull(windowDisplayHandler, "Argument 'windowDisplayHandler' must not be null");
    }

    protected GriffonApplication getApplication() {
        return this.application;
    }

    @Override
    @Nonnull
    public Set<String> getWindowNames() {
        return Collections.unmodifiableSet(this.windows.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public String findWindowName(@Nonnull W w) {
        Objects.requireNonNull(w, ERROR_WINDOW_NULL);
        Map<String, W> map = this.windows;
        synchronized (map) {
            for (Map.Entry<String, W> entry : this.windows.entrySet()) {
                if (!entry.getValue().equals(w)) continue;
                return entry.getKey();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int indexOf(@Nonnull W w) {
        Objects.requireNonNull(w, ERROR_WINDOW_NULL);
        Map<String, W> map = this.windows;
        synchronized (map) {
            int n = 0;
            for (W w2 : this.windows.values()) {
                if (w.equals(w2)) {
                    return n;
                }
                ++n;
            }
        }
        return -1;
    }

    @Override
    @Nullable
    public W findWindow(@Nonnull String string) {
        GriffonNameUtils.requireNonBlank(string, ERROR_NAME_BLANK);
        return this.windows.get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public W getAt(int n) {
        Map<String, W> map = this.windows;
        synchronized (map) {
            int n2 = this.windows.size();
            if (n < 0 || n >= n2) {
                throw new ArrayIndexOutOfBoundsException(n);
            }
            int n3 = 0;
            for (W w : this.windows.values()) {
                if (n != n3++) continue;
                return w;
            }
        }
        throw new ArrayIndexOutOfBoundsException(n);
    }

    @Override
    @Nullable
    public W getStartingWindow() {
        W w;
        Object object = this.resolveStartingWindowFromConfiguration();
        LOG.debug("windowManager.startingWindow configured to {}", object);
        if (object instanceof String) {
            String string = (String)object;
            LOG.debug("Selecting window {} as starting window", (Object)string);
            w = this.findWindow(string);
        } else if (object instanceof Number) {
            int n = ((Number)object).intValue();
            LOG.debug("Selecting window at index {} as starting window", (Object)n);
            w = this.getAt(n);
        } else {
            LOG.debug("No startingWindow configured, selecting the first one from the windows list");
            w = this.getAt(0);
        }
        LOG.debug("Starting Window is {}", w);
        return w;
    }

    @Nullable
    protected Object resolveStartingWindowFromConfiguration() {
        return this.application.getConfiguration().get("windowManager.startingWindow", null);
    }

    @Override
    @Nonnull
    public Collection<W> getWindows() {
        return Collections.unmodifiableCollection(this.windows.values());
    }

    @Override
    public void attach(@Nonnull String string, @Nonnull W w) {
        W w2;
        GriffonNameUtils.requireNonBlank(string, ERROR_NAME_BLANK);
        Objects.requireNonNull(w, ERROR_WINDOW_NULL);
        if (this.windows.containsKey(string) && (w2 = this.windows.get(string)) != w) {
            this.detach(string);
        }
        this.doAttach(w);
        LOG.debug("Attaching window with name: '{}' at index {} {}", new Object[]{string, this.windows.size(), w});
        this.windows.put(string, w);
        this.event(ApplicationEvent.WINDOW_ATTACHED, Arrays.asList(string, w));
    }

    protected abstract void doAttach(@Nonnull W var1);

    @Override
    public void detach(@Nonnull String string) {
        GriffonNameUtils.requireNonBlank(string, ERROR_NAME_BLANK);
        if (this.windows.containsKey(string)) {
            W w = this.windows.get(string);
            this.doDetach(w);
            LOG.debug("Detaching window with name: '{}' {}", (Object)string, w);
            this.windows.remove(string);
            this.event(ApplicationEvent.WINDOW_DETACHED, Arrays.asList(string, w));
        }
    }

    protected abstract void doDetach(@Nonnull W var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void show(@Nonnull W w) {
        int n;
        Objects.requireNonNull(w, ERROR_WINDOW_NULL);
        if (!this.windows.containsValue(w)) {
            return;
        }
        String string = null;
        int n2 = -1;
        Map<String, W> map = this.windows;
        synchronized (map) {
            n = 0;
            for (Map.Entry<String, W> entry : this.windows.entrySet()) {
                if (entry.getValue() == w) {
                    string = entry.getKey();
                    n2 = n;
                    break;
                }
                ++n;
            }
        }
        map = string;
        n = n2;
        this.application.getUIThreadManager().runInsideUIAsync(new Runnable((String)((Object)map), n, w){
            final /* synthetic */ String val$name;
            final /* synthetic */ int val$index;
            final /* synthetic */ Object val$window;
            {
                this.val$name = string;
                this.val$index = n;
                this.val$window = object;
            }

            @Override
            public void run() {
                LOG.debug("Showing window with name: '{}' at index {} {}", new Object[]{this.val$name, this.val$index, this.val$window});
                AbstractWindowManager.this.resolveWindowDisplayHandler().show(this.val$name, this.val$window);
            }
        });
    }

    @Override
    public void show(@Nonnull String string) {
        GriffonNameUtils.requireNonBlank(string, ERROR_NAME_BLANK);
        W w = this.findWindow(string);
        if (w != null) {
            this.show(w);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void hide(@Nonnull W w) {
        int n;
        Objects.requireNonNull(w, ERROR_WINDOW_NULL);
        if (!this.windows.containsValue(w)) {
            return;
        }
        String string = null;
        int n2 = -1;
        Map<String, W> map = this.windows;
        synchronized (map) {
            n = 0;
            for (Map.Entry<String, W> entry : this.windows.entrySet()) {
                if (entry.getValue() == w) {
                    string = entry.getKey();
                    n2 = n;
                    break;
                }
                ++n;
            }
        }
        map = string;
        n = n2;
        this.application.getUIThreadManager().runInsideUIAsync(new Runnable((String)((Object)map), n, w){
            final /* synthetic */ String val$name;
            final /* synthetic */ int val$index;
            final /* synthetic */ Object val$window;
            {
                this.val$name = string;
                this.val$index = n;
                this.val$window = object;
            }

            @Override
            public void run() {
                LOG.debug("Hiding window with name: '{}' at index {} {}", new Object[]{this.val$name, this.val$index, this.val$window});
                AbstractWindowManager.this.resolveWindowDisplayHandler().hide(this.val$name, this.val$window);
            }
        });
    }

    @Nonnull
    protected WindowDisplayHandler<W> resolveWindowDisplayHandler() {
        return this.windowDisplayHandler;
    }

    @Override
    public void hide(@Nonnull String string) {
        GriffonNameUtils.requireNonBlank(string, ERROR_NAME_BLANK);
        W w = this.findWindow(string);
        if (w != null) {
            this.hide(w);
        }
    }

    @Override
    public boolean canShutdown(@Nonnull GriffonApplication griffonApplication) {
        return true;
    }

    @Override
    public void onShutdown(@Nonnull GriffonApplication griffonApplication) {
        for (W w : this.windows.values()) {
            if (!this.isWindowVisible(w)) continue;
            this.hide(w);
        }
    }

    protected abstract boolean isWindowVisible(@Nonnull W var1);

    @Override
    public int countVisibleWindows() {
        int n = 0;
        for (W w : this.windows.values()) {
            if (!this.isWindowVisible(w)) continue;
            ++n;
        }
        return n;
    }

    @Override
    public boolean isAutoShutdown() {
        return this.application.getConfiguration().getAsBoolean("application.autoShutdown", true);
    }

    protected void event(@Nonnull ApplicationEvent applicationEvent, @Nonnull List<?> list) {
        this.event(applicationEvent.getName(), list);
    }

    protected void event(@Nonnull String string, @Nonnull List<?> list) {
        block2: {
            try {
                EventRouter eventRouter = this.getApplication().getEventRouter();
                eventRouter.publishEvent(string, list);
            }
            catch (InstanceNotFoundException instanceNotFoundException) {
                if (this.getApplication().getPhase() == ApplicationPhase.SHUTDOWN) break block2;
                throw instanceNotFoundException;
            }
        }
    }
}

