/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.core.view;

import griffon.core.CallableWithArgs;
import griffon.core.GriffonApplication;
import griffon.core.RunnableWithArgs;
import griffon.core.view.WindowDisplayHandler;
import griffon.exceptions.InstanceNotFoundException;
import griffon.util.AnnotationUtils;
import griffon.util.ConfigUtils;
import griffon.util.GriffonNameUtils;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurableWindowDisplayHandler<W>
implements WindowDisplayHandler<W> {
    protected static final String ERROR_NAME_BLANK = "Argument 'name' must not be blank";
    protected static final String ERROR_WINDOW_NULL = "Argument 'window' must not be null";
    private static final Logger LOG = LoggerFactory.getLogger(ConfigurableWindowDisplayHandler.class);
    private final GriffonApplication application;
    private final WindowDisplayHandler<W> delegateWindowsDisplayHandler;

    @Inject
    public ConfigurableWindowDisplayHandler(@Nonnull GriffonApplication griffonApplication, @Nonnull @Named(value="defaultWindowDisplayHandler") WindowDisplayHandler<W> windowDisplayHandler) {
        this.application = Objects.requireNonNull(griffonApplication, "Argument 'application' must not be null");
        this.delegateWindowsDisplayHandler = Objects.requireNonNull(windowDisplayHandler, "Argument 'delegateWindowsDisplayHandler' must not be null");
    }

    @Override
    public void show(@Nonnull String string, @Nonnull W w) {
        Object object;
        GriffonNameUtils.requireNonBlank(string, ERROR_NAME_BLANK);
        Objects.requireNonNull(w, ERROR_WINDOW_NULL);
        Map<String, Object> map = this.windowBlock(string);
        if (!map.isEmpty()) {
            object = map.get("show");
            if (this.canBeRun(object)) {
                LOG.trace("Showing {} with show: handler", (Object)string);
                this.run(object, string, w);
                return;
            }
            if (map.get("handler") instanceof WindowDisplayHandler) {
                LOG.trace("Showing {} with handler: handler", (Object)string);
                ((WindowDisplayHandler)map.get("handler")).show(string, w);
                return;
            }
        }
        if (this.handleShowByInjectedHandler(string, w)) {
            return;
        }
        map = this.windowManagerBlock();
        if (!map.isEmpty() && this.canBeRun(object = map.get("defaultShow"))) {
            LOG.trace("Showing {} with defaultShow: handler", (Object)string);
            this.run(object, string, w);
            return;
        }
        LOG.trace("Showing {} with default handler", (Object)string);
        this.fetchDefaultWindowDisplayHandler().show(string, w);
    }

    @Override
    public void hide(@Nonnull String string, @Nonnull W w) {
        Object object;
        GriffonNameUtils.requireNonBlank(string, ERROR_NAME_BLANK);
        Objects.requireNonNull(w, ERROR_WINDOW_NULL);
        Map<String, Object> map = this.windowBlock(string);
        if (!map.isEmpty()) {
            object = map.get("hide");
            if (this.canBeRun(object)) {
                LOG.trace("Hiding {} with hide: handler", (Object)string);
                this.run(object, string, w);
                return;
            }
            if (map.get("handler") instanceof WindowDisplayHandler) {
                LOG.trace("Hiding {} with handler: handler", (Object)string);
                ((WindowDisplayHandler)map.get("handler")).hide(string, w);
                return;
            }
        }
        if (this.handleHideByInjectedHandler(string, w)) {
            return;
        }
        map = this.windowManagerBlock();
        if (!map.isEmpty() && this.canBeRun(object = map.get("defaultHide"))) {
            LOG.trace("Hiding {} with defaultHide: handler", (Object)string);
            this.run(object, string, w);
            return;
        }
        LOG.trace("Hiding {} with default handler", (Object)string);
        this.fetchDefaultWindowDisplayHandler().hide(string, w);
    }

    protected boolean handleShowByInjectedHandler(@Nonnull String string, @Nonnull W w) {
        try {
            WindowDisplayHandler windowDisplayHandler = this.getApplication().getInjector().getInstance(WindowDisplayHandler.class, (Annotation)AnnotationUtils.named(string));
            LOG.trace("Showing {} with injected handler", (Object)string);
            windowDisplayHandler.show(string, w);
            return true;
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            return false;
        }
    }

    protected boolean handleHideByInjectedHandler(@Nonnull String string, @Nonnull W w) {
        try {
            WindowDisplayHandler windowDisplayHandler = this.getApplication().getInjector().getInstance(WindowDisplayHandler.class, (Annotation)AnnotationUtils.named(string));
            LOG.trace("Hiding {} with injected handler", (Object)string);
            windowDisplayHandler.hide(string, w);
            return true;
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            return false;
        }
    }

    public WindowDisplayHandler<W> getDelegateWindowsDisplayHandler() {
        return this.delegateWindowsDisplayHandler;
    }

    protected boolean canBeRun(@Nullable Object object) {
        return object instanceof RunnableWithArgs || object instanceof CallableWithArgs;
    }

    protected void run(@Nonnull Object object, @Nonnull String string, @Nonnull W w) {
        if (object instanceof RunnableWithArgs) {
            ((RunnableWithArgs)object).run(string, w);
        } else if (object instanceof CallableWithArgs) {
            ((CallableWithArgs)object).call(string, w);
        }
    }

    protected Map<String, Object> windowManagerBlock() {
        return this.application.getConfiguration().get("windowManager", Collections.emptyMap());
    }

    protected Map<String, Object> windowBlock(String string) {
        Map<String, Object> map = this.windowManagerBlock();
        return ConfigUtils.getConfigValue(map, string, Collections.emptyMap());
    }

    protected GriffonApplication getApplication() {
        return this.application;
    }

    @Nonnull
    protected WindowDisplayHandler<W> fetchDefaultWindowDisplayHandler() {
        Object object = this.windowManagerBlock().get("defaultHandler");
        return object instanceof WindowDisplayHandler ? (WindowDisplayHandler<W>)object : this.delegateWindowsDisplayHandler;
    }
}

