/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.core.view;

import griffon.core.GriffonApplication;
import griffon.core.view.WindowManager;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;

public final class NoopWindowManager
implements WindowManager<Object> {
    private final GriffonApplication application;

    @Inject
    public NoopWindowManager(@Nonnull GriffonApplication griffonApplication) {
        this.application = Objects.requireNonNull(griffonApplication, "Argument 'application' must not be null");
    }

    @Override
    @Nullable
    public Object findWindow(@Nonnull String string) {
        return null;
    }

    @Override
    @Nullable
    public Object getAt(int n) {
        return null;
    }

    @Override
    @Nullable
    public Object getStartingWindow() {
        return null;
    }

    @Override
    @Nonnull
    public Collection<Object> getWindows() {
        return Collections.emptyList();
    }

    @Override
    @Nonnull
    public Set<String> getWindowNames() {
        return Collections.emptySet();
    }

    @Override
    @Nullable
    public String findWindowName(@Nonnull Object object) {
        return null;
    }

    @Override
    public int indexOf(@Nonnull Object object) {
        return -1;
    }

    @Override
    public void attach(@Nonnull String string, @Nonnull Object object) {
    }

    @Override
    public void detach(@Nonnull String string) {
    }

    @Override
    public void show(@Nonnull Object object) {
    }

    @Override
    public void show(@Nonnull String string) {
    }

    @Override
    public void hide(@Nonnull Object object) {
    }

    @Override
    public void hide(@Nonnull String string) {
    }

    @Override
    public boolean canShutdown(@Nonnull GriffonApplication griffonApplication) {
        return true;
    }

    @Override
    public void onShutdown(@Nonnull GriffonApplication griffonApplication) {
    }

    @Override
    public int countVisibleWindows() {
        return 0;
    }

    @Override
    public boolean isAutoShutdown() {
        return this.application.getConfiguration().getAsBoolean("application.autoShutdown", true);
    }
}

