/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.util;

import griffon.core.resources.ResourceHandler;
import griffon.util.CompositeResourceBundle;
import griffon.util.CompositeResourceBundleBuilder;
import griffon.util.GriffonNameUtils;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;

public abstract class AbstractCompositeResourceBundleBuilder
implements CompositeResourceBundleBuilder {
    protected static final String ERROR_FILENAME_BLANK = "Argument 'fileName' must not be blank";
    protected static final String ERROR_SUFFIX_BLANK = "Argument 'suffix' must not be blank";
    protected static final String ERROR_RESOURCE_HANDLER_NULL = "Argument 'resourceHandler' must not be null";
    protected static final String ERROR_BASENAME_BLANK = "Argument 'basename' must not be blank";
    protected static final String ERROR_LOCALE_NULL = "Argument 'locale' must not be null";
    protected final ResourceHandler resourceHandler;

    @Inject
    public AbstractCompositeResourceBundleBuilder(@Nonnull ResourceHandler resourceHandler) {
        this.resourceHandler = Objects.requireNonNull(resourceHandler, ERROR_RESOURCE_HANDLER_NULL);
    }

    @Override
    @Nonnull
    public ResourceBundle create(@Nonnull String string) {
        return this.create(string, Locale.getDefault());
    }

    @Override
    @Nonnull
    public ResourceBundle create(@Nonnull String string, @Nonnull Locale locale) {
        GriffonNameUtils.requireNonBlank(string, ERROR_BASENAME_BLANK);
        Objects.requireNonNull(locale, ERROR_LOCALE_NULL);
        String[] stringArray = new String[]{locale.getLanguage() + "_" + locale.getCountry() + "_" + locale.getVariant(), locale.getLanguage() + "_" + locale.getCountry(), locale.getLanguage()};
        string = string.replace('.', '/');
        ArrayList<ResourceBundle> arrayList = new ArrayList<ResourceBundle>();
        for (String string2 : stringArray) {
            if (string2.endsWith("_")) continue;
            arrayList.addAll(this.loadBundlesFor(string + "_" + string2));
        }
        arrayList.addAll(this.loadBundlesFor(string));
        if (arrayList.size() == 0) {
            throw new IllegalArgumentException("There are no ResourceBundle resources matching " + string);
        }
        return new CompositeResourceBundle(arrayList);
    }

    @Nonnull
    protected ResourceHandler getResourceHandler() {
        return this.resourceHandler;
    }

    @Nullable
    protected URL getResourceAsURL(@Nonnull String string, @Nonnull String string2) {
        GriffonNameUtils.requireNonBlank(string, ERROR_FILENAME_BLANK);
        GriffonNameUtils.requireNonBlank(string2, ERROR_SUFFIX_BLANK);
        return this.resourceHandler.getResourceAsURL(string + string2);
    }

    @Nullable
    protected List<URL> getResources(@Nonnull String string, @Nonnull String string2) {
        GriffonNameUtils.requireNonBlank(string, ERROR_FILENAME_BLANK);
        GriffonNameUtils.requireNonBlank(string2, ERROR_SUFFIX_BLANK);
        return this.resourceHandler.getResources(string + string2);
    }

    @Nonnull
    protected abstract Collection<ResourceBundle> loadBundlesFor(@Nonnull String var1);
}

