/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.util;

import griffon.core.resources.ResourceHandler;
import griffon.util.GriffonNameUtils;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.codehaus.griffon.runtime.util.AbstractCompositeResourceBundleBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCompositeResourceBundleBuilder
extends AbstractCompositeResourceBundleBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultCompositeResourceBundleBuilder.class);
    protected static final String PROPERTIES_SUFFIX = ".properties";
    protected static final String CLASS_SUFFIX = ".class";

    @Inject
    public DefaultCompositeResourceBundleBuilder(@Nonnull ResourceHandler resourceHandler) {
        super(resourceHandler);
    }

    @Override
    @Nonnull
    protected Collection<ResourceBundle> loadBundlesFor(@Nonnull String string) {
        GriffonNameUtils.requireNonBlank(string, "Argument 'fileName' must not be blank");
        ArrayList<ResourceBundle> arrayList = new ArrayList<ResourceBundle>();
        arrayList.addAll(this.loadBundleFromClass(string));
        arrayList.addAll(this.loadBundleFromProperties(string));
        return arrayList;
    }

    @Nonnull
    protected Collection<ResourceBundle> loadBundleFromProperties(@Nonnull String string) {
        GriffonNameUtils.requireNonBlank(string, "Argument 'fileName' must not be blank");
        ArrayList<ResourceBundle> arrayList = new ArrayList<ResourceBundle>();
        List<URL> list = this.getResources(string, PROPERTIES_SUFFIX);
        if (list != null) {
            for (URL uRL : list) {
                if (null == uRL) continue;
                try {
                    arrayList.add(new PropertyResourceBundle(uRL.openStream()));
                }
                catch (IOException iOException) {}
            }
        }
        return arrayList;
    }

    @Nonnull
    protected Collection<ResourceBundle> loadBundleFromClass(@Nonnull String string) {
        ArrayList<ResourceBundle> arrayList = new ArrayList<ResourceBundle>();
        URL uRL = this.getResourceAsURL(string, CLASS_SUFFIX);
        if (null != uRL) {
            String string2 = uRL.toString();
            String string3 = string.replace('/', '.');
            try {
                Class<?> clazz = this.loadClass(string3);
                if (ResourceBundle.class.isAssignableFrom(clazz)) {
                    arrayList.add(this.newInstance(clazz));
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (Exception exception) {
                LOG.warn("An error occurred while loading resource bundle " + string + " from " + string2, (Throwable)exception);
            }
        }
        return arrayList;
    }

    protected Class<?> loadClass(String string) throws ClassNotFoundException {
        return this.getResourceHandler().classloader().loadClass(string);
    }

    protected ResourceBundle newInstance(Class<?> clazz) throws IllegalAccessException, InstantiationException {
        return (ResourceBundle)clazz.newInstance();
    }
}

