/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Coord;
import cds.aladin.Obj;
import cds.aladin.Plan;
import cds.aladin.PlanCatalog;
import cds.aladin.PlanFilter;
import cds.aladin.Projection;
import cds.aladin.Source;
import cds.aladin.UCDFilter;
import cds.aladin.ViewSimple;
import cds.astro.Unit;
import cds.image.EPSGraphics;
import cds.tools.Util;
import cds.tools.parser.Parser;
import cds.tools.parser.ParserException;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.text.ParseException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class Action {
    boolean badSyntax = false;
    static final String[] COLORNAME = new String[]{"black", "blue", "cyan", "darkGray", "gray", "green", "lightGray", "magenta", "orange", "pink", "red", "white", "yellow"};
    static final Color[] MYCOLORS = new Color[]{Color.black, Color.blue, Color.cyan, Color.darkGray, Color.gray, Color.green, Color.lightGray, Color.magenta, Color.orange, Color.pink, Color.red, Color.white, Color.yellow};
    protected static final String DRAWOBJECT = "drawobject";
    protected static final String DRAWSTRING = "drawstring";
    protected static final String HIDE = "hide";
    protected static final String SIZE = "circle";
    protected static final String FILLSIZE = "fillcircle";
    protected static final String FIXEDCIRCLE = "fixedcircle";
    protected static final String ELLIPSE = "ellipse";
    protected static final String FILLELLIPSE = "fillellipse";
    protected static final String RECTANGLE = "rectangle";
    protected static final String PM = "pm";
    protected static final String LINE = "line";
    protected static final String RGB = "rgb";
    protected static final String RAINBOW = "rainbow";
    protected static final String SATURATION = "saturation";
    protected static final String OVAL = "oval";
    protected static final String CARRE = "square";
    protected static final String CROIX = "cross";
    protected static final String PLUS = "plus";
    protected static final String LOSANGE = "rhomb";
    protected static final String TRIANGLE = "triangle";
    protected static final String POINT = "dot";
    protected static final String DOT = "microdot";
    protected static final String[] NOPARAMSHAPE = new String[]{"oval", "square", "cross", "plus", "rhomb", "triangle", "dot", "microdot"};
    protected static final String DRAW = "draw";
    protected static final String COLOR = "color=";
    protected static final String SHAPE = "shape=";
    Parser majAxisParser;
    Parser minAxisParser;
    Parser posAngleParser;
    Parser pmDecParser;
    Parser pmRAParser;
    Color color = null;
    Parser sizeParser;
    private int maxRadius = 30;
    private int minRadius = 3;
    Parser redParser;
    Parser greenParser;
    Parser blueParser;
    Parser rainbowParser;
    Parser saturationParser;
    Parser lineRa1Parser;
    Parser lineDec1Parser;
    Parser lineRa2Parser;
    Parser lineDec2Parser;
    boolean colorIsVariable = false;
    boolean userDefinedMinMax = false;
    boolean rainbowColorIsVariable = false;
    boolean saturationColorIsVariable = false;
    boolean mustComputeMinMax = true;
    boolean mustComputeRGBMinMax = true;
    boolean mustComputeRainbowMinMax = true;
    boolean userDefinedRainbowMinMax = false;
    boolean mustComputeSaturationMinMax = true;
    boolean userDefinedSaturationMinMax = false;
    double minValue;
    double maxValue;
    double redMinValue;
    double redMaxValue;
    double blueMinValue;
    double blueMaxValue;
    double greenMinValue;
    double greenMaxValue;
    double rainbowMinValue;
    double rainbowMaxValue;
    double saturationMinValue;
    double saturationMaxValue;
    private String shape = "draw";
    private String function = "drawobject";
    String textToDisp;
    Parser parserToDisp = null;
    int wTexte;
    int hTexte;
    private static Font FONT = Aladin.SBOLD;
    private static int FONT_SIZE = Aladin.SSIZE;
    Aladin a;
    PlanFilter pf;
    String ERR1;
    String ERR2;
    String ERR3;
    String ERR4;
    String ERR5;
    String ERR6;
    String ERR7;
    String ERR8;
    String ERR9;
    String ERR10;
    String ERR11;
    String ERR12;
    String ERR13;
    String ERR14;
    String ERR15;
    String ERR16;
    String ERR17;
    String ERR19;
    String ERR20;
    String ERR21;
    String ERR22;
    String ERR23;
    String ERR24;

    protected void createChaine() {
        this.ERR1 = Aladin.chaine.getString("ACERR1");
        this.ERR2 = Aladin.chaine.getString("ACERR2");
        this.ERR3 = Aladin.chaine.getString("ACERR3");
        this.ERR4 = Aladin.chaine.getString("ACERR4");
        this.ERR5 = Aladin.chaine.getString("ACERR5");
        this.ERR6 = Aladin.chaine.getString("ACERR6");
        this.ERR7 = Aladin.chaine.getString("ACERR7");
        this.ERR8 = Aladin.chaine.getString("ACERR8");
        this.ERR9 = Aladin.chaine.getString("ACERR9");
        this.ERR10 = Aladin.chaine.getString("ACERR10");
        this.ERR11 = Aladin.chaine.getString("ACERR11");
        this.ERR12 = Aladin.chaine.getString("ACERR12");
        this.ERR13 = Aladin.chaine.getString("ACERR13");
        this.ERR14 = Aladin.chaine.getString("ACERR14");
        this.ERR15 = Aladin.chaine.getString("ACERR15");
        this.ERR16 = Aladin.chaine.getString("ACERR16");
        this.ERR17 = Aladin.chaine.getString("ACERR17");
        this.ERR19 = Aladin.chaine.getString("ACERR19");
        this.ERR20 = Aladin.chaine.getString("ACERR20");
        this.ERR21 = Aladin.chaine.getString("ACERR21");
        this.ERR22 = Aladin.chaine.getString("ACERR22");
        this.ERR23 = Aladin.chaine.getString("ACERR23");
        this.ERR24 = Aladin.chaine.getString("ACERR24");
    }

    Action(String string, Aladin aladin, PlanFilter planFilter) {
        this.a = aladin;
        this.createChaine();
        this.pf = planFilter;
        this.decodeAction(string);
    }

    protected void action(Source source, Graphics graphics, ViewSimple viewSimple, Point point, int n, int n2, int n3, int n4) {
        this.action(source, graphics, viewSimple, point, n, n2, true, n3, n4);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void action(Source source, Graphics graphics, ViewSimple viewSimple, Point point, int n, int n2, boolean bl, int n3, int n4) {
        String string;
        Color color;
        block34: {
            int n5;
            int n6;
            block35: {
                block33: {
                    if (bl) {
                        this.setColor(source);
                    }
                    if ((color = this.color) == null) {
                        color = source.plan.c;
                    }
                    if (this.function.equals(HIDE)) {
                        return;
                    }
                    if (this.function.equals(DRAWOBJECT)) {
                        int n7;
                        if (this.shape.equals(DRAW)) {
                            source.doDraw(graphics, point, color);
                            return;
                        }
                        if (this.shape.equals(OVAL)) {
                            graphics.setColor(color);
                            source.drawOval(graphics, point);
                            return;
                        }
                        if (this.shape.equals(CARRE)) {
                            graphics.setColor(color);
                            source.drawCarre(graphics, point);
                            return;
                        }
                        if (this.shape.equals(CROIX)) {
                            graphics.setColor(color);
                            source.drawCroix(graphics, point);
                            return;
                        }
                        if (this.shape.equals(PLUS)) {
                            graphics.setColor(color);
                            source.drawPlus(graphics, point);
                            return;
                        }
                        if (this.shape.equals(LOSANGE)) {
                            graphics.setColor(color);
                            source.drawLosange(graphics, point);
                            return;
                        }
                        if (this.shape.equals(TRIANGLE)) {
                            graphics.setColor(color);
                            source.drawTriangle(graphics, point);
                            return;
                        }
                        if (this.shape.equals(POINT)) {
                            graphics.setColor(color);
                            source.drawPoint(graphics, point);
                            return;
                        }
                        if (this.shape.equals(DOT)) {
                            graphics.setColor(color);
                            source.drawPoint(graphics, point);
                            return;
                        }
                        if (this.shape.equals(ELLIPSE) || this.shape.equals(FILLELLIPSE)) {
                            this.drawEllipse(source, graphics, viewSimple, point, color, n, n2, n3, n4, this.shape.equals(FILLELLIPSE));
                            return;
                        }
                        if (this.shape.equals(RECTANGLE)) {
                            this.drawRectangle(source, graphics, viewSimple, point, color, n, n2, n3, n4);
                            return;
                        }
                        if (this.shape.equals(PM)) {
                            this.drawPM(source, graphics, viewSimple, point, color, n, n2, n3, n4);
                            return;
                        }
                        if (this.shape.equals(LINE)) {
                            this.drawLine(source, graphics, viewSimple, point, color, n, n2, n3, n4);
                            return;
                        }
                        if (!(this.shape.equals(SIZE) || this.shape.equals(FILLSIZE) || this.shape.equals(FIXEDCIRCLE))) {
                            source.doDraw(graphics, point, null);
                            return;
                        }
                        if (source.values[n][n2][0] == -1.0) {
                            return;
                        }
                        graphics.setColor(color);
                        if (this.shape.equals(FIXEDCIRCLE)) {
                            n7 = (int)source.values[n][n2][0];
                        } else {
                            double d = viewSimple.getProj().r / (60.0 * viewSimple.getProj().rm) * viewSimple.getZoom();
                            n7 = (int)(source.values[n][n2][0] * d * (double)source.plan.getScalingFactor());
                            if (n7 < 3) {
                                source.drawPoint(graphics, point);
                                return;
                            }
                        }
                        if (this.shape.equals(SIZE)) {
                            graphics.drawOval(point.x - n7 / 2, point.y - n7 / 2, n7, n7);
                            return;
                        }
                        if (this.shape.equals(FILLSIZE) && Aladin.ENABLE_FOOTPRINT_OPACITY && graphics instanceof Graphics2D) {
                            Graphics2D graphics2D = (Graphics2D)graphics;
                            Composite composite = graphics2D.getComposite();
                            float f = Aladin.DEFAULT_FOOTPRINT_OPACITY_LEVEL * source.plan.getOpacityLevel();
                            Composite composite2 = Util.getImageComposite(f);
                            graphics2D.setComposite(composite2);
                            graphics2D.fillOval(point.x - n7 / 2, point.y - n7 / 2, n7, n7);
                            graphics2D.setComposite(composite);
                            return;
                        }
                        graphics.fillOval(point.x - n7 / 2, point.y - n7 / 2, n7, n7);
                        return;
                    }
                    if (!this.function.equals(DRAWSTRING)) return;
                    if (this.textToDisp == null || !this.textToDisp.startsWith("[") && !this.textToDisp.startsWith("{")) break block33;
                    if (this.textToDisp.startsWith("[")) {
                        n6 = source.findUCD(this.textToDisp.substring(1, this.textToDisp.length() - 1).toUpperCase());
                        if (n6 < 0) {
                            return;
                        }
                        string = source.getValue(n6);
                    } else {
                        n6 = source.findColumn(this.textToDisp.substring(1, this.textToDisp.length() - 1));
                        if (n6 < 0) {
                            return;
                        }
                        string = source.getValue(n6);
                    }
                    if (string == null) {
                        string = "";
                    }
                    break block34;
                }
                if (this.parserToDisp == null) break block35;
                if (!Action.setAllVariables(this.parserToDisp, source, false)) {
                    return;
                }
                string = new Double(this.parserToDisp.eval()).toString();
                n6 = string.indexOf(".");
                if (n6 >= 0) {
                    int n8;
                    n5 = string.indexOf("E");
                    int n9 = n8 = string.length() > n6 + 5 ? n6 + 5 : string.length();
                    if (n5 >= 0) {
                        n8 = n5 > n8 ? n8 : n5;
                    }
                    String string2 = new String(string);
                    string = string.substring(0, n8);
                    if (n5 >= 0) {
                        string = string + string2.substring(n5);
                    }
                }
                break block34;
            }
            n6 = this.textToDisp.indexOf("\"");
            string = n6 >= 0 && (n5 = this.textToDisp.lastIndexOf("\"")) >= 0 && n6 != n5 ? this.textToDisp.substring(n6 + 1, n5) : this.textToDisp;
        }
        float f = source.plan.getScalingFactor();
        Font font = f == 1.0f ? FONT : FONT.deriveFont((float)FONT.getSize() * (2.0f * f / 3.0f));
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
        this.wTexte = fontMetrics.stringWidth(string) / 2;
        this.hTexte = fontMetrics.getHeight() / 2;
        graphics.setFont(font);
        graphics.setColor(color);
        graphics.drawString(string, point.x - this.wTexte, point.y + this.hTexte - 8);
    }

    private void decodeAction(String string) {
        int n;
        String string2 = new String(string);
        string = UCDFilter.skipSpaces(string);
        while (string.charAt(0) == '\n') {
            string = string.substring(1);
        }
        int n2 = string.indexOf("(");
        String string3 = "";
        if (n2 < 0) {
            n2 = string.length();
        } else {
            int n3 = this.getClosingParenthesis(string, n2 + 1);
            if (n3 < 0) {
                this.badSyntax = true;
                Aladin.warning(this.ERR1, 1);
                return;
            }
            string3 = string.substring(n2 + 1, n3);
        }
        String string4 = string.substring(0, n2);
        if (string4.equals(DRAWOBJECT)) {
            this.function = DRAWOBJECT;
            this.decodeDrawObject(string3);
            return;
        }
        if (string4.equals(DRAWSTRING)) {
            this.function = DRAWSTRING;
            this.decodeDrawString(string3);
            return;
        }
        if (string4.equals(HIDE)) {
            this.function = HIDE;
            return;
        }
        int n4 = string2.indexOf(DRAW);
        if (n4 >= 0) {
            string2 = string2.substring(n4 + DRAW.length());
        }
        if ((n = this.processFunction(string2 = string2.trim())) >= 0 && n < string2.length()) {
            this.processFunction(string2.substring(n).trim());
        }
    }

    private void setColor(Source source) {
        if (this.colorIsVariable) {
            this.color = this.computeColor(source);
        } else if (this.rainbowColorIsVariable) {
            this.color = this.computeRainbowColor(source);
        } else if (this.saturationColorIsVariable) {
            this.color = this.computeSaturationColor(source);
        }
    }

    private int processFunction(String string) {
        String string2;
        int n;
        int n2;
        if (string.length() == 0) {
            return -1;
        }
        if (string.startsWith("\"")) {
            int n3 = string.indexOf("\"", 1);
            if (n3 < 0) {
                this.badSyntax = true;
                Aladin.warning(this.ERR2, 1);
                return -1;
            }
            this.function = DRAWSTRING;
            this.textToDisp = string.substring(1, n3);
            return n3 + 1;
        }
        if (string.startsWith("[") || string.startsWith("{")) {
            int n4;
            int n5 = n4 = string.startsWith("[") ? string.indexOf("]") : string.indexOf("}");
            if (n4 < 0) {
                this.badSyntax = true;
                Aladin.warning(this.ERR3, 1);
                return -1;
            }
            this.function = DRAWSTRING;
            this.textToDisp = string.substring(0, n4 + 1);
            return n4 + 1;
        }
        int n6 = string.indexOf(" ");
        int n7 = string.indexOf("(");
        if (n6 >= 0 && n7 >= 0) {
            n2 = Math.min(string.indexOf(" "), string.indexOf("("));
        }
        if ((n2 = n6 < 0 ? n7 : n6) < 0) {
            n2 = string.length();
        }
        if ((n = Action.findColorName(string2 = string.substring(0, n2))) >= 0) {
            this.color = MYCOLORS[n];
            return string2.length();
        }
        if (string.startsWith(RGB)) {
            n2 = string.indexOf("(");
            if (n2 < 0) {
                this.badSyntax = true;
                Aladin.warning(this.ERR4, 1);
                return -1;
            }
            int n8 = this.getClosingParenthesis(string, n2 + 1);
            if (n8 < 0) {
                this.badSyntax = true;
                Aladin.warning(this.ERR5, 1);
                return -1;
            }
            this.decodeRGB(string.substring(Math.max(0, n2), n8 + 1));
            return n8 + 1;
        }
        if (string.startsWith(RAINBOW)) {
            n2 = string.indexOf("(");
            if (n2 < 0) {
                this.badSyntax = true;
                Aladin.warning(this.ERR6, 1);
                return -1;
            }
            int n9 = this.getClosingParenthesis(string, n2 + 1);
            if (n9 < 0) {
                this.badSyntax = true;
                Aladin.warning(this.ERR7, 1);
                return -1;
            }
            this.decodeRainbow(string.substring(Math.max(0, n2), n9 + 1));
            return n9 + 1;
        }
        if (string.startsWith(SATURATION)) {
            n2 = string.indexOf("(");
            if (n2 < 0) {
                this.badSyntax = true;
                Aladin.warning(this.ERR6, 1);
                return -1;
            }
            int n10 = this.getClosingParenthesis(string, n2 + 1);
            if (n10 < 0) {
                this.badSyntax = true;
                Aladin.warning(this.ERR7, 1);
                return -1;
            }
            this.decodeSaturation(string.substring(Math.max(0, n2), n10 + 1));
            return n10 + 1;
        }
        if (string2.startsWith("#")) {
            this.color = Action.decodeColorString(string.substring(0, n2));
            return string2.length();
        }
        if (string2.equals(OVAL) || string2.equals(CARRE) || string2.equals(CROIX) || string2.equals(PLUS) || string2.equals(LOSANGE) || string2.equals(TRIANGLE) || string2.equals(POINT) || string2.equals(DOT)) {
            this.shape = string2;
            this.function = DRAWOBJECT;
            return string2.length();
        }
        if (string.startsWith(SIZE) || string.startsWith(FILLSIZE) || string.startsWith(FIXEDCIRCLE) || string.startsWith(ELLIPSE) || string.startsWith(FILLELLIPSE) || string.startsWith(PM) || string.startsWith(RECTANGLE) || string.startsWith(LINE)) {
            this.function = DRAWOBJECT;
            n2 = string.indexOf("(");
            if (n2 < 0) {
                this.badSyntax = true;
                Aladin.warning(this.ERR8, 1);
                return -1;
            }
            int n11 = this.getClosingParenthesis(string, n2 + 1);
            if (n11 < 0) {
                this.badSyntax = true;
                Aladin.warning(this.ERR9, 1);
                return -1;
            }
            this.decodeShape(SHAPE + string.substring(0, n11 + 1));
            return n11 + 1;
        }
        try {
            this.parserToDisp = UCDFilter.createParser(string, this.a);
            this.function = DRAWSTRING;
            return -1;
        }
        catch (ParserException parserException) {
            this.badSyntax = true;
            Aladin.warning(this.ERR10 + "[" + string + "]", 1);
            return -1;
        }
    }

    protected static Color getColor(String string) {
        int n = Action.findColorName(string);
        if (n >= 0) {
            return MYCOLORS[n];
        }
        if (string.startsWith(RGB)) {
            return Action.decodeStaticRGB(string);
        }
        return Action.decodeColorString(string);
    }

    private void processColor(String string) {
        int n = Action.findColorName(string);
        if (n >= 0) {
            this.color = MYCOLORS[n];
            return;
        }
        if (string.startsWith(RGB)) {
            this.decodeRGB(string);
            return;
        }
        if (string.startsWith(RAINBOW)) {
            this.decodeRainbow(string);
            return;
        }
        if (string.startsWith(SATURATION)) {
            this.decodeSaturation(string);
            return;
        }
        this.color = Action.decodeColorString(string);
    }

    private void decodeSaturation(String string) {
        String string2 = string.substring(string.indexOf("(") + 1, Math.max(string.lastIndexOf(")"), 0));
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        if (stringTokenizer.countTokens() != 1 && stringTokenizer.countTokens() != 3) {
            this.badSyntax = true;
            Aladin.warning(this.ERR11 + " " + SATURATION + " rainbow(exp[,minValue,maxValue])", 1);
            return;
        }
        try {
            this.saturationParser = UCDFilter.createParser(stringTokenizer.nextToken(), this.a);
        }
        catch (ParserException parserException) {
            Aladin.warning(this.ERR12, 1);
            this.badSyntax = true;
            return;
        }
        if (this.saturationParser.isConstant()) {
            this.color = Color.getHSBColor(this.getHue((float)this.saturationParser.eval()), 1.0f, 1.0f);
        } else {
            this.saturationColorIsVariable = true;
        }
        if (stringTokenizer.hasMoreTokens()) {
            try {
                this.saturationMinValue = Double.valueOf(stringTokenizer.nextToken());
                this.saturationMaxValue = Double.valueOf(stringTokenizer.nextToken());
            }
            catch (NumberFormatException numberFormatException) {
                Aladin.warning(this.ERR13, 1);
                this.badSyntax = true;
                return;
            }
            this.mustComputeSaturationMinMax = false;
            this.userDefinedSaturationMinMax = true;
        }
    }

    private void decodeRainbow(String string) {
        String string2 = string.substring(string.indexOf("(") + 1, Math.max(string.lastIndexOf(")"), 0));
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        if (stringTokenizer.countTokens() != 1 && stringTokenizer.countTokens() != 3) {
            this.badSyntax = true;
            Aladin.warning(this.ERR11 + " " + RAINBOW + " rainbow(exp[,minValue,maxValue])", 1);
            return;
        }
        try {
            this.rainbowParser = UCDFilter.createParser(stringTokenizer.nextToken(), this.a);
        }
        catch (ParserException parserException) {
            Aladin.warning(this.ERR12, 1);
            this.badSyntax = true;
            return;
        }
        if (this.rainbowParser.isConstant()) {
            this.color = Color.getHSBColor(this.getHue((float)this.rainbowParser.eval()), 1.0f, 1.0f);
        } else {
            this.rainbowColorIsVariable = true;
        }
        if (stringTokenizer.hasMoreTokens()) {
            try {
                this.rainbowMinValue = Double.valueOf(stringTokenizer.nextToken());
                this.rainbowMaxValue = Double.valueOf(stringTokenizer.nextToken());
            }
            catch (NumberFormatException numberFormatException) {
                Aladin.warning(this.ERR13, 1);
                this.badSyntax = true;
                return;
            }
            this.mustComputeRainbowMinMax = false;
            this.userDefinedRainbowMinMax = true;
        }
    }

    protected static Color decodeStaticRGB(String string) {
        try {
            int n = string.indexOf(40) + 1;
            int n2 = string.indexOf(44, n);
            int n3 = Integer.parseInt(string.substring(n, n2));
            n = n2 + 1;
            n2 = string.indexOf(44, n);
            int n4 = Integer.parseInt(string.substring(n, n2));
            n = n2 + 1;
            n2 = string.indexOf(41, n);
            int n5 = Integer.parseInt(string.substring(n, n2));
            return new Color(n3, n4, n5);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private void decodeRGB(String string) {
        String string2 = string.substring(string.indexOf("(") + 1, Math.max(string.lastIndexOf(")"), 0));
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        if (stringTokenizer.countTokens() != 3) {
            this.badSyntax = true;
            Aladin.warning(this.ERR14, 1);
            return;
        }
        try {
            this.redParser = UCDFilter.createParser(stringTokenizer.nextToken(), this.a);
            this.greenParser = UCDFilter.createParser(stringTokenizer.nextToken(), this.a);
            this.blueParser = UCDFilter.createParser(stringTokenizer.nextToken(), this.a);
        }
        catch (ParserException parserException) {
            Aladin.warning(this.ERR15, 1);
            this.badSyntax = true;
            return;
        }
        if (this.redParser.isConstant() && this.greenParser.isConstant() && this.blueParser.isConstant()) {
            this.color = new Color(Math.max(Math.min((float)this.redParser.eval() / 255.0f, 1.0f), 0.0f), Math.max(Math.min((float)this.greenParser.eval() / 255.0f, 1.0f), 0.0f), Math.max(Math.min((float)this.blueParser.eval() / 255.0f, 1.0f), 0.0f));
        } else {
            this.colorIsVariable = true;
        }
    }

    private static Color decodeColorString(String string) {
        Color color;
        try {
            color = Color.decode(string);
        }
        catch (NumberFormatException numberFormatException) {
            color = null;
        }
        return color;
    }

    protected static int findColorName(String string) {
        for (int i = 0; i < COLORNAME.length; ++i) {
            if (!string.equalsIgnoreCase(COLORNAME[i])) continue;
            return i;
        }
        return -1;
    }

    protected static String findColorName(Color color) {
        for (int i = 0; i < MYCOLORS.length; ++i) {
            if (!color.equals(MYCOLORS[i])) continue;
            return COLORNAME[i];
        }
        return "rgb(" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + ")";
    }

    private Color computeSaturationColor(Source source) {
        if (this.mustComputeSaturationMinMax) {
            this.computeSaturationMinMax();
            this.mustComputeSaturationMinMax = false;
        }
        if (!Action.setAllVariables(this.saturationParser, source, false)) {
            return null;
        }
        double d = this.saturationParser.eval();
        if (d == 99.9) {
            return null;
        }
        Color color = source.plan.c;
        float[] fArray = new float[3];
        Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), fArray);
        float f = fArray[0];
        float f2 = fArray[2];
        float f3 = (float)((d - this.saturationMinValue) / (this.saturationMaxValue - this.saturationMinValue));
        return Color.getHSBColor(f, f3, f2);
    }

    private Color computeRainbowColor(Source source) {
        if (this.mustComputeRainbowMinMax) {
            this.computeRainbowMinMax();
            this.mustComputeRainbowMinMax = false;
        }
        if (!Action.setAllVariables(this.rainbowParser, source, false)) {
            return null;
        }
        double d = this.rainbowParser.eval();
        if (d == 99.9) {
            return null;
        }
        float f = (float)((d - this.rainbowMinValue) / (this.rainbowMaxValue - this.rainbowMinValue));
        f = this.getHue(f);
        return Color.getHSBColor(f, 1.0f, 1.0f);
    }

    private float getHue(float f) {
        float f2 = 1.0f - f;
        if ((f2 *= 0.78f) > 0.78f) {
            f2 = 0.78f;
        }
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        return f2;
    }

    private Color computeColor(Source source) {
        if (this.mustComputeRGBMinMax) {
            this.computeRGBMinMax();
            this.mustComputeRGBMinMax = false;
        }
        if (!Action.setAllVariables(this.redParser, source, false)) {
            return null;
        }
        if (!Action.setAllVariables(this.blueParser, source, false)) {
            return null;
        }
        if (!Action.setAllVariables(this.greenParser, source, false)) {
            return null;
        }
        double d = this.redParser.eval();
        double d2 = this.greenParser.eval();
        double d3 = this.blueParser.eval();
        if (d == 99.9 || d2 == 99.9 || d3 == 99.9) {
            return null;
        }
        float f = this.redParser.isConstant() ? Math.max(Math.min((float)d / 255.0f, 1.0f), 0.0f) : (float)((d - this.redMinValue) / (this.redMaxValue - this.redMinValue));
        float f2 = this.greenParser.isConstant() ? Math.max(Math.min((float)d2 / 255.0f, 1.0f), 0.0f) : (float)((d2 - this.greenMinValue) / (this.greenMaxValue - this.greenMinValue));
        float f3 = this.blueParser.isConstant() ? Math.max(Math.min((float)d3 / 255.0f, 1.0f), 0.0f) : (float)((d3 - this.blueMinValue) / (this.blueMaxValue - this.blueMinValue));
        return new Color(f, f2, f3);
    }

    private void decodeDrawString(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        String string2 = null;
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            if (string2.startsWith(COLOR)) {
                try {
                    while (Action.countNbOcc('(', string2) != Action.countNbOcc(')', string2)) {
                        string2 = string2 + "," + stringTokenizer.nextToken();
                    }
                }
                catch (NoSuchElementException noSuchElementException) {
                    Aladin.warning(this.ERR16, 1);
                    this.badSyntax = true;
                    return;
                }
                this.processColor(string2.substring(COLOR.length()));
                continue;
            }
            this.textToDisp = string2;
        }
    }

    private void decodeDrawObject(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        String string2 = null;
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            if (string2.startsWith(COLOR)) {
                try {
                    while (Action.countNbOcc('(', string2) != Action.countNbOcc(')', string2)) {
                        string2 = string2 + "," + stringTokenizer.nextToken();
                    }
                }
                catch (NoSuchElementException noSuchElementException) {
                    Aladin.warning(this.ERR16, 1);
                    this.badSyntax = true;
                    return;
                }
                this.processColor(string2.substring(COLOR.length()));
                continue;
            }
            if (!string2.startsWith(SHAPE)) continue;
            if ((string2.indexOf(SIZE) >= 0 || string2.indexOf(FILLSIZE) >= 0 || string2.indexOf(FIXEDCIRCLE) >= 0 || string2.indexOf(LINE) >= 0 || string2.indexOf(ELLIPSE) >= 0 || string2.indexOf(FILLELLIPSE) >= 0 || string2.indexOf(PM) >= 0 || string2.indexOf(RECTANGLE) >= 0) && string2.indexOf("(") >= 0) {
                try {
                    while (Action.countNbOcc('(', string2) != Action.countNbOcc(')', string2)) {
                        string2 = string2 + "," + stringTokenizer.nextToken();
                    }
                }
                catch (NoSuchElementException noSuchElementException) {
                    Aladin.warning(this.ERR17, 1);
                    this.badSyntax = true;
                    return;
                }
            }
            this.decodeShape(string2);
        }
    }

    private void decodeShape(String string) {
        String string2 = string.substring(string.indexOf("(") + 1, Math.max(string.lastIndexOf(")"), 0));
        if (string2.length() != 0) {
            this.shape = string.substring(SHAPE.length(), string.indexOf("(")).trim();
            if (this.shape.equals(SIZE) || this.shape.equals(FILLSIZE) || this.shape.equals(FIXEDCIRCLE)) {
                StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
                if (stringTokenizer.countTokens() != 1 && stringTokenizer.countTokens() != 3 && stringTokenizer.countTokens() != 5) {
                    this.badSyntax = true;
                    Aladin.warning(this.ERR11 + " " + SIZE + " (exp[,minRadius,maxRadius])", 1);
                    return;
                }
                try {
                    this.sizeParser = UCDFilter.createParser(stringTokenizer.nextToken(), this.a);
                }
                catch (ParserException parserException) {
                    Aladin.warning(this.ERR19, 1);
                    this.badSyntax = true;
                }
                if (stringTokenizer.hasMoreTokens()) {
                    try {
                        this.minRadius = Integer.valueOf(stringTokenizer.nextToken().trim());
                        this.maxRadius = Integer.valueOf(stringTokenizer.nextToken().trim());
                    }
                    catch (NumberFormatException numberFormatException) {
                        Aladin.warning(this.ERR20, 1);
                        this.badSyntax = true;
                        return;
                    }
                }
                if (stringTokenizer.hasMoreTokens()) {
                    try {
                        this.minValue = Integer.valueOf(stringTokenizer.nextToken().trim()).intValue();
                        this.maxValue = Integer.valueOf(stringTokenizer.nextToken().trim()).intValue();
                    }
                    catch (NumberFormatException numberFormatException) {
                        Aladin.warning(this.ERR21, 1);
                        this.badSyntax = true;
                        return;
                    }
                    this.mustComputeMinMax = false;
                    this.userDefinedMinMax = true;
                }
            } else if (this.shape.equals(ELLIPSE) || this.shape.equals(FILLELLIPSE)) {
                this.decodeEllipseParameters(string2);
            } else if (this.shape.equals(RECTANGLE)) {
                this.decodeRectangleParameters(string2);
            } else if (this.shape.equals(PM)) {
                this.decodePMParameters(string2);
            } else if (this.shape.equals(LINE)) {
                this.decodeLineParameters(string2);
            }
        } else {
            this.shape = string.substring(SHAPE.length());
            if (this.shape.equals(LINE) || this.shape.equals(ELLIPSE) || this.shape.equals(FILLELLIPSE) || this.shape.equals(RECTANGLE) || this.shape.equals(SIZE) || this.shape.equals(FILLSIZE) || this.shape.equals(FIXEDCIRCLE) || this.shape.equals(PM)) {
                Aladin.warning(this.ERR22 + " " + this.shape, 1);
                this.badSyntax = true;
            }
        }
    }

    private void decodeLineParameters(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        try {
            string5 = stringTokenizer.nextToken();
            string4 = stringTokenizer.nextToken();
            string3 = stringTokenizer.nextToken();
            string2 = stringTokenizer.nextToken();
        }
        catch (NoSuchElementException noSuchElementException) {
            Aladin.warning("Missing parameter for the line function !", 1);
            this.badSyntax = true;
        }
        this.lineRa1Parser = UCDFilter.createParser(string5, this.a);
        this.lineDec1Parser = UCDFilter.createParser(string4, this.a);
        this.lineRa2Parser = UCDFilter.createParser(string3, this.a);
        this.lineDec2Parser = UCDFilter.createParser(string2, this.a);
    }

    private void decodePMParameters(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        String string2 = "";
        String string3 = "";
        try {
            string2 = stringTokenizer.nextToken();
            string3 = stringTokenizer.nextToken();
        }
        catch (NoSuchElementException noSuchElementException) {
            Aladin.warning(this.ERR23, 1);
            this.badSyntax = true;
        }
        this.pmRAParser = UCDFilter.createParser(string2, this.a);
        this.pmDecParser = UCDFilter.createParser(string3, this.a);
    }

    private void decodeRectangleParameters(String string) {
        this.decodeEllipseParameters(string);
    }

    private void decodeEllipseParameters(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        String string2 = "";
        String string3 = "";
        String string4 = "";
        try {
            string4 = stringTokenizer.nextToken();
            string3 = stringTokenizer.nextToken();
            string2 = stringTokenizer.nextToken();
        }
        catch (NoSuchElementException noSuchElementException) {
            Aladin.warning(this.ERR24, 1);
            this.badSyntax = true;
        }
        this.majAxisParser = UCDFilter.createParser(string4, this.a);
        this.minAxisParser = UCDFilter.createParser(string3, this.a);
        this.posAngleParser = UCDFilter.createParser(string2, this.a);
    }

    private void computeMinMax(Source[] sourceArray) {
        if (this.sizeParser.isConstant()) {
            this.minValue = 0.0;
            this.maxValue = this.sizeParser.eval();
            return;
        }
        this.minValue = Double.POSITIVE_INFINITY;
        this.maxValue = Double.NEGATIVE_INFINITY;
        for (int i = sourceArray.length - 1; i >= 0; --i) {
            double d;
            Source source = sourceArray[i];
            if (Aladin.isSlow && i % 50 == 0) {
                Util.pause(10);
            }
            if (!Action.setAllVariables(this.sizeParser, source, false) || Math.abs(d = this.sizeParser.eval()) == 99.9) continue;
            if (d > this.maxValue) {
                this.maxValue = d;
            }
            if (!(d < this.minValue)) continue;
            this.minValue = d;
        }
    }

    private void computeSaturationMinMax() {
        this.saturationMinValue = Double.POSITIVE_INFINITY;
        this.saturationMaxValue = Double.NEGATIVE_INFINITY;
        Plan plan = null;
        Plan[] planArray = this.pf.getConcernedPlans();
        double d = Double.POSITIVE_INFINITY;
        for (int i = planArray.length - 1; i >= 0; --i) {
            plan = planArray[i];
            if (!plan.isCatalog()) continue;
            Iterator<Obj> iterator = ((PlanCatalog)planArray[i]).iterator();
            int n = 0;
            while (iterator.hasNext()) {
                Obj obj = iterator.next();
                if (obj instanceof Source) {
                    Source source = (Source)obj;
                    if (Aladin.isSlow && n % 50 == 0) {
                        Util.pause(10);
                    }
                    if (source != null && Action.setAllVariables(this.saturationParser, source, false) && Math.abs(d = this.saturationParser.eval()) != 99.9) {
                        if (d > this.saturationMaxValue) {
                            this.saturationMaxValue = d;
                        }
                        if (d < this.saturationMinValue) {
                            this.saturationMinValue = d;
                        }
                    }
                }
                ++n;
            }
        }
        if (d == this.saturationMaxValue) {
            this.saturationMinValue = 0.0;
        }
    }

    private void computeRainbowMinMax() {
        this.rainbowMinValue = Double.POSITIVE_INFINITY;
        this.rainbowMaxValue = Double.NEGATIVE_INFINITY;
        Plan plan = null;
        Plan[] planArray = this.pf.getConcernedPlans();
        double d = Double.POSITIVE_INFINITY;
        for (int i = planArray.length - 1; i >= 0; --i) {
            plan = planArray[i];
            if (!plan.isCatalog()) continue;
            Iterator<Obj> iterator = plan.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                Obj obj = iterator.next();
                if (obj instanceof Source) {
                    Source source = (Source)obj;
                    if (Aladin.isSlow && n % 50 == 0) {
                        Util.pause(10);
                    }
                    if (source != null && Action.setAllVariables(this.rainbowParser, source, false) && Math.abs(d = this.rainbowParser.eval()) != 99.9) {
                        if (d > this.rainbowMaxValue) {
                            this.rainbowMaxValue = d;
                        }
                        if (d < this.rainbowMinValue) {
                            this.rainbowMinValue = d;
                        }
                    }
                }
                ++n;
            }
        }
        if (d == this.rainbowMaxValue) {
            this.rainbowMinValue = 0.0;
        }
    }

    private void computeRGBMinMax() {
        this.blueMinValue = Double.POSITIVE_INFINITY;
        this.greenMinValue = Double.POSITIVE_INFINITY;
        this.redMinValue = Double.POSITIVE_INFINITY;
        this.blueMaxValue = Double.NEGATIVE_INFINITY;
        this.greenMaxValue = Double.NEGATIVE_INFINITY;
        this.redMaxValue = Double.NEGATIVE_INFINITY;
        Plan plan = null;
        Plan[] planArray = this.pf.getConcernedPlans();
        for (int i = planArray.length - 1; i >= 0; --i) {
            plan = planArray[i];
            if (!plan.isCatalog()) continue;
            Iterator<Obj> iterator = ((PlanCatalog)plan).iterator();
            int n = 0;
            while (iterator.hasNext()) {
                Obj obj = iterator.next();
                if (obj instanceof Source) {
                    Source source = (Source)obj;
                    if (Aladin.isSlow && n % 50 == 0) {
                        Util.pause(10);
                    }
                    if (source != null && Action.setAllVariables(this.redParser, source, false) && Action.setAllVariables(this.greenParser, source, false) && Action.setAllVariables(this.blueParser, source, false)) {
                        double d = this.redParser.eval();
                        double d2 = this.greenParser.eval();
                        double d3 = this.blueParser.eval();
                        if (Math.abs(d) != 99.9) {
                            if (d > this.redMaxValue) {
                                this.redMaxValue = d;
                            }
                            if (d < this.redMinValue) {
                                this.redMinValue = d;
                            }
                        }
                        if (Math.abs(d2) != 99.9) {
                            if (d2 > this.greenMaxValue) {
                                this.greenMaxValue = d2;
                            }
                            if (d2 < this.greenMinValue) {
                                this.greenMinValue = d2;
                            }
                        }
                        if (Math.abs(d3) != 99.9) {
                            if (d3 > this.blueMaxValue) {
                                this.blueMaxValue = d3;
                            }
                            if (d3 < this.blueMinValue) {
                                this.blueMinValue = d3;
                            }
                        }
                    }
                }
                ++n;
            }
        }
        if (this.redMinValue == this.redMaxValue) {
            this.redMinValue = 0.0;
        }
        if (this.greenMinValue == this.greenMaxValue) {
            this.greenMinValue = 0.0;
        }
        if (this.blueMinValue == this.blueMaxValue) {
            this.blueMinValue = 0.0;
        }
    }

    private void computePM(Source source, int n, int n2) {
        double d;
        double d2;
        if (!Action.setAllVariables(this.pmRAParser, source, false, true)) {
            return;
        }
        if (!Action.setAllVariables(this.pmDecParser, source, false, true)) {
            return;
        }
        source.values[n][n2][0] = this.pmRAParser.eval();
        source.values[n][n2][1] = this.pmDecParser.eval();
        Unit unit = null;
        Unit unit2 = null;
        try {
            unit = this.pmRAParser.evalUnit();
            unit2 = this.pmDecParser.evalUnit();
        }
        catch (ParseException parseException) {
            return;
        }
        Unit unit3 = null;
        Unit unit4 = null;
        Unit unit5 = null;
        boolean bl = true;
        try {
            unit3 = new Unit("1ms/yr");
            unit3.convertFrom(unit);
        }
        catch (ParseException parseException) {
            bl = false;
        }
        catch (ArithmeticException arithmeticException) {
            bl = false;
        }
        if (bl) {
            d2 = 15.0 * unit3.value * Math.cos(source.dej * Math.PI / 180.0);
        } else {
            bl = true;
            try {
                unit4 = new Unit("1mas/yr");
                unit4.convertFrom(unit);
            }
            catch (ParseException parseException) {
                bl = false;
            }
            catch (ArithmeticException arithmeticException) {
                bl = false;
            }
            if (bl) {
                d2 = unit4.value;
            } else {
                return;
            }
        }
        bl = true;
        try {
            unit5 = new Unit("1mas/yr");
            unit5.convertFrom(unit2);
        }
        catch (ParseException parseException) {
            bl = false;
        }
        catch (ArithmeticException arithmeticException) {
            bl = false;
        }
        if (bl) {
            d = unit5.value;
            if (Double.isNaN(d2) || Double.isNaN(d)) {
                return;
            }
        } else {
            return;
        }
        source.values[n][n2][0] = d2;
        source.values[n][n2][1] = d;
    }

    private void computeLine(Source source, int n, int n2) {
        if (!Action.setAllVariables(this.lineRa1Parser, source, false, true)) {
            return;
        }
        if (!Action.setAllVariables(this.lineDec1Parser, source, false, true)) {
            return;
        }
        if (!Action.setAllVariables(this.lineRa2Parser, source, false, true)) {
            return;
        }
        if (!Action.setAllVariables(this.lineDec2Parser, source, false, true)) {
            return;
        }
        source.values[n][n2][0] = this.lineRa1Parser.eval();
        source.values[n][n2][1] = this.lineDec1Parser.eval();
        source.values[n][n2][2] = this.lineRa2Parser.eval();
        source.values[n][n2][3] = this.lineDec2Parser.eval();
    }

    private void drawPM(Source source, Graphics graphics, ViewSimple viewSimple, Point point, Color color, int n, int n2, int n3, int n4) {
        double d;
        double d2 = 1000.0;
        d2 *= (double)source.plan.getScalingFactor();
        double d3 = source.values[n][n2][0];
        double d4 = source.values[n][n2][1];
        double d5 = (d3 * d3 + d4 * d4) / 100.0;
        if (d5 > 6.0) {
            d5 = 6.0;
        }
        if (d3 == -1.0 && d4 == -1.0) {
            return;
        }
        Plan plan = viewSimple.pref;
        if (plan == null) {
            plan = source.plan;
        }
        Projection projection = viewSimple.getProj();
        Coord coord = new Coord();
        coord.al = source.raj;
        coord.del = source.dej;
        coord = projection.getXY(coord);
        if (Double.isNaN(coord.x)) {
            return;
        }
        double d6 = coord.x;
        double d7 = coord.y;
        coord.al += (d3 *= d2) / 3600000.0 / Math.cos(Math.PI * coord.del / 180.0);
        coord.del += (d4 *= d2) / 3600000.0;
        coord = new Coord(coord.al, coord.del);
        coord = projection.getXY(coord);
        if (Double.isNaN(coord.x)) {
            return;
        }
        Point point2 = viewSimple.getViewCoord(d6, d7);
        Point point3 = viewSimple.getViewCoord(coord.x, coord.y);
        if (point2 == null || point3 == null) {
            return;
        }
        double d8 = Math.sqrt(Math.pow(point2.x - point3.x, 2.0) + Math.pow(point2.y - point3.y, 2.0));
        if (projection.t == 4 || projection.t == 11) {
            Coord coord2 = new Coord(source.raj, source.dej);
            coord2.al -= d3 / 3600000.0 / Math.cos(Math.PI * coord.del / 180.0);
            coord2.del -= d4 / 3600000.0;
            projection.getXY(coord2);
            Point point4 = viewSimple.getViewCoord(coord2.x, coord2.y);
            d = Math.sqrt(Math.pow(point2.x - point4.x, 2.0) + Math.pow(point2.y - point4.y, 2.0));
            if (Math.abs(d - d8) > 50.0) {
                return;
            }
        }
        if ((d5 *= viewSimple.getZoom()) > d8 / 5.0) {
            d5 = d8 / 5.0;
        }
        if (d5 > 17.0) {
            d5 = 17.0;
        } else if (d5 < 3.0) {
            d5 = 4.0;
        }
        double d9 = Math.atan((d7 - coord.y) / (d6 - coord.x));
        if (d6 - coord.x < 0.0) {
            d9 += Math.PI;
        }
        d = d9 + 0.7853981633974483;
        Point point5 = new Point((int)(d5 * Math.cos(d)) + point3.x, (int)(d5 * Math.sin(d)) + point3.y);
        d = d9 - 0.7853981633974483;
        Point point6 = new Point((int)(d5 * Math.cos(d)) + point3.x, (int)(d5 * Math.sin(d)) + point3.y);
        point2.x += n3;
        point3.x += n3;
        point5.x += n3;
        point6.x += n3;
        point2.y += n4;
        point3.y += n4;
        point5.y += n4;
        point6.y += n4;
        graphics.setColor(color);
        graphics.drawLine(point2.x, point2.y, point3.x, point3.y);
        graphics.drawLine(point3.x, point3.y, point5.x, point5.y);
        graphics.drawLine(point3.x, point3.y, point6.x, point6.y);
    }

    private void drawLine(Source source, Graphics graphics, ViewSimple viewSimple, Point point, Color color, int n, int n2, int n3, int n4) {
        double d = source.values[n][n2][0];
        double d2 = source.values[n][n2][1];
        double d3 = source.values[n][n2][2];
        double d4 = source.values[n][n2][3];
        if (d == -1.0 && d2 == -1.0) {
            return;
        }
        Plan plan = viewSimple.pref;
        if (plan == null) {
            plan = source.plan;
        }
        Coord coord = new Coord();
        coord.al = d;
        coord.del = d2;
        coord = viewSimple.getProj().getXY(coord);
        if (Double.isNaN(coord.x)) {
            return;
        }
        Coord coord2 = new Coord();
        coord2.al = d3;
        coord2.del = d4;
        coord2 = viewSimple.getProj().getXY(coord2);
        if (Double.isNaN(coord2.x)) {
            return;
        }
        Point point2 = viewSimple.getViewCoord(coord.x, coord.y);
        Point point3 = viewSimple.getViewCoord(coord2.x, coord2.y);
        if (point2 == null || point3 == null) {
            return;
        }
        graphics.setColor(color);
        point2.x += n3;
        point3.x += n3;
        point2.y += n4;
        point3.y += n4;
        graphics.drawLine(point2.x, point2.y, point3.x, point3.y);
    }

    private void computeRectangle(Source source, int n, int n2) {
        this.computeEllipse(source, n, n2);
    }

    private void computeEllipse(Source source, int n, int n2) {
        Unit unit;
        Unit unit2 = null;
        Unit unit3 = null;
        Unit unit4 = null;
        try {
            unit2 = new Unit("1arcsec");
            unit3 = new Unit("1arcsec");
            unit4 = new Unit("1deg");
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        boolean bl = true;
        if (!Action.setAllVariables(this.majAxisParser, source, false, true)) {
            bl = false;
            if (!Action.setAllVariables(this.majAxisParser, source, false)) {
                return;
            }
        }
        if (!Action.setAllVariables(this.minAxisParser, source, false, true)) {
            bl = false;
            if (!Action.setAllVariables(this.minAxisParser, source, false)) {
                return;
            }
        }
        source.values[n][n2][0] = this.majAxisParser.eval();
        source.values[n][n2][1] = this.minAxisParser.eval();
        boolean bl2 = true;
        if (bl) {
            try {
                unit = this.majAxisParser.evalUnit();
                Unit unit5 = this.minAxisParser.evalUnit();
                unit2.convertFrom(unit);
                unit3.convertFrom(unit5);
                if (unit.toStringInSI().equals("mag") || unit5.toStringInSI().equals("mag") || unit.symbol.equals("") || unit5.symbol.equals("")) {
                    bl2 = false;
                }
            }
            catch (ParseException parseException) {
                bl2 = false;
                System.out.println("ERROR");
            }
            catch (ArithmeticException arithmeticException) {
                bl2 = false;
            }
            if (Double.isNaN(unit2.value) || Double.isNaN(unit3.value)) {
                bl2 = false;
            }
            if (bl2) {
                source.values[n][n2][0] = unit2.value;
                source.values[n][n2][1] = unit3.value;
            }
        }
        bl = true;
        if (!Action.setAllVariables(this.posAngleParser, source, false, true)) {
            bl = false;
            if (!Action.setAllVariables(this.posAngleParser, source, false)) {
                return;
            }
        }
        source.values[n][n2][2] = this.posAngleParser.eval();
        bl2 = true;
        if (bl) {
            try {
                unit = this.posAngleParser.evalUnit();
                unit4.convertFrom(unit);
                if (unit.toStringInSI().equals("mag") || unit.symbol.equals("")) {
                    bl2 = false;
                }
            }
            catch (ParseException parseException) {
                bl2 = false;
            }
            catch (ArithmeticException arithmeticException) {
                bl2 = false;
            }
            if (Double.isNaN(unit4.value)) {
                bl2 = false;
            }
            if (bl2) {
                source.values[n][n2][2] = unit4.value;
            }
        }
    }

    private void drawRectangle(Source source, Graphics graphics, ViewSimple viewSimple, Point point, Color color, int n, int n2, int n3, int n4) {
        double d = source.values[n][n2][0];
        double d2 = source.values[n][n2][1];
        double d3 = source.values[n][n2][2];
        if (d3 == -1.0) {
            d3 = 0.0;
        }
        if (d == -1.0) {
            return;
        }
        Plan plan = viewSimple.pref;
        if (plan == null) {
            plan = source.plan;
        }
        Coord coord = new Coord();
        coord.al = source.raj;
        coord.del = source.dej;
        Coord coord2 = new Coord();
        coord2.al = source.raj;
        coord2.del = source.dej;
        coord2 = viewSimple.getProj().getXY(coord2);
        if (Double.isNaN(coord2.x)) {
            return;
        }
        double d4 = coord2.x;
        double d5 = coord2.y;
        coord.al += d / 3600.0 * Math.sin(d3 * 2.0 * Math.PI / 360.0) / Math.cos(coord.del * 2.0 * Math.PI / 360.0);
        coord.del += d / 3600.0 * Math.cos(d3 * 2.0 * Math.PI / 360.0);
        coord2.al += d2 / 3600.0 * Math.cos(d3 * 2.0 * Math.PI / 360.0) / Math.cos(coord2.del * 2.0 * Math.PI / 360.0);
        coord2.del += -(d2 / 3600.0) * Math.sin(d3 * 2.0 * Math.PI / 360.0);
        coord = new Coord(coord.al, coord.del);
        coord = viewSimple.getProj().getXY(coord);
        if (Double.isNaN(coord.x)) {
            return;
        }
        coord2 = new Coord(coord2.al, coord2.del);
        coord2 = viewSimple.getProj().getXY(coord2);
        if (Double.isNaN(coord2.x)) {
            return;
        }
        Point point2 = viewSimple.getViewCoord(coord.x, coord.y);
        double d6 = coord.x;
        double d7 = coord.y;
        Point point3 = viewSimple.getViewCoord(coord.x - 2.0 * (coord.x - d4), coord.y - 2.0 * (coord.y - d5));
        if (point2 == null || point3 == null) {
            return;
        }
        double d8 = Math.sqrt(Math.pow(point3.x - point2.x, 2.0) + Math.pow(point3.y - point2.y, 2.0));
        point2 = viewSimple.getViewCoord(coord2.x, coord2.y);
        point3 = viewSimple.getViewCoord(coord2.x - 2.0 * (coord2.x - d4), coord2.y - 2.0 * (coord2.y - d5));
        if (point2 == null || point3 == null) {
            return;
        }
        double d9 = Math.sqrt(Math.pow(point3.x - point2.x, 2.0) + Math.pow(point3.y - point2.y, 2.0));
        Point point4 = new Point((point2.x + point3.x) / 2, (point2.y + point3.y) / 2);
        double d10 = Math.atan((d5 - d7) / (d4 - d6)) * 180.0 / Math.PI;
        this.doDrawRectangle(graphics, color, point4, 0.25 * d8, 0.25 * d9, d10, n3, n4);
    }

    private void drawEllipse(Source source, Graphics graphics, ViewSimple viewSimple, Point point, Color color, int n, int n2, int n3, int n4, boolean bl) {
        Object object;
        double d = source.values[n][n2][0];
        double d2 = source.values[n][n2][1];
        double d3 = source.values[n][n2][2];
        if (d3 == -1.0) {
            d3 = 0.0;
        }
        if (d == -1.0) {
            return;
        }
        Plan plan = viewSimple.pref;
        if (plan == null) {
            plan = source.plan;
        }
        Coord coord = new Coord();
        coord.al = source.raj;
        coord.del = source.dej;
        Coord coord2 = new Coord();
        coord2.al = source.raj;
        coord2.del = source.dej;
        Projection projection = viewSimple.getProj();
        coord2 = projection.getXY(coord2);
        double d4 = coord2.x;
        double d5 = coord2.y;
        coord.al += d / 3600.0 * Math.sin(d3 * 2.0 * Math.PI / 360.0) / Math.cos(coord.del * 2.0 * Math.PI / 360.0);
        coord.del += d / 3600.0 * Math.cos(d3 * 2.0 * Math.PI / 360.0);
        coord2.al += d2 / 3600.0 * Math.cos(d3 * 2.0 * Math.PI / 360.0) / Math.cos(coord2.del * 2.0 * Math.PI / 360.0);
        coord2.del += -(d2 / 3600.0) * Math.sin(d3 * 2.0 * Math.PI / 360.0);
        coord = projection.getXY(coord);
        coord2 = projection.getXY(coord2);
        Point point2 = viewSimple.getViewCoord(coord.x, coord.y);
        double d6 = coord.x;
        double d7 = coord.y;
        Point point3 = viewSimple.getViewCoord(coord.x - 2.0 * (coord.x - d4), coord.y - 2.0 * (coord.y - d5));
        if (point2 == null || point3 == null) {
            return;
        }
        double d8 = Math.sqrt(Math.pow(point3.x - point2.x, 2.0) + Math.pow(point3.y - point2.y, 2.0));
        point2 = viewSimple.getViewCoord(coord2.x, coord2.y);
        point3 = viewSimple.getViewCoord(coord2.x - 2.0 * (coord2.x - d4), coord2.y - 2.0 * (coord2.y - d5));
        if (point2 == null || point3 == null) {
            return;
        }
        double d9 = Math.sqrt(Math.pow(point3.x - point2.x, 2.0) + Math.pow(point3.y - point2.y, 2.0));
        if (projection.t == 4 || projection.t == 11) {
            object = new Coord(source.raj, source.dej);
            ((Coord)object).al -= d / 3600.0 * Math.sin(d3 * 2.0 * Math.PI / 360.0) / Math.cos(((Coord)object).del * 2.0 * Math.PI / 360.0);
            ((Coord)object).del -= d / 3600.0 * Math.cos(d3 * 2.0 * Math.PI / 360.0);
            projection.getXY((Coord)object);
            Point point4 = viewSimple.getViewCoord(((Coord)object).x, ((Coord)object).y);
            Point point5 = viewSimple.getViewCoord(((Coord)object).x - 2.0 * (((Coord)object).x - d4), ((Coord)object).y - 2.0 * (((Coord)object).y - d5));
            double d10 = Math.sqrt(Math.pow(point5.x - point4.x, 2.0) + Math.pow(point5.y - point4.y, 2.0));
            if (d10 < d8) {
                d8 = d10;
            }
            Coord coord3 = new Coord(source.raj, source.dej);
            coord3.al -= d2 / 3600.0 * Math.cos(d3 * 2.0 * Math.PI / 360.0) / Math.cos(coord3.del * 2.0 * Math.PI / 360.0);
            coord3.del -= -(d2 / 3600.0) * Math.sin(d3 * 2.0 * Math.PI / 360.0);
            projection.getXY(coord3);
            point4 = viewSimple.getViewCoord(coord3.x, coord3.y);
            point5 = viewSimple.getViewCoord(coord3.x - 2.0 * (coord3.x - d4), coord3.y - 2.0 * (coord3.y - d5));
            double d11 = Math.sqrt(Math.pow(point5.x - point4.x, 2.0) + Math.pow(point5.y - point4.y, 2.0));
            if (d11 < d9) {
                d9 = d11;
                point3 = point5;
                point2 = point4;
            }
        }
        object = new Point((point2.x + point3.x) / 2, (point2.y + point3.y) / 2);
        double d12 = Math.atan((d5 - d7) / (d4 - d6)) * 180.0 / Math.PI;
        this.doDrawEllipse(graphics, source, color, (Point)object, 0.5 * d8, 0.5 * d9, d12, n3, n4, bl);
    }

    private void doDrawRectangle(Graphics graphics, Color color, Point point, double d, double d2, double d3, int n, int n2) {
        int n3;
        d3 = d3 * Math.PI / 180.0;
        Point[] pointArray = new Point[4];
        for (n3 = 0; n3 < 4; ++n3) {
            int n4 = n3 == 0 || n3 == 3 ? -1 : 1;
            int n5 = n3 > 1 ? -1 : 1;
            double d4 = (double)n4 * d;
            double d5 = (double)n5 * d2;
            double d6 = d4 * Math.cos(d3) - d5 * Math.sin(d3) + (double)point.x;
            double d7 = d4 * Math.sin(d3) + d5 * Math.cos(d3) + (double)point.y;
            pointArray[n3] = new Point((int)(d6 += (double)n), (int)(d7 += (double)n2));
        }
        graphics.setColor(color);
        for (n3 = 0; n3 < 3; ++n3) {
            graphics.drawLine(pointArray[n3].x, pointArray[n3].y, pointArray[n3 + 1].x, pointArray[n3 + 1].y);
        }
        graphics.drawLine(pointArray[3].x, pointArray[3].y, pointArray[0].x, pointArray[0].y);
    }

    private void doDrawEllipse(Graphics graphics, Source source, Color color, Point point, double d, double d2, double d3, int n, int n2, boolean bl) {
        graphics.setColor(color);
        if (graphics instanceof EPSGraphics || !(graphics instanceof Graphics2D)) {
            Util.drawEllipse(graphics, point.x + n, point.y + n2, d, d2, d3);
            return;
        }
        boolean bl2 = bl && Aladin.ENABLE_FOOTPRINT_OPACITY;
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setColor(color);
        AffineTransform affineTransform = graphics2D.getTransform();
        Composite composite = null;
        if (bl2) {
            composite = graphics2D.getComposite();
            float f = Aladin.DEFAULT_FOOTPRINT_OPACITY_LEVEL * source.plan.getOpacityLevel();
            Composite composite2 = Util.getImageComposite(f);
            graphics2D.setComposite(composite2);
        }
        d3 = d3 * Math.PI / 180.0;
        graphics2D.rotate(d3, point.x + n, point.y + n2);
        if (bl2) {
            graphics2D.fill(new Ellipse2D.Double((double)(point.x + n) - d, (double)(point.y + n2) - d2, d * 2.0, d2 * 2.0));
        } else {
            graphics2D.draw(new Ellipse2D.Double((double)(point.x + n) - d, (double)(point.y + n2) - d2, d * 2.0, d2 * 2.0));
        }
        graphics2D.setTransform(affineTransform);
        if (bl2) {
            graphics2D.setComposite(composite);
        }
    }

    protected static int countNbOcc(char c, String string) {
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != c) continue;
            ++n;
        }
        return n;
    }

    private void computeSize(Source source, int n, int n2) {
    }

    private void finalComputeSize(Source source, int n, int n2) {
        if (!Action.setAllVariables(this.sizeParser, source, false)) {
            return;
        }
        double d = this.sizeParser.eval();
        if (this.sizeParser.isConstant()) {
            source.values[n][n2][0] = d;
            return;
        }
        if (d > this.maxValue) {
            d = this.maxValue;
        } else if (d < this.minValue) {
            d = this.minValue;
        }
        source.values[n][n2][0] = (double)this.minRadius + (d - this.minValue) * (double)(this.maxRadius - this.minRadius) / (this.maxValue - this.minValue);
    }

    protected void computeExtremum(Source[] sourceArray) {
        if (this.shape.equals(SIZE) || this.shape.equals(FILLSIZE) || this.shape.equals(FIXEDCIRCLE)) {
            this.computeMinMax(sourceArray);
        }
    }

    protected void computeValues(Source source, int n, int n2) {
        source.values[n][n2][3] = -1.0;
        source.values[n][n2][2] = -1.0;
        source.values[n][n2][1] = -1.0;
        source.values[n][n2][0] = -1.0;
        if (this.shape.equals(SIZE) || this.shape.equals(FILLSIZE) || this.shape.equals(FIXEDCIRCLE)) {
            this.computeSize(source, n, n2);
        } else if (this.shape.equals(ELLIPSE) || this.shape.equals(FILLELLIPSE)) {
            this.computeEllipse(source, n, n2);
        } else if (this.shape.equals(RECTANGLE)) {
            this.computeRectangle(source, n, n2);
        } else if (this.shape.equals(PM)) {
            this.computePM(source, n, n2);
        } else if (this.shape.equals(LINE)) {
            this.computeLine(source, n, n2);
        }
    }

    protected void finalcomputeValues(Source source, int n, int n2) {
        if (this.shape.equals(SIZE) || this.shape.equals(FILLSIZE) || this.shape.equals(FIXEDCIRCLE)) {
            this.finalComputeSize(source, n, n2);
        }
    }

    protected void reset() {
        if (!this.userDefinedMinMax) {
            this.mustComputeMinMax = true;
        }
        this.mustComputeRGBMinMax = true;
        if (!this.userDefinedRainbowMinMax) {
            this.mustComputeRainbowMinMax = true;
        }
        if (!this.userDefinedSaturationMinMax) {
            this.mustComputeSaturationMinMax = true;
        }
    }

    private int getClosingParenthesis(String string, int n) {
        int n2 = n;
        int n3;
        while ((n3 = string.indexOf(")", n)) != -1) {
            String string2 = string.substring(n2, n3 + 1);
            if (Action.countNbOcc('(', string2) + 1 == Action.countNbOcc(')', string2)) {
                return n3;
            }
            n = n3 + 1;
        }
        return -1;
    }

    protected static boolean setAllVariables(Parser parser, Source source, boolean bl, boolean bl2) {
        Iterator iterator = parser.getVariables();
        while (iterator.hasNext()) {
            int n;
            String string = (String)iterator.next();
            if (string.startsWith("[")) {
                n = source.findUCD(string.substring(1, string.length() - 1).toUpperCase());
                if (n < 0) {
                    if (bl) continue;
                    return false;
                }
            } else {
                n = source.findColumn(string.substring(1, string.length() - 1));
                if (n < 0) {
                    if (bl) continue;
                    return false;
                }
            }
            try {
                parser.setVar(string, Double.valueOf(source.getValue(n)));
            }
            catch (NumberFormatException numberFormatException) {
                if (bl) continue;
                return false;
            }
            catch (NullPointerException nullPointerException) {
                if (bl) continue;
                return false;
            }
            if (!bl2 || parser.setVarUnit(string, source.getUnit(n))) continue;
            return false;
        }
        return true;
    }

    protected static boolean setAllVariables(Parser parser, Source source, boolean bl) {
        return Action.setAllVariables(parser, source, bl, false);
    }
}

