/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.AladinException;
import cds.aladin.Calib;
import cds.aladin.Coord;
import cds.aladin.FrameHeaderFits;
import cds.aladin.Legende;
import cds.aladin.Obj;
import cds.aladin.Plan;
import cds.aladin.PlanImage;
import cds.aladin.PlanImageBlink;
import cds.aladin.Projection;
import cds.aladin.Source;
import java.awt.Color;
import java.net.URL;
import java.util.Hashtable;
import java.util.Iterator;

public class AladinData {
    protected static final String ERR000 = "000 No default data plane";
    protected static final String ERR001 = "001 Unknown data plane";
    protected static final String ERR002 = "002 Plane not ready";
    protected static final String ERR003 = "003 Not an image plane";
    protected static final String ERR004 = "004 Full pixels not available";
    protected static final String ERR005 = "005 Fits header not available";
    protected static final String ERR006 = "006 No astrometrical solution";
    protected static final String ERR007 = "007 No object";
    protected static final String ERR008 = "008 No info on this overlay object";
    protected static final String ERR009 = "009 Plane creation error";
    protected static final String ERR010 = "010 Calibration error";
    protected static final String ERR011 = "011 Not an cube or blink plane";
    protected static final String ERR012 = "012 Cube extraction error";
    protected static final String ERR013 = "013 Plugin already running";
    protected static final String ERR014 = "014 Not available for a huge image";
    protected static final String ERR015 = "015 Catalogue creation error";
    protected Plan plan;
    private final Coord coo = new Coord();
    private Legende leg = null;

    public int getPlaneHashCode() {
        return this.plan.hashCode();
    }

    public String getLabel() {
        return this.plan.label;
    }

    public Color getColor() {
        return this.plan.c;
    }

    public String getOrigin() {
        return this.plan.copyright;
    }

    public URL getUrl() {
        return this.plan.u;
    }

    public String getError() {
        if (this.plan.type == 0) {
            return "Unknown plane";
        }
        return this.plan.error;
    }

    public String getPlaneType() {
        if (this.plan.type == 11 || this.plan.type == 1 || this.plan.type == 15) {
            return Plan.Tp[this.plan.type];
        }
        if (this.plan.type == 0) {
            return "";
        }
        return (this.plan instanceof PlanImage ? "Image/" : "Overlay/") + Plan.Tp[this.plan.type];
    }

    public boolean isSelected() {
        return this.plan.selected;
    }

    public boolean isOn() {
        return this.plan.active;
    }

    public boolean isReady() {
        return this.plan.isReady();
    }

    public double[][] getPixels() throws AladinException {
        this.testImage();
        this.testHuge();
        return ((PlanImage)this.plan).getPixels();
    }

    public double getPixel(int n, int n2) throws AladinException {
        this.testImage();
        this.testHuge();
        if (!((PlanImage)this.plan).hasOriginalPixels() || !((PlanImage)this.plan).pixelsOriginFromCache()) {
            throw new AladinException(ERR004);
        }
        if (n < 0 || n >= ((PlanImage)this.plan).naxis1 || n2 < 0 || n2 >= ((PlanImage)this.plan).naxis2) {
            return Double.NaN;
        }
        return ((PlanImage)this.plan).getPixelOriginInDouble(n, n2);
    }

    public double getPixel(int n, int n2, int n3) throws AladinException {
        this.testImage();
        if (!(this.plan instanceof PlanImageBlink)) {
            throw new AladinException(ERR011);
        }
        try {
            return ((PlanImageBlink)this.plan).getPixel(n, n2, n3);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new AladinException("012 Cube extraction error ");
        }
    }

    public double[][][] getCube(int n, int n2, int n3, int n4, int n5, int n6) throws AladinException {
        return this.getCube(null, n, n2, n3, n4, n5, n6);
    }

    public double[][][] getCube(double[][][] dArray, int n, int n2, int n3, int n4, int n5, int n6) throws AladinException {
        this.testImage();
        if (!(this.plan instanceof PlanImageBlink)) {
            throw new AladinException(ERR011);
        }
        try {
            return ((PlanImageBlink)this.plan).getCube(dArray, n, n2, n3, n4, n5, n6);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new AladinException("012 Cube extraction error ");
        }
    }

    public double[][][] getCube() throws AladinException {
        return this.getCube(0, 0, 0, ((PlanImage)this.plan).width, ((PlanImage)this.plan).height, ((PlanImageBlink)this.plan).depth);
    }

    public void setPixels(double[][] dArray) throws AladinException {
        this.testImage();
        ((PlanImage)this.plan).setPixels(dArray);
        this.codedPixelsModified();
    }

    public void setPixels(double[][] dArray, int n) throws AladinException {
        this.testImage();
        this.testHuge();
        ((PlanImage)this.plan).setPixels(dArray, n);
        this.codedPixelsModified();
    }

    public int getWidth() throws AladinException {
        this.testImage();
        return ((PlanImage)this.plan).width;
    }

    public int getHeight() throws AladinException {
        this.testImage();
        return ((PlanImage)this.plan).height;
    }

    public int getDepth() throws AladinException {
        this.testImage();
        if (!(this.plan instanceof PlanImageBlink)) {
            throw new AladinException(ERR011);
        }
        return ((PlanImageBlink)this.plan).depth;
    }

    public double[] getPixelSize() throws AladinException {
        this.testImage();
        double[] dArray = ((PlanImage)this.plan).getPixelSize();
        if (dArray == null) {
            throw new AladinException(ERR006);
        }
        return dArray;
    }

    public int getFitsBitPix() throws AladinException {
        this.testImage();
        return ((PlanImage)this.plan).bitpix;
    }

    public double getFitsBzero() throws AladinException {
        this.testImage();
        return ((PlanImage)this.plan).bZero;
    }

    public double getFitsBscale() throws AladinException {
        this.testImage();
        return ((PlanImage)this.plan).bScale;
    }

    public String getFitsHeader() throws AladinException {
        this.testImage();
        try {
            return this.plan.aladin.save.generateFitsHeaderString((PlanImage)this.plan);
        }
        catch (Exception exception) {
            throw new AladinException(ERR005);
        }
    }

    public void setFitsHeader(String string) throws AladinException {
        this.testImage();
        try {
            ((PlanImage)this.plan).headerFits = new FrameHeaderFits(this.plan, string);
            ((PlanImage)this.plan).headerFits = new FrameHeaderFits(this.plan, this.plan.aladin.save.generateFitsHeaderString((PlanImage)this.plan));
        }
        catch (Exception exception) {
            throw new AladinException("010 Calibration error => " + exception.getMessage());
        }
        this.setCalib();
    }

    public byte[] seeBytePixels() throws AladinException {
        this.testImage();
        return ((PlanImage)this.plan).getBufPixels8();
    }

    public byte[] seeBytePixels(int n) throws AladinException {
        this.testImage();
        if (!(this.plan instanceof PlanImageBlink)) {
            throw new AladinException(ERR011);
        }
        return ((PlanImageBlink)this.plan).vFrames.elementAt((int)n).pixels;
    }

    public byte[] seeCodedPixels() throws AladinException {
        this.testImage();
        this.testHuge();
        if (!((PlanImage)this.plan).hasOriginalPixels() || !((PlanImage)this.plan).pixelsOriginFromCache()) {
            throw new AladinException(ERR004);
        }
        return ((PlanImage)this.plan).pixelsOrigin;
    }

    public Hashtable seeFitsKeys() throws AladinException {
        this.testImage();
        this.fitsKeysModified();
        return ((PlanImage)this.plan).headerFits.getHeaderFits().getHashHeader();
    }

    public static double CodedPixelsToDouble(byte[] byArray, int n, int n2) {
        return PlanImage.getPixVal1(byArray, n, n2);
    }

    public static void DoubleToCodedPixels(double d, byte[] byArray, int n, int n2) {
        PlanImage.setPixVal(byArray, n, n2, d);
    }

    public void bytePixelsModified() throws AladinException {
        this.testImage();
        this.testHuge();
        ((PlanImage)this.plan).noOriginalPixels();
        this.repaint();
    }

    public void codedPixelsModified() throws AladinException {
        this.testImage();
        this.testHuge();
        ((PlanImage)this.plan).reUseOriginalPixels();
        this.repaint();
    }

    public void fitsKeysModified() throws AladinException {
        this.testImage();
        this.setCalib();
        this.setFitsHeader(this.plan.aladin.save.generateFitsHeaderString((PlanImage)this.plan));
    }

    public double[] getCoord(double d, double d2) throws AladinException {
        this.testImage();
        if (!Projection.isOk(this.plan.projd)) {
            throw new AladinException(ERR006);
        }
        this.coo.x = d - 0.5;
        this.coo.y = d2 - 0.5;
        this.coo.y = (double)((PlanImage)this.plan).naxis2 - this.coo.y;
        this.plan.projd.getCoord(this.coo);
        return new double[]{this.coo.al, this.coo.del};
    }

    public double[] getXY(double d, double d2) throws AladinException {
        if (!Projection.isOk(this.plan.projd)) {
            throw new AladinException(ERR006);
        }
        this.coo.al = d;
        this.coo.del = d2;
        this.plan.projd.getXY(this.coo);
        this.coo.y = (double)((PlanImage)this.plan).naxis2 - this.coo.y;
        return new double[]{this.coo.x, this.coo.y};
    }

    public Iterator<Obj> iteratorObj() throws AladinException {
        this.testOverlay();
        return this.plan.pcat.iterator();
    }

    public Obj[] seeObj() throws AladinException {
        this.testOverlay();
        return this.plan.pcat.getObj();
    }

    public int getNbObj() throws AladinException {
        this.testOverlay();
        return this.plan.pcat.getCount();
    }

    public void rmObj(Obj obj) throws AladinException {
        this.testOverlay();
        if (obj.isSelected()) {
            obj.setSelected(false);
        }
        this.plan.pcat.delObjet(obj, true);
    }

    public void setName(String[] stringArray) {
        this.leg = Legende.adjustDefaultLegende(this.leg, 3, stringArray);
    }

    public void setDatatype(String[] stringArray) {
        this.leg = Legende.adjustDefaultLegende(this.leg, 6, stringArray);
    }

    public void setUnit(String[] stringArray) {
        this.leg = Legende.adjustDefaultLegende(this.leg, 5, stringArray);
    }

    public void setUCD(String[] stringArray) {
        this.leg = Legende.adjustDefaultLegende(this.leg, 7, stringArray);
    }

    public void setWidth(String[] stringArray) {
        this.leg = Legende.adjustDefaultLegende(this.leg, 9, stringArray);
    }

    public void setArraysize(String[] stringArray) {
        this.leg = Legende.adjustDefaultLegende(this.leg, 10, stringArray);
    }

    public void setPrecision(String[] stringArray) {
        this.leg = Legende.adjustDefaultLegende(this.leg, 11, stringArray);
    }

    public Obj addSource(String string, double d, double d2, String[] stringArray) throws AladinException {
        this.testOverlay();
        StringBuffer stringBuffer = new StringBuffer("<&_A>");
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].startsWith("http://") || stringArray[i].startsWith("https://")) {
                stringBuffer.append("\t<&Http " + stringArray[i] + ">");
                continue;
            }
            stringBuffer.append("\t" + stringArray[i]);
        }
        Source source = new Source(this.plan, d, d2, string, stringBuffer.toString());
        source.leg = this.leg;
        this.plan.pcat.setObjetFast(source);
        return source;
    }

    public void objModified() throws AladinException {
        this.testOverlay();
        if (!Projection.isOk(this.plan.projd)) {
            this.plan.pcat.createDefaultProj();
        }
        this.plan.planReady(true);
        this.plan.aladin.view.newView(1);
        this.plan.aladin.mesure.memoWordLineClear();
        this.plan.aladin.mesure.display();
        this.plan.aladin.calque.repaintAll();
    }

    public AladinData(Aladin aladin) throws AladinException {
        this(aladin, 0, null);
    }

    public AladinData(Aladin aladin, String string) throws AladinException {
        this(aladin, 0, string);
    }

    public AladinData(Aladin aladin, int n) throws AladinException {
        this.plan = aladin.calque.getPlanByHashCode(n);
        if (this.plan == null) {
            throw new AladinException(ERR001);
        }
    }

    public AladinData(Aladin aladin, int n, String string) throws AladinException {
        if (n == 0) {
            if (string == null) {
                try {
                    String string2 = aladin.calque.getFirstSelectedPlan().label;
                    this.plan = aladin.calque.getPlan(string2);
                }
                catch (Exception exception) {
                    throw new AladinException(ERR000);
                }
            } else {
                this.plan = aladin.calque.getPlan(string);
                if (this.plan == null) {
                    throw new AladinException(ERR001);
                }
            }
            if (this.plan != null) {
                this.leg = this.plan.getFirstLegende();
            }
        } else {
            try {
                if (n == 1) {
                    String string3 = aladin.calque.newPlanPlugImg(string);
                    this.plan = aladin.calque.getPlan(string3);
                    double[][] dArray = new double[500][500];
                    this.setPixels(dArray);
                    this.plan.error = PlanImage.NOREDUCTION;
                    this.plan = aladin.calque.getPlan(string3, 1);
                    this.plan.planReady(true);
                } else {
                    String string4 = aladin.calque.newPlanPlugCat(string);
                    this.plan = aladin.calque.getPlan(string4, 1);
                }
            }
            catch (Exception exception) {
                throw new AladinException(ERR009);
            }
        }
    }

    protected AladinData(Aladin aladin, String string, String string2) throws AladinException {
        int n = aladin.calque.newPlanImage(null, 0, string, "", "", string2, 0, 0, null, null);
        this.plan = aladin.calque.plan[n];
    }

    private void testImage() throws AladinException {
        if (!this.plan.isReady()) {
            throw new AladinException(ERR002);
        }
        if (!(this.plan instanceof PlanImage)) {
            throw new AladinException(ERR003);
        }
    }

    private void testHuge() throws AladinException {
        if (this.plan.type == 15) {
            throw new AladinException(ERR014);
        }
    }

    private void testOverlay() throws AladinException {
        if (!this.plan.isReady()) {
            throw new AladinException(ERR002);
        }
        if (this.plan.pcat == null) {
            throw new AladinException(ERR007);
        }
    }

    private void setCalib() {
        try {
            Projection projection = new Projection(2, new Calib(((PlanImage)this.plan).headerFits.getHeaderFits()));
            this.plan.setNewProjD(projection);
            this.plan.setHasSpecificCalib();
            this.repaint();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void repaint() {
        if (this.plan instanceof PlanImage) {
            ((PlanImage)this.plan).changeImgID();
        } else {
            this.plan.aladin.view.newView(1);
        }
        this.plan.aladin.calque.repaintAll();
    }

    public String toString() {
        try {
            String string = this.getPlaneType() + " " + this.getLabel();
            if (!(this.plan instanceof PlanImage)) {
                return string;
            }
            return string + " " + this.getWidth() + "x" + this.getHeight();
        }
        catch (Exception exception) {
            return null;
        }
    }
}

