/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.AladinException;

public abstract class AladinPlugin
implements Runnable {
    private Thread thread = null;
    private boolean isSuspended = false;
    public Aladin aladin;
    private String error = null;
    private boolean hasBeenStarted = false;

    public abstract String menu();

    public abstract void exec() throws AladinException;

    public String author() {
        return null;
    }

    public String version() {
        return null;
    }

    public String description() {
        return null;
    }

    public String scriptCommand() {
        return null;
    }

    public String scriptHelp() {
        return null;
    }

    public String category() {
        return null;
    }

    public String url() {
        return null;
    }

    public boolean inSeparatedThread() {
        return false;
    }

    public boolean isSync() {
        return true;
    }

    public String execScriptCommand(String[] stringArray) {
        try {
            this.start();
        }
        catch (Exception exception) {
            return exception.getMessage();
        }
        return "";
    }

    public void cleanup() {
    }

    public boolean isRunning() {
        return this.thread != null && this.thread.isAlive();
    }

    protected boolean isSuspended() {
        return this.thread != null && this.thread.isAlive() && this.isSuspended;
    }

    protected void start() throws AladinException {
        if (this.isRunning()) {
            throw new AladinException("013 Plugin already running");
        }
        this.error = null;
        if (this.inSeparatedThread()) {
            this.thread = new Thread((Runnable)this, "AladinPlugin");
            this.thread.start();
        } else {
            this.exec();
        }
    }

    protected void stop() {
        if (!this.isRunning()) {
            return;
        }
        if (this.thread != null) {
            this.thread.stop();
        }
        this.cleanup();
    }

    protected void suspend() {
        if (!this.isRunning() || this.thread == null || this.isSuspended) {
            return;
        }
        this.thread.suspend();
        this.isSuspended = true;
    }

    protected void resume() {
        if (this.thread == null || !this.isRunning() && !this.isSuspended) {
            return;
        }
        this.thread.resume();
        this.isSuspended = false;
    }

    protected String getError() {
        return this.error;
    }

    public void setAladin(Aladin aladin) {
        this.aladin = aladin;
    }

    @Override
    public void run() {
        this.hasBeenStarted = true;
        try {
            this.exec();
        }
        catch (AladinException aladinException) {
            aladinException.printStackTrace();
            this.error = aladinException.getMessage();
        }
    }

    public boolean hasBeenStarted() {
        return this.hasBeenStarted;
    }
}

