/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Cercle;
import cds.aladin.Coord;
import cds.aladin.Plan;
import cds.aladin.Position;
import cds.aladin.RectangleD;
import cds.aladin.ViewSimple;
import java.awt.Graphics;
import java.awt.Point;

public class Arc
extends Cercle {
    protected double angle;

    protected Arc(Plan plan, ViewSimple viewSimple, double d, double d2, double d3, double d4, double d5) {
        super(plan, new Position[3]);
        this.angle = d5;
        this.o[0] = new Position(plan, viewSimple, d, d2, 0.0, 0.0, 5, null);
        double d6 = d4;
        d6 = Math.PI * d6 / 180.0;
        double d7 = d + d3 * Math.sin(d6);
        double d8 = d2 + d3 * Math.cos(d6);
        this.o[1] = new Position(plan, viewSimple, d7, d8, 0.0, 0.0, 5, null);
        d6 = d4 + d5;
        d6 = Math.PI * d6 / 180.0;
        d7 = d + d3 * Math.sin(d6);
        d8 = d2 + d3 * Math.cos(d6);
        this.o[2] = new Position(plan, viewSimple, d7, d8, 0.0, 0.0, 5, null);
        this.setObjet(this.o);
    }

    protected Arc(Plan plan, Coord coord, double d, double d2, double d3) {
        super(plan, new Position[3]);
        this.angle = d3;
        this.o[0] = new Position(plan, null, 0.0, 0.0, coord.al, coord.del, 2, null);
        Coord coord2 = this.applySphereRot(coord, d, d2);
        this.o[1] = new Position(plan, null, 0.0, 0.0, coord2.al, coord2.del, 2, null);
        Coord coord3 = this.applySphereRot(coord, d, d2 + d3);
        this.o[2] = new Position(plan, null, 0.0, 0.0, coord3.al, coord3.del, 2, null);
        this.setObjet(this.o);
    }

    protected Arc(Plan plan, Position[] positionArray) {
        super(plan, positionArray);
    }

    @Override
    public String getObjType() {
        return "Arc";
    }

    protected double getStartAngle3H(ViewSimple viewSimple) {
        return 180.0 * Math.atan2(this.o[0].yv[viewSimple.n] - this.o[1].yv[viewSimple.n], this.o[1].xv[viewSimple.n] - this.o[0].xv[viewSimple.n]) / Math.PI;
    }

    protected double getEndAngle3H(ViewSimple viewSimple) {
        return 180.0 * Math.atan2(this.o[0].yv[viewSimple.n] - this.o[2].yv[viewSimple.n], this.o[2].xv[viewSimple.n] - this.o[0].xv[viewSimple.n]) / Math.PI;
    }

    protected double getAngle() {
        return this.angle;
    }

    @Override
    protected boolean inside(ViewSimple viewSimple, double d, double d2) {
        return this.in(viewSimple, d, d2);
    }

    @Override
    protected boolean in(ViewSimple viewSimple, double d, double d2) {
        if (!super.in(viewSimple, d, d2)) {
            return false;
        }
        double d3 = this.getStartAngle3H(viewSimple);
        double d4 = 180.0 * Math.atan2(this.o[0].yv[viewSimple.n] - d2, d - this.o[0].xv[viewSimple.n]) / Math.PI;
        double d5 = d4 - d3;
        return this.getAngle() > 0.0 ? -1.0 < d5 && d5 < this.getAngle() + 1.0 : this.getAngle() - 1.0 < d5 && d5 < 1.0;
    }

    @Override
    protected boolean inBout(ViewSimple viewSimple, double d, double d2) {
        if (!this.isVisible()) {
            return false;
        }
        return this.o[1].in(viewSimple, d, d2) || this.o[2].in(viewSimple, d, d2);
    }

    @Override
    protected boolean inRectangle(ViewSimple viewSimple, RectangleD rectangleD) {
        for (int i = 1; i < this.o.length; ++i) {
            if (!this.o[i].inRectangle(viewSimple, rectangleD)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean draw(Graphics graphics, ViewSimple viewSimple, int n, int n2) {
        if (!this.isVisible()) {
            return false;
        }
        int n3 = (int)Math.round(this.getRayon(viewSimple) * viewSimple.getZoom());
        Point point = this.o[0].getViewCoord(viewSimple, n3 * 2, n3 * 2);
        if (point == null) {
            return false;
        }
        point.x += n;
        point.y += n2;
        graphics.setColor(this.getColor());
        double d = this.getStartAngle3H(viewSimple);
        double d2 = this.getAngle();
        graphics.drawArc(point.x - n3, point.y - n3, n3 * 2, n3 * 2, (int)Math.round(d), (int)Math.round(d2));
        if (this.isSelected()) {
            if (this.plan != null && this.plan.type == 10) {
                return true;
            }
            this.drawSelect(graphics, viewSimple, 1);
            this.drawSelect(graphics, viewSimple, 2);
        }
        return true;
    }
}

