/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Slide;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.Timer;

public class Ball
extends JComponent
implements ActionListener {
    static final int UNKNOWN = 0;
    static final int OK = 1;
    static final int HS = 2;
    static final int NOK = 3;
    static final int WAIT = 4;
    static final int PARTIAL = 5;
    private int W = 11;
    private Dimension dim = new Dimension(this.W, this.W);
    private int mode = 0;
    private boolean blinkState;
    private Timer timer = null;
    private int x = 0;
    private int y = 0;

    public Ball() {
    }

    public Ball(int n, int n2) {
        this.x = n;
        this.y = n2;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.dim;
    }

    protected void setMode(int n) {
        this.mode = n;
        if (!Aladin.NOGUI) {
            this.repaint();
        }
    }

    protected boolean isBlinking() {
        return this.mode == 4;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        boolean bl = this.blinkState = !this.blinkState;
        if (!Aladin.NOGUI) {
            this.repaint();
        }
    }

    @Override
    public void paintComponent(Graphics graphics) {
        if (Aladin.NOGUI) {
            return;
        }
        super.paintComponent(graphics);
        switch (this.mode) {
            case 0: {
                Slide.drawBall(graphics, this.x, this.y, Color.white);
                break;
            }
            case 1: {
                Slide.drawBall(graphics, this.x, this.y, Color.green);
                break;
            }
            case 3: {
                Slide.drawBall(graphics, this.x, this.y, Color.red);
                break;
            }
            case 5: {
                Slide.drawBall(graphics, this.x, this.y, Color.orange);
                break;
            }
            case 2: {
                Slide.drawCross(graphics, this.x, this.y);
                break;
            }
            case 4: {
                Slide.drawBall(graphics, this.x, this.y, !this.blinkState ? Color.green : Color.white);
            }
        }
        if (this.mode == 4) {
            if (this.timer == null) {
                this.timer = new Timer(500, this);
            }
            if (!this.timer.isRunning()) {
                this.timer.start();
            }
        } else if (this.timer != null && this.timer.isRunning()) {
            this.timer.stop();
        }
    }
}

