/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.BasicNode;
import cds.aladin.MetaDataTree;
import cds.aladin.ResourceNode;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;

public class BasicTree
extends JComponent
implements MouseMotionListener,
MouseListener,
ActionListener {
    private JScrollPane scroll = null;
    boolean hasSpectraOrImages;
    protected JPopupMenu popup;
    protected JPopupMenu popupPrefs;
    protected static final String DELETE = "Delete";
    protected static final String COLLAPSE_SUBTREE = "Collapse this subtree";
    protected static final String EXPAND_SUBTREE = "Expand this subtree";
    protected static final String COLLAPSE_ALL = "Collapse all";
    protected static final String EXPAND_ALL = "Expand all";
    protected static final String FLAT_VIEW = "Flat view";
    protected static final String HIER_VIEW = "Hierarchical view";
    protected static final String SIAP_EVOL_SORT = "Sort";
    protected static final String CREATE_CATPLANE = "Create a catalog plane with all images/spectra";
    boolean flatView = false;
    private int prefHeight = 600;
    private int prefWidth = 250;
    static final int XSPACE = 22;
    static final int YSPACE = 18;
    static final int LOGOSIZE = 12;
    static final int LOGOPADDING = 4;
    static final Color LITBGCOLOR = new Color(189, 222, 237);
    static final Color LITFGCOLOR = Color.black;
    static final Color selectedColor = new Color(255, 190, 255);
    static final Color mouseOverColor = Color.blue;
    static final Color bkgdLeafColor = Aladin.MYBLUE;
    static final Color bkgdLeafClickedColor = Aladin.LBLUE;
    static final Color lineColor = Color.black;
    static Font nameFont = Aladin.COURIER;
    static Font boldNameFont = Aladin.BCOURIER;
    private BasicNode rootNode;
    BasicNode lastInfoNode;
    private BasicNode ancienCurNode;
    boolean isHistoryTree = false;
    protected Color bkgColor = Aladin.LBLUE;
    private boolean mustInit = true;
    private boolean allowSortByFields = true;
    private int hilightNode;
    int oHilightNode = -1;
    BasicNode selectedNode;
    BasicNode oselectedNode;
    private Vector nodeFullList;
    BasicNode[] nodeFullTab;
    private Vector nodeList;
    BasicNode[] nodeTab;
    private int yCurrent = 0;
    private boolean[] lastChild = new boolean[100];
    Aladin aladin;
    boolean mustScroll = false;
    boolean last = false;
    static Color grayCB = new Color(102, 102, 102);
    static Color grayFill = new Color(192, 192, 192);
    static Color tickColor = Color.red;
    static final int COTE = 12;
    private static Color[] sortFieldColor = new Color[]{Color.decode("0xb7d2ca"), Color.decode("0xd0c2e9"), Color.decode("0xd5e0c4"), Color.decode("0xbccdf0")};
    boolean lastPosInLogo;
    private int maxWidth;
    private int tmpSize;
    static FontMetrics fm = Toolkit.getDefaultToolkit().getFontMetrics(boldNameFont);
    boolean triggerOnNodeSelected = false;
    BasicNode nodeToTrigger = null;
    boolean mustSetLocation = false;

    private BasicTree(Aladin aladin, BasicNode basicNode) {
        this.aladin = aladin;
        this.rootNode = basicNode;
        this.rootNode.hide = true;
        this.setBackground(this.bkgColor);
        this.setOpaque(true);
        this.setDoubleBuffered(false);
        this.createPopup();
        this.traverseTree();
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
    }

    BasicTree(Aladin aladin, BasicNode basicNode, JScrollPane jScrollPane) {
        this(aladin, basicNode);
        this.scroll = jScrollPane;
    }

    BasicTree(Aladin aladin, BasicNode basicNode, JScrollPane jScrollPane, boolean bl) {
        this.aladin = aladin;
        this.rootNode = basicNode;
        this.rootNode.hide = true;
        this.isHistoryTree = bl;
        this.setBackground(this.bkgColor);
        this.setOpaque(true);
        this.setDoubleBuffered(false);
        this.createPopup();
        this.traverseTree();
        this.scroll = jScrollPane;
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
    }

    protected JMenuItem createItem(String string) {
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.setFont(Aladin.PLAIN);
        jMenuItem.addActionListener(this);
        return jMenuItem;
    }

    private void createPopup() {
        if (this.popup == null) {
            this.popup = new JPopupMenu();
        } else {
            this.popup.removeAll();
        }
        this.popup.add(this.createItem(DELETE));
        this.popup.addSeparator();
        this.popup.add(this.createItem(COLLAPSE_SUBTREE));
        this.popup.add(this.createItem(EXPAND_SUBTREE));
        this.popupPrefs = new JPopupMenu();
        this.popupPrefs.add(this.createItem(COLLAPSE_ALL));
        this.popupPrefs.add(this.createItem(EXPAND_ALL));
        if (!this.isHistoryTree && this.hasSpectraOrImages) {
            this.popupPrefs.addSeparator();
            this.popupPrefs.add(this.createItem(CREATE_CATPLANE));
        }
        this.popupPrefs.addSeparator();
        this.popupPrefs.add(this.flatView ? this.createItem(HIER_VIEW) : this.createItem(FLAT_VIEW));
        if (this.allowSortByFields) {
            this.popupPrefs.addSeparator();
            this.popupPrefs.add(this.createItem(SIAP_EVOL_SORT));
        }
    }

    @Override
    public void setBackground(Color color) {
        this.setOpaque(true);
        super.setBackground(color);
        this.bkgColor = color;
    }

    protected void clearSelected() {
        this.ancienCurNode = null;
        if (this.oHilightNode < 0 || this.oHilightNode >= this.nodeTab.length) {
            return;
        }
        BasicNode basicNode = this.nodeTab[this.oHilightNode];
        this.oHilightNode = -1;
        this.drawNodeName(this.getGraphics(), basicNode, true);
        this.repaint();
    }

    protected void majSize() {
        if (this.nodeList != null) {
            this.prefHeight = this.nodeList.size() * 18 + 20;
        }
        if (this.scroll != null) {
            JViewport jViewport = this.scroll.getViewport();
            if (this.prefHeight < jViewport.getHeight()) {
                this.prefHeight = jViewport.getHeight();
            }
            if (this.prefWidth < jViewport.getWidth()) {
                this.prefWidth = jViewport.getWidth();
            }
        }
        this.setSize(this.prefWidth, this.prefHeight);
    }

    protected boolean init(Graphics graphics) {
        this.majSize();
        this.doDisplay(graphics);
        return true;
    }

    protected Color getMouseOverColor(BasicNode basicNode) {
        return basicNode.isLeaf ? Color.white : mouseOverColor;
    }

    void doDisplay(Graphics graphics) {
        this.yCurrent = 0;
        this.nodeList = new Vector();
        if (graphics == null) {
            return;
        }
        graphics.setColor(this.bkgColor);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        this.fullDisplay(graphics);
    }

    void fullDisplay(Graphics graphics) {
        JViewport jViewport;
        this.last = false;
        graphics.setColor(Color.black);
        this.displayTree(graphics, this.rootNode, 0);
        this.hilightNode = -1;
        this.nodeTab = new BasicNode[this.nodeList.size()];
        this.nodeList.copyInto(this.nodeTab);
        this.nodeList = null;
        this.prefHeight = this.nodeTab.length * 18;
        if (this.scroll != null && this.prefHeight < (jViewport = this.scroll.getViewport()).getHeight()) {
            this.prefHeight = jViewport.getHeight();
        }
        if (this.getWidth() != this.prefWidth || this.getHeight() != this.prefHeight) {
            this.setSize(this.prefWidth, this.prefHeight);
        }
    }

    private void drawVertLine(Graphics graphics, int n, int n2) {
        int n3 = n + 11 - 5;
        graphics.setColor(lineColor);
        graphics.drawLine(n3, n2 - 4, n3, n2 + 18 + 2);
    }

    private void drawHalfVertLine(Graphics graphics, int n, int n2) {
        int n3 = n + 11 - 5;
        graphics.setColor(lineColor);
        graphics.drawLine(n3, n2 - 4, n3, n2 + 9 - 1);
    }

    private void displayTree(Graphics graphics, BasicNode basicNode, int n) {
        block12: {
            block11: {
                this.nodeList.addElement(basicNode);
                this.lastChild[n] = basicNode.isLastChild();
                basicNode.level = n;
                int n2 = -21;
                for (int i = 0; i < n; ++i) {
                    if (!this.lastChild[i + 1] && !this.flatView) {
                        this.drawVertLine(graphics, n2 + 22, this.yCurrent);
                    } else if (!this.flatView && i == n - 1) {
                        this.drawHalfVertLine(graphics, n2 + 22, this.yCurrent);
                    }
                    n2 += 22;
                }
                if (!(basicNode.hide || basicNode == this.rootNode && this.flatView)) {
                    this.displayIconLabel(graphics, basicNode, n2);
                } else if (!this.flatView && basicNode == this.rootNode && basicNode.getNbOfChildren() > 0) {
                    this.drawVertLine(graphics, n2 + 22, this.yCurrent);
                } else {
                    n2 += 22;
                    basicNode.x = n2 += 22;
                    basicNode.y = this.yCurrent;
                }
                this.yCurrent += 18;
                if (!this.flatView) break block11;
                BasicNode[] basicNodeArray = this.getLeavesForFlatView(basicNode);
                int n3 = basicNodeArray.length;
                for (int i = 0; i < basicNodeArray.length; ++i) {
                    if (i == n3) {
                        this.last = true;
                    }
                    this.displayTree(graphics, basicNodeArray[i], n + 1);
                }
                break block12;
            }
            if (basicNode.isLeaf || !basicNode.isOpen) break block12;
            Enumeration enumeration = basicNode.getChildren();
            while (enumeration.hasMoreElements()) {
                this.displayTree(graphics, (BasicNode)enumeration.nextElement(), n + 1);
            }
        }
    }

    BasicNode[] getLeavesForFlatView(BasicNode basicNode) {
        Vector vector = new Vector();
        BasicTree.getAllLeaves(basicNode, vector);
        int n = vector.size();
        Object[] objectArray = new BasicNode[n];
        vector.copyInto(objectArray);
        vector = null;
        return objectArray;
    }

    protected void drawCheckBox(Graphics graphics, int n, int n2, BasicNode basicNode, boolean bl) {
        int n3 = n;
        int n4 = n2 + 2;
        if (bl) {
            graphics.setColor(grayFill);
            graphics.fillRect(n3, n4, 12, 12);
        }
        graphics.setColor(Color.white);
        graphics.drawRect(n3 + 1, n4 + 1, 12, 12);
        graphics.setColor(grayCB);
        graphics.drawRect(n3, n4, 12, 12);
        if (basicNode.isSelected()) {
            graphics.setColor(tickColor);
            graphics.fillRect(n3 + 3, n4 + 6 - 1, 2, 6);
            int n5 = n3 + 5;
            int n6 = n4 + 12 - 3;
            int n7 = 5;
            graphics.drawLine(n5, n6, n5 + n7, n6 - n7);
            graphics.drawLine(n5, n6 - 1, n5 + n7, n6 - n7 - 1);
        }
    }

    protected void drawPreCheckBox(Graphics graphics, int n, int n2, BasicNode basicNode, boolean bl) {
        if (!basicNode.isLeaf) {
            return;
        }
        int n3 = n;
        int n4 = n2 + 2;
        int[] nArray = new int[]{n3 + 2, n3 + 5, n3 + 5, n3 + 10, n3 + 11, n3 + 11, n3 + 4, n3 + 2};
        int[] nArray2 = new int[]{n4 + 6 - 2, n4 + 6 - 2, n4 + 6 - 2 + 3, n4 + 6 - 4, n4 + 6 - 4, n4 + 6 - 2, n4 + 6 - 2 + 7, n4 + 6 - 2 + 7};
        if (bl) {
            if (!basicNode.isSelected) {
                graphics.setColor(grayFill);
                graphics.fillRect(n3, n4, 12, 12);
            } else {
                graphics.setColor(grayFill);
                graphics.drawPolygon(nArray, nArray2, nArray.length);
            }
        }
        graphics.setColor(Color.white);
        graphics.drawRect(n3 + 1, n4 + 1, 12, 12);
        graphics.setColor(grayCB);
        graphics.drawRect(n3, n4, 12, 12);
        if (bl) {
            return;
        }
        graphics.setColor(Color.black);
        graphics.drawPolygon(nArray, nArray2, nArray.length);
    }

    private void drawLogo(Graphics graphics, int n, int n2, BasicNode basicNode) {
        int n3 = n;
        graphics.setColor(Color.white);
        graphics.fillRect(n3, n2 + 2, 12, 12);
        graphics.setColor(Color.black);
        graphics.drawRect(n3, n2 + 2, 12, 12);
        if (basicNode.isOpen) {
            graphics.setColor(Color.black);
            graphics.drawLine(n3 + 4, n2 + 2 + 6, n3 + 12 - 4, n2 + 2 + 6);
        } else {
            graphics.setColor(Color.black);
            graphics.drawLine(n3 + 6, n2 + 2 + 4, n3 + 6, n2 + 2 + 12 - 4);
            graphics.drawLine(n3 + 4, n2 + 2 + 6, n3 + 12 - 4, n2 + 2 + 6);
        }
    }

    private void drawHorizLine(Graphics graphics, int n, int n2, BasicNode basicNode) {
        graphics.setColor(lineColor);
        if (basicNode.isLeaf) {
            graphics.drawLine(12 + n - 22 - 5, this.yCurrent + 9 - 1, 16 + n + 11 - 22, this.yCurrent + 9 - 1);
        } else {
            graphics.drawLine(n - 12 - 3, this.yCurrent + 9 - 1, n, this.yCurrent + 9 - 1);
        }
    }

    private void drawNodeName(Graphics graphics, BasicNode basicNode) {
        this.drawNodeName(graphics, basicNode, false);
    }

    protected void drawNodeName(Graphics graphics, BasicNode basicNode, boolean bl) {
        if (basicNode == this.rootNode && this.flatView) {
            return;
        }
        String string = this.getName(basicNode);
        if (bl) {
            graphics.setColor(this.bkgColor);
            graphics.fillRect(basicNode.x - 1, basicNode.y, graphics.getFontMetrics().stringWidth(string) + 2, 18);
        }
        boolean bl2 = false;
        if (this.oHilightNode >= 0 && this.oHilightNode < this.nodeTab.length && this.nodeTab != null && basicNode.equals(this.nodeTab[this.oHilightNode])) {
            bl2 = true;
            if (basicNode.isLeaf) {
                this.drawSelectedLeafNodeName(graphics, basicNode, string);
            }
        }
        graphics.setFont(basicNode.equals(this.lastInfoNode) ? boldNameFont : nameFont);
        int n = string.indexOf("::: ");
        boolean bl3 = n >= 0 && !basicNode.isLeaf;
        boolean bl4 = false;
        String string2 = "";
        int n2 = 0;
        if (bl3) {
            string = MetaDataTree.replace(string, "///", "", 1);
            string2 = string.substring(0, n + 1);
            string = string.substring(n + 3);
            graphics.setColor(sortFieldColor[basicNode.level % sortFieldColor.length]);
            n2 = graphics.getFontMetrics().stringWidth(string2) + 1;
            graphics.fillRect(basicNode.x, basicNode.y + 1, n2, 16);
        } else if (basicNode.isLeaf && basicNode.equals(this.lastInfoNode)) {
            bl4 = true;
        }
        graphics.setColor(bl2 ? this.getMouseOverColor(basicNode) : Color.black);
        if (bl3) {
            graphics.drawString(string2, basicNode.x, basicNode.y + 9 + 4);
        }
        if (bl4) {
            this.drawBorder(graphics, basicNode, graphics.getFontMetrics().stringWidth(string));
        }
        graphics.drawString(string, n2 + basicNode.x, basicNode.y + 9 + 4);
    }

    protected void drawSelectedLeafNodeName(Graphics graphics, BasicNode basicNode, String string) {
        int n = graphics.getFontMetrics().stringWidth(string);
        graphics.setColor(bkgdLeafColor);
        graphics.fillRect(basicNode.x, basicNode.y + 1, n, 16);
        this.drawBorder(graphics, basicNode, n);
    }

    protected void drawBorder(Graphics graphics, BasicNode basicNode, int n) {
        Color color = graphics.getColor();
        graphics.setColor(Color.black);
        graphics.drawLine(basicNode.x - 1, basicNode.y, basicNode.x - 1 + n, basicNode.y);
        graphics.drawLine(basicNode.x - 1, basicNode.y, basicNode.x - 1, basicNode.y + 18 - 2);
        graphics.setColor(Color.white);
        graphics.drawLine(basicNode.x - 1, basicNode.y + 18 - 1, basicNode.x - 1 + n, basicNode.y + 18 - 1);
        graphics.drawLine(basicNode.x + n, basicNode.y, basicNode.x + n, basicNode.y + 18 - 1);
        graphics.setColor(color);
    }

    protected String getName(BasicNode basicNode) {
        return basicNode.name;
    }

    private void displayIconLabel(Graphics graphics, BasicNode basicNode, int n) {
        n += 22;
        if (!basicNode.isLeaf) {
            this.drawLogo(graphics, n, this.yCurrent, basicNode);
        }
        if (basicNode.level > 0 && !this.flatView) {
            this.drawHorizLine(graphics, n, this.yCurrent, basicNode);
        }
        if (basicNode.isLeaf) {
            this.drawCheckBox(graphics, n, this.yCurrent, basicNode, true);
        }
        basicNode.x = n += 22;
        basicNode.y = this.yCurrent;
        this.drawNodeName(graphics, basicNode);
    }

    private boolean inNodeName(Graphics graphics, int n, BasicNode basicNode) {
        return this.inNodeName(graphics, n, basicNode, false);
    }

    private boolean inNodeName(Graphics graphics, int n, BasicNode basicNode, boolean bl) {
        int n2 = bl ? basicNode.level * 22 : basicNode.x;
        return n >= n2 && n <= basicNode.x + graphics.getFontMetrics().stringWidth(this.getName(basicNode));
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        int n;
        BasicNode basicNode;
        BasicNode basicNode2;
        int n2 = mouseEvent.getX();
        int n3 = mouseEvent.getY();
        this.hilightNode = n3 / 18;
        Graphics graphics = this.getGraphics();
        graphics.setFont(nameFont);
        try {
            basicNode2 = this.nodeTab[this.hilightNode];
            if (basicNode2 == this.rootNode) {
                this.onMouseMoved(this.rootNode, false);
                basicNode = this.nodeTab[this.oHilightNode];
                this.oHilightNode = -1;
                this.ancienCurNode = null;
                this.drawNodeName(graphics, basicNode, true);
                if (!basicNode.isSelected()) {
                    this.drawPreCheckBox(graphics, basicNode.x - 22, basicNode.y, basicNode, true);
                }
            }
            if (basicNode2.hide) {
                return;
            }
            boolean bl = this.inNodeName(graphics, n2, basicNode2, true);
            boolean bl2 = this.inLogo(basicNode2, n2);
            if (!bl) {
                this.onMouseMoved(basicNode2, bl);
                basicNode = this.nodeTab[this.oHilightNode];
                this.oHilightNode = -1;
                this.ancienCurNode = null;
                this.drawNodeName(graphics, basicNode, true);
                if (!basicNode.isSelected() && this.lastPosInLogo) {
                    this.drawPreCheckBox(graphics, basicNode.x - 22, basicNode.y, basicNode, true);
                }
                this.lastPosInLogo = bl2;
                return;
            }
            if (!(!bl2 || basicNode2.isSelected() || this.lastPosInLogo && basicNode2 == this.ancienCurNode)) {
                this.drawPreCheckBox(graphics, basicNode2.x - 22, basicNode2.y, basicNode2, false);
            } else if (!bl2 && !basicNode2.isSelected() && this.lastPosInLogo) {
                this.drawPreCheckBox(graphics, basicNode2.x - 22, basicNode2.y, basicNode2, true);
            }
            if (this.ancienCurNode == basicNode2) {
                this.lastPosInLogo = bl2;
                return;
            }
            if (this.ancienCurNode != null && !this.ancienCurNode.isSelected() && this.lastPosInLogo) {
                this.drawPreCheckBox(graphics, this.ancienCurNode.x - 22, this.ancienCurNode.y, this.ancienCurNode, true);
            }
            this.ancienCurNode = basicNode2;
            n = this.oHilightNode;
            this.oHilightNode = this.hilightNode;
            this.drawNodeName(graphics, basicNode2, true);
            this.lastPosInLogo = bl2;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return;
        }
        this.onMouseMoved(basicNode2, true);
        if (n != this.hilightNode) {
            try {
                basicNode = this.nodeTab[n];
                this.drawNodeName(graphics, basicNode, true);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
        }
    }

    void traverseTree() {
        this.hasSpectraOrImages = false;
        this.nodeFullList = new Vector();
        this.maxWidth = this.initMaxWidth();
        this.recTraverseTree(this.rootNode, 0);
        this.nodeFullTab = new BasicNode[this.nodeFullList.size()];
        this.nodeFullList.copyInto(this.nodeFullTab);
        this.prefWidth = this.maxWidth + 5;
        if (this.scroll != null) {
            JViewport jViewport = this.scroll.getViewport();
            JScrollBar jScrollBar = this.scroll.getVerticalScrollBar();
            int n = jViewport.getWidth() + (jScrollBar.isVisible() ? 0 : jScrollBar.getWidth());
            if (this.prefWidth < n) {
                this.prefWidth = n;
            }
        }
        this.createPopup();
    }

    protected int initMaxWidth() {
        return 0;
    }

    private void recTraverseTree(BasicNode basicNode, int n) {
        this.nodeFullList.addElement(basicNode);
        n += 22;
        if (!(this.hasSpectraOrImages || ((ResourceNode)basicNode).type != 3 && ((ResourceNode)basicNode).type != 1)) {
            this.hasSpectraOrImages = true;
        }
        this.tmpSize = fm.stringWidth(this.getName(basicNode));
        this.tmpSize = !this.flatView ? (this.tmpSize += n) : (this.tmpSize += 44);
        if (this.tmpSize > this.maxWidth) {
            this.maxWidth = this.tmpSize;
        }
        Enumeration enumeration = basicNode.getChildren();
        while (enumeration.hasMoreElements()) {
            BasicNode basicNode2 = (BasicNode)enumeration.nextElement();
            this.recTraverseTree(basicNode2, n);
        }
    }

    public BasicNode searchNodeByName(String string) {
        for (int i = 0; i < this.nodeFullTab.length; ++i) {
            if (!this.nodeFullTab[i].name.equals(string)) continue;
            return this.nodeFullTab[i];
        }
        return null;
    }

    public void setFlat(boolean bl) {
        this.flatView = bl;
        if (!((ResourceNode)this.rootNode).isSIAPEvol) {
            this.popupPrefs.remove(this.popupPrefs.getComponentCount() - 1);
            this.popupPrefs.add(this.flatView ? HIER_VIEW : FLAT_VIEW);
        } else {
            this.popupPrefs.remove(this.popupPrefs.getComponentCount() - 1);
            this.popupPrefs.remove(this.popupPrefs.getComponentCount() - 1);
            this.popupPrefs.remove(this.popupPrefs.getComponentCount() - 1);
            this.popupPrefs.add(this.flatView ? this.createItem(HIER_VIEW) : this.createItem(FLAT_VIEW));
            this.popupPrefs.addSeparator();
            this.popupPrefs.add(SIAP_EVOL_SORT);
        }
        this.traverseTree();
        this.repaint();
        if (this.scroll != null) {
            this.scroll.validate();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(DELETE)) {
            this.removeNode(this.selectedNode);
            this.repaint();
        } else if (string.equals(COLLAPSE_SUBTREE)) {
            this.setAllNodes(this.selectedNode, false);
            this.repaint();
        } else if (string.equals(EXPAND_SUBTREE)) {
            this.setAllNodes(this.selectedNode, true);
            this.repaint();
        } else if (string.equals(COLLAPSE_ALL)) {
            this.setAllNodes(this.rootNode, false);
            this.repaint();
        } else if (string.equals(EXPAND_ALL)) {
            this.setAllNodes(this.rootNode, true);
            this.repaint();
        } else if (string.equals(FLAT_VIEW) || string.equals(HIER_VIEW)) {
            this.setFlat(!this.flatView);
        }
    }

    private void removeNode(BasicNode basicNode) {
        if (basicNode == null) {
            return;
        }
        boolean bl = basicNode.getParent().removeChild(basicNode);
        this.onNodeRemoved(basicNode);
        if (bl) {
            this.traverseTree();
        }
        this.repaint();
    }

    protected boolean isEmpty() {
        return this.rootNode.nbChildren == 0;
    }

    public Vector getSelectedLeaves() {
        Vector vector = new Vector();
        this.recGetSelectedLeaves(this.rootNode, vector);
        return vector;
    }

    private void recGetSelectedLeaves(BasicNode basicNode, Vector vector) {
        if (basicNode.isSelected()) {
            vector.addElement(basicNode);
        }
        if (basicNode.isOpen || this.flatView) {
            Enumeration enumeration = basicNode.getChildren();
            while (enumeration.hasMoreElements()) {
                this.recGetSelectedLeaves((BasicNode)enumeration.nextElement(), vector);
            }
        }
    }

    public void openAllNodes(BasicNode basicNode) {
        this.setAllNodes(basicNode, true);
    }

    public void setAllNodes(BasicNode basicNode, boolean bl) {
        this.recSetAllNodes(basicNode, bl);
    }

    private void recSetAllNodes(BasicNode basicNode, boolean bl) {
        if (basicNode != this.rootNode) {
            basicNode.isOpen = bl;
        }
        Enumeration enumeration = basicNode.getChildren();
        while (enumeration.hasMoreElements()) {
            this.recSetAllNodes((BasicNode)enumeration.nextElement(), bl);
        }
    }

    protected static void getAllLeaves(BasicNode basicNode, Vector vector) {
        Enumeration enumeration = basicNode.getChildren();
        while (enumeration.hasMoreElements()) {
            BasicNode basicNode2 = (BasicNode)enumeration.nextElement();
            if (basicNode2.isLeaf) {
                vector.addElement(basicNode2);
            }
            BasicTree.getAllLeaves(basicNode2, vector);
        }
    }

    protected static void getAllObs(BasicNode basicNode, Vector vector) {
        Enumeration enumeration = basicNode.getChildren();
        while (enumeration.hasMoreElements()) {
            BasicNode basicNode2 = (BasicNode)enumeration.nextElement();
            if (basicNode2.isObs) {
                vector.addElement(basicNode2);
            }
            BasicTree.getAllObs(basicNode2, vector);
        }
    }

    protected static void getAllNonLeaves(BasicNode basicNode, Vector vector) {
        Enumeration enumeration = basicNode.getChildren();
        while (enumeration.hasMoreElements()) {
            BasicNode basicNode2 = (BasicNode)enumeration.nextElement();
            if (!basicNode2.isLeaf) {
                vector.addElement(basicNode2);
            }
            BasicTree.getAllNonLeaves(basicNode2, vector);
        }
    }

    protected void getAllSubnodes(BasicNode basicNode, Vector vector) {
        Enumeration enumeration = basicNode.getChildren();
        while (enumeration.hasMoreElements()) {
            BasicNode basicNode2 = (BasicNode)enumeration.nextElement();
            vector.addElement(basicNode2);
            this.getAllSubnodes(basicNode2, vector);
        }
    }

    protected void resetCb() {
        for (int i = 0; i < this.nodeFullTab.length; ++i) {
            if (!this.nodeFullTab[i].isLeaf) continue;
            this.nodeFullTab[i].isSelected = false;
        }
        this.oHilightNode = -1;
        this.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        try {
            BasicNode basicNode;
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            Graphics graphics = this.getGraphics();
            if (this.triggerOnNodeSelected) {
                this.onNodeSelected(this.nodeToTrigger);
                this.triggerOnNodeSelected = false;
            }
            try {
                basicNode = this.nodeTab[n2 / 18];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                if ((mouseEvent.getModifiers() & 4) != 0) {
                    this.onRightClickOutNode(n, n2);
                }
                return;
            }
            if (basicNode.hide) {
                if ((mouseEvent.getModifiers() & 4) != 0) {
                    this.onRightClickOutNode(n, n2);
                }
                return;
            }
            boolean bl = this.inLogo(basicNode, n);
            boolean bl2 = this.inNodeName(graphics, n, basicNode);
            if (!bl && (mouseEvent.getModifiers() & 4) != 0) {
                if (bl2) {
                    this.onRightClickInNode(basicNode, n, n2);
                } else {
                    this.onRightClickOutNode(n, n2);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        this.oselectedNode = this.selectedNode;
        try {
            this.selectedNode = this.nodeTab[n2 / 18];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return;
        }
        if (this.selectedNode.hide) {
            return;
        }
        if (this.selectedNode == this.rootNode && this.flatView) {
            return;
        }
        Graphics graphics = this.getGraphics();
        boolean bl = this.inLogo(this.selectedNode, n);
        boolean bl2 = this.inNodeName(graphics, n, this.selectedNode);
        if (!bl && (mouseEvent.getModifiers() & 4) != 0) {
            return;
        }
        if (!bl && bl2) {
            if (mouseEvent.getClickCount() > 1) {
                this.onNodeSelectedDbleClick(this.selectedNode);
            } else {
                this.triggerOnNodeSelected = true;
                this.nodeToTrigger = this.selectedNode;
            }
        }
        if (!this.selectedNode.equals(this.lastInfoNode) && !bl && bl2) {
            BasicNode basicNode = this.lastInfoNode;
            this.lastInfoNode = this.selectedNode;
            try {
                this.drawNodeName(graphics, this.selectedNode, true);
                if (basicNode != null && !basicNode.hide && this.nodeTab[basicNode.y / 18].equals(basicNode)) {
                    this.drawNodeName(graphics, basicNode, true);
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
        }
        if (this.selectedNode.isLeaf) {
            if (bl) {
                this.selectedNode.isSelected = !this.selectedNode.isSelected;
                this.drawCheckBox(graphics, this.selectedNode.x - 22, this.selectedNode.y, this.selectedNode, true);
            }
            this.repaint();
        } else {
            if (bl) {
                this.selectedNode.changeState();
                if (this.selectedNode.isOpen) {
                    this.onNodeExpanded(this.selectedNode);
                } else {
                    this.onNodeCollapsed(this.selectedNode);
                }
            }
            this.repaint();
        }
    }

    private boolean inLogo(BasicNode basicNode, int n) {
        int n2 = basicNode.level * 22;
        int n3 = basicNode.level * 22 + 2 + 12;
        return n >= n2 && n <= n3;
    }

    BasicNode getRootNode() {
        return this.rootNode;
    }

    void setRootNode(BasicNode basicNode) {
        basicNode.isLeaf = false;
        this.rootNode = basicNode;
        this.createPopup();
    }

    @Override
    public Dimension getSize() {
        this.majSize();
        return new Dimension(this.prefWidth, this.prefHeight);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getSize();
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getSize();
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        this.init(graphics);
        if (this.mustSetLocation) {
            // empty if block
        }
        this.mustSetLocation = true;
    }

    protected void setAllowSortByFields(boolean bl) {
        this.allowSortByFields = bl;
    }

    protected void onNodeExpanded(BasicNode basicNode) {
    }

    protected void onNodeCollapsed(BasicNode basicNode) {
    }

    protected void onNodeSelected(BasicNode basicNode) {
    }

    protected void onNodeSelectedDbleClick(BasicNode basicNode) {
    }

    protected void onNodeRemoved(BasicNode basicNode) {
    }

    protected void onMouseMoved(BasicNode basicNode, boolean bl) {
    }

    protected void onRightClickInNode(BasicNode basicNode, int n, int n2) {
        this.popup.show(this, n, n2);
    }

    protected void onRightClickOutNode(int n, int n2) {
        this.popupPrefs.show(this, n, n2);
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    protected JScrollPane getScroll() {
        return this.scroll;
    }

    protected void setScroll(JScrollPane jScrollPane) {
        this.scroll = jScrollPane;
        this.scroll.getVerticalScrollBar().setUnitIncrement(18);
    }
}

