/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.ColFilter;
import cds.aladin.FilterProperties;
import cds.aladin.Legende;
import cds.aladin.LocalXMatch;
import cds.aladin.Obj;
import cds.aladin.Pcat;
import cds.aladin.Plan;
import cds.aladin.PlanCatalog;
import cds.aladin.Source;
import cds.aladin.Tok;
import cds.aladin.XMatchResult;
import cds.astro.Astrocoo;
import cds.astro.Unit;
import cds.tools.Util;
import cds.xml.Field;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public final class CDSXMatch {
    static final int BESTMATCH = 1;
    static final int ALLMATCH = 2;
    static final int NOMATCH = 4;
    static final int POSXMATCH = 1;
    static final int JOIN = 2;
    static final int POSXMATCH_ELLIPSES = 3;
    private ColFilter colFilter;
    private Aladin aladin;
    static int xMatchNb = 0;
    private static Astrocoo frame = new Astrocoo();
    private static final String UCD_DIST = "POS_ANG_DIST_GENERAL";
    private static final String UCD_SIGMA = "stat.stdev";
    private static final String DEFAULT_PREFIX_T1 = "";
    private static final String DEFAULT_PREFIX_T2 = "";
    private static final String DEFAULT_SUFFIX_T1 = "_tab1";
    private static final String DEFAULT_SUFFIX_T2 = "_tab2";
    int[] idxColToKeep1;
    int[] idxColToKeep2;
    static final String UCD_RA = "POS_EQ_RA";
    static final String UCD_DEC = "POS_EQ_DEC";
    static final String UCD1PLUS_RA = "pos.eq.ra";
    static final String UCD1PLUS_DEC = "pos.eq.dec";

    protected CDSXMatch(Aladin aladin) {
        this.aladin = aladin;
    }

    public void xID(Plan plan, Plan plan2, String string, int n, int n2, Aladin aladin) {
        double d = System.currentTimeMillis();
        PlanCatalog planCatalog = this.initPlaneCreation(plan, string);
        String[] stringArray = new String[plan.getCounts()];
        this.fillXIDArray(plan.pcat, stringArray, n);
        String[] stringArray2 = new String[plan2.getCounts()];
        this.fillXIDArray(plan2.pcat, stringArray2, n2);
        double d2 = System.currentTimeMillis();
        Aladin.trace(3, "Total time for extracting fields : " + (d2 - d));
        XMatchResult[] xMatchResultArray = LocalXMatch.xID(stringArray, stringArray2);
        double d3 = System.currentTimeMillis();
        Aladin.trace(3, "Total time for xid : " + (d3 - d2));
        this.fillResultPlane(planCatalog, xMatchResultArray, plan, plan2, null, null, 2);
        aladin.log("xmatch", "xid");
    }

    private void fillXIDArray(Pcat pcat, String[] stringArray, int n) {
        Iterator<Obj> iterator = pcat.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            Source source = (Source)iterator.next();
            stringArray[n2] = source.getValue(n);
            ++n2;
        }
    }

    public void posXMatch(Plan plan, Plan plan2, String string, int[] nArray, int[] nArray2, double[] dArray, int n, Aladin aladin) {
        this.posXMatch(plan, plan2, string, nArray, nArray2, dArray, n, aladin, false);
    }

    public void posXMatch(Plan plan, Plan plan2, String string, int[] nArray, int[] nArray2, double[] dArray, int n, Aladin aladin, boolean bl) {
        double d = System.currentTimeMillis();
        if (nArray == null && (nArray = CDSXMatch.findCoord(plan)) == null) {
            Aladin.warning(Aladin.chaine.getString("NOCOOR") + " " + plan.label);
            return;
        }
        if (nArray2 == null && (nArray2 = CDSXMatch.findCoord(plan2)) == null) {
            Aladin.warning(Aladin.chaine.getString("NOCOOR") + " " + plan2.label);
            return;
        }
        PlanCatalog planCatalog = this.initPlaneCreation(plan, string);
        double[][] dArray2 = new double[plan.getCounts()][2];
        boolean[] blArray = new boolean[plan.getCounts()];
        CDSXMatch.fillXMatchArray(plan.pcat, dArray2, nArray, blArray);
        double[][] dArray3 = new double[plan2.getCounts()][2];
        boolean[] blArray2 = new boolean[plan2.getCounts()];
        CDSXMatch.fillXMatchArray(plan2.pcat, dArray3, nArray2, blArray2);
        if (!bl) {
            aladin.console.printCommand("xmatch " + Tok.quote(plan.label) + " " + Tok.quote(plan2.label) + " " + dArray[1]);
        }
        double d2 = System.currentTimeMillis();
        Aladin.trace(3, "Total time for extracting coordinates : " + (d2 - d));
        XMatchResult[] xMatchResultArray = LocalXMatch.xMatch(dArray2, dArray3, blArray, blArray2, dArray, n);
        double d3 = System.currentTimeMillis();
        Aladin.trace(3, "Total time for xmatch : " + (d3 - d2));
        this.fillResultPlane(planCatalog, xMatchResultArray, plan, plan2, nArray, dArray2, 1);
        Aladin.trace(3, "Total time for creation of the plane : " + ((double)System.currentTimeMillis() - d3));
        aladin.log("xmatch", "positional");
    }

    public void posXMatchEllipses(Plan plan, Plan plan2, String string, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, double d, double d2, int n, Aladin aladin) {
        double d3 = System.currentTimeMillis();
        if (nArray == null && (nArray = CDSXMatch.findCoord(plan)) == null) {
            Aladin.warning("Coordinates columns not found for plane " + plan.label);
            return;
        }
        if (nArray2 == null && (nArray2 = CDSXMatch.findCoord(plan2)) == null) {
            Aladin.warning("Coordinates columns not found for plane " + plan2.label);
            return;
        }
        PlanCatalog planCatalog = this.initPlaneCreation(plan, string);
        double[][] dArray = new double[plan.getCounts()][2];
        boolean[] blArray = new boolean[plan.getCounts()];
        CDSXMatch.fillXMatchArray(plan.pcat, dArray, nArray, blArray);
        double[][] dArray2 = new double[plan2.getCounts()][2];
        boolean[] blArray2 = new boolean[plan2.getCounts()];
        CDSXMatch.fillXMatchArray(plan2.pcat, dArray2, nArray2, blArray2);
        double[] dArray3 = new double[plan.getCounts()];
        double[] dArray4 = new double[plan.getCounts()];
        double[] dArray5 = new double[plan.getCounts()];
        CDSXMatch.fillEllipsesParamArray(plan.pcat, dArray3, dArray4, dArray5, nArray3, blArray);
        double[] dArray6 = new double[plan2.getCounts()];
        double[] dArray7 = new double[plan2.getCounts()];
        double[] dArray8 = new double[plan2.getCounts()];
        CDSXMatch.fillEllipsesParamArray(plan2.pcat, dArray6, dArray7, dArray8, nArray4, blArray2);
        double d4 = System.currentTimeMillis();
        Aladin.trace(3, "Total time for extracting coordinates : " + (d4 - d3));
        XMatchResult[] xMatchResultArray = LocalXMatch.xMatchEllipse(dArray, dArray2, dArray3, dArray4, dArray5, dArray6, dArray7, dArray8, blArray, blArray2, new double[]{d, d2}, n);
        double d5 = System.currentTimeMillis();
        Aladin.trace(3, "Total time for ellipses xmatch : " + (d5 - d4));
        this.fillResultPlane(planCatalog, xMatchResultArray, plan, plan2, nArray, dArray, 3);
        aladin.log("xmatch", "ellipses");
    }

    private static void fillXMatchArray(Pcat pcat, double[][] dArray, int[] nArray, boolean[] blArray) {
        Iterator<Obj> iterator = pcat.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Source source = (Source)iterator.next();
            try {
                String string = source.getValue(nArray[0]);
                if (CDSXMatch.isSexa(string)) {
                    string = CDSXMatch.sexa2Deg(string, true);
                }
                dArray[n][0] = Double.valueOf(string);
                string = source.getValue(nArray[1]);
                if (CDSXMatch.isSexa(string)) {
                    string = CDSXMatch.sexa2Deg(string, false);
                }
                dArray[n][1] = Double.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
                blArray[n] = true;
            }
            catch (NullPointerException nullPointerException) {
                nullPointerException.printStackTrace();
                blArray[n] = true;
            }
            ++n;
        }
    }

    private static void fillEllipsesParamArray(Pcat pcat, double[] dArray, double[] dArray2, double[] dArray3, int[] nArray, boolean[] blArray) {
        double d;
        double d2;
        double d3;
        Unit unit;
        Source source = (Source)pcat.iterator().next();
        Unit unit2 = null;
        Unit unit3 = null;
        Unit unit4 = null;
        Unit unit5 = null;
        try {
            unit2 = new Unit("1 deg");
            unit3 = new Unit("1 arcsec");
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        try {
            unit = new Unit(unit3);
            unit5 = new Unit("1 " + source.getUnit(nArray[0]));
            unit.convertFrom(unit5);
            d3 = unit.getValue();
        }
        catch (ParseException parseException) {
            d3 = 1.0;
        }
        catch (ArithmeticException arithmeticException) {
            d3 = 1.0;
        }
        System.out.println("facteur pour MAJ : " + d3);
        try {
            unit = new Unit(unit3);
            Unit unit6 = new Unit("1 " + source.getUnit(nArray[1]));
            unit.convertFrom(unit6);
            d2 = unit.getValue();
        }
        catch (ParseException parseException) {
            d2 = 1.0;
        }
        catch (ArithmeticException arithmeticException) {
            d2 = 1.0;
        }
        System.out.println("facteur pour MIN : " + d2);
        try {
            unit4 = new Unit(unit2);
            Unit unit7 = new Unit("1 " + source.getUnit(nArray[2]));
            unit4.convertFrom(unit7);
            d = unit4.getValue();
        }
        catch (ParseException parseException) {
            d = 1.0;
        }
        catch (ArithmeticException arithmeticException) {
            d = 1.0;
        }
        System.out.println("facteur pour PA : " + d);
        Iterator<Obj> iterator = pcat.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Source source2 = (Source)iterator.next();
            try {
                String string = source2.getValue(nArray[0]);
                dArray[n] = d3 * Double.valueOf(string);
                try {
                    string = source2.getValue(nArray[1]);
                    dArray2[n] = d2 * Double.valueOf(string);
                }
                catch (NumberFormatException numberFormatException) {
                    dArray2[n] = dArray[n];
                }
                try {
                    string = source2.getValue(nArray[2]);
                    dArray3[n] = d * Double.valueOf(string);
                }
                catch (NumberFormatException numberFormatException) {
                    dArray3[n] = 0.0;
                }
            }
            catch (NumberFormatException numberFormatException) {
                blArray[n] = true;
                dArray3[n] = 0.0;
                dArray2[n] = 0.0;
                dArray[n] = 0.0;
            }
            ++n;
        }
    }

    private static String sexa2Deg(String string, boolean bl) {
        String string2 = bl ? string + " +0 0 0.0" : "0 0 0.0 " + string;
        try {
            frame.set(string2);
        }
        catch (Exception exception) {
            return "0";
        }
        return bl ? frame.getLon() + "" : frame.getLat() + "";
    }

    private static boolean isSexa(String string) {
        char[] cArray = string.toCharArray();
        int n = 0;
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] == ':' || cArray[i] == ' ' || cArray[i] == '\t') {
                ++n;
            }
            if (n < 1) continue;
            return true;
        }
        return false;
    }

    private void ucdRewriting(Legende legende) {
        Field[] fieldArray = legende.field;
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < fieldArray.length; ++i) {
            String string;
            int n;
            String string2 = fieldArray[i].ucd;
            if (string2 == null || (n = (string = string2.toLowerCase()).indexOf("_main")) < 0 && (n = string.indexOf(";meta.main")) < 0) continue;
            if (!vector.contains(string)) {
                vector.addElement(string);
                continue;
            }
            fieldArray[i].ucd = string2.substring(0, n);
        }
    }

    private PlanCatalog initPlaneCreation(Plan plan, String string) {
        ++xMatchNb;
        int n = this.aladin.calque.newPlanCatalog();
        PlanCatalog planCatalog = (PlanCatalog)this.aladin.calque.plan[n];
        planCatalog.param = "xmatch";
        planCatalog.setLabel(string != null ? string : "XMatch");
        planCatalog.objet = plan.objet != null ? plan.objet : "";
        planCatalog.flagOk = false;
        this.aladin.calque.select.repaint();
        return planCatalog;
    }

    private void fillResultPlane(PlanCatalog planCatalog, XMatchResult[] xMatchResultArray, Plan plan, Plan plan2, int[] nArray, double[][] dArray, int n) {
        ArrayList<Source> arrayList;
        Object object;
        boolean bl = n == 3;
        Obj[] objArray = plan.pcat.getObj();
        Obj[] objArray2 = plan2.pcat.getObj();
        Legende legende = null;
        Hashtable<Object, Legende> hashtable = new Hashtable<Object, Legende>();
        Legende legende2 = null;
        Legende legende3 = null;
        Hashtable<Legende, ArrayList<Source>> hashtable2 = new Hashtable<Legende, ArrayList<Source>>();
        Source source = null;
        for (int i = 0; i < xMatchResultArray.length; ++i) {
            Source source2;
            int n2 = xMatchResultArray[i].idx1;
            int n3 = xMatchResultArray[i].idx2;
            double d = xMatchResultArray[i].dist;
            Source source3 = (Source)objArray[n2];
            Source source4 = source2 = d == -1.0 ? null : (Source)objArray2[n3];
            if (legende3 == null || legende2 == null || source3.leg != legende3 || source2 != null && source2.leg != legende2) {
                legende3 = source3.leg;
                legende2 = source2 == null ? null : source2.leg;
                object = source3.leg.toString() + (source2 == null ? "null" : source2.leg.toString());
                legende = (Legende)hashtable.get(object);
                if (legende == null) {
                    legende = this.createLeg(n, bl, source3, source2, nArray);
                    hashtable.put(object, legende);
                }
            }
            String string = n == 2 ? "<&_getReadMe " + planCatalog.label + " >\t" + this.getOnlyInfo((Source)objArray[n2], true) + "\t" + this.getOnlyInfo((Source)objArray2[n3], false) : (d == -1.0 ? "<&_getReadMe " + planCatalog.label + " >\t" + Util.round(d, 4) + "\t" + this.getOnlyInfo((Source)objArray[n2], true) : "<&_getReadMe " + planCatalog.label + " >\t" + Util.round(d, 4) + "\t" + this.getOnlyInfo((Source)objArray[n2], true) + "\t" + this.getOnlyInfo((Source)objArray2[n3], false));
            if (dArray == null) {
                object = (Source)objArray[n2];
                source = new Source(planCatalog, ((Source)object).raj, ((Source)object).dej, "", string, legende);
            } else {
                source = new Source(planCatalog, dArray[n2][0], dArray[n2][1], "", string, legende);
            }
            arrayList = (ArrayList)hashtable2.get(legende);
            if (arrayList == null) {
                arrayList = new ArrayList<Source>();
                hashtable2.put(legende, arrayList);
            }
            arrayList.add(source);
        }
        Enumeration enumeration = hashtable2.elements();
        while (enumeration.hasMoreElements()) {
            arrayList = (ArrayList<Source>)enumeration.nextElement();
            object = arrayList.iterator();
            while (object.hasNext()) {
                planCatalog.pcat.setObjetFast((Obj)object.next());
            }
        }
        planCatalog.setSourceType(Source.getDefaultType(xMatchResultArray.length));
        planCatalog.setActivated(true);
        planCatalog.flagOk = true;
        this.aladin.calque.select.repaint();
        this.aladin.view.repaintAll();
        FilterProperties.notifyNewPlan();
    }

    private Legende createLeg(int n, boolean bl, Source source, Source source2, int[] nArray) {
        Object object;
        Vector<Field> vector = new Vector<Field>();
        if (n != 2) {
            object = bl ? new Field("NSigma") : new Field("dist");
            ((Field)object).ucd = bl ? UCD_SIGMA : UCD_DIST;
            ((Field)object).datatype = "D";
            ((Field)object).description = bl ? "Distance in sigmas" : "Distance between 2 cross-matched sources";
            ((Field)object).unit = bl ? "---" : "arcsec";
            ((Field)object).width = "7";
            ((Field)object).computeColumnSize();
            vector.addElement((Field)object);
        }
        object = source;
        String string = this.colFilter == null ? "" : this.colFilter.prefix1;
        String string2 = this.colFilter == null ? DEFAULT_SUFFIX_T1 : this.colFilter.suffix1;
        this.addField(true, (Source)object, vector, string, string2, nArray, true);
        object = source2;
        string = this.colFilter == null ? "" : this.colFilter.prefix2;
        String string3 = string2 = this.colFilter == null ? DEFAULT_SUFFIX_T2 : this.colFilter.suffix2;
        if (object != null) {
            this.addField(false, (Source)object, vector, string, string2, null, false);
        }
        Legende legende = new Legende(vector);
        this.ucdRewriting(legende);
        return legende;
    }

    private String getOnlyInfo(Source source, boolean bl) {
        int n = source.info.indexOf(9);
        String string = n >= 0 ? source.info.substring(n + 1) : source.info;
        if (this.colFilter != null) {
            int[] nArray = bl ? this.idxColToKeep1 : this.idxColToKeep2;
            String[] stringArray = Util.split(string, "\t", ':', ':');
            string = "";
            for (int i = 0; i < nArray.length; ++i) {
                string = string + stringArray[nArray[i]];
                if (i >= nArray.length - 1) continue;
                string = string + "\t";
            }
        }
        return string;
    }

    private void addField(boolean bl, Source source, Vector<Field> vector, String string, String string2, int[] nArray, boolean bl2) {
        if (bl) {
            this.idxColToKeep1 = null;
        } else {
            this.idxColToKeep2 = null;
        }
        if (this.colFilter != null) {
            if (bl) {
                this.idxColToKeep1 = new int[this.colFilter.fieldTab1.length];
            } else {
                this.idxColToKeep2 = new int[this.colFilter.fieldTab2.length];
            }
        }
        int n = 0;
        for (int i = 0; i < source.leg.field.length; ++i) {
            Field field = source.leg.field[i];
            boolean bl3 = true;
            if (this.colFilter != null && (bl3 = bl ? this.colFilter.inTab1(field.name) : this.colFilter.inTab2(field.name))) {
                if (bl) {
                    this.idxColToKeep1[n++] = i;
                } else {
                    this.idxColToKeep2[n++] = i;
                }
            }
            if (!bl3) continue;
            Field field2 = new Field("");
            field2.ID = field.ID;
            field2.name = string + field.name + string2;
            field2.description = field.description;
            field2.title = string + field.title + string2;
            field2.type = field.type;
            field2.unit = field.unit;
            field2.ucd = this.colFilter != null ? (bl ? this.colFilter.getUcdTab1(field.name) : this.colFilter.getUcdTab2(field.name)) : field.ucd;
            field2.datatype = field.datatype;
            field2.width = field.width;
            field2.nullValue = field.nullValue;
            field2.arraysize = field.arraysize;
            field2.columnSize = field.columnSize;
            field2.precision = field.precision;
            field2.href = field.href;
            field2.gref = field.gref;
            field2.refText = field.refText;
            field2.refValue = field.refValue;
            if (bl2 && nArray != null && i == nArray[0]) {
                field2.coo = 1;
            }
            if (bl2 && nArray != null && i == nArray[1]) {
                field2.coo = 2;
            }
            vector.addElement(field2);
        }
    }

    protected static int[] findCoord(Plan plan) {
        Field[] fieldArray = plan.getFirstLegende().field;
        boolean bl = false;
        boolean bl2 = false;
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        for (int i = 0; !(i >= fieldArray.length || bl && bl2); ++i) {
            String string;
            String string2 = fieldArray[i].ucd;
            String string3 = string = string2 == null ? null : string2.toLowerCase();
            if (!bl && string2 != null && (string.startsWith(UCD1PLUS_RA) || string2.startsWith(UCD_RA))) {
                bl = true;
                n = i;
            } else if (!bl2 && string2 != null && (string.startsWith(UCD1PLUS_DEC) || string2.startsWith(UCD_DEC))) {
                bl2 = true;
                n2 = i;
            }
            String string4 = fieldArray[i].name;
            if (string4 == null) continue;
            if ((string4 = string4.toLowerCase()).startsWith("_")) {
                string4 = string4.substring(1);
            }
            if (n3 < 0 && (string4.startsWith("ra") || string4.startsWith("alpha"))) {
                n3 = i;
                continue;
            }
            if (n4 >= 0 || !string4.startsWith("de") && !string4.startsWith("delta")) continue;
            n4 = i;
        }
        if (bl && bl2) {
            return new int[]{n, n2};
        }
        if (n3 >= 0 && n4 >= 0) {
            return new int[]{n3, n4};
        }
        return null;
    }

    protected static int findIdx(Plan plan, String[] stringArray) {
        int n;
        if (stringArray == null || stringArray.length == 0) {
            return -1;
        }
        Field[] fieldArray = plan.getFirstLegende().field;
        int[] nArray = new int[stringArray.length];
        int n2 = 0;
        for (n = 0; n < stringArray.length; ++n) {
            stringArray[n] = stringArray[n].toLowerCase();
            nArray[n] = -1;
        }
        block1: for (n = 0; n < fieldArray.length && nArray[0] < 0 && n2 < stringArray.length; ++n) {
            String string = fieldArray[n].ucd;
            if (string == null) continue;
            string = string.toLowerCase();
            for (int i = 0; i < stringArray.length; ++i) {
                if (nArray[i] >= 0 || !stringArray[i].equals(string)) continue;
                nArray[i] = n;
                ++n2;
                continue block1;
            }
        }
        for (n = 0; n < nArray.length; ++n) {
            if (nArray[n] < 0) continue;
            return nArray[n];
        }
        return -1;
    }

    protected void setColFilter(ColFilter colFilter) {
        this.colFilter = colFilter;
    }
}

