/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.MyInputStream;
import cds.tools.Util;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.URL;
import java.util.Vector;

public final class Cache
implements Runnable {
    private Aladin aladin;
    private String dir = null;
    static final String CACHE = "Cache";
    static final int WAIT = 10000;
    static final int OUTOFDATE = 86400000;
    private Vector todo;
    boolean cacheLock = false;
    private Thread thread = null;
    private static char PREFIX = (char)95;
    static final String HEX = "0123456789ABCDEF";

    protected Cache(Aladin aladin) {
        this.aladin = aladin;
        if (!aladin.createCache()) {
            return;
        }
        this.dir = Cache.getCacheDir();
        File file = new File(this.dir);
        if (!file.isDirectory() && !file.mkdir()) {
            this.dir = null;
            return;
        }
        this.todo = new Vector();
    }

    static String getCacheDir() {
        return System.getProperty("user.home") + Util.FS + Aladin.CACHE + Util.FS + CACHE;
    }

    void clear() {
        if (!this.isAvailable()) {
            return;
        }
        try {
            this.cacheLock = true;
            File file = new File(this.dir);
            String[] stringArray = file.list();
            for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
                try {
                    new File(this.dir + Util.FS + stringArray[i]).delete();
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.cacheLock = false;
        Aladin.trace(3, "Clear cache");
    }

    protected boolean isAvailable() {
        while (this.cacheLock) {
            try {
                Util.pause(100);
            }
            catch (Exception exception) {}
        }
        return this.dir != null;
    }

    public InputStream get(URL uRL) throws Exception {
        return this.get(uRL.toString());
    }

    public InputStream get(String string) throws Exception {
        if (!this.isAvailable()) {
            return Util.openStream(string);
        }
        String string2 = Cache.codage(string);
        File file = new File(this.dir + Util.FS + string2);
        if (file.isFile() && file.canRead() && file.length() > 0L) {
            if (this.outOfDate(file)) {
                this.add(string);
            }
            Aladin.trace(3, "[" + string + "] read in cache !");
            return new FileInputStream(file);
        }
        if (this.putInCache(string)) {
            return this.get(string);
        }
        System.err.println("Caching not available for [" + string + "] !!!");
        return Util.openStream(string);
    }

    public InputStream getWithBackup(String string) throws Exception {
        if (!this.isAvailable()) {
            return Util.openStream(string);
        }
        Exception exception = null;
        MyInputStream myInputStream = null;
        try {
            myInputStream = Util.openStream(string);
            if (myInputStream == null) {
                throw new Exception("cache openStream error");
            }
        }
        catch (Exception exception2) {
            myInputStream = null;
            exception = exception2;
        }
        String string2 = Cache.codage(string);
        File file = new File(this.dir + Util.FS + string2);
        if (myInputStream != null) {
            if (!file.isFile() || this.outOfDate(file)) {
                this.add(string);
            }
            return myInputStream;
        }
        if (file.isFile() && file.canRead() && file.length() > 0L) {
            Aladin.trace(3, "[" + string + "] backup from cache !");
            return new FileInputStream(file);
        }
        throw exception;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean putInCache(String string) throws Exception {
        MyInputStream myInputStream = null;
        try {
            myInputStream = Util.openStream(string);
            byte[] byArray = myInputStream.readFully();
            String string2 = Cache.codage(string);
            File file = new File(this.dir + Util.FS + string2);
            file.delete();
            RandomAccessFile randomAccessFile = null;
            try {
                randomAccessFile = new RandomAccessFile(this.dir + Util.FS + string2, "rw");
                randomAccessFile.write(byArray);
            }
            finally {
                if (randomAccessFile != null) {
                    randomAccessFile.close();
                }
            }
            Aladin.trace(3, "Put in cache [" + string + "]");
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            if (Aladin.levelTrace >= 3) {
                exception.printStackTrace();
            }
        }
        finally {
            if (myInputStream != null) {
                myInputStream.close();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCache() {
        Vector vector;
        Aladin.trace(2, "Start cache updater...");
        Object object = this;
        synchronized (object) {
            vector = (Vector)this.todo.clone();
            this.todo.clear();
        }
        object = vector.elements();
        while (object.hasMoreElements()) {
            String string = (String)object.nextElement();
            try {
                this.putInCache(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Util.pause(1000);
        }
        this.fin();
    }

    private synchronized void add(String string) {
        Aladin.trace(3, "Add [" + string + "] for cache upgrade");
        this.todo.addElement(string);
        this.startThread();
    }

    private synchronized void fin() {
        this.thread = null;
    }

    private synchronized void startThread() {
        if (!Aladin.NETWORK) {
            return;
        }
        if (this.thread != null) {
            return;
        }
        this.thread = new Thread((Runnable)this, "Cache updater");
        Util.decreasePriority(Thread.currentThread(), this.thread);
        this.thread.start();
    }

    private boolean outOfDate(File file) {
        return System.currentTimeMillis() - file.lastModified() > 86400000L;
    }

    private static String codage(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (!Character.isLetterOrDigit(c)) {
                stringBuffer.append(PREFIX + Util.hex(c));
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    private static String decodage(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (c != PREFIX) {
                stringBuffer.append(c);
                continue;
            }
            c = (char)(Cache.code(cArray[i + 1]) * 16 + Cache.code(cArray[i + 2]));
            stringBuffer.append(c);
            i += 2;
        }
        return stringBuffer.toString();
    }

    private static int code(char c) {
        return HEX.indexOf(Character.toUpperCase(c));
    }

    @Override
    public void run() {
        try {
            Thread.sleep(10000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.updateCache();
        this.thread = null;
    }
}

