/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Coord;
import cds.astro.Astrocoo;
import cds.astro.Astroframe;
import cds.astro.Ecliptic;
import cds.astro.FK4;
import cds.astro.FK5;
import cds.astro.Galactic;
import cds.astro.ICRS;
import cds.astro.Supergal;
import cds.fits.HeaderFits;
import cds.tools.Util;
import cds.tools.pixtools.CDSHealpix;
import healpix.essentials.FastMath;
import java.awt.Dimension;
import java.io.DataInputStream;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.Vector;

public final class Calib
implements Cloneable {
    int aladin;
    double[] xyapoly = new double[12];
    double[] xydpoly = new double[12];
    double[] adypoly = new double[12];
    double[] adxpoly = new double[12];
    double[][] sip_a = new double[10][10];
    int order_a;
    double[][] sip_b = new double[10][10];
    int order_b;
    double[][] sip_ap = new double[10][10];
    int order_ap;
    double[][] sip_bp = new double[10][10];
    int order_bp;
    double epoch;
    int flagepoc = 0;
    double equinox;
    double alpha;
    double delta;
    double yz;
    double xz;
    double focale;
    double Xorg;
    double Yorg;
    double incX;
    double incY;
    double alphai;
    double deltai;
    double incA;
    double incD;
    double Xcen;
    double Ycen;
    double widtha;
    double widthd;
    int xnpix;
    int ynpix;
    double rota;
    double cdelz;
    double sdelz;
    String type1;
    String type2;
    double[][] CD = new double[2][2];
    double[][] ID = new double[2][2];
    public static int FK4 = 1;
    public static int GALACTIC = 2;
    public static int SUPERGALACTIC = 3;
    public static int ECLIPTIC = 4;
    public static int FK5 = 5;
    public static int ICRS = 6;
    public static int XYLINEAR = 7;
    static final String[] RADECSYS = new String[]{"", "FK4", "", "", "", "FK5", "ICRS", ""};
    protected int system = ICRS;
    protected int proj;
    private static double deg_to_rad = Math.PI / 180;
    private static double rad_to_deg = 57.29577951308232;
    static String[] WCSKeys = new String[]{"NAXIS1", "NAXIS2", "CRPIX1", "CRPIX2", "CRVAL1", "CRVAL2", "CD1_1", "CD1_2", "CD2_1", "CD2_1", "CD2_2", "CDELT1", "CDELT2", "CROTA1", "CROTA2", "PC001001", "PC001002", "PC002001", "PC002002", "EPOCH", "EQUINOX", "EPOCH", "CTYPE1", "CTYPE2", "RADECSYS", "PLTRAM", "PLTRAH", "PLTDECSN", "PLTDECS", "PLTDECM", "PLTDECD", "PLTSCALE", "PPO3", "PPO6", "AMDX1", "AMDY1", "AMDX2", "AMDY2", "AMDX3", "AMDY3", "AMDX4", "AMDY4", "AMDX5", "AMDY5", "AMDX6", "AMDY6", "AMDX7", "AMDY8", "AMDY8", "AMDX9", "AMDY9", "AMDX10", "AMDY10", "AMDX11", "AMDY11", "AMDX12", "AMDY12", "XPIXELSZ", "YPIXELSZ", "CNPIX1", "CNPIX2"};
    public static final int SIN = 1;
    public static final int TAN = 2;
    public static final int ARC = 3;
    public static final int AIT = 4;
    public static final int ZEA = 5;
    public static final int STG = 6;
    public static final int CAR = 7;
    public static final int NCP = 8;
    public static final int ZPN = 9;
    public static final int SOL = 10;
    public static final int MOL = 11;
    public static final int SIP = 12;
    public static final int FIE = 13;
    public static final int TPV = 14;
    public static final int SINSIP = 15;
    public static final int FEYE = 16;
    static final String[] projType = new String[]{"", "SIN", "TAN", "ARC", "AIT", "ZEA", "STG", "CAR", "NCP", "ZPN", "SOL", "MOL", "TAN-SIP", "FIE", "TPV", "SIN-SIP", "FEYE"};
    private static Astroframe AF_FK4 = new FK4();
    private static Astroframe AF_FK5 = new FK5();
    private static Astroframe AF_ICRS = new ICRS();
    private static Astroframe AF_GAL = new Galactic();
    private static Astroframe AF_SGAL = new Supergal();
    private static Astroframe AF_ECL = new Ecliptic();
    static double[][] testCenter = new double[][]{{0.0, 0.0}, {15.0, -1.0}, {259.9, 89.99}, {0.1, -89.99}};
    static double EPSILON = 2.7777777777777777E-10;

    public long getMem() {
        return 3672L;
    }

    static int getProjType(String string) {
        return Util.indexInArrayOf(string, projType);
    }

    static int getSubProjType(String string) {
        int n = Calib.getProjType(string);
        if (n >= 0) {
            return n;
        }
        String[] stringArray = projType;
        String string2 = string.toUpperCase();
        for (n = 1; n < stringArray.length; ++n) {
            if (string2.indexOf(stringArray[n]) < 0) continue;
            String string3 = "!!! Unknown projection [" + string + "] : assume " + projType[n];
            if (Aladin.aladin != null && Aladin.aladin.command != null) {
                Aladin.aladin.command.printConsole(string3);
            } else {
                Aladin.trace(3, string3);
            }
            return n;
        }
        if (string2.indexOf("TNX") >= 0 || string2.indexOf("COE") >= 0) {
            n = 2;
            String string4 = "!!! Unknown projection [" + string + "] : assume " + projType[n];
            if (Aladin.aladin != null && Aladin.aladin.command != null) {
                Aladin.aladin.command.printConsole(string4);
            } else {
                Aladin.trace(3, string4);
            }
            return n;
        }
        return -1;
    }

    static String getProjName(int n) {
        return projType[n];
    }

    public static Calib copy(Calib calib) {
        int n;
        Calib calib2 = new Calib();
        calib2.aladin = calib.aladin;
        calib2.xyapoly = new double[12];
        System.arraycopy(calib.xyapoly, 0, calib2.xyapoly, 0, 10);
        calib2.xydpoly = new double[12];
        System.arraycopy(calib.xydpoly, 0, calib2.xydpoly, 0, 10);
        calib2.adypoly = new double[12];
        System.arraycopy(calib.adypoly, 0, calib2.adypoly, 0, 10);
        calib2.adxpoly = new double[12];
        System.arraycopy(calib.adxpoly, 0, calib2.adxpoly, 0, 10);
        calib2.epoch = calib.epoch;
        calib2.flagepoc = calib.flagepoc;
        calib2.equinox = calib.equinox;
        calib2.alpha = calib.alpha;
        calib2.delta = calib.delta;
        calib2.yz = calib.yz;
        calib2.xz = calib.xz;
        calib2.focale = calib.focale;
        calib2.Xorg = calib.Xorg;
        calib2.Yorg = calib.Yorg;
        calib2.incX = calib.incX;
        calib2.incY = calib.incY;
        calib2.alphai = calib.alphai;
        calib2.deltai = calib.deltai;
        calib2.incA = calib.incA;
        calib2.incD = calib.incD;
        calib2.Xcen = calib.Xcen;
        calib2.Ycen = calib.Ycen;
        calib2.widtha = calib.widtha;
        calib2.widthd = calib.widthd;
        calib2.xnpix = calib.xnpix;
        calib2.ynpix = calib.ynpix;
        calib2.rota = calib.rota;
        calib2.cdelz = calib.cdelz;
        calib2.sdelz = calib.sdelz;
        calib2.type1 = calib.type1;
        calib2.type2 = calib.type2;
        calib2.CD = new double[2][2];
        for (n = 0; n < 2; ++n) {
            System.arraycopy(calib.CD[n], 0, calib2.CD[n], 0, 2);
        }
        calib2.ID = new double[2][2];
        for (n = 0; n < 2; ++n) {
            System.arraycopy(calib.ID[n], 0, calib2.ID[n], 0, 2);
        }
        calib2.system = calib.system;
        calib2.proj = calib.proj;
        return calib2;
    }

    public static String[] getWCSKeys() {
        return WCSKeys;
    }

    public Calib flipBU() {
        Calib calib = new Calib();
        try {
            calib = (Calib)this.clone();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.aladin == 1) {
            calib.Yorg += (double)this.ynpix * calib.incY;
            calib.incY = -calib.incY;
        } else {
            calib.CD[1][1] = -calib.CD[1][1];
            calib.CD[0][1] = -calib.CD[0][1];
            calib.ID[1][1] = -calib.ID[1][1];
            calib.ID[1][0] = -calib.ID[1][0];
            calib.Ycen = (double)calib.ynpix - (calib.Ycen - 1.0);
        }
        return calib;
    }

    public Calib flipRL() {
        Calib calib = new Calib();
        try {
            calib = (Calib)this.clone();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.aladin == 1) {
            calib.Xorg += (double)this.xnpix * calib.incX;
            calib.incX = -calib.incX;
        } else {
            calib.CD[1][0] = -calib.CD[1][0];
            calib.CD[0][0] = -calib.CD[0][0];
            calib.ID[0][1] = -calib.ID[0][1];
            calib.ID[0][0] = -calib.ID[0][0];
            calib.Xcen = (double)calib.xnpix - (calib.Xcen - 1.0);
        }
        return calib;
    }

    public Calib resize(int n) {
        if (this.aladin == 1) {
            try {
                this.GetWCS_i();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        double d = this.Xcen / (double)n;
        double d2 = this.Ycen / (double)n;
        int n2 = this.xnpix / n;
        int n3 = this.ynpix / n;
        double d3 = this.CD[0][0] * (double)n;
        double d4 = this.CD[0][1] * (double)n;
        double d5 = this.CD[1][0] * (double)n;
        double d6 = this.CD[1][1] * (double)n;
        Calib calib = new Calib(this.alphai, this.deltai, d, d2, n2, n3, d3, d4, d5, d6, this.equinox, this.epoch, this.proj);
        return calib;
    }

    public Calib resize(int n, double d, double d2, int n2, int n3) {
        double d3 = (this.Xcen - d) * (double)n;
        double d4 = (this.Ycen - d2) * (double)n;
        double d5 = this.CD[0][0] / (double)n;
        double d6 = this.CD[0][1] / (double)n;
        double d7 = this.CD[1][0] / (double)n;
        double d8 = this.CD[1][1] / (double)n;
        Calib calib = new Calib(this.alphai, this.deltai, d3, d4, n2 *= n, n3 *= n, d5, d6, d7, d8, this.equinox, this.epoch, this.proj);
        return calib;
    }

    public Calib recalibrate(Coord[] coordArray) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        double d10 = 0.0;
        double d11 = 0.0;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        try {
            double d12;
            if (this.aladin == 1) {
                this.GetWCS_i();
                d12 = this.CD[0][0] * this.CD[1][1] - this.CD[0][1] * this.CD[1][0];
                this.ID[0][0] = this.CD[1][1] / d12;
                this.ID[0][1] = -this.CD[0][1] / d12;
                this.ID[1][0] = -this.CD[1][0] / d12;
                this.ID[1][1] = this.CD[0][0] / d12;
                this.incA = Math.sqrt(this.CD[0][0] * this.CD[0][0] + this.CD[0][1] * this.CD[0][1]);
                this.incD = Math.sqrt(this.CD[1][0] * this.CD[1][0] + this.CD[1][1] * this.CD[1][1]);
                this.widtha = (double)this.xnpix * Math.abs(this.incA);
                this.widthd = (double)this.ynpix * Math.abs(this.incD);
                this.cdelz = FastMath.cos(this.deltai * deg_to_rad);
                this.sdelz = FastMath.sin(this.deltai * deg_to_rad);
                this.aladin = 0;
            }
            double d13 = coordArray[0].dx;
            double d14 = coordArray[0].dy;
            double d15 = coordArray[0].xstand;
            double d16 = coordArray[0].ystand;
            double d17 = 0.0;
            double d18 = 0.0;
            double d19 = 0.0;
            double d20 = 0.0;
            for (n3 = 1; n3 < coordArray.length; ++n3) {
                this.GetXYstand(coordArray[n3]);
                double d21 = -coordArray[n3].dx * d14 + coordArray[n3].dy * d13;
                if (d21 != 0.0) {
                    d17 += (-d14 * coordArray[n3].xstand + d15 * coordArray[n3].dy) / d21;
                    d18 += (-coordArray[n3].dx * d15 + coordArray[n3].xstand * d13) / d21;
                    double d22 = coordArray[n3].dx * d14 - coordArray[n3].dy * d13;
                    d19 += (d16 * coordArray[n3].dx - d13 * coordArray[n3].ystand) / d22;
                    d20 += (coordArray[n3].ystand * d14 - coordArray[n3].dy * d16) / d22;
                }
                d13 = coordArray[n3].dx;
                d14 = coordArray[n3].dy;
                d15 = coordArray[n3].xstand;
                d16 = coordArray[n3].ystand;
            }
            n = d17 < 0.0 ? -1 : 1;
            n2 = d19 < 0.0 ? -1 : 1;
            for (n3 = 1; n3 < coordArray.length; ++n3) {
                this.GetXYstand(coordArray[n3]);
                d3 += (double)n * coordArray[n3].dx;
                d4 += (double)n2 * coordArray[n3].dy;
                d5 += coordArray[n3].xstand;
                d6 += coordArray[n3].ystand;
                d7 += coordArray[n3].dx * coordArray[n3].dx + coordArray[n3].dy * coordArray[n3].dy;
                d8 += (double)n * coordArray[n3].dx * coordArray[n3].xstand + (double)n2 * coordArray[n3].dy * coordArray[n3].ystand;
                d9 += (double)(-n) * coordArray[n3].dx * coordArray[n3].ystand + (double)n2 * coordArray[n3].dy * coordArray[n3].xstand;
            }
            double d23 = d5 / (double)coordArray.length;
            double d24 = d6 / (double)coordArray.length;
            double d25 = d8 / (double)coordArray.length;
            double d26 = d9 / (double)coordArray.length;
            double d27 = d3 * d3 * d3 + d3 * (d4 /= (double)coordArray.length) * d4 - (d3 /= (double)coordArray.length) * (d7 /= (double)coordArray.length);
            double d28 = d3 * d3 * d4 + d4 * d4 * d4 - d4 * d7;
            double d29 = -d3 * d3 - d4 * d4 + d7;
            double d30 = -d3 * d3 * d7 - d4 * d4 * d7 + d7 * d7;
            d12 = d3 * d3 * d3 * d3 + 2.0 * d3 * d3 * d4 * d4 + d4 * d4 * d4 * d4 - 2.0 * d3 * d3 * d7 - 2.0 * d4 * d4 * d7 + d7 * d7;
            d = (d23 * d27 + d24 * d28 + d25 * d29) / d12;
            d2 = (-d24 * d27 + d23 * d28 + d26 * d29) / d12;
            d10 = (d25 * d27 + d26 * d28 + d23 * d30) / d12;
            d11 = (-d26 * d27 + d25 * d28 + d24 * d30) / d12;
            double d31 = this.Xcen + (double)n * (-d * d10 + d2 * d11) / (d * d + d2 * d2);
            double d32 = this.Ycen + (double)n2 * (-d2 * d10 - d * d11) / (d * d + d2 * d2);
            double d33 = (double)n * d * rad_to_deg;
            double d34 = (double)(-n) * d2 * rad_to_deg;
            double d35 = (double)n2 * d2 * rad_to_deg;
            double d36 = (double)n2 * d * rad_to_deg;
            Calib calib = new Calib(this.alphai, this.deltai, d31, d32, this.xnpix, this.ynpix, d33, d35, d34, d36, this.equinox, this.epoch, this.proj);
            return calib;
        }
        catch (Exception exception) {
            return this;
        }
    }

    public Calib(double d, double d2, double d3, double d4, int n, int n2, double d5, double d6, double d7, double d8, double d9, double d10, int n3) {
        this.aladin = 0;
        this.xnpix = n;
        this.ynpix = n2;
        this.Xcen = d3;
        this.Ycen = d4;
        this.alphai = d;
        this.deltai = d2;
        this.CD[0][0] = d5;
        this.CD[0][1] = d6;
        this.CD[1][0] = d7;
        this.CD[1][1] = d8;
        this.equinox = d9;
        this.epoch = d10;
        this.proj = n3;
        this.incA = Math.sqrt(this.CD[0][0] * this.CD[0][0] + this.CD[0][1] * this.CD[0][1]) * (this.CD[0][0] / Math.abs(this.CD[0][0]));
        this.incD = Math.sqrt(this.CD[1][0] * this.CD[1][0] + this.CD[1][1] * this.CD[1][1]) * (this.CD[1][1] / Math.abs(this.CD[1][1]));
        this.rota = Math.atan2(this.CD[0][1] / this.incA, this.CD[1][1] / this.incD) * 57.29577951308232;
        this.widtha = (double)this.xnpix * Math.abs(this.incA);
        this.widthd = (double)this.ynpix * Math.abs(this.incD);
        this.cdelz = FastMath.cos(this.deltai * deg_to_rad);
        this.sdelz = FastMath.sin(this.deltai * deg_to_rad);
        double d11 = this.CD[0][0] * this.CD[1][1] - this.CD[0][1] * this.CD[1][0];
        this.ID[0][0] = this.CD[1][1] / d11;
        this.ID[0][1] = -this.CD[0][1] / d11;
        this.ID[1][0] = -this.CD[1][0] / d11;
        this.ID[1][1] = this.CD[0][0] / d11;
        this.type1 = "RA---" + projType[this.proj];
        this.type2 = "DEC--" + projType[this.proj];
        this.flagepoc = 1;
    }

    public Calib(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, int n, boolean bl, int n2) {
        this.aladin = 0;
        this.xnpix = (int)d5;
        this.ynpix = (int)d6;
        this.Xcen = d3;
        this.Ycen = d4;
        this.alphai = d;
        this.deltai = d2;
        this.cdelz = FastMath.cos(this.deltai * deg_to_rad);
        this.sdelz = FastMath.sin(this.deltai * deg_to_rad);
        double d10 = FastMath.cos(d9 * deg_to_rad);
        double d11 = FastMath.sin(d9 * deg_to_rad);
        this.incA = !bl ? -d7 / d5 : (d7 /= 60.0) / d5;
        this.incD = (d8 /= 60.0) / d6;
        this.widtha = d7;
        this.widthd = d8;
        this.CD[0][0] = this.incA * d10;
        this.CD[0][1] = this.incA * d11;
        this.CD[1][0] = -this.incD * d11;
        this.CD[1][1] = this.incD * d10;
        double d12 = this.CD[0][0] * this.CD[1][1] - this.CD[0][1] * this.CD[1][0];
        this.ID[0][0] = this.CD[1][1] / d12;
        this.ID[0][1] = -this.CD[0][1] / d12;
        this.ID[1][0] = -this.CD[1][0] / d12;
        this.ID[1][1] = this.CD[0][0] / d12;
        this.rota = d9;
        this.equinox = 2000.0;
        this.epoch = 2000.0;
        this.flagepoc = 0;
        this.proj = n;
        this.system = n2;
        this.type1 = "RA---" + projType[this.proj];
        this.type2 = "DEC--" + projType[this.proj];
    }

    public Calib(double d, double d2, double d3, double d4, double d5, double d6, double d7, int n, boolean bl) {
        this(d, d2, d3, d4, d5, d5, d6, d6, d7, n, bl, FK5);
    }

    public Calib(DataInputStream dataInputStream) throws Exception {
        int n;
        int n2 = 1;
        this.aladin = 1;
        this.equinox = 2000.0;
        String string = dataInputStream.readLine();
        this.epoch = new Double(string);
        this.flagepoc = 1;
        string = dataInputStream.readLine();
        this.focale = new Double(string);
        string = dataInputStream.readLine();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        String string2 = stringTokenizer.nextToken();
        this.alpha = new Double(string2);
        string2 = stringTokenizer.nextToken();
        this.alpha += new Double(string2) / 60.0;
        string2 = stringTokenizer.nextToken();
        this.alpha += new Double(string2) / 3600.0;
        this.alpha *= 15.0;
        string = dataInputStream.readLine();
        stringTokenizer = new StringTokenizer(string, " ");
        string2 = stringTokenizer.nextToken();
        if (string2.startsWith("-")) {
            n2 = -1;
        }
        this.delta = new Double(string2);
        if (n2 == -1) {
            this.delta = -this.delta;
        }
        string2 = stringTokenizer.nextToken();
        this.delta += new Double(string2) / 60.0;
        string2 = stringTokenizer.nextToken();
        this.delta += new Double(string2) / 3600.0;
        if (n2 == -1) {
            this.delta = -this.delta;
        }
        string = dataInputStream.readLine();
        stringTokenizer = new StringTokenizer(string, " ");
        string2 = stringTokenizer.nextToken();
        this.yz = new Double(string2);
        string2 = stringTokenizer.nextToken();
        this.xz = new Double(string2);
        for (n = 0; n < 6; ++n) {
            dataInputStream.readLine();
        }
        for (n = 0; n < 10; ++n) {
            string = dataInputStream.readLine();
            stringTokenizer = new StringTokenizer(string, " ");
            string2 = stringTokenizer.nextToken();
            this.adypoly[n] = new Double(string2);
            string2 = stringTokenizer.nextToken();
            this.adxpoly[n] = new Double(string2);
        }
        for (n = 0; n < 12; ++n) {
            string = dataInputStream.readLine();
            stringTokenizer = new StringTokenizer(string, " ");
            string2 = stringTokenizer.nextToken();
            this.xyapoly[n] = new Double(string2);
            string2 = stringTokenizer.nextToken();
            this.xydpoly[n] = new Double(string2);
        }
        string = dataInputStream.readLine();
        stringTokenizer = new StringTokenizer(string, " ");
        string2 = stringTokenizer.nextToken();
        this.incY = new Double(string2);
        string2 = stringTokenizer.nextToken();
        this.incX = new Double(string2);
        string = dataInputStream.readLine();
        stringTokenizer = new StringTokenizer(string, " ");
        string2 = stringTokenizer.nextToken();
        string2 = stringTokenizer.nextToken();
        this.Yorg = new Double(string2);
        string2 = stringTokenizer.nextToken();
        this.Xorg = new Double(string2);
        string = dataInputStream.readLine();
        stringTokenizer = new StringTokenizer(string, " ,=/");
        string2 = stringTokenizer.nextToken();
        string2 = stringTokenizer.nextToken();
        this.alphai = new Double(string2);
        string2 = stringTokenizer.nextToken();
        this.deltai = new Double(string2);
        string2 = stringTokenizer.nextToken();
        string2 = stringTokenizer.nextToken();
        this.widtha = new Double(string2);
        string2 = stringTokenizer.nextToken();
        this.widthd = new Double(string2);
        string = dataInputStream.readLine();
        stringTokenizer = new StringTokenizer(string, " ,=/");
        string2 = stringTokenizer.nextToken();
        string2 = stringTokenizer.nextToken();
        this.xnpix = new Integer(string2);
        string2 = stringTokenizer.nextToken();
        this.ynpix = new Integer(string2);
        this.cdelz = FastMath.cos(this.delta * deg_to_rad);
        this.sdelz = FastMath.sin(this.delta * deg_to_rad);
        this.incA = this.xyapoly[2] * this.incX / this.focale / 1000.0 * rad_to_deg;
        this.incD = this.xydpoly[1] * this.incY / this.focale / 1000.0 * rad_to_deg;
        Coord coord = new Coord();
        coord.al = this.alphai;
        coord.del = this.deltai;
        this.GetXY(coord);
        this.Xcen = coord.x;
        this.Ycen = coord.y;
    }

    public Calib() {
    }

    public Calib(HeaderFits headerFits) throws Exception {
        this.aladin = 0;
        this.xnpix = headerFits.getIntFromHeader("NAXIS1  ");
        this.ynpix = headerFits.getIntFromHeader("NAXIS2  ");
        String string = headerFits.getStringFromHeader("PLATE");
        this.aladin = string != null ? 3 : 0;
        try {
            this.alpha = headerFits.getDoubleFromHeader("PLTRAS  ");
            this.Dss(headerFits);
            return;
        }
        catch (Exception exception) {
            int n;
            block156: {
                this.Xcen = headerFits.getDoubleFromHeader("CRPIX1  ");
                this.Ycen = headerFits.getDoubleFromHeader("CRPIX2  ");
                this.type1 = headerFits.getStringFromHeader("CTYPE1  ");
                this.type2 = headerFits.getStringFromHeader("CTYPE2  ");
                if (this.type1.startsWith("Solar") || this.type1.startsWith("solar")) {
                    try {
                        this.alphai = headerFits.getDoubleFromHeader("CRVAL1  ");
                        this.deltai = headerFits.getDoubleFromHeader("CRVAL2  ");
                    }
                    catch (Exception exception2) {
                        this.alphai = 0.0;
                        this.deltai = 0.0;
                    }
                } else {
                    this.alphai = headerFits.getDoubleFromHeader("CRVAL1  ");
                    this.deltai = headerFits.getDoubleFromHeader("CRVAL2  ");
                }
                try {
                    this.CD[0][0] = headerFits.getDoubleFromHeader("CD1_1    ");
                    try {
                        this.CD[0][1] = headerFits.getDoubleFromHeader("CD1_2    ");
                    }
                    catch (Exception exception3) {
                        this.CD[0][1] = 0.0;
                    }
                    try {
                        this.CD[1][0] = headerFits.getDoubleFromHeader("CD2_1    ");
                    }
                    catch (Exception exception4) {
                        this.CD[1][0] = 0.0;
                    }
                    this.CD[1][1] = headerFits.getDoubleFromHeader("CD2_2    ");
                    int n2 = this.CD[0][0] < 0.0 ? -1 : 1;
                    n = this.CD[1][1] < 0.0 ? -1 : 1;
                    this.incA = Math.sqrt(this.CD[0][0] * this.CD[0][0] + this.CD[0][1] * this.CD[0][1]) * (double)n2;
                    this.incD = Math.sqrt(this.CD[1][0] * this.CD[1][0] + this.CD[1][1] * this.CD[1][1]) * (double)n;
                    this.rota = Math.atan2(this.CD[0][1] / this.incA, this.CD[1][1] / this.incD) * 180.0 / Math.PI;
                }
                catch (Exception exception5) {
                    this.incA = headerFits.getDoubleFromHeader("CDELT1  ");
                    this.incD = headerFits.getDoubleFromHeader("CDELT2  ");
                    try {
                        double d = 0.0;
                        double d2 = 0.0;
                        try {
                            d = headerFits.getDoubleFromHeader("CROTA1  ");
                            d2 = headerFits.getDoubleFromHeader("CROTA2  ");
                        }
                        catch (Exception exception6) {
                            try {
                                d = headerFits.getDoubleFromHeader("CROTA1  ");
                            }
                            catch (Exception exception7) {
                                d2 = headerFits.getDoubleFromHeader("CROTA2  ");
                            }
                        }
                        this.rota = d;
                        if (d == 0.0) {
                            this.rota = d2;
                        } else if (d2 != 0.0) {
                            this.rota = (d + d2) / 2.0;
                        }
                        this.CD[0][0] = this.incA * FastMath.cos(this.rota / 180.0 * Math.PI);
                        this.CD[0][1] = -this.incD * FastMath.sin(this.rota / 180.0 * Math.PI);
                        this.CD[1][0] = this.incA * FastMath.sin(this.rota / 180.0 * Math.PI);
                        this.CD[1][1] = this.incD * FastMath.cos(this.rota / 180.0 * Math.PI);
                    }
                    catch (Exception exception8) {
                        try {
                            this.CD[0][0] = headerFits.getDoubleFromHeader("PC001001") * this.incA;
                            this.CD[0][1] = headerFits.getDoubleFromHeader("PC001002") * this.incA;
                            this.CD[1][0] = headerFits.getDoubleFromHeader("PC002001") * this.incD;
                            this.CD[1][1] = headerFits.getDoubleFromHeader("PC002002") * this.incD;
                            this.rota = Math.acos(headerFits.getDoubleFromHeader("PC001001")) * 57.29577951308232;
                        }
                        catch (Exception exception9) {
                            try {
                                try {
                                    this.CD[0][0] = headerFits.getDoubleFromHeader("PC1_1") * this.incA;
                                }
                                catch (Exception exception10) {
                                    this.CD[0][0] = this.incA;
                                }
                                try {
                                    this.CD[0][1] = headerFits.getDoubleFromHeader("PC1_2") * this.incA;
                                }
                                catch (Exception exception11) {
                                    this.CD[0][1] = 0.0;
                                }
                                try {
                                    this.CD[1][0] = headerFits.getDoubleFromHeader("PC2_1") * this.incD;
                                }
                                catch (Exception exception12) {
                                    this.CD[1][0] = 0.0;
                                }
                                try {
                                    this.CD[1][1] = headerFits.getDoubleFromHeader("PC2_2") * this.incD;
                                }
                                catch (Exception exception13) {
                                    this.CD[1][1] = this.incA;
                                }
                                this.rota = Math.acos(headerFits.getDoubleFromHeader("PC1_1")) * 57.29577951308232;
                            }
                            catch (Exception exception14) {
                                this.rota = 0.0;
                                this.CD[0][0] = this.incA;
                                this.CD[0][1] = 0.0;
                                this.CD[1][0] = 0.0;
                                this.CD[1][1] = this.incD;
                                String string2 = headerFits.getStringFromHeader("ORIGIN  ");
                                if (string2 == null || !string2.startsWith("DeNIS")) break block156;
                                if (this.CD[0][0] > 0.0) {
                                    this.CD[0][0] = -this.CD[0][0];
                                }
                                if (!(this.CD[1][1] > 0.0)) break block156;
                                this.CD[1][1] = -this.CD[1][1];
                            }
                        }
                    }
                }
            }
            try {
                this.epoch = headerFits.getDoubleFromHeader("EPOCH   ");
                this.flagepoc = 1;
            }
            catch (Exception exception15) {
                this.epoch = 0.0;
            }
            try {
                this.equinox = headerFits.getDoubleFromHeader("EQUINOX ");
            }
            catch (Exception exception16) {
                try {
                    this.epoch = this.equinox = headerFits.getDoubleFromHeader("EPOCH  ");
                    this.flagepoc = 1;
                }
                catch (Exception exception17) {
                    this.equinox = 2000.0;
                    this.epoch = 2000.0;
                    this.flagepoc = 0;
                }
            }
            if (this.type1.startsWith("DEC")) {
                double d = this.deltai;
                this.deltai = this.alphai;
                this.alphai = d;
                d = this.CD[0][0];
                this.CD[0][0] = this.CD[1][0];
                this.CD[1][0] = d;
                d = this.CD[1][1];
                this.CD[1][1] = this.CD[0][1];
                this.CD[0][1] = d;
                d = this.incA;
                this.incA = this.incD;
                this.incD = d;
            }
            try {
                String string3 = headerFits.getStringFromHeader("RADECSYS");
                if (string3.indexOf("ICRS") >= 0) {
                    this.system = ICRS;
                }
                if (string3.indexOf("FK5") >= 0) {
                    this.system = FK5;
                }
                if (string3.indexOf("FK4") >= 0) {
                    this.system = FK4;
                }
            }
            catch (Exception exception18) {
                // empty catch block
            }
            if (this.type1.startsWith("ELON")) {
                this.system = ECLIPTIC;
            }
            if (this.type1.startsWith("GLON")) {
                this.system = GALACTIC;
            }
            if (this.type1.startsWith("SLON")) {
                this.system = SUPERGALACTIC;
            }
            if (this.type1.startsWith("Solar")) {
                this.system = XYLINEAR;
            }
            if (this.type1.startsWith("solar")) {
                this.system = XYLINEAR;
            }
            if (this.equinox == 1950.0 && this.system != GALACTIC && this.system != ECLIPTIC && this.system != SUPERGALACTIC && this.system != XYLINEAR) {
                this.system = FK4;
            }
            try {
                this.adxpoly[0] = headerFits.getDoubleFromHeader("PV2_0   ");
                this.xydpoly[0] = this.adxpoly[0];
            }
            catch (Exception exception19) {
                // empty catch block
            }
            try {
                this.adxpoly[1] = headerFits.getDoubleFromHeader("PV2_1   ");
                this.xydpoly[1] = this.adxpoly[1];
            }
            catch (Exception exception20) {
                // empty catch block
            }
            try {
                this.adxpoly[2] = headerFits.getDoubleFromHeader("PV2_2   ");
                this.xydpoly[2] = this.adxpoly[2];
            }
            catch (Exception exception21) {
                // empty catch block
            }
            try {
                this.adxpoly[3] = headerFits.getDoubleFromHeader("PV2_3   ");
                this.xydpoly[3] = this.adxpoly[3];
            }
            catch (Exception exception22) {
                // empty catch block
            }
            try {
                this.adxpoly[4] = headerFits.getDoubleFromHeader("PV2_4   ");
                this.xydpoly[4] = this.adxpoly[4];
            }
            catch (Exception exception23) {
                // empty catch block
            }
            try {
                this.adxpoly[5] = headerFits.getDoubleFromHeader("PV2_5   ");
                this.xydpoly[5] = this.adxpoly[5];
            }
            catch (Exception exception24) {
                // empty catch block
            }
            try {
                this.adxpoly[6] = headerFits.getDoubleFromHeader("PV2_6   ");
                this.xydpoly[6] = this.adxpoly[6];
            }
            catch (Exception exception25) {
                // empty catch block
            }
            try {
                this.adxpoly[7] = headerFits.getDoubleFromHeader("PV2_7   ");
                this.xydpoly[7] = this.adxpoly[7];
            }
            catch (Exception exception26) {
                // empty catch block
            }
            try {
                this.adxpoly[8] = headerFits.getDoubleFromHeader("PV2_8   ");
                this.xydpoly[8] = this.adxpoly[8];
            }
            catch (Exception exception27) {
                // empty catch block
            }
            try {
                this.adxpoly[9] = headerFits.getDoubleFromHeader("PV2_9   ");
                this.xydpoly[9] = this.adxpoly[9];
            }
            catch (Exception exception28) {
                // empty catch block
            }
            try {
                this.adxpoly[10] = headerFits.getDoubleFromHeader("PV2_10   ");
                this.xydpoly[10] = this.adxpoly[10];
            }
            catch (Exception exception29) {
                // empty catch block
            }
            try {
                this.xyapoly[0] = headerFits.getDoubleFromHeader("PV1_0   ");
            }
            catch (Exception exception30) {
                // empty catch block
            }
            try {
                this.xydpoly[0] = headerFits.getDoubleFromHeader("PV2_0   ");
            }
            catch (Exception exception31) {
                // empty catch block
            }
            try {
                this.xyapoly[1] = headerFits.getDoubleFromHeader("PV1_1   ");
            }
            catch (Exception exception32) {
                // empty catch block
            }
            try {
                this.xydpoly[1] = headerFits.getDoubleFromHeader("PV2_1   ");
            }
            catch (Exception exception33) {
                // empty catch block
            }
            try {
                this.xyapoly[2] = headerFits.getDoubleFromHeader("PV1_2   ");
            }
            catch (Exception exception34) {
                // empty catch block
            }
            try {
                this.xydpoly[2] = headerFits.getDoubleFromHeader("PV2_2   ");
            }
            catch (Exception exception35) {
                // empty catch block
            }
            try {
                this.xyapoly[3] = headerFits.getDoubleFromHeader("PV1_3   ");
            }
            catch (Exception exception36) {
                // empty catch block
            }
            try {
                this.xydpoly[3] = headerFits.getDoubleFromHeader("PV2_3   ");
            }
            catch (Exception exception37) {
                // empty catch block
            }
            try {
                this.xyapoly[4] = headerFits.getDoubleFromHeader("PV1_4   ");
            }
            catch (Exception exception38) {
                // empty catch block
            }
            try {
                this.xydpoly[4] = headerFits.getDoubleFromHeader("PV2_4   ");
            }
            catch (Exception exception39) {
                // empty catch block
            }
            try {
                this.xyapoly[5] = headerFits.getDoubleFromHeader("PV1_5   ");
            }
            catch (Exception exception40) {
                // empty catch block
            }
            try {
                this.xydpoly[5] = headerFits.getDoubleFromHeader("PV2_5   ");
            }
            catch (Exception exception41) {
                // empty catch block
            }
            try {
                this.xyapoly[6] = headerFits.getDoubleFromHeader("PV1_6   ");
            }
            catch (Exception exception42) {
                // empty catch block
            }
            try {
                this.xydpoly[6] = headerFits.getDoubleFromHeader("PV2_6   ");
            }
            catch (Exception exception43) {
                // empty catch block
            }
            try {
                this.xyapoly[7] = headerFits.getDoubleFromHeader("PV1_7   ");
            }
            catch (Exception exception44) {
                // empty catch block
            }
            try {
                this.xydpoly[7] = headerFits.getDoubleFromHeader("PV2_7   ");
            }
            catch (Exception exception45) {
                // empty catch block
            }
            try {
                this.xyapoly[8] = headerFits.getDoubleFromHeader("PV1_8   ");
            }
            catch (Exception exception46) {
                // empty catch block
            }
            try {
                this.xydpoly[8] = headerFits.getDoubleFromHeader("PV2_8   ");
            }
            catch (Exception exception47) {
                // empty catch block
            }
            try {
                this.xyapoly[9] = headerFits.getDoubleFromHeader("PV1_9   ");
            }
            catch (Exception exception48) {
                // empty catch block
            }
            try {
                this.xydpoly[9] = headerFits.getDoubleFromHeader("PV2_9   ");
            }
            catch (Exception exception49) {
                // empty catch block
            }
            try {
                this.xyapoly[10] = headerFits.getDoubleFromHeader("PV1_10   ");
            }
            catch (Exception exception50) {
                // empty catch block
            }
            try {
                this.xydpoly[10] = headerFits.getDoubleFromHeader("PV2_10   ");
            }
            catch (Exception exception51) {
                // empty catch block
            }
            try {
                this.xyapoly[11] = headerFits.getDoubleFromHeader("PV1_11   ");
            }
            catch (Exception exception52) {
                // empty catch block
            }
            try {
                this.xydpoly[11] = headerFits.getDoubleFromHeader("PV2_11   ");
            }
            catch (Exception exception53) {
                // empty catch block
            }
            try {
                this.proj = Calib.getSubProjType(this.type2.substring(5));
            }
            catch (Exception exception54) {
                this.proj = -1;
            }
            if (this.proj != -1) {
                try {
                    this.proj = Calib.getSubProjType(this.type1.substring(5));
                }
                catch (Exception exception55) {
                    this.proj = -1;
                }
            }
            if (this.proj == -1 && headerFits.getStringFromHeader("GRIDTYPE") != null) {
                this.proj = 7;
                System.err.println("No projection specified in CTYPE, GRIDTYPE present => assuming CAR");
            }
            if (Util.indexOfIgnoreCase(this.type1, "solar") >= 0) {
                this.proj = 10;
            }
            if (this.proj == 12 || this.proj == 15) {
                try {
                    int n3;
                    this.order_a = headerFits.getIntFromHeader("A_ORDER");
                    this.order_b = headerFits.getIntFromHeader("B_ORDER");
                    for (n3 = 2; n3 < this.order_a + 1; ++n3) {
                        for (int i = 0; i < n3 + 1; ++i) {
                            for (n = 0; n < n3 - i + 1; ++n) {
                                try {
                                    this.sip_a[i][n] = headerFits.getDoubleFromHeader("A_" + new Integer(i).toString() + "_" + new Integer(n).toString() + "  ");
                                    continue;
                                }
                                catch (Exception exception56) {
                                    this.sip_a[i][n] = 0.0;
                                }
                            }
                        }
                    }
                    for (n3 = 2; n3 < this.order_b + 1; ++n3) {
                        for (int i = 0; i < n3 + 1; ++i) {
                            for (n = 0; n < n3 - i + 1; ++n) {
                                try {
                                    this.sip_b[i][n] = headerFits.getDoubleFromHeader("B_" + new Integer(i).toString() + "_" + new Integer(n).toString() + "  ");
                                    continue;
                                }
                                catch (Exception exception57) {
                                    this.sip_b[i][n] = 0.0;
                                }
                            }
                        }
                    }
                }
                catch (Exception exception58) {
                    this.proj = -1;
                }
                try {
                    int n4;
                    this.order_ap = headerFits.getIntFromHeader("AP_ORDER");
                    this.order_bp = headerFits.getIntFromHeader("BP_ORDER");
                    for (n4 = 2; n4 < this.order_ap + 1; ++n4) {
                        for (int i = 0; i < n4 + 1; ++i) {
                            for (n = 0; n < n4 - i + 1; ++n) {
                                try {
                                    this.sip_ap[i][n] = headerFits.getDoubleFromHeader("AP_" + new Integer(i).toString() + "_" + new Integer(n).toString() + "  ");
                                    continue;
                                }
                                catch (Exception exception59) {
                                    this.sip_ap[i][n] = 0.0;
                                }
                            }
                        }
                    }
                    for (n4 = 2; n4 < this.order_bp + 1; ++n4) {
                        for (int i = 0; i < n4 + 1; ++i) {
                            for (n = 0; n < n4 - i + 1; ++n) {
                                try {
                                    this.sip_bp[i][n] = headerFits.getDoubleFromHeader("BP_" + new Integer(i).toString() + "_" + new Integer(n).toString() + "  ");
                                    continue;
                                }
                                catch (Exception exception60) {
                                    this.sip_bp[i][n] = 0.0;
                                }
                            }
                        }
                    }
                }
                catch (Exception exception61) {
                    // empty catch block
                }
            }
            if (this.type1.indexOf("COE") >= 0 && this.type2.indexOf("COE") >= 0) {
                this.proj = 2;
            }
            if (this.proj == -1) {
                System.err.println("Calib warning:CTYPE " + this.type1 + "/" + this.type2 + " is not yet supported by Aladin");
                throw new Exception("CTYPE " + this.type1 + "/" + this.type2 + " is not yet supported by Aladin");
            }
            this.widtha = (double)this.xnpix * Math.abs(this.incA);
            this.widthd = (double)this.ynpix * Math.abs(this.incD);
            this.cdelz = FastMath.cos(this.deltai * deg_to_rad);
            this.sdelz = FastMath.sin(this.deltai * deg_to_rad);
            double d = this.CD[0][0] * this.CD[1][1] - this.CD[0][1] * this.CD[1][0];
            this.ID[0][0] = this.CD[1][1] / d;
            this.ID[0][1] = -this.CD[0][1] / d;
            this.ID[1][0] = -this.CD[1][0] / d;
            this.ID[1][1] = this.CD[0][0] / d;
            return;
        }
    }

    public Calib(long l, long l2, int n, int n2) {
        try {
            double[][] dArray = CDSHealpix.borders(l, l2, 2);
            double[] dArray2 = CDSHealpix.pix2ang_nest(l, l2);
            double[] dArray3 = CDSHealpix.polarToRadec(dArray2);
            this.alphai = dArray3[0];
            this.deltai = dArray3[1];
            double d = dArray[0][0];
            double d2 = dArray[0][1];
            double d3 = dArray[1][0];
            double d4 = dArray[1][1];
            double d5 = dArray[2][0];
            double d6 = dArray[2][1];
            double d7 = dArray[3][0];
            double d8 = dArray[3][1];
            double d9 = dArray[4][0];
            double d10 = dArray[4][1];
            double d11 = dArray[5][0];
            double d12 = dArray[5][1];
            double d13 = dArray[6][0];
            double d14 = dArray[6][1];
            double d15 = dArray[7][0];
            double d16 = dArray[7][1];
            this.cdelz = FastMath.cos(this.deltai / 180.0 * Math.PI);
            this.sdelz = FastMath.sin(this.deltai / 180.0 * Math.PI);
            double d17 = this.cdelz;
            double d18 = this.sdelz;
            double d19 = FastMath.sin(d2 * Math.PI / 180.0) * d18 + FastMath.cos(d2 * Math.PI / 180.0) * d17 * FastMath.cos((d - this.alphai) * Math.PI / 180.0);
            double d20 = FastMath.cos(d2 * Math.PI / 180.0) * FastMath.sin((d - this.alphai) * Math.PI / 180.0) / d19;
            double d21 = (FastMath.sin(d2 * Math.PI / 180.0) * d17 - FastMath.cos(d2 * Math.PI / 180.0) * d18 * FastMath.cos((d - this.alphai) * Math.PI / 180.0)) / d19;
            d19 = FastMath.sin(d4 * Math.PI / 180.0) * d18 + FastMath.cos(d4 * Math.PI / 180.0) * d17 * FastMath.cos((d3 - this.alphai) * Math.PI / 180.0);
            double d22 = FastMath.cos(d4 * Math.PI / 180.0) * FastMath.sin((d3 - this.alphai) * Math.PI / 180.0) / d19;
            double d23 = (FastMath.sin(d4 * Math.PI / 180.0) * d17 - FastMath.cos(d4 * Math.PI / 180.0) * d18 * FastMath.cos((d3 - this.alphai) * Math.PI / 180.0)) / d19;
            d19 = FastMath.sin(d6 * Math.PI / 180.0) * d18 + FastMath.cos(d6 * Math.PI / 180.0) * d17 * FastMath.cos((d5 - this.alphai) * Math.PI / 180.0);
            double d24 = FastMath.cos(d6 * Math.PI / 180.0) * FastMath.sin((d5 - this.alphai) * Math.PI / 180.0) / d19;
            double d25 = FastMath.sin(d6 * Math.PI / 180.0) * d17 - FastMath.cos(d6 * Math.PI / 180.0) * d18 * FastMath.cos((d5 - this.alphai) * Math.PI / 180.0) / d19;
            d19 = FastMath.sin(d8 * Math.PI / 180.0) * d18 + FastMath.cos(d8 * Math.PI / 180.0) * d17 * FastMath.cos((d7 - this.alphai) * Math.PI / 180.0);
            double d26 = FastMath.cos(d8 * Math.PI / 180.0) * FastMath.sin((d7 - this.alphai) * Math.PI / 180.0) / d19;
            double d27 = (FastMath.sin(d8 * Math.PI / 180.0) * d17 - FastMath.cos(d8 * Math.PI / 180.0) * d18 * FastMath.cos((d7 - this.alphai) * Math.PI / 180.0)) / d19;
            d19 = FastMath.sin(d10 * Math.PI / 180.0) * d18 + FastMath.cos(d10 * Math.PI / 180.0) * d17 * FastMath.cos((d9 - this.alphai) * Math.PI / 180.0);
            double d28 = FastMath.cos(d10 * Math.PI / 180.0) * FastMath.sin((d9 - this.alphai) * Math.PI / 180.0) / d19;
            double d29 = (FastMath.sin(d10 * Math.PI / 180.0) * d17 - FastMath.cos(d10 * Math.PI / 180.0) * d18 * FastMath.cos((d9 - this.alphai) * Math.PI / 180.0)) / d19;
            d19 = FastMath.sin(d12 * Math.PI / 180.0) * d18 + FastMath.cos(d12 * Math.PI / 180.0) * d17 * FastMath.cos((d11 - this.alphai) * Math.PI / 180.0);
            double d30 = FastMath.cos(d12 * Math.PI / 180.0) * FastMath.sin((d11 - this.alphai) * Math.PI / 180.0) / d19;
            double d31 = (FastMath.sin(d12 * Math.PI / 180.0) * d17 - FastMath.cos(d12 * Math.PI / 180.0) * d18 * FastMath.cos((d11 - this.alphai) * Math.PI / 180.0)) / d19;
            d19 = FastMath.sin(d14 * Math.PI / 180.0) * d18 + FastMath.cos(d14 * Math.PI / 180.0) * d17 * FastMath.cos((d13 - this.alphai) * Math.PI / 180.0);
            double d32 = FastMath.cos(d14 * Math.PI / 180.0) * FastMath.sin((d13 - this.alphai) * Math.PI / 180.0) / d19;
            double d33 = (FastMath.sin(d14 * Math.PI / 180.0) * d17 - FastMath.cos(d14 * Math.PI / 180.0) * d18 * FastMath.cos((d13 - this.alphai) * Math.PI / 180.0)) / d19;
            d19 = FastMath.sin(d16 * Math.PI / 180.0) * d18 + FastMath.cos(d16 * Math.PI / 180.0) * d17 * FastMath.cos((d15 - this.alphai) * Math.PI / 180.0);
            double d34 = FastMath.cos(d16 * Math.PI / 180.0) * FastMath.sin((d15 - this.alphai) * Math.PI / 180.0) / d19;
            double d35 = (FastMath.sin(d16 * Math.PI / 180.0) * d17 - FastMath.cos(d16 * Math.PI / 180.0) * d18 * FastMath.cos((d15 - this.alphai) * Math.PI / 180.0)) / d19;
            this.CD[0][0] = rad_to_deg * (-d20 - d22 - d24 + d28 + d30 + d32) / 6.0 / 256.0;
            this.CD[0][1] = rad_to_deg * (d20 - d24 - d26 - d28 + d32 + d34) / 6.0 / 256.0;
            this.CD[1][0] = -rad_to_deg * (-d21 - d23 - d25 + d29 + d31 + d33) / 6.0 / 256.0;
            this.CD[1][1] = rad_to_deg * (d21 - d25 - d27 - d29 + d33 + d35) / 6.0 / 256.0;
            this.xnpix = 512;
            this.ynpix = 512;
            this.Xcen = 255.0;
            this.Ycen = 255.0;
            this.proj = 2;
            this.equinox = 2000.0;
            Coord coord = new Coord();
            coord.x = 0.0;
            coord.y = 0.0;
            this.GetCoord(coord);
            coord.x = 0.0;
            coord.y = 256.0;
            this.GetCoord(coord);
            coord.x = 0.0;
            coord.y = 128.0;
            this.GetCoord(coord);
            coord.x = 512.0;
            coord.y = 512.0;
            this.GetCoord(coord);
            double[][] dArray4 = CDSHealpix.borders(l, l2, 2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void Dss(HeaderFits headerFits) throws Exception {
        int n = 1;
        this.proj = 2;
        this.alpha += (double)headerFits.getIntFromHeader("PLTRAM  ") * 60.0;
        this.alpha += (double)headerFits.getIntFromHeader("PLTRAH  ") * 3600.0;
        this.alpha /= 240.0;
        if (headerFits.getStringFromHeader("PLTDECSN").startsWith("-")) {
            n = -1;
        }
        this.delta = headerFits.getDoubleFromHeader("PLTDECS ");
        this.delta += (double)headerFits.getIntFromHeader("PLTDECM ") * 60.0;
        this.delta += (double)headerFits.getIntFromHeader("PLTDECD ") * 3600.0;
        this.delta /= 3600.0;
        this.delta *= (double)n;
        this.focale = headerFits.getDoubleFromHeader("PLTSCALE");
        this.focale = 206264.80624709636 / this.focale;
        this.equinox = headerFits.getDoubleFromHeader("EQUINOX ");
        try {
            this.epoch = headerFits.getDoubleFromHeader("EPOCH  ");
            this.flagepoc = 1;
        }
        catch (Exception exception) {
            this.epoch = this.equinox;
            this.flagepoc = 0;
        }
        this.xz = headerFits.getDoubleFromHeader("PPO3    ");
        this.xz /= 1000.0;
        this.yz = headerFits.getDoubleFromHeader("PPO6    ");
        this.yz /= 1000.0;
        this.xyapoly[2] = headerFits.getDoubleFromHeader("AMDX1   ");
        this.xydpoly[1] = headerFits.getDoubleFromHeader("AMDY1   ");
        this.xyapoly[1] = headerFits.getDoubleFromHeader("AMDX2   ");
        this.xydpoly[2] = headerFits.getDoubleFromHeader("AMDY2   ");
        this.xyapoly[0] = headerFits.getDoubleFromHeader("AMDX3   ");
        this.xydpoly[0] = headerFits.getDoubleFromHeader("AMDY3   ");
        this.xyapoly[4] = headerFits.getDoubleFromHeader("AMDX4   ");
        this.xydpoly[3] = headerFits.getDoubleFromHeader("AMDY4   ");
        this.xyapoly[5] = headerFits.getDoubleFromHeader("AMDX5   ");
        this.xydpoly[5] = headerFits.getDoubleFromHeader("AMDY5   ");
        this.xyapoly[3] = headerFits.getDoubleFromHeader("AMDX6   ");
        this.xydpoly[4] = headerFits.getDoubleFromHeader("AMDY6   ");
        this.xyapoly[4] = this.xyapoly[4] + headerFits.getDoubleFromHeader("AMDX7   ");
        this.xydpoly[4] = this.xydpoly[4] + headerFits.getDoubleFromHeader("AMDY7   ");
        this.xyapoly[3] = this.xyapoly[3] + headerFits.getDoubleFromHeader("AMDX7   ");
        this.xydpoly[3] = this.xydpoly[3] + headerFits.getDoubleFromHeader("AMDY7   ");
        this.xyapoly[7] = headerFits.getDoubleFromHeader("AMDX8   ");
        this.xydpoly[6] = headerFits.getDoubleFromHeader("AMDY8   ");
        this.xyapoly[9] = headerFits.getDoubleFromHeader("AMDX9   ");
        this.xydpoly[8] = headerFits.getDoubleFromHeader("AMDY9   ");
        this.xyapoly[8] = headerFits.getDoubleFromHeader("AMDX10  ");
        this.xydpoly[9] = headerFits.getDoubleFromHeader("AMDY10  ");
        this.xyapoly[6] = headerFits.getDoubleFromHeader("AMDX11  ");
        this.xydpoly[7] = headerFits.getDoubleFromHeader("AMDY11  ");
        this.xyapoly[7] = this.xyapoly[7] + headerFits.getDoubleFromHeader("AMDX12  ");
        this.xydpoly[6] = this.xydpoly[6] + headerFits.getDoubleFromHeader("AMDY12  ");
        this.xyapoly[8] = this.xyapoly[8] + headerFits.getDoubleFromHeader("AMDX12  ");
        this.xydpoly[9] = this.xydpoly[9] + headerFits.getDoubleFromHeader("AMDY12  ");
        this.xyapoly[0] = this.xyapoly[0] / this.focale;
        this.xydpoly[0] = this.xydpoly[0] / this.focale;
        this.xyapoly[1] = this.xyapoly[1] * -1.0;
        this.xydpoly[1] = this.xydpoly[1] * -1.0;
        this.xyapoly[2] = this.xyapoly[2] * -1.0;
        this.xydpoly[2] = this.xydpoly[2] * -1.0;
        this.xyapoly[3] = this.xyapoly[3] * this.focale;
        this.xydpoly[3] = this.xydpoly[3] * this.focale;
        this.xyapoly[4] = this.xyapoly[4] * this.focale;
        this.xydpoly[4] = this.xydpoly[4] * this.focale;
        this.xyapoly[5] = this.xyapoly[5] * this.focale;
        this.xydpoly[5] = this.xydpoly[5] * this.focale;
        this.xyapoly[6] = this.xyapoly[6] * (-this.focale * this.focale);
        this.xydpoly[6] = this.xydpoly[6] * (-this.focale * this.focale);
        this.xyapoly[7] = this.xyapoly[7] * (-this.focale * this.focale);
        this.xydpoly[7] = this.xydpoly[7] * (-this.focale * this.focale);
        this.xyapoly[8] = this.xyapoly[8] * (-this.focale * this.focale);
        this.xydpoly[8] = this.xydpoly[8] * (-this.focale * this.focale);
        this.xyapoly[9] = this.xyapoly[9] * (-this.focale * this.focale);
        this.xydpoly[9] = this.xydpoly[9] * (-this.focale * this.focale);
        int n2 = 0;
        while (n2 <= 9) {
            int n3 = n2;
            this.xyapoly[n3] = this.xyapoly[n3] / (206264.80624709636 / this.focale);
            int n4 = n2++;
            this.xydpoly[n4] = this.xydpoly[n4] / (206264.80624709636 / this.focale);
        }
        this.incX = headerFits.getDoubleFromHeader("XPIXELSZ");
        this.incY = headerFits.getDoubleFromHeader("YPIXELSZ");
        this.xnpix = headerFits.getIntFromHeader("NAXIS1  ");
        this.ynpix = headerFits.getIntFromHeader("NAXIS2  ");
        this.Xorg = this.incX * headerFits.getDoubleFromHeader("CNPIX1  ");
        this.Yorg = this.incY * (23040.0 - headerFits.getDoubleFromHeader("CNPIX2  ") - (double)this.ynpix);
        this.yz = this.incY * 23040.0 / 1000.0 - this.yz;
        this.cdelz = FastMath.cos(this.delta * deg_to_rad);
        this.sdelz = FastMath.sin(this.delta * deg_to_rad);
        this.alphai = this.alpha;
        this.deltai = this.delta;
        this.incA = this.xyapoly[2] * this.incX / this.focale / 1000.0 * rad_to_deg;
        this.incD = this.xydpoly[1] * this.incY / this.focale / 1000.0 * rad_to_deg;
        this.widtha = (double)this.xnpix * Math.abs(this.incA);
        this.widthd = (double)this.ynpix * Math.abs(this.incD);
        this.aladin = 2;
    }

    protected void GetXYstand(Coord coord) throws Exception {
        double d = 1.0;
        double d2 = 1.0;
        double d3 = 0.03;
        double d4 = 0.03;
        if (this.aladin == 1) {
            double d5 = coord.del * deg_to_rad;
            double d6 = (coord.al - this.alpha) * deg_to_rad;
            double d7 = FastMath.sin(d5);
            double d8 = FastMath.cos(d5);
            double d9 = FastMath.sin(d6);
            double d10 = FastMath.cos(d6);
            double d11 = d7 * this.sdelz + d8 * this.cdelz * d10;
            d4 = d8 * d9 / d11;
            d3 = (d7 * this.cdelz - d8 * this.sdelz * d10) / d11;
        } else {
            Astrocoo astrocoo;
            double d12 = coord.al;
            double d13 = coord.del;
            coord.dx = coord.x - this.Xcen;
            coord.dy = coord.y - this.Ycen;
            if (this.system == FK4) {
                astrocoo = new Astrocoo(AF_ICRS, coord.al, coord.del);
                astrocoo.setPrecision(9);
                astrocoo.convertTo(AF_FK4);
                d12 = astrocoo.getLon();
                d13 = astrocoo.getLat();
            }
            if (this.system == FK5) {
                astrocoo = new Astrocoo(AF_ICRS, coord.al, coord.del);
                astrocoo.setPrecision(9);
                astrocoo.convertTo(AF_FK5);
                d12 = astrocoo.getLon();
                d13 = astrocoo.getLat();
            }
            if (this.system == GALACTIC) {
                astrocoo = new Astrocoo(AF_ICRS, coord.al, coord.del);
                astrocoo.setPrecision(9);
                astrocoo.convertTo(AF_GAL);
                d12 = astrocoo.getLon();
                d13 = astrocoo.getLat();
            }
            if (this.system == ECLIPTIC) {
                astrocoo = new Astrocoo(AF_ICRS, coord.al, coord.del);
                astrocoo.setPrecision(9);
                astrocoo.convertTo(AF_ECL);
                d12 = astrocoo.getLon();
                d13 = astrocoo.getLat();
            }
            if (this.system == SUPERGALACTIC) {
                astrocoo = new Astrocoo(AF_ICRS, coord.al, coord.del);
                astrocoo.setPrecision(9);
                astrocoo.convertTo(AF_SGAL);
                d12 = astrocoo.getLon();
                d13 = astrocoo.getLat();
            }
            double d14 = (d13 - this.deltai) * deg_to_rad;
            double d15 = (d12 - this.alphai) * deg_to_rad;
            double d16 = FastMath.cos(d13 * deg_to_rad);
            double d17 = FastMath.sin(d13 * deg_to_rad);
            double d18 = FastMath.sin(d15);
            double d19 = FastMath.cos(d15);
            double d20 = d16 * d18;
            double d21 = d17 * this.cdelz - d16 * this.sdelz * d19;
            switch (this.proj) {
                case 1: 
                case 8: {
                    d4 = d20;
                    d3 = d21;
                    if (this.xydpoly[1] == 0.0 || this.xydpoly[2] == 0.0) break;
                    d4 += this.xydpoly[1] * (1.0 - (d17 * this.cdelz - d16 * this.sdelz * d19));
                    d3 += this.xydpoly[2] * (1.0 - (d17 * this.cdelz - d16 * this.sdelz * d19));
                    break;
                }
                case 2: {
                    double d22 = d17 * this.sdelz + d16 * this.cdelz;
                    d4 = d20 / d22;
                    d3 = d21 / d22;
                    break;
                }
                case 3: 
                case 9: {
                    double d23;
                    double d24 = d17 * this.cdelz - d16 * this.sdelz * d19 != 0.0 ? Math.atan(-d16 * d18 / (d17 * this.cdelz - d16 * this.sdelz * d19)) : (-d16 * d18 < 0.0 ? 1.5707963267948966 : -1.5707963267948966);
                    if (d17 * this.cdelz - d16 * this.sdelz * d19 >= 0.0) {
                        d24 = Math.PI + d24;
                    }
                    double d25 = Math.asin(d17 * this.sdelz + d16 * this.cdelz * d19);
                    if (this.proj == 9) {
                        d23 = 0.0;
                        for (int i = 9; i >= 0; --i) {
                            d23 = d23 * (1.5707963267948966 - d25) + this.adxpoly[i];
                        }
                    } else {
                        d23 = 1.5707963267948966 - d25;
                    }
                    if (d23 < 0.0) {
                        System.out.println("rteta" + d23);
                    }
                    d4 = d23 * FastMath.sin(d24);
                    d3 = -d23 * FastMath.cos(d24);
                    break;
                }
                case 4: {
                    if (d12 > 180.0) {
                        d15 -= Math.PI * 2;
                    }
                    double d26 = FastMath.cos(d14);
                    double d27 = Math.sqrt(2.0 / (1.0 + d26 * FastMath.cos(d15 / 2.0)));
                    d4 = 2.0 * d27 * d26 * FastMath.sin(d15 / 2.0);
                    d3 = d27 * FastMath.sin(d14);
                    if (!(d15 / 2.0 > Math.PI)) break;
                    d4 = -d4;
                    break;
                }
                case 5: {
                    double d28 = d17 * this.cdelz - d16 * this.sdelz * d19 != 0.0 ? Math.atan(-d16 * d18 / (d17 * this.cdelz - d16 * this.sdelz * d19)) : (-d16 * d18 < 0.0 ? 1.5707963267948966 : -1.5707963267948966);
                    if (d17 * this.cdelz - d16 * this.sdelz * d19 > 0.0) {
                        d28 = Math.PI + d28;
                    }
                    double d29 = Math.asin(d17 * this.sdelz + d16 * this.cdelz * d19);
                    double d30 = Math.sqrt(2.0 * (1.0 - FastMath.sin(d29)));
                    d4 = d30 * FastMath.sin(d28);
                    d3 = -d30 * FastMath.cos(d28);
                    break;
                }
                case 6: {
                    double d31 = 1.0 + d17 * this.sdelz + d16 * this.cdelz * d19;
                    d4 = 2.0 * d20 / d31;
                    d3 = 2.0 * d21 / d31;
                    break;
                }
                case 7: {
                    d4 = (d12 - this.alphai) * deg_to_rad;
                    d3 = (d13 - this.deltai) * deg_to_rad;
                    break;
                }
            }
        }
        coord.xstand = d4;
        coord.ystand = d3;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    public void GetCoord(Coord var1_1) throws Exception {
        block50: {
            var2_2 = 1.0;
            var4_3 = 1.0;
            if (this.aladin == 1 || this.aladin == 2) {
                var2_2 = (var1_1.x * this.incX + this.Xorg) / 1000.0;
                var6_4 = (var2_2 - this.xz) / this.focale;
                var4_3 = (var1_1.y * this.incY + this.Yorg) / 1000.0;
                var8_6 = (var4_3 - this.yz) / this.focale;
                if (var6_4 * var6_4 + var8_6 * var8_6 > 0.19) {
                    throw new Exception("No coordinates");
                }
                var10_8 = this.xyapoly[0] + this.xyapoly[1] * var8_6 + this.xyapoly[2] * var6_4 + this.xyapoly[3] * var8_6 * var8_6 + this.xyapoly[4] * var6_4 * var6_4 + this.xyapoly[5] * var8_6 * var6_4 + this.xyapoly[6] * var8_6 * var8_6 * var8_6 + this.xyapoly[7] * var6_4 * var6_4 * var6_4 + this.xyapoly[8] * var8_6 * var8_6 * var6_4 + this.xyapoly[9] * var8_6 * var6_4 * var6_4;
                var12_10 = this.xydpoly[0] + this.xydpoly[1] * var8_6 + this.xydpoly[2] * var6_4 + this.xydpoly[3] * var8_6 * var8_6 + this.xydpoly[4] * var6_4 * var6_4 + this.xydpoly[5] * var8_6 * var6_4 + this.xydpoly[6] * var8_6 * var8_6 * var8_6 + this.xydpoly[7] * var6_4 * var6_4 * var6_4 + this.xydpoly[8] * var8_6 * var8_6 * var6_4 + this.xydpoly[9] * var8_6 * var6_4 * var6_4;
                var1_1.al = this.alpha + Math.atan(var10_8 / (this.cdelz - var12_10 * this.sdelz)) * Calib.rad_to_deg;
                var1_1.del = Math.atan(FastMath.cos((var1_1.al - this.alpha) * Calib.deg_to_rad) * (this.sdelz + var12_10 * this.cdelz) / (this.cdelz - var12_10 * this.sdelz)) * Calib.rad_to_deg;
                if (var1_1.del * this.delta < 0.0 && Math.abs(this.delta) > 87.0) {
                    var1_1.al += 180.0;
                    var1_1.del = -var1_1.del;
                }
                if (var1_1.al > 360.0) {
                    var1_1.al -= 360.0;
                }
                if (!(var1_1.al < 0.0)) return;
                var1_1.al += 360.0;
                return;
            }
            var2_2 = var1_1.x - this.Xcen;
            var4_3 = (double)this.ynpix - this.Ycen - var1_1.y;
            if (this.proj == 2 && this.xyapoly[1] != 0.0 && this.xyapoly[1] != 1.0 && this.aladin == 3 && this.xydpoly[2] * this.CD[1][1] < 0.0) {
                var4_3 = var1_1.y - this.Ycen;
            }
            if (this.proj == 12 || this.proj == 15) {
                var14_12 = var2_2;
                var16_13 = var4_3;
                for (var18_14 = 2; var18_14 < this.order_a + 1; ++var18_14) {
                    for (var19_20 = 0; var19_20 < var18_14 + 1; var2_2 += this.sip_a[var19_20][var18_14 - var19_20] * Math.pow(var14_12, var19_20) * Math.pow(var16_13, var18_14 - var19_20), ++var19_20) {
                    }
                }
                for (var18_14 = 2; var18_14 < this.order_b + 1; ++var18_14) {
                    for (var19_20 = 0; var19_20 < var18_14 + 1; var4_3 += this.sip_b[var19_20][var18_14 - var19_20] * Math.pow(var14_12, var19_20) * Math.pow(var16_13, var18_14 - var19_20), ++var19_20) {
                    }
                }
            }
            var6_5 = this.CD[0][0] * var2_2 + this.CD[0][1] * var4_3;
            var8_7 = this.CD[1][0] * var2_2 + this.CD[1][1] * var4_3;
            var6_5 *= Calib.deg_to_rad;
            var14_12 = var8_7 *= Calib.deg_to_rad;
            block0 : switch (this.proj) {
                case 1: 
                case 15: {
                    var1_1.del = Calib.rad_to_deg * Math.asin(var8_7 * this.cdelz + this.sdelz * Math.sqrt(1.0 - var8_7 * var8_7 - var6_5 * var6_5));
                    var16_13 = var6_5 / (this.cdelz * Math.sqrt(1.0 - var8_7 * var8_7 - var6_5 * var6_5) - var8_7 * this.sdelz);
                    var1_1.al = this.alphai + Calib.rad_to_deg * Math.atan(var16_13);
                    if (this.cdelz * Math.sqrt(1.0 - var8_7 * var8_7 - var6_5 * var6_5) - var8_7 * this.sdelz < 0.0) {
                        var1_1.al += 180.0;
                    }
                    if (this.xydpoly[1] == 0.0 || this.xydpoly[2] == 0.0) break;
                    var20_21 = this.xydpoly[1];
                    var22_27 = this.xydpoly[2];
                    var24_29 = var20_21 * var20_21 + var22_27 * var22_27 + 1.0;
                    var26_31 = (var6_5 - var20_21) * var20_21 + var22_27 * (var8_7 - var22_27);
                    var28_35 = (var6_5 - var20_21) * (var6_5 - var20_21) + (var8_7 - var22_27) * (var8_7 - var22_27) - 1.0;
                    var30_38 = (-var26_31 + Math.sqrt(var26_31 * var26_31 - var24_29 * var28_35)) / var24_29;
                    var18_15 = Math.asin(var30_38);
                    var32_43 = Math.atan2(var6_5 - var20_21 * (1.0 - var30_38), -(var8_7 - var22_27 * (1.0 - var30_38)));
                    var1_1.del = -Calib.rad_to_deg * Math.asin(-this.sdelz * FastMath.sin(var18_15) + this.cdelz * FastMath.cos(var18_15) * FastMath.cos(var32_43));
                    var34_46 = FastMath.sin(var18_15) * this.cdelz - FastMath.cos(var18_15) * this.sdelz * FastMath.cos(var32_43);
                    var36_50 = -(FastMath.cos(var18_15) * FastMath.sin(var32_43));
                    var1_1.al = Math.abs(this.deltai) != 90.0 ? this.alphai - Calib.rad_to_deg * Math.atan2(var36_50, var34_46) : (this.deltai == 90.0 ? Calib.rad_to_deg * (var32_43 + 3.141592653589793) : Calib.rad_to_deg * -var32_43);
                    if (!(var1_1.del * var1_1.del > 8100.0) || !(Math.abs(this.deltai) > 65.0)) break;
                    var1_1.al = 180.0 - var1_1.al;
                    var1_1.del = 2.0 * this.deltai - var1_1.del;
                    break;
                }
                case 8: {
                    var16_13 = var6_5 / (this.cdelz - var8_7 * this.sdelz);
                    var1_1.al = this.alphai + Calib.rad_to_deg * Math.atan(var16_13);
                    var1_1.del = Calib.rad_to_deg * Math.acos((this.cdelz - var14_12 * this.sdelz) / FastMath.cos((var1_1.al - this.alphai) * Calib.deg_to_rad));
                    if ((this.cdelz - var14_12 * this.sdelz) / FastMath.cos((var1_1.al - this.alphai) * Calib.deg_to_rad) > 1.0) {
                        var1_1.del = -32000.0;
                        var1_1.al = -32000.0;
                    }
                    if (this.sdelz < 0.0) {
                        var1_1.del = -var1_1.del;
                    }
                    if (var1_1.del > 90.0) {
                        var1_1.del = 180.0 - var1_1.del;
                        var1_1.al = 180.0 + var1_1.al;
                    }
                    if (!(var1_1.del < -90.0)) break;
                    var1_1.del = -180.0 - var1_1.del;
                    var1_1.al = 180.0 + var1_1.al;
                    break;
                }
                case 2: 
                case 12: 
                case 14: {
                    if (this.xyapoly[1] != 0.0 && this.xyapoly[1] != 1.0 && this.aladin == 0) {
                        var20_21 = Math.sqrt((var6_5 *= Calib.rad_to_deg) * var6_5 + (var14_12 *= Calib.rad_to_deg) * var14_12);
                        var10_9 = this.xyapoly[0] + this.xyapoly[1] * var6_5 + this.xyapoly[2] * var14_12 + this.xyapoly[3] * Math.sqrt(var6_5 * var6_5 + var14_12 * var14_12) + this.xyapoly[4] * var6_5 * var6_5 + this.xyapoly[5] * var14_12 * var6_5 + this.xyapoly[6] * var14_12 * var14_12 + this.xyapoly[7] * var6_5 * var6_5 * var6_5 + this.xyapoly[8] * var14_12 * var6_5 * var6_5 + this.xyapoly[9] * var14_12 * var14_12 * var6_5 + this.xyapoly[10] * var14_12 * var14_12 * var14_12 + this.xyapoly[11] * var20_21 * var20_21 * var20_21;
                        var12_11 = this.xydpoly[0] + this.xydpoly[1] * var14_12 + this.xydpoly[2] * var6_5 + this.xydpoly[3] * Math.sqrt(var6_5 * var6_5 + var14_12 * var14_12) + this.xydpoly[4] * var14_12 * var14_12 + this.xydpoly[5] * var14_12 * var6_5 + this.xydpoly[6] * var6_5 * var6_5 + this.xydpoly[7] * var14_12 * var14_12 * var14_12 + this.xydpoly[8] * var14_12 * var14_12 * var6_5 + this.xydpoly[9] * var14_12 * var6_5 * var6_5 + this.xydpoly[10] * var6_5 * var6_5 * var6_5 + this.xydpoly[11] * var20_21 * var20_21 * var20_21;
                        var6_5 = var10_9 * Calib.deg_to_rad;
                        var14_12 = var12_11 * Calib.deg_to_rad;
                    }
                    if (this.xyapoly[1] != 0.0 && this.xyapoly[1] != 1.0 && this.aladin == 3) {
                        var10_9 = this.xyapoly[0] + this.xyapoly[2] * (var14_12 *= Calib.rad_to_deg) + this.xyapoly[1] * (var6_5 *= Calib.rad_to_deg) + this.xyapoly[5] * var14_12 * var14_12 + this.xyapoly[3] * var6_5 * var6_5 + this.xyapoly[4] * var14_12 * var6_5 + this.xyapoly[9] * var14_12 * var14_12 * var14_12 + this.xyapoly[6] * var6_5 * var6_5 * var6_5 + this.xyapoly[8] * var14_12 * var14_12 * var6_5 + this.xyapoly[7] * var14_12 * var6_5 * var6_5;
                        var12_11 = this.xydpoly[0] + this.xydpoly[2] * var14_12 + this.xydpoly[1] * var6_5 + this.xydpoly[5] * var14_12 * var14_12 + this.xydpoly[3] * var6_5 * var6_5 + this.xydpoly[4] * var14_12 * var6_5 + this.xydpoly[9] * var14_12 * var14_12 * var14_12 + this.xydpoly[6] * var6_5 * var6_5 * var6_5 + this.xydpoly[8] * var14_12 * var14_12 * var6_5 + this.xydpoly[7] * var14_12 * var6_5 * var6_5;
                        var6_5 = var10_9;
                        var14_12 = var12_11;
                    }
                    var20_21 = this.cdelz - var14_12 * this.sdelz;
                    var22_28 = Math.atan(var6_5 / var20_21);
                    var1_1.del = 57.29577951308232 * Math.atan(FastMath.cos(var22_28) * (this.sdelz + var14_12 * this.cdelz) / var20_21);
                    var1_1.al = this.alphai + var22_28 * Calib.rad_to_deg;
                    if (!(var20_21 < 0.0)) break;
                    var1_1.al += 180.0;
                    var1_1.del = -var1_1.del;
                    break;
                }
                case 3: 
                case 9: {
                    var24_30 = Math.sqrt(var6_5 * var6_5 + var8_7 * var8_7);
                    if (this.proj != 9) ** GOTO lbl108
                    var18_16 = 0.0;
                    var26_32 = 20;
                    var29_53 = 0;
                    break block50;
lbl108:
                    // 1 sources

                    var18_16 = var24_30;
                    while (true) {
                        if (var24_30 == 0.0) {
                            var1_1.del = this.deltai;
                            var1_1.al = this.alphai;
                        } else {
                            var1_1.del = Calib.rad_to_deg * Math.asin(var8_7 * this.cdelz * FastMath.sin(var18_16) / var24_30 + this.sdelz * FastMath.cos(var18_16));
                        }
                        if (var18_16 == 0.0) {
                            var1_1.al = this.alphai;
                            break block0;
                        }
                        if (var18_16 < 1.5707963267948966 || var6_5 == 0.0) {
                            var1_1.al = this.alphai + Calib.rad_to_deg * Math.asin(FastMath.sin(var18_16) * var6_5 / (var24_30 * FastMath.cos(var1_1.del * Calib.deg_to_rad)));
                            break block0;
                        }
                        var1_1.al = this.alphai + 180.0 - Calib.rad_to_deg * Math.asin(FastMath.sin(var18_16) * var6_5 / (var24_30 * FastMath.cos(var1_1.del * Calib.deg_to_rad)));
                        break block0;
                        break;
                    }
                }
                case 4: {
                    var26_33 = FastMath.cos(this.deltai * Calib.deg_to_rad + 1.5707963267948966);
                    var28_36 = FastMath.sin(this.deltai * Calib.deg_to_rad + 1.5707963267948966);
                    if (this.deltai > 0.0) {
                        var26_33 = FastMath.cos((90.0 - this.deltai) * Calib.deg_to_rad);
                        var28_36 = FastMath.sin((90.0 - this.deltai) * Calib.deg_to_rad);
                    }
                    if ((var32_45 = 1.0 - var6_5 * var6_5 / 16.0 - var8_7 * var8_7 / 4.0) < 0.5) {
                        throw new Exception("No coordinates");
                    }
                    var34_48 = Math.sqrt(var32_45);
                    var18_17 = Math.asin(var8_7 * var34_48);
                    var30_40 = 2.0 * Math.atan(var6_5 * var34_48 / 2.0 / (2.0 * var34_48 * var34_48 - 1.0));
                    if (this.deltai < 0.0) {
                        var30_40 += 3.141592653589793;
                    }
                    var1_1.del = Calib.rad_to_deg * Math.asin(var28_36 * FastMath.sin(var18_17) + var26_33 * FastMath.cos(var18_17) * FastMath.cos(var30_40));
                    var36_51 = -(FastMath.sin(var18_17) * var26_33 - FastMath.cos(var18_17) * var28_36 * FastMath.cos(var30_40));
                    var38_55 = FastMath.cos(var18_17) * FastMath.sin(var30_40);
                    var1_1.al = this.alphai + Calib.rad_to_deg * Math.atan2(var38_55, var36_51);
                    if (this.deltai < 0.0) {
                        var1_1.al += 180.0;
                    }
                    if (!(var1_1.del * var1_1.del > 8100.0) || Math.abs(this.deltai) > 65.0) break;
                    break;
                }
                case 11: {
                    var26_34 = FastMath.cos(this.deltai * Calib.deg_to_rad + 1.5707963267948966);
                    var28_37 = FastMath.sin(this.deltai * Calib.deg_to_rad + 1.5707963267948966);
                    var34_49 = var6_5;
                    var36_52 = var8_7;
                    var38_56 = var34_49 * var34_49 / 8.0 + var36_52 * var36_52 / 2.0;
                    if (var38_56 > 1.0) {
                        throw new Exception("No coordinates");
                    }
                    var40_57 = Math.asin(var36_52 / Math.sqrt(2.0));
                    var42_58 = var40_57 * 2.0;
                    var44_59 = Math.asin((var42_58 + FastMath.sin(var42_58)) / 3.141592653589793);
                    var46_60 = 3.141592653589793 / (2.0 * Math.sqrt(2.0)) * (var34_49 / FastMath.cos(var40_57));
                    var1_1.del = Calib.rad_to_deg * Math.asin(var28_37 * FastMath.sin(var44_59) - var26_34 * FastMath.cos(var44_59) * FastMath.cos(var46_60));
                    var48_61 = FastMath.sin(var44_59) * var26_34 + FastMath.cos(var44_59) * var28_37 * FastMath.cos(var46_60);
                    var50_62 = FastMath.cos(var44_59) * FastMath.sin(var46_60);
                    var1_1.al = this.alphai + Calib.rad_to_deg * Math.atan2(var50_62, var48_61);
                    break;
                }
                case 5: {
                    var52_63 = Math.sqrt(var6_5 * var6_5 + var8_7 * var8_7) / 2.0;
                    var18_18 = 1.5707963267948966 - 2.0 * Math.asin(var52_63);
                    var30_41 = var8_7 != 0.0 ? Math.atan(-var6_5 / var8_7) : (var6_5 != 0.0 ? 1.5707963267948966 * (-var6_5 / var6_5) : 1.5707963267948966);
                    if (var8_7 < 0.0) {
                        var30_41 += 3.141592653589793;
                    }
                    var1_1.del = Calib.rad_to_deg * Math.asin(this.sdelz * FastMath.sin(var18_18) + this.cdelz * FastMath.cos(var18_18) * FastMath.cos(var30_41));
                    var54_64 = FastMath.sin(var18_18) * this.cdelz - FastMath.cos(var18_18) * this.sdelz * FastMath.cos(var30_41);
                    var56_65 = -(FastMath.cos(var18_18) * FastMath.sin(var30_41));
                    var1_1.al = Math.abs(this.deltai) != 90.0 ? this.alphai + Calib.rad_to_deg * Math.atan2(var56_65, var54_64) : (this.deltai == 90.0 ? Calib.rad_to_deg * (var30_41 + 3.141592653589793) : Calib.rad_to_deg * -var30_41);
                    if (!(var1_1.del * var1_1.del > 8100.0) || !(Math.abs(this.deltai) > 65.0)) break;
                    var1_1.al = 180.0 - var1_1.al;
                    var1_1.del = 2.0 * this.deltai - var1_1.del;
                    break;
                }
                case 6: {
                    var58_66 = FastMath.sin(1.5707963267948966 - 2.0 * Math.atan(Math.sqrt(var8_7 * var8_7 + var6_5 * var6_5) / 2.0));
                    var1_1.del = Calib.rad_to_deg * Math.asin(this.cdelz * var8_7 / 2.0 + var58_66 * (this.sdelz + this.cdelz * var8_7 / 2.0));
                    var20_21 = var58_66 * (2.0 * this.cdelz - var8_7 * this.sdelz) - var8_7 * this.sdelz;
                    var1_1.al = this.alphai + Calib.rad_to_deg * Math.atan2(var6_5 * (1.0 + var58_66), var20_21);
                    break;
                }
                case 13: {
                    var18_19 = Math.sqrt(var6_5 * var6_5 + var8_7 * var8_7);
                    var30_42 = Math.atan2(var8_7, var6_5);
                    var1_1.del = Calib.rad_to_deg * Math.asin(this.sdelz * FastMath.cos(var18_19) - this.cdelz * FastMath.sin(var18_19) * FastMath.cos(var30_42));
                    var60_67 = FastMath.cos(var18_19) * this.cdelz - FastMath.sin(var18_19) * this.sdelz * FastMath.cos(var30_42);
                    var62_68 = -(FastMath.sin(var18_19) * FastMath.sin(var30_42));
                    var1_1.al = this.alphai + Calib.rad_to_deg * Math.atan2(var62_68, var60_67);
                    break;
                }
                case 7: {
                    var1_1.al = this.alphai + var6_5 * Calib.rad_to_deg;
                    var1_1.del = this.deltai + var8_7 * Calib.rad_to_deg;
                    break;
                }
                case 10: {
                    var1_1.al = this.alphai + var6_5 * Calib.rad_to_deg;
                    var1_1.del = this.deltai + var8_7 * Calib.rad_to_deg;
                    break;
                }
            }
            if (this.system == Calib.XYLINEAR) {
                return;
            }
            if (this.system == Calib.FK4) {
                var20_22 = new Astrocoo(Calib.AF_FK4, var1_1.al, var1_1.del);
                var20_22.setPrecision(9);
                var20_22.convertTo(Calib.AF_ICRS);
                var1_1.al = var20_22.getLon();
                var1_1.del = var20_22.getLat();
            }
            if (this.system == Calib.FK5) {
                var20_23 = new Astrocoo(Calib.AF_FK5, var1_1.al, var1_1.del);
                var20_23.setPrecision(9);
                var20_23.convertTo(Calib.AF_ICRS);
                var1_1.al = var20_23.getLon();
                var1_1.del = var20_23.getLat();
            }
            if (this.system == Calib.GALACTIC) {
                var20_24 = new Astrocoo(Calib.AF_GAL, var1_1.al, var1_1.del);
                var20_24.setPrecision(9);
                var20_24.convertTo(Calib.AF_ICRS);
                var1_1.al = var20_24.getLon();
                var1_1.del = var20_24.getLat();
            }
            if (this.system == Calib.SUPERGALACTIC) {
                var20_25 = new Astrocoo(Calib.AF_SGAL, var1_1.al, var1_1.del);
                var20_25.setPrecision(9);
                var20_25.convertTo(Calib.AF_ICRS);
                var1_1.al = var20_25.getLon();
                var1_1.del = var20_25.getLat();
            }
            if (this.system == Calib.ECLIPTIC) {
                var20_26 = new Astrocoo(Calib.AF_ECL, var1_1.al, var1_1.del);
                var20_26.setPrecision(9);
                var20_26.convertTo(Calib.AF_ICRS);
                var1_1.al = var20_26.getLon();
                var1_1.del = var20_26.getLat();
            }
            if (var1_1.al >= 360.0) {
                var1_1.al -= 360.0;
            }
            if (!(var1_1.al < 0.0)) return;
            var1_1.al += 360.0;
            return;
        }
        while (true) {
            if (var29_53 >= var26_32) ** continue;
            var30_39 = 0.0;
            var32_44 = 0.0;
            for (var34_47 = 9; var34_47 >= 0; --var34_47) {
                var30_39 = var30_39 * var18_16 + this.adxpoly[var34_47];
            }
            for (var34_47 = 8; var34_47 >= 0; --var34_47) {
                var32_44 = var32_44 * var18_16 + (double)(var34_47 + 1) * this.adxpoly[var34_47 + 1];
            }
            var27_54 = (var24_30 - var30_39) / var32_44;
            var18_16 += var27_54;
            ++var29_53;
        }
    }

    protected boolean TheSame(Calib calib) {
        if (this.aladin == 1) {
            return false;
        }
        if (this.xnpix != calib.xnpix) {
            return false;
        }
        if (this.ynpix != calib.ynpix) {
            return false;
        }
        if (this.Xcen != calib.Xcen) {
            return false;
        }
        if (this.Ycen != calib.Ycen) {
            return false;
        }
        if (this.alphai != calib.alphai) {
            return false;
        }
        if (this.deltai != calib.deltai) {
            return false;
        }
        if (this.CD[0][0] != calib.CD[0][0]) {
            return false;
        }
        if (this.CD[0][1] != calib.CD[0][1]) {
            return false;
        }
        if (this.CD[1][0] != calib.CD[1][0]) {
            return false;
        }
        if (this.CD[1][1] != calib.CD[1][1]) {
            return false;
        }
        if (this.equinox != calib.equinox) {
            return false;
        }
        return this.proj == calib.proj;
    }

    public void GetXY(Coord coord) throws Exception {
        this.GetXY(coord, true);
    }

    public void GetXY(Coord coord, boolean bl) throws Exception {
        double d = 1.0;
        double d2 = 1.0;
        double d3 = 0.03;
        double d4 = 0.03;
        if (this.aladin == 1) {
            double d5;
            double d6 = FastMath.cos(coord.del * deg_to_rad);
            if (d6 * (d5 = Math.min(Math.abs(coord.al - this.alphai), 360.0 - Math.abs(coord.al - this.alphai))) * d6 * d5 + (coord.del - this.deltai) * (coord.del - this.deltai) > 625.0) {
                throw new Exception("Outside the projection");
            }
            double d7 = coord.del * deg_to_rad;
            double d8 = (coord.al - this.alpha) * deg_to_rad;
            double d9 = FastMath.sin(d7);
            double d10 = FastMath.cos(d7);
            double d11 = FastMath.sin(d8);
            double d12 = FastMath.cos(d8);
            double d13 = d9 * this.sdelz + d10 * this.cdelz * d12;
            d4 = d10 * d11 / d13;
            d3 = (d9 * this.cdelz - d10 * this.sdelz * d12) / d13;
            d = this.adxpoly[0] + this.adxpoly[1] * d4 + this.adxpoly[2] * d3 + this.adxpoly[3] * d4 * d4 + this.adxpoly[4] * d3 * d3 + this.adxpoly[5] * d3 * d4 + this.adxpoly[6] * d4 * d4 * d4 + this.adxpoly[7] * d3 * d3 * d3 + this.adxpoly[8] * d3 * d4 * d4 + this.adxpoly[9] * d3 * d3 * d4;
            d2 = this.adypoly[0] + this.adypoly[1] * d4 + this.adypoly[2] * d3 + this.adypoly[3] * d4 * d4 + this.adypoly[4] * d3 * d3 + this.adypoly[5] * d3 * d4 + this.adypoly[6] * d4 * d4 * d4 + this.adypoly[7] * d3 * d3 * d3 + this.adypoly[8] * d3 * d4 * d4 + this.adypoly[9] * d3 * d3 * d4;
            d = d * this.focale + this.xz;
            d2 = d2 * this.focale + this.yz;
            coord.x = (d * 1000.0 - this.Xorg) / this.incX;
            coord.y = (d2 * 1000.0 - this.Yorg) / this.incY;
        } else {
            double d14;
            double d15;
            double d16;
            double d17;
            double d18;
            double d19;
            double d20;
            double d21;
            double d22;
            double d23;
            double d24;
            double d25;
            double d26 = coord.al;
            double d27 = coord.del;
            if (this.system != ICRS && this.system != XYLINEAR) {
                Astroframe astroframe = this.system == FK4 ? AF_FK4 : (this.system == FK5 ? AF_FK5 : (this.system == GALACTIC ? AF_GAL : (this.system == SUPERGALACTIC ? AF_SGAL : (this.system == ECLIPTIC ? AF_ECL : null))));
                Astrocoo astrocoo = new Astrocoo(AF_ICRS, coord.al, coord.del);
                astrocoo.setPrecision(9);
                astrocoo.convertTo(astroframe);
                d26 = astrocoo.getLon();
                d27 = astrocoo.getLat();
            }
            double d28 = (d26 - this.alphai) * deg_to_rad;
            double d29 = FastMath.cos(d27 * deg_to_rad);
            double d30 = FastMath.sin(d27 * deg_to_rad);
            double d31 = FastMath.sin(d28);
            double d32 = FastMath.cos(d28);
            double d33 = d29 * d31;
            double d34 = d30 * this.cdelz - d29 * this.sdelz * d32;
            if (bl) {
                switch (this.proj) {
                    case 1: 
                    case 2: 
                    case 8: 
                    case 12: 
                    case 14: 
                    case 15: {
                        if (d28 > Math.PI) {
                            d28 = Math.PI * -2 + d28;
                        }
                        if (d28 < -Math.PI) {
                            d28 = Math.PI * 2 + d28;
                        }
                        if (-d30 * this.sdelz / (d29 * this.cdelz) > 1.0) {
                            throw new Exception("Outside the projection");
                        }
                        if (!(-d30 * this.sdelz / (d29 * this.cdelz) > -1.0) || !(Math.abs(d28) > Math.acos(-d30 * this.sdelz / (d29 * this.cdelz)))) break;
                        throw new Exception("Outside the projection");
                    }
                }
            }
            switch (this.proj) {
                case 1: 
                case 15: {
                    d4 = rad_to_deg * d33;
                    d3 = rad_to_deg * d34;
                    if (this.xydpoly[1] == 0.0 || this.xydpoly[2] == 0.0) break;
                    d4 += rad_to_deg * this.xydpoly[1] * (1.0 - (d30 * this.sdelz + d29 * this.cdelz * d32));
                    d3 += rad_to_deg * this.xydpoly[2] * (1.0 - (d30 * this.sdelz + d29 * this.cdelz * d32));
                    break;
                }
                case 8: {
                    d4 = rad_to_deg * d33;
                    if (this.sdelz == 0.0) {
                        d3 = rad_to_deg * d34;
                        break;
                    }
                    if (this.sdelz * d30 > 0.0) {
                        d3 = rad_to_deg * d34 + this.cdelz / this.sdelz * rad_to_deg * (1.0 - Math.sqrt(1.0 - d29 * d29 * d31 * d31 - d30 * d30 * this.cdelz * this.cdelz - d29 * d29 * this.sdelz * this.sdelz * d32 * d32 + 2.0 * d30 * d29 * this.sdelz * this.cdelz * d32));
                        break;
                    }
                    d4 = 0.0;
                    d3 = 0.0;
                    break;
                }
                case 2: 
                case 12: 
                case 14: {
                    int n;
                    double d35;
                    d25 = d30 * this.sdelz + d29 * this.cdelz * d32;
                    d4 = d33 / d25;
                    d3 = d34 / d25;
                    if (this.xyapoly[1] != 0.0 && this.xyapoly[1] != 1.0 && this.aladin == 0) {
                        d4 *= rad_to_deg;
                        d3 *= rad_to_deg;
                        d24 = this.xyapoly[0];
                        double d36 = this.xydpoly[0];
                        d23 = 0.0;
                        d35 = 0.0;
                        int n2 = 20;
                        for (n = 0; n < n2; ++n) {
                            d22 = d23 == 0.0 & d35 == 0.0 ? 1.0 : Math.sqrt(d23 * d23 + d35 * d35);
                            d21 = this.xyapoly[1] + this.xyapoly[3] * d23 / d22 + 2.0 * this.xyapoly[4] * d23 + this.xyapoly[5] * d35 + 3.0 * this.xyapoly[7] * d23 * d23 + this.xyapoly[9] * d35 * d35 + 2.0 * this.xyapoly[8] * d35 * d23 + 3.0 * this.xyapoly[11] * d23 * Math.sqrt(d23 * d23 + d35 * d35);
                            d20 = this.xydpoly[2] + this.xydpoly[3] * d23 / d22 + 2.0 * this.xydpoly[6] * d23 + this.xydpoly[5] * d35 + 3.0 * this.xydpoly[10] * d23 * d23 + this.xydpoly[8] * d35 * d35 + 2.0 * this.xydpoly[9] * d35 * d23 + 3.0 * this.xydpoly[11] * d23 * Math.sqrt(d23 * d23 + d35 * d35);
                            d19 = this.xyapoly[2] + this.xyapoly[3] * d35 / d22 + 2.0 * this.xyapoly[6] * d35 + this.xyapoly[5] * d23 + 3.0 * this.xyapoly[10] * d35 * d35 + 2.0 * this.xyapoly[9] * d35 * d23 + this.xyapoly[8] * d23 * d23 + 3.0 * this.xyapoly[11] * d35 * Math.sqrt(d23 * d23 + d35 * d35);
                            d18 = this.xydpoly[1] + this.xydpoly[3] * d35 / d22 + 2.0 * this.xydpoly[4] * d35 + this.xydpoly[5] * d23 + 3.0 * this.xydpoly[7] * d35 * d35 + 2.0 * this.xydpoly[8] * d35 * d23 + this.xydpoly[9] * d23 * d23 + 3.0 * this.xydpoly[11] * d35 * Math.sqrt(d23 * d23 + d35 * d35);
                            d17 = d21 * d18 - d20 * d19;
                            d16 = d18 / d17;
                            d18 = d21 / d17;
                            d21 = d16;
                            d15 = d21 * (d4 - d24) + (d19 /= -d17) * (d3 - d36);
                            d14 = (d20 /= -d17) * (d4 - d24) + d18 * (d3 - d36);
                            d22 = Math.sqrt((d23 += d15) * d23 + (d35 += d14) * d35);
                            d24 = this.xyapoly[0] + this.xyapoly[2] * d35 + this.xyapoly[1] * d23 + this.xyapoly[3] * Math.sqrt(d23 * d23 + d35 * d35) + this.xyapoly[6] * d35 * d35 + this.xyapoly[4] * d23 * d23 + this.xyapoly[5] * d35 * d23 + this.xyapoly[10] * d35 * d35 * d35 + this.xyapoly[7] * d23 * d23 * d23 + this.xyapoly[9] * d35 * d35 * d23 + this.xyapoly[8] * d35 * d23 * d23 + this.xyapoly[11] * d22 * d22 * d22;
                            d36 = this.xydpoly[0] + this.xydpoly[1] * d35 + this.xydpoly[2] * d23 + this.xydpoly[3] * Math.sqrt(d23 * d23 + d35 * d35) + this.xydpoly[4] * d35 * d35 + this.xydpoly[6] * d23 * d23 + this.xydpoly[5] * d35 * d23 + this.xydpoly[7] * d35 * d35 * d35 + this.xydpoly[10] * d23 * d23 * d23 + this.xydpoly[8] * d35 * d35 * d23 + this.xydpoly[9] * d35 * d23 * d23 + this.xydpoly[11] * d22 * d22 * d22;
                        }
                        d4 = d23;
                        d3 = d35;
                        break;
                    }
                    if (this.xyapoly[1] != 0.0 && this.xyapoly[1] != 1.0 && this.aladin == 3) {
                        d24 = this.xyapoly[0];
                        double d37 = this.xydpoly[0];
                        d23 = 0.0;
                        d35 = 0.0;
                        int n3 = 20;
                        for (n = 0; n < n3; ++n) {
                            d21 = this.xyapoly[1] + 2.0 * this.xyapoly[3] * d23 + this.xyapoly[4] * d35 + 3.0 * this.xyapoly[6] * d23 * d23 + this.xyapoly[8] * d35 * d35 + 2.0 * this.xyapoly[7] * d35 * d23;
                            d20 = this.xydpoly[1] + 2.0 * this.xydpoly[3] * d23 + this.xydpoly[4] * d35 + 3.0 * this.xydpoly[6] * d23 * d23 + this.xydpoly[8] * d35 * d35 + 2.0 * this.xydpoly[7] * d35 * d23;
                            d19 = this.xyapoly[2] + 2.0 * this.xyapoly[5] * d35 + this.xyapoly[4] * d23 + 3.0 * this.xyapoly[9] * d35 * d35 + 2.0 * this.xyapoly[8] * d35 * d23 + this.xyapoly[7] * d23 * d23;
                            d18 = this.xydpoly[2] + 2.0 * this.xydpoly[5] * d35 + this.xydpoly[4] * d23 + 3.0 * this.xydpoly[9] * d35 * d35 + 2.0 * this.xydpoly[8] * d35 * d23 + this.xydpoly[7] * d23 * d23;
                            d22 = d21 * d18 - d20 * d19;
                            d17 = d18 / d22;
                            d18 = d21 / d22;
                            d21 = d17;
                            d15 = d21 * (d4 - d24) + (d19 /= -d22) * (d3 - d37);
                            d14 = (d20 /= -d22) * (d4 - d24) + d18 * (d3 - d37);
                            d24 = this.xyapoly[0] + this.xyapoly[2] * (d35 += d14) + this.xyapoly[1] * (d23 += d15) + this.xyapoly[5] * d35 * d35 + this.xyapoly[3] * d23 * d23 + this.xyapoly[4] * d35 * d23 + this.xyapoly[9] * d35 * d35 * d35 + this.xyapoly[6] * d23 * d23 * d23 + this.xyapoly[8] * d35 * d35 * d23 + this.xyapoly[7] * d35 * d23 * d23;
                            d37 = this.xydpoly[0] + this.xydpoly[2] * d35 + this.xydpoly[1] * d23 + this.xydpoly[5] * d35 * d35 + this.xydpoly[3] * d23 * d23 + this.xydpoly[4] * d35 * d23 + this.xydpoly[9] * d35 * d35 * d35 + this.xydpoly[6] * d23 * d23 * d23 + this.xydpoly[8] * d35 * d35 * d23 + this.xydpoly[7] * d35 * d23 * d23;
                        }
                        d4 = d23;
                        d3 = d35;
                        break;
                    }
                    if (this.xyapoly[1] != 0.0 && this.xyapoly[1] != 1.0 && this.aladin == 2) {
                        d24 = this.xyapoly[0];
                        double d38 = this.xydpoly[0];
                        d23 = 0.0;
                        d35 = 0.0;
                        int n4 = 5;
                        for (n = 0; n < n4; ++n) {
                            d21 = this.xyapoly[2] + 2.0 * this.xyapoly[4] * d23 + this.xyapoly[5] * d35 + 3.0 * this.xyapoly[7] * d23 * d23 + this.xyapoly[8] * d35 * d35 + 2.0 * this.xyapoly[9] * d35 * d23;
                            d20 = this.xydpoly[2] + 2.0 * this.xydpoly[4] * d23 + this.xydpoly[5] * d35 + 3.0 * this.xydpoly[7] * d23 * d23 + this.xydpoly[8] * d35 * d35 + 2.0 * this.xydpoly[9] * d35 * d23;
                            d19 = this.xyapoly[1] + 2.0 * this.xyapoly[3] * d35 + this.xyapoly[5] * d23 + 3.0 * this.xyapoly[6] * d35 * d35 + 2.0 * this.xyapoly[8] * d35 * d23 + this.xyapoly[9] * d23 * d23;
                            d18 = this.xydpoly[1] + 2.0 * this.xydpoly[3] * d35 + this.xydpoly[5] * d23 + 3.0 * this.xydpoly[6] * d35 * d35 + 2.0 * this.xydpoly[8] * d35 * d23 + this.xydpoly[9] * d23 * d23;
                            d22 = d21 * d18 - d20 * d19;
                            d17 = d18 / d22;
                            d18 = d21 / d22;
                            d21 = d17;
                            d15 = d21 * (d4 - d24) + (d19 /= -d22) * (d3 - d38);
                            d14 = (d20 /= -d22) * (d4 - d24) + d18 * (d3 - d38);
                            d24 = this.xyapoly[0] + this.xyapoly[1] * (d35 += d14) + this.xyapoly[2] * (d23 += d15) + this.xyapoly[3] * d35 * d35 + this.xyapoly[4] * d23 * d23 + this.xyapoly[5] * d35 * d23 + this.xyapoly[6] * d35 * d35 * d35 + this.xyapoly[7] * d23 * d23 * d23 + this.xyapoly[8] * d35 * d35 * d23 + this.xyapoly[9] * d35 * d23 * d23;
                            d38 = this.xydpoly[0] + this.xydpoly[1] * d35 + this.xydpoly[2] * d23 + this.xydpoly[3] * d35 * d35 + this.xydpoly[4] * d23 * d23 + this.xydpoly[5] * d35 * d23 + this.xydpoly[6] * d35 * d35 * d35 + this.xydpoly[7] * d23 * d23 * d23 + this.xydpoly[8] * d35 * d35 * d23 + this.xydpoly[9] * d35 * d23 * d23;
                        }
                        d4 = d23;
                        d3 = d35;
                        break;
                    }
                    d4 *= rad_to_deg;
                    d3 *= rad_to_deg;
                    break;
                }
                case 3: 
                case 9: 
                case 16: {
                    double d39 = d30 * this.cdelz - d29 * this.sdelz * d32 != 0.0 ? Math.atan(-d29 * d31 / (d30 * this.cdelz - d29 * this.sdelz * d32)) : (-d29 * d31 < 0.0 ? 1.5707963267948966 : -1.5707963267948966);
                    if (d30 * this.cdelz - d29 * this.sdelz * d32 > 0.0) {
                        d39 = Math.PI + d39;
                    }
                    double d40 = Math.asin(d30 * this.sdelz + d29 * this.cdelz * d32);
                    if (this.proj == 9) {
                        d24 = 0.0;
                        for (int i = 9; i >= 0; --i) {
                            d24 = d24 * (1.5707963267948966 - d40) + this.adxpoly[i];
                        }
                    } else {
                        d24 = 1.5707963267948966 - d40;
                    }
                    if (this.proj == 16 && d24 > Math.toRadians(95.0)) {
                        d4 = Double.NaN;
                        d3 = Double.NaN;
                        break;
                    }
                    d4 = d24 * FastMath.sin(d39);
                    d3 = -d24 * FastMath.cos(d39);
                    d4 *= rad_to_deg;
                    d3 *= rad_to_deg;
                    break;
                }
                case 4: {
                    double d41 = FastMath.cos(this.deltai * deg_to_rad + 1.5707963267948966);
                    d15 = FastMath.sin(this.deltai * deg_to_rad + 1.5707963267948966);
                    double d39 = Math.atan2(d29 * d31, -(d30 * d41 - d29 * d15 * d32));
                    double d40 = Math.asin(d30 * d15 + d29 * d41 * d32);
                    if (d39 > Math.PI) {
                        d39 = Math.PI * -2 + d39;
                    }
                    d14 = Math.sqrt(2.0 / (1.0 + FastMath.cos(d40) * FastMath.cos(d39 / 2.0)));
                    d4 = 2.0 * d14 * FastMath.cos(d40) * FastMath.sin(d39 / 2.0);
                    d3 = d14 * FastMath.sin(d40);
                    d4 *= rad_to_deg;
                    d3 *= rad_to_deg;
                    break;
                }
                case 11: {
                    double d42 = FastMath.cos(this.deltai * deg_to_rad + 1.5707963267948966);
                    d15 = FastMath.sin(this.deltai * deg_to_rad + 1.5707963267948966);
                    double d39 = Math.atan2(d29 * d31, -(d30 * d42 - d29 * d15 * d32));
                    double d40 = Math.asin(d30 * d15 + d29 * d42 * d32);
                    d23 = 2.0 * Math.asin(2.0 * d40 / Math.PI);
                    double d35 = 0.0;
                    for (int i = 0; i < 200; ++i) {
                        d35 = d23;
                        if (Double.isNaN(d23 -= (d23 + FastMath.sin(d23) - Math.PI * FastMath.sin(d40)) / (1.0 + FastMath.cos(d23)))) {
                            d23 = d35;
                            break;
                        }
                        if (Math.abs(d23 - d35) > 1.0E-4) break;
                    }
                    double d43 = d23 / 2.0;
                    d4 = 2.0 * Math.sqrt(2.0) / Math.PI * d39 * FastMath.cos(d43) * rad_to_deg;
                    d3 = Math.sqrt(2.0) * FastMath.sin(d43) * rad_to_deg;
                    break;
                }
                case 5: {
                    double d39 = d30 * this.cdelz - d29 * this.sdelz * d32 != 0.0 ? Math.atan(-d29 * d31 / (d30 * this.cdelz - d29 * this.sdelz * d32)) : (-d29 * d31 < 0.0 ? 1.5707963267948966 : -1.5707963267948966);
                    if (d30 * this.cdelz - d29 * this.sdelz * d32 > 0.0 && Math.abs(FastMath.sin(d39)) != 1.0) {
                        d39 = Math.PI + d39;
                    }
                    double d40 = Math.asin(d30 * this.sdelz + d29 * this.cdelz * d32);
                    d21 = rad_to_deg * Math.sqrt(2.0 * (1.0 - FastMath.sin(d40)));
                    d4 = d21 * FastMath.sin(d39);
                    d3 = -d21 * FastMath.cos(d39);
                    break;
                }
                case 6: {
                    d25 = 1.0 + d30 * this.sdelz + d29 * this.cdelz * d32;
                    d4 = 2.0 * d33 / d25;
                    d3 = 2.0 * d34 / d25;
                    d4 *= rad_to_deg;
                    d3 *= rad_to_deg;
                    break;
                }
                case 13: {
                    double d39 = Math.atan2(-d29 * d31, d30 * this.cdelz - d29 * this.sdelz * d32);
                    double d40 = Math.asin(d30 * this.sdelz + d29 * this.cdelz * d32);
                    d4 = d40 * Math.cos(d39);
                    d3 = d40 * Math.sin(d39);
                    d4 *= rad_to_deg;
                    d3 *= rad_to_deg;
                    break;
                }
                case 7: {
                    d4 = d26 - this.alphai;
                    d3 = d27 - this.deltai;
                    d20 = 0.0;
                    if (d4 + 360.0 > Math.min(this.CD[0][0] * -this.Xcen + this.CD[0][1] * this.Ycen, this.CD[0][0] * ((double)this.xnpix - this.Xcen) + this.CD[0][1] * this.Ycen) && d4 + 360.0 < Math.max(this.CD[0][0] * -this.Xcen + this.CD[0][1] * this.Ycen, this.CD[0][0] * ((double)this.xnpix - this.Xcen) + this.CD[0][1] * this.Ycen)) {
                        d20 = 360.0;
                    }
                    if (d4 - 360.0 > Math.min(this.CD[0][0] * -this.Xcen + this.CD[0][1] * this.Ycen, this.CD[0][0] * ((double)this.xnpix - this.Xcen) + this.CD[0][1] * this.Ycen) && d4 - 360.0 < Math.max(this.CD[0][0] * -this.Xcen + this.CD[0][1] * this.Ycen, this.CD[0][0] * ((double)this.xnpix - this.Xcen) + this.CD[0][1] * this.Ycen)) {
                        d20 = -360.0;
                    }
                    d4 += d20;
                    break;
                }
                case 10: {
                    d4 = d26 - this.alphai;
                    d3 = d27 - this.deltai;
                    break;
                }
            }
            if (this.aladin != 2) {
                coord.x = this.ID[0][0] * d4 + this.ID[0][1] * d3 + this.Xcen;
                coord.y = -(this.ID[1][0] * d4 + this.ID[1][1] * d3) + (double)this.ynpix - this.Ycen;
                if (this.xyapoly[1] != 0.0 && this.xyapoly[1] != 1.0 && (this.proj == 2 || this.proj == 12) && this.aladin == 3 && this.xydpoly[2] * this.ID[1][1] < 0.0) {
                    coord.y = this.ID[1][0] * d4 + this.ID[1][1] * d3 + this.Ycen;
                }
                if (this.proj == 12) {
                    if (this.order_ap == 0 || this.order_bp == 0) {
                        d25 = 0.0;
                        d24 = 0.0;
                        d14 = 0.0;
                        d23 = 0.0;
                        int n = 20;
                        int n5 = 0;
                        while (n5 < n) {
                            int n6;
                            int n7;
                            int n8;
                            int n9;
                            ++n5;
                            double d44 = 1.0;
                            for (n9 = 2; n9 < this.order_a + 1; ++n9) {
                                for (n8 = 0; n8 < n9 + 1; ++n8) {
                                    d44 += (double)n8 * this.sip_a[n8][n9 - n8] * Math.pow(d14, n8 - 1) * Math.pow(d23, n9 - n8);
                                }
                            }
                            d21 = 0.0;
                            for (n9 = 2; n9 < this.order_a + 1; ++n9) {
                                for (n8 = 0; n8 < n9 + 1; ++n8) {
                                    d21 += (double)(n9 - n8) * this.sip_a[n8][n9 - n8] * Math.pow(d14, n8) * Math.pow(d23, n9 - n8 - 1);
                                }
                            }
                            d20 = 1.0;
                            for (n9 = 2; n9 < this.order_b + 1; ++n9) {
                                for (n8 = 0; n8 < n9 + 1; ++n8) {
                                    d20 += (double)n8 * this.sip_b[n8][n9 - n8] * Math.pow(d14, n8 - 1) * Math.pow(d23, n9 - n8);
                                }
                            }
                            d19 = 0.0;
                            for (n9 = 2; n9 < this.order_b + 1; ++n9) {
                                for (n8 = 0; n8 < n9 + 1; ++n8) {
                                    d19 += (double)(n9 - n8) * this.sip_b[n8][n9 - n8] * Math.pow(d14, n8) * Math.pow(d23, n9 - n8 - 1);
                                }
                            }
                            d18 = d44 * d19 - d21 * d20;
                            d22 = d19 / d18;
                            d21 /= -d18;
                            d19 = d44 / d18;
                            d44 = d22;
                            d17 = this.ID[0][0] * (d4 - d25) + this.ID[0][1] * (d3 - d24);
                            d16 = this.ID[1][0] * (d4 - d25) + this.ID[1][1] * (d3 - d24);
                            double d45 = d44 * d17 + (d20 /= -d18) * d16;
                            d15 = d21 * d17 + d19 * d16;
                            double d46 = d14 += d45;
                            double d47 = d23 += d15;
                            double d48 = d46;
                            double d49 = d47;
                            for (n7 = 2; n7 < this.order_a + 1; ++n7) {
                                for (n6 = 0; n6 < n7 + 1; ++n6) {
                                    d48 += this.sip_a[n6][n7 - n6] * Math.pow(d46, n6) * Math.pow(d47, n7 - n6);
                                }
                            }
                            for (n7 = 2; n7 < this.order_b + 1; ++n7) {
                                for (n6 = 0; n6 < n7 + 1; ++n6) {
                                    d49 += this.sip_b[n6][n7 - n6] * Math.pow(d46, n6) * Math.pow(d47, n7 - n6);
                                }
                            }
                            d25 = this.CD[0][0] * d48 + this.CD[0][1] * d49;
                            d24 = this.CD[1][0] * d48 + this.CD[1][1] * d49;
                        }
                        coord.x = d14 + this.Xcen;
                        coord.y = d23 + (double)this.ynpix - this.Ycen;
                    } else {
                        int n;
                        int n10;
                        d25 = coord.x - this.Xcen;
                        d24 = -(coord.y - (double)this.ynpix + this.Ycen);
                        coord.x = d25;
                        for (n10 = 2; n10 < this.order_ap + 1; ++n10) {
                            for (n = 0; n < n10 + 1; ++n) {
                                for (int i = 0; i < n10 - n + 1; ++i) {
                                    coord.x += this.sip_ap[n][i] * Math.pow(d25, n) * Math.pow(d24, i);
                                }
                            }
                        }
                        coord.x += this.Xcen;
                        coord.y = d24;
                        for (n10 = 2; n10 < this.order_bp + 1; ++n10) {
                            for (n = 0; n < n10 + 1; ++n) {
                                for (int i = 0; i < n10 - n + 1; ++i) {
                                    coord.y += this.sip_bp[n][i] * Math.pow(d25, n) * Math.pow(d24, i);
                                }
                            }
                        }
                        coord.y = -coord.y + (double)this.ynpix - this.Ycen;
                    }
                }
            } else {
                coord.x = (d4 * this.focale * 1000.0 + this.xz * 1000.0 - this.Xorg) / this.incX;
                coord.y = (d3 * this.focale * 1000.0 + this.yz * 1000.0 - this.Yorg) / this.incY;
            }
        }
    }

    public double[] GetResol() {
        double[] dArray = new double[]{Math.abs(this.incA), Math.abs(this.incD)};
        return dArray;
    }

    protected void GetWCS_i() throws Exception {
        Coord coord = new Coord();
        Coord coord2 = new Coord();
        Coord coord3 = new Coord();
        Coord coord4 = new Coord();
        Coord coord5 = new Coord();
        if (this.aladin == 1) {
            this.Xcen = (this.xz * 1000.0 - this.Xorg) / this.incX;
            this.Ycen = (this.yz * 1000.0 - this.Yorg) / this.incY;
            this.alphai = this.alpha;
            this.deltai = this.delta;
            this.CD[0][0] = 1.0;
            this.CD[0][1] = 0.0;
            this.CD[1][0] = 0.0;
            this.CD[1][1] = 1.0;
            this.ID[0][0] = 1.0;
            this.ID[0][1] = 0.0;
            this.ID[1][0] = 0.0;
            this.ID[1][1] = 1.0;
            this.Xcen = (double)this.xnpix / 2.0;
            this.Ycen = (double)this.ynpix / 2.0;
            coord.x = this.Xcen;
            coord.y = this.Ycen;
            this.GetCoord(coord);
            this.alphai = coord.al;
            this.deltai = coord.del;
            coord2.x = this.Xcen - (double)this.xnpix / 4.0;
            coord2.y = this.Ycen - (double)this.ynpix / 4.0;
            this.GetCoord(coord2);
            double d = FastMath.cos(this.deltai / 180.0 * Math.PI);
            double d2 = FastMath.sin(this.deltai / 180.0 * Math.PI);
            double d3 = FastMath.sin(coord2.del * Math.PI / 180.0) * d2 + FastMath.cos(coord2.del * Math.PI / 180.0) * d * FastMath.cos((coord2.al - this.alphai) * Math.PI / 180.0);
            double d4 = FastMath.cos(coord2.del * Math.PI / 180.0) * FastMath.sin((coord2.al - this.alphai) * Math.PI / 180.0) / d3;
            double d5 = FastMath.sin(coord2.del * Math.PI / 180.0) * d - FastMath.cos(coord2.del * Math.PI / 180.0) * d2 * FastMath.cos((coord2.al - this.alphai) * Math.PI / 180.0) / d3;
            this.CD[0][0] = -((double)this.ynpix * d4 + (double)this.xnpix * d5) * 2.0 / (double)this.ynpix / (double)this.xnpix;
            this.CD[0][1] = ((double)this.ynpix * d4 - (double)this.xnpix * d5) * 2.0 / (double)this.xnpix / (double)this.ynpix;
            coord3.x = this.Xcen + (double)this.xnpix / 4.0;
            coord3.y = this.Ycen - (double)this.ynpix / 4.0;
            this.GetCoord(coord3);
            d3 = FastMath.sin(coord3.del * Math.PI / 180.0) * d2 + FastMath.cos(coord3.del * Math.PI / 180.0) * d * FastMath.cos((coord3.al - this.alphai) * Math.PI / 180.0);
            d4 = FastMath.cos(coord3.del * Math.PI / 180.0) * FastMath.sin((coord3.al - this.alphai) * Math.PI / 180.0) / d3;
            d5 = FastMath.sin(coord3.del * Math.PI / 180.0) * d - FastMath.cos(coord3.del * Math.PI / 180.0) * d2 * FastMath.cos((coord3.al - this.alphai) * Math.PI / 180.0) / d3;
            double[] dArray = this.CD[0];
            dArray[0] = dArray[0] + ((double)this.ynpix * d4 - (double)this.xnpix * d5) * 2.0 / (double)this.ynpix / (double)this.xnpix;
            double[] dArray2 = this.CD[0];
            dArray2[1] = dArray2[1] + ((double)this.ynpix * d4 + (double)this.xnpix * d5) * 2.0 / (double)this.xnpix / (double)this.ynpix;
            coord4.x = this.Xcen - (double)this.xnpix / 4.0;
            coord4.y = this.Ycen + (double)this.ynpix / 4.0;
            this.GetCoord(coord4);
            d3 = FastMath.sin(coord4.del * Math.PI / 180.0) * d2 + FastMath.cos(coord4.del * Math.PI / 180.0) * d * FastMath.cos((coord4.al - this.alphai) * Math.PI / 180.0);
            d4 = FastMath.cos(coord4.del * Math.PI / 180.0) * FastMath.sin((coord4.al - this.alphai) * Math.PI / 180.0) / d3;
            d5 = FastMath.sin(coord4.del * Math.PI / 180.0) * d - FastMath.cos(coord4.del * Math.PI / 180.0) * d2 * FastMath.cos((coord4.al - this.alphai) * Math.PI / 180.0) / d3;
            double[] dArray3 = this.CD[0];
            dArray3[0] = dArray3[0] - ((double)this.ynpix * d4 - (double)this.xnpix * d5) * 2.0 / (double)this.ynpix / (double)this.xnpix;
            double[] dArray4 = this.CD[0];
            dArray4[1] = dArray4[1] - (d4 * (double)this.ynpix + d5 * (double)this.xnpix) * 2.0 / (double)this.xnpix / (double)this.ynpix;
            coord5.x = this.Xcen + (double)this.xnpix / 4.0;
            coord5.y = this.Ycen + (double)this.ynpix / 4.0;
            this.GetCoord(coord5);
            d3 = FastMath.sin(coord5.del * Math.PI / 180.0) * d2 + FastMath.cos(coord5.del * Math.PI / 180.0) * d * FastMath.cos((coord5.al - this.alphai) * Math.PI / 180.0);
            d4 = FastMath.cos(coord5.del * Math.PI / 180.0) * FastMath.sin((coord5.al - this.alphai) * Math.PI / 180.0) / d3;
            d5 = FastMath.sin(coord5.del * Math.PI / 180.0) * d - FastMath.cos(coord5.del * Math.PI / 180.0) * d2 * FastMath.cos((coord5.al - this.alphai) * Math.PI / 180.0) / d3;
            double[] dArray5 = this.CD[0];
            dArray5[0] = dArray5[0] + ((double)this.ynpix * d4 + (double)this.xnpix * d5) * 2.0 / (double)this.ynpix / (double)this.xnpix;
            double[] dArray6 = this.CD[0];
            dArray6[1] = dArray6[1] - (d4 * (double)this.ynpix - d5 * (double)this.xnpix) * 2.0 / (double)this.xnpix / (double)this.ynpix;
            double[] dArray7 = this.CD[0];
            dArray7[0] = dArray7[0] * 14.32394487827058;
            double[] dArray8 = this.CD[0];
            dArray8[1] = dArray8[1] * 14.32394487827058;
            this.CD[1][0] = this.CD[0][1];
            this.CD[1][1] = -this.CD[0][0];
            this.equinox = 2000.0;
            this.proj = 2;
        }
    }

    protected void GetWCS(Vector vector, Vector vector2) throws Exception {
        this.GetWCS_i();
        vector.addElement("NAXIS1  ");
        vector2.addElement(new Integer(this.xnpix).toString());
        vector.addElement("NAXIS2  ");
        vector2.addElement(new Integer(this.ynpix).toString());
        vector.addElement("CRPIX1  ");
        vector2.addElement(new Double(this.Xcen).toString());
        vector.addElement("CRPIX2  ");
        vector2.addElement(new Double(this.Ycen).toString());
        vector.addElement("EQUINOX ");
        vector2.addElement(new Double(this.equinox).toString());
        boolean bl = this.aladin != 1 && this.type1 != null && this.type1.startsWith("DEC");
        vector.addElement("CRVAL1  ");
        vector2.addElement(new Double(bl ? this.deltai : this.alphai).toString());
        vector.addElement("CRVAL2  ");
        vector2.addElement(new Double(bl ? this.alphai : this.deltai).toString());
        vector.addElement("CTYPE1  ");
        if (this.aladin == 1) {
            vector2.addElement("'RA---TAN'");
        } else {
            vector2.addElement(this.type1);
        }
        vector.addElement("CTYPE2  ");
        if (this.aladin == 1) {
            vector2.addElement("'DEC--TAN'");
        }
        if (this.aladin == 1) {
            vector2.addElement("'DEC--TAN'");
        } else {
            vector2.addElement(this.type2);
        }
        if (RADECSYS[this.system].length() > 0) {
            vector.addElement("RADECSYS");
            vector2.addElement(RADECSYS[this.system]);
        }
        vector.addElement("CD1_1   ");
        vector2.addElement(new Double(this.CD[0][0]).toString());
        vector.addElement("CD1_2   ");
        vector2.addElement(new Double(this.CD[0][1]).toString());
        vector.addElement("CD2_1   ");
        vector2.addElement(new Double(this.CD[1][0]).toString());
        vector.addElement("CD2_2   ");
        vector2.addElement(new Double(this.CD[1][1]).toString());
        if (this.xyapoly[0] != 0.0) {
            vector.addElement("PV1_0");
            vector2.addElement(new Double(this.xyapoly[0]).toString());
        }
        if (this.xydpoly[0] != 0.0) {
            vector.addElement("PV2_0");
            vector2.addElement(new Double(this.xydpoly[0]).toString());
        }
        if (this.xyapoly[1] != 0.0) {
            vector.addElement("PV1_1");
            vector2.addElement(new Double(this.xyapoly[1]).toString());
        }
        if (this.xydpoly[1] != 0.0) {
            vector.addElement("PV2_1");
            vector2.addElement(new Double(this.xydpoly[1]).toString());
        }
        if (this.xyapoly[2] != 0.0) {
            vector.addElement("PV1_2");
            vector2.addElement(new Double(this.xyapoly[2]).toString());
        }
        if (this.xydpoly[2] != 0.0) {
            vector.addElement("PV2_2");
            vector2.addElement(new Double(this.xydpoly[2]).toString());
        }
        if (this.xyapoly[3] != 0.0) {
            vector.addElement("PV1_3");
            vector2.addElement(new Double(this.xyapoly[3]).toString());
        }
        if (this.xydpoly[3] != 0.0) {
            vector.addElement("PV2_3");
            vector2.addElement(new Double(this.xydpoly[3]).toString());
        }
        if (this.xyapoly[4] != 0.0) {
            vector.addElement("PV1_4");
            vector2.addElement(new Double(this.xyapoly[4]).toString());
        }
        if (this.xydpoly[4] != 0.0) {
            vector.addElement("PV2_4");
            vector2.addElement(new Double(this.xydpoly[4]).toString());
        }
        if (this.xyapoly[5] != 0.0) {
            vector.addElement("PV1_5");
            vector2.addElement(new Double(this.xyapoly[5]).toString());
        }
        if (this.xydpoly[5] != 0.0) {
            vector.addElement("PV2_5");
            vector2.addElement(new Double(this.xydpoly[5]).toString());
        }
        if (this.xyapoly[6] != 0.0) {
            vector.addElement("PV1_6");
            vector2.addElement(new Double(this.xyapoly[6]).toString());
        }
        if (this.xydpoly[6] != 0.0) {
            vector.addElement("PV2_6");
            vector2.addElement(new Double(this.xydpoly[6]).toString());
        }
        if (this.xyapoly[7] != 0.0) {
            vector.addElement("PV1_7");
            vector2.addElement(new Double(this.xyapoly[7]).toString());
        }
        if (this.xydpoly[7] != 0.0) {
            vector.addElement("PV2_7");
            vector2.addElement(new Double(this.xydpoly[7]).toString());
        }
        if (this.xyapoly[8] != 0.0) {
            vector.addElement("PV1_8");
            vector2.addElement(new Double(this.xyapoly[8]).toString());
        }
        if (this.xydpoly[8] != 0.0) {
            vector.addElement("PV2_8");
            vector2.addElement(new Double(this.xydpoly[8]).toString());
        }
        if (this.xyapoly[9] != 0.0) {
            vector.addElement("PV1_9");
            vector2.addElement(new Double(this.xyapoly[9]).toString());
        }
        if (this.xydpoly[9] != 0.0) {
            vector.addElement("PV2_9");
            vector2.addElement(new Double(this.xydpoly[9]).toString());
        }
        if (this.xyapoly[10] != 0.0) {
            vector2.addElement(new Double(this.xyapoly[10]).toString());
        }
        if (this.xydpoly[10] != 0.0) {
            vector2.addElement(new Double(this.xydpoly[10]).toString());
        }
    }

    protected void GetWCSP(Vector vector, Vector vector2) throws Exception {
        vector.addElement("NAXIS1  ");
        vector2.addElement(new Integer(this.xnpix).toString());
        vector.addElement("NAXIS2  ");
        vector2.addElement(new Integer(this.ynpix).toString());
        vector.addElement("CRPIX1  ");
        if (this.aladin != 1) {
            vector2.addElement(new Double(this.Xcen).toString());
        } else {
            vector2.addElement(new Double((this.xz * 1000.0 - this.Xorg) / this.incX).toString());
        }
        vector.addElement("CRPIX2  ");
        if (this.aladin != 1) {
            vector2.addElement(new Double(this.Ycen).toString());
        } else {
            vector2.addElement(new Double((this.yz * 1000.0 - this.Yorg) / this.incY).toString());
        }
        vector.addElement("EQUINOX");
        vector2.addElement(new Double(this.equinox).toString());
        boolean bl = this.aladin != 1 && this.type1 != null && this.type1.startsWith("DEC");
        vector.addElement("CRVAL1  ");
        if (this.aladin != 1) {
            vector2.addElement(new Double(bl ? this.deltai : this.alphai).toString());
        } else {
            vector2.addElement(new Double(this.alpha).toString());
        }
        vector.addElement("CRVAL2  ");
        if (this.aladin != 1) {
            vector2.addElement(new Double(bl ? this.alphai : this.deltai).toString());
        } else {
            vector2.addElement(new Double(this.delta).toString());
        }
        vector.addElement("CTYPE1  ");
        if (this.aladin == 1) {
            vector2.addElement("'RA---TAN'");
        } else {
            vector2.addElement(this.type1);
        }
        vector.addElement("CTYPE2  ");
        if (this.aladin == 1) {
            vector2.addElement("'DEC--TAN'");
        } else {
            vector2.addElement(this.type2);
        }
        if (RADECSYS[this.system].length() > 0) {
            vector.addElement("RADECSYS");
            vector2.addElement(RADECSYS[this.system]);
        }
        if (this.aladin == 1) {
            this.CD[0][0] = this.incX / (1000.0 * this.focale) * rad_to_deg;
            this.CD[0][1] = 0.0;
            this.CD[1][0] = 0.0;
            this.CD[1][1] = this.incY / (1000.0 * this.focale) * rad_to_deg;
            this.ID[0][0] = 1000.0 * this.focale / this.incX * deg_to_rad;
            this.ID[0][1] = 0.0;
            this.ID[1][0] = 0.0;
            this.ID[1][1] = 1000.0 * this.focale / this.incY * deg_to_rad;
            double d = deg_to_rad;
            bl = false;
            vector.addElement("PV1_0");
            vector2.addElement(new Double(this.xyapoly[0]).toString());
            vector.addElement("PV2_0");
            vector2.addElement(new Double(this.xydpoly[0]).toString());
            vector.addElement("PV1_1");
            vector2.addElement(new Double(this.xyapoly[2] * d).toString());
            vector.addElement("PV2_1");
            vector2.addElement(new Double(this.xydpoly[2] * d).toString());
            vector.addElement("PV1_2");
            vector2.addElement(new Double(this.xyapoly[1] * d).toString());
            vector.addElement("PV2_2");
            vector2.addElement(new Double(this.xydpoly[1] * d).toString());
            vector.addElement("PV1_3");
            vector2.addElement(new Double(this.xyapoly[4] * d * d).toString());
            vector.addElement("PV2_3");
            vector2.addElement(new Double(this.xydpoly[4] * d * d).toString());
            vector.addElement("PV1_4");
            vector2.addElement(new Double(this.xyapoly[5] * d * d).toString());
            vector.addElement("PV2_4");
            vector2.addElement(new Double(this.xydpoly[5] * d * d).toString());
            vector.addElement("PV1_5");
            vector2.addElement(new Double(this.xyapoly[3] * d * d).toString());
            vector.addElement("PV2_5");
            vector2.addElement(new Double(this.xydpoly[3] * d * d).toString());
            vector.addElement("PV1_6");
            vector2.addElement(new Double(this.xyapoly[7] * d * d * d).toString());
            vector.addElement("PV2_6");
            vector2.addElement(new Double(this.xydpoly[7] * d * d * d).toString());
            vector.addElement("PV1_7");
            vector2.addElement(new Double(this.xyapoly[9] * d * d * d).toString());
            vector.addElement("PV2_7");
            vector2.addElement(new Double(this.xydpoly[9] * d * d * d).toString());
            vector.addElement("PV1_8");
            vector2.addElement(new Double(this.xyapoly[8] * d * d * d).toString());
            vector.addElement("PV2_8");
            vector2.addElement(new Double(this.xydpoly[8] * d * d * d).toString());
            vector.addElement("PV1_9");
            vector2.addElement(new Double(this.xyapoly[6] * d * d * d).toString());
            vector.addElement("PV2_9");
            vector2.addElement(new Double(this.xydpoly[6] * d * d * d).toString());
        }
        vector.addElement("CD1_1   ");
        vector2.addElement(new Double(this.CD[0][0]).toString());
        vector.addElement("CD1_2   ");
        vector2.addElement(new Double(this.CD[0][1]).toString());
        vector.addElement("CD2_1   ");
        vector2.addElement(new Double(this.CD[1][0]).toString());
        vector.addElement("CD2_2   ");
        vector2.addElement(new Double(this.CD[1][1]).toString());
    }

    protected void SetEquinox(double d) {
        this.equinox = d;
    }

    protected double GetEquinox() {
        return this.equinox;
    }

    protected double GetEpoch() {
        if (this.flagepoc != 0) {
            return this.epoch;
        }
        return Double.NaN;
    }

    public Coord getImgCenter() throws Exception {
        Coord coord = new Coord();
        coord.x = (double)this.xnpix / 2.0;
        coord.y = (double)this.ynpix / 2.0;
        this.GetCoord(coord);
        return coord;
    }

    public Coord getProjCenter() {
        Coord coord = new Coord();
        coord.x = this.Xcen;
        coord.y = this.Ycen;
        try {
            this.GetCoord(coord);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return coord;
    }

    public double getProjRot() {
        return this.rota;
    }

    public double getImgWidth() {
        return this.widtha;
    }

    public double getImgHeight() {
        return this.widthd;
    }

    public boolean getProjSym() {
        return this.incA > 0.0;
    }

    protected int getProj() {
        return this.proj;
    }

    protected int getSystem() {
        return this.system;
    }

    public Dimension getImgSize() {
        return new Dimension(this.xnpix, this.ynpix);
    }

    protected void cropping(double d, double d2) {
        this.cropping(((double)this.xnpix - d) / 2.0, ((double)this.ynpix - d2) / 2.0, d, d2);
    }

    protected void cropping(double d, double d2, double d3, double d4) {
        if (this.aladin == 0 || this.aladin == 3) {
            this.Xcen -= d;
            this.Ycen -= (double)this.ynpix - d2 - d4;
        } else {
            this.Xorg += d * this.incX;
            this.Yorg += d2 * this.incY;
        }
        this.xnpix = (int)Math.round(d3);
        this.ynpix = (int)Math.round(d4);
        this.widtha = (double)this.xnpix * Math.abs(this.incA);
        this.widthd = (double)this.ynpix * Math.abs(this.incD);
    }

    protected boolean sensDirect() {
        double d = this.xydpoly[2];
        if (this.aladin == 0 || this.aladin == 3) {
            double d2 = this.xyapoly[1];
            if (d2 > 0.0) {
                return this.CD[0][0] * this.CD[1][1] > 0.0;
            }
            if (d2 < 0.0) {
                return -this.CD[0][0] * this.CD[1][1] > 0.0;
            }
            return this.CD[0][0] * this.CD[1][1] > 0.0;
        }
        if (this.aladin == 2) {
            return this.CD[0][0] * this.CD[1][1] > 0.0;
        }
        double d3 = this.xyapoly[2];
        return d3 * d > 0.0;
    }

    protected void cropAndZoom(double d, double d2, double d3, double d4, double d5) {
        this.incX /= d5;
        this.incY /= d5;
        this.Xcen *= d5;
        this.Ycen *= d5;
        this.xnpix = (int)Math.round((double)this.xnpix * d5);
        this.ynpix = (int)Math.round((double)this.ynpix * d5);
        this.CD[0][0] = this.CD[0][0] / d5;
        this.CD[0][1] = this.CD[0][1] / d5;
        this.CD[1][0] = this.CD[1][0] / d5;
        this.CD[1][1] = this.CD[1][1] / d5;
        this.ID[0][0] = this.ID[0][0] * d5;
        this.ID[0][1] = this.ID[0][1] * d5;
        this.ID[1][0] = this.ID[1][0] * d5;
        this.ID[1][1] = this.ID[1][1] * d5;
        this.incA /= d5;
        this.incD /= d5;
        this.cropping(d * d5, d2 * d5, d3 * d5, d4 * d5);
    }

    static boolean equalEpsilon(double d, double d2) {
        if (Double.isNaN(d) || Double.isNaN(d2)) {
            return false;
        }
        return Math.abs(d - d2) <= EPSILON;
    }

    public static boolean test1() {
        boolean bl = true;
        Calib calib = new Calib(8L, 424L, 0, 1);
        Calib calib2 = new Calib(8L, 0L, 0, 1);
        return bl;
    }

    public static boolean test() {
        boolean bl = true;
        try {
            System.out.println("> Calib test...");
            int n = 3;
            boolean bl2 = false;
            System.out.print("   Test" + projType[n] + "...");
            for (int i = 0; i < testCenter.length; ++i) {
                double d = testCenter[i][0];
                double d2 = testCenter[i][1];
                double d3 = 250.0;
                double d4 = 250.0;
                double d5 = 500.0;
                double d6 = 500.0;
                double d7 = 90.0;
                double d8 = 90.0;
                double d9 = 0.0;
                boolean bl3 = false;
                String string = "   coo=(" + d + "," + d2 + ")<=>xy=(" + d3 + "," + d4 + ") : ";
                Calib calib = new Calib(d, d2, d3, d4, d5, d6, d7, d8, d9, n, bl3, FK5);
                Coord coord = new Coord();
                double d10 = d3;
                double d11 = d4;
                coord.x = d10;
                coord.y = d11;
                calib.GetCoord(coord);
                System.out.print("\nfixe" + string + "  coo=(" + coord.al + "," + coord.del + ") => xy=(" + coord.x + "," + coord.y + ")");
                if (!Calib.equalEpsilon(coord.al, d) || !Calib.equalEpsilon(coord.del, d2)) {
                    if (!bl2) {
                        System.out.print(" Error");
                    }
                    bl2 = true;
                    System.out.print("\nfixe" + string + " Wrong celestian center: xy=(" + d10 + "," + d11 + ") => coo=(" + coord.al + "," + coord.del + ") ");
                }
                coord.al = d;
                coord.del = d2;
                calib.GetXY(coord);
                if (!Calib.equalEpsilon(coord.x, d10) || !Calib.equalEpsilon(coord.y, d11)) {
                    if (!bl2) {
                        System.out.print(" Error");
                    }
                    bl2 = true;
                    System.out.print("\nfixe" + string + " Wrong projected center: coo=(" + coord.al + "," + coord.del + ") => xy=(" + coord.x + "," + coord.y + ")");
                }
                try {
                    Random random = new Random(System.currentTimeMillis());
                    for (int j = 0; j < 1000; ++j) {
                        coord.al = 3.1384510609362035;
                        coord.del = Math.PI * (-0.5 + (double)j / 1000.0);
                        calib.GetXY(coord);
                        if (!(Math.abs(coord.y) > 30000.0)) continue;
                        System.out.println(" coo.aldel" + coord.al + " " + coord.del);
                        System.out.println(" coo.XY" + coord.x + " " + coord.y);
                    }
                    continue;
                }
                catch (Exception exception) {
                    if (!bl2) {
                        System.out.print("random Error");
                    }
                    bl2 = true;
                    System.out.print("\n" + string + " Java exception: xy=(" + d10 + "," + d11 + ") => " + exception.getMessage());
                }
            }
            if (!bl2) {
                System.out.println(" OK");
            } else {
                System.out.println();
            }
            bl &= bl2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            bl = false;
        }
        return bl;
    }
}

