/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Calib;
import cds.aladin.CanvasColorMap;
import cds.aladin.Command;
import cds.aladin.Configuration;
import cds.aladin.ContourAlgorithm;
import cds.aladin.Coord;
import cds.aladin.Couleur;
import cds.aladin.FootprintBean;
import cds.aladin.Fov;
import cds.aladin.Glu;
import cds.aladin.Legende;
import cds.aladin.MyInputStream;
import cds.aladin.Obj;
import cds.aladin.Pcat;
import cds.aladin.Plan;
import cds.aladin.PlanBG;
import cds.aladin.PlanBGCat;
import cds.aladin.PlanBGCube;
import cds.aladin.PlanBGProgen;
import cds.aladin.PlanCatalog;
import cds.aladin.PlanContour;
import cds.aladin.PlanField;
import cds.aladin.PlanFilter;
import cds.aladin.PlanFolder;
import cds.aladin.PlanFov;
import cds.aladin.PlanFree;
import cds.aladin.PlanHealpix;
import cds.aladin.PlanHealpixAlgo;
import cds.aladin.PlanHealpixDMap;
import cds.aladin.PlanImage;
import cds.aladin.PlanImageAlgo;
import cds.aladin.PlanImageBlink;
import cds.aladin.PlanImageColor;
import cds.aladin.PlanImageCube;
import cds.aladin.PlanImageCubeRGB;
import cds.aladin.PlanImageHuge;
import cds.aladin.PlanImageMosaic;
import cds.aladin.PlanImageRGB;
import cds.aladin.PlanImageResamp;
import cds.aladin.PlanImageRice;
import cds.aladin.PlanMoc;
import cds.aladin.PlanMocAlgo;
import cds.aladin.PlanMocColl;
import cds.aladin.PlanMocGen;
import cds.aladin.PlanMultiCCD;
import cds.aladin.PlanTool;
import cds.aladin.PointD;
import cds.aladin.Position;
import cds.aladin.Projection;
import cds.aladin.RectangleD;
import cds.aladin.ResourceNode;
import cds.aladin.ScrollbarStack;
import cds.aladin.Select;
import cds.aladin.Server;
import cds.aladin.ServerFile;
import cds.aladin.Source;
import cds.aladin.SourcePhot;
import cds.aladin.SourceStat;
import cds.aladin.SourceTag;
import cds.aladin.Tag;
import cds.aladin.Tok;
import cds.aladin.TreeNodeAllsky;
import cds.aladin.View;
import cds.aladin.ViewSimple;
import cds.aladin.Zoom;
import cds.moc.HealpixMoc;
import cds.tools.Util;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.io.EOFException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class Calque
extends JPanel
implements Runnable {
    int FIRSTBLOC = 25;
    int BLOC = 50;
    Aladin aladin;
    Select select;
    Zoom zoom;
    protected Plan[] plan;
    int maxPlan = 0;
    int current;
    int runme_n = -1;
    ScrollbarStack scroll;
    protected int reticleMode;
    protected int gridMode = 1;
    protected boolean flagOverlay;
    protected boolean flagHpxPolar;
    protected boolean flagAutoDist;
    protected boolean flagSimbad;
    protected boolean flagVizierSED;
    protected boolean flagTip;
    protected Fov[] curFov;
    Projection fovProj;
    protected Fov[] cutoutFov = null;
    protected int overlayFlag;
    protected static final int SCALE = 1;
    protected static final int LABEL = 2;
    protected static final int SIZE = 4;
    protected static final int GRID = 8;
    protected static final int NE = 16;
    protected static final int RETICLE = 32;
    protected static final int TARGET = 64;
    protected static final int PIXEL = 128;
    protected static final int HPXGRID = 256;
    protected static final int COLORMAP = 512;
    protected static final int CONST = 1024;
    private static final String[] OVERLAYFLAG = new String[]{"scale", "label", "size", "grid", "NE", "reticle", "target", "pixel", "HPXgrid", "colormap", "const"};
    private static final int[] OVERLAYFLAGVAL = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024};
    protected volatile Object pile = new Object();
    private boolean flagFirstAutoDist = true;
    private boolean flagFirstSimbad = true;
    private boolean flagFirstVizierSED = true;
    protected boolean taggedSrc = false;
    private Obj oNewobj = null;
    private boolean memoClinDoeil = false;
    static final int COLIMG = 256;
    static final int CALIB = 512;
    static final int TRUEIMG = 1024;
    static final int IMG = 2048;
    static final int SELECTED = 3840;
    Plan planRotCenter = null;
    static final String DMAPGLU = "getDMap";
    private String _target;
    private String _radius;
    private String _file;
    private MyInputStream _in;
    private Plan _firstPlan;
    private String _label;
    private Obj _o;
    private boolean lock;
    private final Object lockObj = new Object();

    public int getOverlayFlag() {
        return this.overlayFlag;
    }

    public boolean hasScale() {
        return (this.overlayFlag & 1) == 1;
    }

    public boolean hasLabel() {
        return (this.overlayFlag & 2) == 2;
    }

    public boolean hasSize() {
        return (this.overlayFlag & 4) == 4;
    }

    public boolean hasGrid() {
        return (this.overlayFlag & 8) == 8;
    }

    public boolean hasNE() {
        return (this.overlayFlag & 0x10) == 16;
    }

    public boolean hasReticle() {
        return (this.overlayFlag & 0x20) == 32;
    }

    public boolean hasTarget() {
        return (this.overlayFlag & 0x40) == 64;
    }

    public boolean hasPixel() {
        return (this.overlayFlag & 0x80) == 128;
    }

    public boolean hasHpxGrid() {
        return (this.overlayFlag & 0x100) == 256;
    }

    public boolean hasColormap() {
        return (this.overlayFlag & 0x200) == 512;
    }

    public boolean hasConst() {
        return (this.overlayFlag & 0x400) == 1024;
    }

    public boolean setOverlayFlag(String string, boolean bl) {
        int n = Util.indexInArrayOf(string, OVERLAYFLAG, true);
        if (n < 0) {
            return false;
        }
        this.overlayFlag = bl ? (this.overlayFlag |= OVERLAYFLAGVAL[n]) : (this.overlayFlag &= ~OVERLAYFLAGVAL[n]);
        return true;
    }

    public void setOverlayList(String string) throws Exception {
        int n = 0;
        if (string.length() > 1) {
            if (string.charAt(0) == '+') {
                n = 1;
                string = string.substring(1);
            } else if (string.charAt(0) == '-') {
                n = -1;
                string = string.substring(1);
            }
        }
        if (n == 0) {
            this.overlayFlag = 0;
            n = 1;
        }
        int n2 = 0;
        Tok tok = new Tok(string, ",");
        while (tok.hasMoreTokens()) {
            String string2 = tok.nextToken().trim();
            int n3 = Util.indexInArrayOf(string2, OVERLAYFLAG, true);
            if (n3 >= 0) {
                n2 |= OVERLAYFLAGVAL[n3];
                continue;
            }
            throw new Exception("overlay parameter unknown [" + string2 + "]");
        }
        this.overlayFlag = n == 1 ? (this.overlayFlag |= n2) : (this.overlayFlag &= ~n2);
        if (this.aladin.view != null) {
            this.aladin.view.showRainbow(this.hasColormap());
        }
    }

    public String getOverlayList() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < OVERLAYFLAG.length; ++i) {
            if ((this.overlayFlag & OVERLAYFLAGVAL[i]) != OVERLAYFLAGVAL[i]) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(OVERLAYFLAG[i]);
        }
        return stringBuffer.toString();
    }

    protected void createChaine() {
    }

    protected Calque() {
    }

    protected Calque(Aladin aladin) {
        this.aladin = aladin;
        this.select = new Select(aladin);
        this.zoom = new Zoom(aladin);
        this.scroll = new ScrollbarStack(aladin, 1, this.FIRSTBLOC - 1, 1, 0, this.FIRSTBLOC);
        this.reallocPlan();
        this.flagOverlay = true;
        this.reticleMode = aladin.configuration.get(Configuration.RETICLE) != null ? 2 : 1;
        this.flagTip = aladin.configuration.get(Configuration.TOOLTIP) != null;
        this.flagAutoDist = aladin.configuration.getAutoDist();
        this.flagSimbad = aladin.configuration.getSimbadFlag();
        this.flagVizierSED = aladin.configuration.getVizierSEDFlag();
        try {
            this.setOverlayList("label,scale,size,NE,target,reticle,target,pixel");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setLayout(new BorderLayout(0, 5));
        this.add((Component)this.select, "Center");
        this.add((Component)this.zoom, "South");
    }

    protected boolean scrollAdjustement() {
        boolean bl;
        if (this.aladin.isFullScreen()) {
            return false;
        }
        int n = this.scroll.getLastVisiblePlan();
        if (n == -1) {
            return false;
        }
        boolean bl2 = bl = !this.scroll.getRequired();
        if (this.scroll.isShowing() && bl) {
            this.remove(this.scroll);
            this.validate();
            return true;
        }
        if (!this.scroll.isShowing() && !bl) {
            this.add((Component)this.scroll, "East");
            this.validate();
            return true;
        }
        return false;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(Select.frMax + 95 + 16, 200);
    }

    protected int getNbPlan() {
        return this.plan.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Plan getPlanByHashCode(int n) {
        Object object = this.pile;
        synchronized (object) {
            for (int i = 0; i < this.plan.length; ++i) {
                if (this.plan[i].hashCode() != n) continue;
                return this.plan[i];
            }
        }
        return null;
    }

    public Plan getPlan(int n) {
        try {
            return this.plan[n];
        }
        catch (Exception exception) {
            if (Aladin.levelTrace >= 3) {
                exception.printStackTrace();
            }
            return null;
        }
    }

    protected Plan[] getPlans() {
        Plan[] planArray = new Plan[this.plan.length];
        System.arraycopy(this.plan, 0, planArray, 0, this.plan.length);
        return planArray;
    }

    private Plan getMyScopeFolder(Plan plan) {
        return this.getMyScopeFolder(this.plan, plan);
    }

    protected Plan getMyScopeFolder(Plan[] planArray, Plan plan) {
        int n = plan.folder - 1;
        for (int i = this.getIndex(plan) - 1; n >= 0 && i >= 0; --i) {
            if (planArray[i].type != 11) continue;
            if (((PlanFolder)planArray[i]).localScope && planArray[i].folder == n) {
                return planArray[i];
            }
            --n;
        }
        return null;
    }

    protected Plan getFolder(Plan plan) {
        if (plan.type == 11) {
            return plan;
        }
        int n = this.getIndex(plan);
        for (int i = n - 1; i >= 0; --i) {
            if (this.plan[i].type != 11 || this.plan[i].folder >= plan.folder) continue;
            return this.plan[i];
        }
        return null;
    }

    protected Plan[] getFolderPlan(Plan plan) {
        return this.getFolderPlan(plan, true);
    }

    protected Plan[] getFolderPlan(Plan plan, boolean bl) {
        Plan[] planArray;
        int n;
        if (plan.type != 11) {
            return null;
        }
        Vector<Plan[]> vector = new Vector<Plan[]>(10);
        int n2 = plan.folder;
        boolean bl2 = false;
        for (n = 0; n < this.plan.length; ++n) {
            planArray = this.plan[n];
            if (!bl2) {
                bl2 = planArray == plan;
                continue;
            }
            if (planArray.folder <= n2) break;
            if (!bl && planArray.folder != plan.folder + 1) continue;
            vector.addElement(planArray);
        }
        planArray = new Plan[vector.size()];
        Enumeration enumeration = vector.elements();
        n = 0;
        while (enumeration.hasMoreElements()) {
            planArray[n++] = (Plan)enumeration.nextElement();
        }
        return planArray;
    }

    protected boolean isCollapsed(Plan plan) {
        int n;
        if (plan.type != 11) {
            return false;
        }
        Plan[] planArray = this.getPlans();
        for (n = 0; n < planArray.length && planArray[n] != plan; ++n) {
        }
        if (n >= planArray.length - 1) {
            return false;
        }
        return planArray[n + 1].collapse;
    }

    protected void setActiveFolder(Plan plan, boolean bl) {
        Plan[] planArray = this.getFolderPlan(plan);
        for (int i = 0; i < planArray.length; ++i) {
            planArray[i].setActivated(bl);
        }
        plan.active = bl;
        this.repaintAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int reallocPlan() {
        int n;
        int n2 = this.maxPlan > 0 ? this.BLOC : this.FIRSTBLOC;
        Object object = this.pile;
        synchronized (object) {
            Plan[] planArray = new Plan[this.maxPlan + n2];
            if (this.maxPlan > 0) {
                System.arraycopy(this.plan, 0, planArray, n2, this.maxPlan);
                n = this.scroll.getValue() + n2;
            } else {
                n = n2;
            }
            for (int i = 0; i < n2; ++i) {
                planArray[i] = new PlanFree(this.aladin);
            }
            this.plan = planArray;
            this.maxPlan += n2;
            if (SwingUtilities.isEventDispatchThread()) {
                this.scroll.setValues(n - 1, 1, 0, this.maxPlan);
            } else {
                final int[] nArray = new int[]{n};
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Calque.this.scroll.setValues(nArray[0] - 1, 1, 0, Calque.this.maxPlan);
                    }
                });
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reinitPlan() {
        this.maxPlan = this.FIRSTBLOC;
        Object object = this.pile;
        synchronized (object) {
            Plan[] planArray = new Plan[this.maxPlan];
            for (int i = 0; i < this.maxPlan; ++i) {
                planArray[i] = new PlanFree(this.aladin);
            }
            this.plan = planArray;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.scroll.setValues(this.maxPlan - 1, 1, 0, this.maxPlan);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Calque.this.scroll.setValues(Calque.this.maxPlan - 1, 1, 0, Calque.this.maxPlan);
                }
            });
        }
        this.taggedSrc = false;
    }

    protected int getNbSelectedPlans() {
        int n = 0;
        Plan[] planArray = this.getPlans();
        for (int i = 0; i < planArray.length; ++i) {
            if (planArray[i].type == 0 || !planArray[i].flagOk || !planArray[i].selected) continue;
            ++n;
        }
        return n;
    }

    protected int getNbUsedPlans() {
        int n = 0;
        Plan[] planArray = this.getPlans();
        for (int i = 0; i < planArray.length; ++i) {
            if (planArray[i].type == 0 || !planArray[i].flagOk) continue;
            ++n;
        }
        return n;
    }

    protected double getFps() {
        Plan[] planArray = this.getPlans();
        double d = 0.0;
        int n = 0;
        for (int i = 0; i < planArray.length; ++i) {
            double d2;
            if (planArray[i].type != 16 || !planArray[i].flagOk || !planArray[i].active) continue;
            try {
                d2 = ((PlanBG)planArray[i]).getFps();
            }
            catch (Exception exception) {
                continue;
            }
            if (d2 <= 0.0) continue;
            d += d2;
            ++n;
        }
        return d / (double)n;
    }

    protected int getNbPlanImg() {
        return this.getNbPlanImg(true);
    }

    protected int getNbPlanImg(boolean bl) {
        int n = 0;
        Plan[] planArray = this.getPlans();
        for (int i = 0; i < planArray.length; ++i) {
            if (!planArray[i].isReady()) continue;
            if (planArray[i].isImage()) {
                ++n;
            }
            if (!bl || planArray[i].type != 16) continue;
            ++n;
        }
        return n;
    }

    protected int getNbPlanByClass(Class<?> clazz) {
        int n = 0;
        Plan[] planArray = this.getPlans();
        for (int i = 0; i < planArray.length; ++i) {
            if (!clazz.isInstance(planArray[i]) || !planArray[i].flagOk) continue;
            ++n;
        }
        return n;
    }

    protected int getNbPlanImgSelected() {
        int n = 0;
        Plan[] planArray = this.getPlans();
        for (int i = 0; i < planArray.length; ++i) {
            if (!(planArray[i] instanceof PlanImage) || !planArray[i].flagOk || planArray[i] instanceof PlanBG || !planArray[i].selected) continue;
            ++n;
        }
        return n;
    }

    protected int getNbPlanTranspImg() {
        int n = 0;
        Plan[] planArray = this.getPlans();
        for (int i = 0; i < planArray.length; ++i) {
            if (!(planArray[i] instanceof PlanImage) || !planArray[i].flagOk || !planArray[i].hasCanBeTranspState()) continue;
            ++n;
        }
        return n;
    }

    protected int getNbPlanCat() {
        int n = 0;
        Plan[] planArray = this.getPlans();
        for (int i = 0; i < planArray.length; ++i) {
            if (!planArray[i].isCatalog() || !planArray[i].flagOk) continue;
            ++n;
        }
        return n;
    }

    protected boolean hasSelectableObjects() {
        Plan[] planArray = this.getPlans();
        for (int i = 0; i < planArray.length; ++i) {
            Plan plan = planArray[i];
            if (!plan.flagOk || !plan.active || plan instanceof PlanContour || !plan.hasObj() && !plan.hasSources()) continue;
            return true;
        }
        return false;
    }

    protected int getNbPlanTool() {
        int n = 0;
        Plan[] planArray = this.getPlans();
        for (int i = 0; i < planArray.length; ++i) {
            if (!(planArray[i] instanceof PlanTool) || !planArray[i].flagOk) continue;
            ++n;
        }
        return n;
    }

    protected int getNbPlanMoc() {
        int n = 0;
        Plan[] planArray = this.getPlans();
        for (int i = 0; i < planArray.length; ++i) {
            if (planArray[i].type != 19 || !planArray[i].flagOk) continue;
            ++n;
        }
        return n;
    }

    protected int getNbPlanImgBG() {
        int n = 0;
        Plan[] planArray = this.getPlans();
        for (int i = 0; i < planArray.length; ++i) {
            if (planArray[i].type != 16 || !planArray[i].flagOk) continue;
            ++n;
        }
        return n;
    }

    protected int getNbPlanImgHiPS4RGB() {
        int n = 0;
        Plan[] planArray = this.getPlans();
        for (int i = 0; i < planArray.length; ++i) {
            if (planArray[i].type != 16 || !planArray[i].flagOk || !((PlanBG)planArray[i]).isLocalAllSky() || ((PlanBG)planArray[i]).isColored()) continue;
            ++n;
        }
        return n;
    }

    protected long getNbSrc() {
        long l = 0L;
        Plan[] planArray = this.getPlans();
        for (int i = 0; i < planArray.length; ++i) {
            if (!planArray[i].isCatalog() || !planArray[i].flagOk) continue;
            l += (long)planArray[i].getCounts();
        }
        return l;
    }

    protected void setReticle(int n) {
        this.reticleMode = n;
        this.setOverlayFlag("reticle", n > 0);
    }

    protected void setGrid(int n) {
        this.gridMode = n;
        this.setGrid(n != 0, false);
    }

    protected void setConstellation(boolean bl) {
        this.setOverlayFlag("const", bl);
    }

    protected void setGrid(boolean bl, boolean bl2) {
        if (bl == !this.hasGrid()) {
            this.switchGrid(bl2);
        }
    }

    protected void switchGrid(boolean bl) {
        if (!this.hasGrid()) {
            this.setOverlayFlag("grid", true);
            if (bl) {
                this.aladin.console.printCommand("grid on");
            }
        } else {
            this.setOverlayFlag("grid", false);
            if (bl) {
                this.aladin.console.printCommand("grid off");
            }
        }
        this.repaintAll();
    }

    protected void setOverlay(boolean bl) {
        this.flagOverlay = bl;
    }

    protected void setAutoDist(boolean bl) {
        if (this.flagFirstAutoDist && bl && this.aladin.configuration.isHelp()) {
            this.aladin.configuration.showHelpIfOk("HAUTODIST");
            this.flagFirstAutoDist = false;
        }
        this.flagAutoDist = bl;
    }

    protected void setSimbad(boolean bl) {
        if (this.flagFirstSimbad && bl && this.aladin.configuration.isHelp()) {
            this.aladin.configuration.showHelpIfOk("HFINGER");
            this.flagFirstSimbad = false;
        }
        this.flagSimbad = bl;
    }

    protected void setVizierSED(boolean bl) {
        if (this.flagFirstVizierSED && bl && this.aladin.configuration.isHelp()) {
            this.aladin.configuration.showHelpIfOk("HFINGERVIZIERSED");
            this.flagFirstVizierSED = false;
        }
        this.flagVizierSED = bl;
    }

    protected Plan contains(Coord coord) {
        Plan[] planArray = this.getPlans();
        for (int i = 0; i < planArray.length; ++i) {
            Plan plan = planArray[i];
            if (!plan.flagOk || !(plan instanceof PlanImage) || !plan.contains(coord)) continue;
            return plan;
        }
        return null;
    }

    protected boolean dejaCharge(int n, String string, String string2) {
        return this.dejaCharge(n, string, string2, null);
    }

    protected boolean dejaCharge(int n, String string, String string2, String string3) {
        Plan[] planArray = this.getPlans();
        for (int i = 0; i < planArray.length; ++i) {
            if (!planArray[i].theSame(n, string, string2, string3)) continue;
            return true;
        }
        return false;
    }

    protected boolean isFreeX(Plan plan) {
        Plan[] planArray = this.getPlans();
        for (int i = 0; i < planArray.length; ++i) {
            if (planArray[i] == plan || planArray[i].type == 0 || (!(planArray[i] instanceof PlanBG) || !((PlanBG)planArray[i]).flagOk) && !planArray[i].isSync()) continue;
            return false;
        }
        return true;
    }

    protected boolean hasImage(Plan plan) {
        Plan[] planArray = this.getPlans();
        for (int i = 0; i < planArray.length; ++i) {
            if (planArray[i] == plan || !planArray[i].isSync() || !planArray[i].isImage() && planArray[i].type != 16) continue;
            return true;
        }
        return false;
    }

    protected boolean isFree() {
        return this.getNbPlans(false) == 0;
    }

    protected int getNbPlans(boolean bl) {
        int n = 0;
        Plan[] planArray = this.getPlans();
        for (int i = 0; i < planArray.length; ++i) {
            if (planArray[i].type == 0 || bl && !planArray[i].flagOk) continue;
            ++n;
        }
        return n;
    }

    protected String getBlinkingInfo() {
        StringBuffer stringBuffer = new StringBuffer();
        Plan[] planArray = this.getPlans();
        for (int i = 0; i < planArray.length; ++i) {
            Plan plan = planArray[i];
            if (plan.type == 0 || (plan.flagOk || plan.error != null) && !plan.flagProcessing && (plan.type != 15 || !((PlanImageHuge)plan).isExtracting)) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(plan.label);
        }
        return stringBuffer.toString();
    }

    protected boolean isBlinking() {
        Plan[] planArray = this.getPlans();
        for (int i = 0; i < planArray.length; ++i) {
            Plan plan = planArray[i];
            if (plan.type == 0) continue;
            if (!plan.flagOk && plan.error == null) {
                return true;
            }
            if (plan.flagProcessing) {
                return true;
            }
            if (plan.type != 15 || !((PlanImageHuge)plan).isExtracting) continue;
            return true;
        }
        return false;
    }

    protected boolean waitingFirst() {
        boolean bl = false;
        for (int i = 0; i < this.plan.length; ++i) {
            Plan plan = this.plan[i];
            if (plan.type == 0) continue;
            bl = true;
            if (!plan.flagOk) continue;
            return false;
        }
        return bl;
    }

    protected void Free() {
        int n = this.getFirstSelected();
        if (n < 0) {
            return;
        }
        this.Free(n);
    }

    protected void Free(Plan plan) {
        this.Free(this.getIndex(plan));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void Free(int n) {
        if (n != -1) {
            final int[] nArray = new int[]{n};
            Object object = this.pile;
            synchronized (object) {
                this.plan[n].Free();
                if (SwingUtilities.isEventDispatchThread()) {
                    this.scroll.rm(nArray[0]);
                } else {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Calque.this.scroll.rm(nArray[0]);
                        }
                    });
                }
            }
        }
        this.repaintAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void FreeAll() {
        Aladin.makeCursor(this, 1);
        this.aladin.view.freeAll();
        Object object = this.pile;
        synchronized (object) {
            for (int i = 0; i < this.plan.length; ++i) {
                this.plan[i].Free();
            }
            this.reinitPlan();
        }
        this.repaintAll();
        Aladin.makeCursor(this, 0);
    }

    protected void setActivatedSet(boolean bl) {
        int n;
        if (bl) {
            n = 0;
            for (int i = 0; i < this.plan.length; ++i) {
                if (!this.plan[i].selected || !this.plan[i].isImage() || !this.canBeRef(this.plan[i])) continue;
                ++n;
            }
            if (n > this.aladin.view.getModeView()) {
                this.aladin.view.setModeView(n <= 3 ? 3 : (n <= 4 ? 4 : (n <= 9 ? 9 : 16)));
            }
        }
        for (n = 0; n < this.plan.length; ++n) {
            if (!this.plan[n].selected) continue;
            if (!bl || !this.plan[n].isImage()) {
                this.plan[n].setActivated(bl);
                continue;
            }
            this.showPlan(this.plan[n], true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void FreeEmpty() {
        Object object = this.pile;
        synchronized (object) {
            for (int i = this.plan.length - 1; i >= 0; --i) {
                if (!this.plan[i].isEmpty() || !this.plan[i].Free()) continue;
                this.scroll.rm(i);
                Plan plan = this.plan[i];
                for (int j = i; j > 1; --j) {
                    this.plan[j] = this.plan[j - 1];
                }
                ++i;
                this.plan[1] = plan;
            }
        }
        this.aladin.view.findBestDefault();
        this.repaintAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void FreeSet(boolean bl) {
        Object object = this.pile;
        synchronized (object) {
            int n;
            int n2;
            for (n2 = this.plan.length - 1; n2 >= 0; --n2) {
                if (!this.plan[n2].selected || this.plan[n2].type != 11) continue;
                Plan[] planArray = this.getFolderPlan(this.plan[n2]);
                for (n = 0; n < planArray.length; ++n) {
                    planArray[n].selected = true;
                }
            }
            for (n2 = this.plan.length - 1; n2 >= 0; --n2) {
                if (!this.plan[n2].selected || this.plan[n2].type == 0) continue;
                if (bl) {
                    this.aladin.console.printCommand("rm " + Tok.quote(this.plan[n2].label));
                }
                if (!this.plan[n2].Free()) continue;
                this.scroll.rm(n2);
                for (n = n2; n > 1; --n) {
                    this.plan[n] = this.plan[n - 1];
                }
                ++n2;
                this.plan[0] = new PlanFree(this.aladin);
            }
        }
        if (this.isFree()) {
            this.zoom.zoomView.free();
        }
        this.aladin.view.findBestDefault();
        this.repaintAll();
        this.aladin.gc();
    }

    protected boolean hasTaggedSrc() {
        if (!this.taggedSrc) {
            return false;
        }
        Plan[] planArray = this.getPlans();
        for (int i = 0; i < planArray.length; ++i) {
            if (!planArray[i].isCatalog() || !planArray[i].flagOk) continue;
            Iterator<Obj> iterator = planArray[i].iterator();
            while (iterator.hasNext()) {
                Source source;
                Obj obj = iterator.next();
                if (!(obj instanceof Source) || !(source = (Source)obj).isTagged()) continue;
                return true;
            }
        }
        return false;
    }

    protected void selectAllObjectInPlans() {
        this.selectAllObject(1);
    }

    protected void selectAllObject(int n) {
        this.aladin.view.deSelect();
        for (int i = 0; i < this.plan.length; ++i) {
            if (!this.plan[i].hasObj() || !this.plan[i].flagOk || !this.plan[i].active || n != 0 && n != 2 && !this.plan[i].selected) continue;
            this.aladin.view.selectAllInPlanWithoutFree(this.plan[i], n == 2 ? 1 : 0);
        }
        if (Aladin.PLASTIC_SUPPORT && this.aladin.getMessagingMgr().isRegistered()) {
            try {
                this.aladin.getMessagingMgr().sendSelectObjectsMsg();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.aladin.view.repaintAll();
        this.aladin.mesure.mcanvas.repaint();
    }

    protected void untag() {
        for (int i = 0; i < this.plan.length; ++i) {
            if (!this.plan[i].isCatalog() || !this.plan[i].flagOk) continue;
            Iterator<Obj> iterator = this.plan[i].iterator();
            while (iterator.hasNext()) {
                Obj obj = iterator.next();
                if (!(obj instanceof Source)) continue;
                Source source = (Source)obj;
                source.setTag(false);
            }
        }
        this.repaintAll();
        this.aladin.mesure.mcanvas.repaint();
    }

    protected Vector<Obj> setMultiSelect(ViewSimple viewSimple, RectangleD rectangleD) {
        Vector<Obj> vector = new Vector<Obj>(5000);
        Plan plan = this.getMyScopeFolder(viewSimple.pref);
        for (int i = 0; i < this.plan.length; ++i) {
            if (!this.plan[i].active || !this.plan[i].hasObj() || this.plan[i].type == 10 || plan != this.getMyScopeFolder(this.plan[i])) continue;
            Enumeration<Obj> enumeration = this.plan[i].setMultiSelect(viewSimple, rectangleD).elements();
            while (enumeration.hasMoreElements()) {
                vector.addElement(enumeration.nextElement());
            }
        }
        return vector;
    }

    protected Vector<Obj> getObjWith(ViewSimple viewSimple, double d, double d2) {
        Vector<Obj> vector = new Vector<Obj>(500, 500);
        Plan plan = this.getMyScopeFolder(viewSimple.pref);
        Plan[] planArray = this.getPlans();
        for (int i = 0; i < planArray.length; ++i) {
            Plan plan2 = planArray[i];
            if (!plan2.active || plan2 instanceof PlanTool && !plan2.isCatalog() && plan2.type != 9 && plan2.type != 10 || plan != this.getMyScopeFolder(plan2)) continue;
            Enumeration<Obj> enumeration = plan2.getObjWith(viewSimple, d, d2).elements();
            while (enumeration.hasMoreElements()) {
                vector.addElement(enumeration.nextElement());
            }
        }
        return vector;
    }

    protected Source[] getSources(String[] stringArray) {
        int n;
        Source[] sourceArray;
        if (stringArray == null) {
            return new Source[0];
        }
        Vector<Source> vector = new Vector<Source>(500, 500);
        Plan[] planArray = this.getPlans();
        for (int i = 0; i < planArray.length; ++i) {
            sourceArray = planArray[i];
            if (sourceArray.isSimpleCatalog() || sourceArray.pcat == null) continue;
            block1: for (n = 0; n < stringArray.length; ++n) {
                for (Obj obj : sourceArray) {
                    Source source;
                    String string;
                    if (!(obj instanceof Source) || (string = (source = (Source)obj).getOID()) == null || !string.equals(stringArray[n])) continue;
                    vector.addElement(source);
                    continue block1;
                }
            }
        }
        sourceArray = new Source[vector.size()];
        n = 0;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            sourceArray[n++] = (Source)enumeration.nextElement();
        }
        return sourceArray;
    }

    protected void resumeFrame() {
        int n = this.aladin.localisation.getFrame();
        this.aladin.command.setDrawMode(n == 11 ? Command.DRAWXY : Command.DRAWRADEC);
        Plan[] planArray = this.getPlans();
        for (int i = 0; i < planArray.length; ++i) {
            if (planArray[i].type == 0) continue;
            if (planArray[i].type == 9) {
                ((PlanTool)planArray[i]).setIdAgain();
            }
            if (!(planArray[i] instanceof PlanBG) || !Projection.isOk(planArray[i].projd) || planArray[i].projd.frame == ((PlanBG)planArray[i]).getCurrentFrameDrawing()) continue;
            planArray[i].projd.frame = ((PlanBG)planArray[i]).getCurrentFrameDrawing();
            planArray[i].syncProjLocal();
            planArray[i].resetProj();
        }
        Server server = this.aladin.dialog.server[this.aladin.dialog.current];
        if (server.target != null && server.tree != null) {
            server.target.setText("");
        }
        this.aladin.dialog.adjustParameters();
        this.aladin.dialog.resume();
        if (this.aladin.frameInfo != null) {
            this.aladin.frameInfo.initTarget();
        }
        this.aladin.view.grilAgain();
        this.aladin.view.repaintAll();
    }

    protected void resumePixel() {
        if (this.aladin.calque.freeUnusedPixelsOrigin()) {
            this.aladin.gc();
        }
    }

    protected void setObjet(Obj obj) {
        if (obj == this.oNewobj) {
            return;
        }
        PlanTool planTool = this.selectPlanTool();
        if (obj instanceof SourceTag) {
            planTool.pcat.insertSource((Source)obj);
        } else {
            planTool.pcat.setObjet(obj);
        }
        this.oNewobj = obj;
    }

    protected boolean delObjet(Obj obj) {
        Plan plan = ((Position)obj).plan;
        if (!plan.active || plan.pcat == null) {
            return false;
        }
        return plan.pcat.delObjet(obj);
    }

    protected void majPlanFlag() {
        Plan[] planArray = this.getPlans();
        for (int i = 0; i < planArray.length; ++i) {
            if (planArray[i].type == 0) continue;
            if (this.canBeRef(planArray[i])) {
                planArray[i].ref = this.aladin.view.isUsed(planArray[i]);
            }
            if (planArray[i].type == 12) continue;
            planArray[i].setActivated();
        }
    }

    protected boolean freeUnusedPixelsOrigin() {
        boolean bl = false;
        Plan[] planArray = this.getPlans();
        for (int i = 0; i < planArray.length; ++i) {
            if (planArray[i].type != 1 && !(planArray[i] instanceof PlanBG) || !planArray[i].flagOk || planArray[i].active && !((PlanImage)planArray[i]).pixelsOriginFromDisk()) continue;
            bl |= ((PlanImage)planArray[i]).pixelsOriginIntoCache();
        }
        return bl;
    }

    protected boolean canBeRef(Plan plan) {
        if (plan == null) {
            return false;
        }
        if (plan.hasXYorig) {
            return true;
        }
        return plan.isImage() || plan.type == 16 || plan.isPlanBGOverlay() || plan.isCatalog() || plan.isTool();
    }

    protected boolean setPlanRef(Plan plan) {
        return this.setPlanRef(plan, this.aladin.view.getLastNumView(plan));
    }

    protected boolean setPlanRef(Plan plan, int n) {
        if (n < 0 || !this.canBeRef(plan)) {
            return false;
        }
        plan.ref = true;
        this.aladin.view.setSelect(n);
        this.aladin.view.setPlanRef(n, plan);
        this.selectPlan(plan);
        return true;
    }

    protected boolean setPlanRefOnSameTarget(PlanBG planBG) {
        int n = this.aladin.view.getLastNumView(planBG);
        if (n < 0 || !this.canBeRef(planBG)) {
            return false;
        }
        ViewSimple viewSimple = this.aladin.view.viewSimple[n];
        if (viewSimple.isFree() || !Projection.isOk(viewSimple.pref.projd)) {
            return this.setPlanRef(planBG, n);
        }
        Coord coord = viewSimple.getProj().getProjCenter();
        Aladin.trace(4, "Calque.setPlanRefOnSameTarget() sur " + coord);
        double d = viewSimple.zoom;
        double d2 = 1.0;
        try {
            d2 = planBG.projd.getPixResAlpha() / viewSimple.getProj().getPixResAlpha();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setPlanRef(planBG, n);
        viewSimple.getProj().setProjCenter(coord.al, coord.del);
        viewSimple.newView(1);
        viewSimple.setZoomRaDec(d * d2, coord.al, coord.del);
        return true;
    }

    protected boolean setPlanRef(int n) {
        return this.setPlanRef(n, this.aladin.view.getLastNumView(this.plan[n]));
    }

    protected boolean setPlanRef(int n, int n2) {
        return this.setPlanRef(this.getPlan(n), n2);
    }

    protected void selectPlan(Plan plan) {
        this.unSelectAllPlan();
        if (plan != null) {
            plan.selected = true;
            plan.setActivated(true);
        }
        this.select.showSelectedPlan();
    }

    protected void selectPlanUnderMouse(Plan plan) {
        this.unSelectUnderMouse();
        if (plan != null) {
            plan.underMouse = true;
        }
    }

    protected void unSelectUnderMouse() {
        for (int i = 0; i < this.plan.length; ++i) {
            this.plan[i].underMouse = false;
        }
    }

    protected void unSelectAllPlan() {
        for (int i = 0; i < this.plan.length; ++i) {
            this.plan[i].underMouse = false;
            this.plan[i].selected = false;
        }
    }

    protected void rename(Plan plan, String string) {
        plan.setLabel(string);
        this.repaintAll();
    }

    protected void showPlan(Plan plan) {
        this.showPlan(plan, true);
    }

    protected void showPlan(Plan plan, boolean bl) {
        if (this.select.canBeNewRef(plan)) {
            if (this.setPlanRef(plan)) {
                this.aladin.view.newView();
            }
        } else if (!this.aladin.view.tryToShow(plan)) {
            plan.setActivated(true);
        }
        if (plan.isCatalog() && plan.active) {
            PlanFilter.updatePlan(plan);
        }
        if (bl) {
            this.repaintAll();
        }
    }

    protected void switchOffBGOver(Plan plan) {
        Plan[] planArray = this.getPlans();
        int n = this.getIndex(plan);
        for (int i = n - 1; i >= 0; --i) {
            Plan plan2 = planArray[i];
            if (!plan2.flagOk || !(plan2 instanceof PlanBG) || plan2.isOverlay()) continue;
            plan2.setActivated(false);
        }
        plan.setActivated(true);
    }

    protected boolean hasClinDoeil() {
        return this.memoClinDoeil;
    }

    protected void resetClinDoeil() {
        this.memoClinDoeil = false;
    }

    protected void clinDoeil() {
        Plan[] planArray = this.getPlans();
        for (int i = 0; i < planArray.length; ++i) {
            Plan plan = planArray[i];
            if (!plan.flagOk || plan.ref) continue;
            if (this.memoClinDoeil) {
                plan.setActivated(plan.memoClinDoeil);
                continue;
            }
            plan.memoClinDoeil = plan.active;
            plan.setActivated(false);
        }
        this.memoClinDoeil = !this.memoClinDoeil;
        this.aladin.view.newView();
    }

    protected void activateAll() {
        boolean bl = false;
        Plan[] planArray = this.getPlans();
        for (int i = 0; i < planArray.length; ++i) {
            if (!planArray[i].flagOk) continue;
            bl |= planArray[i].setActivated(true);
        }
        if (bl) {
            this.aladin.view.newView();
        }
    }

    protected int getIndex(Plan plan) {
        return this.getIndex(this.plan, plan);
    }

    protected int getIndex(Plan[] planArray, Plan plan) {
        if (plan == null) {
            return -1;
        }
        for (int i = 0; i < planArray.length; ++i) {
            if (planArray[i].type == 0 || planArray[i] != plan) continue;
            return i;
        }
        return -1;
    }

    protected int getIndexPlan(String string) {
        return this.getIndexPlan(string, 0);
    }

    protected int getIndexPlan(String string, int n) {
        for (int i = 0; i < this.plan.length; ++i) {
            if ((n != 0 || !Util.matchMask(string, this.plan[i].label)) && (n != 1 || !string.equals(this.plan[i].label))) continue;
            return i;
        }
        return -1;
    }

    public Plan getPlan(String string) {
        return this.getPlan(string, 0);
    }

    protected Plan getPlan(String string, int n) {
        int n2 = this.getIndexPlan(string, n);
        return n2 == -1 ? null : this.plan[n2];
    }

    protected Vector getPlans(String string) {
        Vector<Plan> vector = null;
        Plan[] planArray = this.getPlans();
        for (int i = 0; i < planArray.length; ++i) {
            Plan plan = planArray[i];
            if (plan.hasError() || !Util.matchMask(string, plan.label)) continue;
            if (vector == null) {
                vector = new Vector<Plan>(planArray.length);
            }
            vector.addElement(plan);
        }
        return vector;
    }

    private boolean isSpecialType(int n) {
        return n > 255;
    }

    private int getSpecialType(Plan plan) {
        int n = 0;
        if (plan instanceof PlanImage) {
            n |= 0x800;
        }
        if (plan instanceof PlanImageRGB) {
            n |= 0x100;
        }
        if (!plan.hasNoReduction()) {
            n |= 0x200;
        }
        if (plan.hasAvailablePixels()) {
            n |= 0x400;
        }
        if (plan.selected) {
            n |= 0xF00;
        }
        return n;
    }

    protected Vector<Plan> getPlans(int n) {
        Vector<Plan> vector = null;
        for (int i = 0; i < this.plan.length; ++i) {
            int n2;
            Plan plan = this.plan[i];
            if (plan.hasError() || (!this.isSpecialType(n) ? (n != 1 ? (n != 8 ? plan.type != n : !plan.isSimpleCatalog()) : plan.type != 1 && plan.type != 15 && plan.type != 5 && plan.type != 7 && plan.type != 6) : (n & (n2 = this.getSpecialType(plan))) == 0)) continue;
            if (vector == null) {
                vector = new Vector<Plan>(this.plan.length);
            }
            vector.addElement(plan);
        }
        return vector;
    }

    protected Vector<Plan> getPlans(Class<?> clazz) {
        Vector<Plan> vector = null;
        for (int i = 0; i < this.plan.length; ++i) {
            Plan plan = this.plan[i];
            if (plan.hasError() || !clazz.isInstance(plan)) continue;
            if (vector == null) {
                vector = new Vector<Plan>(this.plan.length);
            }
            vector.addElement(plan);
        }
        return vector;
    }

    protected Vector<Plan> getPlanImg() {
        return this.getPlans(1);
    }

    public Vector<Plan> getPlanBG() {
        return this.getPlans(16);
    }

    protected Vector<Plan> getPlanCat() {
        return this.getPlans(8);
    }

    protected Vector<Plan> getPlanAllImg() {
        return this.getPlans(2048);
    }

    protected Vector<Plan> getPlanSelected() {
        return this.getPlans(3840);
    }

    protected Plan getPlanRef() {
        ViewSimple viewSimple = this.aladin.view.getCurrentView();
        return viewSimple == null ? null : viewSimple.pref;
    }

    protected int getIndexPlanRef() {
        return this.getIndex(this.getPlanRef());
    }

    public Plan getPlanBase() {
        Plan plan = this.getPlanRef();
        return plan != null && plan.isPixel() ? plan : null;
    }

    public boolean isModeAllSky() {
        Plan plan = this.getPlanRef();
        return plan != null && plan instanceof PlanBG;
    }

    protected Plan nextImage(Plan plan, int n) {
        int n2 = this.getIndex(plan);
        for (int i = n2 + n; i != n2; i += n) {
            Plan plan2;
            if (i >= this.plan.length) {
                i = 0;
            }
            if (i < 0) {
                i = this.plan.length - 1;
            }
            if (!((plan2 = this.plan[i]) instanceof PlanImage) || !plan2.flagOk) continue;
            return plan2;
        }
        return plan;
    }

    protected int getIndexPlanBase() {
        int n = this.getIndexPlanRef();
        if (n == -1 || !this.plan[n].isImage() || !this.plan[n].active) {
            return -1;
        }
        return n;
    }

    protected String[] getStackLabels() {
        Vector<String> vector = new Vector<String>();
        for (int i = this.plan.length - 1; i >= 0; --i) {
            if (this.plan[i].type == 0) continue;
            vector.add(this.plan[i].label);
        }
        String[] stringArray = new String[vector.size()];
        Enumeration enumeration = vector.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            stringArray[n] = (String)enumeration.nextElement();
            ++n;
        }
        return stringArray;
    }

    protected void updateToolCatPhotExtract(SourceStat sourceStat, double[] dArray) {
        final PlanTool planTool = this.selectPlanTool();
        final SourcePhot sourcePhot = planTool.addPhot(this.aladin.view.getMouseView(), sourceStat.raj, sourceStat.dej, dArray);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Util.pause(100);
                sourcePhot.setSelected(true);
                planTool.updateDedicatedFilter();
                Calque.this.repaintAll();
            }
        });
    }

    protected void updateToolCatTag(Tag tag) {
        final PlanTool planTool = this.selectPlanTool();
        final SourceTag sourceTag = planTool.addTag(this.aladin.view.getMouseView(), tag.raj, tag.dej);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Util.pause(100);
                sourceTag.setSelected(true);
                planTool.updateDedicatedFilter();
                Calque.this.repaintAll();
            }
        });
    }

    protected void resetPlanField(int n, PlanField[] planFieldArray, int n2) {
        for (int i = 0; i < n2; ++i) {
            planFieldArray[i].reset(n);
        }
    }

    protected Plan newPlanFilter() {
        return this.newPlanFilter(null, null);
    }

    protected Plan newPlanFilter(String string, String string2) {
        PlanFilter planFilter = null;
        int n = this.getStackIndex();
        planFilter = new PlanFilter(this.aladin, string, string2);
        this.plan[n] = planFilter;
        PlanFilter.updateAllFilters(this.aladin);
        return planFilter;
    }

    protected Plan createFolder(String string, int n, boolean bl) {
        return this.plan[this.newFolder(string, n, bl)];
    }

    protected int newFolder(String string, int n, boolean bl) {
        int n2 = this.getStackIndex();
        this.plan[n2] = new PlanFolder(this.aladin, string, n, bl);
        return n2;
    }

    protected int newPlanDMap(String string) throws Exception {
        Glu cfr_ignored_0 = this.aladin.glu;
        String string2 = "" + this.aladin.glu.getURL(DMAPGLU, Glu.quote(string));
        String string3 = "DMAP " + string;
        int n = this.getStackIndex(string3);
        try {
            this.plan[n] = new PlanHealpixDMap(this.aladin, string2, string3);
        }
        catch (Exception exception) {
            this.plan[n].error = exception.getMessage();
            throw exception;
        }
        n = this.bestPlace(n);
        this.suiteNew(this.plan[n]);
        return n;
    }

    protected int newPlanImageRGB(PlanImage planImage, PlanImage planImage2, PlanImage planImage3, PlanImage planImage4, String string, boolean bl) {
        int n = this.getStackIndex(string);
        string = this.prepareLabel(string);
        this.plan[n] = new PlanImageRGB(this.aladin, planImage, planImage2, planImage3, planImage4, string, bl);
        n = this.bestPlace(n);
        this.suiteNew(this.plan[n]);
        return n;
    }

    protected int newPlanImage(PlanImageRGB planImageRGB) {
        PlanImage planImage = this.greyPlan(planImageRGB);
        ViewSimple viewSimple = this.aladin.view.getFirstSelectedView(planImageRGB);
        if (viewSimple != null) {
            viewSimple.pref = planImage;
            viewSimple.repaint();
        }
        return 1;
    }

    protected int newPlanImageResamp(PlanImage planImage, PlanImage planImage2, String string, int n, boolean bl, boolean bl2) {
        PlanImageResamp planImageResamp;
        if (planImage.type != 5) {
            ViewSimple viewSimple;
            if (bl2) {
                try {
                    planImageResamp = (PlanImageResamp)this.dupPlan(planImage, string, 5, true);
                }
                catch (Exception exception) {
                    planImageResamp = null;
                }
                planImage.selected = false;
            } else {
                planImageResamp = this.rspPlan(planImage);
            }
            if (string == null) {
                planImageResamp.setLabel("Rsp " + planImageResamp.label);
            }
            if ((viewSimple = this.aladin.view.getFirstSelectedView(planImage)) != null) {
                viewSimple.pref = planImageResamp;
                viewSimple.repaint();
            }
        } else {
            planImageResamp = (PlanImageResamp)planImage;
        }
        planImageResamp.launchResampleBy(planImage2, n, bl);
        return 1;
    }

    protected int newPlanMoc(String string, PlanMoc planMoc, Coord[] coordArray) {
        if (string == null && planMoc != null) {
            PlanMoc planMoc2 = planMoc;
            string = "=" + planMoc2.getUniqueLabel("[" + planMoc2.getLabel() + "]");
        }
        int n = this.getStackIndex(string);
        string = this.prepareLabel(string);
        PlanMocAlgo planMocAlgo = new PlanMocAlgo(this.aladin, string, planMoc, coordArray);
        this.plan[n] = planMocAlgo;
        if (Calque.isNewPlan(string)) {
            n = this.bestPlace(n);
            planMocAlgo.folder = 0;
        }
        this.suiteNew(planMocAlgo);
        return n;
    }

    protected int newPlanMoc(String string, PlanMoc[] planMocArray, int n, int n2) {
        if (string == null) {
            PlanMoc planMoc = planMocArray[0];
            string = "=" + planMoc.getUniqueLabel("[" + planMoc.getLabel() + "]");
        }
        int n3 = this.getStackIndex(string);
        string = this.prepareLabel(string);
        PlanMocAlgo planMocAlgo = new PlanMocAlgo(this.aladin, string, planMocArray, n, n2);
        this.plan[n3] = planMocAlgo;
        if (Calque.isNewPlan(string)) {
            n3 = this.bestPlace(n3);
            planMocAlgo.folder = 0;
        }
        this.suiteNew(planMocAlgo);
        return n3;
    }

    protected int newPlanMocColl(Aladin aladin, String string, String string2, int n, boolean bl, boolean bl2, double d, int[] nArray) {
        int n2 = this.getStackIndex(string);
        string = this.prepareLabel(string);
        PlanMocColl planMocColl = new PlanMocColl(aladin, string, string2, n, bl, bl2, d, nArray);
        this.plan[n2] = planMocColl;
        if (Calque.isNewPlan(string)) {
            n2 = this.bestPlace(n2);
            planMocColl.folder = 0;
        }
        this.suiteNew(planMocColl);
        return n2;
    }

    protected int newPlanMoc(String string, Plan[] planArray, int n, double d, double d2, double d3, double d4) {
        if (string == null) {
            string = "=" + planArray[0].getUniqueLabel("[" + planArray[0].getLabel() + "]");
        }
        int n2 = this.getStackIndex(string);
        string = this.prepareLabel(string);
        PlanMocGen planMocGen = new PlanMocGen(this.aladin, string, planArray, n, d, d2, d3, d4);
        this.plan[n2] = planMocGen;
        if (Calque.isNewPlan(string)) {
            n2 = this.bestPlace(n2);
            planMocGen.folder = 0;
        }
        this.suiteNew(planMocGen);
        return n2;
    }

    protected int newPlanImageAlgo(String string, PlanImage planImage, PlanImage planImage2, int n, double d, String string2, int n2) {
        if (planImage == null) {
            planImage = (PlanImage)this.getPlanBase();
            if (string == null) {
                string = "=" + planImage.getLabel();
            }
        } else if (string == null) {
            string = "=" + planImage.getUniqueLabel("[" + planImage.getLabel() + "]");
        }
        int n3 = this.getStackIndex(string);
        string = this.prepareLabel(string);
        PlanImageAlgo planImageAlgo = new PlanImageAlgo(this.aladin, string, planImage, planImage2, n, d, string2, n2);
        this.plan[n3] = planImageAlgo;
        if (Calque.isNewPlan(string)) {
            n3 = this.bestPlace(n3);
            planImageAlgo.folder = 0;
        }
        this.suiteNew(planImageAlgo);
        return n3;
    }

    protected int newPlanHealpixAlgo(String string, PlanHealpix planHealpix, PlanHealpix planHealpix2, int n, double d) {
        if (planHealpix == null) {
            planHealpix = (PlanHealpix)this.getPlanBase();
            if (string == null) {
                string = "=" + planHealpix.getLabel();
            }
        } else if (string == null) {
            string = "=" + planHealpix.getUniqueLabel("[" + planHealpix.getLabel() + "]");
        }
        int n2 = this.getStackIndex(string);
        string = this.prepareLabel(string);
        System.out.println(planHealpix.getNSideFile());
        System.out.println(planHealpix2.getNSideFile());
        if (planHealpix2 != null && (planHealpix.getNSideFile() != planHealpix2.getNSideFile() || planHealpix.getCoordsys() != planHealpix2.getCoordsys())) {
            Aladin.warning("Operation on planes with different nside or coordinate system not available yet !", 1);
            return -1;
        }
        PlanHealpixAlgo planHealpixAlgo = new PlanHealpixAlgo(this.aladin, string, planHealpix, planHealpix2, n, d);
        this.plan[n2] = planHealpixAlgo;
        if (Calque.isNewPlan(string)) {
            n2 = this.bestPlace(n2);
        }
        this.suiteNew(planHealpixAlgo);
        return n2;
    }

    protected int newPlanImageBlink(PlanImage[] planImageArray, String string, int n) {
        int n2 = this.getStackIndex(string);
        string = this.prepareLabel(string);
        this.plan[n2] = new PlanImageBlink(this.aladin, planImageArray, string, n);
        n2 = this.bestPlace(n2);
        this.suiteNew(this.plan[n2]);
        return n2;
    }

    protected int newPlanImageMosaic(PlanImage[] planImageArray, String string, ViewSimple viewSimple) {
        int n = this.getStackIndex(string);
        string = this.prepareLabel(string);
        this.plan[n] = new PlanImageMosaic(this.aladin, planImageArray, string, viewSimple);
        n = this.bestPlace(n);
        this.suiteNew(this.plan[n]);
        return n;
    }

    protected int newPlanImage(URL uRL, int n, String string, String string2, String string3, String string4, int n2, int n3, Obj obj) {
        return this.newPlanImage(uRL, null, n, string, string2, string3, string4, n2, n3, obj);
    }

    protected int newPlanImage(URL uRL, int n, String string, String string2, String string3, String string4, int n2, int n3, Obj obj, ResourceNode resourceNode) {
        int n4 = this.getStackIndex(string);
        string = this.prepareLabel(string);
        this.plan[n4] = new PlanImage(this.aladin, null, n, uRL, string, string2, string3, string4, n2, n3, obj, resourceNode);
        n4 = this.bestPlace(n4);
        this.suiteNew(this.plan[n4]);
        return n4;
    }

    protected int newPlanImage(URL uRL, MyInputStream myInputStream, int n, String string, String string2, String string3, String string4, int n2, int n3, Obj obj) {
        int n4 = this.getStackIndex(string);
        string = this.prepareLabel(string);
        this.plan[n4] = new PlanImage(this.aladin, myInputStream, n, uRL, string, string2, string3, string4, n2, n3, obj);
        n4 = this.bestPlace(n4);
        this.suiteNew(this.plan[n4]);
        return n4;
    }

    protected int newPlanImage(URL uRL, MyInputStream myInputStream, int n, String string, String string2, String string3, String string4, int n2, int n3, Obj obj, ResourceNode resourceNode) {
        int n4 = this.getStackIndex(string);
        string = this.prepareLabel(string);
        long l = 0L;
        try {
            l = myInputStream.getType();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.plan[n4] = (l & 0x2000000L) != 0L ? new PlanImageCube(this.aladin, null, myInputStream, string, string4, obj, resourceNode, false, true, null) : new PlanImage(this.aladin, myInputStream, n, uRL, string, string2, string3, string4, n2, n3, obj, resourceNode);
        n4 = this.bestPlace(n4);
        this.suiteNew(this.plan[n4]);
        return n4;
    }

    protected int newPlanImageCube(URL uRL, MyInputStream myInputStream, int n, String string, String string2, String string3, String string4, int n2, int n3, Obj obj, ResourceNode resourceNode) {
        if (myInputStream == null) {
            try {
                myInputStream = Util.openStream(uRL);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        int n4 = this.getStackIndex();
        this.plan[n4] = new PlanImageCube(this.aladin, null, myInputStream, string, string4, obj, resourceNode, false, true, null);
        n4 = this.bestPlace(n4);
        this.suiteNew(this.plan[n4]);
        return n4;
    }

    private int bestPlace(int n) {
        int n2;
        Plan[] planArray = this.getPlans();
        Plan plan = planArray[n];
        int n3 = plan.folder;
        if (planArray[n].type == 16) {
            int n4;
            for (n4 = planArray.length - 1; n4 >= 0 && planArray[n4].type == 16; --n4) {
            }
            if (n4 + 1 == n) {
                return n;
            }
            if (n4 != n) {
                this.permute(planArray[n], planArray[n4]);
            }
            plan.folder = n3;
            return n4;
        }
        String string = planArray[n].getTargetQuery();
        for (n2 = n + 1; n2 < planArray.length; ++n2) {
            Plan plan2 = planArray[n2];
            if (plan2.type != 12 && plan2.type != 13 && (!plan2.isOverlay() || !string.equals(plan2.getTargetQuery()) && !(plan2 instanceof PlanBG))) break;
        }
        if (n2 > planArray.length || n2 <= 0 || n2 - 1 == n) {
            return n;
        }
        this.permute(planArray[n], planArray[n2 - 1]);
        plan.folder = n3;
        return n2 - 1;
    }

    protected void bestPlacePost(Plan plan) {
        int n;
        if (plan.noBestPlacePost || plan instanceof PlanBG || !Projection.isOk(plan.projd)) {
            return;
        }
        boolean bl = plan.isOverlay();
        int n2 = plan.folder;
        int n3 = this.getIndex(plan);
        for (n = n3 + 1; n < this.plan.length; ++n) {
            Plan plan2 = this.plan[n];
            if (plan2.type != 12 && plan2.type != 13 && plan2.flagOk && (bl || !plan2.isOverlay() || !plan.projd.agree(plan2.projd, null))) break;
        }
        if (n > this.plan.length || n <= 0 || n - 1 == n3) {
            return;
        }
        this.permute(plan, this.plan[n - 1]);
        plan.folder = n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Plan dupPlan(PlanImage planImage, String string, int n, boolean bl) throws Exception {
        if (!planImage.isImage() && !(planImage instanceof PlanBG)) {
            throw new Exception("Not yet supported for this kind of plane");
        }
        if (!planImage.flagOk) {
            throw new Exception("This plane is not yet ready");
        }
        PlanImage planImage2 = null;
        Object object = this.pile;
        synchronized (object) {
            int n2 = this.getStackIndex(string);
            int n3 = this.getIndex(planImage);
            if (bl) {
                for (int i = n2; i < n3 - 1; ++i) {
                    this.plan[i] = this.plan[i + 1];
                }
                n2 = n3 - 1;
            }
            if (n2 != n3) {
                if (n == -1) {
                    n = planImage.type;
                }
                switch (n) {
                    case 2: 
                    case 20: {
                        planImage2 = new PlanImageRGB(this.aladin, planImage);
                        break;
                    }
                    case 7: {
                        planImage2 = new PlanImageAlgo(this.aladin, planImage);
                        break;
                    }
                    case 5: {
                        planImage2 = new PlanImageResamp(this.aladin, planImage);
                        break;
                    }
                    case 6: {
                        planImage2 = new PlanImageMosaic(this.aladin, planImage);
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 4: {
                        planImage2 = new PlanImage(this.aladin, planImage);
                        break;
                    }
                    case 16: {
                        if (((PlanBG)planImage).color) {
                            planImage2 = new PlanImageRGB(this.aladin, planImage);
                            break;
                        }
                        planImage2 = new PlanImage(this.aladin, planImage);
                        break;
                    }
                    case 15: {
                        planImage2 = new PlanImage(this.aladin, planImage);
                        planImage2.initZoom /= (double)((PlanImageHuge)planImage).getStep();
                    }
                }
                this.plan[n2] = planImage2;
                string = this.prepareLabel(string);
                if (string == null) {
                    string = "[" + planImage.label + "]";
                }
                planImage2.setLabel(string);
            } else {
                planImage.isOldPlan = true;
                planImage2 = planImage;
            }
        }
        this.suiteNew(planImage2);
        if (bl) {
            planImage2.selected = false;
            planImage2.active = false;
        } else {
            planImage2.folder = 0;
            planImage2.planReady(true);
        }
        return planImage2;
    }

    protected PlanImageResamp rspPlan(PlanImage planImage) {
        if (planImage.type != 1) {
            return null;
        }
        PlanImageResamp planImageResamp = null;
        int n = this.getIndex(planImage);
        planImageResamp = new PlanImageResamp(this.aladin, planImage);
        this.plan[n] = planImageResamp;
        this.suiteNew(planImageResamp);
        return planImageResamp;
    }

    protected PlanImageAlgo algoPlan(PlanImage planImage) {
        if (!planImage.isSimpleImage()) {
            return null;
        }
        PlanImageAlgo planImageAlgo = null;
        int n = this.getIndex(planImage);
        planImageAlgo = new PlanImageAlgo(this.aladin, planImage);
        this.plan[n] = planImageAlgo;
        this.suiteNew(planImageAlgo);
        return planImageAlgo;
    }

    protected PlanImage greyPlan(PlanImageRGB planImageRGB) {
        if (planImageRGB.type != 2) {
            return null;
        }
        PlanImage planImage = new PlanImage(this.aladin, planImageRGB);
        planImage.type = 1;
        planImage.pixelsOrigin = planImageRGB.getGreyPixels();
        planImage.bitpix = 8;
        planImage.npix = 1;
        planImage.setBufPixels8(planImage.getPix8Bits(null, planImage.pixelsOrigin, 8, planImageRGB.width, planImageRGB.height, planImageRGB.dataMinFits, planImageRGB.dataMaxFits, false, 0, 0, 0));
        planImage.calculPixelsZoom();
        planImage.fmt = 1;
        planImage.video = 0;
        planImage.cm = CanvasColorMap.getCM(0, 128, 255, planImage.video == 1, this.aladin.configuration.getCMMap(), this.aladin.configuration.getCMFct());
        planImage.cmControl[0] = 0;
        planImage.cmControl[1] = 128;
        planImage.cmControl[2] = 255;
        planImage.pixMode = 3;
        planImage.changeImgID();
        planImage.setPourcent(-1.0);
        int n = this.getIndex(planImageRGB);
        this.plan[n] = planImage;
        this.suiteNew(planImage);
        planImageRGB.Free();
        return planImage;
    }

    protected int newPlanImage(MyInputStream myInputStream, String string) {
        PlanImage planImage = null;
        int n = -1;
        n = this.getStackIndex(string);
        string = this.prepareLabel(string);
        planImage = new PlanImage(this.aladin, myInputStream, string);
        this.plan[n] = planImage;
        this.suiteNew(planImage);
        return n;
    }

    protected int newPlanImage(InputStream inputStream, String string, String string2) {
        PlanImage planImage = null;
        int n = -1;
        n = this.getStackIndex(string);
        string = this.prepareLabel(string);
        planImage = new PlanImage(this.aladin, inputStream, string, string2);
        this.plan[n] = planImage;
        this.suiteNew(planImage);
        return n;
    }

    protected int[] getNumExt(String string) {
        String string2 = string;
        int[] nArray = new int[1000];
        int n = 0;
        try {
            int n2 = string2.lastIndexOf(91);
            if (n2 < 0) {
                return null;
            }
            int n3 = string2.indexOf(93, n2);
            if (n3 < 0 || n3 != string2.length() - 1) {
                return null;
            }
            string2 = string2.substring(n2 + 1, n3);
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",;");
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                n2 = string3.indexOf(45);
                if (n2 > 0) {
                    int n4 = Integer.parseInt(string3.substring(0, n2));
                    int n5 = Integer.parseInt(string3.substring(n2 + 1));
                    n2 = n4;
                    while (n2 <= n5) {
                        nArray[n++] = n2++;
                    }
                } else {
                    nArray[n++] = Integer.parseInt(string3);
                }
                if (n != 1000) continue;
                Aladin.warning(this, "Too many Fits extension/frame designation ");
                return null;
            }
        }
        catch (Exception exception) {
            Aladin.warning(this, "Bad FITS extension/frame designation " + string2);
            return null;
        }
        int[] nArray2 = new int[n];
        System.arraycopy(nArray, 0, nArray2, 0, n);
        return nArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void newFitsExt(String string, MyInputStream myInputStream, String string2, Obj obj, String string3, String string4) {
        if (string != null && string2 == null) {
            int n = string.lastIndexOf(Util.FS);
            string2 = n >= 0 ? string.substring(n + 1) : string;
        } else if (string2 == null) {
            string2 = "Fits ext";
        }
        this.waitLock();
        this._target = string3;
        this._radius = string4;
        this._file = string;
        this._in = myInputStream;
        this._firstPlan = new PlanImage(this.aladin);
        this._firstPlan.dis = myInputStream;
        this._firstPlan.setLabel(string2);
        this._firstPlan.flagOk = false;
        Object object = this.pile;
        synchronized (object) {
            int n = this.getStackIndex();
            this.plan[n] = this._firstPlan;
        }
        int n = string2.lastIndexOf(46);
        this._label = n > 0 ? string2.substring(0, n) : string2;
        this._o = obj;
        this.select.repaint();
        Thread thread = new Thread((Runnable)this, "AladinFitsExtQuery");
        Util.decreasePriority(Thread.currentThread(), thread);
        Plan.aladinQueryThread(thread);
        thread.start();
    }

    private void waitLock() {
        while (!this.getLock()) {
            Util.pause(10);
        }
    }

    private void unlock() {
        this.lock = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getLock() {
        Object object = this.lockObj;
        synchronized (object) {
            if (this.lock) {
                return false;
            }
            this.lock = true;
            return true;
        }
    }

    @Override
    public void run() {
        this.newFitsExtThread();
        this.stack();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stack() {
        Object object = this.pile;
        synchronized (object) {
            int n = this.plan.length - 1;
            for (int i = this.plan.length - 1; i >= 0; --i) {
                if (this.plan[i].isEmpty() || this.plan[i].type == 0) continue;
                this.plan[n--] = this.plan[i];
            }
            while (n >= 0) {
                if (!this.plan[n].isEmpty() && this.plan[n].type != 0) {
                    this.plan[n] = new PlanFree(this.aladin);
                }
                --n;
            }
        }
    }

    private boolean keepFitsExt(int n, int[] nArray) {
        if (nArray == null) {
            return true;
        }
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != n) continue;
            nArray[i] = -1;
            return true;
        }
        return false;
    }

    private boolean allFitsExt(int[] nArray) {
        if (nArray == null) {
            return false;
        }
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == -1) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void newFitsExtThread() {
        int n;
        Vector<Plan> vector;
        PlanFolder planFolder;
        String string;
        MyInputStream myInputStream;
        Plan plan;
        block44: {
            plan = null;
            String string2 = this._target;
            String string3 = this._radius;
            String string4 = this._file;
            myInputStream = this._in;
            string = this._label;
            planFolder = new PlanFolder(this.aladin, string);
            Plan plan2 = this._firstPlan;
            Obj obj = this._o;
            int n2 = 0;
            int[] nArray = null;
            if (string4 != null) {
                nArray = this.getNumExt(string4);
            }
            this.unlock();
            vector = new Vector<Plan>();
            try {
                int n3 = 0;
                while (!this.allFitsExt(nArray)) {
                    long l;
                    Object object;
                    n = this.keepFitsExt(n3, nArray);
                    plan = null;
                    myInputStream.resetType();
                    long l2 = myInputStream.getType();
                    if ((l2 & 0x80000000000L) != 0L) break;
                    Aladin.trace(3, "MultiExtension " + n3 + " detect => " + MyInputStream.decodeType(l2));
                    if ((l2 & 1L) != 0L) {
                        object = null;
                        object = (l2 & 0x2000000L) != 0L ? ((l2 & 0x400000000L) != 0L ? new PlanImageCubeRGB(this.aladin, string4, myInputStream, string, null, obj, null, false, false, null) : new PlanImageCube(this.aladin, string4, myInputStream, string + "[" + n3 + "]", null, obj, null, n == 0, false, plan2)) : ((l2 & 0x8000000L) != 0L ? new PlanImageHuge(this.aladin, string4, myInputStream, string + "[" + n3 + "]", null, obj, null, n == 0, false, plan2) : ((l2 & 0x100000000L) != 0L ? new PlanHealpix(this.aladin, string4, myInputStream, string + "[" + n3 + "]", 0, 0, false, this.getTargetBG(string2, null), this.getRadiusBG(string2, string3, null)) : new PlanImage(this.aladin, string4, myInputStream, string + "[" + n3 + "]", null, obj, null, n == 0, false, plan2)));
                        if (n3 == 0 && ((PlanImage)object).error != null && ((PlanImage)object).error.equals("_HEAD_XFITS_")) {
                            planFolder.headerFits = ((PlanImage)object).headerFits;
                        } else {
                            if (((PlanImage)object).error == null || ((PlanImage)object).error.equals("_END_XFITS_")) {
                                ((PlanImage)object).pixelsOriginIntoCache();
                            }
                            plan = object;
                        }
                    } else {
                        if ((l2 & 0x1800000L) == 0L) {
                            Aladin.trace(3, "One MEF extension not supported => ignored!");
                            break;
                        }
                        if ((l2 & 0x80000000L) != 0L) {
                            plan = new PlanImageRice(this.aladin, string4, myInputStream, string, null, obj, null, n == 0, false, plan2);
                        } else if ((l2 & 0x10000000L) != 0L) {
                            Aladin.trace(3, "MEF AIPS CC table detected => ignored !");
                            new PlanCatalog(this.aladin, "", myInputStream, true, false);
                        } else {
                            PlanCatalog planCatalog = new PlanCatalog(this.aladin, "", myInputStream, n == 0, false);
                            if (planCatalog.label.equals("")) {
                                planCatalog.setLabel(string4);
                            }
                            plan = planCatalog;
                            if ((planCatalog.pcat.badRaDecDetection || planCatalog.pcat.getCount() == 0) && n3 > 0 && vector.size() > 0 && vector.elementAt(0).isImage()) {
                                plan = null;
                                this.aladin.command.printConsole("!!! Table MEF extension ignored => seems to be reduction information");
                            }
                        }
                    }
                    planFolder.setPourcent(n3);
                    if (plan != null) {
                        if (plan.error != null && plan.error.equals("_END_XFITS_")) break;
                        if (n != 0) {
                            if (plan.isImage()) {
                                ((PlanImage)plan).pixelsOriginIntoCache();
                            }
                            plan.askActive = !plan.isImage();
                            plan.selected = false;
                            vector.add(plan);
                            if (plan.label == null || plan.label.equals("") || plan.label.startsWith("~")) {
                                plan.setLabel(string + (vector.size() > 0 ? "[" + n3 + "]" : ""));
                            }
                            if (n2 < 2) {
                                object = this.pile;
                                synchronized (object) {
                                    int n4 = this.getIndex(plan2);
                                    if (n2 == 0) {
                                        plan2 = this.plan[n4] = plan;
                                    } else if (n2 == 1) {
                                        this.plan[n4] = planFolder;
                                    }
                                    ++n2;
                                }
                                this.select.repaint();
                            }
                        }
                    }
                    if ((l = myInputStream.getPos()) % 2880L != 0L) {
                        long l3 = (l / 2880L + 1L) * 2880L - l;
                        myInputStream.skip(l3);
                    }
                    ++n3;
                }
            }
            catch (Exception exception) {
                if (Aladin.levelTrace < 3) break block44;
                exception.printStackTrace();
            }
        }
        try {
            myInputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (PlanMultiCCD.isMultiCCD(vector)) {
            if (string.charAt(0) == '=') {
                string = string.substring(1);
            }
            plan = new PlanMultiCCD(this.aladin, string, vector);
            Object object = this.pile;
            synchronized (object) {
                n = this.getIndex(planFolder);
                this.plan[n] = plan;
            }
            plan.planReady(true);
            this.select.repaint();
            return;
        }
        planFolder.planReady(true);
        if (vector.size() == 0) {
            return;
        }
        if (vector.size() > 1) {
            Object object = this.pile;
            synchronized (object) {
                Enumeration<Plan> enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    int n5 = this.getStackIndex();
                    this.plan[n5] = enumeration.nextElement();
                    this.plan[n5].setLabel(this.plan[n5].label);
                    this.permute(this.plan[n5], planFolder);
                }
            }
        }
        plan = vector.elementAt(0);
        if (vector.size() == 1) {
            if (string.charAt(0) == '=') {
                string = string.substring(1);
            }
            plan.setLabel(string);
        }
        plan.doClose = true;
        plan.planReady(true);
        if (vector.size() > 6) {
            this.aladin.calque.select.switchCollapseFolder(planFolder);
        }
    }

    public void seekFitsExt(MyInputStream myInputStream, int n) throws Exception {
        for (int i = 0; i < n; ++i) {
            Plan plan = null;
            myInputStream.resetType();
            long l = myInputStream.getType();
            if ((l & 1L) != 0L) {
                plan = new PlanImage(this.aladin, "", myInputStream, "", null, null, null, true, false, null);
            } else if ((l & 0x1800000L) != 0L) {
                plan = new PlanCatalog(this.aladin, "", myInputStream, true, false);
            } else {
                Aladin.trace(3, "Extension type not supported !");
                break;
            }
            if (plan != null && plan.error != null && plan.error.equals("_END_XFITS_")) {
                throw new EOFException();
            }
            long l2 = myInputStream.getPos();
            if (l2 % 2880L == 0L) continue;
            long l3 = (l2 / 2880L + 1L) * 2880L - l2;
            myInputStream.skip(l3);
        }
    }

    protected int newPlanImage(String string, MyInputStream myInputStream, String string2, String string3, Obj obj, ResourceNode resourceNode) {
        int n = this.getStackIndex(string2);
        string2 = this.prepareLabel(string2);
        long l = 0L;
        try {
            l = myInputStream.getType();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.plan[n] = (l & 0x2000000L) != 0L && (l & 0x400000000L) != 0L ? new PlanImageCubeRGB(this.aladin, string, myInputStream, string2, string3, obj, resourceNode, false, true, null) : ((l & 0x2000000L) != 0L ? new PlanImageCube(this.aladin, string, myInputStream, string2, string3, obj, resourceNode, false, true, null) : ((l & 0x8000000L) != 0L ? new PlanImageHuge(this.aladin, string, myInputStream, string2, string3, obj, resourceNode, false, true, null) : new PlanImage(this.aladin, string, myInputStream, string2, string3, obj, resourceNode, false, true, null)));
        if (Calque.isNewPlan(string2)) {
            n = this.bestPlace(n);
        }
        this.suiteNew(this.plan[n]);
        return n;
    }

    protected static boolean isNewPlan(String string) {
        return string == null || string.length() <= 0 || string.charAt(0) != '=';
    }

    protected String newPlanPlugImg(String string) {
        int n = this.getStackIndex();
        PlanImage planImage = new PlanImage(this.aladin);
        this.plan[n] = planImage;
        planImage.setLabel(string);
        planImage.creatDefaultCM();
        planImage.orig = 3;
        planImage.flagOk = true;
        return planImage.getLabel();
    }

    protected String newPlanPlugCat(String string) {
        int n = this.getStackIndex();
        PlanCatalog planCatalog = new PlanCatalog(this.aladin);
        this.plan[n] = planCatalog;
        planCatalog.setLabel(string);
        return planCatalog.getLabel();
    }

    protected int newPlanImageRGB(String string, URL uRL, MyInputStream myInputStream) {
        int n = this.getStackIndex();
        if (n < 0) {
            return -1;
        }
        this.plan[n] = new PlanImageRGB(this.aladin, string, uRL, myInputStream);
        this.bestPlace(n);
        this.suiteNew(this.plan[n]);
        return n;
    }

    protected int newPlanImageRGB(URL uRL, MyInputStream myInputStream, int n, String string, String string2, String string3, String string4, int n2, int n3, Obj obj, ResourceNode resourceNode) {
        int n4 = this.getStackIndex(string);
        string = this.prepareLabel(string);
        this.plan[n4] = new PlanImageRGB(this.aladin, myInputStream, n, uRL, string, string2, string3, string4, n2, n3, obj, resourceNode);
        n4 = this.bestPlace(n4);
        this.suiteNew(this.plan[n4]);
        return n4;
    }

    protected int newPlanImageRGB(String string, URL uRL, MyInputStream myInputStream, ResourceNode resourceNode) {
        int n = this.getStackIndex();
        this.plan[n] = new PlanImageRGB(this.aladin, string, uRL, myInputStream, resourceNode);
        n = this.bestPlace(n);
        this.suiteNew(this.plan[n]);
        return n;
    }

    protected int newPlanHealpix(String string, MyInputStream myInputStream, String string2, int n, int n2, boolean bl) {
        return this.newPlanHealpix(string, myInputStream, string2, n, n2, bl, null, null);
    }

    protected int newPlanHealpix(String string, MyInputStream myInputStream, String string2, int n, int n2, boolean bl, String string3, String string4) {
        Coord coord = this.getTargetBG(string3, null);
        double d = this.getRadiusBG(string3, string4, null);
        int n3 = this.getStackIndex();
        this.plan[n3] = new PlanHealpix(this.aladin, string, myInputStream, string2, n, n2, bl, coord, d);
        n3 = this.bestPlace(n3);
        this.suiteNew(this.plan[n3]);
        return n3;
    }

    protected int newPlanImageColor(String string, URL uRL, MyInputStream myInputStream) {
        int n = this.getStackIndex();
        this.plan[n] = new PlanImageColor(this.aladin, string, uRL, myInputStream);
        n = this.bestPlace(n);
        this.suiteNew(this.plan[n]);
        return n;
    }

    protected int newPlanImageColor(URL uRL, MyInputStream myInputStream, int n, String string, String string2, String string3, String string4, int n2, int n3, Obj obj, ResourceNode resourceNode) {
        int n4 = this.getStackIndex(string);
        string = this.prepareLabel(string);
        this.plan[n4] = new PlanImageColor(this.aladin, myInputStream, n, uRL, string, string2, string3, string4, n2, n3, obj, resourceNode);
        n4 = this.bestPlace(n4);
        this.suiteNew(this.plan[n4]);
        return n4;
    }

    protected int newPlanImageColor(String string, URL uRL, MyInputStream myInputStream, ResourceNode resourceNode) {
        int n = this.getStackIndex();
        this.plan[n] = new PlanImageColor(this.aladin, string, uRL, myInputStream, resourceNode);
        n = this.bestPlace(n);
        this.suiteNew(this.plan[n]);
        return n;
    }

    protected boolean planToolOk(Plan plan, boolean bl) {
        return (plan.type == 9 || bl && plan.type == 10) && plan.isReady() && plan.isSelectable();
    }

    protected PlanTool selectPlanTool() {
        return (PlanTool)this.selectPlanTool1(false);
    }

    protected Plan selectPlanToolOrFoV() {
        return this.selectPlanTool1(true);
    }

    private Plan selectPlanTool1(boolean bl) {
        try {
            Plan plan = this.getFirstSelectedPlan();
            ViewSimple viewSimple = this.aladin.view.getCurrentView();
            int n = this.getIndex(viewSimple.pref);
            if (this.planToolOk(plan, bl) && this.getIndex(plan) < n) {
                return plan;
            }
            Plan[] planArray = this.getPlans();
            for (int i = 0; i < planArray.length && i < n; ++i) {
                if (!this.planToolOk(planArray[i], bl)) continue;
                this.selectPlan(planArray[i]);
                return planArray[i];
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.createPlanTool(null);
    }

    protected PlanTool newPlanTool(String string) {
        return this.createPlanTool(string);
    }

    protected PlanTool createPlanTool(String string) {
        int n = this.getStackIndex();
        PlanTool planTool = new PlanTool(this.aladin, string);
        this.plan[n] = planTool;
        planTool.selected = true;
        planTool.active = true;
        Plan plan = this.getPlanRef();
        planTool.projd = plan == null || !Projection.isOk(plan.projd) ? null : new Projection("Myproj", 2, plan.projd.alphai, plan.projd.deltai, 5400.0, 250.0, 250.0, 500.0, 0.0, false, 4, Calib.FK5);
        this.suiteNew(planTool);
        this.aladin.command.resetPreviousDrawing();
        return planTool;
    }

    protected PlanField createPlanField(String string, Coord coord, double d, boolean bl, boolean bl2) {
        int n = this.getStackIndex();
        PlanField planField = new PlanField(this.aladin, string, coord, d, bl, bl2);
        this.plan[n] = planField;
        planField.active = true;
        this.suiteNew(planField);
        return planField;
    }

    protected int newPlanFov(String string, Fov[] fovArray) {
        int n = this.getStackIndex();
        this.plan[n] = new PlanFov(this.aladin, string, fovArray);
        this.suiteNew(this.plan[n]);
        return n;
    }

    protected int newPlanContour(String string, PlanImage planImage, double[] dArray, ContourAlgorithm contourAlgorithm, boolean bl, int n, boolean bl2, boolean bl3, Color[] colorArray) {
        int n2 = this.getStackIndex();
        if (dArray == null) {
            this.plan[n2] = new PlanContour(this.aladin, string);
        } else {
            Color color = PlanContour.getNextColor(this.aladin.calque);
            this.plan[n2] = new PlanContour(this.aladin, string, planImage, dArray, contourAlgorithm, bl, n, bl2, bl3, colorArray, color);
        }
        n2 = this.bestPlace(n2);
        this.suiteNew(this.plan[n2]);
        return n2;
    }

    protected int newPlanField(String string, double d, String string2, String string3) {
        int n = this.getStackIndex(string3);
        string3 = this.prepareLabel(string3);
        this.plan[n] = new PlanField(this.aladin, string, d, string2, string2);
        if (((PlanField)this.plan[n]).needTarget && this.plan[n].objet != null) {
            this.aladin.view.setRepere(this.plan[n]);
        }
        this.suiteNew(this.plan[n]);
        this.plan[n].planReady(!((PlanField)this.plan[n]).needTarget);
        return n;
    }

    protected int newPlanField(FootprintBean footprintBean, String string, String string2, double d) {
        int n = this.getStackIndex(string2);
        string2 = this.prepareLabel(string2);
        this.plan[n] = new PlanField(this.aladin, string, footprintBean, string2, d);
        if (((PlanField)this.plan[n]).needTarget && this.plan[n].objet != null) {
            this.aladin.view.setRepere(this.plan[n]);
        }
        this.suiteNew(this.plan[n]);
        this.plan[n].planReady(!((PlanField)this.plan[n]).needTarget);
        return n;
    }

    protected int newPlanField(PlanField planField, String string) {
        int n = this.getStackIndex(string);
        string = this.prepareLabel(string);
        this.plan[n] = planField;
        planField.setLabel(string);
        this.suiteNew(this.plan[n]);
        this.plan[n].planReady(!((PlanField)this.plan[n]).needTarget);
        return n;
    }

    protected void setCenterForField(double d, double d2) {
        for (int i = 0; i < this.plan.length; ++i) {
            if (this.plan[i].type != 10 || !((PlanField)this.plan[i]).needTarget) continue;
            ((PlanField)this.plan[i]).resolveTarget(d, d2);
        }
    }

    protected void newPlanImageFromBlink(PlanImageBlink planImageBlink, int n) throws Exception {
        if (n == -1) {
            n = this.aladin.view.getView((Plan)planImageBlink).cubeControl.lastFrame;
        }
        planImageBlink.activePixelsOrigin(n);
        PlanImage planImage = (PlanImage)this.aladin.calque.dupPlan(planImageBlink, null, planImageBlink.type, false);
        planImage.setLabel(planImageBlink.label + "#" + n);
        planImage.setHasSpecificCalib();
        planImage.headerFits.setKeyValue("NAXIS", "2");
        planImage.isOldPlan = false;
        planImage.selected = false;
        planImage.pourcent = -1.0;
        planImage.flagOk = true;
        planImage.type = 1;
        planImage.copyright = "Extract from " + planImageBlink.label + " (frame #" + (n + 1) + ")";
    }

    protected void newPlanImageByCrop(final ViewSimple viewSimple, final RectangleD rectangleD, final double d, final boolean bl) {
        final double d2 = viewSimple.zoom;
        new Thread("crop"){

            @Override
            public void run() {
                viewSimple.cropArea(rectangleD, null, d2, d, bl, true);
                Calque.this.repaintAll();
            }
        }.start();
    }

    protected String newPlanCatalogByCatalogs(Plan[] planArray, boolean bl, String string) {
        StringBuilder stringBuilder = null;
        Plan[] planArray2 = planArray != null ? planArray : this.getPlans();
        Vector<Source> vector = new Vector<Source>(100000);
        for (int i = 0; i < planArray2.length; ++i) {
            if (!planArray2[i].isCatalog() || !planArray2[i].flagOk || planArray == null && !planArray2[i].selected) continue;
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder(Tok.quote(planArray2[i].label));
            } else {
                stringBuilder.append(" " + Tok.quote(planArray2[i].label));
            }
            Iterator<Obj> iterator = planArray2[i].iterator();
            while (iterator.hasNext()) {
                Obj obj = iterator.next();
                if (!(obj instanceof Source)) continue;
                Source source = (Source)obj;
                vector.addElement(source);
            }
        }
        this.newPlanCatalogBySources(vector, string, bl);
        this.repaintAll();
        return stringBuilder == null ? "" : stringBuilder.toString();
    }

    protected void newPlanCatalogBySelectedObjet(boolean bl) {
        this.newPlanCatalogBySelectedObjet("Select.src", bl);
    }

    protected void newPlanCatalogBySelectedObjet(String string, boolean bl) {
        Vector<Obj> vector = this.aladin.view.getSelectedObjet();
        PlanCatalog planCatalog = this.newPlanCatalogBySources(vector, string, bl);
        if (planCatalog != null) {
            this.aladin.view.selectAllInPlan(planCatalog);
        }
    }

    protected PlanCatalog newPlanCatalogBySources(Vector vector, String string, boolean bl) {
        if (vector == null) {
            return null;
        }
        if (string == null || string.length() == 0) {
            string = "New.cat";
        }
        int n = this.getStackIndex(string);
        string = this.prepareLabel(string);
        this.newPlanCatalog(n);
        PlanCatalog planCatalog = (PlanCatalog)this.plan[n];
        planCatalog.setLabel(string);
        if (!bl) {
            Vector<Legende> vector2 = new Vector<Legende>(10);
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                Obj obj = (Obj)enumeration.nextElement();
                if (!(obj instanceof Source)) continue;
                Source source = (Source)obj;
                Source source2 = new Source(planCatalog, source.raj, source.dej, source.id, source.info);
                planCatalog.pcat.setObjetFast(source2);
                source2.isSelected = source.isSelected;
                source2.values = source.values;
                source2.actions = source.actions;
                source2.leg = source.leg;
                if (vector2.contains(source.leg)) continue;
                vector2.addElement(source.leg);
            }
            planCatalog.pcat.nbTable = vector2.size();
        } else {
            Source source;
            Object object;
            ArrayList<Legende> arrayList = new ArrayList<Legende>(10);
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                object = (Obj)enumeration.nextElement();
                if (!(object instanceof Source)) continue;
                source = (Source)object;
                if (arrayList.contains(source.leg)) continue;
                arrayList.add(source.leg);
            }
            object = new Legende(arrayList);
            enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                Obj obj = (Obj)enumeration.nextElement();
                if (!(obj instanceof Source)) continue;
                source = (Source)obj;
                String string2 = this.createInfo(source, (Legende)object);
                Source source3 = new Source(planCatalog, source.raj, source.dej, source.id, string2);
                planCatalog.pcat.setObjetFast(source3);
                planCatalog.pcat.nbTable = 1;
                source3.leg = object;
            }
        }
        if (this.aladin.calque.getPlanRef() != null) {
            planCatalog.objet = this.aladin.calque.getPlanRef().objet;
        }
        planCatalog.setActivated(true);
        planCatalog.pcat.createDefaultProj();
        return planCatalog;
    }

    private String createInfo(Source source, Legende legende) {
        int n;
        String[] stringArray = new String[legende.getSize()];
        int n2 = source.info.indexOf(9);
        int n3 = n2 + 1;
        int n4 = 0;
        while (n2 != -1) {
            n2 = source.info.indexOf(9, n3);
            n = legende.find(source.leg.field[n4]);
            if (n != -1) {
                stringArray[n] = n2 != -1 ? source.info.substring(n3, n2) : source.info.substring(n3);
                n3 = n2 + 1;
            }
            ++n4;
        }
        StringBuffer stringBuffer = new StringBuffer("<&_X|X>");
        for (n = 0; n < stringArray.length; ++n) {
            stringBuffer.append("\t" + (stringArray[n] == null ? " " : stringArray[n]));
        }
        return stringBuffer.toString();
    }

    protected int newPlanCatalog(URL uRL, String string, String string2, String string3, String string4, Server server) {
        return this.newPlanCatalog(uRL, null, string, string2, string3, string4, server);
    }

    protected int newPlanCatalog(URL uRL, MyInputStream myInputStream, String string, String string2, String string3, String string4, Server server) {
        int n = this.getStackIndex(string);
        string = this.prepareLabel(string);
        this.plan[n] = new PlanCatalog(this.aladin, uRL, myInputStream, string, string2, string3, string4, server);
        this.suiteNew(this.plan[n]);
        return n;
    }

    protected int newPlanCatalog(String string) {
        return this.newPlanCatalog(string, null);
    }

    protected int newPlanCatalog(String string, MyInputStream myInputStream) {
        int n = this.getStackIndex();
        this.plan[n] = new PlanCatalog(this.aladin, string, myInputStream, false, true);
        this.suiteNew(this.plan[n]);
        return n;
    }

    PlanImage createCropImage(ViewSimple viewSimple) throws Exception {
        if (!(viewSimple.pref instanceof PlanBG)) {
            throw new Exception("Cropping only on HiPS");
        }
        PointD pointD = viewSimple.getPosition(0.0, 0.0);
        return viewSimple.cropAreaBG(new RectangleD(pointD.x, pointD.y, (double)viewSimple.rv.width / viewSimple.zoom, (double)viewSimple.rv.height / viewSimple.zoom), "Crop." + viewSimple.pref.label, viewSimple.zoom, 1.0, false, false);
    }

    protected Plan createPlanCatalog(MyInputStream myInputStream, String string) {
        int n = this.newPlanCatalog(myInputStream, string);
        return this.plan[n];
    }

    protected int newPlan(Plan plan) {
        int n = this.getStackIndex();
        this.plan[n] = plan;
        this.suiteNew(plan);
        return n;
    }

    protected int newPlanCatalog(MyInputStream myInputStream, String string) {
        int n = this.getStackIndex(string);
        string = this.prepareLabel(string);
        this.plan[n] = new PlanCatalog(this.aladin, myInputStream, string);
        this.suiteNew(this.plan[n]);
        return n;
    }

    protected int newPlanCatalog(MyInputStream myInputStream, String string, String string2) {
        int n = this.getStackIndex(string);
        string = this.prepareLabel(string);
        this.plan[n] = new PlanCatalog(this.aladin, myInputStream, string, string2);
        this.suiteNew(this.plan[n]);
        return n;
    }

    protected String prepareLabel(String string) {
        if (!Calque.isNewPlan(string)) {
            if (string.charAt(1) == '@') {
                int n;
                try {
                    n = Integer.parseInt(string.substring(2));
                    n = this.plan.length - n;
                }
                catch (Exception exception) {
                    return null;
                }
                if (this.plan[n].type == 0 || this.plan[n].type == 14) {
                    return null;
                }
                return "=" + this.plan[n].label;
            }
            String string2 = string.substring(1);
            if (this.getIndexPlan(string2, 1) < 0) {
                return string2;
            }
        }
        return string;
    }

    private Vector<Plan> splitCatalog1(PlanCatalog planCatalog) {
        Vector<Plan> vector = new Vector<Plan>(10);
        PlanCatalog planCatalog2 = null;
        Legende legende = null;
        int n = planCatalog.folder;
        PlanFolder planFolder = new PlanFolder(this.aladin, planCatalog.label, n, false);
        planFolder.label = planCatalog.label;
        planFolder.active = true;
        planFolder.projd = planCatalog.projd;
        planFolder.u = planCatalog.u;
        planFolder.pcat = new Pcat(planFolder, null, this, null, this.aladin);
        planFolder.pcat.description = planCatalog.pcat.description;
        planFolder.pcat.parsingInfo = planCatalog.pcat.parsingInfo;
        vector.addElement(planFolder);
        Iterator<Obj> iterator = planCatalog.iterator();
        while (iterator.hasNext()) {
            Obj obj = iterator.next();
            if (!(obj instanceof Source)) continue;
            Source source = (Source)obj;
            if (source.leg != legende) {
                planCatalog2 = new PlanCatalog(this.aladin);
                planCatalog2.server = planCatalog.server;
                planCatalog2.c = planCatalog.c;
                planCatalog2.folder = n + 1;
                planCatalog2.copyright = planCatalog.copyright;
                planCatalog2.co = planCatalog.co;
                planCatalog2.param = planCatalog.param;
                planCatalog2.objet = planCatalog.objet;
                planCatalog2.pcat.nbTable = 1;
                planCatalog2.sourceType = planCatalog.sourceType;
                planCatalog2.fullSource = planCatalog.fullSource;
                planCatalog2.planFilter = planCatalog.planFilter;
                planCatalog2.projd = planCatalog.projd.copy();
                planCatalog2.setLabel(planCatalog2.getTableName(source));
                vector.addElement(planCatalog2);
                legende = source.leg;
            }
            source.plan = planCatalog2;
            planCatalog2.pcat.setObjetFast(source);
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void splitCatalog(PlanCatalog planCatalog) {
        if (planCatalog.getNbTable() == 1) {
            return;
        }
        Vector<Plan> vector = this.splitCatalog1(planCatalog);
        int n = vector.size() - 1;
        this.getStackIndex(null, n);
        Object object = this.pile;
        synchronized (object) {
            int n2;
            int n3 = this.getIndex(planCatalog);
            for (n2 = 0; n2 < n3 - n; ++n2) {
                this.plan[n2] = this.plan[n2 + n];
            }
            for (n2 = 0; n2 <= n; ++n2) {
                Plan plan;
                this.plan[n3 - n + n2] = plan = vector.elementAt(n2);
                plan.setActivated(true);
                if (n2 <= 1) continue;
                plan.c = Couleur.getNextDefault(this);
            }
        }
        this.stack();
    }

    protected int newPlanCatalog() {
        return this.newPlanCatalog(-1);
    }

    protected int newPlanCatalog(int n) {
        if (n == -1) {
            n = this.getStackIndex();
        }
        this.plan[n] = new PlanCatalog(this.aladin);
        Projection projection = this.aladin.view.getCurrentView().getProj();
        this.plan[n].projd = projection == null ? null : projection.copy();
        this.suiteNew(this.plan[n]);
        return n;
    }

    boolean isBackGround() {
        Plan plan = this.getPlanBase();
        return plan != null && plan.type == 16;
    }

    private Coord getTargetBG(String string, TreeNodeAllsky treeNodeAllsky) {
        Coord coord;
        block8: {
            coord = null;
            if (string != null && string.length() > 0) {
                try {
                    if (!View.notCoord(string)) {
                        coord = new Coord(string);
                        break block8;
                    }
                    coord = this.aladin.view.sesame(string);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else if (treeNodeAllsky != null && treeNodeAllsky.getTarget() != null) {
                coord = treeNodeAllsky.getTarget();
            } else if (!this.aladin.view.isFree() && this.aladin.view.repere != null && !Double.isNaN(this.aladin.view.repere.raj)) {
                coord = new Coord(this.aladin.view.repere.raj, this.aladin.view.repere.dej);
            }
        }
        return coord;
    }

    private double getRadiusBG(String string, String string2, TreeNodeAllsky treeNodeAllsky) {
        double d = -1.0;
        if (string2 != null && string2.length() > 0) {
            try {
                d = Server.getAngleInArcmin(string2, 1) / 60.0;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else if (treeNodeAllsky != null && treeNodeAllsky.getRadius() != -1.0) {
            d = treeNodeAllsky.getRadius();
        } else if ((string == null || string.length() == 0) && d == -1.0) {
            try {
                d = this.aladin.view.getCurrentView().getTaille();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return d;
    }

    protected int newPlanMOC(MyInputStream myInputStream, String string) {
        int n = this.getStackIndex(string);
        string = this.prepareLabel(string);
        Coord coord = this.getTargetBG(null, null);
        double d = this.getRadiusBG(null, null, null);
        this.plan[n] = new PlanMoc(this.aladin, myInputStream, string, coord, d);
        n = this.bestPlace(n);
        this.suiteNew(this.plan[n]);
        return n;
    }

    protected int newPlanMOC(HealpixMoc healpixMoc, String string) {
        int n = this.getStackIndex(string);
        string = this.prepareLabel(string);
        Coord coord = this.getTargetBG(null, null);
        double d = this.getRadiusBG(null, null, null);
        this.plan[n] = new PlanMoc(this.aladin, healpixMoc, string, coord, d);
        n = this.bestPlace(n);
        this.suiteNew(this.plan[n]);
        return n;
    }

    public int newPlanBG(String string, String string2, String string3, String string4) {
        return this.newPlanBG(null, string, null, string2, string3, string4);
    }

    public int newPlanBG(TreeNodeAllsky treeNodeAllsky, String string, String string2, String string3) {
        return this.newPlanBG(treeNodeAllsky, null, null, string, string2, string3);
    }

    public int newPlanBG(URL uRL, String string, String string2, String string3) {
        return this.newPlanBG(null, null, uRL, string, string2, string3);
    }

    public int newPlanBG(TreeNodeAllsky treeNodeAllsky, String string, URL uRL, String string2, String string3, String string4) {
        PlanBG planBG;
        int n = this.getStackIndex(string2);
        string2 = this.prepareLabel(string2);
        Coord coord = this.getTargetBG(string3, treeNodeAllsky);
        double d = this.getRadiusBG(string3, string4, treeNodeAllsky);
        String string5 = this.aladin.synchroPlan.start("Calque.newPlanBG/creating" + (string2 == null ? "" : "/" + string2));
        if (treeNodeAllsky != null) {
            planBG = treeNodeAllsky.isProgen() ? new PlanBGProgen(this.aladin, treeNodeAllsky, string2, coord, d, string5) : (treeNodeAllsky.isCatalog() ? new PlanBGCat(this.aladin, treeNodeAllsky, string2, coord, d, string5) : (treeNodeAllsky.isMap() ? new PlanHealpix(this.aladin, treeNodeAllsky, string2, coord, d, string5) : (treeNodeAllsky.isCube() ? new PlanBGCube(this.aladin, treeNodeAllsky, string2, coord, d, string5) : new PlanBG(this.aladin, treeNodeAllsky, string2, coord, d, string5))));
            this.plan[n] = planBG;
        } else {
            planBG = string != null ? new PlanBG(this.aladin, string, string2, coord, d, string5) : new PlanBG(this.aladin, uRL, string2, coord, d, string5);
            this.plan[n] = planBG;
        }
        n = this.bestPlace(n);
        this.suiteNew(planBG);
        return n;
    }

    protected int newPlan(String string, String string2, String string3, Obj obj) {
        return ((ServerFile)this.aladin.dialog.localServer).creatLocalPlane(string, string2, string3, obj, null, null, null, null, null);
    }

    protected Plan createPlan(String string, String string2, String string3, Server server) {
        int n = ((ServerFile)this.aladin.dialog.localServer).creatLocalPlane(string, string2, string3, null, null, null, server, null, null);
        return this.plan[n];
    }

    protected int newPlan(String string, String string2, String string3) {
        return this.newPlan(string, string2, string3, null, null);
    }

    protected int newPlan(String string, String string2, String string3, String string4, String string5) {
        return ((ServerFile)this.aladin.dialog.localServer).creatLocalPlane(string, string2, string3, null, null, null, null, string4, string5);
    }

    protected int newPlan(InputStream inputStream, String string, String string2) {
        return ((ServerFile)this.aladin.dialog.localServer).creatLocalPlane(null, string, string2, null, null, inputStream, null, null, null);
    }

    protected Plan createPlan(InputStream inputStream, String string, String string2) throws Exception {
        int n = ((ServerFile)this.aladin.dialog.localServer).creatLocalPlane(null, string, string2, null, null, inputStream, null, null, null);
        if (n == -2) {
            return null;
        }
        if (n < 0) {
            throw new Exception("plane creation error");
        }
        return this.plan[n];
    }

    protected void suiteNew(Plan plan) {
        if (plan == null) {
            return;
        }
        this.aladin.view.adjustViews(plan);
        this.select.repaint();
        this.aladin.toolBox.toolMode();
    }

    protected boolean noSelected() {
        Plan[] planArray = this.getPlans();
        for (int i = 0; i < planArray.length; ++i) {
            if (!planArray[i].selected) continue;
            return false;
        }
        return true;
    }

    private void permute(int n, int n2, int n3) {
        int n4;
        int n5 = n4 = n < n2 ? 1 : -1;
        if (n4 == -1) {
            ++n2;
        }
        for (int i = 0; i < n3; ++i) {
            int n6;
            int n7 = n4 == -1 ? n2 + i : n2;
            Plan plan = this.plan[n6];
            for (n6 = n4 == -1 ? n + i : n; n6 != n7; n6 += n4) {
                this.plan[n6] = this.plan[n6 + n4];
            }
            this.plan[n7] = plan;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void permute(Plan plan, Plan plan2) {
        int n = 0;
        int n2 = 0;
        int n3 = 1;
        int n4 = 0;
        boolean bl = this.isCollapsed(plan2) || plan2.collapse;
        n4 = plan2.folder;
        if (plan2.type == 11) {
            ++n4;
        }
        Object object = this.pile;
        synchronized (object) {
            int n5;
            Plan[] planArray;
            if (plan.type == 11) {
                planArray = this.getFolderPlan(plan);
                int n6 = n4 - plan.folder;
                plan.folder += n6;
                for (n5 = 0; n5 < planArray.length; ++n5) {
                    planArray[n5].folder += n6;
                }
                n3 = planArray.length + 1;
            } else {
                plan.folder = n4;
            }
            for (n5 = 0; n5 < this.plan.length; ++n5) {
                if (plan == this.plan[n5]) {
                    n = n5;
                    continue;
                }
                if (plan2 != this.plan[n5]) continue;
                n2 = n5;
            }
            this.permute(n, n2, n3);
            if (bl) {
                planArray = this.getFolderPlan(this.getFolder(plan2));
                for (n5 = 0; n5 < planArray.length; ++n5) {
                    planArray[n5].collapse = false;
                }
            }
        }
        if (plan.isCatalog()) {
            PlanFilter.updatePlan(plan, n, n2);
            return;
        }
        if (plan2.isCatalog()) {
            PlanFilter.updatePlan(plan2, n2, n);
            return;
        }
        if (plan.type == 12) {
            ((PlanFilter)plan).positionChange();
        }
        if (plan2.type == 12) {
            ((PlanFilter)plan2).positionChange();
        }
    }

    protected Plan getFirstCatalog() {
        for (int i = 0; i < this.plan.length; ++i) {
            if (!this.plan[i].isReady() || !this.plan[i].isSimpleCatalog()) continue;
            return this.plan[i];
        }
        return null;
    }

    protected int getFirstSelected() {
        for (int i = 0; i < this.plan.length; ++i) {
            if (!this.plan[i].selected) continue;
            return i;
        }
        return -1;
    }

    protected Plan getFirstSelectedPlan() {
        int n = this.getFirstSelected();
        if (n < 0) {
            return null;
        }
        return this.plan[n];
    }

    protected PlanCatalog getFirstSelectedPlanCatalog() {
        for (int i = 0; i < this.plan.length; ++i) {
            if (!this.plan[i].selected || !this.plan[i].isSimpleCatalog()) continue;
            return (PlanCatalog)this.plan[i];
        }
        return null;
    }

    protected PlanImage getFirstSelectedPlanImage() {
        for (int i = 0; i < this.plan.length; ++i) {
            if (!this.plan[i].selected || !this.plan[i].isImage() && this.plan[i].type != 16) continue;
            if (this.plan[i] instanceof PlanMultiCCD) {
                return ((PlanMultiCCD)this.plan[i]).getSelectedCCD();
            }
            return (PlanImage)this.plan[i];
        }
        return null;
    }

    protected PlanImage getFirstSelectedSimpleImage() {
        for (int i = 0; i < this.plan.length; ++i) {
            if (!this.plan[i].selected || !this.plan[i].isImage()) continue;
            return (PlanImage)this.plan[i];
        }
        return null;
    }

    protected PlanImage getFirstSelectedImage() {
        for (int i = 0; i < this.plan.length; ++i) {
            if (!this.plan[i].selected || !this.plan[i].isPixel()) continue;
            return (PlanImage)this.plan[i];
        }
        return null;
    }

    protected int getLastSelected() {
        for (int i = this.plan.length - 1; i >= 0; --i) {
            if (!this.plan[i].selected) continue;
            return i;
        }
        return -1;
    }

    protected Vector getSelectedPlanes() {
        Vector<Plan> vector = new Vector<Plan>(10);
        Plan[] planArray = this.getPlans();
        for (int i = 0; i < planArray.length; ++i) {
            if (!planArray[i].selected) continue;
            vector.addElement(planArray[i]);
        }
        return vector;
    }

    protected Vector getSelectedSimpleImage() {
        Vector<Plan> vector = new Vector<Plan>(10);
        Plan[] planArray = this.getPlans();
        for (int i = 0; i < planArray.length; ++i) {
            if (!planArray[i].flagOk || !planArray[i].selected || !planArray[i].isSimpleImage()) continue;
            vector.addElement(planArray[i]);
        }
        return vector;
    }

    protected Vector getSelectedImagesWithPixels() {
        Vector<Plan> vector = new Vector<Plan>(10);
        Plan[] planArray = this.getPlans();
        for (int i = 0; i < planArray.length; ++i) {
            if (!planArray[i].flagOk || !planArray[i].selected || !planArray[i].hasAvailablePixels()) continue;
            vector.addElement(planArray[i]);
        }
        return vector;
    }

    protected void setOpacityLevelImage(float f) {
        Plan[] planArray = this.getPlans();
        for (int i = 0; i < planArray.length; ++i) {
            Plan plan = planArray[i];
            if (!plan.flagOk || !plan.isSimpleImage()) continue;
            plan.setOpacityLevel(f);
        }
    }

    protected void setOpacityLevel(float f) {
        Plan[] planArray = this.getPlans();
        for (int i = 0; i < planArray.length; ++i) {
            Plan plan = planArray[i];
            if (!plan.flagOk || !plan.selected || !plan.hasCanBeTranspState()) continue;
            plan.setOpacityLevel(f);
            if (!((double)f >= 0.1)) continue;
            plan.setActivated(true);
        }
    }

    protected void setScalingFactor(float f) {
        Plan[] planArray = this.getPlans();
        for (int i = 0; i < planArray.length; ++i) {
            Plan plan = planArray[i];
            if (!plan.flagOk || !plan.selected) continue;
            plan.setScalingFactor(f);
        }
    }

    protected boolean mustBeSetPlanRef(Plan plan) {
        boolean bl = false;
        ViewSimple viewSimple = this.aladin.view.viewSimple[this.aladin.view.getLastNumView(plan)];
        String string = null;
        if (this.aladin.calque.isFreeX(plan)) {
            bl = true;
            string = "Stack Vide";
        } else if (plan.isOldPlan) {
            bl = false;
            string = "Flag IsOldPlan=true";
        } else if (viewSimple.isFree() && !plan.isOverlay()) {
            bl = true;
            string = "Image dans la prochaine view vide";
        } else if (viewSimple.pref != null && viewSimple.pref.isImage() && plan.isImage()) {
            bl = true;
            string = "Image sur image";
        } else if (viewSimple.pref != null && viewSimple.pref.isSimpleCatalog() && (plan.isImage() || plan instanceof PlanBG)) {
            bl = true;
            string = "Image ou Allsky sur catalogue";
        } else if (viewSimple.pref != null && !(viewSimple.pref instanceof PlanBG) && plan.isSimpleCatalog() && !plan.isViewable()) {
            bl = true;
            string = "Catalogue non visible autrement";
        } else if (this.aladin.view.isMultiView() && plan.isImage()) {
            bl = true;
            string = "Image sur multivue";
        }
        Aladin.trace(4, "Calque.mustBeSetPlanRef(" + plan.label + ") => " + bl + (string != null ? " (" + string + ")" : ""));
        return bl;
    }

    protected boolean canBeTransparent(Plan plan) {
        Object object;
        boolean bl;
        boolean bl2 = bl = plan != null && plan.isRefForVisibleView();
        if (plan == null || plan.type == 12 || !this.isFree() && bl && !plan.isOverlay()) {
            if (plan != null) {
                plan.setDebugFlag(2, false);
            }
            return false;
        }
        if (plan.isOverlay()) {
            plan.setDebugFlag(2, true);
            return true;
        }
        if ((plan.isImage() || plan.type == 16) && !this.aladin.configuration.isTransparent()) {
            return false;
        }
        if (plan.type == 16 && !bl && plan.flagOk && !plan.isUnderImg()) {
            plan.setDebugFlag(2, true);
            return true;
        }
        boolean bl3 = true;
        if (plan instanceof PlanFolder) {
            bl3 = false;
            for (Plan plan2 : object = this.getFolderPlan(plan)) {
                if (!this.canBeTransparent(plan2)) continue;
                bl3 = true;
                break;
            }
        }
        if (bl3) {
            plan.setDebugFlag(2, true);
            return true;
        }
        if (!plan.flagOk || !bl3 || !Projection.isOk(plan.projd) || plan.isRefForVisibleView() || plan.isImage() && plan.projd.isLargeField()) {
            plan.setDebugFlag(2, false);
            return false;
        }
        object = this.aladin.view.getCurrentView();
        Plan[] planArray = this.getPlans();
        int n = 1;
        for (int i = 0; i < planArray.length; ++i) {
            if (n != 0) {
                if (planArray[i] != plan) continue;
                n = 0;
                continue;
            }
            if (!planArray[i].isRefForVisibleView() || !Projection.isOk(planArray[i].projd) || !planArray[i].projd.agree(plan.projd, (ViewSimple)object)) continue;
            plan.setDebugFlag(2, true);
            return true;
        }
        plan.setDebugFlag(2, false);
        return false;
    }

    protected void addOnStack(Plan plan) {
        int n = this.aladin.calque.getStackIndex();
        this.aladin.calque.plan[n] = plan;
    }

    private int getStackIndex() {
        return this.getStackIndex(null, 1);
    }

    private int getStackIndex(String string) {
        return this.getStackIndex(string, 1);
    }

    private int getStackIndex(String string, int n) {
        int n2;
        if (!Calque.isNewPlan(string)) {
            int n3;
            if (string.charAt(1) == '@') {
                try {
                    n3 = Integer.parseInt(string.substring(2));
                }
                catch (Exception exception) {
                    n3 = -1;
                }
                n3 = this.plan.length - n3;
            } else {
                n3 = this.getIndexPlan(string.substring(1), 1);
            }
            if (n3 >= 0) {
                if (this.plan[n3].isCatalog()) {
                    this.aladin.view.deSelect(this.plan[n3]);
                }
                return n3;
            }
        }
        for (n2 = 0; n2 < this.plan.length && this.plan[n2].type == 0; ++n2) {
        }
        if (n2 <= n) {
            this.reallocPlan();
            return this.getStackIndex(null, n);
        }
        return --n2;
    }

    public void repaintAll() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.repaintAll1();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Calque.this.repaintAll1();
                }
            });
        }
    }

    private void repaintAll1() {
        if (this.select != null) {
            this.select.repaint();
            this.zoom.zoomSliderReset();
            this.zoom.zoomView.repaint();
            this.aladin.view.repaintAll();
            this.aladin.toolBox.toolMode();
        }
    }

    public void updateFootprintOpacity(float f, float f2) {
        for (int i = 0; i < this.plan.length; ++i) {
            if (!Aladin.isFootprintPlane(this.plan[i]) || this.plan[i].getOpacityLevel() != f) continue;
            this.plan[i].setOpacityLevel(f2);
        }
    }
}

