/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.FrameColorMap;
import cds.aladin.PlanBG;
import cds.aladin.PlanImage;
import cds.tools.Util;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JPanel;

public final class CanvasPixelRange
extends JPanel
implements MouseMotionListener,
MouseListener {
    private static final int MX = 5;
    private static final int MY = 5;
    private static final int MINIMUM_HEIGHT = 65;
    private static final int H_HAMPE = 3;
    private static final int COLORMAP_POSX_CUTMIN = 39;
    private static final int COLORMAP_POSX_CUTMAX = 295;
    private FrameColorMap frameColorMap;
    private Color BKGD = null;
    private PlanImage pimg;
    private boolean isFullDynamic;
    private boolean isFitsHiPS;
    private int width;
    private int height;
    private Rectangle rectRange;
    private Rectangle rectVisible;
    private double sizeOnePixel;
    private double pixelRangeMin;
    private double pixelRangeMax;
    private double pixelCutMin;
    private double pixelCutMax;
    private int xStart = -1;
    private int xMove;
    private int mode = 0;
    private static final int IN = 1;
    private static final int LEFT = 2;
    private static final int RIGHT = 3;
    private int oM = -1;

    protected CanvasPixelRange(FrameColorMap frameColorMap, PlanImage planImage) {
        this.frameColorMap = frameColorMap;
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        this.pimg = planImage;
        this.BKGD = planImage.aladin.frameCM.getBackground();
        this.rectRange = new Rectangle();
        this.rectVisible = new Rectangle();
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        return new Dimension(dimension.width, 65);
    }

    protected void resume() {
        double d;
        this.width = this.getWidth();
        this.height = this.getHeight();
        if (this.pimg == null) {
            return;
        }
        this.isFullDynamic = this.pimg.hasAvailablePixels();
        this.isFitsHiPS = this.pimg instanceof PlanBG && ((PlanBG)this.pimg).isTruePixels();
        this.rectRange.x = 5;
        this.rectRange.y = 20;
        this.rectRange.width = this.width - 10;
        this.rectRange.height = 17;
        if (this.isFitsHiPS) {
            this.rectRange.x += 20;
            this.rectRange.width -= 40;
        }
        if (this.isFullDynamic) {
            this.pixelRangeMin = this.pimg.dataMin * this.pimg.bScale + this.pimg.bZero;
            this.pixelRangeMax = this.pimg.dataMax * this.pimg.bScale + this.pimg.bZero;
            this.pixelCutMin = this.pimg.pixelMin * this.pimg.bScale + this.pimg.bZero;
            this.pixelCutMax = this.pimg.pixelMax * this.pimg.bScale + this.pimg.bZero;
            if (this.pixelCutMin < this.pixelRangeMin) {
                this.pixelRangeMin = this.pixelCutMin;
            }
            if (this.pixelCutMax > this.pixelRangeMax) {
                this.pixelRangeMax = this.pixelCutMax;
            }
        } else {
            this.pixelRangeMax = 0.0;
            this.pixelRangeMin = 0.0;
            this.pixelCutMin = this.rectRange.width / 4;
            this.pixelCutMax = 2 * this.rectRange.width / 3;
        }
        this.sizeOnePixel = (d = this.pixelRangeMax - this.pixelRangeMin) <= 0.0 ? 1.0 : (double)this.rectRange.width / d;
        this.rectVisible.x = (int)((double)this.rectRange.x + (this.pixelCutMin - this.pixelRangeMin) * this.sizeOnePixel);
        this.rectVisible.y = this.rectRange.y + 1;
        this.rectVisible.width = (int)((this.pixelCutMax - this.pixelCutMin) * this.sizeOnePixel);
        this.rectVisible.height = this.rectRange.height - 2;
        if (this.mode != 0) {
            int n = this.xMove - this.xStart;
            switch (this.mode) {
                case 1: {
                    this.rectVisible.x += n;
                    break;
                }
                case 2: {
                    this.rectVisible.x += n;
                    this.rectVisible.width -= n;
                    break;
                }
                case 3: {
                    this.rectVisible.width += n;
                }
            }
        }
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        int n;
        int n2;
        int n3;
        super.paintComponent(graphics);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        this.resume();
        graphics.setColor(this.BKGD);
        graphics.fillRect(0, 0, this.width, this.height);
        if (this.pimg == null) {
            return;
        }
        graphics.setColor(this.frameColorMap.cm.getColor(0));
        graphics.fillRect(this.rectRange.x, this.rectRange.y, this.rectVisible.x - this.rectRange.x, this.rectRange.height);
        graphics.setColor(this.frameColorMap.cm.getColor(255));
        graphics.fillRect(this.rectVisible.x + this.rectVisible.width, this.rectRange.y, this.rectRange.x + this.rectRange.width - this.rectVisible.x - this.rectVisible.width, this.rectRange.height);
        graphics.setColor(this.pimg.hasAvailablePixels() ? Color.cyan : Color.lightGray);
        graphics.fillRect(this.rectVisible.x, this.rectVisible.y, this.rectVisible.width, this.rectVisible.height);
        graphics.drawRect(this.rectVisible.x, this.rectVisible.y, this.rectVisible.width, this.rectVisible.height);
        graphics.setColor(Color.black);
        graphics.drawRect(this.rectRange.x, this.rectRange.y, this.rectRange.width, this.rectRange.height);
        if (this.isFitsHiPS) {
            n3 = this.rectRange.y + this.rectRange.height / 2;
            n2 = this.rectRange.x - 5;
            for (n = 0; n < 3; ++n) {
                Util.fillCircle2(graphics, n2 - n * 5, n3);
            }
            n2 = this.rectRange.x + this.rectRange.width + 3;
            for (n = 0; n < 3; ++n) {
                Util.fillCircle2(graphics, n2 + n * 5, n3);
            }
        }
        graphics.setColor(Color.lightGray);
        n = this.rectVisible.x;
        int n4 = this.rectVisible.y + this.rectVisible.height + 3;
        graphics.drawLine(n, n4, n, n4 + 3);
        graphics.drawLine(n, n4 + 3, 39, this.height - 3);
        graphics.drawLine(39, this.height - 3, 39, this.height);
        n = this.rectVisible.x + this.rectVisible.width;
        n4 = this.rectVisible.y + this.rectVisible.height + 3;
        graphics.drawLine(n, n4, n, n4 + 3);
        graphics.drawLine(n, n4 + 3, 295, this.height - 3);
        graphics.drawLine(295, this.height - 3, 295, this.height);
        graphics.setColor(Color.black);
        n3 = this.rectRange.y - 2;
        String string = !this.isFullDynamic ? "???" : Util.myRound(this.pixelRangeMin);
        graphics.drawString(string, this.rectRange.x, n3);
        string = !this.isFullDynamic ? "???" : Util.myRound(this.pixelRangeMax);
        int n5 = fontMetrics.stringWidth(string);
        graphics.drawString(string, this.rectRange.x + this.rectRange.width + 2 - n5, n3);
        graphics.setColor(Aladin.MYBLUE);
        string = this.isFullDynamic ? this.frameColorMap.CMRANGE : this.frameColorMap.CMRANGE1;
        n5 = fontMetrics.stringWidth(string);
        n2 = this.rectRange.x + this.rectRange.width / 2 - n5 / 2;
        n3 = this.rectRange.y - 3;
        graphics.drawString(string, n2, n3);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        this.mode = this.getMode(n, n2);
        if (this.mode != 0) {
            this.xStart = n;
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (!this.pimg.hasAvailablePixels()) {
            return;
        }
        this.xMove = mouseEvent.getX();
        this.resume();
        double d = this.pixelRangeMin + (double)(this.rectVisible.x - this.rectRange.x) / this.sizeOnePixel;
        double d2 = d + (double)this.rectVisible.width / this.sizeOnePixel;
        this.frameColorMap.setMinMax(d, d2, true);
        this.xStart = -1;
        this.mode = 0;
        this.repaint();
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (!this.pimg.hasAvailablePixels()) {
            return;
        }
        this.xMove = mouseEvent.getX();
        this.resume();
        double d = this.pixelRangeMin + (double)this.rectVisible.x / this.sizeOnePixel;
        double d2 = (double)(this.rectVisible.x + this.rectVisible.width) / this.sizeOnePixel;
        this.frameColorMap.setMinMax(d, d2, false);
        this.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        int n = this.getMode(mouseEvent.getX(), mouseEvent.getY());
        if (this.oM == n || n == 0) {
            return;
        }
        switch (n) {
            case 1: {
                this.setCursor(Cursor.getPredefinedCursor(13));
                break;
            }
            case 2: {
                this.setCursor(Cursor.getPredefinedCursor(11));
                break;
            }
            case 3: {
                this.setCursor(Cursor.getPredefinedCursor(10));
                break;
            }
            default: {
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
        this.oM = n;
    }

    private int getMode(int n, int n2) {
        if (!this.pimg.hasAvailablePixels()) {
            return 0;
        }
        int n3 = 0;
        if (n2 > this.rectVisible.y && n2 < this.rectVisible.y + this.rectVisible.height) {
            if (Math.abs(n - this.rectVisible.x) < 4) {
                n3 = 2;
            } else if (Math.abs(n - (this.rectVisible.x + this.rectVisible.width)) < 4) {
                n3 = 3;
            } else if (this.rectVisible.contains(n, n2)) {
                n3 = 1;
            }
        }
        return n3;
    }
}

