/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Coord;
import cds.aladin.Forme;
import cds.aladin.Plan;
import cds.aladin.PointD;
import cds.aladin.Position;
import cds.aladin.RectangleD;
import cds.aladin.ViewSimple;
import cds.tools.Util;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Ellipse2D;

public class Cercle
extends Forme {
    protected Cercle(Plan plan, ViewSimple viewSimple, double d, double d2, double d3) {
        super(plan, new Position[2]);
        this.o[0] = new Position(plan, viewSimple, d, d2, 0.0, 0.0, 5, null);
        this.o[1] = new Position(plan, viewSimple, d, d2 + d3, 0.0, 0.0, 5, null);
        this.setObjet(this.o);
    }

    protected Cercle(Plan plan, Coord coord, double d) {
        super(plan, new Position[2]);
        this.o[0] = new Position(plan, null, 0.0, 0.0, coord.al, coord.del, 2, null);
        double d2 = coord.del + d;
        if (d2 > 90.0) {
            d2 = coord.del - d;
        }
        this.o[1] = new Position(plan, null, 0.0, 0.0, coord.al, d2, 2, null);
        this.setObjet(this.o);
    }

    protected Cercle(Plan plan, Position[] positionArray) {
        super(plan, positionArray);
    }

    @Override
    public String getObjType() {
        return "Circle";
    }

    protected double getRayon(ViewSimple viewSimple) {
        double d = this.o[1].yv[viewSimple.n] - this.o[0].yv[viewSimple.n];
        double d2 = this.o[1].xv[viewSimple.n] - this.o[0].xv[viewSimple.n];
        return Math.sqrt(d2 * d2 + d * d);
    }

    @Override
    public double getRadius() {
        Coord coord = new Coord(this.o[0].raj, this.o[0].dej);
        Coord coord2 = new Coord(this.o[1].raj, this.o[1].dej);
        return Coord.getDist(coord, coord2);
    }

    @Override
    protected boolean inside(ViewSimple viewSimple, double d, double d2) {
        double d3;
        if (!this.isVisible()) {
            return false;
        }
        double d4 = Math.abs(d - this.o[0].xv[viewSimple.n]);
        return Math.sqrt(d4 * d4 + (d3 = Math.abs(d2 - this.o[0].yv[viewSimple.n])) * d3) < this.getRayon(viewSimple);
    }

    @Override
    protected boolean in(ViewSimple viewSimple, double d, double d2) {
        if (!this.isVisible()) {
            return false;
        }
        PointD pointD = viewSimple.getViewCoordDble(this.o[0].xv[viewSimple.n], this.o[0].yv[viewSimple.n]);
        PointD pointD2 = viewSimple.getViewCoordDble(d, d2);
        return Cercle.inPerimetre(pointD.x, pointD.y, this.getRayon(viewSimple) * viewSimple.zoom, pointD2.x, pointD2.y, this.mouseDist(viewSimple));
    }

    protected static boolean inPerimetre(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7;
        return (d7 = Math.abs(Math.sqrt((d4 -= d) * d4 + (d5 -= d2) * d5) - d3)) < d6;
    }

    @Override
    protected boolean inRectangle(ViewSimple viewSimple, RectangleD rectangleD) {
        return this.o[0].inRectangle(viewSimple, rectangleD);
    }

    @Override
    protected boolean inClip(ViewSimple viewSimple, Rectangle rectangle) {
        boolean bl = super.inClip(viewSimple, rectangle);
        return bl;
    }

    @Override
    protected Rectangle extendClip(ViewSimple viewSimple, Rectangle rectangle) {
        if (!this.isVisible()) {
            return rectangle;
        }
        int n = (int)Math.round(this.getRayon(viewSimple) * viewSimple.getZoom()) + 1;
        Point point = this.o[0].getViewCoord(viewSimple, n, n);
        if (point == null) {
            return rectangle;
        }
        if (this.isSelected()) {
            return Cercle.unionRect(rectangle, point.x - n - 2, point.y - n - 2, n * 2 + 4, n * 2 + 4);
        }
        return Cercle.unionRect(rectangle, point.x - n, point.y - n, n * 2, n * 2);
    }

    @Override
    protected void drawSelect(Graphics graphics, ViewSimple viewSimple) {
        Rectangle rectangle = this.getClip(viewSimple);
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < 4; ++i) {
            switch (i) {
                case 0: {
                    n = rectangle.x + rectangle.width / 2 - 4;
                    n2 = rectangle.y;
                    break;
                }
                case 1: {
                    n = rectangle.x + rectangle.width / 2 - 4;
                    n2 = rectangle.y + rectangle.height - 4;
                    break;
                }
                case 2: {
                    n = rectangle.x + rectangle.width - 4;
                    n2 = rectangle.y + rectangle.height / 2 - 4;
                    break;
                }
                case 3: {
                    n = rectangle.x;
                    n2 = rectangle.y + rectangle.height / 2 - 4;
                }
            }
            graphics.setColor(Color.green);
            graphics.fillRect(n + 1, n2 + 1, 4, 4);
            graphics.setColor(Color.black);
            graphics.drawRect(n, n2, 4, 4);
        }
    }

    @Override
    protected boolean draw(Graphics graphics, ViewSimple viewSimple, int n, int n2) {
        if (!this.isVisible()) {
            return false;
        }
        int n3 = (int)Math.round(this.getRayon(viewSimple) * viewSimple.getZoom());
        Point point = this.o[0].getViewCoord(viewSimple, n3, n3);
        if (point == null) {
            return false;
        }
        point.x += n;
        point.y += n2;
        graphics.setColor(this.getColor());
        if (this.plan != null && (double)this.plan.getOpacityLevel() > 0.02 && Aladin.isFootprintPlane(this.plan) && Aladin.ENABLE_FOOTPRINT_OPACITY && graphics instanceof Graphics2D) {
            Composite composite = null;
            Graphics2D graphics2D = (Graphics2D)graphics;
            composite = graphics2D.getComposite();
            Composite composite2 = Util.getFootprintComposite(this.plan.getOpacityLevel());
            graphics2D.setComposite(composite2);
            graphics2D.fill(new Ellipse2D.Double(point.x - n3, point.y - n3, n3 * 2, n3 * 2));
            graphics2D.setComposite(composite);
        }
        graphics.drawOval(point.x - n3, point.y - n3, n3 * 2, n3 * 2);
        if (this.isSelected()) {
            if (this.plan != null && this.plan.type == 10) {
                return true;
            }
            graphics.setColor(Color.green);
            this.drawSelect(graphics, viewSimple);
        }
        return true;
    }
}

