/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.FrameHeaderFits;
import cds.aladin.FrameInfo;
import cds.aladin.MyInputStream;
import cds.aladin.Pcat;
import cds.aladin.Plan;
import cds.aladin.PlanImage;
import cds.aladin.ServerSkybot;
import cds.tools.Util;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class Chaine {
    private static String STRINGFILE = "Aladin.string";
    private static String STRINGFILE0 = "Aladin0.string";
    private boolean flagAll = false;
    protected static Hashtable map;
    private Aladin aladin;
    private String lastFileName = null;
    private ArrayList defList = null;
    private boolean loadDefList = false;
    private static SimpleAttributeSet atKey;
    private static SimpleAttributeSet atValue;
    private static SimpleAttributeSet atLang;
    private static SimpleAttributeSet atCom;
    private static SimpleAttributeSet atHist;
    private static SimpleAttributeSet atYellow;
    private static SimpleAttributeSet atWhite;
    private boolean first = true;
    private JButton clear;
    private JFrame frame;
    private DefaultStyledDocument df;
    JTextPane ta;
    JTextField ts;

    Chaine(Aladin aladin) {
        this.aladin = aladin;
        if (map == null) {
            map = new Hashtable(4000);
            this.loadDefList = true;
            this.defList = new ArrayList(1500);
            this.loadFile(STRINGFILE0);
            this.loadDefList = false;
            this.loadAddFiles();
        }
        this.createChaine();
    }

    protected void createChaine() {
        Pcat.createChaine(this);
        Plan.createChaine(this);
        FrameInfo.createChaine(this);
        PlanImage.createChaine(this);
        ServerSkybot.createChaine(this);
        FrameHeaderFits.createChaine(this);
    }

    private static String replaceNL(String string) {
        char[] cArray = string.toCharArray();
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        while (n < cArray.length) {
            int n3 = cArray[n];
            if (bl && n3 == 110) {
                --n2;
                n3 = 10;
            }
            boolean bl2 = bl = n3 == 92;
            if (n != n2) {
                cArray[n2] = n3;
            }
            ++n;
            ++n2;
        }
        return n == n2 ? string : new String(cArray, 0, n2);
    }

    private static String reverseNL(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n + 10);
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '\n') {
                stringBuffer.append('\\');
                stringBuffer.append('n');
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadFile(String string) {
        Closeable closeable;
        long l = System.currentTimeMillis();
        MyInputStream myInputStream = null;
        try {
            closeable = this.getClass().getResourceAsStream("/" + string);
            if (closeable == null) {
                throw new Exception();
            }
            myInputStream = new MyInputStream((InputStream)closeable);
            myInputStream = myInputStream.startRead();
        }
        catch (Exception exception) {
            try {
                FileInputStream fileInputStream = new FileInputStream(new File(string));
                if (fileInputStream == null) {
                    throw new Exception();
                }
                myInputStream = new MyInputStream(fileInputStream);
            }
            catch (Exception exception2) {
                try {
                    String string2 = Aladin.aladin.getCodeBase() + string;
                    myInputStream = Util.openStream(string2);
                }
                catch (Exception exception3) {
                    exception2.printStackTrace();
                    exception3.printStackTrace();
                    return;
                }
            }
        }
        closeable = null;
        try {
            closeable = string.indexOf(".utf") >= 0 ? new BufferedReader(new InputStreamReader((InputStream)myInputStream, "UTF8")) : new BufferedReader(new InputStreamReader((InputStream)myInputStream, "iso-8859-1"));
            this.parseStringFile((BufferedReader)closeable);
            Aladin.trace(1, "String file " + string + " loaded (" + (System.currentTimeMillis() - l) + "ms)");
        }
        catch (Exception exception) {
            if (Aladin.levelTrace >= 3) {
                exception.printStackTrace();
            }
            Aladin.trace(1, "Could not load strings file " + string);
            return;
        }
        finally {
            if (closeable != null) {
                try {
                    ((BufferedReader)closeable).close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private static int getStringIndex(String string) {
        int n;
        int n2 = string.length();
        for (n = 0; n < n2 && !Character.isSpace(string.charAt(n)); ++n) {
        }
        while (n < n2 && Character.isSpace(string.charAt(n))) {
            ++n;
        }
        return n > 0 && n < n2 ? n : -1;
    }

    private void parseStringFile(BufferedReader bufferedReader) throws IOException {
        String string;
        while ((string = bufferedReader.readLine()) != null) {
            int n;
            if (string.trim().length() > 0 && string.charAt(0) == '#' || (n = Chaine.getStringIndex(string)) < 0) continue;
            String string2 = string.substring(0, n - 1).trim();
            String string3 = Chaine.replaceNL(string.substring(n));
            if (string2.equals("LANGUAGE")) {
                this.aladin.configuration.setLanguage(string3);
                continue;
            }
            if (string2.length() == 0) continue;
            map.put(string2, string3);
            if (!this.loadDefList || string2.indexOf(".") >= 0) continue;
            this.defList.add(string2);
        }
    }

    protected void testLanguage(String string) {
        String string2 = "";
        String string3 = null;
        if (string == null || string.trim().length() == 0) {
            string2 = this.aladin.configuration.getLang();
            if (string2.length() > 0) {
                string3 = this.aladin.configuration.getLanguage(string2.substring(1));
            }
        } else {
            try {
                int n = string.indexOf(32);
                if (n < 0) {
                    n = string.length();
                }
                string2 = (string2 = string.substring(0, n).trim()).length() == 2 ? "." + string2 : "";
                if (n != string.length()) {
                    string3 = string.substring(n).trim();
                }
            }
            catch (Exception exception) {
                string2 = "";
            }
        }
        if (string2.length() == 0) {
            Aladin.warning("Missing parameters !");
            return;
        }
        this.testLanguage(string2, string3);
    }

    private void search(String string) {
        int n;
        int n2;
        if (atKey == null) {
            atKey = new SimpleAttributeSet();
            atKey.addAttribute(StyleConstants.CharacterConstants.Foreground, Color.blue);
            atKey.addAttribute(StyleConstants.CharacterConstants.Background, Color.white);
            atValue = new SimpleAttributeSet();
            atValue.addAttribute(StyleConstants.CharacterConstants.Foreground, Color.black);
            atValue.addAttribute(StyleConstants.CharacterConstants.Background, Color.white);
            atCom = new SimpleAttributeSet();
            atCom.addAttribute(StyleConstants.CharacterConstants.Foreground, Aladin.GREEN);
            atCom.addAttribute(StyleConstants.CharacterConstants.Background, Color.white);
            atLang = new SimpleAttributeSet();
            atLang.addAttribute(StyleConstants.CharacterConstants.Foreground, new Color(127, 0, 85));
            atLang.addAttribute(StyleConstants.CharacterConstants.Background, Color.white);
            atHist = new SimpleAttributeSet();
            atHist.addAttribute(StyleConstants.CharacterConstants.Foreground, Color.red);
            atHist.addAttribute(StyleConstants.CharacterConstants.Background, Color.white);
            atWhite = new SimpleAttributeSet();
            atWhite.addAttribute(StyleConstants.CharacterConstants.Background, Color.white);
            atYellow = new SimpleAttributeSet();
            atYellow.addAttribute(StyleConstants.CharacterConstants.Background, Color.yellow);
        }
        String string2 = this.ta.getText();
        if (this.first) {
            this.first = false;
            n2 = 0;
            while ((n = string2.indexOf("\n", n2)) >= 0) {
                if (string2.charAt(n2) == '#') {
                    this.df.setCharacterAttributes(n2, n - n2, atCom, true);
                } else {
                    int n3 = string2.indexOf(32, n2 + 1);
                    if (string2.substring(n2, n3).equals("LANGUAGE")) {
                        this.df.setCharacterAttributes(n2, n - n2, atLang, true);
                    } else {
                        this.df.setCharacterAttributes(n2, n3 - n2, atKey, true);
                        if (string2.charAt(n3 + 1) == '[' && string2.charAt(n - 1) == ']') {
                            this.df.setCharacterAttributes(n3, n - n3, atHist, true);
                        } else {
                            this.df.setCharacterAttributes(n3, n - n3, atValue, true);
                        }
                    }
                }
                n2 = n + 1;
            }
        } else {
            this.df.setCharacterAttributes(0, string2.length() - 1, atWhite, false);
        }
        if (string.length() == 0) {
            this.clear.setEnabled(false);
            return;
        }
        this.clear.setEnabled(true);
        n = -1;
        n2 = -1;
        while ((n = string2.indexOf(string, n + 1)) >= 0) {
            this.df.setCharacterAttributes(n, string.length(), atYellow, false);
            if (n2 != -1) continue;
            n2 = n;
        }
        if (n2 != -1) {
            this.ta.setCaretPosition(n2);
        }
    }

    private JPanel makePanelTranslation() {
        JButton jButton;
        this.df = new DefaultStyledDocument();
        this.ta = new JTextPane(this.df);
        this.ta.setFont(Aladin.COURIER);
        JScrollPane jScrollPane = new JScrollPane(this.ta);
        jScrollPane.setPreferredSize(new Dimension(700, 800));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)jScrollPane, "Center");
        JPanel jPanel2 = new JPanel();
        this.ts = new JTextField(10);
        this.ts.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                String string = ((JTextField)keyEvent.getSource()).getText();
                Chaine.this.search(string);
            }
        });
        jPanel2.add(Aladin.createLabel("Search"));
        jPanel2.add(this.ts);
        this.clear = jButton = new JButton("Clear");
        jButton.setEnabled(false);
        jPanel2.add(jButton);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Chaine.this.ts.setText("");
                Chaine.this.search("");
            }
        });
        jPanel2.add(new JLabel(""));
        jButton = new JButton("Install");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Chaine.this.installTranslation();
            }
        });
        jPanel2.add(jButton);
        jButton = new JButton("Send to Aladin team...");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Chaine.this.aladin;
                    Aladin.info(Chaine.this.frame, "If you agree for submitting your translation file for an official distribution, please after installing and testing your work, attach the following file to a mail address to:\n \nEmail: language@aladin.u-strasbg.fr\nFile : " + Chaine.this.getTranslationFullName() + "\n \nPlease, do not forget to specify in this mail your name and quality\nThanks for your contribution !");
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        jPanel2.add(jButton);
        jButton = new JButton("Close");
        jPanel2.add(jButton);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Chaine.this.frame.dispose();
            }
        });
        jPanel.add((Component)jPanel2, "South");
        return jPanel;
    }

    private String getTranslationFullName() throws Exception {
        String string = this.ta.getText();
        int n = string.indexOf("\nLANGUAGE");
        String string2 = string.substring(n + 10, string.indexOf(40, n) - 1).trim();
        boolean bl = this.testUTF(string);
        String string3 = this.getTranslationFileName(string2, bl);
        String string4 = System.getProperty("user.home") + Util.FS + Aladin.CACHE;
        String string5 = string4 + Util.FS + string3;
        return string5;
    }

    private String getTranslationFileName(String string, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(50);
        char[] cArray = string.toCharArray();
        boolean bl2 = true;
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (Character.isSpaceChar(c)) {
                bl2 = true;
                continue;
            }
            c = bl2 ? Character.toUpperCase(c) : Character.toLowerCase(c);
            bl2 = false;
            stringBuffer.append(c);
        }
        return "Aladin-" + stringBuffer.toString() + "-" + "v9.033a".substring(1) + "-perso.string" + (bl ? ".utf" : "");
    }

    protected void testLanguage(String string, String string2) {
        if (this.defList == null) {
            return;
        }
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = true;
        if (string.length() > 0) {
            Object object2;
            String string3;
            this.frame = new JFrame("Translation");
            Aladin.setIcon(this.frame);
            StringBuffer stringBuffer = new StringBuffer(8000);
            this.frame.getContentPane().add(this.makePanelTranslation());
            if (string2 == null || string2.length() == 0) {
                string2 = "Unknown";
            }
            if ((string3 = this.aladin.configuration.getLanguageAuthor(string.substring(1))) == null) {
                string3 = "YourName";
            }
            stringBuffer.append("# TRANSLATION PROCEDURE:\n# 0) Complete LANGUAGE line if necessary [in purple] (language name + author name)\n# 1) Translate missing sentences [in red] (do not forget to remove the brackets);\n# 2) Remove translated sentences no longer required [in green]\n# 3) Check translated sentences already done [in black]\n# *) Do not modify keywords (first word of each line);\n#    Do not remove control characters (*,!,%) at the beginning of some words;\n# 4) Install your translation, restart Aladin and check the result\n\n");
            stringBuffer.append("\nLANGUAGE " + string2 + " (" + string.substring(1) + ") " + "v9.033a".substring(1) + " " + string3 + "\n");
            for (Object object2 : this.defList) {
                if (map.get((String)object2 + string) != null) continue;
                if (bl) {
                    bl = false;
                    stringBuffer.append("\n### MISSING TRANSLATION:\n");
                }
                stringBuffer.append((String)object2 + string + " [" + Chaine.reverseNL((String)map.get(object2)) + "]\n");
            }
            object2 = map.keys();
            while (object2.hasMoreElements()) {
                String string4;
                String string5 = (String)object2.nextElement();
                if (!string5.endsWith(string) || map.get(string4 = string5.substring(0, string5.lastIndexOf(string))) != null || string5.startsWith("Tool.")) continue;
                if (bl2) {
                    bl2 = false;
                    stringBuffer.append("\n### TRANSLATION NO LONGER REQUIRED:\n");
                }
                stringBuffer.append("#" + string5 + " " + Chaine.reverseNL((String)map.get(string5)) + "\n");
            }
            for (String string5 : this.defList) {
                if (map.get(string5 + string) == null) continue;
                if (bl3) {
                    bl3 = false;
                    stringBuffer.append("\n### TRANSLATION DONE:\n");
                }
                stringBuffer.append(string5 + string + " " + Chaine.reverseNL((String)map.get(string5 + string)) + "\n");
            }
            if (bl && bl2) {
                Aladin.info(this.frame, "The translation (" + string + ") seems complete!");
            }
            this.frame.pack();
            this.frame.setVisible(true);
            this.ta.setText(stringBuffer.toString());
            this.ta.setCaretPosition(0);
            this.first = true;
            new Thread("Translation"){

                @Override
                public void run() {
                    Util.pause(100);
                    Chaine.this.search("");
                }
            }.start();
        }
    }

    private boolean testUTF(String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if ((string.charAt(i) & 0xFF00) == 0) continue;
            return true;
        }
        return false;
    }

    private void installTranslation() {
        try {
            Object object;
            boolean bl = false;
            String string = "";
            String string2 = this.ta.getText();
            StringBuffer stringBuffer = new StringBuffer(8000);
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "\n");
            while (stringTokenizer.hasMoreTokens()) {
                int n;
                int n2;
                object = stringTokenizer.nextToken().trim();
                if (((String)object).length() == 0 || ((String)object).charAt(0) == '#' || (n2 = ((String)object).indexOf(32)) < 0 || ((String)object).charAt(n2 + 1) == '[' && ((String)object).charAt(((String)object).length() - 1) == ']') continue;
                stringBuffer.append((String)object + Util.CR);
                if (string.length() != 0 || !((String)object).startsWith("LANGUAGE") || (n = ((String)object).indexOf("(")) <= 8) continue;
                string = ((String)object).substring(8, n - 1).trim();
                stringBuffer.append(Util.CR);
            }
            bl = this.testUTF(string2);
            string2 = stringBuffer.toString();
            if (!bl) {
                object = string2.getBytes("ISO-8859-1");
            } else {
                object = string2.getBytes("UTF-8");
                byte[] byArray = new byte[((Object)object).length + 3];
                System.arraycopy(object, 0, byArray, 3, ((Object)object).length);
                byArray[0] = -17;
                byArray[1] = -69;
                byArray[2] = -65;
                object = byArray;
            }
            String string3 = this.getTranslationFileName(string, bl);
            this.aladin.configuration.installLanguage(string, string3, (byte[])object);
            Aladin.info(this.aladin, Aladin.chaine.getString("RESTART"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void loadAddFiles() {
        this.addAltFiles();
        if (Aladin.STRINGFILE == null) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(Aladin.STRINGFILE, ";");
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            this.loadFile(string);
        }
    }

    private void addAltFiles() {
        block4: {
            try {
                String string;
                int n;
                String string2 = System.getProperty("user.home") + Util.FS + Aladin.CACHE;
                FilenameFilter filenameFilter = new FilenameFilter(){

                    @Override
                    public boolean accept(File file, String string) {
                        return Util.matchMaskIgnoreCase("Aladin*.string*", string);
                    }
                };
                File file = new File(string2);
                File[] fileArray = file.listFiles(filenameFilter);
                for (n = 0; n < fileArray.length; ++n) {
                    string = fileArray[n].getName();
                    if (!string.endsWith("-perso.string.utf") && !string.endsWith("-perso.string")) continue;
                    Aladin.STRINGFILE = Aladin.STRINGFILE == null ? "" : ";" + Aladin.STRINGFILE;
                    Aladin.STRINGFILE = fileArray[n].getAbsolutePath() + Aladin.STRINGFILE;
                }
                for (n = 0; n < fileArray.length; ++n) {
                    string = fileArray[n].getName();
                    if (!string.endsWith(".utf") && !string.endsWith(".string") || string.endsWith("-perso.string.utf") || string.endsWith("-perso.string")) continue;
                    Aladin.STRINGFILE = Aladin.STRINGFILE == null ? "" : ";" + Aladin.STRINGFILE;
                    Aladin.STRINGFILE = fileArray[n].getAbsolutePath() + Aladin.STRINGFILE;
                }
            }
            catch (Exception exception) {
                if (Aladin.levelTrace < 3) break block4;
                exception.printStackTrace();
            }
        }
    }

    public String getString(String string) {
        String string2 = this.aladin.configuration.getLang();
        Object v = map.get(string + string2);
        if (v == null && !this.flagAll) {
            try {
                this.loadFile(STRINGFILE);
            }
            catch (Exception exception) {
                // empty catch block
            }
            v = map.get(string + string2);
            this.flagAll = true;
        }
        if (v == null && string2.length() > 0) {
            if (string.startsWith("TIP")) {
                return null;
            }
            v = map.get(string);
        }
        if (v == null) {
            if (string.startsWith("TIP")) {
                return null;
            }
            System.err.println("No default string for [" + string + "]");
            return "[" + string + "]";
        }
        return (String)v;
    }

    static {
        atKey = null;
    }
}

