/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Action;
import cds.aladin.Aladin;
import cds.aladin.FilterProperties;
import cds.aladin.Obj;
import cds.aladin.Plan;
import cds.aladin.Source;
import cds.aladin.UCDFilter;
import cds.savot.model.SavotField;
import cds.tools.parser.Parser;
import cds.tools.parser.ParserException;
import cds.xml.Field;
import java.util.Iterator;
import java.util.Vector;

public class ColumnCalculator {
    private SavotField[] fields;
    private String[] expr;
    private Plan p;
    private Expression[] parsers;
    private String error = "";
    private Aladin a;
    private int nbDec;

    protected ColumnCalculator(SavotField[] savotFieldArray, String[] stringArray, Plan plan, int n, Aladin aladin) {
        this(aladin);
        this.setFields(savotFieldArray);
        this.setExpr(stringArray);
        this.setPlan(plan);
        this.setNbDec(n);
    }

    protected ColumnCalculator(Aladin aladin) {
        this.a = aladin;
    }

    protected void setNbDec(int n) {
        this.nbDec = n;
    }

    protected void setFields(SavotField[] savotFieldArray) {
        this.fields = savotFieldArray;
    }

    protected void setExpr(String[] stringArray) {
        this.expr = stringArray;
        this.parsers = null;
    }

    protected void setPlan(Plan plan) {
        this.p = plan;
    }

    protected boolean createParser() {
        this.error = "";
        if (this.expr == null || this.fields == null || this.p == null) {
            this.error = "One of the parameters was null";
            return false;
        }
        int n = 0;
        this.parsers = new Expression[this.expr.length];
        try {
            for (n = 0; n < this.expr.length; ++n) {
                this.parsers[n] = new Expression(this.expr[n]);
                if (this.parsers[n].createParser()) continue;
                throw new ParserException();
            }
        }
        catch (ParserException parserException) {
            this.error = this.parsers[n].error;
            return false;
        }
        return true;
    }

    protected String getError() {
        return this.error;
    }

    protected boolean compute() {
        int n;
        if (this.parsers == null && !this.createParser()) {
            return false;
        }
        Source[] sourceArray = this.getSources();
        if (sourceArray == null) {
            return true;
        }
        Field[] fieldArray = new Field[this.fields.length];
        for (int i = 0; i < fieldArray.length; ++i) {
            fieldArray[i] = new Field(this.fields[i].getName());
            fieldArray[i].arraysize = this.fields[i].getArraySize();
            fieldArray[i].datatype = "D";
            fieldArray[i].description = this.fields[i].getDescription();
            fieldArray[i].ID = this.fields[i].getId();
            fieldArray[i].precision = this.fields[i].getPrecision();
            fieldArray[i].ucd = this.fields[i].getUcd();
            fieldArray[i].unit = this.fields[i].getUnit();
            fieldArray[i].width = "10";
            fieldArray[i].computeColumnSize();
        }
        for (n = 0; n < sourceArray.length; ++n) {
            Source source = sourceArray[n];
            for (int i = 0; i < this.parsers.length; ++i) {
                Expression expression = this.parsers[i];
                String string = expression.eval(source, this.nbDec);
                this.addCol(fieldArray[i], string, source);
            }
        }
        this.a.view.setMesure();
        FilterProperties.majFilterProp(false, true);
        for (n = 0; n < this.parsers.length; ++n) {
            this.a.log("newcolumn", "name=" + this.fields[n].getName() + " expr=" + this.expr[n] + " catplane=" + this.p.label);
        }
        return true;
    }

    private void addCol(Field field, String string, Source source) {
        if (source.leg.field[source.leg.field.length - 1] != field) {
            Field[] fieldArray = new Field[source.leg.field.length + 1];
            boolean[] blArray = new boolean[source.leg.computed.length + 1];
            System.arraycopy(source.leg.field, 0, fieldArray, 0, source.leg.field.length);
            System.arraycopy(source.leg.computed, 0, blArray, 0, source.leg.computed.length);
            fieldArray[source.leg.field.length] = field;
            blArray[source.leg.computed.length] = true;
            source.leg.field = fieldArray;
            source.leg.computed = blArray;
        }
        source.info = new String(source.info + "\t" + string);
        source.fixInfo();
    }

    private Source[] getSources() {
        Object[] objectArray;
        Vector<Source> vector = new Vector<Source>();
        Iterator<Obj> iterator = this.p.iterator();
        while (iterator.hasNext()) {
            Source source;
            objectArray = iterator.next();
            if (!(objectArray instanceof Source) || (source = (Source)objectArray) == null) continue;
            vector.addElement(source);
        }
        objectArray = new Source[vector.size()];
        vector.copyInto(objectArray);
        vector = null;
        return objectArray;
    }

    public static double round(double d, int n) {
        if (d == Double.NEGATIVE_INFINITY || d == Double.POSITIVE_INFINITY) {
            return d;
        }
        double d2 = Math.pow(10.0, n);
        return (double)Math.round(d * d2) / d2;
    }

    public static String format(double d, int n) {
        String string = Double.toString(d);
        int n2 = string.indexOf(".");
        if (n2 >= 0) {
            int n3;
            int n4 = string.indexOf("E");
            int n5 = n3 = string.length() > n2 + n + 1 ? n2 + n + 1 : string.length();
            if (n4 >= 0) {
                n3 = n4 > n3 ? n3 : n4;
            }
            String string2 = new String(string);
            string = string.substring(0, n3);
            if (n4 >= 0) {
                string = string + string2.substring(n4);
            }
        }
        return string;
    }

    class Expression {
        String error = "";
        String s;
        UCDFilter condFilter;
        boolean conditional = false;
        Parser parser1;
        Parser parser2;

        Expression(String string) {
            this.s = string;
        }

        boolean createParser() {
            int n = this.s.indexOf(63);
            int n2 = this.s.lastIndexOf(58);
            if (n >= 0 && n2 >= 0) {
                this.conditional = true;
            }
            if (!this.conditional) {
                try {
                    this.parser1 = UCDFilter.createParser(this.s.replace('$', ' ').trim(), ColumnCalculator.this.a);
                }
                catch (ParserException parserException) {
                    this.error = "Incorrect syntax for expression " + this.s;
                    return false;
                }
            }
            String string = this.s.substring(0, n);
            String string2 = this.s.substring(n + 1, n2);
            String string3 = this.s.substring(n2 + 1);
            this.condFilter = new UCDFilter("test", string + " {}", ColumnCalculator.this.a, null);
            if (this.condFilter.badSyntax) {
                this.error = "Incorrect syntax for condition " + string;
                return false;
            }
            try {
                this.parser1 = UCDFilter.createParser(string2.replace('$', ' ').trim(), ColumnCalculator.this.a);
            }
            catch (ParserException parserException) {
                this.error = "Incorrect syntax for expression " + string2;
                return false;
            }
            try {
                this.parser2 = UCDFilter.createParser(string3.replace('$', ' ').trim(), ColumnCalculator.this.a);
            }
            catch (ParserException parserException) {
                this.error = "Incorrect syntax for expression " + string3;
                return false;
            }
            return true;
        }

        String eval(Source source, int n) {
            String string = "";
            if (this.conditional) {
                if (this.condFilter.verifyValueConstraints(source, 0)) {
                    if (Action.setAllVariables(this.parser1, source, false)) {
                        string = ColumnCalculator.format(this.parser1.eval(), n);
                    }
                } else if (Action.setAllVariables(this.parser2, source, false)) {
                    string = ColumnCalculator.format(this.parser2.eval(), n);
                }
            } else if (Action.setAllVariables(this.parser1, source, false)) {
                string = ColumnCalculator.format(this.parser1.eval(), n);
            }
            return string;
        }
    }
}

