/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Action;
import cds.aladin.ActionExecutor;
import cds.aladin.Aladin;
import cds.aladin.Arc;
import cds.aladin.Box;
import cds.aladin.CDSXMatch;
import cds.aladin.Calib;
import cds.aladin.Calque;
import cds.aladin.Cercle;
import cds.aladin.ColumnCalculator;
import cds.aladin.CommandDS9;
import cds.aladin.Configuration;
import cds.aladin.ContourPlot;
import cds.aladin.Coord;
import cds.aladin.Cote;
import cds.aladin.Ellipse;
import cds.aladin.FilterProperties;
import cds.aladin.FrameColumnCalculator;
import cds.aladin.FrameContour;
import cds.aladin.FrameMocFiltering;
import cds.aladin.Function;
import cds.aladin.Glu;
import cds.aladin.Ligne;
import cds.aladin.Localisation;
import cds.aladin.MacroModel;
import cds.aladin.MyByteArrayStream;
import cds.aladin.MyInputStream;
import cds.aladin.MyRobot;
import cds.aladin.Obj;
import cds.aladin.Pickle;
import cds.aladin.Plan;
import cds.aladin.PlanBG;
import cds.aladin.PlanCatalog;
import cds.aladin.PlanField;
import cds.aladin.PlanFilter;
import cds.aladin.PlanFolder;
import cds.aladin.PlanImage;
import cds.aladin.PlanImageBlink;
import cds.aladin.PlanMoc;
import cds.aladin.PlanMocAlgo;
import cds.aladin.Position;
import cds.aladin.Projection;
import cds.aladin.RectangleD;
import cds.aladin.Repere;
import cds.aladin.Save;
import cds.aladin.Server;
import cds.aladin.Source;
import cds.aladin.SourceStat;
import cds.aladin.Synchro;
import cds.aladin.Tag;
import cds.aladin.Tok;
import cds.aladin.Vecteur;
import cds.aladin.View;
import cds.aladin.ViewSimple;
import cds.allsky.HipsGen;
import cds.astro.Astrocoo;
import cds.astro.Unit;
import cds.moc.HealpixMoc;
import cds.savot.model.SavotField;
import cds.tools.Computer;
import cds.tools.Util;
import cds.tools.pixtools.CDSHealpix;
import cds.xml.Field;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public final class Command
implements Runnable {
    static final long TIMEOUT = 3L;
    static long timeout = 180000L;
    static int DRAWXY = 0;
    static int DRAWRADEC;
    static int drawMode;
    Aladin a;
    Calque c;
    private CommandDS9 ds9;
    private boolean stop;
    private String lastCmd = "";
    protected Synchro syncSave = new Synchro();
    private Thread thread;
    JFrame robotInfo;
    String curTuto;
    JTextArea infoTxt;
    HashMap<String, String> var = new HashMap(100);
    MyRobot robot;
    public boolean robotMode = false;
    boolean filterMode = false;
    StringBuffer filterDef = null;
    PlanImage planRGBRef;
    static final String execHelp = "\n#PLANE:#                                   #VIEW:#\n   @get servers [target] [radius]           @mview [1|2|4|9|16] [n]\n   @load filename                           @cview [-plot] [[x] v]\n   @select x1 [x2..]                        @select v1 [v2..]\n   @set [x1] [x2..] prop=value              @zoom ...\n   @hide|@show [x1] [x2..]                   @northup|@unnorthup [v1] [v2..]\n   @mv|@copy x1 x2                           @thumbnail [radius]\n   @rm [x1] [x2..] | -all                   @lock|@unlock [v1] [v2..]\n   @export [-fmt] x filename                @match [-scale] [v|x|off]\n                                           @mv|@copy v1 v2\n#IMAGE:#                                     @rm [v1] [v2..] | -lock\n   @cm [x1|v1...] [colorMap...]             @save [-fmt] [-lk] [WxH] [file]\n   @RGB|@RGBdiff [x1|v1...]                  @coord|@object\n   @blink|@mosaic [x1] [x2...]\n   @+ | @- | @* | @/ ...                     #CATALOG:#\n   @norm [-cut] [x]                         @filter ...\n   @conv [x] ...                            @addcol ...\n   @kernel ...                              @xmatch x1 x2 [dist] ...\n   @resamp x1 x2 ...                        @ccat [-uniq] [x1...]\n   @crop [x|v] [[X,Y] WxH]                  @search {expr|+|-}\n   @flipflop [x|v] [V|H]                    @tag|@untag\n   @contour [nn] [nosmooth] [zoom]          @select -tag\n   @grey|@bitpix [-cut] [x] BITPIX\n                                         #FOLDER:#\n#GRAPHIC# #TOOL:#                              @md [-localscope] [name]\n   @draw [color] fct(param)                 @mv|@rm [name]\n   @grid [on|off]                           @collapse|@expand [name]\n   @reticle [on|off]\n   @overlay [on|off]                      #COVERAGE:#\n                                           @cmoc [-order=o] [x1|v1...]\n \n#MISCELLANEOUS:#\n   @backup filename     @status       @sync       @demo [on|off|end]  @pause [nn]\n   @help ...            @trace        @mem        @info msg\n   @macro script param  @call fct     @list [fct] @reset\n   @setconf prop=value  @function ... @= ...      @convert      @quit   ";
    static final String[] CMD;
    private static final String[] NOSYNCCMD;
    private InputStream stream = System.in;
    Stack<InputStream> stackStream = new Stack();
    private boolean sleepFlag = false;
    int X = 0;
    static Object lockSyncNeedSesame;
    protected boolean syncNeedSesame = false;
    static Object lockSyncNeedRepaint;
    protected boolean syncNeedRepaint = false;
    private boolean killSync = false;
    private boolean inSync = false;
    protected static final int SYNCOFF = 0;
    protected static final int SYNCON = 1;
    protected int syncMode = 1;
    static String[] UNIT;
    private static final String OP = "+-*/";
    protected HipsGen hipsgen = null;
    private static final String OTHERS = "+-*/";
    private boolean flagFoV = false;
    private Color globalColor = null;
    private Plan oPlan = null;
    StringBuffer comment = null;
    Function fonct = null;
    private static final int STICKVIEW = 0;
    private static final int UNSTICKVIEW = 1;
    private static final int LOCKVIEW = 2;
    private static final int UNLOCKVIEW = 3;
    private static final int NORTHUP = 4;
    private static final int UNNORTHUP = 5;
    private ArrayList<Function> function = new ArrayList();
    private boolean functionLocalDefinition = false;
    private boolean functionModif = false;
    private String TEST = "info Aladin test script in progress...;reset;setconf frame=ICRS;setconf timeout=1;mview 4;get ESO(dss1,25,25),Aladin(DSS2) M1;get skyview(Surveys=2MASS,400,Sin) m1;cview DSS* A1;cview Sk* B1;cview ESO* A2;set ESO* planeID=ESO.DSS1;cm A2 noreverse 2200..13000 log;mv A2 B2;mv B1 A2;mv B2 B1;select Sk*;contour;select DSS*;contour;select Sk*;draw mode(radec);draw tag(05:34:30.87,+22:01:02.1,\"Crab nebulae\",50,-30,circle,14);set Draw* color=yellow;draw mode(xy);draw phot(63 57 15);get LEDA M1;hide Contours;select ESO*;zoom 1x;Gauss = conv Skw* gauss(fwhm=10\",radius=12);backup back.aj;reset;pause 2;load back.aj;RGB = RGB ESO* DSS*;zoom 1x;rm DSS*;rm Contours~1;show Contours;Gauss1 = Gauss;set Gauss1 FITS:CRPIX1=203;Gauss = Gauss / Gauss1;rm Gauss1;cview Gauss;setconf frame=Gal;184.57316 -05.83741;flipflop Gauss V;Crop = crop Gauss 100x100;rm Gauss;rm A2;Cube=blink Sk* Crop ESO*;PR=get Press;cview Sk* A2;set PR opacity=65;rm A2;pause 2;get Simbad M1 14';call NED(M1,\"10'\");get Vizier(USNO);md Fold;mv RGB Fold;sync;mv I/284 Fold;filter Magn {;$[phot.mag*]<15 {draw rainbow(${Imag}) fillcircle(-$[phot.mag*]) };};mv Magn Fold;set Fold scope=local;rm USNO;XMatch = xmatch Simbad NED 45;addcol XMatch,B-V,${B_tab1}-${V_tab1};select XMatch;search -B-V=\"\";tag;cplane B-V;rm XMatch;get Fov(HST);mv HST Fold;export Simbad Cat.xml;export NED Cat1.tsv;export Crop Img.jpg;rm Simbad NED Crop;load Img.jpg;grey Img.jpg;rm A2;load Cat.xml;load Cat1.tsv;mv Img.jpg Fold;mv Cat.xml Fold;mv Cat1.tsv Fold;set Img.jpg opacity=20;collapse Fold;get hips(SHASSA);set proj=AITOFF;zoom 180\u00b0;rm B1;get hips(Mellinger);m1;zoom 15';rm B1;set Melling* opacity=30;get hips(\"Simbad density\");set proj=CARTESIAN;cm eosb reverse log;M1;zoom 30\u00b0;set opacity=30;rm B1;cview -plot I/284(Imag,R2mag) B1;sync;select B-V;grid on;setconf overlays=-label;info The end !;";

    private String execHelp() {
        if (Aladin.levelTrace > 0) {
            return "\n#PLANE:#                                   #VIEW:#\n   @get servers [target] [radius]           @mview [1|2|4|9|16] [n]\n   @load filename                           @cview [-plot] [[x] v]\n   @select x1 [x2..]                        @select v1 [v2..]\n   @set [x1] [x2..] prop=value              @zoom ...\n   @hide|@show [x1] [x2..]                   @northup|@unnorthup [v1] [v2..]\n   @mv|@copy x1 x2                           @thumbnail [radius]\n   @rm [x1] [x2..] | -all                   @lock|@unlock [v1] [v2..]\n   @export [-fmt] x filename                @match [-scale] [v|x|off]\n                                           @mv|@copy v1 v2\n#IMAGE:#                                     @rm [v1] [v2..] | -lock\n   @cm [x1|v1...] [colorMap...]             @save [-fmt] [-lk] [WxH] [file]\n   @RGB|@RGBdiff [x1|v1...]                  @coord|@object\n   @blink|@mosaic [x1] [x2...]\n   @+ | @- | @* | @/ ...                     #CATALOG:#\n   @norm [-cut] [x]                         @filter ...\n   @conv [x] ...                            @addcol ...\n   @kernel ...                              @xmatch x1 x2 [dist] ...\n   @resamp x1 x2 ...                        @ccat [-uniq] [x1...]\n   @crop [x|v] [[X,Y] WxH]                  @search {expr|+|-}\n   @flipflop [x|v] [V|H]                    @tag|@untag\n   @contour [nn] [nosmooth] [zoom]          @select -tag\n   @grey|@bitpix [-cut] [x] BITPIX\n                                         #FOLDER:#\n#GRAPHIC# #TOOL:#                              @md [-localscope] [name]\n   @draw [color] fct(param)                 @mv|@rm [name]\n   @grid [on|off]                           @collapse|@expand [name]\n   @reticle [on|off]\n   @overlay [on|off]                      #COVERAGE:#\n                                           @cmoc [-order=o] [x1|v1...]\n \n#MISCELLANEOUS:#\n   @backup filename     @status       @sync       @demo [on|off|end]  @pause [nn]\n   @help ...            @trace        @mem        @info msg\n   @macro script param  @call fct     @list [fct] @reset\n   @setconf prop=value  @function ... @= ...      @convert      @quit   @test ...\n";
        }
        return "\n#PLANE:#                                   #VIEW:#\n   @get servers [target] [radius]           @mview [1|2|4|9|16] [n]\n   @load filename                           @cview [-plot] [[x] v]\n   @select x1 [x2..]                        @select v1 [v2..]\n   @set [x1] [x2..] prop=value              @zoom ...\n   @hide|@show [x1] [x2..]                   @northup|@unnorthup [v1] [v2..]\n   @mv|@copy x1 x2                           @thumbnail [radius]\n   @rm [x1] [x2..] | -all                   @lock|@unlock [v1] [v2..]\n   @export [-fmt] x filename                @match [-scale] [v|x|off]\n                                           @mv|@copy v1 v2\n#IMAGE:#                                     @rm [v1] [v2..] | -lock\n   @cm [x1|v1...] [colorMap...]             @save [-fmt] [-lk] [WxH] [file]\n   @RGB|@RGBdiff [x1|v1...]                  @coord|@object\n   @blink|@mosaic [x1] [x2...]\n   @+ | @- | @* | @/ ...                     #CATALOG:#\n   @norm [-cut] [x]                         @filter ...\n   @conv [x] ...                            @addcol ...\n   @kernel ...                              @xmatch x1 x2 [dist] ...\n   @resamp x1 x2 ...                        @ccat [-uniq] [x1...]\n   @crop [x|v] [[X,Y] WxH]                  @search {expr|+|-}\n   @flipflop [x|v] [V|H]                    @tag|@untag\n   @contour [nn] [nosmooth] [zoom]          @select -tag\n   @grey|@bitpix [-cut] [x] BITPIX\n                                         #FOLDER:#\n#GRAPHIC# #TOOL:#                              @md [-localscope] [name]\n   @draw [color] fct(param)                 @mv|@rm [name]\n   @grid [on|off]                           @collapse|@expand [name]\n   @reticle [on|off]\n   @overlay [on|off]                      #COVERAGE:#\n                                           @cmoc [-order=o] [x1|v1...]\n \n#MISCELLANEOUS:#\n   @backup filename     @status       @sync       @demo [on|off|end]  @pause [nn]\n   @help ...            @trace        @mem        @info msg\n   @macro script param  @call fct     @list [fct] @reset\n   @setconf prop=value  @function ... @= ...      @convert      @quit   \n";
    }

    private boolean needSync(String string) {
        return Util.indexInArrayOf(string, NOSYNCCMD) == -1;
    }

    Command(Aladin aladin) {
        this.a = aladin;
        this.ds9 = new CommandDS9(aladin);
        this.testRobot();
        if (Aladin.ROBOTSUPPORT) {
            this.robot = new MyRobot(this.a);
            Aladin.trace(3, "Creating robot");
        }
    }

    protected void stop() {
        this.stop = true;
    }

    public void printConsole(String string) {
        this.print(string);
        this.console(string);
    }

    public void console(String string) {
        if (!string.startsWith("!!!")) {
            this.a.console.printInfo(string);
        } else {
            this.a.console.printError(string);
        }
    }

    public void println(String string) {
        this.print(string + "\n");
    }

    public void print(String string) {
        if (Aladin.NOGUI && !string.startsWith("!!!")) {
            return;
        }
        if (!Aladin.isApplet()) {
            System.out.print(string);
        }
    }

    protected void readStandardInput() {
        this.thread = new Thread((Runnable)this, "AladinReadStdin");
        Util.decreasePriority(Thread.currentThread(), this.thread);
        this.thread.start();
    }

    synchronized void setStream(InputStream inputStream) {
        if (inputStream == null) {
            if (this.stackStream.empty()) {
                inputStream = System.in;
            } else {
                inputStream = this.stackStream.pop();
                if (inputStream == this.stream && inputStream != System.in && !this.stackStream.empty()) {
                    inputStream = this.stackStream.peek();
                }
            }
        } else {
            this.stackStream.push(inputStream);
        }
        this.stream = inputStream;
    }

    protected void readFromStream(InputStream inputStream) {
        this.setStream(inputStream);
    }

    @Override
    public void run() {
        this.a.waitDialog();
        this.scriptFromInputStream();
        Aladin.trace(2, "Command interpreter stopped !");
    }

    protected synchronized void readNow() {
        if (this.sleepFlag) {
            this.thread.interrupt();
        }
    }

    private synchronized void setFlagSleep(boolean bl) {
        this.sleepFlag = bl;
    }

    protected boolean hasCommand() {
        try {
            return this.stream != System.in && this.stream.available() > -1 || this.stream.available() > 0 || !this.isSyncServer();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    private String readLine() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        int n = 0;
        int n2 = 0;
        do {
            block9: {
                if ((this.stream == null || this.stream == System.in) && this.a.console != null && this.a.console.hasWaitingCmd()) {
                    return this.a.console.popCmd();
                }
                try {
                    if (this.stream == null || this.stream == System.in && this.stream.available() == 0) {
                        this.setFlagSleep(true);
                        Util.pause(500);
                        this.setFlagSleep(false);
                    }
                    break block9;
                }
                catch (Exception exception) {
                    this.stream = null;
                }
                continue;
            }
            try {
                n = this.stream.read();
            }
            catch (Exception exception) {
                this.stream = null;
                continue;
            }
            if (this.stream != System.in && n == -1) {
                this.setStream(null);
                bl = false;
                continue;
            }
            stringBuffer.append((char)n);
            if (n == 91) {
                ++n2;
                continue;
            }
            if (n != 93) continue;
            --n2;
        } while (bl && !this.stop && n != 10 && (n != 59 || n2 != 0));
        return stringBuffer.toString();
    }

    protected String getPrompt() {
        return this.filterMode ? "Filter> " : (this.fonct != null ? "Function> " : "Command> ");
    }

    protected boolean waitingMore() {
        return !this.filterMode && this.fonct == null;
    }

    protected void scriptFromInputStream() {
        boolean bl;
        String string = null;
        boolean bl2 = bl = this.stream == System.in;
        if (bl) {
            this.print(this.getPrompt());
        }
        while (!this.stop) {
            try {
                if (this.robotMode) {
                    this.robotSync();
                }
                if ((string = this.readLine()) == null) {
                    return;
                }
                if (string.trim().length() != 0) {
                    this.execScript(string);
                }
                if (!bl) continue;
                this.print(this.getPrompt());
            }
            catch (Exception exception) {
                if (Aladin.levelTrace >= 3) {
                    exception.printStackTrace();
                }
                this.println("!!! " + exception);
                exception.printStackTrace();
            }
        }
    }

    protected int getViewNumber(String string) {
        return this.getViewNumber(string, true);
    }

    protected int getViewNumber(String string, boolean bl) {
        int n = this.a.view.getNViewFromID(string);
        if (bl && n < 0) {
            this.printConsole("!!! Not a valid view identifier [ex: B2]");
            return -1;
        }
        if (n >= this.a.view.getModeView()) {
            if (bl) {
                this.printConsole("!!! View \"" + string + "\" not visible " + n);
            }
            return -1;
        }
        return n;
    }

    protected String parseColumnIndex(String[] stringArray, String string) {
        stringArray[0] = "";
        stringArray[1] = "";
        int n = string.indexOf(40);
        int n2 = string.lastIndexOf(44);
        if (n == -1 || n2 == -1 || string.charAt(string.length() - 1) != ')') {
            return string;
        }
        String string2 = string.substring(0, n);
        stringArray[0] = string.substring(n + 1, n2);
        stringArray[1] = string.substring(n2 + 1, string.length() - 1);
        return string2;
    }

    protected Plan getNumber(String string) {
        return this.getNumber(string, 1);
    }

    protected Plan getNumber(String string, int n) {
        return this.getNumber(string, n, false, true);
    }

    protected Plan getNumber(String string, int n, boolean bl, boolean bl2) {
        int n2 = 0;
        boolean bl3 = string.length() > 1 && string.charAt(0) == '@';
        try {
            n2 = Integer.parseInt(bl ? string.substring(1) : (bl3 ? string.substring(1) : string));
        }
        catch (Exception exception) {
            // empty catch block
        }
        Plan[] planArray = this.a.calque.getPlans();
        if (n2 < 1 || n2 > planArray.length) {
            if (n == 1 && !bl3) {
                n2 = this.a.calque.getIndexPlan(string);
                if (n2 < 0) {
                    if (bl2) {
                        this.printConsole("!!! Plane \"" + string + "\" not found !");
                    }
                    return null;
                }
                return planArray[n2];
            }
            if (bl2) {
                this.printConsole("!!! Plane number error (" + string + ")");
            }
            return null;
        }
        n2 = planArray.length - n2;
        if (planArray[n2].type == 0) {
            if (bl2) {
                this.printConsole("!!! Plane number " + string + " not assigned");
            }
            return null;
        }
        return planArray[n2];
    }

    private Plan getPlanFromParam(String string) {
        return this.getPlanFromParam(string, 0, false);
    }

    private Plan getPlanFromParam(String string, int n) {
        return this.getPlanFromParam(string, n, false);
    }

    private Plan getPlanFromParam(String string, int n, boolean bl) {
        ViewSimple viewSimple;
        int n2;
        Plan plan = null;
        if (n == 0 && (n2 = this.getViewNumber(string, false)) >= 0 && !(viewSimple = this.a.view.viewSimple[n2]).isFree()) {
            plan = viewSimple.pref;
        }
        if (plan == null) {
            plan = this.getNumber(string, 1, bl, false);
        }
        return plan;
    }

    private PlanImage[] getPlanImage(String string) {
        Plan[] planArray = this.getPlan(string, 1);
        PlanImage[] planImageArray = new PlanImage[planArray.length];
        System.arraycopy(planArray, 0, planImageArray, 0, planArray.length);
        return planImageArray;
    }

    protected Plan getFirstPlan(String string) {
        Plan[] planArray;
        if (string.indexOf(32) >= 0 && string.indexOf(34) < 0) {
            string = '\"' + string + '\"';
        }
        if ((planArray = this.getPlan(string)).length == 0) {
            return null;
        }
        return planArray[0];
    }

    protected Plan[] getPlan(String string) {
        return this.getPlan(string, 0);
    }

    protected Plan[] getPlan(String string, int n) {
        Vector<Plan> vector = new Vector<Plan>();
        string = string.trim();
        Plan[] planArray = this.a.calque.getPlans();
        if (string.length() == 0) {
            for (int i = 0; i < planArray.length; ++i) {
                Plan plan = planArray[i];
                if (n == 1 && !plan.isPixel() || !plan.flagOk || !plan.selected) continue;
                vector.addElement(plan);
            }
        } else {
            Tok tok = new Tok(string);
            while (tok.hasMoreTokens()) {
                String string2 = tok.nextToken();
                Plan plan = this.getPlanFromParam(string2, n == 2 ? 1 : 0);
                if (plan == null || n == 1 && !plan.isPixel() || n == 3 && plan.type != 11 || plan == null || !plan.flagOk && n != 4) continue;
                vector.addElement(plan);
            }
        }
        return vector.toArray(new Plan[vector.size()]);
    }

    protected boolean isSyncServer() {
        if (this.a.synchroServer.isReady()) {
            return true;
        }
        Aladin.trace(4, "Command.isSyncServer() : waiting server...\n==> " + this.a.synchroServer);
        return false;
    }

    protected boolean isSyncPlugin() {
        if (this.a.plugins == null) {
            return true;
        }
        boolean bl = this.a.plugins.isSync();
        if (!bl) {
            Aladin.trace(4, "Command.isSyncPlugin() : waiting a plugin...\n");
        }
        return bl;
    }

    protected boolean isSyncPlan() {
        if (this.a.synchroPlan.isReady()) {
            return true;
        }
        Aladin.trace(4, "Command.isSyncPlan() : waiting plane...\n==> " + this.a.synchroPlan);
        return false;
    }

    protected boolean isSyncSave() {
        if (this.syncSave.isReady()) {
            return true;
        }
        Aladin.trace(4, "Command.isSyncSave() : waiting save process...\n==> " + this.syncSave);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSyncNeedSesame(boolean bl) {
        Object object = lockSyncNeedSesame;
        synchronized (object) {
            this.syncNeedSesame = bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSyncNeedSesame() {
        Object object = lockSyncNeedSesame;
        synchronized (object) {
            return this.syncNeedSesame;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSyncNeedRepaint(boolean bl) {
        Object object = lockSyncNeedRepaint;
        synchronized (object) {
            this.syncNeedRepaint = bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSyncNeedRepaint() {
        Object object = lockSyncNeedRepaint;
        synchronized (object) {
            return this.syncNeedRepaint;
        }
    }

    protected boolean isSync() {
        if (this.a.dialog == null || this.a.calque == null) {
            Aladin.trace(4, "Command.isSync() : waiting (Aladin.dialog not ready)...");
            return false;
        }
        if (this.isSyncNeedSesame() && this.a.view.isSesameInProgress()) {
            Aladin.trace(4, "Command.isSync() : waiting sesame...\n==> " + this.a.view.sesameSynchro);
            return false;
        }
        this.setSyncNeedSesame(false);
        if (this.isSyncNeedRepaint()) {
            Aladin.trace(4, "Command.isSync() : waiting viewSimple.paintComponent()...");
            this.a.view.repaintAll();
            return false;
        }
        if (!this.isSyncServer()) {
            return false;
        }
        if (!this.isSyncPlan()) {
            return false;
        }
        if (!this.isSyncPlugin()) {
            return false;
        }
        if (!this.isSyncSave()) {
            return false;
        }
        Plan[] planArray = this.a.calque.getPlans();
        for (int i = planArray.length - 1; i >= 0; --i) {
            if (planArray[i].type == 0 || planArray[i].isSync()) continue;
            Aladin.trace(4, "Command.isSync() : waiting plane \"" + planArray[i] + "\"...");
            if (planArray[i].label == null) {
                System.err.println("isSync label==null : type=" + planArray[i].type + " state=" + planArray[i].getDebugFlag());
            }
            return false;
        }
        return true;
    }

    protected void killSync() {
        if (!this.inSync) {
            return;
        }
        this.killSync = true;
    }

    protected void setSyncMode(int n) {
        this.syncMode = n;
    }

    public void sync() {
        this.inSync = true;
        if (this.robotMode) {
            this.robotSync();
            Util.pause(1000);
        }
        long l = System.currentTimeMillis();
        while (!this.isSync()) {
            if (this.killSync) {
                this.killSync = false;
                this.println("!!! Command sync has been killed !");
                this.inSync = false;
                return;
            }
            if (timeout > 0L && System.currentTimeMillis() - l > 4L * timeout / 5L) {
                if (Aladin.levelTrace != 4) {
                    this.println("!!! Command.sync() TOO LONG => trace mode actived");
                    Aladin.levelTrace = 4;
                }
            }
            if (timeout > 0L && System.currentTimeMillis() - l > timeout) {
                this.println("!!! Auto Sync time out error (" + timeout / 60000L + " minutes) in Command.sync() => sync ignored");
                System.err.println("Command.sync() timeout => status:\n" + this.getStatus("*"));
                this.inSync = false;
                return;
            }
            Util.pause(100);
        }
        this.inSync = false;
    }

    private void syncServer() {
        try {
            this.a.synchroServer.waitUntil(timeout);
        }
        catch (Exception exception) {
            this.println("!!! Time out error (" + timeout / 60000L + " minutes) in Command.syncServer().");
        }
    }

    private void testRobot() {
        try {
            Class<?> clazz = Class.forName("java.awt.Robot");
            Constructor<?> constructor = clazz.getConstructor(new Class[0]);
            constructor.newInstance(new Object[0]);
            Aladin.trace(3, "Robot supported");
            Aladin.ROBOTSUPPORT = true;
        }
        catch (Exception exception) {
            Aladin.trace(3, "Robot NOT supported");
            Aladin.ROBOTSUPPORT = false;
        }
    }

    private void robotSync() {
        long l = System.currentTimeMillis();
        while (!ActionExecutor.ready || ActionExecutor.interruptAction) {
            if (timeout > 0L && System.currentTimeMillis() - l > timeout) {
                this.println("!!! Time out error (" + timeout / 60000L + " minutes).");
                return;
            }
            Util.pause(500);
        }
        Util.pause(1000);
    }

    private String execStatusCmd(String string) {
        String string2 = this.getStatus(string);
        this.println(string2);
        return string2;
    }

    protected String getStatus(String string) {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        Plan[] planArray = string == null || string.equals("") || string.equals("*") || string.equals("stack") ? this.a.calque.getPlans() : this.getPlan(string, 2);
        for (int i = 0; i < planArray.length; ++i) {
            String string2;
            object = planArray[i];
            if (((Plan)object).type == 0) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append("\n");
            }
            stringBuffer.append("PlaneID " + Tok.quote(((Plan)object).label) + "\nPlaneNb " + (planArray.length - this.a.calque.getIndex((Plan)object)) + "\nType    " + Plan.Tp[((Plan)object).type] + "\n" + (((Plan)object).verboseDescr != null ? "Info    " + ((Plan)object).verboseDescr + "\n" : "") + (((Plan)object).ack != null ? "Ack     " + ((Plan)object).ack + "\n" : "") + "Status  " + (((Plan)object).active ? "shown" : "hidden") + " " + (((Plan)object).selected ? "selected" : "") + (!((Plan)object).flagOk && ((Plan)object).error != null ? " error" : "") + "\n" + (((Plan)object).u != null ? "Url     " + ((Plan)object).getUrl() + "\n" : "") + (((Plan)object).co != null ? "Target  " + ((Plan)object).getTarget() + "\n" : ""));
            if (((Plan)object).colorBackground != null) {
                stringBuffer.append("Background " + (((Plan)object).colorBackground == Color.white ? "white" : "black") + "\n");
            }
            if (((Plan)object).type == 10) {
                stringBuffer.append("Roll    " + ((PlanField)object).getRoll() + "\n");
                stringBuffer.append("Rollable " + ((PlanField)object).isRollable() + "\n");
                stringBuffer.append("Movable  " + ((PlanField)object).isMovable() + "\n");
                string2 = ((PlanField)object).getStatusSubFov();
                if (string2 != null) {
                    stringBuffer.append(string2);
                }
            } else if (((Plan)object).isCatalog()) {
                stringBuffer.append("NbObj   " + ((Plan)object).getCounts() + "\n");
                stringBuffer.append("Shape   " + Source.getShape(((Plan)object).sourceType) + "\n");
                stringBuffer.append("Filter  " + ((PlanCatalog)object).getFilterDescription() + "\n");
                stringBuffer.append("Color   " + Action.findColorName(((Plan)object).c) + "\n");
            } else if (((Plan)object).type == 9) {
                stringBuffer.append("Color   " + Action.findColorName(((Plan)object).c) + "\n");
                stringBuffer.append("Movable " + (((Plan)object).isMovable() ? "on" : "off") + "\n");
            } else if (((Plan)object).type == 1 || ((Plan)object).type == 15) {
                stringBuffer.append("Width   " + ((PlanImage)object).naxis1 + "\nHeight  " + ((PlanImage)object).naxis2 + "\n");
                if (((Plan)object).flagOk && ((Plan)object).projd != null) {
                    string2 = Coord.getUnit(((Plan)object).projd.c.GetResol()[0]);
                    stringBuffer.append("PixelRes " + string2);
                }
            } else if (((Plan)object).type == 11) {
                stringBuffer.append("Scope   " + (((PlanFolder)object).localScope ? "local" : "global") + "\n");
                string2 = ((PlanFolder)object).getStatusItems();
                if (string2 != null) {
                    stringBuffer.append(string2);
                }
            }
            if (object instanceof PlanBG && ((Plan)object).isPixel()) {
                stringBuffer.append("PixelRes " + ((PlanBG)object).getMaxResolution());
            }
            if (!this.a.calque.canBeTransparent((Plan)object)) continue;
            stringBuffer.append("Opacity " + Util.myRound(((Plan)object).getOpacityLevel() * 100.0f + "", 0) + "\n");
        }
        StringBuffer stringBuffer2 = new StringBuffer();
        if (string == null || string.equals("") || string.equals("*") || string.equals("views")) {
            stringBuffer2 = this.a.view.getStatus();
        } else {
            object = new Tok(string);
            while (((Tok)object).hasMoreTokens()) {
                String string3 = ((Tok)object).nextToken();
                int n = this.getViewNumber(string3, false);
                if (n == -1 || this.a.view.viewSimple[n].isFree()) continue;
                stringBuffer2.append(this.a.view.viewSimple[n].getStatus() + "\n");
            }
        }
        if (stringBuffer2.length() > 0) {
            stringBuffer.append("\n" + stringBuffer2);
        }
        return stringBuffer.toString();
    }

    private boolean extractRadius(StringBuffer stringBuffer, StringBuffer stringBuffer2, String string) {
        int n;
        int n2;
        char[] cArray = string.toCharArray();
        for (n2 = cArray.length - 1; n2 > 0 && (cArray[n2] < '0' || cArray[n2] > '9'); --n2) {
        }
        String string2 = new String(cArray, n2 + 1, cArray.length - n2 - 1);
        for (n = 0; n < UNIT.length && !string2.equalsIgnoreCase(UNIT[n]); ++n) {
        }
        if (n == UNIT.length) {
            return false;
        }
        for (n = n2; n > 0 && cArray[n] != ' '; --n) {
        }
        if (n == 0) {
            return false;
        }
        String string3 = new String(cArray, n + 1, cArray.length - n - 1);
        if (string3.endsWith("'")) {
            string3 = string3.substring(0, string3.length() - 1) + "m";
        } else if (string3.endsWith("\"")) {
            string3 = string3.substring(0, string3.length() - 1) + "s";
        }
        stringBuffer.append("" + Server.getAngleInArcmin(string3, 1));
        stringBuffer2.append(new String(cArray, 0, n));
        return true;
    }

    protected boolean isCommand(String string) {
        return Util.indexInArrayOf(string, CMD, true) >= 0;
    }

    private int findPosAlgebre(String string) {
        for (int i = 0; i < "+-*/".length(); ++i) {
            char c = "+-*/".charAt(i);
            int n = -1;
            while ((n = string.indexOf(c, n + 1)) != -1) {
                boolean bl;
                boolean bl2;
                double d = Double.NaN;
                double d2 = Double.NaN;
                String string2 = string.substring(n + 1).trim();
                try {
                    d2 = Double.parseDouble(string2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                boolean bl3 = bl2 = this.getNumber(Tok.unQuote(string2), 1, true, false) != null;
                if (n == 0 && (!Double.isNaN(d2) || bl2)) {
                    return n;
                }
                String string3 = string.substring(0, n).trim();
                try {
                    d = Double.parseDouble(string3);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                boolean bl4 = bl = this.getNumber(Tok.unQuote(string3), 1, true, false) != null;
                if (Double.isNaN(d) && !bl || Double.isNaN(d2) && !bl2 || !Double.isNaN(d) && !Double.isNaN(d2)) continue;
                return n;
            }
        }
        return -1;
    }

    protected String getTargetPlane(StringBuffer stringBuffer, String string) {
        int n;
        String string2;
        int n2 = string.indexOf(61);
        if (n2 == 0) {
            return string;
        }
        String string3 = n2 == -1 ? string : string.substring(n2 + 1).trim();
        String string4 = string2 = n2 == -1 ? "" : string.substring(0, n2).trim();
        if (string2.indexOf(32) > 0 && string2.charAt(0) != '\"' && string2.charAt(0) != '\'') {
            return string;
        }
        if (this.findAlgebre(string3) < 0 && (n = this.findPosAlgebre(string3)) >= 0) {
            string3 = n == 0 ? string3.charAt(n) + " " + string3.substring(n + 1) : string3.substring(0, n) + " " + string3.charAt(n) + " " + string3.substring(n + 1);
        }
        if (n2 == -1) {
            return string3;
        }
        String string5 = new Tok(string3).nextToken();
        if (!this.isCommand(string5) && this.findAlgebre(string3) < 0 && this.getNumber(string3, 1, false, false) == null) {
            return string;
        }
        stringBuffer.append(Tok.unQuote(string.substring(0, n2).trim()));
        return string3;
    }

    protected boolean splitGetCmd(StringBuffer stringBuffer, StringBuffer stringBuffer2, StringBuffer stringBuffer3, String string, boolean bl) {
        CharSequence charSequence;
        int n;
        int n2;
        char[] cArray = string.toCharArray();
        if (bl && (stringBuffer.indexOf("IVOA") >= 0 || string.indexOf("IVOA") >= 0) && !this.a.dialog.ivoaServersLoaded) {
            this.a.dialog.appendIVOAServer();
        }
        for (n2 = 0; n2 < cArray.length && cArray[n2] == ' '; ++n2) {
        }
        int n3 = 0;
        for (n = n2; n < cArray.length; ++n) {
            if (n3 == 0) {
                if (cArray[n] == '(') {
                    ++n3;
                    continue;
                }
                if (cArray[n] != ' ') continue;
                break;
            }
            if (cArray[n] != ')') continue;
            --n3;
        }
        String string2 = new String(cArray, n2, n - n2);
        for (n2 = n; n2 < cArray.length && cArray[n2] == ' '; ++n2) {
        }
        CharSequence charSequence2 = new String(cArray, n2, cArray.length - n2).trim();
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",(");
        String string3 = stringTokenizer.nextToken();
        if (string3.equalsIgnoreCase("allsky")) {
            string3 = "hips";
        }
        if (!bl || this.a.dialog.getServer(string3) < 0) {
            if (this.a.view.getCurrentView().isFree()) {
                charSequence2 = string;
                if (Aladin.OUTREACH || this.a.isFullScreen()) {
                    string2 = "hips(\"P/DSS2/color\")";
                } else {
                    string2 = this.a.configuration.getServer();
                    charSequence = this.a.configuration.getSurvey();
                    if (charSequence != null && ((String)charSequence).trim().length() > 0) {
                        string2 = string2 + "(" + (String)charSequence + ")";
                    }
                }
                charSequence = this.a.view.sesameResolve(string, true);
                if (charSequence == null) {
                    Aladin.warning(this.a.dialog.server[0].UNKNOWNOBJ);
                    return false;
                }
                charSequence2 = charSequence;
                this.a.console.printCommand("get " + string2 + " " + string);
            } else {
                this.setSyncNeedRepaint(true);
                this.setSyncNeedSesame(true);
                string = Tok.unQuote(string);
                if (this.execHpxCmd(string)) {
                    return false;
                }
                this.a.view.sesameResolve(string);
                this.a.dialog.setDefaultTarget(string);
                return false;
            }
        }
        stringBuffer.append(string2);
        if (charSequence2.length() != 0) {
            charSequence = new StringBuffer();
            if (this.extractRadius(stringBuffer3, (StringBuffer)charSequence, (String)charSequence2)) {
                charSequence2 = ((StringBuffer)charSequence).toString();
                this.a.dialog.setDefaultTaille(stringBuffer3.toString());
            }
            this.a.dialog.setDefaultTarget((String)charSequence2);
        }
        stringBuffer2.append((String)charSequence2);
        if (stringBuffer3.length() == 0) {
            this.waitingPlanInProgress();
            stringBuffer3.append(Server.getRM(this.a.dialog.getDefaultTaille()) + "'");
        }
        return true;
    }

    private void waitingPlanInProgress() {
    }

    protected int getServerInfo(StringBuffer stringBuffer, StringBuffer stringBuffer2, char[] cArray, int n) {
        int n2 = n;
        int n3 = 0;
        while (n < cArray.length) {
            if (n3 == 0) {
                if (cArray[n] == '(') {
                    ++n3;
                    stringBuffer.append(new String(cArray, n2, n - n2));
                    n2 = n + 1;
                } else if (cArray[n] == ',') {
                    break;
                }
            } else if (cArray[n] == ')') {
                --n3;
                stringBuffer2.append(new String(cArray, n2, n - n2));
            }
            ++n;
        }
        if (stringBuffer.length() == 0) {
            stringBuffer.append(new String(cArray, n2, n - n2));
        }
        if (n < cArray.length && cArray[n] == ',') {
            ++n;
        }
        return n;
    }

    private boolean isTargetRequired(StringBuffer stringBuffer) {
        char[] cArray = stringBuffer.toString().toCharArray();
        StringBuffer stringBuffer2 = new StringBuffer();
        StringBuffer stringBuffer3 = new StringBuffer();
        int n = 0;
        n = this.getServerInfo(stringBuffer2, stringBuffer3, cArray, n);
        String string = stringBuffer2.toString().trim();
        return !(string.equalsIgnoreCase("Local") || string.equalsIgnoreCase("MyData") || string.equalsIgnoreCase("VizieRX") || string.equalsIgnoreCase("VizieR") && Util.indexOfIgnoreCase(stringBuffer3.toString(), "allsky") >= 0 || string.equalsIgnoreCase("allsky") || string.equalsIgnoreCase("hips") || string.equalsIgnoreCase("Aladin") && Util.indexOfIgnoreCase(stringBuffer3.toString(), "allsky") >= 0 || string.equalsIgnoreCase("File") || n != cArray.length);
    }

    protected String execGetCmd(String string, String string2, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        StringBuffer stringBuffer3 = new StringBuffer();
        StringBuffer stringBuffer4 = new StringBuffer();
        if (!this.splitGetCmd(stringBuffer3, stringBuffer, stringBuffer2, string, bl)) {
            return null;
        }
        String string3 = this.a.localisation.getICRSCoord(stringBuffer.toString().trim());
        String string4 = stringBuffer2.toString();
        if (this.isTargetRequired(stringBuffer3)) {
            if (string3.length() == 0) {
                if (this.syncMode == 1) {
                    this.sync();
                }
                string3 = this.a.dialog.getDefaultTargetJ2000();
            }
            if (string3.length() == 0) {
                Aladin.warning(Aladin.chaine.getString("WNEEDOBJ"), 1);
                return null;
            }
            this.a.dialog.setDefaultTarget(string3);
            if (View.notCoord(string3)) {
                int n = 1;
                Aladin.makeCursor(this.a, n);
                Coord coord = null;
                try {
                    coord = this.a.view.sesame(string3);
                    n = 0;
                    Aladin.makeCursor(this.a, n);
                    if (coord == null) {
                        Aladin.warning("\"" + string3 + "\": " + Aladin.chaine.getString("OBJUNKNOWN"), 1);
                    }
                }
                catch (Exception exception) {
                    Aladin.warning(exception.getMessage(), 1);
                }
                if (coord == null) {
                    return null;
                }
            }
        }
        char[] cArray = stringBuffer3.toString().toCharArray();
        int n = 0;
        do {
            int n2;
            StringBuffer stringBuffer5 = new StringBuffer();
            StringBuffer stringBuffer6 = new StringBuffer();
            n = this.getServerInfo(stringBuffer5, stringBuffer6, cArray, n);
            String string5 = stringBuffer5.toString();
            if (string5.equalsIgnoreCase("allsky")) {
                string5 = "hips";
            }
            String string6 = stringBuffer6.toString();
            Aladin.trace(4, "Command.execGetCmd(" + string + "," + string2 + ") => server=[" + string5 + "] criteria=[" + string6 + "] target=[" + string3 + "] radius=[" + string4 + "])");
            if (string5.equalsIgnoreCase("VizierX")) {
                string5 = "VizieR";
            }
            if ((n2 = this.a.dialog.getServer(string5)) >= 0) {
                this.a.dialog.server[n2].flagToFront = false;
                int n3 = this.a.dialog.server[n2].createPlane(string3, string4, string6, string2, this.a.dialog.server[n2].institute);
                if (n3 != -1) {
                    this.a.calque.getPlan(n3).setBookmarkCode("get " + string5 + (string6.length() > 0 ? "(" + string6 + ")" : "") + " $TARGET $RADIUS");
                }
                if (!this.a.isFullScreen()) continue;
                this.a.fullScreen.repaint();
                continue;
            }
            if (stringBuffer4.length() > 0) {
                stringBuffer4.append(", ");
            }
            stringBuffer4.append(string5);
        } while (n < cArray.length);
        if (stringBuffer4.length() > 0) {
            if (!Aladin.NETWORK) {
                Aladin.warning("No network for: " + stringBuffer4, 1);
            } else {
                Aladin.warning(Aladin.chaine.getString("WERROR") + " " + stringBuffer4, 1);
            }
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execMacro(String string) {
        MyInputStream myInputStream = null;
        MyInputStream myInputStream2 = null;
        try {
            Object[] objectArray;
            String string2;
            Tok tok = new Tok(string);
            String string3 = this.a.getFullFileName(tok.nextToken());
            myInputStream = new MyInputStream(Util.openAnyStream(string3)).startRead();
            Vector<Object[]> vector = new Vector<Object[]>(100);
            while ((string2 = myInputStream.readLine()) != null) {
                objectArray = string2.trim();
                vector.addElement(objectArray);
            }
            objectArray = vector.toArray();
            MacroModel macroModel = new MacroModel(this.a);
            String string4 = this.a.getFullFileName(tok.nextToken());
            myInputStream2 = new MyInputStream(Util.openAnyStream(string4)).startRead();
            HashMap<String, String> hashMap = new HashMap<String, String>();
            while ((string2 = myInputStream2.readLine()) != null) {
                int n = -1;
                int n2 = 0;
                int n3 = 1;
                while ((n = string2.indexOf(9, n + 1)) != -1) {
                    String string5 = string2.substring(n2, n).trim();
                    hashMap.put("$" + n3, string5);
                    ++n3;
                    n2 = n;
                }
                hashMap.put("$" + n3, string2.substring(n2).trim());
                for (n3 = 0; n3 < objectArray.length; ++n3) {
                    macroModel.executeScript((String)objectArray[n3], hashMap);
                }
            }
        }
        catch (Exception exception) {
            if (Aladin.levelTrace >= 3) {
                exception.printStackTrace();
            }
            Aladin.warning("macro error !" + exception.getMessage() + "\n", 1);
        }
        finally {
            if (myInputStream != null) {
                try {
                    myInputStream.close();
                }
                catch (Exception exception) {}
            }
            if (myInputStream2 != null) {
                try {
                    myInputStream2.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    protected String execSetconfCmd(String string) {
        int n = string.lastIndexOf(61);
        if (n == -1) {
            return null;
        }
        String string2 = string.substring(0, n).trim();
        String string3 = string.substring(n + 1).trim();
        Aladin.trace(4, "Command.execSetconfCmd(" + string + ") => prop=[" + string2 + "] value=[" + string3 + "])");
        if (string2.equalsIgnoreCase("bookmarks")) {
            this.a.bookmarks.setBookmarkList(string3);
            return "";
        }
        if (string2.equalsIgnoreCase("timeout")) {
            int n2 = string3.equals("off") ? 0 : Integer.parseInt(string3);
            timeout = n2 * 60000;
            return "";
        }
        if (string2.equalsIgnoreCase("overlays") || string2.equalsIgnoreCase("overlay")) {
            try {
                this.a.calque.setOverlayList(string3);
            }
            catch (Exception exception) {
                return "!!! " + exception.getMessage();
            }
            this.a.calque.repaintAll();
            return "";
        }
        if (string2.equalsIgnoreCase("gridcolor")) {
            Color color = Action.getColor(string3);
            if (color == null) {
                return "!!! Unknown color";
            }
            this.a.view.gridColor = color;
            this.a.calque.repaintAll();
            return "";
        }
        if (string2.equalsIgnoreCase("gridcolorRA")) {
            Color color = Action.getColor(string3);
            if (color == null) {
                return "!!! Unknown color";
            }
            this.a.view.gridColorRA = color;
            this.a.calque.repaintAll();
            return "";
        }
        if (string2.equalsIgnoreCase("gridFontSize")) {
            int n3;
            boolean bl = false;
            if (string3.startsWith("+")) {
                bl = true;
                string3 = string3.substring(1);
            }
            try {
                n3 = Integer.parseInt(string3);
            }
            catch (Exception exception) {
                return "!!! gridFontSize syntax error";
            }
            this.a.view.gridFontSize = bl || n3 < 0 ? (this.a.view.gridFontSize += n3) : n3;
            this.a.calque.repaintAll();
            return "";
        }
        if (string2.equalsIgnoreCase("gridcolorDEC")) {
            Color color = Action.getColor(string3);
            if (color == null) {
                return "!!! Unknown color";
            }
            this.a.view.gridColorDEC = color;
            this.a.calque.repaintAll();
            return "";
        }
        try {
            this.a.configuration.setconf(string2, string3);
        }
        catch (Exception exception) {
            if (Aladin.levelTrace >= 3) {
                exception.printStackTrace();
            }
            this.printConsole("!!! setconf error: " + exception.getMessage());
            return exception.getMessage();
        }
        if (string2.equalsIgnoreCase("frame")) {
            if (Util.indexOfIgnoreCase(string3, "XY") >= 0) {
                this.setDrawMode(DRAWXY);
            } else {
                this.setDrawMode(DRAWRADEC);
            }
        }
        return "";
    }

    protected String execSetCmd(String string) {
        int n;
        int n2;
        int n3 = string.lastIndexOf(61);
        if (n3 == -1) {
            return null;
        }
        String string2 = string.substring(n3 + 1).trim();
        char[] cArray = string.toCharArray();
        for (n2 = n3 - 1; n2 > 0 && cArray[n2] == ' '; --n2) {
        }
        while (n2 > 0 && cArray[n2] != ' ') {
            --n2;
        }
        String string3 = string.substring(n2, n3).trim();
        String string4 = null;
        for (n = n2; n > 0 && cArray[n] != '/'; --n) {
        }
        if (cArray[n] == '/') {
            if (cArray[n2 - 1] == '\"') {
                string4 = string.substring(n + 1, n2 - 1);
                cArray[n] = 34;
                n2 = n + 1;
            } else {
                string4 = string.substring(n + 1, n2);
                n2 = n;
            }
        }
        String string5 = new String(cArray, 0, n2).trim();
        Aladin.trace(4, "Command.execSetCmd(" + string + ") =>plans=[" + string5 + "] " + (string4 != null ? "specif=[" + string4 + "]" : "") + "prop=[" + string3 + "] value=[" + string2 + "]");
        Plan[] planArray = this.getPlan(string5, 2);
        if (string4 != null && planArray.length > 1) {
            String string6 = "set error: only suppport one plane with \"/\" specification";
            this.printConsole("!!! set error: " + string6);
            return string6;
        }
        for (n2 = 0; n2 < planArray.length; ++n2) {
            try {
                planArray[n2].setPropertie(string3, string4, string2);
                continue;
            }
            catch (Exception exception) {
                this.printConsole("!!! set error: " + exception.getMessage());
                return exception.getMessage();
            }
        }
        this.a.calque.repaintAll();
        return "";
    }

    protected String execCM(String string) {
        Plan plan;
        boolean bl = true;
        Vector<Plan> vector = new Vector<Plan>(10);
        String string2 = null;
        boolean bl2 = false;
        Tok tok = new Tok(string);
        while (tok.hasMoreTokens() && (plan = this.getPlanFromParam(string2 = tok.nextToken())) != null) {
            if (!plan.isPixel()) {
                bl = false;
                continue;
            }
            vector.add(plan);
        }
        if (vector.size() == 0 && bl && (plan = this.a.calque.getPlanBase()) != null) {
            vector.add(plan);
        }
        if (vector.size() == 0) {
            return "No image plane";
        }
        StringBuffer stringBuffer = new StringBuffer();
        while (string2 != null) {
            stringBuffer.append(" " + string2);
            if (tok.hasMoreTokens()) {
                string2 = tok.nextToken();
                continue;
            }
            string2 = null;
        }
        string2 = stringBuffer.toString();
        if (string2.length() == 0) {
            string2 = this.a.configuration.get(Configuration.CM);
            if (string2 == null) {
                string2 = "gray reverse autocut";
            }
            string2 = string2 + " all";
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            PlanImage planImage = (PlanImage)enumeration.nextElement();
            bl2 |= planImage.setCmParam(string2);
        }
        if (bl2) {
            this.a.calque.repaintAll();
        }
        return "";
    }

    protected String removeLinks(String string) {
        if (string.indexOf(64) < 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] == '@') continue;
            stringBuffer.append(cArray[i]);
        }
        return stringBuffer.toString();
    }

    private boolean isLetter(char c) {
        return Character.isLetterOrDigit(c) || "+-*/".indexOf(c) >= 0;
    }

    protected String translateLinks(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " |\t\n\r\f", true);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.startsWith("@")) {
                int n;
                for (n = 1; n < string2.length() && this.isLetter(string2.charAt(n)); ++n) {
                }
                String string3 = string2.substring(1, n);
                String string4 = string2.substring(n, string2.length());
                stringBuffer.append("<A HREF=\"#" + string3 + "\">" + string3 + "</A>" + string4);
                continue;
            }
            if (string2.startsWith("_") && string2.endsWith("_")) {
                String string5 = string2.substring(1, string2.length() - 1);
                stringBuffer.append("<B><FONT SIZE=\"+2\" COLOR=\"darkgreen\">" + string5 + "</FONT></B>");
                continue;
            }
            if (string2.startsWith("#") && string2.endsWith("#")) {
                String string6 = string2.substring(1, string2.length() - 1);
                stringBuffer.append("<B>" + string6 + "</B>");
                continue;
            }
            if (string2.startsWith("\\")) {
                String string7 = string2.substring(1, string2.length());
                stringBuffer.append(string7);
                continue;
            }
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    protected void execROICmd(String string) {
        try {
            if (string.length() == 0) {
                this.a.view.createROI();
            } else if (!Character.isDigit(string.charAt(string.length() - 1))) {
                double d = Server.getRM(string.substring(0, string.length() - 1));
                this.a.view.createROI(d / 60.0);
            } else {
                int n = Integer.parseInt(string);
                this.a.view.createROI(n);
            }
        }
        catch (Exception exception) {
            if (Aladin.levelTrace >= 3) {
                exception.printStackTrace();
            }
            this.printConsole("!!! thumbnail error: " + exception.getMessage());
        }
    }

    protected String execXMatchCmd(String string, String string2) {
        Object object;
        int n;
        int n2;
        String string3;
        String[] stringArray = Util.split(string, " ", '(', ')');
        int n3 = stringArray.length;
        int n4 = 1;
        double d = -1.0;
        int n5 = 1;
        Plan plan = null;
        Plan plan2 = null;
        String string4 = null;
        String string5 = null;
        if (n4 < n3) {
            string3 = stringArray[n4++];
            n2 = string3.indexOf(40);
            n = string3.lastIndexOf(41);
            if (n2 >= 0 && n >= 0) {
                string5 = string3.substring(n2 + 1, n);
                plan = this.getNumber(string3.substring(0, n2));
            } else {
                plan = this.getNumber(string3);
            }
        }
        if (n4 < n3) {
            string3 = stringArray[n4++];
            n2 = string3.indexOf(40);
            n = string3.lastIndexOf(41);
            if (n2 >= 0 && n >= 0) {
                string4 = string3.substring(n2 + 1, n);
                plan2 = this.getNumber(string3.substring(0, n2));
            } else {
                plan2 = this.getNumber(string3);
            }
        }
        if (n4 < n3) {
            try {
                d = Double.valueOf(stringArray[n4++]);
            }
            catch (NumberFormatException numberFormatException) {
                d = -1.0;
            }
        } else {
            d = 4.0;
        }
        if (n4 < n3) {
            if (((String)(object = stringArray[n4++])).equalsIgnoreCase("allmatch")) {
                n5 = 2;
            } else if (((String)object).equalsIgnoreCase("bestmatch")) {
                n5 = 1;
            } else if (((String)object).equalsIgnoreCase("nomatch")) {
                n5 = 4;
            } else {
                this.printConsole("!!! xmatch error: parameter " + (String)object + " was not recognized !");
                this.println("Allowed modes are : allmatch|bestmatch|nomatch");
                return "";
            }
        }
        if (plan == null || plan2 == null || d < 0.0) {
            this.printConsole("!!! xmatch error: missing or incorrect parameters");
        } else {
            if (!(plan instanceof PlanCatalog) || !(plan2 instanceof PlanCatalog)) {
                this.printConsole("!!! xmatch error: can only be performed on catalog planes !");
                return "";
            }
            object = new CDSXMatch(this.a);
            int[] nArray = null;
            int[] nArray2 = null;
            if (string5 != null) {
                nArray2 = this.getCoordIdx((PlanCatalog)plan, string5);
            }
            if (string4 != null) {
                nArray = this.getCoordIdx((PlanCatalog)plan2, string4);
            }
            ((CDSXMatch)object).setColFilter(null);
            ((CDSXMatch)object).posXMatch(plan, plan2, string2, nArray2, nArray, new double[]{0.0, d}, n5, this.a, true);
        }
        return "";
    }

    private int[] getCoordIdx(PlanCatalog planCatalog, String string) {
        String[] stringArray = Util.split(string, ",", ' ', ' ', true);
        if (stringArray.length < 2) {
            this.printConsole("!!! xmatch error: there should be 2 coordinate columns !");
            return null;
        }
        int n = -1;
        int n2 = -1;
        try {
            Field[] fieldArray = planCatalog.getFirstLegende().field;
            for (int i = 0; i < fieldArray.length && (n2 < 0 || n < 0); ++i) {
                if (fieldArray[i].name.equals(stringArray[0])) {
                    n2 = i;
                    continue;
                }
                if (!fieldArray[i].name.equals(stringArray[1])) continue;
                n = i;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        if (n2 < 0 || n < 0) {
            this.printConsole("!!! xmatch error: could not find coordinate columns " + string + " for plane " + planCatalog.getLabel());
            this.println("Cross-match will be performed using coordinate columns found by UCD !");
            return null;
        }
        return new int[]{n2, n};
    }

    protected void execHelpCmd(String string) {
        this.execHelpCmd(string, true);
    }

    protected void execHelpCmd(String string, boolean bl) {
        if (string.length() == 0) {
            if (bl) {
                this.a.log("Help", "script command");
                this.a.cardView.show(this.a.bigView, "Help");
                this.a.inScriptHelp = true;
                if (this.a.msgOn) {
                    this.a.msgOn = false;
                }
                this.a.help.setHyperText("", "|!Aladin script commands." + this.execHelp());
            }
            this.println(this.removeLinks(this.execHelp()));
            return;
        }
        if (string.equals("off")) {
            this.a.cardView.show(this.a.bigView, "View");
            this.a.inScriptHelp = false;
        } else if (string.equals("all")) {
            this.execAllHelp();
        } else if (string.equals("allhtml")) {
            this.execHTMLHelp();
        } else {
            String string2 = this.getHelpString(string);
            if (string2.length() == 0) {
                return;
            }
            this.println(this.removeLinks(string2));
            if (bl) {
                this.a.inScriptHelp = true;
                this.a.cardView.show(this.a.bigView, "Help");
                this.a.help.setHyperText(string.charAt(0) == '#' ? null : string, "|" + string2);
            }
        }
    }

    private void execAllHelp() {
        this.println(this.removeLinks(this.execHelp()));
        for (int i = 0; i < CMD.length; ++i) {
            this.println("----");
            this.println(this.removeLinks(this.getHelpString(CMD[i])));
        }
    }

    private void execHTMLHelp() {
        this.println("<PRE>\n" + this.translateLinks(this.execHelp()) + "</PRE>\n");
        for (int i = 0; i < CMD.length; ++i) {
            this.println("<P><HR><A NAME=\"" + CMD[i] + "\"></A>");
            this.println(this.translateLinks(this.getHelpStringHTML(CMD[i])));
        }
    }

    private String getHelpString(String string) {
        Object object;
        String string2;
        if (string.charAt(0) == '#') {
            string2 = string;
        } else {
            object = "Help." + Util.toLower(string);
            string2 = Aladin.chaine.getString((String)object);
            if (string2.length() == 0 || string2.equals("[" + (String)object + "]")) {
                this.printConsole("!!! help error: command \"" + string + "\" unknown !");
                return "";
            }
        }
        object = new StringTokenizer(string2, "#");
        String string3 = "   ";
        StringBuffer stringBuffer = new StringBuffer();
        char c = ' ';
        while (((StringTokenizer)object).hasMoreTokens()) {
            string2 = ((StringTokenizer)object).nextToken();
            if (string2.length() < 2) continue;
            char c2 = string2.charAt(0);
            string2 = string2.substring(2);
            if (c2 != c) {
                stringBuffer.append(" \n" + (c2 == 'n' ? " \n \n \n#NAME#" : (c2 == 's' ? "#SYNOPSIS#" : (c2 == 'd' ? "#DESCRIPTION#" : (c2 == 'e' ? "#EXAMPLE#" : (c2 == 't' ? "#NOTES#" : (c2 == 'g' ? "#SEE# #ALSO#" : "")))))) + "\n");
            }
            c = c2;
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "\n");
            while (stringTokenizer.hasMoreTokens()) {
                StringBuffer stringBuffer2 = new StringBuffer(string3.toString());
                StringTokenizer stringTokenizer2 = new StringTokenizer(stringTokenizer.nextToken(), " ", true);
                String string4 = null;
                while (string4 != null || stringTokenizer2.hasMoreTokens()) {
                    if (string4 == null) {
                        string4 = stringTokenizer2.nextToken();
                    }
                    if (stringBuffer2.length() + string4.length() > 78) {
                        stringBuffer.append(stringBuffer2 + "\n");
                        stringBuffer2 = new StringBuffer(string3.toString());
                    }
                    stringBuffer2.append(string4);
                    string4 = null;
                }
                if (stringBuffer2.length() <= string3.length()) continue;
                stringBuffer.append(stringBuffer2 + "\n");
            }
        }
        return stringBuffer.toString();
    }

    private String getHelpStringHTML(String string) {
        Object object;
        String string2;
        if (string.charAt(0) == '#') {
            string2 = string;
        } else {
            object = "Help." + Util.toLower(string);
            string2 = Aladin.chaine.getString((String)object);
            if (string2.length() == 0 || string2.equals("[" + (String)object + "]")) {
                this.printConsole("!!! help error: command \"" + string + "\" unknown !");
                return "";
            }
        }
        object = new StringTokenizer(string2, "#");
        String string3 = "   ";
        StringBuffer stringBuffer = new StringBuffer();
        char c = ' ';
        while (((StringTokenizer)object).hasMoreTokens()) {
            string2 = ((StringTokenizer)object).nextToken();
            if (string2.length() < 2) continue;
            char c2 = string2.charAt(0);
            string2 = string2.substring(2);
            if (c2 != c) {
                stringBuffer.append("<P>\n" + (c2 == 'n' ? "" : (c2 == 's' ? "<P><I><B>Synopsis</B></I>:<BR>" : (c2 == 'd' ? "<P><I><B>Description</B></I><BR>" : (c2 == 'e' ? "<P><I><B>Example</B></I>:<BR>" : (c2 == 't' ? "<P><I><B>Note</B></I> - " : (c2 == 'g' ? "<P><I><B>See also</B></I>: " : "")))))) + "\n");
            } else {
                stringBuffer.append("<BR>\n");
            }
            c = c2;
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    protected boolean execHpxCmd(String string) {
        try {
            int n = string.indexOf(47);
            if (n == -1) {
                return false;
            }
            int n2 = Integer.parseInt(string.substring(0, n).trim());
            int n3 = Integer.parseInt(string.substring(n + 1).trim());
            long l = CDSHealpix.pow2(n2);
            double[] dArray = CDSHealpix.polarToRadec(CDSHealpix.pix2ang_nest(l, n3));
            Coord coord = new Coord(dArray[0], dArray[1]);
            Localisation cfr_ignored_0 = this.a.localisation;
            Localisation.frameToFrame(coord, this.a.localisation.getFrameGeneric(), 0);
            this.a.view.setRepere(coord);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected void execSelectCmd(String string) {
        if (string.trim().equals("-tag")) {
            this.a.selecttag();
            return;
        }
        int n = this.a.view.getCurrentNumView();
        int n2 = -1;
        int n3 = -1;
        boolean bl = true;
        Tok tok = new Tok(string);
        while (tok.hasMoreTokens()) {
            String string2 = tok.nextToken();
            if (Util.indexOfIgnoreCase(string2, "frame=") == 0) {
                try {
                    double d = Double.parseDouble(string2.substring(6)) - 1.0;
                    if (n3 >= 0) {
                        int[] nArray = this.a.view.getNumView(this.a.calque.getPlan(n3));
                        for (int i = 0; i < nArray.length; ++i) {
                            if (this.a.view.viewSimple[nArray[i]].cubeControl == null) continue;
                            this.a.view.viewSimple[nArray[i]].cubeControl.setFrameLevel(d);
                            this.a.view.viewSimple[nArray[i]].repaint();
                        }
                    } else if (n2 >= 0) {
                        if (this.a.view.viewSimple[n2].cubeControl == null) continue;
                        this.a.view.viewSimple[n2].cubeControl.setFrameLevel(d);
                        this.a.view.viewSimple[n2].repaint();
                    } else {
                        ViewSimple[] viewSimpleArray = this.a.view.getSelectedView();
                        for (int i = 0; i < viewSimpleArray.length; ++i) {
                            if (viewSimpleArray[i].cubeControl == null) continue;
                            viewSimpleArray[i].cubeControl.setFrameLevel(d);
                            viewSimpleArray[i].repaint();
                        }
                    }
                }
                catch (Exception exception) {
                    this.printConsole("!!! select cube frame error: " + exception.getMessage());
                }
                return;
            }
            if (bl) {
                bl = false;
                this.a.view.unSelectAllView();
                this.a.view.deSelect();
                this.a.calque.unSelectAllPlan();
            }
            Plan plan = this.getNumber(string2, 1, false, false);
            n2 = this.getViewNumber(string2, false);
            if (n2 >= 0) {
                this.a.view.selectView(n2);
                this.a.view.setCurrentNumView(n2);
                n = -1;
                continue;
            }
            if (plan == null) continue;
            plan.selected = true;
            n2 = this.a.view.selectView(plan);
            if (n != -1 && n2 != -1) {
                this.a.view.setCurrentNumView(n2);
                n = -1;
            }
            if (!plan.isCatalog() && plan.type != 9) continue;
            this.a.view.selectAllInPlanWithoutFree(plan, 0);
            this.a.mesure.mcanvas.repaint();
        }
        if (n >= 0) {
            this.a.view.selectView(n);
            this.a.view.setCurrentNumView(n);
        }
        this.a.calque.repaintAll();
    }

    protected void execFlipFlop(String string, String string2) {
        char[] cArray = string.toCharArray();
        int n = 0;
        String string3 = null;
        int n2 = 0;
        if (cArray.length > 0) {
            for (n = cArray.length - 1; n > 0 && Character.isSpaceChar(cArray[n]); --n) {
            }
            int n3 = n + 1;
            while (n > 0 && !Character.isSpaceChar(cArray[n])) {
                --n;
            }
            if (Character.isSpaceChar(cArray[n])) {
                ++n;
            }
            string3 = string.substring(n, n3);
        }
        if (string3 != null && string3.length() != 0) {
            if (string3.equalsIgnoreCase("H")) {
                n2 = 1;
            } else if (string3.equalsIgnoreCase("VH") || string3.equalsIgnoreCase("HV")) {
                n2 = 2;
            }
        } else {
            n = cArray.length;
        }
        Plan[] planArray = this.getPlan(string.substring(0, n).trim(), 1);
        if (planArray.length == 0) {
            planArray = new Plan[]{this.a.calque.getPlanBase()};
        }
        if (string2 != null) {
            try {
                planArray[0] = this.a.calque.dupPlan((PlanImage)planArray[0], string2, planArray[0].type, false);
            }
            catch (Exception exception) {
                this.printConsole("!!! fliflop error: " + exception.getMessage());
                return;
            }
        }
        try {
            this.a.view.flip((PlanImage)planArray[0], n2);
        }
        catch (Exception exception) {
            this.printConsole("!!! fliflop error: " + exception.getMessage());
        }
    }

    protected void execMatchCmd(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        int n = 3;
        String string2 = "";
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (string3.equalsIgnoreCase("-scale")) {
                n = 2;
                continue;
            }
            if (string3.equalsIgnoreCase("off")) {
                n = 0;
                continue;
            }
            string2 = string3;
            break;
        }
        if (string2.length() > 0) {
            this.execSelectCmd(string2);
        }
        if (n == 0) {
            if (this.a.view.isSelectCompatibleViews()) {
                this.a.view.unselectViewsPartial();
            }
            this.a.match(0);
        } else {
            this.a.switchMatch(n == 3);
        }
    }

    protected void execCcatCmd(String string, String string2, String string3) {
        block17: {
            boolean bl;
            boolean bl2;
            int n = string2.indexOf("-uniq");
            boolean bl3 = bl2 = n >= 0;
            if (bl2) {
                string2 = string2.replace("-uniq", "").trim();
            }
            boolean bl4 = bl = (n = string2.indexOf("-out")) < 0;
            if (!bl) {
                string2 = string2.replace("-out", "").trim();
            }
            if (string.equalsIgnoreCase("cplane") && string2.trim().length() > 0) {
                string3 = "=" + string2;
                string2 = "";
            }
            if (string2.length() == 0) {
                this.a.calque.newPlanCatalogBySelectedObjet(string3, bl2);
                this.a.calque.repaintAll();
                return;
            }
            Plan[] planArray = this.getPlan(string2, 2);
            PlanMoc planMoc = null;
            ArrayList<Plan> arrayList = new ArrayList<Plan>();
            for (Plan plan : planArray) {
                if (plan.pcat != null) {
                    arrayList.add(plan);
                    continue;
                }
                if (plan instanceof PlanMoc) {
                    if (planMoc != null) {
                        this.printConsole("!!! execCatCmd error: only one MOC is authorized");
                        return;
                    }
                    planMoc = (PlanMoc)plan;
                    continue;
                }
                this.printConsole("!!! execCatCmd error: uncompatible catalog plane [" + plan.label + "]");
                return;
            }
            planArray = new Plan[arrayList.size()];
            arrayList.toArray(planArray);
            if (planMoc == null) {
                try {
                    this.a.calque.newPlanCatalogByCatalogs(planArray, bl2, string3);
                }
                catch (Exception exception) {
                    this.printConsole("!!! execCatCmd error: MocFiltering error");
                    if (Aladin.levelTrace >= 3) {
                        exception.printStackTrace();
                    }
                    break block17;
                }
            }
            if (planArray.length == 0) {
                PlanCatalog exception = this.a.calque.newPlanCatalogBySources(this.a.view.getSelectedObjet(), null, bl2);
                planArray = new Plan[]{exception};
            }
            if (this.a.frameMocFiltering == null) {
                this.a.frameMocFiltering = new FrameMocFiltering(this.a);
            }
            try {
                PlanCatalog planCatalog = this.a.frameMocFiltering.createPlane(string3, planMoc, planArray, bl);
                if (bl2 && planArray.length > 1) {
                    planArray = new Plan[]{planCatalog};
                    this.a.calque.newPlanCatalogByCatalogs(planArray, bl2, string3);
                }
            }
            catch (Exception exception) {
                this.printConsole("!!! execCatCmd error: MocFiltering error");
                if (Aladin.levelTrace < 3) break block17;
                exception.printStackTrace();
            }
        }
        this.a.calque.repaintAll();
    }

    protected String execCmocCmd(String string, String string2) {
        try {
            int n;
            String string3;
            Plan[] planArray;
            int n2;
            int n3;
            int n4 = -1;
            double d = 0.0;
            double d2 = Double.NaN;
            double d3 = Double.NaN;
            double d4 = Double.NaN;
            int n5 = 0;
            if (n3 >= 0) {
                n2 = n3 + 7;
                for (n3 = string.indexOf("-order="); n3 < string.length() && !Character.isSpace(string.charAt(n3)); ++n3) {
                }
                n4 = Integer.parseInt(string.substring(n2, n3));
                String string4 = string = n3 == string.length() ? "" : string.substring(n3).trim();
            }
            if ((n3 = string.indexOf("-threshold=")) >= 0) {
                n2 = n3 + 12;
                while (n3 < string.length() && !Character.isSpace(string.charAt(n3))) {
                    ++n3;
                }
                d2 = Double.parseDouble(string.substring(n2, n3));
                String string5 = string = n3 == string.length() ? "" : string.substring(n3).trim();
            }
            if ((n3 = string.indexOf("-radius=")) >= 0) {
                n2 = n3 + 8;
                while (n3 < string.length() && !Character.isSpace(string.charAt(n3))) {
                    ++n3;
                }
                d = Server.getAngleInArcmin(string.substring(n2, n3), 16);
                String string6 = string = n3 == string.length() ? "" : string.substring(n3).trim();
            }
            if ((n3 = string.indexOf("-pixelCut=")) >= 0) {
                n2 = n3 + 10;
                while (n3 < string.length() && !Character.isSpace(string.charAt(n3))) {
                    ++n3;
                }
                while (n3 < string.length() && Character.isSpace(string.charAt(n3))) {
                    ++n3;
                }
                while (n3 < string.length() && !Character.isSpace(string.charAt(n3))) {
                    ++n3;
                }
                planArray = Tok.unQuote(string.substring(n2, n3));
                Tok tok = new Tok((String)planArray);
                try {
                    d3 = Double.parseDouble(tok.nextToken());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    d4 = Double.parseDouble(tok.nextToken());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                String string7 = string = n3 == string.length() ? "" : string.substring(n3).trim();
            }
            if ((n3 = string.indexOf(32)) < 0) {
                n3 = string.length();
            }
            if ((string3 = string.substring(0, n3)).startsWith("-") && (n5 = PlanMocAlgo.getOp(string3)) > 0) {
                string = string.substring(n3);
            }
            planArray = this.getPlan(string, 2);
            int n6 = -1;
            if (planArray.length > 0) {
                this.a.view.deSelect();
                Plan[] planArray2 = planArray;
                int n7 = planArray2.length;
                for (n = 0; n < n7; ++n) {
                    Plan plan = planArray2[n];
                    if (n6 == -1) {
                        n6 = plan.type;
                    }
                    if (plan.type != n6) {
                        throw new Exception("mixed source plane types are not authorized");
                    }
                    if (plan.type != 9) continue;
                    this.a.view.selectAllInPlanWithoutFree(plan, 0);
                }
            }
            if (n6 == -1 || n6 == 9) {
                int n8 = this.a.createMocRegion(n4);
                Plan plan = this.a.calque.getPlan(n8);
                if (string2 != null) {
                    plan.setLabel(string2);
                }
            } else if (n6 == 19) {
                boolean bl = n4 == -1;
                PlanMoc[] planMocArray = new PlanMoc[planArray.length];
                for (n = 0; n < planArray.length; ++n) {
                    planMocArray[n] = (PlanMoc)planArray[n];
                    if (!bl || planMocArray[n].getMocOrder() <= n4) continue;
                    n4 = planMocArray[n].getMocOrder();
                }
                this.a.calque.newPlanMoc(string2, planMocArray, n5, n4);
            } else if (!Double.isNaN(d2) && n6 == 16) {
                this.a.calque.newPlanMoc(string2, planArray, n4, 0.0, Double.NaN, Double.NaN, d2);
            } else {
                if (n4 == -1) {
                    n4 = 13;
                }
                this.a.calque.newPlanMoc(string2, planArray, n4, d, d3, d4, Double.NaN);
            }
            this.a.calque.repaintAll();
            return "";
        }
        catch (Exception exception) {
            if (Aladin.levelTrace >= 3) {
                exception.printStackTrace();
            }
            return exception.getMessage() != null ? "cmoc error: " + exception.getMessage() : "cmoc error";
        }
    }

    protected Plan execCropCmd(String string, String string2) {
        int n;
        int n2;
        char[] cArray = string.toCharArray();
        String string3 = null;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 50.0;
        double d4 = 50.0;
        Coord coord = null;
        boolean bl = false;
        try {
            for (n2 = cArray.length - 1; n2 > 0 && Character.isSpaceChar(cArray[n2]); --n2) {
            }
            n = n2 + 1;
            while (n2 > 0 && !Character.isSpaceChar(cArray[n2])) {
                --n2;
            }
            String string4 = string.substring(Character.isSpaceChar(cArray[n2]) ? n2 + 1 : n2, n);
            n = string4.indexOf(120);
            if (n < 0) {
                throw new Exception();
            }
            d3 = Double.parseDouble(string4.substring(0, n));
            d4 = Double.parseDouble(string4.substring(n + 1));
            bl = true;
        }
        catch (Exception exception) {
            n2 = cArray.length - 1;
        }
        while (n2 > 0 && Character.isSpaceChar(cArray[n2])) {
            --n2;
        }
        n = n2 > 0 && !Character.isSpaceChar(cArray[n2]) ? n2 + 1 : n2;
        boolean bl2 = false;
        while (n2 > 0 && !Character.isSpaceChar(cArray[n2])) {
            if (cArray[n2] == ',') {
                bl2 = true;
            }
            --n2;
        }
        if (bl2) {
            string3 = string.substring(Character.isSpaceChar(cArray[n2]) ? n2 + 1 : n2, n);
            n = string3.indexOf(44);
            d = Double.parseDouble(string3.substring(0, n));
            d2 = Double.parseDouble(string3.substring(n + 1));
            n = n2;
        }
        PlanImage planImage = null;
        try {
            planImage = (PlanImage)this.getPlan(string.substring(0, n), 1)[0];
            if (planImage == null) {
                throw new Exception();
            }
        }
        catch (Exception exception) {
            planImage = (PlanImage)this.a.calque.getPlanBase();
        }
        ViewSimple viewSimple = this.a.view.getView(planImage);
        if (planImage instanceof PlanBG && (!planImage.active || !planImage.ref && planImage.getOpacityLevel() == 0.0f)) {
            Aladin.warning("crop error: HiPS plane [" + planImage.label + "] must be visible to be cropped!", 1);
            System.err.println("crop error: HiPS plane [" + planImage.label + "] must be visible to be cropped!");
            return null;
        }
        if (!bl) {
            try {
                if (planImage instanceof PlanBG) {
                    d3 = viewSimple.rv.width;
                    d4 = viewSimple.rv.height;
                } else {
                    d3 = viewSimple.rzoom.width;
                    d4 = viewSimple.rzoom.height;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (planImage instanceof PlanBG) {
            d3 /= viewSimple.zoom;
            d4 /= viewSimple.zoom;
        }
        if (!bl2) {
            try {
                coord = planImage instanceof PlanBG ? viewSimple.getCooCentre() : new Coord(this.a.view.repere.raj, this.a.view.repere.dej);
                planImage.projd.getXY(coord);
                d = coord.x - d3 / 2.0;
                d2 = coord.y - d4 / 2.0;
                d2 = (double)planImage.naxis2 - (d2 + d4);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                d = viewSimple.rzoom.x;
                d2 = viewSimple.rzoom.y;
            }
        }
        Aladin.trace(4, "Command.crop: on " + viewSimple + " param=[" + string + "] label=" + string2 + " " + d + "," + d2 + (bl2 ? "(provided) " : " (" + coord + " on reticle) ") + d3 + "x" + d4 + (bl ? "( provided)" : "(view size)"));
        if (viewSimple.cropArea(new RectangleD(d, (double)planImage.naxis2 - (d2 + d4), d3, d4), string2, viewSimple.zoom, 1.0, true, false) == null) {
            Aladin.warning("crop error: view [" + viewSimple + "] not usable!", 1);
            System.err.println("crop error: view [" + viewSimple + "] not usable!");
            return null;
        }
        this.setSyncNeedRepaint(true);
        this.a.view.repaintAll();
        return planImage;
    }

    protected void setDrawMode(int n) {
        drawMode = n;
    }

    private Color getSpecifColor(String string, Tok tok) {
        Color color;
        if (string.equalsIgnoreCase("rgb")) {
            String string2 = tok.nextToken();
            String string3 = tok.nextToken();
            String string4 = tok.nextToken();
            string = string + "(" + string2 + "," + string3 + "," + string4 + ")";
            color = Action.getColor(string);
        } else {
            color = Action.getColor(string);
        }
        return color;
    }

    public void resetPreviousDrawing() {
        this.oPlan = null;
    }

    protected boolean execDrawCmd(String string, String string2) {
        Color color;
        Position position;
        Plan plan;
        block88: {
            plan = null;
            position = null;
            Coord coord = null;
            double d = 0.0;
            double d2 = 0.0;
            color = null;
            Tok tok = new Tok(string2, "(, )");
            String string3 = tok.nextToken();
            color = this.getSpecifColor(string3, tok);
            if (color != null) {
                string3 = tok.nextToken();
            }
            if (string3.equalsIgnoreCase("moc")) {
                String string4;
                int n = string2.indexOf(40);
                int n2 = string2.lastIndexOf(41);
                if (n > 0 && n < n2) {
                    string4 = string2.substring(n + 1, n2);
                } else {
                    n = string2.indexOf(32);
                    string4 = string2.substring(n + 1);
                }
                try {
                    HealpixMoc healpixMoc = new HealpixMoc(string4);
                    Plan plan2 = this.a.calque.getPlan(this.a.calque.newPlanMOC(healpixMoc, "Moc"));
                    if (color != null) {
                        plan2.c = color;
                    }
                    return true;
                }
                catch (Exception exception) {
                    this.printConsole("!!! draw moc error: syntax error [" + string4 + "]");
                    return false;
                }
            }
            String[] stringArray = new String[tok.countTokens()];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = tok.nextToken();
            }
            int n = 500;
            PlanImage planImage = (PlanImage)this.a.calque.getPlanBase();
            if (planImage != null) {
                n = planImage.naxis2;
            }
            if (string3.equalsIgnoreCase("mode")) {
                if (stringArray[0].equalsIgnoreCase("xy")) {
                    drawMode = DRAWXY;
                } else if (stringArray[0].equalsIgnoreCase("radec")) {
                    drawMode = DRAWRADEC;
                } else {
                    this.printConsole("!!! draw error: mode param (" + stringArray[0] + ") unknown");
                    return false;
                }
                this.console("Draw mode: " + (drawMode == DRAWXY ? "XY coordinates" : "celestial coordinates"));
                return true;
            }
            if (string3.equalsIgnoreCase("global")) {
                this.memoGlobal(stringArray);
                return true;
            }
            if (string3.equalsIgnoreCase("newtool")) {
                String string5 = null;
                if (stringArray.length > 0) {
                    string5 = stringArray[0];
                }
                this.oPlan = plan = this.a.calque.createPlanTool(string5);
                if (this.globalColor != null) {
                    plan.c = this.globalColor;
                }
                return true;
            }
            try {
                if (string3.equalsIgnoreCase("newfov")) {
                    if (drawMode == DRAWRADEC) {
                        coord = new Coord(stringArray[0] + " " + stringArray[1]);
                        coord = this.a.localisation.frameToICRS(coord);
                    } else {
                        coord = new Coord();
                        coord.x = this.parseDouble(stringArray[0]) - 0.5;
                        coord.y = (double)n - this.parseDouble(stringArray[1]) + 0.5;
                        this.a.view.getCurrentView().getProj().getCoord(coord);
                    }
                    double d3 = stringArray.length < 3 ? 0.0 : this.parseDouble(stringArray[2]);
                    String string6 = stringArray.length >= 4 ? stringArray[3] : null;
                    this.oPlan = plan = this.a.calque.createPlanField(string6, coord, d3, true, true);
                    if (this.globalColor != null) {
                        plan.c = this.globalColor;
                    }
                    this.flagFoV = true;
                    return true;
                }
            }
            catch (Exception exception) {
                this.printConsole("!!! draw error: " + exception.getMessage());
                if (Aladin.levelTrace != 0) {
                    exception.printStackTrace();
                }
                return false;
            }
            if (this.oPlan != null && this.oPlan.type != 10 && this.flagFoV) {
                this.oPlan = null;
            }
            plan = this.oPlan != null && this.a.calque.planToolOk(this.oPlan, this.flagFoV) ? this.oPlan : (this.flagFoV ? this.a.calque.selectPlanToolOrFoV() : this.a.calque.selectPlanTool());
            this.oPlan = plan;
            if (this.globalColor != null) {
                if (this.globalColor != plan.c && plan.type == 9 && plan.getCounts() > 0) {
                    plan = this.a.calque.createPlanTool(null);
                }
                plan.c = this.globalColor;
            }
            if (drawMode == DRAWRADEC) {
                plan.setXYorig(false);
            }
            try {
                if (drawMode == DRAWRADEC) {
                    if (stringArray[0].equals("-") && stringArray[1].equals("-")) {
                        coord = this.a.localisation.getLastCoord();
                    } else {
                        coord = new Coord(stringArray[0] + " " + stringArray[1]);
                        coord = this.a.localisation.frameToICRS(coord);
                    }
                } else {
                    d = this.parseDouble(stringArray[0]) - 0.5;
                    d2 = (double)n - this.parseDouble(stringArray[1]) + 0.5;
                }
                if (string3.equalsIgnoreCase("string")) {
                    Tag tag;
                    position = drawMode == DRAWRADEC ? (tag = new Tag(plan, coord, stringArray[2])) : (tag = new Tag(plan, this.a.view.getCurrentView(), d, d2, stringArray[2]));
                    tag.setDist(5);
                    tag.setAngle(0);
                    tag.setPole("nopole");
                    break block88;
                }
                if (string3.equalsIgnoreCase("tag") || string3.equalsIgnoreCase("string")) {
                    Tag tag;
                    String string7 = stringArray.length < 3 ? null : stringArray[2];
                    position = drawMode == DRAWRADEC ? (tag = new Tag(plan, coord, string7)) : (tag = new Tag(plan, this.a.view.getCurrentView(), d, d2, string7));
                    try {
                        if (stringArray.length > 3) {
                            tag.setDist((int)this.parseDouble(stringArray[3]));
                        }
                        if (stringArray.length > 4) {
                            tag.setAngle((int)this.parseDouble(stringArray[4]));
                        }
                        if (stringArray.length > 5) {
                            tag.setPole(stringArray[5]);
                        }
                        if (stringArray.length > 6) {
                            tag.setFontSize((int)this.parseDouble(stringArray[6]));
                        }
                        break block88;
                    }
                    catch (Exception exception) {
                        this.printConsole("!!! draw tag error: usage: draw tag(x,y[,label,dist,angle,pole,fontSize])");
                        return false;
                    }
                }
                if (string3.equalsIgnoreCase("phot")) {
                    ViewSimple viewSimple = this.a.view.getCurrentView();
                    try {
                        SourceStat sourceStat;
                        if (drawMode == DRAWRADEC) {
                            sourceStat = new SourceStat(plan, viewSimple, coord, null);
                            position = sourceStat;
                            sourceStat.setRadius(stringArray[2]);
                        } else {
                            sourceStat = new SourceStat(plan, viewSimple, d, d2, null);
                            position = sourceStat;
                            sourceStat.setRayon(viewSimple, this.parseDouble(stringArray[2]));
                        }
                        sourceStat.setLocked(true);
                        break block88;
                    }
                    catch (Exception exception) {
                        this.printConsole("!!! draw phot error: usage: draw phot(x,y,radius)");
                        return false;
                    }
                }
                if (string3.equalsIgnoreCase("circle")) {
                    if (drawMode == DRAWRADEC) {
                        double d4 = Server.getAngleInArcmin(stringArray[2], 8) / 60.0;
                        position = new Cercle(plan, coord, d4);
                    } else {
                        double d5 = this.parseDouble(stringArray[2]);
                        position = new Cercle(plan, this.a.view.getCurrentView(), d, d2, d5);
                    }
                    break block88;
                }
                if (string3.equalsIgnoreCase("ellipse")) {
                    double d6 = this.parseDouble(stringArray[4]);
                    if (drawMode == DRAWRADEC) {
                        double d7 = Server.getAngleInArcmin(stringArray[2], 8) / 60.0;
                        double d8 = Server.getAngleInArcmin(stringArray[3], 8) / 60.0;
                        position = new Ellipse(plan, coord, d7, d8, d6);
                    } else {
                        double d9 = this.parseDouble(stringArray[2]);
                        double d10 = this.parseDouble(stringArray[3]);
                        position = new Ellipse(plan, this.a.view.getCurrentView(), d, d2, d9, d10, d6);
                    }
                    break block88;
                }
                if (string3.equalsIgnoreCase("box")) {
                    double d11 = 0.0;
                    String string8 = null;
                    try {
                        d11 = this.parseDouble(stringArray[4]);
                    }
                    catch (Exception exception) {
                        try {
                            string8 = stringArray[4];
                        }
                        catch (Exception exception2) {
                            // empty catch block
                        }
                    }
                    if (string8 == null) {
                        try {
                            string8 = stringArray[5];
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (drawMode == DRAWRADEC) {
                        double d12 = Server.getAngleInArcmin(stringArray[2], 8) / 60.0;
                        double d13 = Server.getAngleInArcmin(stringArray[3], 8) / 60.0;
                        position = new Box(plan, coord, d12, d13, d11, string8);
                    } else {
                        double d14 = this.parseDouble(stringArray[2]);
                        double d15 = this.parseDouble(stringArray[3]);
                        position = new Box(plan, this.a.view.getCurrentView(), d, d2, d14, d15, d11, string8);
                    }
                    break block88;
                }
                if (string3.equalsIgnoreCase("vector")) {
                    double d16 = this.parseDouble(stringArray[3]);
                    if (drawMode == DRAWRADEC) {
                        double d17 = Server.getAngleInArcmin(stringArray[2], 8) / 60.0;
                        position = new Vecteur(plan, coord, d17, d16);
                    } else {
                        double d18 = this.parseDouble(stringArray[2]);
                        position = new Vecteur(plan, this.a.view.getCurrentView(), d, d2, d18, d16);
                    }
                    break block88;
                }
                if (string3.equalsIgnoreCase("arc")) {
                    double d19 = this.parseDouble(stringArray[3]);
                    double d20 = this.parseDouble(stringArray[4]);
                    if (drawMode == DRAWRADEC) {
                        double d21 = Server.getAngleInArcmin(stringArray[2], 8) / 60.0;
                        position = new Arc(plan, coord, d21, d19, d20);
                    } else {
                        double d22 = this.parseDouble(stringArray[2]);
                        position = new Arc(plan, this.a.view.getCurrentView(), d, d2, d22, d19, d20);
                    }
                    break block88;
                }
                if (string3.equalsIgnoreCase("pickle")) {
                    double d23 = this.parseDouble(stringArray[4]);
                    double d24 = this.parseDouble(stringArray[5]);
                    if (drawMode == DRAWRADEC) {
                        double d25 = Server.getAngleInArcmin(stringArray[2], 8) / 60.0;
                        double d26 = Server.getAngleInArcmin(stringArray[3], 8) / 60.0;
                        position = new Pickle(plan, coord, d25, d26, d23, d24);
                    } else {
                        double d27 = this.parseDouble(stringArray[2]);
                        double d28 = this.parseDouble(stringArray[3]);
                        position = new Pickle(plan, this.a.view.getCurrentView(), d, d2, d27, d28, d23, d24);
                    }
                    break block88;
                }
                if (string3.equalsIgnoreCase("line") || string3.equalsIgnoreCase("polygon")) {
                    Ligne ligne;
                    position = null;
                    Ligne ligne2 = null;
                    ViewSimple viewSimple = this.a.view.getCurrentView();
                    String string9 = null;
                    int n3 = stringArray.length;
                    if (n3 % 2 == 1) {
                        string9 = stringArray[n3 - 1];
                        --n3;
                    }
                    for (int i = 0; i < n3; i += 2) {
                        if (drawMode == DRAWRADEC) {
                            coord = new Coord(stringArray[i] + " " + stringArray[i + 1]);
                            coord = this.a.localisation.frameToICRS(coord);
                            ligne = new Ligne(coord.al, coord.del, plan, viewSimple, string9, ligne2);
                        } else {
                            d = this.parseDouble(stringArray[i]) - 0.5;
                            d2 = (double)n - this.parseDouble(stringArray[i + 1]) + 0.5;
                            ligne = new Ligne(plan, viewSimple, d, d2, string9, ligne2);
                        }
                        if (color != null) {
                            ligne.setColor(color);
                        }
                        this.addObj(plan, ligne);
                        ligne2 = ligne;
                    }
                    if (string3.equalsIgnoreCase("polygon")) {
                        ligne = new Ligne(0.0, 0.0, plan, viewSimple, string9, ligne2);
                        position = ligne;
                        ligne.makeLastLigneForClose(viewSimple);
                    }
                    break block88;
                }
                if (string3.equalsIgnoreCase("dist")) {
                    position = null;
                    Cote cote = null;
                    ViewSimple viewSimple = this.a.view.getCurrentView();
                    int n4 = stringArray.length;
                    for (int i = 0; i < n4; i += 2) {
                        Cote cote2;
                        if (drawMode == DRAWRADEC) {
                            coord = new Coord(stringArray[i] + " " + stringArray[i + 1]);
                            coord = this.a.localisation.frameToICRS(coord);
                            cote2 = new Cote(coord.al, coord.del, plan, viewSimple, cote);
                        } else {
                            d = this.parseDouble(stringArray[i]) - 0.5;
                            d2 = (double)n - this.parseDouble(stringArray[i + 1]) + 0.5;
                            cote2 = new Cote(plan, viewSimple, d, d2, cote);
                        }
                        if (color != null) {
                            cote2.setColor(color);
                        }
                        this.addObj(plan, cote2);
                        cote = cote2;
                    }
                    break block88;
                }
                this.printConsole("!!! draw error: function unknown (" + string3 + ")");
                return false;
            }
            catch (Exception exception) {
                this.printConsole("!!! draw error: " + exception.getMessage());
                if (Aladin.levelTrace != 0) {
                    exception.printStackTrace();
                }
                return false;
            }
        }
        if (position != null) {
            if (color != null) {
                ((Obj)position).setColor(color);
            }
            this.addObj(plan, position);
        }
        plan.resetProj();
        this.a.view.repaintAll();
        return true;
    }

    private double parseDouble(String string) throws Exception {
        int n;
        string = string.trim();
        for (n = string.length() - 1; n > 0 && !Character.isDigit(string.charAt(n)); --n) {
        }
        int n2 = string.length() > 0 && string.charAt(0) == '+' ? 1 : 0;
        return Double.parseDouble(string.substring(n2, n + 1));
    }

    private void addObj(Plan plan, Obj obj) {
        plan.pcat.setObjetFast(obj);
        if (plan.type != 10) {
            return;
        }
        ((Position)obj).setXYTan(plan.co);
    }

    private void memoGlobal(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].startsWith("color=")) continue;
            this.globalColor = Action.getColor(stringArray[i].substring(6));
        }
    }

    private void execInfo(String string) {
        this.a.status.setText(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execScriptAsStream(String string) {
        MyByteArrayStream myByteArrayStream = null;
        try {
            myByteArrayStream = new MyByteArrayStream(2000);
            myByteArrayStream.write(string);
            this.readFromStream(myByteArrayStream.getInputStream());
        }
        finally {
            try {
                if (myByteArrayStream != null) {
                    myByteArrayStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public String execScript(String string) {
        return this.execScript(string, true, false);
    }

    public synchronized String execScript(String string, boolean bl, boolean bl2) {
        String[] stringArray = Util.split(string, ";\n\r", '[', ']');
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = null;
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                String string3 = stringArray[i].trim();
                if (string3.length() > 0) {
                    if (n == 0) {
                        string2 = this.exec(string3, bl, bl2);
                        if (string2 == null) {
                            return null;
                        }
                    } else {
                        string2 = this.exec(string3, bl, bl2);
                    }
                }
                if (string2 != null && string2.length() > 0) {
                    if (string2.startsWith("!!!")) {
                        this.printConsole(string2);
                    }
                    stringBuffer.append(string2);
                }
                ++n;
                continue;
            }
            catch (Exception exception) {
                if (Aladin.levelTrace != 3) continue;
                exception.printStackTrace();
            }
        }
        return stringBuffer.toString();
    }

    protected String getLastCmd() {
        return this.lastCmd;
    }

    private int findAlgebre(String string) {
        if (string.startsWith("+")) {
            return 0;
        }
        if (string.startsWith("-")) {
            return 1;
        }
        if (string.startsWith("* ")) {
            return 2;
        }
        if (string.startsWith("/")) {
            return 3;
        }
        if (string.indexOf(" + ") > 0) {
            return 0;
        }
        if (string.indexOf(" - ") > 0) {
            return 1;
        }
        if (string.indexOf(" * ") > 0) {
            return 2;
        }
        if (string.indexOf(" / ") > 0) {
            return 3;
        }
        return -1;
    }

    private boolean findMoc(String string) {
        int n = -1;
        int n2 = -1;
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (n == -1 && cArray[i] == '/') {
                n = i;
                continue;
            }
            if (n2 == -1 && (cArray[i] == '-' || cArray[i] == ',')) {
                n2 = i;
                continue;
            }
            if (Character.isDigit(cArray[i]) || Character.isSpaceChar(cArray[i])) continue;
            return false;
        }
        return n > 0 && n < n2;
    }

    protected void execLater(String string) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.exec(string);
        } else {
            final String[] stringArray = new String[]{string};
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Command.this.exec(stringArray[0]);
                }
            });
        }
    }

    protected String exec(String string) {
        return this.exec(string, true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected String exec(String var1_1, boolean var2_2, boolean var3_3) {
        if (this.a.isFullScreen() && !this.a.fullScreen.isVisible()) {
            this.a.fullScreen.setVisible(true);
        }
        if (var1_1.trim().charAt(0) == '#') {
            if (this.comment == null) {
                this.comment = new StringBuffer(var1_1.trim().substring(1));
            } else {
                this.comment.append(" " + var1_1.trim().substring(1));
            }
            return "";
        }
        if (!var1_1.startsWith("function")) {
            this.comment = null;
        }
        this.syncServer();
        if (!this.filterMode && this.fonct == null) {
            var1_1 = this.evalAdjust(var1_1.trim());
            var1_1 = this.convertAdjust(var1_1);
        }
        try {
            var4_4 = this.ds9.translate(var1_1);
            if (var4_4 != null) {
                if (var4_4.length() == 0) {
                    return "";
                }
                return this.execScript((String)var4_4, var2_2, var3_3);
            }
        }
        catch (Exception var4_5) {
            this.printConsole(var4_5.getMessage());
            return "";
        }
        var4_4 = new StringBuffer();
        var5_6 = this.getTargetPlane((StringBuffer)var4_4, var1_1);
        var6_7 = var4_4.length() == 0 ? null : "=" + var4_4.toString();
        var7_8 = new Tok(var5_6);
        var8_9 = var7_8.nextToken();
        if (this.getNumber(var5_6, 1, false, false) != null) {
            var9_10 = var5_6;
            var8_9 = "copy";
        } else {
            var9_10 = var5_6.substring(var8_9.length()).trim();
        }
        this.lastCmd = var8_9;
        if (!var2_2) ** GOTO lbl-1000
        if (this.a.getInstanceId() > 0) ** GOTO lbl-1000
        if (this.a.getInstanceId() == 0) {
            ** if (Aladin.flagLaunch) goto lbl-1000
        }
        ** GOTO lbl-1000
lbl-1000:
        // 2 sources

        {
            v0 = true;
            ** GOTO lbl46
        }
lbl-1000:
        // 3 sources

        {
            v0 = var12_11 = false;
        }
lbl46:
        // 2 sources

        if (var12_11 || Aladin.NOGUI) {
            this.println("[" + var1_1 + "]...");
        }
        if (this.syncMode == 1 && this.needSync(var8_9)) {
            if (!this.isSync()) {
                Aladin.trace(4, "Command.exec() : command \"" + var8_9 + "\" needs sync...");
            }
            this.sync();
        }
        if (var1_1.trim().startsWith("function")) {
            this.fonct = new Function();
            if (this.comment != null) {
                this.fonct.setDescription(this.comment.toString());
                this.comment = null;
            }
        }
        if (this.fonct != null) {
            try {
                if (this.fonct.parseFunction(var1_1)) {
                    this.addFunction(this.fonct);
                    this.fonct = null;
                }
            }
            catch (Exception var13_12) {
                this.printConsole("!!! " + var13_12.getMessage());
                this.fonct = null;
            }
            return "";
        }
        if (var3_3) {
            return "";
        }
        if (var5_6.toLowerCase().startsWith("filter") && var5_6.indexOf("{") >= 0) {
            this.println("Enter the constraints for the new filter");
            this.filterMode = true;
            this.filterDef = new StringBuffer();
        }
        if (this.filterMode) {
            this.filterDef.append("\n" + var5_6);
            if (Action.countNbOcc('{', this.filterDef.toString()) <= Action.countNbOcc('}', this.filterDef.toString())) {
                this.filterMode = false;
                if (this.robotMode && Aladin.ROBOTSUPPORT) {
                    FilterProperties.setCurrentMode(FilterProperties.ADVANCED);
                    this.robot.executeCommand("filter", this.filterDef.toString());
                } else if (this.createFilter(this.filterDef.toString()) != null) {
                    this.a.calque.select.repaint();
                }
                return "";
            }
            if (Action.countNbOcc('\n', this.filterDef.toString()) > 1) {
                this.println("Enter other constraints for the new filter");
            }
            return "";
        }
        if (var12_11) {
            this.a.console.printCommand(var1_1);
        }
        if (var1_1.length() > 0 && var1_1.trim().charAt(0) == '#') {
            return "";
        }
        if (this.robotMode && Aladin.ROBOTSUPPORT && this.robot.executeCommand(var8_9, var9_10)) {
            return "";
        }
        Aladin.trace(4, "Command.exec() : execute now \"" + var8_9 + " " + var9_10 + "\"...");
        if (var8_9.equalsIgnoreCase("taquin")) {
            this.a.view.taquin(var9_10);
        } else if (var8_9.equalsIgnoreCase("macro")) {
            this.execMacro(var9_10);
        } else if (var8_9.equalsIgnoreCase("test")) {
            this.hop();
        } else if (var8_9.equalsIgnoreCase("cleancache")) {
            PlanBG.cleanCache();
        } else if (var8_9.equalsIgnoreCase("testlang")) {
            Aladin.chaine.testLanguage(var9_10);
        } else if (var8_9.equalsIgnoreCase("testimg")) {
            this.testCalib(var6_7, var9_10, 0);
        } else if (var8_9.equalsIgnoreCase("testcat")) {
            this.testCalib(var6_7, var9_10, 1);
        } else if (var8_9.equalsIgnoreCase("testscript")) {
            this.testscript(var9_10);
        } else if (var8_9.equalsIgnoreCase("testperf")) {
            this.testperf(var9_10);
        } else if (var8_9.equalsIgnoreCase("testnet")) {
            this.testnet();
        } else if (var8_9.equalsIgnoreCase("call")) {
            this.execFunction(var9_10);
        } else if (var8_9.equalsIgnoreCase("=")) {
            this.execEval(var9_10);
        } else if (var8_9.equalsIgnoreCase("convert")) {
            this.execConvert(var9_10);
        } else {
            if (var8_9.equalsIgnoreCase("list")) {
                return this.listFunction(var9_10);
            }
            if (var5_6.trim().startsWith("addcol")) {
                this.execAddCol(var5_6);
                return "";
            }
            if (var8_9.equalsIgnoreCase("select")) {
                this.execSelectCmd(var9_10);
            } else if (var8_9.equalsIgnoreCase("tag")) {
                this.a.tagselect();
            } else if (var8_9.equalsIgnoreCase("untag")) {
                this.a.untag();
            } else if (var8_9.equalsIgnoreCase("reloadglu")) {
                this.a.glu = new Glu(this.a);
            } else if (var8_9.equalsIgnoreCase("goto")) {
                this.goTo(var9_10);
            } else if (var8_9.equalsIgnoreCase("crop")) {
                this.execCropCmd(var9_10, var6_7);
            } else if (var8_9.equalsIgnoreCase("match")) {
                this.execMatchCmd(var9_10);
            } else if (var8_9.equalsIgnoreCase("stick")) {
                this.execViewCmd(var9_10, 0);
            } else if (var8_9.equalsIgnoreCase("unstick")) {
                this.execViewCmd(var9_10, 1);
            } else if (var8_9.equalsIgnoreCase("lock")) {
                this.execViewCmd(var9_10, 2);
            } else if (var8_9.equalsIgnoreCase("unlock")) {
                this.execViewCmd(var9_10, 3);
            } else if (var8_9.equalsIgnoreCase("northup")) {
                this.execViewCmd(var9_10, 4);
            } else if (var8_9.equalsIgnoreCase("unnorthup")) {
                this.execViewCmd(var9_10, 5);
            } else if (var8_9.equalsIgnoreCase("grey") || var8_9.equalsIgnoreCase("gray")) {
                this.a.grey();
            } else if (var8_9.equalsIgnoreCase("quit")) {
                this.a.quit(0);
            } else {
                if (var8_9.equalsIgnoreCase("get")) {
                    return this.execGetCmd(var9_10, var6_7, true);
                }
                if (var8_9.equalsIgnoreCase("set")) {
                    return this.execSetCmd(var9_10);
                }
                if (var8_9.equalsIgnoreCase("setconf")) {
                    return this.execSetconfCmd(var9_10);
                }
                if (var8_9.equalsIgnoreCase("status")) {
                    return this.execStatusCmd(var9_10);
                }
                if (var8_9.equalsIgnoreCase("info")) {
                    this.execInfo(var9_10);
                } else if (var8_9.equalsIgnoreCase("help")) {
                    this.execHelpCmd(var9_10, false);
                } else if (var8_9.equalsIgnoreCase("reset")) {
                    this.a.reset();
                } else if (var8_9.equalsIgnoreCase("new")) {
                    this.a.windows();
                } else if (var8_9.equalsIgnoreCase("search")) {
                    this.a.search.execute(var9_10);
                } else if (var8_9.equalsIgnoreCase("createplane") || var8_9.equalsIgnoreCase("cplane") || var8_9.equalsIgnoreCase("plane")) {
                    this.execCcatCmd("cplane", var9_10, var6_7);
                } else if (var8_9.equalsIgnoreCase("ccat")) {
                    this.execCcatCmd("ccat", var9_10, var6_7);
                } else if (var8_9.equalsIgnoreCase("thumbnail") || var8_9.equalsIgnoreCase("createROI") || var8_9.equalsIgnoreCase("ROI")) {
                    this.execROICmd(var9_10);
                } else if (var8_9.equalsIgnoreCase("stc")) {
                    this.execDrawCmd("draw", var9_10);
                } else if (this.findMoc(var8_9)) {
                    this.execDrawCmd("draw", "MOC " + var8_9);
                } else {
                    if (var8_9.equalsIgnoreCase("cmoc")) {
                        return this.execCmocCmd(var9_10, var6_7);
                    }
                    if (var8_9.equalsIgnoreCase("draw")) {
                        this.execDrawCmd(var8_9, var9_10);
                    } else {
                        if (var8_9.equalsIgnoreCase("rename") || var8_9.equalsIgnoreCase("ren")) {
                            try {
                                var13_13 = null;
                                var7_8 = new Tok(var9_10);
                                var14_58 = var7_8.nextToken();
                                var15_82 = var7_8.nextToken();
                                if (var15_82.length() > 0) {
                                    var13_13 = this.getNumber(var14_58);
                                } else {
                                    var13_13 = this.a.calque.getFirstSelectedPlan();
                                    var15_82 = var14_58;
                                }
                                this.a.calque.rename(var13_13, var15_82);
                            }
                            catch (Exception var13_14) {
                                this.printConsole("!!! rename error: " + var13_14.getMessage());
                                return "";
                            }
                        }
                        if (var8_9.equalsIgnoreCase("constellation")) {
                            this.a.calque.setConstellation(var9_10.equals("off") == false);
                        } else if (var8_9.equalsIgnoreCase("grid")) {
                            if (var9_10.equalsIgnoreCase("healpix") || var9_10.equalsIgnoreCase("hpx")) {
                                this.a.calque.setGrid(2);
                            } else {
                                this.a.calque.setGrid(var9_10.equals("off") != false ? 0 : 1);
                            }
                            this.a.calque.repaintAll();
                        } else if (var8_9.equalsIgnoreCase("pause")) {
                            try {
                                var13_15 = Double.parseDouble(var9_10);
                                if (var13_15 <= 0.0) {
                                    var13_15 = 1.0;
                                }
                            }
                            catch (Exception var15_83) {
                                var13_15 = 1.0;
                            }
                            Util.pause((int)Math.round(var13_15 * 1000.0));
                        } else {
                            if (var8_9.equalsIgnoreCase("timeout")) {
                                return this.execSetconfCmd("timeout=" + var9_10);
                            }
                            if (var8_9.equalsIgnoreCase("reticle")) {
                                var13_16 = var9_10.equals("off") != false ? 0 : (var9_10.equals("large") != false ? 2 : 1);
                                this.a.calque.setReticle(var13_16);
                                this.a.calque.repaintAll();
                            } else if (var8_9.equalsIgnoreCase("target")) {
                                var13_17 = var9_10.equals("off") == false;
                                this.a.calque.setOverlayFlag("target", var13_17);
                                this.a.calque.repaintAll();
                            } else if (var8_9.equalsIgnoreCase("scale") || var8_9.equalsIgnoreCase("overlay")) {
                                var13_18 = var9_10.equals("off") == false;
                                this.a.calque.setOverlay(var13_18);
                                this.a.calque.repaintAll();
                            } else if (var8_9.equalsIgnoreCase("flipflop")) {
                                this.execFlipFlop(var9_10, var6_7);
                            } else if (var8_9.equalsIgnoreCase("reverse")) {
                                var13_19 = var9_10.equals("off") == false;
                                this.execCM(var13_19 != false ? "reverse" : "noreverse");
                            } else if (var8_9.equalsIgnoreCase("blink")) {
                                var13_20 = this.getPlanImage(var9_10);
                                if (var13_20.length < 2) {
                                    this.printConsole("!!! blink error: 2 images are required for blinking");
                                    return "";
                                }
                                this.a.calque.newPlanImageBlink(var13_20, var6_7, 400);
                                this.setSyncNeedRepaint(true);
                            } else if (var8_9.equalsIgnoreCase("mosaic")) {
                                var13_21 = this.getPlanImage(var9_10);
                                if (var13_21.length < 2) {
                                    this.printConsole("!!! mosaic error: 2 images are required for mosaic");
                                    return "";
                                }
                                this.a.calque.newPlanImageMosaic(var13_21, var6_7, null);
                                this.setSyncNeedRepaint(true);
                            } else {
                                if (var8_9.equalsIgnoreCase("resamp") || var8_9.equalsIgnoreCase("rsamp")) {
                                    try {
                                        var13_22 = false;
                                        var14_59 = 1;
                                        var7_8 = new Tok(var9_10);
                                        var15_84 = (PlanImage)this.getPlanFromParam(var7_8.nextToken());
                                        var16_101 = (PlanImage)this.getPlanFromParam(var7_8.nextToken());
                                        while (var7_8.hasMoreTokens()) {
                                            var17_117 = var7_8.nextToken().charAt(0);
                                            if (var17_117 == '8') {
                                                var13_22 = false;
                                            }
                                            if (var17_117 == 'F' || var17_117 == 'f') {
                                                var13_22 = true;
                                            }
                                            if (var17_117 == 'C' || var17_117 == 'c') {
                                                var14_59 = 0;
                                            }
                                            if (var17_117 != 'B' && var17_117 != 'b') continue;
                                            var14_59 = 1;
                                        }
                                        this.a.calque.newPlanImageResamp(var15_84, var16_101, var6_7, var14_59, var13_22, true);
                                        this.setSyncNeedRepaint(true);
                                    }
                                    catch (Exception var13_23) {
                                        this.printConsole("Resamp error: " + var13_23.getMessage());
                                        return "";
                                    }
                                }
                                var11_128 = this.findAlgebre(var5_6);
                                if (var11_128 >= 0) {
                                    if (this.syncMode == 1) {
                                        this.sync();
                                    }
                                    try {
                                        var7_8 = new Tok(var5_6);
                                        var13_24 = null;
                                        var14_60 = null;
                                        var17_118 = NaN;
                                        var10_129 = var7_8.countTokens();
                                        if (var10_129 <= 2) {
                                            var16_102 = var5_6.substring(1).trim();
                                            var14_60 = (PlanImage)this.getPlanFromParam(var16_102, 0, true);
                                            if (var14_60 == null) {
                                                try {
                                                    var17_118 = Double.parseDouble(var16_102);
                                                }
                                                catch (Exception var19_132) {
                                                    // empty catch block
                                                }
                                            }
                                            if (var13_24 == null && var14_60 == null && Double.isNaN(var17_118)) {
                                                throw new Exception();
                                            }
                                            this.a.calque.newPlanImageAlgo(var6_7, var13_24, var14_60, var11_128, var17_118, null, 1);
                                        }
                                        if (var10_129 == 3) {
                                            var15_85 = var7_8.nextToken();
                                            var7_8.nextToken();
                                            var16_103 = var7_8.nextToken();
                                            var13_24 = (PlanImage)this.getPlanFromParam(var15_85, 0, true);
                                            if (var13_24 == null) {
                                                try {
                                                    var17_118 = Double.parseDouble(var15_85);
                                                }
                                                catch (Exception var19_133) {
                                                    // empty catch block
                                                }
                                            }
                                            if ((var14_60 = (PlanImage)this.getPlanFromParam(var16_103, 0, true)) == null) {
                                                try {
                                                    var17_118 = Double.parseDouble(var16_103);
                                                }
                                                catch (Exception var19_134) {
                                                    // empty catch block
                                                }
                                            }
                                            if (var13_24 == null && var14_60 == null && Double.isNaN(var17_118)) {
                                                throw new Exception();
                                            }
                                            this.a.calque.newPlanImageAlgo(var6_7, var13_24, var14_60, var11_128, var17_118, null, 1);
                                        }
                                        throw new Exception();
                                    }
                                    catch (Exception var13_25) {
                                        this.printConsole("!!! Arithmetic expression syntax error: " + var13_25.getMessage());
                                        return "error";
                                    }
                                } else {
                                    if (var8_9.equalsIgnoreCase("norm")) {
                                        try {
                                            var11_128 = 4;
                                            var7_8 = new Tok(var9_10);
                                            var13_26 = var7_8.nextToken();
                                            var14_61 = var7_8.hasMoreTokens() != false ? var7_8.nextToken() : null;
                                            var15_86 = null;
                                            if (var13_26 != null && var13_26.equals("-cut")) {
                                                var11_128 = 5;
                                                var13_26 = var14_61;
                                            }
                                            if (var13_26 != null) {
                                                var15_86 = (PlanImage)this.getPlanFromParam(var13_26);
                                            }
                                            this.a.calque.newPlanImageAlgo(var6_7, var15_86, null, var11_128, 0.0, null, 0);
                                            this.setSyncNeedRepaint(true);
                                        }
                                        catch (Exception var13_27) {
                                            this.printConsole("!!! norm error: " + var13_27.getMessage());
                                            return "error";
                                        }
                                    }
                                    if (var8_9.equalsIgnoreCase("kernel")) {
                                        var13_28 = "";
                                        if (var9_10.trim().length() == 0) {
                                            var13_28 = this.a.kernelList.getKernelList();
                                        } else {
                                            if (var9_10.indexOf(61) > 0) {
                                                var14_62 = 2.777777777777778E-4;
                                                try {
                                                    var14_62 = this.a.view.getCurrentView().pref.projd.getPixResDelta();
                                                }
                                                catch (Exception var16_104) {
                                                    // empty catch block
                                                }
                                                try {
                                                    this.a.kernelList.addKernel(var9_10, var14_62);
                                                }
                                                catch (Exception var16_105) {
                                                    this.printConsole("!!! conv error: kernel definition error");
                                                    return "error";
                                                }
                                            }
                                            var13_28 = this.a.kernelList.getKernelDef(var9_10);
                                        }
                                        this.print(var13_28);
                                        this.a.console.printInPad(var13_28);
                                        return var13_28;
                                    }
                                    if (var8_9.equalsIgnoreCase("conv")) {
                                        try {
                                            var7_8 = new Tok(var9_10);
                                            var13_29 = var7_8.nextToken();
                                            var14_63 = null;
                                            var15_87 = (PlanImage)this.getPlanFromParam(var13_29, 0, true);
                                            var14_63 = var15_87 != null ? var9_10.substring(var13_29.length()).trim() : var9_10;
                                            this.a.calque.newPlanImageAlgo(var6_7, var15_87, null, 6, 0.0, var14_63, 0);
                                            this.setSyncNeedRepaint(true);
                                        }
                                        catch (Exception var13_30) {
                                            this.printConsole("!!! conv error: " + var13_30.getMessage());
                                            return "error";
                                        }
                                    }
                                    if (var8_9.equalsIgnoreCase("bitpix")) {
                                        try {
                                            var11_128 = 8;
                                            var7_8 = new Tok(var9_10);
                                            var13_31 = var7_8.nextToken();
                                            var14_64 = var7_8.hasMoreTokens() != false ? var7_8.nextToken() : null;
                                            var15_88 = var7_8.hasMoreTokens() != false ? var7_8.nextToken() : null;
                                            var16_106 = null;
                                            if (var13_31 != null && var13_31.equals("-cut")) {
                                                var11_128 = 9;
                                                var13_31 = var14_64;
                                                var14_64 = var15_88;
                                            }
                                            if ((var16_106 = (PlanImage)this.getPlanFromParam(var13_31, 0, true)) != null) {
                                                var13_31 = var14_64;
                                            }
                                            var17_119 = var13_31;
                                            if (var16_106 != null && !var16_106.isSimpleImage() || var16_106 == null && !this.a.calque.getPlanBase().isSimpleImage()) {
                                                throw new Exception("Uncompatible image");
                                            }
                                            this.a.calque.newPlanImageAlgo(var6_7, var16_106, null, var11_128, 0.0, var17_119, 0);
                                            this.setSyncNeedRepaint(true);
                                        }
                                        catch (Exception var13_32) {
                                            this.printConsole("!!! bitpix error: " + var13_32.getMessage());
                                            return "error";
                                        }
                                    }
                                    if (var8_9.equalsIgnoreCase("RGB")) {
                                        var13_33 = this.getPlanImage(var9_10);
                                        if (var13_33.length < 2) {
                                            this.printConsole("!!! RGB error: not enough images");
                                            return "";
                                        }
                                        this.a.calque.newPlanImageRGB(var13_33[0], var13_33.length > 2 ? var13_33[1] : null, var13_33.length > 2 ? var13_33[2] : var13_33[1], var13_33[0], var6_7, false);
                                        this.setSyncNeedRepaint(true);
                                    } else if (var8_9.equalsIgnoreCase("RGBdiff")) {
                                        var13_34 = this.getPlanImage(var9_10);
                                        if (var13_34.length != 2) {
                                            this.printConsole("!!! RGBdiff error: requires two images");
                                            return "";
                                        }
                                        this.a.calque.newPlanImageRGB(var13_34[0], var13_34[1], null, var13_34[0], var6_7, true);
                                        this.setSyncNeedRepaint(true);
                                    } else if (var8_9.equalsIgnoreCase("cm")) {
                                        this.execCM(var9_10);
                                    } else if (var8_9.equalsIgnoreCase("sync")) {
                                        this.sync();
                                    } else if (var8_9.equalsIgnoreCase("md")) {
                                        var13_35 = false;
                                        if (var9_10.length() > 11 && var9_10.substring(0, 11).equalsIgnoreCase("-localscope")) {
                                            var13_35 = true;
                                            var9_10 = var9_10.substring(11).trim();
                                        }
                                        if (var9_10.length() == 0) {
                                            this.a.calque.newFolder(null, 0, var13_35);
                                        } else {
                                            this.a.calque.newFolder(var9_10, 0, var13_35);
                                        }
                                        this.a.calque.select.repaint();
                                    } else if (var8_9.equalsIgnoreCase("collapse")) {
                                        var13_36 = this.getPlan(var9_10, 3);
                                        for (var14_65 = 0; var14_65 < var13_36.length; ++var14_65) {
                                            if (this.a.calque.isCollapsed(var13_36[var14_65])) continue;
                                            this.a.calque.select.switchCollapseFolder(var13_36[var14_65]);
                                        }
                                        this.a.calque.repaintAll();
                                    } else if (var8_9.equalsIgnoreCase("expand")) {
                                        var13_37 = this.getPlan(var9_10, 3);
                                        for (var14_66 = 0; var14_66 < var13_37.length; ++var14_66) {
                                            if (!this.a.calque.isCollapsed(var13_37[var14_66])) continue;
                                            this.a.calque.select.switchCollapseFolder(var13_37[var14_66]);
                                        }
                                        this.a.calque.repaintAll();
                                    } else if (var8_9.equalsIgnoreCase("copy")) {
                                        var7_8 = new Tok(var9_10);
                                        var13_38 = var7_8.nextToken();
                                        var15_89 = this.getViewNumber(var13_38, false);
                                        var14_67 = var7_8.nextToken();
                                        var16_107 = this.getViewNumber(var14_67, false);
                                        if (var15_89 >= 0 && var16_107 >= 0) {
                                            this.a.view.copyView(var15_89, var16_107);
                                        } else {
                                            var17_120 = null;
                                            var18_140 = this.getNumber(var13_38, 1, false, false);
                                            if (var18_140 == null && var14_67.length() == 0) {
                                                var14_67 = var13_38;
                                                var17_120 = this.a.calque.getFirstSelectedPlan();
                                            } else {
                                                var17_120 = var18_140;
                                            }
                                            if (var6_7 != null) {
                                                var14_67 = var6_7;
                                            }
                                            try {
                                                if (var17_120 instanceof PlanImageBlink) {
                                                    this.a.calque.newPlanImageFromBlink((PlanImageBlink)var17_120, -1);
                                                } else {
                                                    this.a.calque.dupPlan((PlanImage)var17_120, var14_67.trim().length() == 0 ? null : var14_67, var17_120.type, true);
                                                }
                                                this.setSyncNeedRepaint(true);
                                            }
                                            catch (Exception var19_135) {
                                                this.printConsole("!!! copy error: " + var19_135.getMessage());
                                                return "";
                                            }
                                        }
                                    } else {
                                        if (var8_9.equalsIgnoreCase("mv") || var8_9.equalsIgnoreCase("move")) {
                                            var7_8 = new Tok(var9_10);
                                            if (var7_8.countTokens() == 2) {
                                                var13_39 = this.getViewNumber(var7_8.nextToken(), false);
                                                var14_68 = this.getViewNumber(var7_8.nextToken(), false);
                                                if (var13_39 >= 0 && var14_68 >= 0) {
                                                    this.a.view.moveView(var13_39, var14_68);
                                                    return "";
                                                }
                                            }
                                            var7_8 = new Tok(var9_10);
                                            try {
                                                var13_40 = new Vector<Plan>(10);
                                                while (var7_8.hasMoreTokens()) {
                                                    var13_40.addElement(this.getNumber(var7_8.nextToken()));
                                                }
                                                var14_68 = var13_40.size();
                                                var15_90 = (Plan)var13_40.elementAt(var14_68 - 1);
                                                for (var16_108 = var14_68 - 2; var16_108 >= 0; --var16_108) {
                                                    this.a.calque.permute((Plan)var13_40.elementAt(var16_108), var15_90);
                                                }
                                                this.setSyncNeedRepaint(true);
                                                this.a.view.newView(1);
                                                this.a.calque.repaintAll();
                                            }
                                            catch (Exception var13_41) {
                                                this.printConsole("!!! mv error: " + var13_41.getMessage());
                                                return "";
                                            }
                                        }
                                        if (var8_9.equalsIgnoreCase("rm") || var8_9.equalsIgnoreCase("free")) {
                                            if (var9_10.equals("lock") || var9_10.equals("-lock") || var9_10.equals("ROI") || var9_10.equals("-ROI")) {
                                                this.a.view.freeLock();
                                            } else if (var9_10.equals("all") || var9_10.equals("-all")) {
                                                this.a.calque.FreeAll();
                                            } else if (var9_10.length() == 0) {
                                                this.a.delete();
                                            } else {
                                                var13_42 = this.getViews(var9_10);
                                                if (var13_42.length > 0) {
                                                    this.a.view.free(var13_42);
                                                }
                                                this.a.calque.unSelectAllPlan();
                                                var14_69 = this.getPlan(var9_10, 4);
                                                if (var14_69.length > 0) {
                                                    for (var15_91 = 0; var15_91 < var14_69.length; ++var15_91) {
                                                        var14_69[var15_91].selected = true;
                                                    }
                                                    this.a.calque.FreeSet(false);
                                                }
                                                this.a.view.setSelectFromView(true);
                                            }
                                            this.a.gc();
                                            this.a.calque.repaintAll();
                                        } else if (var8_9.equalsIgnoreCase("modeview") || var8_9.equalsIgnoreCase("mview")) {
                                            try {
                                                var10_130 = Integer.parseInt(var7_8.nextToken());
                                                if (var10_130 != 1 && var10_130 != 2 && var10_130 != 4 && var10_130 != 9 && var10_130 != 16) {
                                                    var10_130 = 1;
                                                }
                                            }
                                            catch (Exception var13_43) {
                                                var10_130 = 1;
                                            }
                                            this.a.view.setModeView(var10_130);
                                            try {
                                                var10_130 = Integer.parseInt(var7_8.nextToken());
                                                this.a.view.scrollOn(var10_130 - 1);
                                            }
                                            catch (Exception var13_44) {}
                                        } else if (var8_9.equalsIgnoreCase("createview") || var8_9.equalsIgnoreCase("cview")) {
                                            var13_45 = false;
                                            var14_70 = new String[2];
                                            var15_92 = null;
                                            if (var9_10.length() == 0) {
                                                var15_92 = this.a.calque.getFirstSelectedPlan();
                                            } else {
                                                var16_109 = var7_8.nextToken();
                                                if (var16_109.equals("-plot")) {
                                                    var13_45 = true;
                                                    if (!var7_8.hasMoreTokens()) {
                                                        var15_92 = this.a.calque.getFirstSelectedPlan();
                                                    } else {
                                                        var16_109 = var7_8.nextToken();
                                                    }
                                                }
                                                if (var13_45) {
                                                    var16_109 = this.parseColumnIndex(var14_70, var16_109);
                                                }
                                                if (var15_92 == null) {
                                                    var15_92 = this.getNumber(var16_109);
                                                }
                                            }
                                            if (var15_92 == null) {
                                                return "";
                                            }
                                            var16_110 = -1;
                                            if (var7_8.hasMoreTokens()) {
                                                var16_110 = this.getViewNumber(var7_8.nextToken());
                                                this.a.calque.setPlanRef(var15_92, var16_110);
                                            } else {
                                                var16_110 = this.a.view.getLastNumView(var15_92);
                                            }
                                            if (var16_110 < 0) {
                                                return "";
                                            }
                                            if (!this.a.view.viewSimple[var16_110].isPlotView()) {
                                                if (var15_92 instanceof PlanBG) {
                                                    this.a.calque.setPlanRefOnSameTarget((PlanBG)var15_92);
                                                } else {
                                                    this.a.view.setPlanRef(var16_110, var15_92);
                                                }
                                            }
                                            if (var13_45) {
                                                try {
                                                    this.a.view.viewSimple[var16_110].addPlotTable(var15_92, var14_70[0], var14_70[1], false);
                                                }
                                                catch (Exception var17_121) {
                                                    this.printConsole("!!! cview -plot error: " + var17_121.getMessage());
                                                }
                                            }
                                            this.a.calque.repaintAll();
                                        } else if (var8_9.equalsIgnoreCase("hide")) {
                                            var13_46 = this.getPlan(var9_10, 2);
                                            for (var14_71 = 0; var14_71 < var13_46.length; ++var14_71) {
                                                if (var13_46[var14_71].type == 11) {
                                                    this.a.calque.setActiveFolder(var13_46[var14_71], false);
                                                    continue;
                                                }
                                                var13_46[var14_71].setActivated(false);
                                            }
                                            this.a.calque.repaintAll();
                                        } else if (var8_9.equalsIgnoreCase("show") || var8_9.equalsIgnoreCase("ref")) {
                                            var13_47 = this.getPlan(var9_10, 2);
                                            for (var14_72 = 0; var14_72 < var13_47.length; ++var14_72) {
                                                if (var13_47[var14_72].type == 11) {
                                                    this.a.calque.setActiveFolder(var13_47[var14_72], true);
                                                    continue;
                                                }
                                                this.a.calque.showPlan(var13_47[var14_72]);
                                            }
                                        } else if (var8_9.equalsIgnoreCase("zoom")) {
                                            this.setSyncNeedRepaint(true);
                                            if (!this.a.calque.zoom.setZoom(var9_10)) {
                                                this.printConsole("!!! zoom error: factor \"" + var9_10 + "\" unknown !");
                                            }
                                        } else if (var8_9.equalsIgnoreCase("backup")) {
                                            var13_48 = this.syncSave.start("Command.backup");
                                            try {
                                                if (this.a.save == null) {
                                                    this.a.save = new Save(this.a);
                                                }
                                                this.a.save.saveAJ(var9_10);
                                            }
                                            catch (Exception var14_73) {
                                            }
                                            finally {
                                                this.syncSave.stop(var13_48);
                                            }
                                        } else if (var8_9.equalsIgnoreCase("save")) {
                                            var13_49 = this.syncSave.start("Command.save");
                                            try {
                                                if (this.a.save == null) {
                                                    this.a.save = new Save(this.a);
                                                }
                                                var14_74 = null;
                                                var15_93 = null;
                                                var16_111 = 500;
                                                var17_122 = 500;
                                                var18_141 = false;
                                                var19_136 = false;
                                                var20_145 = 0;
                                                var21_148 = var8_9.length();
                                                var22_150 = -1.0f;
                                                if (var7_8.hasMoreTokens()) {
                                                    var14_74 = var7_8.nextToken();
                                                }
                                                if (var14_74 != null) {
                                                    if (var14_74.equals("-ROI") || var14_74.equals("-allviews")) {
                                                        var19_136 = true;
                                                        var21_148 = var5_6.indexOf(var14_74) + var14_74.length() + 1;
                                                        var14_74 = var7_8.nextToken();
                                                    }
                                                    if (var14_74.startsWith("-jpeg") || var14_74.startsWith("-jpg")) {
                                                        var20_145 = 4;
                                                        try {
                                                            var22_150 = Float.parseFloat(var14_74.substring(var14_74.indexOf(103) + 1, var14_74.length()));
                                                            if (var22_150 > 1.0f) {
                                                                var22_150 /= 100.0f;
                                                            }
                                                        }
                                                        catch (Exception var23_153) {
                                                            var22_150 = -1.0f;
                                                        }
                                                        var21_148 = var5_6.indexOf(var14_74) + var14_74.length() + 1;
                                                        var14_74 = var7_8.hasMoreTokens() ? var7_8.nextToken() : null;
                                                    } else if (var14_74.equals("-eps")) {
                                                        var20_145 = 2;
                                                        var21_148 = var5_6.indexOf(var14_74) + var14_74.length() + 1;
                                                        var14_74 = var7_8.hasMoreTokens() ? var7_8.nextToken() : null;
                                                    } else if (var14_74.equals("-png")) {
                                                        var20_145 = 8;
                                                        var21_148 = var5_6.indexOf(var14_74) + var14_74.length() + 1;
                                                        var14_74 = var7_8.hasMoreTokens() != false ? var7_8.nextToken() : null;
                                                    }
                                                    if (var14_74 != null && var14_74.equals("-lk")) {
                                                        var20_145 |= 16;
                                                        var21_148 = var5_6.indexOf(var14_74) + var14_74.length() + 1;
                                                        var14_74 = var7_8.hasMoreTokens() ? var7_8.nextToken() : null;
                                                    } else if (var14_74 != null && var14_74.equals("-lkflex")) {
                                                        var20_145 |= 32;
                                                        var21_148 = var5_6.indexOf(var14_74) + var14_74.length() + 1;
                                                        if (var7_8.hasMoreTokens()) {
                                                            var14_74 = var7_8.nextToken();
                                                        }
                                                    }
                                                }
                                                if (var14_74 != null) {
                                                    try {
                                                        var23_154 = var14_74.indexOf(120);
                                                        var16_111 = Integer.parseInt(var14_74.substring(0, var23_154));
                                                        var17_122 = Integer.parseInt(var14_74.substring(var23_154 + 1));
                                                        var18_141 = true;
                                                        if (var7_8.hasMoreTokens()) {
                                                            var21_148 = var5_6.indexOf(var14_74) + var14_74.length() + 1;
                                                            var15_93 = var7_8.nextToken();
                                                        }
                                                    }
                                                    catch (Exception var23_155) {
                                                        var16_111 = var17_122 = View.INITW;
                                                        var15_93 = var14_74;
                                                    }
                                                }
                                                if (var15_93 != null) {
                                                    var15_93 = var5_6.substring(var21_148).trim();
                                                }
                                                if (var15_93 == null) {
                                                    if (!Aladin.NOGUI) {
                                                        var14_74 = "saving on standard output required NOGUI mode (-nogui parameter)";
                                                        Aladin.warning("save error: " + var14_74, 1);
                                                        var23_156 = var14_74;
                                                        return var23_156;
                                                    }
                                                }
                                                var15_93 = Tok.unQuote(var15_93);
                                                if (Aladin.NOGUI) {
                                                    var23_157 = this.a.view.getCurrentView();
                                                    if (var16_111 == -1 || var17_122 == -1) {
                                                        var23_157.setDimension(((PlanImage)var23_157.pref).width, ((PlanImage)var23_157.pref).height);
                                                        var23_157.setZoomXY(1.0, -1.0, -1.0);
                                                    } else {
                                                        var23_157.setDimension(var16_111, var17_122);
                                                    }
                                                    var23_157.paintComponent(null);
                                                }
                                                if (var20_145 == 0 || var20_145 == 16 || var20_145 == 32) {
                                                    var20_145 = var15_93 != null && (var15_93.endsWith(".jpg") || var15_93.endsWith(".jpeg")) ? (var20_145 |= 4) : (var15_93 != null && var15_93.endsWith(".eps") ? (var20_145 |= 2) : (var15_93 != null && var15_93.endsWith(".png") ? (var20_145 |= 8) : (var15_93 != null && var15_93.endsWith(".bmp") ? (var20_145 |= 1) : (var15_93 != null && var15_93.endsWith(".lk") ? (var20_145 |= 16) : (var20_145 |= 8)))));
                                                }
                                                if (var19_136) {
                                                    var23_158 = var15_93.lastIndexOf(46);
                                                    if (var23_158 >= 0) {
                                                        var15_93 = var15_93.substring(0, var23_158);
                                                    }
                                                    this.a.view.saveROI(var15_93, var16_111, var17_122, var20_145);
                                                }
                                                this.a.save.saveView(var15_93, var16_111, var17_122, var20_145, var22_150);
                                            }
                                            catch (Exception var14_75) {
                                                var14_75.printStackTrace();
                                            }
                                            finally {
                                                this.syncSave.stop(var13_49);
                                            }
                                        } else if (var8_9.equalsIgnoreCase("export")) {
                                            var13_50 = this.syncSave.start("Command.export");
                                            try {
                                                if (var9_10 != null && var9_10.startsWith("-ROI")) {
                                                    var14_76 = null;
                                                    try {
                                                        var7_8.nextToken();
                                                        var14_76 = var7_8.nextToken();
                                                    }
                                                    catch (Exception var15_94) {
                                                        var14_76 = null;
                                                    }
                                                    this.a.view.exportROI(var14_76);
                                                }
                                                if (this.a.save == null) {
                                                    this.a.save = new Save(this.a);
                                                }
                                                var14_77 = 0;
                                                var15_95 = false;
                                                var16_112 = false;
                                                var17_123 = false;
                                                var18_142 = -1;
                                                var19_137 = var7_8.nextToken();
                                                var20_146 = false;
                                                if (var19_137.charAt(0) == '-') {
                                                    if (var19_137.indexOf("votable") > 0) {
                                                        var15_95 = true;
                                                        if (var19_137.indexOf("flex") > 0) {
                                                            var20_146 = true;
                                                        }
                                                    } else if (var19_137.indexOf("fits") > 0) {
                                                        var16_112 = true;
                                                    } else if (var19_137.indexOf("hpx") > 0) {
                                                        var17_123 = true;
                                                    }
                                                    var19_137 = var7_8.nextToken();
                                                }
                                                var14_77 = var7_8.getPos();
                                                var21_149 = this.getNumber(var19_137);
                                                if (var21_149 == null) {
                                                    var22_151 = "nothing to export";
                                                    this.printConsole("!!! export error: " + var22_151);
                                                    var23_159 = var22_151;
                                                    return var23_159;
                                                }
                                                if (var9_10.endsWith(" votable") || var9_10.endsWith(" VOTABLE") || var9_10.endsWith(".xml") || var9_10.endsWith(".XML")) {
                                                    var15_95 = true;
                                                    if (var9_10.endsWith(" votable") || var9_10.endsWith(" VOTABLE")) {
                                                        var18_142 = var9_10.length() - " votable".length();
                                                    }
                                                } else if (var9_10.endsWith("fits") || var9_10.endsWith("FITS")) {
                                                    var16_112 = true;
                                                    if (var9_10.endsWith(" fits") || var9_10.endsWith(" FITS")) {
                                                        var18_142 = var9_10.length() - " fits".length();
                                                    }
                                                } else if (var9_10.endsWith("hpx") || var9_10.endsWith("HPX")) {
                                                    var17_123 = true;
                                                    if (var9_10.endsWith(" hpx") || var9_10.endsWith(" HPX")) {
                                                        var18_142 = var9_10.length() - " hpx".length();
                                                    }
                                                }
                                                var22_152 = var18_142 == -1 ? var5_6.substring(var14_77) : var5_6.substring(var14_77, var18_142);
                                                if ((var22_152 = Tok.unQuote(var22_152.trim()).trim()).endsWith("fits") || var22_152.endsWith("FITS")) {
                                                    var16_112 = true;
                                                } else if (var22_152.endsWith("hpx") || var22_152.endsWith("HPX")) {
                                                    var17_123 = true;
                                                }
                                                if (var21_149 instanceof PlanMoc) {
                                                    this.a.save.saveMoc(var22_152, (PlanMoc)var21_149, 0);
                                                }
                                                if (var21_149.isCatalog()) {
                                                    this.a.save.saveCatalog(var22_152, var21_149, var15_95 == false, var20_146);
                                                }
                                                if (var21_149.isImage() && !(var21_149 instanceof PlanImageBlink)) {
                                                    this.a.save.saveImage(var22_152, var21_149, var17_123 != false ? 1 : (var16_112 != false ? 0 : 2));
                                                }
                                                var23_160 = "plane type [" + Plan.Tp[var21_149.type] + "] not supported";
                                                this.printConsole("!!! export error: " + var23_160);
                                                var24_162 = var23_160;
                                                return var24_162;
                                            }
                                            catch (Exception var14_78) {
                                                if (Aladin.levelTrace < 3) ** GOTO lbl1040
                                                var14_78.printStackTrace();
                                            }
                                            finally {
                                                this.syncSave.stop(var13_50);
                                            }
                                        } else if (var8_9.equalsIgnoreCase("trace")) {
                                            if (var9_10.equals("off") || var9_10.equals("0")) {
                                                this.a.setTraceLevel(0);
                                                return "";
                                            }
                                            try {
                                                var10_131 = Integer.parseInt(var9_10);
                                                if (var10_131 > 6 || var10_131 < 0) {
                                                    var10_131 = 1;
                                                }
                                            }
                                            catch (Exception var13_51) {
                                                var10_131 = 1;
                                            }
                                            this.a.setTraceLevel(var10_131);
                                        } else if (var8_9.equalsIgnoreCase("gc") || var8_9.equalsIgnoreCase("mem")) {
                                            if (var9_10.equals("off")) {
                                                this.a.gc = false;
                                            } else {
                                                this.a.gc = true;
                                                this.a.gc();
                                                var13_52 = Runtime.getRuntime().totalMemory() / 0x100000L;
                                                var15_96 = Runtime.getRuntime().freeMemory() / 0x100000L;
                                                var17_124 = Runtime.getRuntime().maxMemory() / 0x100000L;
                                                this.printConsole("Total used memory: " + (int)(var13_52 - var15_96) + "Mb (total=" + var13_52 + "Mb free=" + var15_96 + "Mb max=" + var17_124 + "Mb)\n");
                                            }
                                        } else if (var8_9.equalsIgnoreCase("load")) {
                                            this.a.load(Tok.unQuote(var9_10), var6_7);
                                        } else if (var8_9.equalsIgnoreCase("ptool")) {
                                            var13_53 = var7_8.nextToken();
                                            this.printConsole("Creating new PlanTool " + var13_53);
                                            this.a.calque.newPlanTool(var13_53);
                                            this.a.calque.repaintAll();
                                        } else if (var8_9.equalsIgnoreCase("rep")) {
                                            var13_54 = var7_8.nextToken();
                                            var14_79 = this.getNumber(var13_54);
                                            if (var14_79 == null) {
                                                return "";
                                            }
                                            var15_97 = Integer.parseInt(var7_8.nextToken());
                                            var16_113 = Integer.parseInt(var7_8.nextToken());
                                            this.printConsole("Creating repere (" + var15_97 + "," + var16_113 + ") on plane " + var13_54);
                                            var17_125 = new Repere(var14_79, this.a.view.getCurrentView(), var15_97, var16_113);
                                            this.a.calque.setObjet(var17_125);
                                            this.a.calque.repaintAll();
                                        } else {
                                            if (var8_9.equalsIgnoreCase("demo") || var8_9.equalsIgnoreCase("robot")) {
                                                if (!Aladin.ROBOTSUPPORT) {
                                                    Aladin.warning(Aladin.chaine.getString("NOROBOT"), 1);
                                                    return "";
                                                }
                                                if (var9_10.trim().equals("end") && this.robotInfo != null) {
                                                    MyRobot.info("\n\n         T H E     E N D\n\n\n", this.a);
                                                    this.robotInfo = null;
                                                    this.robotMode = false;
                                                    if (this.robot != null) {
                                                        this.robot.reset();
                                                    }
                                                } else {
                                                    this.robotMode = var9_10.trim().equals("off") == false;
                                                }
                                                return "";
                                            }
                                            if (var8_9.equals("xmatch")) {
                                                return this.execXMatchCmd(var5_6, var6_7);
                                            }
                                            if (var8_9.equals("contour")) {
                                                var13_55 = (PlanImage)this.a.calque.getPlanBase();
                                                if (var13_55 == null || !var13_55.flagOk) {
                                                    this.printConsole("!!! contour error: no image ready !");
                                                    return "";
                                                }
                                                if (var13_55.type == 2 || var13_55 instanceof PlanImageBlink) {
                                                    this.printConsole("!!! contour error: can't produce contours on this image");
                                                    return "";
                                                }
                                                var14_80 = 4;
                                                if (var7_8.hasMoreTokens()) {
                                                    var15_98 = var7_8.nextToken();
                                                    try {
                                                        var14_80 = Integer.parseInt((String)var15_98);
                                                    }
                                                    catch (NumberFormatException var16_114) {
                                                        this.printConsole("!!! contour error: incorrect or missing parameter");
                                                        return "";
                                                    }
                                                }
                                                var15_98 = new int[var14_80];
                                                var15_98 = FrameContour.generateLevels(var14_80);
                                                var16_115 = new double[var14_80];
                                                for (var17_126 = false; var17_126 < var16_115.length; var17_126 += 1) {
                                                    var16_115[var17_126] = (double)var15_98[var17_126];
                                                }
                                                var17_126 = true;
                                                var18_143 = false;
                                                try {
                                                    var19_138 = var7_8.nextToken();
                                                    if (var19_138.equals("smooth") || var19_138.equals("nosmooth")) {
                                                        var17_126 = var19_138.equals("smooth") != false;
                                                        var20_147 = var7_8.nextToken();
                                                        var18_143 = var20_147.equals("zoom") != false;
                                                    } else {
                                                        var18_143 = var19_138.equals("zoom") != false;
                                                    }
                                                }
                                                catch (Exception var19_139) {
                                                    // empty catch block
                                                }
                                                this.a.calque.newPlanContour(var6_7 != null ? var6_7 : "Contours", null, var16_115, new ContourPlot(), var17_126, 2, var18_143, true, null);
                                            } else if (var8_9.equals("filter")) {
                                                var13_56 = "Syntax is : filter [filter name] on|off";
                                                var14_81 = var7_8.countTokens();
                                                if (var14_81 == 1) {
                                                    var15_99 = var7_8.nextToken().toLowerCase();
                                                    if (var15_99.equals("on")) {
                                                        PlanFilter.activateAllFilters();
                                                    } else if (var15_99.equals("off")) {
                                                        PlanFilter.desactivateAllFilters();
                                                        PlanCatalog.desactivateAllDedicatedFilters(this.a);
                                                    } else {
                                                        this.printConsole("!!! filter error: incorrect parameter \"" + var15_99 + "\"");
                                                        this.println(var13_56);
                                                    }
                                                } else if (var14_81 == 2) {
                                                    var15_100 = var7_8.nextToken();
                                                    var16_116 = var7_8.nextToken().toLowerCase();
                                                    var17_127 = null;
                                                    var17_127 = PlanFilter.getFilterByName(var15_100, this.a);
                                                    if (var17_127 != null) {
                                                        if (var16_116.equals("on")) {
                                                            var17_127.setActivated(true);
                                                            var17_127.updateState();
                                                            this.a.calque.select.repaint();
                                                        } else if (var16_116.equals("off")) {
                                                            var17_127.setActivated(false);
                                                            var17_127.updateState();
                                                            this.a.calque.select.repaint();
                                                        } else {
                                                            this.printConsole("!!! filter error: incorrect parameter \"" + var16_116 + "\"");
                                                            this.println(var13_56);
                                                        }
                                                    } else {
                                                        this.printConsole("!!! filter error: the filter " + var15_100 + " does not exist");
                                                    }
                                                } else {
                                                    this.printConsole("!!! filter error: incorrect number of parameters");
                                                    this.println(var13_56);
                                                }
                                            } else {
                                                if (this.a.plugins != null && this.a.plugins.findScript(var8_9) != null) {
                                                    var7_8 = new Tok(var9_10);
                                                    var13_57 = var7_8.getStrings();
                                                    return this.a.plugins.execPluginByScript(var8_9, var13_57);
                                                }
                                                if (this.execVar(var5_6)) {
                                                    return "";
                                                }
                                                return this.execGetCmd(var5_6, var6_7, false);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
lbl1040:
        // 99 sources

        return "";
    }

    private boolean execVar(String string) {
        return false;
    }

    private ViewSimple[] getViews(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        Vector<ViewSimple> vector = new Vector<ViewSimple>();
        while (stringTokenizer.hasMoreTokens()) {
            int n = this.getViewNumber(stringTokenizer.nextToken(), false);
            if (n < 0) continue;
            vector.addElement(this.a.view.viewSimple[n]);
        }
        return vector.toArray(new ViewSimple[vector.size()]);
    }

    private void execViewCmd(String string, int n) {
        ViewSimple[] viewSimpleArray = string.length() == 0 ? (n == 1 || n == 3 || n == 5 ? this.a.view.viewSimple : this.a.view.getSelectedView()) : this.getViews(string);
        block8: for (int i = 0; i < viewSimpleArray.length; ++i) {
            if (viewSimpleArray[i] == null || viewSimpleArray[i].isFree()) continue;
            switch (n) {
                case 0: {
                    viewSimpleArray[i].sticked = true;
                    continue block8;
                }
                case 1: {
                    viewSimpleArray[i].sticked = false;
                    continue block8;
                }
                case 2: {
                    viewSimpleArray[i].locked = true;
                    continue block8;
                }
                case 3: {
                    viewSimpleArray[i].locked = false;
                    continue block8;
                }
                case 4: {
                    viewSimpleArray[i].northUp = true;
                    continue block8;
                }
                case 5: {
                    viewSimpleArray[i].northUp = false;
                }
            }
        }
        this.a.view.repaintAll();
    }

    protected PlanFilter createFilter(String string) {
        PlanFilter planFilter = (PlanFilter)this.a.calque.newPlanFilter(null, string);
        if (planFilter != null && planFilter.isValid()) {
            this.printConsole("Filter " + planFilter.label + " created");
            planFilter.setActivated(true);
            planFilter.updateState();
        } else {
            this.printConsole("!!! Bad filter syntax !");
            planFilter = null;
        }
        return planFilter;
    }

    private void execAddCol(String string) {
        int n;
        string = string.trim();
        string = string.substring(6).trim();
        String string2 = "addcol : syntax is addcol plane,name,expr,unit,ucd,nb decimals";
        String[] stringArray = new String[6];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = "";
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",", true);
        String string3 = "";
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            if (string4.equals(",")) {
                if (string3.equals(",")) {
                    stringArray[n2++] = "";
                }
            } else {
                stringArray[n2++] = string4;
            }
            string3 = string4;
        }
        String string5 = stringArray[0].trim();
        String string6 = stringArray[1].trim();
        String string7 = stringArray[2].trim();
        String string8 = stringArray[3].trim();
        String string9 = stringArray[4].trim();
        try {
            n = Integer.parseInt(stringArray[5].trim());
        }
        catch (NumberFormatException numberFormatException) {
            n = 4;
        }
        Aladin.trace(3, "expr: " + string7);
        Plan plan = this.getNumber(string5);
        if (plan == null) {
            this.printConsole("!!! addcol error : plane " + string5 + " is not in current stack");
            this.println(string2);
            return;
        }
        if (!plan.isSimpleCatalog()) {
            this.printConsole("!!! addcol error : plane " + string5 + " is not a catalogue plane");
            this.println(string2);
            return;
        }
        PlanCatalog planCatalog = (PlanCatalog)plan;
        if (FrameColumnCalculator.colExist(string6, planCatalog)) {
            this.printConsole("!!! addcol error : A column with label \"" + string6 + "\"already exists in this plane !");
            this.println(string2);
            return;
        }
        SavotField savotField = new SavotField();
        savotField.setName(string6);
        savotField.setUcd(string9);
        savotField.setUnit(string8);
        ColumnCalculator columnCalculator = new ColumnCalculator(new SavotField[]{savotField}, new String[]{string7}, planCatalog, n, this.a);
        if (!columnCalculator.createParser()) {
            this.printConsole("!!! addcol error : " + columnCalculator.getError());
            this.println(string2);
            return;
        }
        columnCalculator.compute();
    }

    protected void reset() {
        if (this.robotInfo != null && this.infoTxt != null) {
            this.infoTxt.setText("");
        }
    }

    protected void goTo(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        this.a.view.gotoThere(string);
    }

    public void setFunctionLocalDefinition(boolean bl) {
        this.functionLocalDefinition = bl;
    }

    public boolean getFunctionLocalDefinition() {
        return this.functionLocalDefinition;
    }

    public int getNbFunctions() {
        return this.function.size();
    }

    public Function getFunction(int n) {
        if (this.function == null || n < 0 || n >= this.function.size()) {
            return null;
        }
        return this.function.get(n);
    }

    public Function getFunction(String string) {
        int n = this.findFunction(string);
        return n < 0 ? null : this.getFunction(n);
    }

    private int findFunction(String string) {
        for (int i = 0; i < this.function.size(); ++i) {
            if (!this.function.get(i).getName().equals(string)) continue;
            return i;
        }
        return -1;
    }

    public void addFunction(Function function) {
        String string = function.getName();
        function.setLocalDefinition(this.functionLocalDefinition);
        int n = this.findFunction(string);
        if (n >= 0) {
            this.function.set(n, function);
        } else {
            this.function.add(function);
        }
        this.functionModif = true;
    }

    public void removeFunction(Function function) {
        int n = this.findFunction(function.getName());
        if (n < 0) {
            return;
        }
        this.function.remove(n);
        this.functionModif = true;
    }

    public void setFunctionModif(boolean bl) {
        this.functionModif = bl;
        for (Function function : this.function) {
            if (!function.isLocalDefinition()) continue;
            function.setModif(false);
        }
    }

    public boolean functionModif() {
        if (this.functionModif) {
            return true;
        }
        for (Function function : this.function) {
            if (!function.isLocalDefinition() || !function.hasBeenModif()) continue;
            return true;
        }
        return false;
    }

    private String convertAdjust(String string) {
        if (string.indexOf("convert") == 0) {
            return string;
        }
        int n = string.indexOf(" to ");
        if (n <= 0) {
            return string;
        }
        return "convert " + string.substring(0, n) + " to " + string.substring(n + 4);
    }

    private String execConvert(String string) {
        String string2;
        if (string.trim().length() == 0) {
            StringBuffer stringBuffer = new StringBuffer();
            Enumeration enumeration = Unit.symbols();
            while (enumeration.hasMoreElements()) {
                String string3 = (String)enumeration.nextElement();
                String string4 = Unit.explainUnit(string3);
                stringBuffer.append(string3 + " - " + string4 + "\n");
            }
            string2 = stringBuffer.toString();
            this.print(string2);
            this.a.console.printInPad(string2);
        } else {
            char c;
            int n;
            int n2 = string.indexOf(" to ");
            String string5 = string.substring(0, n2);
            for (n = string5.length() - 1; n > 0 && !Character.isDigit(c = string5.charAt(n)) && c != ')'; --n) {
            }
            String string6 = string.substring(n2 + 4);
            try {
                string5 = Computer.compute(string5.substring(0, n + 1)) + string5.substring(n + 1);
                Unit unit = new Unit(string5);
                Unit unit2 = new Unit();
                unit2.setUnit(string6);
                unit.convertTo(unit2);
                string2 = unit.getValue() + " " + unit.getUnit();
            }
            catch (Exception exception) {
                string2 = "!!! Conversion error [" + exception.getMessage() + "]";
            }
            this.a.localisation.setTextSaisie(string2);
            this.a.console.printInPad(string + "\n = " + string2 + "\n");
        }
        return string2;
    }

    private String execEval(String string) {
        String string2;
        if (string.trim().length() == 0) {
            string2 = Computer.help();
            this.print(string2);
            this.a.console.printInPad(string2);
        } else {
            try {
                string2 = Computer.compute(string) + "";
            }
            catch (Exception exception) {
                string2 = "!!! Eval error [" + exception.getMessage() + "]";
            }
            this.a.localisation.setTextSaisie(string2);
            this.a.console.printInPad(string + "\n = " + string2 + "\n");
        }
        return string2;
    }

    private String evalAdjust(String string) {
        int n = string.length();
        if (n == 0 || string.charAt(0) != '=' && string.charAt(n - 1) != '=') {
            return string;
        }
        if (string.charAt(0) == '=' && !Character.isSpace(string.charAt(1))) {
            return "= " + string.substring(1);
        }
        if (string.charAt(n - 1) == '=' && !string.startsWith("http://")) {
            return "= " + string.substring(0, n - 1).trim();
        }
        return string;
    }

    private String execFunction(String string) {
        try {
            Function function;
            String string2 = string;
            String string3 = "";
            int n = string.indexOf(40);
            if (n > 0) {
                string2 = string.substring(0, n);
                int n2 = string.lastIndexOf(41);
                string3 = string.substring(n + 1, n2);
            }
            if ((function = this.getFunction(string2)) == null) {
                return "Function unknown [" + string2 + "]";
            }
            return function.exec(this.a, string3, false);
        }
        catch (Exception exception) {
            return "Function syntax error [" + string + "]";
        }
    }

    private String listFunction(String string) {
        try {
            boolean bl = false;
            if (string != null && string.length() > 0) {
                bl = true;
            } else {
                string = null;
            }
            StringBuffer stringBuffer = new StringBuffer(1000);
            for (Function function : this.function) {
                String string2 = function.getName();
                if (string != null && !Util.matchMask(string, function.getName())) continue;
                if (bl) {
                    stringBuffer.append(function + "\n");
                    continue;
                }
                stringBuffer.append(string2 + (function.getDescription().length() > 0 ? " - " + function.getDescription() : "") + "\n");
            }
            this.print(stringBuffer.toString());
            this.a.console.printInPad(stringBuffer.toString());
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return exception.getMessage();
        }
    }

    public void resetBookmarks() {
        if (this.function == null) {
            return;
        }
        Iterator<Function> iterator = this.function.iterator();
        while (iterator.hasNext()) {
            iterator.next().setBookmark(false);
        }
    }

    public Vector<Function> getBookmarkFunctions() {
        return this.getFunctions(0);
    }

    protected Vector<Function> getLocalFunctions() {
        return this.getFunctions(1);
    }

    private Vector<Function> getFunctions(int n) {
        Vector<Function> vector = new Vector<Function>(10);
        if (this.getNbFunctions() == 0) {
            return vector;
        }
        for (Function function : this.function) {
            if (n == 0 && function.isBookmark()) {
                vector.addElement(function);
                continue;
            }
            if (n != 1 || !function.isLocalDefinition()) continue;
            vector.addElement(function);
        }
        return vector;
    }

    protected void testscript(String string) {
        this.a.console.setVisible(true);
        this.a.console.clearPad();
        this.a.console.printInPad(this.TEST.replace(';', '\n'));
        this.execScript(this.TEST);
        this.a.glu.showDocument("Http", "http://aladin.u-strasbg.fr/java/Testscript.jpg", true);
    }

    protected void testnet() {
        block3: {
            Plan plan = this.a.calque.getPlanBase();
            if (!(plan instanceof PlanBG)) {
                this.a.console.printError("testnet only on HiPS");
                return;
            }
            try {
                ((PlanBG)plan).testnet();
            }
            catch (Exception exception) {
                this.a.console.printError("testnet error: " + exception.getMessage());
                if (Aladin.levelTrace < 3) break block3;
                exception.printStackTrace();
            }
        }
    }

    private void testperf(final String string) {
        new Thread(){

            @Override
            public void run() {
                String string2 = string == null || string.trim().length() == 0 ? "AladinTestDisk.tmp" : string;
                File file = new File(string2);
                try {
                    long l;
                    if (file.exists()) {
                        if (string == null || string.trim().length() == 0) {
                            file.delete();
                        } else {
                            if (!file.isDirectory()) {
                                Command.this.printConsole("!!! testperf error: test file is already existing [" + string + "]");
                                return;
                            }
                            file = new File(string2 = Util.concatDir(string2, "AladinTestDisk.tmp"));
                            if (file.exists()) {
                                file.delete();
                            }
                        }
                    }
                    byte[] byArray = new byte[512];
                    for (int i = 0; i < byArray.length; ++i) {
                        byArray[i] = (byte)i;
                    }
                    int n = 0;
                    Command.this.print("testperf disk writing...");
                    long l2 = System.currentTimeMillis();
                    RandomAccessFile randomAccessFile = new RandomAccessFile(string2, "rw");
                    for (l = 0x40000000L; l > 0L; l -= (long)byArray.length) {
                        randomAccessFile.write(byArray);
                        if ((n += byArray.length) < 0xA00000) continue;
                        Command.this.print(".");
                        n = 0;
                    }
                    Command.this.println("");
                    randomAccessFile.close();
                    long l3 = System.currentTimeMillis() - l2;
                    double d = 1.073741824E9 / ((double)l3 / 1000.0) / 1048576.0;
                    Command.this.print("testperf disk reading...");
                    l2 = System.currentTimeMillis();
                    randomAccessFile = new RandomAccessFile(string2, "rw");
                    for (l = randomAccessFile.length(); l > 0L; l -= (long)byArray.length) {
                        randomAccessFile.read(byArray);
                        if ((n += byArray.length) < 0xA00000) continue;
                        Command.this.print(".");
                        n = 0;
                    }
                    Command.this.println("");
                    randomAccessFile.close();
                    long l4 = System.currentTimeMillis() - l2;
                    double d2 = 1.073741824E9 / ((double)l4 / 1000.0) / 1048576.0;
                    double d3 = 0.0;
                    try {
                        int n2;
                        Command.this.println("testperf memory...");
                        long l5 = 0x10000000L;
                        int n3 = 10;
                        byArray = new byte[(int)l5];
                        for (n2 = 0; n2 < byArray.length; ++n2) {
                            byArray[n2] = (byte)n2;
                        }
                        l2 = System.currentTimeMillis();
                        for (n2 = 0; n2 < n3; ++n2) {
                            for (int i = 0; i < byArray.length; ++i) {
                                byArray[i] = (byte)(byArray[i] + i);
                            }
                        }
                        l = 0L;
                        for (n2 = 0; n2 < byArray.length; ++n2) {
                            l += (long)byArray[n2];
                        }
                        Command.this.println("Optimiser obfuscator...(" + l + ")...");
                        long l6 = System.currentTimeMillis() - l2;
                        d3 = (double)l5 / ((double)l6 / 1000.0) / 1.073741824E9 * (double)n3;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    Command.this.printConsole("testperf: Disk: w=" + Util.myRound(d) + "MB/s r=" + Util.myRound(d2) + "MB/s - Memory: r/w=" + Util.myRound(d3) + "GB/s");
                    file.delete();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    file.delete();
                }
            }
        }.start();
    }

    private long testDiskFlush(File file, long l) {
        if (l <= 0L) {
            return l;
        }
        File[] fileArray = file.listFiles();
        for (int i = 0; fileArray != null && i < fileArray.length; ++i) {
            if (fileArray[i].isDirectory()) {
                l = this.testDiskFlush(fileArray[i], l);
            } else {
                if (fileArray[i].length() < 0x100000L) continue;
                try {
                    RandomAccessFile randomAccessFile = new RandomAccessFile(fileArray[i], "r");
                    byte[] byArray = new byte[512];
                    for (long j = randomAccessFile.length(); j > 0L; j -= (long)byArray.length) {
                        randomAccessFile.read(byArray, 0, j > (long)byArray.length ? byArray.length : (int)j);
                    }
                    l -= randomAccessFile.length();
                    randomAccessFile.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            if (l > 0L) continue;
            return l;
        }
        return l;
    }

    protected void testCalib(String string, String string2, int n) {
        String string3;
        Object object;
        boolean bl;
        int n2 = 50;
        int n3 = 30;
        int n4 = 16;
        Coord coord = new Coord();
        double d = 0.016666666666666666;
        int n5 = 2;
        boolean bl2 = n == 1 || n == 2;
        boolean bl3 = bl = n == 0 || n == 2;
        if (string == null) {
            string = "Test";
        }
        try {
            object = new StringTokenizer(string2);
            n2 = Integer.parseInt(((StringTokenizer)object).nextToken());
            n3 = Integer.parseInt(((StringTokenizer)object).nextToken());
            string3 = ((StringTokenizer)object).nextToken() + " " + ((StringTokenizer)object).nextToken();
            coord = new Coord(string3);
            d = Double.parseDouble(((StringTokenizer)object).nextToken()) / 60.0;
            n5 = Calib.getProjType(((StringTokenizer)object).nextToken()) - 1;
            if (n5 < 0) {
                n5 = 2;
            }
            n4 = Integer.parseInt(((StringTokenizer)object).nextToken());
        }
        catch (Exception exception) {
            // empty catch block
        }
        object = "Test.fits";
        string3 = "Test.txt";
        String string4 = "Calibration grid test:\n" + (bl2 ? "- Catalog file: " + string3 + "\n   .catalog size        : " + n2 * n3 / 25 + " objects\n   .Dist. between ojects: " + d * 300.0 + "\"\n" : "") + (bl ? "- Image file  : " + (String)object + "\n   .bitpix              : " + n4 + "\n   .Image size          : " + n2 + "x" + n3 + "\n   .Central coord       : " + coord + "\n   .Pixel size          : " + d * 60.0 + "\"\n   .Projection          : " + Calib.projType[n5] : "");
        System.out.println(string4);
        if (bl) {
            this.createFitsTest((String)object, n2, n3, n4, coord.al, coord.del, d, n5);
            this.a.load((String)object, string);
        }
        if (bl2) {
            this.createTSVTest(string3, n2, n3, coord.al, coord.del, d);
            this.a.load(string3, string + (n == 2 ? " cat" : ""));
        }
    }

    protected void createTSVTest(String string, int n, int n2, double d, double d2, double d3) {
        try {
            int n3 = n / 2 - 1;
            int n4 = n2 / 2 - 1;
            double d4 = d3 / 60.0;
            Astrocoo astrocoo = new Astrocoo();
            int n5 = 1;
            File file = new File(this.a.getDefaultDirectory() + Util.FS + string);
            file.delete();
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("RA\tDEC\tX Fits\tY Fits\tSexa\n");
            for (int i = 0; i < n2; ++i) {
                double d5 = d2 + (double)(i - n4) * d4;
                double d6 = Math.cos(d5 * Math.PI / 180.0);
                for (int j = 0; j < n; ++j) {
                    if ((j - n3) % 5 != 0 || (i - n4) % 5 != 0) continue;
                    double d7 = (d + (double)(j - n3) * d4) / d6;
                    if (d5 > 90.0) {
                        d5 = 180.0 - d5;
                        d7 += 180.0;
                    }
                    if (d5 < -90.0) {
                        d5 = -180.0 - d5;
                        d7 += 180.0;
                    }
                    if (d7 < 0.0) {
                        d7 += 360.0;
                    } else if (d7 > 360.0) {
                        d7 -= 360.0;
                    }
                    astrocoo.set(d7, d5);
                    stringBuffer.append(astrocoo.getLon() + "\t" + astrocoo.getLat() + "\t" + (j + 1) + "\t" + (i + 1) + "\t" + astrocoo.toString("2s") + "\n");
                    if (++n5 != 1000) continue;
                    this.writeString(randomAccessFile, stringBuffer.toString());
                    n5 = 0;
                    stringBuffer = new StringBuffer();
                }
            }
            if (n5 != 0) {
                this.writeString(randomAccessFile, stringBuffer.toString());
            }
            randomAccessFile.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void writeString(RandomAccessFile randomAccessFile, String string) throws Exception {
        char[] cArray = string.toString().toCharArray();
        byte[] byArray = new byte[cArray.length];
        for (int i = 0; i < cArray.length; ++i) {
            byArray[i] = (byte)cArray[i];
        }
        randomAccessFile.write(byArray);
    }

    protected void createFitsTest(String string, int n, int n2, int n3, double d, double d2, double d3, int n4) {
        try {
            int n5;
            int n6;
            int n7;
            byte[] byArray;
            double d4 = d3 * (double)n;
            double d5 = d3 * (double)n2;
            int n8 = n / 2;
            int n9 = n2 / 2;
            Projection projection = new Projection("Test", 3, d, d2, d4, d5, (double)n8 - 0.5, (double)n9 - 0.5, n, n2, 0.0, true, n4, Calib.FK5);
            File file = new File(this.a.getDefaultDirectory() + Util.FS + string);
            file.delete();
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
            Vector vector = new Vector(20);
            Vector vector2 = new Vector(20);
            try {
                projection.getWCS(vector, vector2);
            }
            catch (Exception exception) {
                System.err.println("GetWCS error");
            }
            Vector<byte[]> vector3 = new Vector<byte[]>();
            vector3.addElement(Save.getFitsLine("SIMPLE", "T", "Aladin image test"));
            vector3.addElement(Save.getFitsLine("BITPIX", n3 + "", null));
            vector3.addElement(Save.getFitsLine("NAXIS", "2", null));
            Enumeration enumeration = vector.elements();
            Enumeration enumeration2 = vector2.elements();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                String string3 = (String)enumeration2.nextElement();
                vector3.addElement(Save.getFitsLine(string2, string3, ""));
            }
            long l = 0L;
            Enumeration enumeration3 = vector3.elements();
            while (enumeration3.hasMoreElements()) {
                byArray = (byte[])enumeration3.nextElement();
                randomAccessFile.write(byArray);
                l += (long)byArray.length;
            }
            byArray = new byte[]{69, 78, 68};
            randomAccessFile.write(byArray);
            byte[] byArray2 = new byte[2880 - (int)(l += 3L) % 2880];
            for (n7 = 0; n7 < byArray2.length; ++n7) {
                byArray2[n7] = 32;
            }
            randomAccessFile.write(byArray2);
            n7 = Math.abs(n3) / 8;
            boolean bl = (long)(n * n2 * n7) > Aladin.LIMIT_HUGEFILE;
            byte[] byArray3 = new byte[n * n7 * (bl ? 1 : n2)];
            --n8;
            --n9;
            double d6 = (double)(n + n2) / 1600.0;
            int n10 = 0;
            for (n6 = 0; n6 < n2; ++n6) {
                for (n5 = 0; n5 < n; ++n5) {
                    double d7;
                    double d8 = n6 == n9 && n5 == n8 ? 900.0 : (n6 == n9 || n5 == n8 ? 700.0 : (n6 > n9 - 100 && n6 < n9 && n5 > n8 && n5 < n8 + 100 ? -100.0 : ((n6 - n9) % 100 == 0 || (n5 - n8) % 100 == 0 ? 500.0 : ((n6 - n9) % 10 == 0 || (n5 - n8) % 10 == 0 ? 300.0 : ((n6 - n9) % 5 == 0 || (n5 - n8) % 5 == 0 ? 200.0 : (n6 < n9 && n5 < n8 ? (double)(n6 + n5) / d6 - 100.0 : (d7 = n6 % 2 == 0 || n5 % 2 == 0 ? 0.0 : -100.0)))))));
                    if (n3 == 8) {
                        d7 = (d7 + 100.0) / 4.0;
                    }
                    PlanImage.setPixVal(byArray3, n3, n10++, d7);
                }
                if (!bl) continue;
                randomAccessFile.write(byArray3);
                n10 = 0;
            }
            if (!bl) {
                n6 = 1;
                n5 = 1;
                for (int i = 10; i < 100; i += 10) {
                    int n11 = i;
                    double[][] dArray = this.a.kernelList.getKernel(n5);
                    if ((n5 += n6) == 6) {
                        n6 = -1;
                        n5 = 5;
                    }
                    if (n5 == 0) break;
                    int n12 = dArray[0].length;
                    for (int j = 0; j < n12; ++j) {
                        for (int k = 0; k < n12; ++k) {
                            double d9 = dArray[j][k] * 1000.0 - 100.0;
                            if (n3 == 8) {
                                d9 = (d9 + 100.0) / 4.0;
                            }
                            int n13 = n8 + (i - n12 / 2 + k);
                            int n14 = n9 - (n11 - n12 / 2 + j);
                            if (n14 < n2 && n14 >= 0 && n13 < n && n13 >= 0) {
                                PlanImage.setPixVal(byArray3, n3, n14 * n + n13, d9);
                            }
                            n13 = n8 + (i - n12 / 2 + k);
                            n14 = n9 - (100 - (n11 - n12 / 2 + j));
                            if (n14 >= n2 || n14 < 0 || n13 >= n || n13 < 0) continue;
                            PlanImage.setPixVal(byArray3, n3, n14 * n + n13, d9);
                        }
                    }
                }
                randomAccessFile.write(byArray3);
            }
            randomAccessFile.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void hop() {
        try {
            this.a.calque.stack();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static {
        drawMode = DRAWRADEC = 1;
        CMD = new String[]{"addcol", "backup", "bitpix", "blink", "call", "cm", "cmoc", "collapse", "conv", "contour", "coord", "copy", "ccat", "cview", "crop", "demo", "draw", "expand", "export", "filter", "moreonfilter", "function", "flipflop", "get", "grey", "grid", "help", "hide", "hist", "info", "kernel", "list", "load", "lock", "macro", "md", "mem", "northup", "match", "mosaic", "mv", "norm", "overlay", "pause", "print", "quit", "resamp", "reset", "reticle", "RGB", "RGBdiff", "rm", "save", "scale", "search", "select", "set", "setconf", "show", "status", "sync", "tag", "thumbnail", "trace", "unlock", "untag", "xmatch", "moreonxmatch", "zoom", "+", "-", "*", "/", "="};
        NOSYNCCMD = new String[]{"call", "collapse", "demo", "expand", "function", "=", "get", "grid", "help", "hist", "info", "list", "kernel", "load", "lock", "md", "mem", "pause", "reticle", "scale", "status", "stick", "sync", "timeout", "trace", "unlock", "unstick"};
        lockSyncNeedSesame = new Object();
        lockSyncNeedRepaint = new Object();
        UNIT = new String[]{"m", "arcmin", "'", "s", "sec", "\"", "d", "deg", "\u00b0"};
    }
}

