/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Localisation;
import cds.aladin.Tok;
import cds.tools.Util;

public final class CommandDS9 {
    private Aladin aladin;
    private int previousFrame = 5;
    private int currentFrame = -1;
    private static String SAOTNFORMATERROR = "!!!SAOTN compatibility error (format parsing failed)";
    private static String[] STCKEYS = new String[]{"LOCAL_GROUP_CENTER", "GALACTIC_CENTER", "UNKNOWNRefPos", "EMBARYCENTER", "HELIOCENTER", "BARYCENTER", "TOPOCENTER", "GEOCENTER", "JUPITER", "MERCURY", "NEPTUNE", "URANUS", "SATURN", "PLUTO", "VENUS", "LSRD", "LSRK", "MOON", "MARS", "LSR"};
    private static final String[] TEST = new String[]{"# Region file format: DS9 version 4.1", "# Filename: C:/Documents and Settings/Standard/Mes documents/Fits et XML/dss1.fits", "global color=green dashlist=8 3 width=1 font=\"helvetica 10 normal\" select=1 highlite=1 dash=0 fixed=0 edit=1 move=1 delete=1 include=1 source=1", "fk5", "circle(83.660376,22.042708,31.940586\")", "ellipse(83.585086,22.03882,79.491097\",38.786247\",351.70206)", "box(83.690273,22.020911,67.517674\",45.347692\",359.61543)", "polygon(83.63402,22.012313,83.621943,22.012238,83.622024,22.001041,83.634101,22.001117)", "polygon 83.610533 22.011943 83.584443 22.011775", "line(83.661236,22.006322,83.671597,21.992668) # line=0 0", "ecliptic;line(83.646735,22.007633,83.627889,21.983442) # line=0 0", "#  vector(83.702004,22.049953,94.710207\",20.171478) vector=1", "# text(83.646667,22.01715) color=red width=2 text={Region}", "# composite(83.667432,22.012471,23.324274) || composite=1", "point(83.667432,22.012471) || # point=boxcircle", "  point  83.667432  22.012471  ", "text(84.059752,21.854908) || textangle=22.939706 text={S0}", "polygon(84.099463,21.761356,83.958987,21.817998,84.019991,21.948451,84.16057,21.891758) ||", "b1950; circle 82.907937d 22.010159d 31.940586", "circle(83.660376,22.042708,31.940586\")", "# Region STC ", "stc POLYGON ICRS 172.3051205700001 29.00697160000002 172.35133123000008 29.000585790000006 172.3475670999997 28.98066108000001 172.33490575999994 28.98246860000003 172.33324013999982 28.973249709999987 172.32257678999994 28.974723670000003 172.32063336000007 28.963602760000004 172.29783566999998 28.966582310000014", "draw stc POLYGON ICRS 172.3051205700001 29.00697160000002 172.35133123000008 29.000585790000006 172.3475670999997 28.98066108000001 172.33490575999994 28.98246860000003 172.33324013999982 28.973249709999987 172.32257678999994 28.974723670000003 172.32063336000007 28.963602760000004 172.29783566999998 28.966582310000014"};

    public CommandDS9(Aladin aladin) {
        this.aladin = aladin;
    }

    public String translate(String string) throws Exception {
        StringBuffer stringBuffer = null;
        if (this.aladin != null) {
            this.previousFrame = this.aladin.localisation.getFrame();
        }
        Tok tok = new Tok(string, ";");
        int n = 0;
        while (tok.hasMoreTokens()) {
            String string2 = this.translateOne(tok.nextToken());
            if (string2 == null) continue;
            if (string2.length() >= 0 && stringBuffer == null) {
                stringBuffer = new StringBuffer();
            }
            if (string2.length() == 0) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append(';');
            }
            stringBuffer.append(string2);
            ++n;
        }
        if (stringBuffer == null) {
            return null;
        }
        if (n > 1 && this.currentFrame != -1 && !Localisation.isSameFrame(this.previousFrame, this.currentFrame)) {
            stringBuffer.append(";setconf frame=" + Localisation.getFrameName(this.previousFrame));
        }
        return stringBuffer.toString();
    }

    public String translateOne(String string) throws Exception {
        if ((string = this.trimCom(string)) == null) {
            return null;
        }
        Tok tok = new Tok(string, "( ");
        String string2 = tok.nextToken();
        if (string2.equalsIgnoreCase("draw") && tok.nextToken().equalsIgnoreCase("stc")) {
            return this.translateOne(string.substring(string2.length()));
        }
        if (string2.equalsIgnoreCase("stc")) {
            return this.translateOne(string.substring(string2.length()));
        }
        if (string2.equalsIgnoreCase("circle") || string2.equalsIgnoreCase("line") || string2.equalsIgnoreCase("polygon") || string2.equalsIgnoreCase("box") || string2.equalsIgnoreCase("global") || string2.equalsIgnoreCase("ellipse")) {
            return this.basicDS9toAladin(string);
        }
        if (string2.equalsIgnoreCase("rotbox")) {
            return this.rotboxCIAtoAladin(string);
        }
        if (string2.equalsIgnoreCase("ruler")) {
            return this.rulerDS9toAladin(string);
        }
        if (string2.equalsIgnoreCase("point")) {
            return this.pointDS9toAladin(string);
        }
        if (string2.equalsIgnoreCase("vector")) {
            return this.basicDS9toAladin(string);
        }
        if (string2.equalsIgnoreCase("text")) {
            return this.textDS9toAladin(string);
        }
        if (string2.equalsIgnoreCase("composite")) {
            return this.compositeDS9toAladin(string);
        }
        if (string2.equalsIgnoreCase("format:")) {
            return this.formatSAOTNtoAladin(string);
        }
        if (string2.equalsIgnoreCase("region")) {
            return this.formatCIAOtoAladin(string);
        }
        if (string2.equalsIgnoreCase("fk5") || string2.equalsIgnoreCase("j2000") || string2.equalsIgnoreCase("fk4") || string2.equalsIgnoreCase("b1950") || string2.equalsIgnoreCase("galactic") || string2.equalsIgnoreCase("ecliptic") || string2.equalsIgnoreCase("icrs") || string2.equalsIgnoreCase("image")) {
            return this.frameDS9toAladin(string);
        }
        return null;
    }

    private String trimCom(String string) {
        char c;
        int n;
        if (string == null) {
            return null;
        }
        int n2 = string.length();
        for (n = 0; n < n2 && ((c = string.charAt(n)) == '#' || c == '+' || Character.isSpace(c)); ++n) {
        }
        return n == 0 ? string : (n == n2 ? null : string.substring(n));
    }

    private String rulerDS9toAladin(String string) throws Exception {
        int n = string.indexOf("ruler");
        return this.basicDS9toAladin("dist" + string.substring(n + 5));
    }

    private String rotboxCIAtoAladin(String string) throws Exception {
        int n = string.indexOf("rot");
        return this.basicDS9toAladin(string.substring(n + 3));
    }

    private String formatCIAOtoAladin(String string) throws Exception {
        if (string.indexOf("CIAO version") < 0) {
            return null;
        }
        return this.frameDS9toAladin("J2000");
    }

    private String formatSAOTNtoAladin(String string) throws Exception {
        int n = string.lastIndexOf(40);
        int n2 = string.indexOf(41, n);
        if (n < 0 || n2 < 0) {
            throw new Exception(SAOTNFORMATERROR);
        }
        return this.frameDS9toAladin(string.substring(n + 1, n2));
    }

    private String textDS9toAladin(String string) throws Exception {
        boolean bl = false;
        int n = 0;
        int n2 = string.lastIndexOf("text={");
        if (n2 < 0) {
            bl = true;
        } else {
            n = string.indexOf("}", n2 += 6);
        }
        Tok tok = new Tok(string, "( ,)");
        tok.nextToken();
        String string2 = "draw string(" + tok.nextToken() + "," + tok.nextToken() + "," + Tok.quote(bl ? tok.nextToken() : string.substring(n2, n)) + ")";
        return string2;
    }

    private String pointDS9toAladin(String string) throws Exception {
        Tok tok = new Tok(string, "( ,)");
        tok.nextToken();
        return "draw tag(" + tok.nextToken() + "," + tok.nextToken() + ")";
    }

    private String compositeDS9toAladin(String string) throws Exception {
        Tok tok = new Tok(string, "( ,)");
        tok.nextToken();
        return "draw newfov(" + tok.nextToken() + "," + tok.nextToken() + ")";
    }

    private String frameDS9toAladin(String string) throws Exception {
        int n = -1;
        if (string.equals("fk5") || string.equals("j2000")) {
            n = 5;
        } else if (string.equals("icrs")) {
            n = 0;
        } else if (string.equals("fk4") || string.equals("b1950")) {
            n = 7;
        } else if (string.equals("galactic")) {
            n = 3;
        } else if (string.equals("ecliptic")) {
            n = 2;
        } else if (string.equals("image")) {
            n = 11;
        } else {
            return null;
        }
        if (n == this.previousFrame) {
            return "";
        }
        this.currentFrame = n;
        return "setconf frame=" + Localisation.getFrameName(this.currentFrame);
    }

    private String basicDS9toAladin(String string) throws Exception {
        int n;
        String string2 = null;
        int n2 = string.indexOf(35);
        int n3 = string.indexOf(124);
        int n4 = string.indexOf(41);
        int n5 = n4 > 0 ? n4 + 1 : (n2 > 0 && n3 > 0 ? Math.min(n2, n3) : (n = n2 > 0 ? n2 : n3));
        if (n == -1) {
            n = string.length();
        }
        string = string.substring(0, n).trim();
        Tok tok = new Tok(string, "( ,)");
        StringBuffer stringBuffer = new StringBuffer("draw " + tok.nextToken().toLowerCase() + "(");
        boolean bl = true;
        while (tok.hasMoreTokens()) {
            String string3 = tok.nextToken();
            if (this.isSTCKeyword(string3)) continue;
            if (!bl) {
                stringBuffer.append(',');
            } else if (!Character.isDigit(string3.charAt(0))) {
                string2 = "setconf frame=" + string3 + ";";
                continue;
            }
            bl = false;
            stringBuffer.append(Tok.quote(string3));
        }
        stringBuffer.append(')');
        return (string2 != null ? string2 : "") + stringBuffer.toString();
    }

    private boolean isSTCKeyword(String string) {
        return Util.indexInArrayOf(string, STCKEYS, true) >= 0;
    }

    public static void main(String[] stringArray) {
        int n;
        CommandDS9 commandDS9 = new CommandDS9(null);
        for (n = 0; n < TEST.length; ++n) {
            System.out.println(TEST[n]);
        }
        System.out.println();
        for (n = 0; n < TEST.length; ++n) {
            String string;
            try {
                string = commandDS9.translate(TEST[n]);
            }
            catch (Exception exception) {
                string = "Exception: " + exception.getMessage();
                exception.printStackTrace();
            }
            System.out.println(string == null ? "null" : string);
        }
    }
}

