/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Calib;
import cds.aladin.CanvasColorMap;
import cds.aladin.FrameColorMap;
import cds.aladin.Function;
import cds.aladin.Glu;
import cds.aladin.Localisation;
import cds.aladin.MyInputStream;
import cds.aladin.PlanBG;
import cds.aladin.PlanImage;
import cds.aladin.Projection;
import cds.aladin.Tok;
import cds.aladin.prop.PropPanel;
import cds.tools.Util;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.net.URL;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.concurrent.LinkedBlockingDeque;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public final class Configuration
extends JFrame
implements Runnable,
ActionListener,
ItemListener,
ChangeListener {
    static final String ASTRONOMER = "astronomer";
    static final String UNDERGRADUATE = "undergraduate";
    static final String PREVIEW = "preview";
    private static String CONFIGNAME = "Aladin.conf";
    private static String CONFIGBKM = "Bookmarks.ajs";
    protected static String BROWSER = "UnixBrowser";
    protected static String GLU = "DefaultGluSite";
    protected static String DIR = "DefaultDir";
    protected static String CM = "DefaultCM";
    protected static String BKG = "BackgroundCM";
    protected static String POSITION = "PositionMode";
    protected static String LANG = "Language";
    protected static String CSV = "CSVchar";
    protected static String AUTODIST = "AutoDistance";
    protected static String SIMBAD = "SimbadPointer";
    protected static String VIZIERSED = "VizierSEDPointer";
    protected static String FILTER = "DedicatedFilter";
    protected static String TRANSOLD = "FootprintTransparency";
    protected static String TRANS = "Transparency";
    protected static String TRANSLEVEL = "TransparencyLevel";
    protected static String SURVEY = "Survey";
    protected static String SERVER = "Server";
    protected static String WINLOC = "WindowLocation";
    protected static String RETICLE = "Reticle";
    protected static String TOOLTIP = "Tooltip";
    protected static String SCROLL = "AutoScroll";
    protected static String MOD = "Profile";
    protected static String HPXGRID = "HealpixGrid";
    protected static String MESURE = "HideMeasurements";
    protected static String MHEIGHT = "MeasurementHeight";
    protected static String BOOKMARKS = "Bookmarks";
    protected static String FRAME = "Frame";
    protected static String FRAMEALLSKY = "FrameAllsky";
    protected static String PROJALLSKY = "ProjAllsky";
    protected static String VERSION = "Version";
    protected static String OFFICIALVERSION = "OfficialVersion";
    protected static String CACHE = "HpxCacheSize";
    protected static String MAXCACHE = "HpxMaxCacheSize";
    protected static String LOG = "Log";
    protected static String LOOKANDFEEL = "LookAndFeel";
    protected static String HELP = "Wizard";
    protected static String SLEPOCH = "SliderEpoch";
    protected static String SLSIZE = "SliderSize";
    protected static String SLDENS = "SliderDensity";
    protected static String SLCUBE = "SliderCube";
    protected static String SLOPAC = "SliderOpac";
    protected static String SLZOOM = "SliderZoom";
    protected static String SEDWAVE = "SEDWave";
    protected static String LASTFILE = "LastFile";
    protected static String LASTRUN = "LastRun";
    protected static String STOPHELP = "StopHelp";
    static String NOTACTIVATED = "Not activated";
    static String ACTIVATED = "Activated";
    static String JAVA = "Java";
    static String OPSYS = "OS native";
    static String TITLE;
    static String DEFDIR;
    static String DEFDIRH;
    static String LANGUE;
    static String LANGUEH;
    static String LANGCONTRIB;
    static String CSVCHAR;
    static String CSVCHARH;
    static String PIXB;
    static String PIX8;
    static String PIXF;
    static String CMB;
    static String CMH;
    static String CMV;
    static String CMM;
    static String CMC;
    static String CMF;
    static String WEBB;
    static String WEBH;
    static String RELOAD;
    static String REGB;
    static String REGH;
    static String APPLY;
    static String CLOSE;
    static String BROWSE;
    static String FRAMEB;
    static String FRAMEALLSKYB;
    static String FRAMEH;
    static String OPALEVEL;
    static String PROJALLSKYB;
    static String PROJALLSKYH;
    static String FILTERB;
    static String FILTERH;
    static String FILTERN;
    static String FILTERY;
    static String SMBB;
    static String SMBH;
    static String TRANSB;
    static String TRANSH;
    static String IMGB;
    static String IMGH;
    static String IMGS;
    static String IMGC;
    static String MODE;
    static String MODEH;
    static String CACHES;
    static String CACHEH;
    static String CLEARCACHE;
    static String LOGS;
    static String LOGH;
    static String HELPS;
    static String HELPH;
    static String SLIDERS;
    static String SLIDERH;
    static String SLIDEREPOCH;
    static String SLIDERDENSITY;
    static String SLIDERCUBE;
    static String SLIDERSIZE;
    static String SLIDEROPAC;
    static String SLIDERZOOM;
    static String FILEDIALOG;
    static String FILEDIALOGHELP;
    static String FILEDIALOGJAVA;
    static String FILEDIALOGNATIVE;
    private static String[] CSVITEM;
    private static String[] CSVITEMLONG;
    private Aladin aladin;
    private Vector prop;
    private boolean flagModif;
    private boolean first = true;
    private boolean flagModifLang = true;
    private String currentLang = "En";
    protected LinkedBlockingDeque<String> lastFile;
    private JTextField browser;
    private JTextField dir;
    private JTextField maxCache;
    private JLabel cache;
    private JComboBox frameChoice;
    private JComboBox frameAllskyChoice;
    private JComboBox projAllskyChoice;
    private JComboBox videoChoice;
    private JComboBox mapChoice;
    private JComboBox cutChoice;
    private JComboBox fctChoice;
    private JComboBox gluChoice;
    private JComboBox lfChoice;
    private JComboBox langChoice;
    private JComboBox modeChoice;
    private JComboBox filterChoice;
    private JComboBox transparencyChoice;
    private JComboBox logChoice;
    private JComboBox helpChoice;
    private JSlider transparencyLevel;
    private JComboBox csvChoice;
    private int langItem;
    private int modeItem;
    private int csvItem;
    private Vector gluUrl;
    private JTextField serverTxt;
    private JTextField surveyTxt;
    private int lastGluChoice = -1;
    private JButton reload;
    private JCheckBox bxEpoch;
    private JCheckBox bxSize;
    private JCheckBox bxDens;
    private JCheckBox bxCube;
    private JCheckBox bxOpac;
    private JCheckBox bxZoom;
    private static Langue[] lang;
    private Vector remoteLang = null;
    protected static String[] CMPARAM;
    private Thread gluTestThread = null;
    private Vector<String> stopHelp = null;
    private boolean setConfFrame = false;
    private Point initWinLocXY = new Point();
    private Dimension initWinLocWH = new Dimension();
    private int initMesureHeight = 0;
    private int oFrame = 0;
    private static final int MAXLASTFILE = 20;

    protected void createChaine() {
        TITLE = Aladin.chaine.getString("UPTITLE");
        DEFDIR = Aladin.chaine.getString("UPDEFDIR");
        DEFDIRH = Aladin.chaine.getString("UPDEFDIRH");
        LANGUE = Aladin.chaine.getString("UPLANGUE");
        LANGUEH = Aladin.chaine.getString("UPLANGUEH");
        LANGCONTRIB = Aladin.chaine.getString("UPLANGCONTRIB");
        MODE = Aladin.chaine.getString("UPMODE");
        MODEH = Aladin.chaine.getString("UPMODEH");
        CSVCHAR = Aladin.chaine.getString("UPCSVCHAR");
        CSVCHARH = Aladin.chaine.getString("UPCSVCHARH");
        PIXB = Aladin.chaine.getString("UPPIXB");
        PIX8 = "8 bit grey level";
        PIXF = "Full pixel";
        CMB = Aladin.chaine.getString("UPCMB");
        CMH = Aladin.chaine.getString("UPCMH");
        CMV = Aladin.chaine.getString("UPCMV");
        CMM = Aladin.chaine.getString("UPCMM");
        CMC = Aladin.chaine.getString("UPCMC");
        CMF = Aladin.chaine.getString("UPCMF");
        WEBB = Aladin.chaine.getString("UPWEBB");
        WEBH = Aladin.chaine.getString("UPWEBH");
        REGB = Aladin.chaine.getString("UPREGB");
        REGH = Aladin.chaine.getString("UPREGH");
        RELOAD = Aladin.chaine.getString("PROPRELOAD");
        APPLY = Aladin.chaine.getString("UPAPPLY");
        CLOSE = Aladin.chaine.getString("UPCLOSE");
        BROWSE = Aladin.chaine.getString("FILEBROWSE");
        FRAMEB = Aladin.chaine.getString("UPFRAMEB");
        CACHES = Aladin.chaine.getString("UPCACHE");
        CLEARCACHE = Aladin.chaine.getString("NPRESET");
        CACHEH = Aladin.chaine.getString("UPCACHEH");
        FRAMEALLSKYB = Aladin.chaine.getString("UPFRAMEALLSKYB");
        FRAMEH = Aladin.chaine.getString("UPFRAMEH");
        PROJALLSKYB = Aladin.chaine.getString("UPPROJALLSKYB");
        PROJALLSKYH = Aladin.chaine.getString("UPPROJALLSKYH");
        OPALEVEL = Aladin.chaine.getString("PROPOPACITYLEVEL");
        SMBB = Aladin.chaine.getString("UPSMBB");
        SMBH = Aladin.chaine.getString("UPSMBH");
        FILTERB = Aladin.chaine.getString("UPFILTERB");
        FILTERH = Aladin.chaine.getString("UPFILTERH");
        TRANSB = Aladin.chaine.getString("UPTRANSB");
        TRANSH = Aladin.chaine.getString("UPTRANSH");
        IMGB = Aladin.chaine.getString("UPIMGB");
        IMGH = Aladin.chaine.getString("UPIMGH");
        IMGS = Aladin.chaine.getString("UPIMGS");
        IMGC = Aladin.chaine.getString("UPIMGC");
        LOGS = Aladin.chaine.getString("UPLOG");
        LOGH = Aladin.chaine.getString("UPLOGH");
        HELPS = Aladin.chaine.getString("UPHELP");
        HELPH = Aladin.chaine.getString("UPHELPH");
        SLIDERS = Aladin.chaine.getString("UPSLIDERS");
        SLIDERH = Aladin.chaine.getString("UPSLIDERH");
        SLIDEREPOCH = Aladin.chaine.getString("SLIDEREPOCH");
        SLIDERDENSITY = Aladin.chaine.getString("SLIDERDENSITY");
        SLIDERSIZE = Aladin.chaine.getString("SLIDERSIZE");
        SLIDERCUBE = Aladin.chaine.getString("SLIDERCUBE");
        SLIDEROPAC = Aladin.chaine.getString("OPACITY");
        SLIDERZOOM = Aladin.chaine.getString("ZOOM");
        FILEDIALOG = Aladin.chaine.getString("FILEDIALOG");
        FILEDIALOGHELP = Aladin.chaine.getString("FILEDIALOGHELP");
        FILEDIALOGJAVA = Aladin.chaine.getString("FILEDIALOGJAVA");
        FILEDIALOGNATIVE = Aladin.chaine.getString("FILEDIALOGNATIVE");
        CSVITEMLONG = new String[]{"Tab", "Pipe (|)", "Semicolon (;)", "Comma (,)", "Tab or Pipe (|)", "Tab, Pipe (|) or Semicolon (;)"};
    }

    public Configuration(Aladin aladin) {
        this.aladin = aladin;
        Aladin.setIcon(this);
        this.enableEvents(64L);
        Util.setCloseShortcut(this, false, aladin);
        this.prop = new Vector(10);
        this.flagModif = false;
    }

    protected JPanel getValidPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1));
        JButton jButton = new JButton(APPLY);
        jPanel.add(jButton);
        jButton.addActionListener(this);
        jButton.setFont(jButton.getFont().deriveFont(1));
        jButton = new JButton(CLOSE);
        jPanel.add(jButton);
        jButton.addActionListener(this);
        return jPanel;
    }

    @Override
    public void show() {
        if (this.first) {
            this.createChaine();
            this.setTitle(TITLE);
            ((JPanel)this.getContentPane()).setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            Aladin.makeAdd(this.getContentPane(), this.createPanel(), "Center");
            Aladin.makeAdd(this.getContentPane(), this.getValidPanel(), "South");
            this.pack();
            this.first = false;
            this.setLocation(Aladin.computeLocation(this));
        }
        this.updateWidgets();
        super.show();
    }

    private void createGluChoice() {
        this.gluChoice = new JComboBox();
        this.gluChoice.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (Configuration.this.reload != null) {
                    int n = Configuration.this.gluChoice.getSelectedIndex();
                    Configuration.this.reload.setEnabled(n == Configuration.this.lastGluChoice);
                }
            }
        });
        this.gluUrl = new Vector();
        Enumeration enumeration = this.aladin.glu.aladinDic.keys();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            int n2;
            String string = (String)enumeration.nextElement();
            if (!string.startsWith("AlaU.")) continue;
            String string2 = (String)this.aladin.glu.aladinDic.get(string);
            int n3 = string2.indexOf("//");
            if (n < 0 || (n2 = string2.indexOf("/", n3 + 2)) < 0) continue;
            this.gluUrl.addElement(string2);
            string2 = string2.substring(n3 + 2, n2);
            this.gluChoice.addItem(string2);
            ++n;
        }
    }

    private void setSyncMode(String string) throws Exception {
        string = Util.toUpper(string);
        this.aladin.command.setSyncMode(string == null || string.indexOf("OFF") >= 0 || string.indexOf("AUTO") >= 0 ? 0 : 0);
    }

    private void setSimbadMode(String string) throws Exception {
        boolean bl;
        this.aladin.calque.flagSimbad = bl = (string = Util.toUpper(string)) != null && string.indexOf("NO") < 0 && string.indexOf("OFF") < 0;
        this.aladin.setButtonMode();
    }

    private void setFilterMode(String string) throws Exception {
        this.aladin.FILTERDEFAULT = Util.toUpper(string);
    }

    private void setCMMode(String string) throws Exception {
        this.setMode1(string, false);
    }

    private void setBkgMode(String string) throws Exception {
        this.setMode1(string, true);
    }

    private void setMode1(String string, boolean bl) throws Exception {
        if (CMPARAM == null) {
            CMPARAM = new String[4 + PlanImage.TRANSFERTFCT.length + FrameColorMap.CMA.length];
            Configuration.CMPARAM[0] = "reverse";
            Configuration.CMPARAM[1] = "noreverse";
            Configuration.CMPARAM[2] = "autocut";
            Configuration.CMPARAM[3] = "noautocut";
            System.arraycopy(PlanImage.TRANSFERTFCT, 0, CMPARAM, 4, PlanImage.TRANSFERTFCT.length);
            System.arraycopy(FrameColorMap.CMA, 0, CMPARAM, 4 + PlanImage.TRANSFERTFCT.length, FrameColorMap.CMA.length);
        }
        Tok tok = new Tok(string);
        StringBuffer stringBuffer = null;
        while (tok.hasMoreTokens()) {
            String string2 = tok.nextToken();
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer();
            } else {
                stringBuffer.append(' ');
            }
            int n = Util.indexInArrayOf(string2, CMPARAM, true);
            if (n < 0) {
                throw new Exception("Not available cm mode ! [" + string2 + "]");
            }
            stringBuffer.append(CMPARAM[n]);
        }
        if (bl) {
            this.aladin.BKGDEFAULT = stringBuffer.toString();
        } else {
            this.aladin.CMDEFAULT = stringBuffer.toString();
        }
        this.updateWidgets();
    }

    private void setCSV(String string) {
        if (string == null) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals("tab")) {
                stringBuffer.append('\t');
                continue;
            }
            stringBuffer.append(string2.charAt(0));
        }
        this.aladin.CSVCHAR = stringBuffer.toString();
    }

    private void setMaxCache(String string) {
        if (string == null) {
            return;
        }
        try {
            long l = Long.parseLong(string);
            PlanBG.setMaxCacheSize(l);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setTransparency(String string, float f) {
        float f2;
        this.transparencyLevel.setToolTipText(OPALEVEL + " : " + (int)(f * 100.0f));
        boolean bl = Aladin.ENABLE_FOOTPRINT_OPACITY;
        boolean bl2 = !string.equals(NOTACTIVATED);
        if (bl2 != bl) {
            Aladin.ENABLE_FOOTPRINT_OPACITY = bl2;
            this.aladin.calque.repaintAll();
        }
        if (f != (f2 = Aladin.DEFAULT_FOOTPRINT_OPACITY_LEVEL)) {
            Aladin.DEFAULT_FOOTPRINT_OPACITY_LEVEL = f;
            this.aladin.calque.updateFootprintOpacity(f2, f);
            this.aladin.calque.repaintAll();
        }
    }

    protected void setSelectGluChoice(String string) {
        Enumeration enumeration = this.gluUrl.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            if (string != null && string.startsWith((String)enumeration.nextElement())) {
                this.gluChoice.setSelectedIndex(n);
                this.lastGluChoice = n;
                return;
            }
            ++n;
        }
    }

    @Override
    public void run() {
        this.launchGluTest();
    }

    private void launchGluTest() {
        Aladin.makeCursor(this, 1);
        this.aladin.glu.testAlaSites(false, true);
        Aladin.makeCursor(this, 0);
        Glu cfr_ignored_0 = this.aladin.glu;
        this.setSelectGluChoice(Glu.NPHGLUALADIN);
    }

    private boolean isUnixStandalone() {
        if (Aladin.isApplet()) {
            return false;
        }
        String string = System.getProperty("os.name");
        return string != null && !string.startsWith("Windows") && !string.startsWith("Mac");
    }

    protected int getBkgVideo() {
        String string;
        String string2 = string = this.aladin.BKGDEFAULT == null ? this.get(BKG) : this.aladin.BKGDEFAULT;
        if (string != null && string.indexOf("noreverse") >= 0) {
            return 0;
        }
        return Aladin.OUTREACH ? 0 : 1;
    }

    protected int getBkgFct() {
        String string = this.aladin.BKGDEFAULT == null ? this.get(BKG) : this.aladin.BKGDEFAULT;
        return this.getFct1(string);
    }

    private int getFct1(String string) {
        if (string != null) {
            for (int i = 0; i < PlanImage.TRANSFERTFCT.length; ++i) {
                if (string.indexOf(PlanImage.TRANSFERTFCT[i]) < 0) continue;
                return i;
            }
        }
        return 3;
    }

    protected int getBkgMap() {
        String string = this.aladin.BKGDEFAULT == null ? this.get(BKG) : this.aladin.BKGDEFAULT;
        return this.getMap1(string);
    }

    private int getMap1(String string) {
        if (string != null) {
            int n;
            for (n = 0; n < FrameColorMap.CMA.length; ++n) {
                if (string.indexOf(FrameColorMap.CMA[n]) < 0) continue;
                return n;
            }
            if (CanvasColorMap.customCMName != null) {
                Enumeration enumeration = CanvasColorMap.customCMName.elements();
                while (enumeration.hasMoreElements()) {
                    String string2 = (String)enumeration.nextElement();
                    if (string.indexOf(string2) >= 0) {
                        return n;
                    }
                    ++n;
                }
            }
        }
        return Aladin.OUTREACH ? 1 : 0;
    }

    protected int getCMVideo() {
        String string;
        String string2 = string = this.aladin.CMDEFAULT == null ? this.get(CM) : this.aladin.CMDEFAULT;
        if (string != null && string.indexOf("noreverse") >= 0) {
            return 0;
        }
        return Aladin.OUTREACH ? 0 : 1;
    }

    protected boolean getCMCut() {
        String string;
        String string2 = string = this.aladin.CMDEFAULT == null ? this.get(CM) : this.aladin.CMDEFAULT;
        return string == null || string.indexOf("noautocut") < 0;
    }

    protected int getCMFct() {
        String string = this.aladin.CMDEFAULT == null ? this.get(CM) : this.aladin.CMDEFAULT;
        return this.getFct1(string);
    }

    protected int getCMMap() {
        String string = this.aladin.CMDEFAULT == null ? this.get(CM) : this.aladin.CMDEFAULT;
        return this.getMap1(string);
    }

    protected String getServer() {
        String string = this.get(SERVER);
        string = string == null || string.equalsIgnoreCase("allsky") || string.trim().length() == 0 ? "hips" : string;
        return string;
    }

    public String getBookmarks() {
        if (Aladin.OUTREACH) {
            return null;
        }
        return this.get(BOOKMARKS);
    }

    public void resetBookmarks() {
        this.remove(BOOKMARKS);
    }

    protected String getSurvey() {
        String string = this.get(SURVEY);
        string = string == null || string.length() == 0 ? "P/DSS2/color" : string;
        return string;
    }

    protected String getOfficialVersion() {
        return this.get(OFFICIALVERSION);
    }

    protected String getVersion() {
        return this.get(VERSION);
    }

    protected String getLoadImgCmd() {
        String string = this.getSurvey();
        return this.getServer() + (string == null ? "" : "(" + string + ")");
    }

    protected int getFilter() {
        String string;
        String string2 = string = this.aladin.FILTERDEFAULT == null ? this.get(FILTER) : this.aladin.FILTERDEFAULT;
        if (string != null && (Util.indexOfIgnoreCase(string, "NO") >= 0 || Util.indexOfIgnoreCase(string, "OFF") >= 0)) {
            return -1;
        }
        return 0;
    }

    protected boolean showHelpIfOk(String string) {
        return this.showHelpIfOk(null, string);
    }

    protected boolean showHelpIfOk(Component component, String string) {
        if (this.stopHelp == null) {
            this.stopHelp = new Vector();
        }
        if (this.stopHelp.contains(string)) {
            return false;
        }
        if (!Aladin.confirmation(component == null ? this.aladin : component, Aladin.chaine.getString(string) + "\n \n" + Aladin.chaine.getString("STOPHELP"))) {
            this.stopHelp.add(string);
        }
        return true;
    }

    private void initStopHelp(String string) {
        if (string == null) {
            return;
        }
        this.stopHelp = new Vector();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            this.stopHelp.add(stringTokenizer.nextToken());
        }
    }

    private void majStopHelp() {
        if (this.stopHelp == null || this.stopHelp.size() == 0) {
            this.remove(STOPHELP);
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            Enumeration<String> enumeration = this.stopHelp.elements();
            while (enumeration.hasMoreElements()) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(' ');
                }
                stringBuilder.append(enumeration.nextElement());
            }
            this.set(STOPHELP, stringBuilder.toString());
        }
    }

    protected String getLang() {
        if (this.flagModifLang) {
            String string = "User";
            this.flagModifLang = false;
            String string2 = this.get(LANG);
            if (string2 == null) {
                try {
                    string = "Default";
                    string2 = System.getProperty("user.language");
                    string2 = this.getLanguage(string2);
                }
                catch (Exception exception) {
                    string2 = null;
                }
            }
            this.currentLang = this.getLangSuffix(string2);
            Aladin.trace(2, string + " language [" + string2 + "] => assume [" + this.currentLang + "]");
        }
        return this.currentLang;
    }

    protected int getFrame() {
        if (Aladin.OUTREACH) {
            return 0;
        }
        try {
            String string = this.get(FRAME);
            int n = Util.indexInArrayOf(string, Localisation.REPERE);
            if (n >= 0) {
                return n;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    protected int getProjAllsky() {
        if (Aladin.OUTREACH) {
            return 1;
        }
        if (this.aladin.isCinema()) {
            return 16;
        }
        try {
            String string = this.get(PROJALLSKY);
            int n = Projection.getAlaProjIndex(string);
            String string2 = Projection.alaProjToType[n];
            n = Calib.getProjType(string2);
            if (n >= 0) {
                return n;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 1;
    }

    protected void setProjAllsky(String string) throws Exception {
        int n = Projection.getAlaProjIndex(string);
        if (n < 0) {
            throw new Exception("Unknown projection [" + string + "]");
        }
        String string2 = Projection.getAlaProj(n);
        this.set(PROJALLSKY, string2);
    }

    private void setPositionMode(String string) throws Exception {
        if (!this.aladin.localisation.setPositionMode(string)) {
            throw new Exception("Not available position mode ! [" + string + "]");
        }
        this.setConfFrame = true;
    }

    protected boolean getSEDWave() {
        if (Aladin.OUTREACH) {
            return false;
        }
        String string = this.get(SEDWAVE);
        if (string == null) {
            return false;
        }
        return string.equalsIgnoreCase("On");
    }

    protected boolean getAutoDist() {
        if (Aladin.OUTREACH) {
            return false;
        }
        String string = this.get(AUTODIST);
        if (string == null) {
            return false;
        }
        return string.equalsIgnoreCase("On");
    }

    protected boolean getSimbadFlag() {
        if (Aladin.OUTREACH) {
            return true;
        }
        String string = this.get(SIMBAD);
        if (string == null) {
            return false;
        }
        return string.equalsIgnoreCase("On");
    }

    protected boolean getVizierSEDFlag() {
        if (Aladin.OUTREACH) {
            return false;
        }
        String string = this.get(VIZIERSED);
        if (string == null) {
            return false;
        }
        return string.equalsIgnoreCase("On");
    }

    protected int getFrameDrawing() {
        if (Aladin.OUTREACH) {
            return 3;
        }
        if (this.setConfFrame) {
            return this.getFrame();
        }
        String string = this.get(FRAMEALLSKY);
        try {
            int n = Util.indexInArrayOf(string, Localisation.FRAME);
            if (n >= 0) {
                return n;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    protected String getLanguage() {
        String string = this.getLang();
        if (string.length() == 0) {
            return "en";
        }
        return string.substring(1);
    }

    protected boolean isLog() {
        String string = this.get(LOG);
        return string == null || string.equals(ACTIVATED);
    }

    protected boolean isSliderEpoch() {
        String string = this.get(SLEPOCH);
        return string == null || !string.equals("off");
    }

    protected boolean isSliderSize() {
        String string = this.get(SLSIZE);
        return string == null || !string.equals("off");
    }

    protected boolean isSliderDensity() {
        String string = this.get(SLDENS);
        return string == null || !string.equals("off");
    }

    protected boolean isSliderCube() {
        String string = this.get(SLCUBE);
        return string != null && string.equals("on");
    }

    protected boolean isSliderOpac() {
        String string = this.get(SLOPAC);
        return string == null || !string.equals("off");
    }

    protected boolean isSliderZoom() {
        String string = this.get(SLZOOM);
        return string == null || !string.equals("off");
    }

    protected boolean isHelp() {
        String string = this.get(HELP);
        return string == null || string.equals(ACTIVATED);
    }

    public boolean isLookAndFeelJava() {
        String string = this.get(LOOKANDFEEL);
        if (string == null && Aladin.macPlateform) {
            return false;
        }
        return string == null || string.equals(JAVA);
    }

    protected boolean isOutReach() {
        String string = this.get(MOD);
        return string != null && string.charAt(0) == 'u';
    }

    protected boolean isBeginner() {
        String string = this.get(MOD);
        return string != null && string.charAt(0) == 'p';
    }

    public boolean isTransparent() {
        return true;
    }

    public float getTransparencyLevel() {
        return 0.150111f;
    }

    private void addRemoteLanguage() {
        Enumeration enumeration = this.remoteLang.elements();
        while (enumeration.hasMoreElements()) {
            int n;
            Langue langue = (Langue)enumeration.nextElement();
            int n2 = this.langChoice.getItemCount();
            for (n = 0; n < n2 && !((String)this.langChoice.getItemAt(n)).equals(langue.langue); ++n) {
            }
            if (n != n2) continue;
            this.langChoice.addItem(langue.langue);
        }
    }

    private void setRemoteLanguage(String string) {
        block6: {
            try {
                int n = string.indexOf(45);
                int n2 = string.indexOf(45, n + 1);
                int n3 = string.indexOf(".string");
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = n + 1; i < n2; ++i) {
                    char c = string.charAt(i);
                    if (i > n + 1 && Character.isUpperCase(c)) {
                        stringBuffer.append(' ');
                    }
                    stringBuffer.append(c);
                }
                Langue langue = new Langue(stringBuffer.toString());
                try {
                    langue.version = Double.parseDouble(string.substring(n2 + 1, n3));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                langue.file = string;
                this.remoteLang.addElement(langue);
            }
            catch (Exception exception) {
                if (Aladin.levelTrace < 3) break block6;
                exception.printStackTrace();
            }
        }
    }

    protected void loadRemoteLang() {
        this.remoteLang = new Vector();
        if (!Aladin.STANDALONE) {
            return;
        }
        new Thread("loadLang"){

            @Override
            public void run() {
                block4: {
                    try {
                        Langue langue;
                        String string;
                        Util.pause(1000);
                        Aladin.trace(3, "Checking language support...");
                        Configuration.this.aladin;
                        InputStream inputStream = Aladin.cache.get("http://aladin.u-strasbg.fr/java/nph-aladin.pl?frame=getLang");
                        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                        while ((string = bufferedReader.readLine()) != null) {
                            Configuration.this.setRemoteLanguage(string);
                        }
                        inputStream.close();
                        string = Configuration.this.get(LANG);
                        Langue langue2 = Configuration.this.getBestLangVersion(string);
                        if (langue2 != null && (langue = Configuration.this.findLangue(string)) != null && langue.version != langue2.version) {
                            Util.pause(10000);
                            Configuration.this.installRemoteLanguage(string);
                        }
                    }
                    catch (Exception exception) {
                        if (Aladin.levelTrace < 3) break block4;
                        exception.printStackTrace();
                    }
                }
            }
        }.start();
    }

    private Langue findLangue(String string) {
        for (int i = 0; i < lang.length; ++i) {
            if (!lang[i].isLangue(string)) continue;
            return lang[i];
        }
        return null;
    }

    private String getLangSuffix(String string) {
        if (lang == null) {
            return "";
        }
        if (string == null) {
            return "";
        }
        for (int i = 0; i < lang.length; ++i) {
            if (!string.equals(Configuration.lang[i].langue)) continue;
            return (Configuration.lang[i].code.length() > 0 ? "." : "") + Configuration.lang[i].code;
        }
        return "";
    }

    protected String getLanguage(String string) {
        for (int i = 0; i < lang.length; ++i) {
            if (!lang[i].isLangue(string)) continue;
            return Configuration.lang[i].langue;
        }
        return null;
    }

    protected String getLanguageAuthor(String string) {
        for (int i = 0; i < lang.length; ++i) {
            if (!lang[i].isLangue(string)) continue;
            return Configuration.lang[i].auteur;
        }
        return null;
    }

    protected long getHpxCacheSize() {
        long l;
        String string = this.get(CACHE);
        if (string == null) {
            return -1L;
        }
        try {
            l = Long.parseLong(string);
        }
        catch (Exception exception) {
            l = -1L;
        }
        return l;
    }

    private boolean sameWinParam() {
        Configuration configuration = this;
        if (configuration.aladin.isApplet()) {
            return true;
        }
        Dimension dimension = this.aladin.f.getSize();
        Point point = this.aladin.f.getLocation();
        int n = this.aladin.splitH.getMesureHeight();
        return this.initWinLocXY.equals(point) && this.initWinLocWH.equals(dimension) && this.initMesureHeight == n;
    }

    protected Rectangle getWinLocation() {
        try {
            String string = this.get(WINLOC);
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            Rectangle rectangle = new Rectangle(Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()));
            this.setInitWinLoc(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            return rectangle;
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected int getWinDivider() {
        int n = 150;
        try {
            String string = this.get(MHEIGHT);
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setInitMesureHeight(n);
        return n;
    }

    protected void setInitWinLoc(int n, int n2, int n3, int n4) {
        this.initWinLocXY.x = n;
        this.initWinLocXY.y = n2;
        this.initWinLocWH.width = n3;
        this.initWinLocWH.height = n4;
    }

    protected void setInitMesureHeight(int n) {
        this.initMesureHeight = n;
    }

    private int extendLang(int n) {
        int n2;
        if (lang != null) {
            Langue[] langueArray = lang;
            lang = new Langue[langueArray.length + n];
            System.arraycopy(langueArray, 0, lang, 0, langueArray.length);
            n2 = langueArray.length;
        } else {
            lang = new Langue[n];
            n2 = 0;
        }
        return n2;
    }

    protected void setLanguage(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        for (int i = this.extendLang(stringTokenizer.countTokens()); i < lang.length; ++i) {
            block11: {
                String string2 = stringTokenizer.nextToken();
                int n = string2.length();
                Configuration.lang[i] = new Langue(string2);
                int n2 = string2.indexOf(40);
                int n3 = -1;
                if (n2 > 0 && (n3 = string2.indexOf(41, n2)) > 0) {
                    Configuration.lang[i].langue = string2.substring(0, n2).trim();
                    Configuration.lang[i].code = string2.substring(n2 + 1, n3);
                }
                try {
                    int n4;
                    if (n3 <= 0) break block11;
                    n2 = n3;
                    while (n3 < n && !Character.isDigit(string2.charAt(n3))) {
                        ++n3;
                    }
                    if (n3 < n) {
                        n4 = string2.indexOf(32, n3);
                        if (n4 == -1) {
                            n4 = n;
                        }
                        try {
                            Configuration.lang[i].version = Double.parseDouble(string2.substring(n3, n4));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    for (n4 = n2 + 1; n4 < n && !Character.isLetter(string2.charAt(n4)); ++n4) {
                    }
                    if (n4 < n) {
                        Configuration.lang[i].auteur = n3 > n4 ? string2.substring(n4, n3).trim() : string2.substring(n4).trim();
                    }
                }
                catch (Exception exception) {
                    if (Aladin.levelTrace < 3) break block11;
                    exception.printStackTrace();
                }
            }
            Aladin.trace(2, "Supported language [" + Configuration.lang[i].langue + "] (" + Configuration.lang[i].code + ") " + (Configuration.lang[i].version > 0.0 ? Configuration.lang[i].version + "" : "") + " " + Configuration.lang[i].auteur);
        }
    }

    protected JPanel createPanel() {
        if (Aladin.OUTREACH) {
            return this.createPanel1();
        }
        JPanel jPanel = new JPanel(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane(this.createPanel1());
        jPanel.add((Component)jScrollPane, "Center");
        return jPanel;
    }

    private JPanel createPanel1() {
        JButton jButton;
        int n;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(gridBagLayout);
        JPanel jPanel2 = new JPanel(new BorderLayout(5, 5));
        this.langChoice = new JComboBox();
        this.langChoice.addItem("-- default --");
        for (n = 0; n < lang.length; ++n) {
            this.langChoice.addItem(Configuration.lang[n].langue);
        }
        JLabel jLabel = new JLabel(LANGUE);
        jLabel.setFont(jLabel.getFont().deriveFont(1));
        jPanel2.add((Component)this.langChoice, "Center");
        if (!Aladin.OUTREACH) {
            jButton = new JButton(LANGCONTRIB);
            jButton.addActionListener(this);
            jButton.setMargin(new Insets(2, 4, 2, 4));
            jPanel2.add((Component)jButton, "East");
        }
        PropPanel.addCouple(this, jPanel, jLabel, LANGUEH, jPanel2, gridBagLayout, gridBagConstraints, 13);
        this.addRemoteLanguage();
        this.modeChoice = new JComboBox();
        this.modeChoice.addItem(ASTRONOMER);
        this.modeChoice.addItem(UNDERGRADUATE);
        if (Aladin.PROTO) {
            this.modeChoice.addItem(PREVIEW);
        }
        jLabel = new JLabel(MODE);
        jLabel.setFont(jLabel.getFont().deriveFont(1));
        if (!Aladin.setOUTREACH) {
            PropPanel.addCouple(this, jPanel, jLabel, MODEH, this.modeChoice, gridBagLayout, gridBagConstraints, 13);
        }
        if (!Aladin.OUTREACH) {
            jLabel = new JLabel(HELPS);
            jLabel.setFont(jLabel.getFont().deriveFont(1));
            this.helpChoice = new JComboBox();
            this.helpChoice.addItem(ACTIVATED);
            this.helpChoice.addItem(NOTACTIVATED);
            PropPanel.addCouple(this, jPanel, jLabel, HELPH, this.helpChoice, gridBagLayout, gridBagConstraints, 13);
            jLabel = new JLabel(SLIDERS);
            jLabel.setFont(jLabel.getFont().deriveFont(1));
            JPanel jPanel3 = new JPanel(new GridLayout(1, 0));
            this.bxEpoch = new JCheckBox(SLIDEREPOCH);
            jPanel3.add(this.bxEpoch);
            this.bxSize = new JCheckBox(SLIDERSIZE);
            jPanel3.add(this.bxSize);
            this.bxDens = new JCheckBox(SLIDERDENSITY);
            jPanel3.add(this.bxDens);
            this.bxCube = new JCheckBox(SLIDERCUBE);
            jPanel3.add(this.bxCube);
            this.bxOpac = new JCheckBox(SLIDEROPAC);
            jPanel3.add(this.bxOpac);
            this.bxZoom = new JCheckBox(SLIDERZOOM);
            jPanel3.add(this.bxZoom);
            PropPanel.addCouple(this, jPanel, jLabel, SLIDERH, jPanel3, gridBagLayout, gridBagConstraints, 13);
            for (JCheckBox jCheckBox : new JCheckBox[]{this.bxEpoch, this.bxSize, this.bxDens, this.bxCube, this.bxOpac, this.bxZoom}) {
                final Configuration configuration = this;
                jCheckBox.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        Configuration.this.aladin;
                        Aladin.info(configuration, Aladin.chaine.getString("RESTART"));
                    }
                });
            }
        }
        this.dir = new JTextField(35);
        jButton = new JButton(BROWSE);
        jButton.addActionListener(this);
        jButton.setMargin(new Insets(2, 4, 2, 4));
        jLabel = new JLabel(DEFDIR);
        jLabel.setFont(jLabel.getFont().deriveFont(1));
        jPanel2 = new JPanel(new BorderLayout(5, 5));
        jPanel2.add((Component)this.dir, "Center");
        jPanel2.add((Component)jButton, "East");
        PropPanel.addCouple(this, jPanel, jLabel, DEFDIRH, jPanel2, gridBagLayout, gridBagConstraints, 13);
        this.frameChoice = this.aladin.localisation.createSimpleChoice();
        Aladin aladin = this.aladin;
        this.frameAllskyChoice = aladin.localisation.createFrameCombo();
        jLabel = new JLabel(FRAMEB);
        jLabel.setFont(jLabel.getFont().deriveFont(1));
        jPanel2 = new JPanel(new FlowLayout(0, 0, 0));
        jPanel2.add(this.frameChoice);
        jPanel2.add(new JLabel(" - " + FRAMEALLSKYB));
        jPanel2.add(this.frameAllskyChoice);
        if (!Aladin.OUTREACH) {
            PropPanel.addCouple(this, jPanel, jLabel, FRAMEH, jPanel2, gridBagLayout, gridBagConstraints, 13);
        }
        this.projAllskyChoice = new JComboBox<String>(Projection.getAlaProj());
        this.projAllskyChoice.setMaximumRowCount(10);
        jLabel = new JLabel(PROJALLSKYB);
        jLabel.setFont(jLabel.getFont().deriveFont(1));
        jPanel2 = new JPanel(new FlowLayout(0, 0, 0));
        jPanel2.add(this.projAllskyChoice);
        if (!Aladin.OUTREACH) {
            PropPanel.addCouple(this, jPanel, jLabel, PROJALLSKYH, jPanel2, gridBagLayout, gridBagConstraints, 13);
        }
        JComboBox<Object> jComboBox = new JComboBox<String>();
        this.videoChoice = jComboBox;
        jComboBox.addItem("reverse");
        jComboBox.addItem("noreverse");
        jComboBox = FrameColorMap.createComboCM();
        this.mapChoice = jComboBox;
        jComboBox = new JComboBox();
        this.cutChoice = jComboBox;
        jComboBox.addItem("autocut");
        jComboBox.addItem("noautocut");
        jComboBox = new JComboBox();
        this.fctChoice = jComboBox;
        for (n = 0; n < PlanImage.TRANSFERTFCT.length; ++n) {
            jComboBox.addItem(PlanImage.TRANSFERTFCT[n]);
        }
        if (!Aladin.OUTREACH) {
            jPanel2 = new JPanel(new GridLayout(2, 2, 4, 4));
            jPanel2.add(new JLabel("- " + CMV, 2));
            jPanel2.add(this.videoChoice);
            jPanel2.add(new JLabel("  - " + CMM, 2));
            jPanel2.add(this.mapChoice);
            jPanel2.add(new JLabel("- " + CMC, 2));
            jPanel2.add(this.cutChoice);
            jPanel2.add(new JLabel("  - " + CMF, 2));
            jPanel2.add(this.fctChoice);
            jLabel = new JLabel(CMB);
            jLabel.setFont(jLabel.getFont().deriveFont(1));
            PropPanel.addCouple(this, jPanel, jLabel, CMH, jPanel2, gridBagLayout, gridBagConstraints, 13);
        }
        this.filterChoice = new JComboBox();
        this.filterChoice.addItem(NOTACTIVATED);
        this.filterChoice.addItem(ACTIVATED);
        if (!Aladin.OUTREACH) {
            jLabel = new JLabel(FILTERB);
            jLabel.setFont(jLabel.getFont().deriveFont(1));
            PropPanel.addCouple(this, jPanel, jLabel, FILTERH, this.filterChoice, gridBagLayout, gridBagConstraints, 13);
        }
        this.transparencyChoice = new JComboBox();
        this.transparencyChoice.addItem(NOTACTIVATED);
        this.transparencyChoice.addItem(ACTIVATED);
        JPanel jPanel4 = new JPanel(new FlowLayout(0, 0, 0));
        jPanel4.add(this.transparencyChoice);
        this.transparencyLevel = new JSlider(0, 100);
        this.transparencyLevel.setValue((int)(100.0f * Aladin.DEFAULT_FOOTPRINT_OPACITY_LEVEL));
        this.transparencyLevel.setMajorTickSpacing(20);
        this.transparencyLevel.setPaintLabels(true);
        this.transparencyLevel.setPaintTicks(true);
        this.transparencyLevel.setPaintTrack(true);
        this.transparencyLevel.setPreferredSize(new Dimension(230, this.transparencyLevel.getPreferredSize().height));
        this.transparencyLevel.setToolTipText(OPALEVEL + " : " + this.transparencyLevel.getValue());
        this.transparencyLevel.addChangeListener(this);
        jPanel4.add(this.transparencyLevel);
        if (this.isUnixStandalone()) {
            if (!Aladin.OUTREACH) {
                PropPanel.addFilet(jPanel, gridBagLayout, gridBagConstraints);
                this.browser = new JTextField(30);
                jLabel = new JLabel(WEBB);
                jLabel.setFont(jLabel.getFont().deriveFont(1));
                PropPanel.addCouple(this, jPanel, jLabel, WEBH, this.browser, gridBagLayout, gridBagConstraints, 13);
            }
        }
        this.serverTxt = new JTextField(10);
        this.surveyTxt = new JTextField(10);
        if (!Aladin.OUTREACH) {
            JPanel jPanel5 = new JPanel(new FlowLayout(0, 5, 0));
            jPanel5.add(new JLabel(IMGS, 2));
            jPanel5.add(this.serverTxt);
            jPanel5.add(new JLabel(IMGC, 2));
            jPanel5.add(this.surveyTxt);
            jLabel = new JLabel(IMGB);
            jLabel.setFont(jLabel.getFont().deriveFont(1));
            PropPanel.addCouple(this, jPanel, jLabel, IMGH, jPanel5, gridBagLayout, gridBagConstraints, 13);
        }
        jLabel = new JLabel(REGB);
        jLabel.setFont(jLabel.getFont().deriveFont(1));
        this.reload = jButton = new JButton(RELOAD);
        this.createGluChoice();
        if (!Aladin.OUTREACH) {
            jPanel2 = new JPanel(new BorderLayout(5, 5));
            jPanel2.add((Component)this.gluChoice, "West");
            jButton.setMargin(new Insets(2, 4, 2, 4));
            jButton.addActionListener(this);
            jPanel2.add((Component)jButton, "East");
            PropPanel.addCouple(this, jPanel, jLabel, REGH, jPanel2, gridBagLayout, gridBagConstraints, 13);
            jLabel = new JLabel(FILEDIALOG);
            jLabel.setFont(jLabel.getFont().deriveFont(1));
            this.lfChoice = new JComboBox();
            this.lfChoice.addItem(FILEDIALOGJAVA);
            this.lfChoice.addItem(FILEDIALOGNATIVE);
            this.lfChoice.addActionListener(this);
            PropPanel.addCouple(this, jPanel, jLabel, FILEDIALOGHELP, this.lfChoice, gridBagLayout, gridBagConstraints, 13);
            if (Aladin.LOG) {
                jLabel = new JLabel(LOGS);
                jLabel.setFont(jLabel.getFont().deriveFont(1));
                this.logChoice = new JComboBox();
                this.logChoice.addItem(ACTIVATED);
                this.logChoice.addItem(NOTACTIVATED);
                PropPanel.addCouple(this, jPanel, jLabel, LOGH, this.logChoice, gridBagLayout, gridBagConstraints, 13);
            }
            jLabel = new JLabel(CACHES);
            jLabel.setFont(jLabel.getFont().deriveFont(1));
            jPanel2 = new JPanel(new FlowLayout(0, 5, 0));
            this.cache = new JLabel("???? / ");
            jPanel2.add(this.cache);
            this.maxCache = new JTextField(6);
            jPanel2.add(this.maxCache);
            jPanel2.add(new JLabel("MB"));
            jButton = new JButton(CLEARCACHE);
            jButton.addActionListener(this);
            jButton.setMargin(new Insets(2, 4, 2, 4));
            jPanel2.add(jButton);
            PropPanel.addCouple(this, jPanel, jLabel, CACHEH, jPanel2, gridBagLayout, gridBagConstraints, 13);
        }
        return jPanel;
    }

    private void clearCache() {
        Aladin.makeCursor(this, 1);
        Aladin.cache.clear();
        PlanBG.clearCache();
        this.set(CACHE, "0");
        this.cache.setText("0 / ");
        Aladin.makeCursor(this, 0);
    }

    private void updateWidgets() {
        Object object;
        if (this.dir == null) {
            return;
        }
        String string = this.get(DIR);
        if (string == null) {
            string = "";
        }
        this.dir.setText(string);
        string = this.get(LANG);
        if (string == null) {
            this.langChoice.setSelectedIndex(0);
        } else {
            this.langChoice.setSelectedItem(string);
        }
        this.langItem = this.langChoice.getSelectedIndex();
        string = this.get(MOD);
        if (string == null) {
            this.modeChoice.setSelectedIndex(0);
        } else {
            this.modeChoice.setSelectedItem(string);
        }
        this.modeItem = this.modeChoice.getSelectedIndex();
        string = this.get(LOOKANDFEEL);
        if (string == null && Aladin.macPlateform) {
            this.lfChoice.setSelectedIndex(1);
        }
        if (string == null || string.equals(JAVA)) {
            this.lfChoice.setSelectedIndex(0);
        } else {
            this.lfChoice.setSelectedIndex(1);
        }
        string = this.get(FRAME);
        if (string == null) {
            this.frameChoice.setSelectedItem("ICRS");
        } else {
            this.frameChoice.setSelectedItem(string);
        }
        string = this.get(PROJALLSKY);
        if (string == null) {
            this.projAllskyChoice.setSelectedItem("SINUS");
        } else {
            this.projAllskyChoice.setSelectedItem(string);
        }
        string = this.get(FRAMEALLSKY);
        if (string == null) {
            this.frameAllskyChoice.setSelectedItem("GAL");
        } else {
            this.frameAllskyChoice.setSelectedItem(string);
        }
        this.fctChoice.setSelectedIndex(3);
        String string2 = string = this.aladin.CMDEFAULT != null ? this.aladin.CMDEFAULT : this.get(CM);
        if (string != null) {
            object = new Tok(string);
            block2: while (((Tok)object).hasMoreTokens()) {
                string = ((Tok)object).nextToken();
                for (int i = 0; i < 4; ++i) {
                    JComboBox jComboBox = i == 0 ? this.videoChoice : (i == 1 ? this.mapChoice : (i == 2 ? this.cutChoice : this.fctChoice));
                    for (int j = 0; j < jComboBox.getItemCount(); ++j) {
                        if (!((String)jComboBox.getItemAt(j)).equalsIgnoreCase(string)) continue;
                        jComboBox.setSelectedIndex(j);
                        continue block2;
                    }
                }
            }
        }
        if ((string = this.get(FILTER)) != null && string.charAt(0) == 'N') {
            this.filterChoice.setSelectedIndex(0);
        } else {
            this.filterChoice.setSelectedIndex(1);
        }
        string = this.get(TRANS);
        if (string != null && string.charAt(0) == 'N') {
            this.transparencyChoice.setSelectedIndex(0);
            this.transparencyLevel.setEnabled(false);
        } else {
            this.transparencyChoice.setSelectedIndex(1);
            this.transparencyLevel.setEnabled(true);
        }
        this.transparencyChoice.addItemListener(this);
        string = this.get(TRANSLEVEL);
        if (string == null) {
            this.transparencyLevel.setValue(15);
        }
        if (this.isUnixStandalone() && !Aladin.OUTREACH) {
            string = this.get(BROWSER);
            if (string == null) {
                string = "";
            }
            this.browser.setText(string);
        }
        string = this.getServer();
        this.serverTxt.setText(string);
        string = this.getSurvey();
        this.surveyTxt.setText(string);
        object = this.get(GLU);
        if (object == null) {
            object = Glu.NPHGLUALADIN;
        }
        this.setSelectGluChoice((String)object);
        this.reload.setEnabled(true);
        if (this.logChoice != null) {
            this.logChoice.setSelectedIndex(this.isLog() ? 0 : 1);
        }
        if (this.helpChoice != null) {
            this.helpChoice.setSelectedIndex(this.isHelp() ? 0 : 1);
        }
        if (this.bxEpoch != null) {
            this.bxEpoch.setSelected(this.isSliderEpoch());
        }
        if (this.bxSize != null) {
            this.bxSize.setSelected(this.isSliderSize());
        }
        if (this.bxDens != null) {
            this.bxDens.setSelected(this.isSliderDensity());
        }
        if (this.bxOpac != null) {
            this.bxOpac.setSelected(this.isSliderOpac());
        }
        if (this.bxCube != null) {
            this.bxCube.setSelected(this.isSliderCube());
        }
        if (this.bxZoom != null) {
            this.bxZoom.setSelected(this.isSliderZoom());
        }
        if (this.cache != null) {
            long l = PlanBG.cacheSize;
            try {
                if (l == -1L) {
                    l = Long.parseLong(this.get(CACHE));
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (l == -1L) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        long l = PlanBG.getCacheSize(new File(PlanBG.getCacheDirStatic()), null);
                        PlanBG.setCacheSize(l);
                        Configuration.this.cache.setText(l / 1024L + " / ");
                    }
                });
            } else {
                this.cache.setText(l / 1024L + " / ");
            }
            int n = (int)(PlanBG.MAXCACHE / 1024L);
            this.maxCache.setText(n + "");
        }
    }

    protected String get(String string) {
        ConfigurationItem configurationItem = this.getItem(string);
        if (configurationItem == null) {
            return null;
        }
        return configurationItem.value;
    }

    protected void remove(String string) {
        ConfigurationItem configurationItem = this.getItem(string);
        if (configurationItem != null) {
            this.prop.removeElement(configurationItem);
            this.flagModif = true;
        }
    }

    protected void set(String string, String string2) {
        string.replace(' ', '_');
        this.flagModif = true;
        ConfigurationItem configurationItem = this.getItem(string);
        if (configurationItem == null) {
            configurationItem = new ConfigurationItem(string, string2);
            this.prop.addElement(configurationItem);
        } else {
            configurationItem.value = string2;
        }
    }

    private ConfigurationItem getItem(String string) {
        Enumeration enumeration = this.prop.elements();
        while (enumeration.hasMoreElements()) {
            ConfigurationItem configurationItem = (ConfigurationItem)enumeration.nextElement();
            if (!configurationItem.key.equals(string)) continue;
            return configurationItem;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    protected void save() throws Exception {
        block41: {
            if (Aladin.NOGUI) {
                return;
            }
            this.majStopHelp();
            this.setLastRun();
            this.set(Configuration.VERSION, "v9.033a");
            if (this.aladin.calque.reticleMode == 2 && this.get(Configuration.RETICLE) == null) {
                this.set(Configuration.RETICLE, "Large");
            }
            if (this.aladin.calque.reticleMode != 2 && this.get(Configuration.RETICLE) != null) {
                this.remove(Configuration.RETICLE);
            }
            if (this.aladin.calque.flagTip && this.get(Configuration.TOOLTIP) == null) {
                this.set(Configuration.TOOLTIP, "On");
            }
            if (!this.aladin.calque.flagTip && this.get(Configuration.TOOLTIP) != null) {
                this.remove(Configuration.TOOLTIP);
            }
            if (this.aladin.mesure.isReduced() && this.get(Configuration.MESURE) == null) {
                this.remove(Configuration.MESURE);
            }
            if (!this.aladin.mesure.isReduced() && this.get(Configuration.MESURE) != null) {
                this.set(Configuration.MESURE, "on");
            }
            var1_1 = this.aladin.splitH.getMesureHeight();
            this.set(Configuration.MHEIGHT, "" + var1_1);
            if (!Aladin.OUTREACH && this.aladin.bookmarks.canBeSaved()) {
                var2_2 = this.aladin.bookmarks.getBookmarkList();
                Aladin.trace(4, "Configuration.save(): updating bookmark list => " + var2_2);
                if (this.aladin.bookmarks.isDefaultList()) {
                    this.remove(Configuration.BOOKMARKS);
                } else if (this.get(Configuration.BOOKMARKS) == null || !this.get(Configuration.BOOKMARKS).equals(var2_2)) {
                    this.set(Configuration.BOOKMARKS, var2_2);
                }
            }
            var2_2 = this.get(Configuration.CACHE);
            if (PlanBG.cacheSize != -1L) {
                var3_3 = PlanBG.cacheSize + "";
                if (var2_2 == null || !var3_3.equals(var2_2)) {
                    this.set(Configuration.CACHE, var3_3);
                }
            }
            var2_2 = this.get(Configuration.MAXCACHE);
            var3_3 = PlanBG.MAXCACHE + "";
            if (var2_2 == null || !var3_3.equals(var2_2)) {
                this.set(Configuration.MAXCACHE, var3_3);
            }
            if ((var4_4 = this.get(Configuration.LOG)) != null && var4_4.equals(Configuration.ACTIVATED)) {
                this.remove(Configuration.LOG);
            }
            if ((var4_4 = this.get(Configuration.HELP)) != null && var4_4.equals(Configuration.ACTIVATED)) {
                this.remove(Configuration.HELP);
            }
            if ((var4_4 = this.get(Configuration.LOOKANDFEEL)) != null && var4_4.equals(Configuration.JAVA)) {
                this.remove(Configuration.LOOKANDFEEL);
            }
            if (!Aladin.OUTREACH) {
                if (this.aladin.calque.flagSimbad && !this.getSimbadFlag()) {
                    this.set(Configuration.SIMBAD, "On");
                }
                if (!this.aladin.calque.flagSimbad && this.getSimbadFlag()) {
                    this.remove(Configuration.SIMBAD);
                }
                if (this.aladin.calque.flagAutoDist && !this.getAutoDist()) {
                    this.set(Configuration.AUTODIST, "On");
                }
                if (!this.aladin.calque.flagAutoDist && this.getAutoDist()) {
                    this.remove(Configuration.AUTODIST);
                }
                if (this.aladin.calque.flagVizierSED && !this.getVizierSEDFlag()) {
                    this.set(Configuration.VIZIERSED, "On");
                }
                if (!this.aladin.calque.flagVizierSED && this.getVizierSEDFlag()) {
                    this.remove(Configuration.VIZIERSED);
                }
                try {
                    if (this.aladin.calque.zoom.zoomView.sed.getSEDWave()) {
                        this.set(Configuration.SEDWAVE, "On");
                    } else {
                        this.remove(Configuration.SEDWAVE);
                    }
                }
                catch (Exception var5_5) {
                    // empty catch block
                }
            }
            if (!this.flagModif && this.sameWinParam()) {
                return;
            }
            var5_6 = System.getProperty("user.home") + Util.FS + Aladin.CACHE;
            var6_7 = new File(var5_6);
            if (!var6_7.isDirectory() && !var6_7.mkdir()) {
                throw new Exception("Cannot create " + Aladin.CACHE + " directory");
            }
            var7_8 = var5_6 + Util.FS + Configuration.CONFIGNAME;
            var6_7 = new File(var7_8);
            var6_7.delete();
            var8_9 = new BufferedWriter(new FileWriter(var6_7));
            v0 = this;
            if (v0.aladin.isApplet()) break block41;
            var9_10 = (this.aladin.f.getExtendedState() & 6) != 0;
            this.aladin.f.setExtendedState(0);
            var10_11 = this.aladin.f.getLocation();
            var11_12 = this.aladin.f.getSize();
            if (var10_11.x < 0) {
                var10_11.x = 0;
            }
            if (var10_11.y < 0) {
                var10_11.y = 0;
            }
            if (Math.abs(var10_11.x) > Aladin.SCREENSIZE.width) ** GOTO lbl-1000
            if (Math.abs(var10_11.y) > Aladin.SCREENSIZE.height || var11_12.width < 100) ** GOTO lbl-1000
            if ((double)var11_12.width > (double)Aladin.SCREENSIZE.width * 1.5 || var11_12.height < 100) ** GOTO lbl-1000
            if ((double)var11_12.height > (double)Aladin.SCREENSIZE.height * 1.5) lbl-1000:
            // 4 sources

            {
                this.remove(Configuration.WINLOC);
            } else {
                this.set(Configuration.WINLOC, var10_11.x + " " + var10_11.y + " " + (var9_10 != false ? -var11_12.width : var11_12.width) + " " + (var9_10 != false ? -var11_12.height : var11_12.height));
            }
        }
        var9_10 = true;
        var10_11 = this.prop.elements();
        while (var10_11.hasMoreElements()) {
            var11_12 = (ConfigurationItem)var10_11.nextElement();
            if (!(!var9_10 || var11_12.key.equals("#") && var11_12.value.startsWith("#Aladin"))) {
                var8_9.write("#Aladin user configuration file");
                var8_9.newLine();
                var8_9.newLine();
            }
            var9_10 = false;
            if (var11_12.key.equals("#")) {
                var8_9.write(var11_12.value);
            } else if (var11_12.key.trim().length() > 0) {
                var8_9.write(Util.align(var11_12.key, 20) + var11_12.value);
            }
            var8_9.newLine();
        }
        if (this.lastFile != null) {
            var11_13 = 1;
            for (String var13_15 : this.lastFile) {
                var14_16 = Configuration.LASTFILE + var11_13++;
                var8_9.write(Util.align(var14_16, 20) + var13_15);
                var8_9.newLine();
            }
        }
        var8_9.close();
        this.flagModif = false;
        Aladin.trace(3, "Aladin user configuration file saved");
    }

    protected void saveLocalFunction() throws Exception {
        if (!this.aladin.command.functionModif()) {
            return;
        }
        String string = System.getProperty("user.home") + Util.FS + Aladin.CACHE;
        File file = new File(string + Util.FS + CONFIGBKM);
        file.delete();
        StringBuffer stringBuffer = new StringBuffer();
        BufferedWriter bufferedWriter = null;
        Enumeration<Function> enumeration = this.aladin.command.getLocalFunctions().elements();
        while (enumeration.hasMoreElements()) {
            Function function = enumeration.nextElement();
            if (!function.isLocalDefinition()) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(function.getName());
            if (bufferedWriter == null) {
                bufferedWriter = new BufferedWriter(new FileWriter(file));
            }
            bufferedWriter.write(function.toString(Util.CR) + Util.CR);
        }
        if (bufferedWriter != null) {
            bufferedWriter.close();
        }
        Aladin.trace(3, "Aladin user local functions saved: " + stringBuffer);
    }

    public String getLocalBookmarksFileName() {
        return System.getProperty("user.home") + Util.FS + Aladin.CACHE + Util.FS + CONFIGBKM;
    }

    protected void load() throws Exception {
        String string;
        String string2 = System.getProperty("user.home") + Util.FS + Aladin.CACHE;
        File file = new File(string2);
        if (!file.isDirectory()) {
            return;
        }
        String string3 = string2 + Util.FS + CONFIGNAME;
        file = new File(string3);
        if (!file.exists()) {
            return;
        }
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        this.prop = new Vector();
        int n = 0;
        Aladin.trace(2, "Loading Aladin user configuration file...");
        while ((string = bufferedReader.readLine()) != null) {
            int n2;
            int n3;
            ++n;
            if (string.trim().length() == 0) {
                this.prop.addElement(new ConfigurationItem(" ", null));
                continue;
            }
            if (string.charAt(0) == '#') {
                this.prop.addElement(new ConfigurationItem("#", string));
                continue;
            }
            char[] cArray = string.toCharArray();
            for (n3 = 0; n3 < cArray.length && !Character.isSpace(cArray[n3]); ++n3) {
            }
            String string4 = new String(cArray, 0, n3);
            for (n2 = n3; n2 < cArray.length && Character.isSpace(cArray[n2]); ++n2) {
            }
            String string5 = new String(cArray, n2, cArray.length - n2);
            if (string4.equals(TRANSOLD)) {
                string4 = TRANS;
            }
            Aladin.trace(4, "Configuration.load() [" + string4 + "] = [" + string5 + "]");
            if (string4.startsWith(LASTFILE)) {
                this.setLastFile(string5, false);
                continue;
            }
            this.set(string4, string5);
        }
        bufferedReader.close();
        this.setCSV(this.get(CSV));
        this.setMaxCache(this.get(MAXCACHE));
        this.initStopHelp(this.get(STOPHELP));
        this.flagModif = false;
    }

    private void reloadGlu() {
        try {
            Aladin.makeCursor(this, 1);
            this.aladin.glu.reload(true, false);
            Aladin.makeCursor(this, 0);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected long getLastRun() {
        try {
            return Long.parseLong(this.get(LASTRUN));
        }
        catch (Exception exception) {
            return System.currentTimeMillis();
        }
    }

    protected void setLastRun() {
        this.set(LASTRUN, System.currentTimeMillis() + "");
    }

    private void langContrib() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        TextField textField = new TextField(15);
        TextField textField2 = new TextField(3);
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(2, 2));
        panel.add(new Label("Language name:"));
        panel.add(textField);
        panel.add(new Label("2 letter code:"));
        panel.add(textField2);
        gridBagLayout.setConstraints(panel, gridBagConstraints);
        if (!Aladin.question(this, "Specify the new language name (in english)\nand the corresponding 2 letter abbreviation.\nOr just press \"Ok\" for checking/completing the current language translation.", panel)) {
            return;
        }
        String string = Util.toLower(textField2.getText()) + " " + Util.toUpLower(textField.getText());
        Aladin.chaine.testLanguage(string);
        this.dispose();
    }

    public boolean apply() throws Exception {
        String string;
        int n;
        boolean bl = true;
        if (this.logChoice != null) {
            if (this.logChoice.getSelectedIndex() == 1) {
                if (this.get(LOG) == null) {
                    this.aladin.glu.log("Log", "off");
                }
                this.set(LOG, (String)this.logChoice.getSelectedItem());
            } else {
                n = this.get(LOG) != null && this.get(LOG).equals(NOTACTIVATED) ? 1 : 0;
                this.remove(LOG);
                if (n != 0) {
                    this.aladin.glu.log("Log", "on");
                }
            }
        }
        if (this.helpChoice != null) {
            if (this.helpChoice.getSelectedIndex() == 1) {
                this.set(HELP, (String)this.helpChoice.getSelectedItem());
            } else {
                this.remove(HELP);
            }
        }
        if (this.lfChoice != null) {
            if (this.lfChoice.getSelectedIndex() == 1) {
                this.set(LOOKANDFEEL, OPSYS);
            } else {
                this.remove(LOOKANDFEEL);
            }
        }
        if (this.bxEpoch != null) {
            if (!this.bxEpoch.isSelected()) {
                this.set(SLEPOCH, "off");
            } else {
                this.remove(SLEPOCH);
            }
        }
        if (this.bxSize != null) {
            if (!this.bxSize.isSelected()) {
                this.set(SLSIZE, "off");
            } else {
                this.remove(SLSIZE);
            }
        }
        if (this.bxDens != null) {
            if (!this.bxDens.isSelected()) {
                this.set(SLDENS, "off");
            } else {
                this.remove(SLDENS);
            }
        }
        if (this.bxCube != null) {
            if (!this.bxCube.isSelected()) {
                this.remove(SLCUBE);
            } else {
                this.set(SLCUBE, "on");
            }
        }
        if (this.bxOpac != null) {
            if (!this.bxOpac.isSelected()) {
                this.set(SLOPAC, "off");
            } else {
                this.remove(SLOPAC);
            }
        }
        if (this.bxZoom != null) {
            if (!this.bxZoom.isSelected()) {
                this.set(SLZOOM, "off");
            } else {
                this.remove(SLZOOM);
            }
        }
        if ((n = this.gluChoice.getSelectedIndex()) != -1 && n != this.lastGluChoice) {
            string = (String)this.gluUrl.elementAt(n);
            String string2 = this.aladin.glu.setDefaultGluSite(string);
            this.lastGluChoice = n;
            if (string2 != null) {
                this.setSelectGluChoice(string2);
                bl = false;
            }
            this.reloadGlu();
        }
        this.set(FRAME, (String)this.frameChoice.getSelectedItem());
        this.set(FRAMEALLSKY, (String)this.frameAllskyChoice.getSelectedItem());
        this.set(PROJALLSKY, (String)this.projAllskyChoice.getSelectedItem());
        string = this.videoChoice.getSelectedItem() + " " + this.mapChoice.getSelectedItem() + " " + this.cutChoice.getSelectedItem() + " " + this.fctChoice.getSelectedItem();
        this.set(CM, string);
        this.aladin.CMDEFAULT = null;
        this.set(SERVER, this.serverTxt.getText().trim());
        this.set(SURVEY, this.surveyTxt.getText().trim());
        this.set(FILTER, (String)this.filterChoice.getSelectedItem());
        float f = (float)((double)this.transparencyLevel.getValue() / 100.0);
        f = f >= 1.0f ? (f -= 1.11E-4f) : (f += 1.11E-4f);
        this.set(TRANS, (String)this.transparencyChoice.getSelectedItem());
        this.set(TRANSLEVEL, f + "");
        this.setTransparency((String)this.transparencyChoice.getSelectedItem(), f);
        n = this.langChoice.getSelectedIndex();
        if (n != this.langItem) {
            this.langItem = n;
            if (n > lang.length) {
                this.installRemoteLanguage((String)this.langChoice.getSelectedItem());
            } else {
                this.setLang(n == 0 ? null : (String)this.langChoice.getSelectedItem());
            }
            Aladin.info(this, Aladin.chaine.getString("RESTART"));
        }
        if ((n = this.modeChoice.getSelectedIndex()) != this.modeItem) {
            this.modeItem = n;
            this.setMode(n == 0 ? null : (String)this.modeChoice.getSelectedItem());
            Aladin.info(this, Aladin.chaine.getString("RESTART"));
        }
        if (this.csvChoice != null && (n = this.csvChoice.getSelectedIndex()) != this.csvItem) {
            this.set(CSV, CSVITEM[n]);
            this.setCSV(CSVITEM[n]);
        }
        if (this.browser != null) {
            string = this.browser.getText().trim();
            if (string.length() != 0) {
                this.set(BROWSER, string);
            } else {
                this.remove(BROWSER);
            }
        }
        if (this.dir != null) {
            string = this.dir.getText().trim();
            if (string.length() == 0) {
                this.remove(DIR);
            } else {
                this.setDir(string);
                this.set(DIR, string);
            }
        }
        if (this.maxCache != null) {
            try {
                string = this.maxCache.getText();
                long l = Long.parseLong(string);
                PlanBG.setMaxCacheSize(l * 1024L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.save();
        this.updateWidgets();
        return bl;
    }

    private Langue getBestLangVersion(String string) {
        Langue langue = null;
        try {
            double d = Double.MAX_VALUE;
            double d2 = Double.parseDouble("v9.033a".substring(1));
            Enumeration enumeration = this.remoteLang.elements();
            while (enumeration.hasMoreElements()) {
                double d3;
                Langue langue2 = (Langue)enumeration.nextElement();
                if (!langue2.isLangue(string) || !(d > (d3 = Math.abs(d2 - langue2.version)))) continue;
                d = d3;
                langue = langue2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return langue;
    }

    private void clearPreviousRemoteLang() {
        block3: {
            try {
                String string = System.getProperty("user.home") + Util.FS + Aladin.CACHE;
                FilenameFilter filenameFilter = new FilenameFilter(){

                    @Override
                    public boolean accept(File file, String string) {
                        return Util.matchMaskIgnoreCase("Aladin*.string*", string);
                    }
                };
                File file = new File(string);
                File[] fileArray = file.listFiles(filenameFilter);
                for (int i = 0; i < fileArray.length; ++i) {
                    String string2 = fileArray[i].getName();
                    if (!string2.endsWith(".utf") && !string2.endsWith(".string") || string2.endsWith("-perso.string") || string2.endsWith("-perso.string.utf")) continue;
                    fileArray[i].delete();
                }
            }
            catch (Exception exception) {
                if (Aladin.levelTrace < 3) break block3;
                exception.printStackTrace();
            }
        }
    }

    private void installRemoteLanguage(String string) throws Exception {
        Langue langue = this.getBestLangVersion(string);
        URL uRL = new URL("http://aladin.u-strasbg.fr/java/nph-aladin.pl?frame=getLang&id=" + langue.file);
        MyInputStream myInputStream = Util.openStream(uRL);
        byte[] byArray = myInputStream.readFully();
        myInputStream.close();
        if (byArray.length < 10) {
            throw new Exception("Cannot download translation file [" + uRL + "]");
        }
        this.clearPreviousRemoteLang();
        this.installLanguage(string, langue.file, byArray);
    }

    protected void installLanguage(String string, String string2, byte[] byArray) throws Exception {
        File file;
        String string3 = System.getProperty("user.home") + Util.FS + Aladin.CACHE;
        String string4 = string3 + Util.FS + string2;
        File file2 = new File(string4 + ".tmp");
        RandomAccessFile randomAccessFile = new RandomAccessFile(file2, "rw");
        randomAccessFile.write(byArray);
        randomAccessFile.close();
        if (string4.endsWith(".string")) {
            file = new File(string4 + ".utf");
            file.delete();
        } else if (string4.endsWith(".utf")) {
            file = new File(string4.substring(0, string4.length() - 4));
            file.delete();
        }
        file = new File(string4);
        file.delete();
        file2.renameTo(file);
        Aladin.trace(1, "Translation file installed [" + string4 + "]");
        this.set(LANG, string);
    }

    private void setLang(String string) throws Exception {
        if (string == null) {
            this.remove(LANG);
            return;
        }
        String string2 = this.getLanguage(string);
        if (string2 == null) {
            throw new Exception("Language not supported ! [" + string + "]");
        }
        this.set(LANG, string2);
    }

    private void setMode(String string) throws Exception {
        if (string == null) {
            this.remove(MOD);
            return;
        }
        this.set(MOD, string);
    }

    protected void setLastFile(String string, boolean bl) {
        if (this.lastFile == null) {
            this.lastFile = new LinkedBlockingDeque(20);
        }
        if (bl) {
            string = string.replace('\\', '/');
            File file = new File(string);
            for (String string2 : this.lastFile) {
                if (!file.equals(new File(string2))) continue;
                this.lastFile.remove(string2);
                break;
            }
        }
        if (this.lastFile.size() == 20) {
            this.lastFile.removeFirst();
        }
        this.lastFile.add(string);
    }

    private void setDir(String string) throws Exception {
        if (string == null) {
            this.remove(DIR);
            return;
        }
        File file = new File(string);
        if (!file.isDirectory()) {
            throw new Exception("Not a directory ! [" + string + "]");
        }
        this.set(DIR, string);
    }

    protected void setOfficialVersion(String string) {
        this.set(OFFICIALVERSION, string);
    }

    protected void setconf(String string, String string2) throws Exception {
        if (string.equalsIgnoreCase(DIR) || string.equalsIgnoreCase("dir")) {
            this.setDir(string2);
        } else if (string.equalsIgnoreCase(CSV)) {
            this.setCSV(string2);
        } else if (string.equalsIgnoreCase("sync")) {
            this.setSyncMode(string2);
        } else if (string.equalsIgnoreCase(POSITION) || string.equalsIgnoreCase("position") || string.equalsIgnoreCase("frame")) {
            this.setPositionMode(string2);
        } else if (string.equalsIgnoreCase(SIMBAD) || string.equalsIgnoreCase("simbad")) {
            this.setSimbadMode(string2);
        } else if (string.equalsIgnoreCase(FILTER) || string.equalsIgnoreCase("filter")) {
            this.setFilterMode(string2);
        } else if (string.equalsIgnoreCase(CM) || string.equalsIgnoreCase("Colormap") || string.equalsIgnoreCase("cm")) {
            this.setCMMode(string2);
        } else if (string.equalsIgnoreCase(BKG) || string.equalsIgnoreCase("Background")) {
            this.setBkgMode(string2);
        } else if (string.equalsIgnoreCase(PROJALLSKY) || string.equalsIgnoreCase("projection") || string.equalsIgnoreCase("Proj")) {
            this.setProjAllsky(string2);
        } else {
            throw new Exception("Unknown conf. propertie [" + string + "]");
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string;
        Object object = actionEvent.getSource();
        String string2 = string = object instanceof JButton ? ((JButton)object).getActionCommand() : "";
        if (CLOSE.equals(string)) {
            this.dispose();
        } else if (LANGCONTRIB.equals(string)) {
            this.langContrib();
        } else if (RELOAD.equals(string)) {
            this.reloadGlu();
        } else if (APPLY.equals(string)) {
            try {
                if (this.apply()) {
                    this.aladin.calque.repaintAll();
                }
            }
            catch (Exception exception) {
                Aladin.warning(this, " " + exception.getMessage(), 1);
            }
        } else if (CLEARCACHE.equals(string)) {
            this.clearCache();
        } else if (BROWSE.equals(string)) {
            String string3;
            String string4 = this.dir.getText();
            if (string4.length() == 0) {
                string4 = null;
            }
            if ((string3 = Util.dirBrowser("", string4, this.dir, 3)) != null) {
                this.aladin.memoDefaultDirectory(string3);
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        float f = (float)((double)this.transparencyLevel.getValue() / 100.0);
        f = f >= 1.0f ? (f -= 1.11E-4f) : (f += 1.11E-4f);
        if ((double)Math.abs(f - Aladin.DEFAULT_FOOTPRINT_OPACITY_LEVEL) > 0.02) {
            this.setTransparency((String)this.transparencyChoice.getSelectedItem(), f);
            this.set(TRANSLEVEL, f + "");
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() != 1) {
            return;
        }
        this.transparencyLevel.setEnabled(itemEvent.getItem().equals(FILTERY));
    }

    @Override
    protected void processWindowEvent(WindowEvent windowEvent) {
        if (windowEvent.getID() == 201) {
            this.dispose();
        }
        super.processWindowEvent(windowEvent);
    }

    static {
        CSVITEM = new String[]{"tab", "|", ";", ",", "tab |", "tab | ;"};
        CMPARAM = null;
    }

    class Langue {
        String code;
        String langue;
        double version;
        String auteur;
        String file;

        Langue(String string) {
            this.langue = string;
            this.auteur = "";
            this.code = "";
            this.version = 0.0;
            this.file = null;
        }

        boolean isLangue(String string) {
            try {
                return this.code != null && string.equalsIgnoreCase(this.code) || this.langue != null && string.equalsIgnoreCase(this.langue);
            }
            catch (Exception exception) {
                return false;
            }
        }

        public String toString() {
            return this.langue + " (" + this.code + ") " + this.version + " " + this.auteur + (this.file != null ? " " + this.file : "");
        }
    }

    private class ConfigurationItem {
        protected String key;
        protected String value;

        private ConfigurationItem(String string, String string2) {
            this.key = string;
            this.value = string2;
        }
    }
}

