/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.tools.Util;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;

public final class Console
extends JFrame
implements ActionListener,
KeyListener,
MouseListener {
    private static final int NBHISTORYCMD = 1000;
    private static String EXEC;
    private static String CLOSE;
    private static String CLEAR;
    private static String DELETE;
    private static String HELP;
    private static String COPY;
    private static String DUMP;
    private Aladin aladin;
    private JTable table;
    private JTextArea fieldCmd;
    private JTextArea fieldPad;
    private JButton exec;
    private JButton clear;
    private JButton delete;
    private JButton dump;
    private JButton clearPad;
    private Vector<String> cmd;
    private Vector<Command> cmdHistory;
    private String currentCmd;
    private static final int CMD = 0;
    private static final int INFO = 1;
    private static final int ERROR = 2;
    static final String[] TYPES;
    private static SimpleDateFormat SDF;
    private static final String HISTORYNAME = "History.ajs";
    private int indexArrowHistory;
    private static final int DATE = 0;
    private static final int TYPE = 1;
    private static final int DESC = 2;
    private int oIndexCmd;
    private int indexCmd;

    public void createChaine() {
        CLOSE = Aladin.chaine.getString("CLOSE");
        CLEAR = Aladin.chaine.getString("CLEAR");
        DELETE = Aladin.chaine.getString("RESETHISTORY");
        HELP = Aladin.chaine.getString("HELPSCRIPT");
        EXEC = Aladin.chaine.getString("EXEC");
        DUMP = Aladin.chaine.getString("NPCLONE");
    }

    public Console(Aladin aladin) {
        block4: {
            this.cmd = new Vector();
            this.cmdHistory = new Vector();
            this.currentCmd = null;
            this.indexArrowHistory = -1;
            this.oIndexCmd = -1;
            this.indexCmd = -1;
            Aladin.setIcon(this);
            this.aladin = aladin;
            this.createChaine();
            this.setTitle(Aladin.chaine.getString("NPTITLE"));
            this.enableEvents(64L);
            Util.setCloseShortcut(this, false, aladin);
            this.addMouseListener(this);
            JPanel jPanel = (JPanel)this.getContentPane();
            jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            jPanel.add((Component)this.getHistoryPanel(), "North");
            JPanel jPanel2 = new JPanel(new BorderLayout(5, 5));
            jPanel2.add((Component)this.getCommandPanel(), "North");
            jPanel2.add((Component)this.getPadPanel(), "Center");
            jPanel.add((Component)jPanel2, "Center");
            if (Aladin.STANDALONE) {
                if (!Aladin.NOGUI) {
                    try {
                        this.loadHistory();
                    }
                    catch (Exception exception) {
                        if (Aladin.levelTrace < 3) break block4;
                        exception.printStackTrace();
                    }
                }
            }
        }
        this.pack();
        this.resumeButton();
    }

    public void printCommand(String string) {
        if (string == null || string.trim().length() == 0) {
            return;
        }
        this.cmdHistory.addElement(new Command(string));
        this.resetArrowHistory();
        this.resumeTable();
    }

    public void printInfo(String string) {
        this.cmdHistory.addElement(new Command(string, 1));
        this.resumeTable();
    }

    public void printError(String string) {
        this.cmdHistory.addElement(new Command(string, 2));
        this.resumeTable();
    }

    public void printInPad(String string) {
        boolean bl = this.fieldPad.getCaretPosition() == this.fieldPad.getText().length();
        this.fieldPad.append(string);
        if (bl) {
            this.fieldPad.setCaretPosition(this.fieldPad.getText().length());
        }
        this.clearPad.setEnabled(true);
    }

    public void dumpMeasurements() {
        this.printInPad(this.aladin.mesure.getText());
        this.aladin.log("DumpMeasurements", "");
    }

    public void clearPad() {
        this.fieldPad.setText("");
    }

    private void clear() {
        this.fieldCmd.setText("");
        this.resumeTable();
    }

    private void deleteHistory() {
        if (!Aladin.confirmation(this, Aladin.chaine.getString("NPCONF"))) {
            return;
        }
        this.cmdHistory.clear();
        this.resumeTable();
    }

    public synchronized boolean hasWaitingCmd() {
        return this.cmd.size() > 0;
    }

    public synchronized void pushCmd(String string) {
        String[] stringArray = Util.split(string, "\n;", '[', ']');
        for (int i = 0; i < stringArray.length; ++i) {
            this.cmd.addElement(stringArray[i]);
        }
        this.aladin.command.readNow();
    }

    public synchronized String popCmd() {
        if (this.cmd.size() == 0) {
            return "";
        }
        String string = this.cmd.elementAt(0);
        this.cmd.removeElementAt(0);
        return string;
    }

    private void execute() {
        String string = this.fieldCmd.getText();
        if ((string = this.isCmdComplete(string)) != null) {
            this.pushCmd(string);
            this.fieldCmd.setText("");
        }
    }

    @Override
    public void show() {
        super.show();
        this.fieldCmd.requestFocusInWindow();
    }

    private String isCmdComplete(String string) {
        if (!(string = string.trim()).startsWith("filter") && !string.startsWith("function")) {
            return string;
        }
        int n = string.length();
        int n2 = 0;
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '{') {
                bl = true;
                ++n2;
            } else if (c == '}') {
                --n2;
            }
            stringBuffer.append(c);
        }
        if (n2 == 0 || !bl) {
            return stringBuffer.toString();
        }
        return null;
    }

    public void saveHistory() throws Exception {
        String string = System.getProperty("user.home") + Util.FS + Aladin.CACHE;
        File file = new File(string);
        if (!file.isDirectory() && !file.mkdir()) {
            throw new Exception("Cannot create " + Aladin.CACHE + " directory");
        }
        String string2 = string + Util.FS + HISTORYNAME;
        file = new File(string2);
        file.delete();
        int n = this.cmdHistory.size();
        Aladin.trace(2, "Saving command history [" + string2 + "]...");
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
        if ((n -= 1000) < 0) {
            n = 0;
        }
        for (int i = n; i < this.cmdHistory.size(); ++i) {
            Command command = this.cmdHistory.elementAt(i);
            bufferedWriter.write(command + "\n");
        }
        bufferedWriter.close();
    }

    public void loadHistory() throws Exception {
        String string;
        String string2 = System.getProperty("user.home") + Util.FS + Aladin.CACHE + Util.FS + HISTORYNAME;
        File file = new File(string2);
        if (!file.exists()) {
            return;
        }
        Aladin.trace(2, "Loading command history [" + string2 + "]...");
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        while ((string = bufferedReader.readLine()) != null) {
            if ((string = string.trim()).length() == 0) continue;
            Command command = new Command();
            if (string.charAt(0) == '#') {
                if (!command.setDate(string = string.substring(1))) {
                    command.cmd = string;
                    command.type = string.startsWith("!!!") ? 2 : 1;
                    this.cmdHistory.addElement(command);
                    continue;
                }
                string = bufferedReader.readLine();
                if (string == null) break;
                if ((string = string.trim()).length() == 0) continue;
            }
            if (string.charAt(0) == '#') {
                string = string.substring(1);
                command.cmd = string;
                command.type = string.startsWith("!!!") ? 2 : 1;
            } else {
                command.cmd = string;
                command.type = 0;
            }
            this.cmdHistory.addElement(command);
        }
    }

    private void resetArrowHistory() {
        this.indexArrowHistory = -1;
    }

    public int getIndexArrowHistory() {
        return this.indexArrowHistory;
    }

    public String getNextArrowHistory(int n) {
        if (n == 2) {
            this.resetArrowHistory();
        }
        if (this.indexArrowHistory == -1 && this.cmdHistory.size() > 0) {
            this.indexArrowHistory = this.cmdHistory.size();
        }
        Command command = null;
        try {
            this.indexArrowHistory += n;
            while (!(this.indexArrowHistory < 0 && this.indexArrowHistory > this.cmdHistory.size() || (command = this.cmdHistory.get(this.indexArrowHistory)).isCmd())) {
                this.indexArrowHistory += n;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.indexArrowHistory < 0) {
            this.indexArrowHistory = 0;
        }
        if (this.indexArrowHistory >= this.cmdHistory.size()) {
            this.indexArrowHistory = -1;
        }
        if (this.indexArrowHistory == -1) {
            return null;
        }
        return command == null || !command.isCmd() ? null : command.getCommand();
    }

    public void resumeButton() {
        try {
            this.dump.setEnabled(this.aladin.mesure.getNbSrc() > 0);
            this.clearPad.setEnabled(this.fieldPad.getText().trim().length() > 0);
            boolean bl = this.fieldCmd.getText().trim().length() > 0;
            this.clear.setEnabled(bl);
            this.exec.setEnabled(bl && this.isCmdComplete(this.fieldCmd.getText()) != null);
            this.delete.setEnabled(this.cmdHistory.size() > 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setEnabledDumpButton(boolean bl) {
        this.dump.setEnabled(bl);
    }

    private void resumeTable() {
        while (this.cmdHistory.size() > 1000) {
            this.cmdHistory.removeElementAt(0);
        }
        ((HistoryTable)this.table.getModel()).fireTableDataChanged();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Console.this.table.scrollRectToVisible(Console.this.table.getCellRect(Console.this.cmdHistory.size() - 1, 0, true));
                Console.this.resumeButton();
            }
        });
    }

    private JPanel getCommandPanel() {
        JButton jButton;
        this.fieldCmd = new JTextArea(4, 60);
        JScrollPane jScrollPane = new JScrollPane(this.fieldCmd);
        this.fieldCmd.setFont(Aladin.COURIER);
        this.fieldCmd.addKeyListener(this);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)new JLabel("Command:"), "North");
        jPanel.add((Component)jScrollPane, "South");
        JPanel jPanel2 = new JPanel();
        this.exec = jButton = new JButton(EXEC);
        jPanel2.add(jButton);
        jButton.addActionListener(this);
        jButton.setFont(jButton.getFont().deriveFont(1));
        this.clear = jButton = new JButton(CLEAR);
        jPanel2.add(jButton);
        jButton.addActionListener(this);
        this.delete = jButton = new JButton(DELETE);
        jPanel2.add(jButton);
        jButton.addActionListener(this);
        jButton = new JButton(HELP);
        jPanel2.add(jButton);
        jButton.addActionListener(this);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add((Component)jPanel, "North");
        jPanel3.add((Component)jPanel2, "South");
        return jPanel3;
    }

    private JPanel getPadPanel() {
        JButton jButton;
        this.fieldPad = new JTextArea(8, 60);
        JScrollPane jScrollPane = new JScrollPane(this.fieldPad);
        this.fieldPad.setFont(Aladin.COURIER);
        this.fieldPad.addKeyListener(this);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)new JLabel("Notepad:"), "North");
        jPanel.add((Component)jScrollPane, "Center");
        JPanel jPanel2 = new JPanel();
        this.dump = jButton = new JButton(DUMP);
        jPanel2.add(jButton);
        jButton.addActionListener(this);
        jButton.setEnabled(false);
        this.clearPad = jButton = new JButton(CLEAR);
        jPanel2.add(jButton);
        jButton.addActionListener(this);
        jButton.setEnabled(false);
        jPanel2.add(new JLabel("                 "));
        jButton = new JButton(CLOSE);
        jPanel2.add(jButton);
        jButton.addActionListener(this);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add((Component)jPanel, "Center");
        jPanel3.add((Component)jPanel2, "South");
        return jPanel3;
    }

    private JPanel getHistoryPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane(this.createHistoryTable());
        jPanel.add((Component)jScrollPane, "Center");
        return jPanel;
    }

    private JTable createHistoryTable() {
        this.table = new JTable(new HistoryTable());
        this.table.setSelectionMode(2);
        this.table.getColumnModel().getColumn(1).setMinWidth(40);
        this.table.getColumnModel().getColumn(1).setMaxWidth(40);
        this.table.getColumnModel().getColumn(0).setMinWidth(100);
        this.table.getColumnModel().getColumn(0).setMaxWidth(100);
        this.table.setPreferredScrollableViewportSize(new Dimension(420, 192));
        MyRenderer myRenderer = new MyRenderer();
        this.table.getColumnModel().getColumn(1).setCellRenderer(myRenderer);
        this.table.getColumnModel().getColumn(0).setCellRenderer(myRenderer);
        this.table.getColumnModel().getColumn(2).setCellRenderer(myRenderer);
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                Console.this.showSelectedCommands();
            }
        });
        return this.table;
    }

    private void showSelectedCommands() {
        int[] nArray = this.table.getSelectedRows();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < nArray.length; ++i) {
            Command command = this.cmdHistory.elementAt(nArray[i]);
            if (command.type != 0) continue;
            stringBuffer.append(command.cmd + "\n");
        }
        this.fieldCmd.setText(stringBuffer.toString());
        if (nArray.length > 0) {
            this.setIndexCmd(nArray[0]);
        }
        this.resumeButton();
    }

    private void setIndexCmd(int n) {
        this.indexCmd = n;
    }

    private void showCmd(int n) {
        String string;
        int n2;
        if (n == -1 && !this.isFirstLine()) {
            return;
        }
        if (n == 1 && !this.isLastLine()) {
            return;
        }
        if (this.indexCmd == -1) {
            this.currentCmd = this.fieldCmd.getText();
        }
        int n3 = n2 = this.indexCmd == -1 ? this.cmdHistory.size() : this.indexCmd;
        if ((n2 += n) < 0) {
            return;
        }
        this.indexCmd = n2 >= this.cmdHistory.size() ? -1 : n2;
        if (this.oIndexCmd == this.indexCmd) {
            return;
        }
        this.oIndexCmd = this.indexCmd;
        if (this.indexCmd == -1) {
            string = this.currentCmd;
        } else {
            Command command = this.cmdHistory.elementAt(this.indexCmd);
            if (command.type != 0) {
                this.showCmd(n);
                return;
            }
            string = command.getCommand();
        }
        this.fieldCmd.setText(string);
        if (this.indexCmd == -1) {
            this.table.getSelectionModel().clearSelection();
        } else {
            this.table.getSelectionModel().setSelectionInterval(this.indexCmd, this.indexCmd);
        }
        this.table.scrollRectToVisible(this.table.getCellRect(this.indexCmd == -1 ? this.cmdHistory.size() - 1 : this.indexCmd, 0, true));
    }

    private boolean isFirstLine() {
        int n = this.fieldCmd.getCaretPosition();
        int n2 = this.fieldCmd.getText().indexOf(10);
        return n2 == -1 || n < n2;
    }

    private boolean isLastLine() {
        int n = this.fieldCmd.getCaretPosition();
        int n2 = this.fieldCmd.getText().lastIndexOf(10);
        return n2 == -1 || n > n2;
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            this.fieldCmd.requestFocusInWindow();
            this.resumeTable();
            this.resumeButton();
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == 10) {
            this.execute();
        } else if (n == 38) {
            this.showCmd(-1);
        } else if (n == 40) {
            this.showCmd(1);
        } else {
            this.setIndexCmd(-1);
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        this.resumeButton();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string;
        Object object = actionEvent.getSource();
        if (object == this.clearPad) {
            this.clearPad();
            return;
        }
        String string2 = string = object instanceof JButton ? ((JButton)object).getActionCommand() : "";
        if (CLOSE.equals(string)) {
            this.setVisible(false);
        } else if (CLEAR.equals(string)) {
            this.clear();
        } else if (DELETE.equals(string)) {
            this.deleteHistory();
        } else if (EXEC.equals(string)) {
            this.execute();
        } else if (DUMP.equals(string)) {
            this.dumpMeasurements();
        } else if (HELP.equals(string)) {
            this.aladin.command.execHelpCmd("", true);
        }
    }

    @Override
    protected void processWindowEvent(WindowEvent windowEvent) {
        if (windowEvent.getID() == 201) {
            this.setVisible(false);
        }
        super.processWindowEvent(windowEvent);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.resumeButton();
    }

    static {
        TYPES = new String[]{"Cmd", "Info", "Error"};
        SDF = new SimpleDateFormat("dd/MM/yy HH:mm:ss");
        SDF.setTimeZone(TimeZone.getDefault());
    }

    private class Command {
        private int type;
        private long date;
        private String cmd;

        private Command() {
        }

        private Command(String string) {
            this(string, 0);
        }

        private Command(String string, int n) {
            this.cmd = string;
            this.type = n;
            this.date = System.currentTimeMillis();
        }

        private String getType() {
            return TYPES[this.type];
        }

        private String getDate() {
            return this.date == 0L ? " ? " : SDF.format(this.date);
        }

        private String getCommand() {
            return this.cmd;
        }

        public boolean isCmd() {
            return this.type == 0;
        }

        private boolean setDate(String string) {
            try {
                this.date = SDF.parse(string).getTime();
                return true;
            }
            catch (ParseException parseException) {
                return false;
            }
        }

        public String toString() {
            String string = this.date == 0L ? "" : "#" + this.getDate() + "\n";
            return string + (this.type != 0 ? "#" : "") + this.getCommand();
        }
    }

    private class HistoryTable
    extends AbstractTableModel {
        private HistoryTable() {
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return Console.this.cmdHistory.size();
        }

        @Override
        public String getColumnName(int n) {
            return n == 1 ? "Type" : (n == 0 ? "Date" : "Description");
        }

        @Override
        public Object getValueAt(int n, int n2) {
            Command command = (Command)Console.this.cmdHistory.elementAt(n);
            switch (n2) {
                case 1: {
                    return command.getType();
                }
                case 0: {
                    return command.getDate();
                }
            }
            return command.getCommand();
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 2;
        }
    }

    class MyRenderer
    extends DefaultTableCellRenderer {
        MyRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            Command command = (Command)Console.this.cmdHistory.elementAt(n);
            Color color = Color.red;
            if (command.type == 0) {
                color = Color.black;
            } else if (command.type == 1) {
                color = Aladin.GREEN;
            }
            component.setForeground(color);
            component.setFont(component.getFont().deriveFont(n2 == 2 ? 1 : 0));
            return component;
        }
    }
}

