/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Calib;
import cds.aladin.Coord;
import cds.aladin.Ligne;
import cds.aladin.LigneConst;
import cds.aladin.Position;
import cds.aladin.Projection;
import cds.aladin.TagConstellation;
import cds.aladin.Tok;
import cds.aladin.ViewSimple;
import java.awt.Color;
import java.awt.Graphics;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;

public class Constellation {
    private static final String CONSTELLATION_FILE = "Constellation.txt";
    private static Color COLOR = new Color(255, 200, 68);
    private Aladin aladin;
    private HashMap<String, ArrayList<Position>> cstMap;
    private short[] projOk;

    protected Constellation(Aladin aladin) {
        block2: {
            this.cstMap = null;
            this.projOk = new short[16];
            this.aladin = aladin;
            try {
                this.load();
            }
            catch (Exception exception) {
                if (Aladin.levelTrace < 3) break block2;
                exception.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void load() throws Exception {
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(this.aladin.getClass().getResourceAsStream("/Constellation.txt")));
            this.cstMap = new HashMap();
            String string = null;
            ArrayList<Object> arrayList = null;
            Object object = null;
            Projection projection = null;
            double d = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = 0.0;
            boolean bl = true;
            boolean bl2 = true;
            while (bl2) {
                String string2 = bufferedReader.readLine();
                if (string2 == null) {
                    bl2 = false;
                }
                try {
                    Coord coord;
                    Object object2;
                    String string3;
                    double d5 = 0.0;
                    double d6 = 0.0;
                    if (!bl2) {
                        string3 = "";
                    } else {
                        object2 = new Tok(string2, " ");
                        d5 = Double.parseDouble(((Tok)object2).nextToken());
                        d6 = Double.parseDouble(((Tok)object2).nextToken());
                        string3 = ((Tok)object2).nextToken();
                    }
                    if (!string3.equals(string)) {
                        if (arrayList != null) {
                            object2 = (LigneConst)arrayList.get(0);
                            object2 = new LigneConst(((LigneConst)object).raj, ((LigneConst)object).dej, (LigneConst)object);
                            ((LigneConst)object2).bout = (byte)3;
                            arrayList.add(object2);
                            coord = new Coord();
                            coord.x = (d + d2) / 2.0;
                            coord.y = (d3 + d4) / 2.0;
                            if (string.equals("DRA")) {
                                coord.x -= (d2 - d) / 3.0;
                            } else if (string.equals("ERI")) {
                                coord.x -= (d2 - d) / 4.0;
                            } else if (string.equals("PUP")) {
                                coord.x -= (d2 - d) / 4.0;
                            } else if (string.equals("PSC")) {
                                coord.x -= (d2 - d) / 4.0;
                            } else if (string.equals("SER2")) {
                                coord.y -= (d2 - d) / 6.0;
                            } else if (string.equals("SCO")) {
                                coord.y += (d2 - d) / 5.0;
                            }
                            projection.getCoordNative(coord);
                            TagConstellation tagConstellation = new TagConstellation(coord, string);
                            tagConstellation.setColor(COLOR);
                            arrayList.add(tagConstellation);
                            this.cstMap.put(string3, arrayList);
                            object = null;
                            bl = true;
                            if (!bl2) {
                                break;
                            }
                        }
                        arrayList = new ArrayList<Object>();
                        projection = new Projection(null, 2, d5, d6, 60.0, 0.0, 0.0, 60.0, 0.0, false, 1, Calib.FK5);
                    }
                    string = string3;
                    object2 = new LigneConst(d5, d6, (LigneConst)object);
                    ((Ligne)object2).setColor(COLOR);
                    arrayList.add(object2);
                    object = object2;
                    coord = new Coord(d5, d6);
                    projection.getXYNative(coord);
                    if (d > coord.x || bl) {
                        d = coord.x;
                    }
                    if (d2 < coord.x || bl) {
                        d2 = coord.x;
                    }
                    if (d3 > coord.y || bl) {
                        d3 = coord.y;
                    }
                    if (d4 < coord.y || bl) {
                        d4 = coord.y;
                    }
                    bl = false;
                }
                catch (Exception exception) {
                    if (Aladin.levelTrace < 3) continue;
                    exception.printStackTrace();
                }
            }
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
    }

    protected void draw(Graphics graphics, ViewSimple viewSimple, int n, int n2) {
        boolean bl = this.projOk[viewSimple.n] != viewSimple.iz;
        for (ArrayList<Position> arrayList : this.cstMap.values()) {
            for (Position position : arrayList) {
                if (bl) {
                    position.projection(viewSimple);
                }
                position.draw(graphics, viewSimple, n, n2);
            }
        }
        this.projOk[viewSimple.n] = viewSimple.iz;
    }
}

