/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.PlanContour;
import cds.aladin.PointD;

public abstract class ContourAlgorithm {
    protected PlanContour pc;
    protected int width;
    protected int height;
    protected double level;
    protected short[] data;

    ContourAlgorithm(short[] sArray, int n, int n2, double d) {
        this();
        this.level = d;
        this.width = n;
        this.height = n2;
        this.data = sArray;
    }

    ContourAlgorithm() {
    }

    protected abstract PointD[] getContours();

    protected void setLevel(double d) {
        this.level = d;
    }

    protected void setData(short[] sArray) {
        this.data = sArray;
    }

    protected void setDimension(int n, int n2) {
        this.width = n;
        this.height = n2;
    }

    protected static PointD[] cleanContours(PointD[] pointDArray) {
        if (pointDArray.length == 0) {
            return pointDArray;
        }
        PointD[] pointDArray2 = new PointD[pointDArray.length];
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 1;
        int n5 = 2;
        boolean bl = false;
        while (!bl) {
            PointD pointD;
            if (n5 >= pointDArray.length) {
                bl = true;
            }
            pointDArray2[n2] = pointD = pointDArray[n3];
            n = ContourAlgorithm.testPoints(n3, pointDArray);
            pointDArray2[++n2] = pointDArray[n];
            ++n2;
            n3 = n + 1;
            n4 = n3 + 1;
            n5 = n4 + 1;
            if (n5 < pointDArray.length) continue;
            bl = true;
        }
        PointD[] pointDArray3 = new PointD[n2 + 1];
        System.arraycopy(pointDArray2, 0, pointDArray3, 0, n2 + 1);
        return pointDArray3;
    }

    private static int testPoints(int n, PointD[] pointDArray) {
        int n2 = n + 1;
        int n3 = n2 + 1;
        boolean bl = false;
        int n4 = -1;
        while (!bl) {
            if (n3 >= pointDArray.length) {
                bl = true;
                continue;
            }
            PointD pointD = pointDArray[n];
            PointD pointD2 = pointDArray[n2];
            PointD pointD3 = pointDArray[n3];
            if (pointD == null || pointD2 == null || pointD3 == null) {
                bl = true;
                continue;
            }
            if (pointD.x == pointD2.x && pointD2.x == pointD3.x && (n4 == 0 || n4 == -1)) {
                n4 = 0;
                ++n2;
                ++n3;
                continue;
            }
            if (pointD.y == pointD2.y && pointD2.y == pointD3.y && (n4 == 1 || n4 == -1)) {
                n4 = 1;
                ++n2;
                ++n3;
                continue;
            }
            if (pointD2.x - pointD.x == pointD3.x - pointD2.x && pointD2.y - pointD.y == pointD3.y - pointD2.y && (n4 == 2 || n4 == -1)) {
                n4 = 2;
                ++n2;
                ++n3;
                continue;
            }
            bl = true;
        }
        return n2;
    }
}

