/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.astro.Astrocoo;
import cds.astro.Coo;
import cds.tools.Util;

public final class Coord {
    public double al;
    public double del;
    public double x;
    protected double dx;
    public double y;
    protected double dy;
    protected double xstand;
    protected double ystand;
    static Astrocoo coo = new Astrocoo();

    public Coord() {
    }

    public Coord(double d, double d2) {
        this.al = d;
        this.del = d2;
        coo.set(this.al, this.del);
    }

    public Coord(String string) throws Exception {
        coo.set(string);
        this.al = coo.getLon();
        this.del = coo.getLat();
    }

    public boolean equals(Coord coord) {
        if (coord == null) {
            return false;
        }
        return this.al == coord.al && this.del == coord.del;
    }

    public static String getSexa(double d, double d2) {
        return Coord.getSexa(d, d2, "s");
    }

    public static String getSexa(double d, double d2, String string) {
        Astrocoo astrocoo = new Astrocoo();
        astrocoo.set(d, d2);
        astrocoo.setPrecision(6);
        try {
            String string2 = "2s" + (!string.equals(" ") ? string : "");
            return astrocoo.toString(string2);
        }
        catch (Exception exception) {
            System.err.println(exception);
            return "";
        }
    }

    public String getSexa() {
        return this.getSexa("");
    }

    public String getSexa(String string) {
        return Coord.getSexa(this.al, this.del, string);
    }

    public String getDegPlanet(boolean bl) {
        String string = Util.myRound(Math.abs(this.del));
        String string2 = this.del < 0.0 ? "S" : "N";
        double d = this.al > 180.0 ? this.al - 360.0 : this.al;
        String string3 = Util.myRound(Math.abs(d));
        String string4 = bl && d < 0.0 || !bl && d >= 0.0 ? "W" : "E";
        return string + " " + string2 + ", " + string3 + " " + string4;
    }

    public String getSexaPlanet(boolean bl) {
        String string = this.getSexaD(this.del);
        String string2 = this.del < 0.0 ? "S" : "N";
        double d = this.al > 180.0 ? this.al - 360.0 : this.al;
        String string3 = this.getSexaD(d);
        String string4 = bl && d < 0.0 || !bl && d >= 0.0 ? "W" : "E";
        return string + " " + string2 + ", " + string3 + " " + string4;
    }

    public String getSexaD(double d) {
        d = Math.abs(d);
        int n = (int)d;
        double d2 = (d - (double)n) * 60.0;
        int n2 = (int)d2;
        double d3 = (d2 - (double)n2) * 60.0;
        return n + "\u00b0" + n2 + "'" + Util.myRound(d3) + "\"";
    }

    public String toString() {
        return this.getSexa();
    }

    public String getRA() {
        return this.getRA(':');
    }

    public String getRA(char c) {
        try {
            String string = this.getSexa(c + "");
            int n = string.indexOf(43);
            if (n == -1) {
                n = string.indexOf(45);
            }
            return string.substring(0, n - 1);
        }
        catch (Exception exception) {
            return "";
        }
    }

    public String getDE() {
        return this.getDE(':');
    }

    public String getDE(char c) {
        try {
            String string = this.getSexa(c + "");
            int n = string.indexOf(43);
            if (n == -1) {
                n = string.indexOf(45);
            }
            return string.substring(n);
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static String getUnit(double d) {
        return Coord.getUnit(d, false, false);
    }

    public static String getUnit(double d, boolean bl, boolean bl2) {
        double d2;
        if (d == 0.0) {
            return "";
        }
        String string = null;
        double d3 = bl2 ? 3600.0 : 60.0;
        double d4 = d2 = bl2 ? 100000.0 : 1000.0;
        if (Math.abs(d) >= 1.0) {
            string = "\u00b0";
        }
        if (Math.abs(d) < 1.0) {
            string = "'";
            d *= d3;
        }
        if (Math.abs(d) < 1.0) {
            string = "\"";
            d *= d3;
        }
        if (Math.abs(d) < 1.0) {
            string = "mas";
            d *= d2;
        }
        if (Math.abs(d) < 1.0) {
            string = "\u00b5as";
            d *= d2;
        }
        if (bl && (int)d != 0) {
            return (int)d + string;
        }
        string = Util.myRound(d) + string;
        return string;
    }

    public static String getUnitTime(double d) {
        String string = null;
        if (d >= 1.0) {
            string = "h";
        }
        if (d < 1.0) {
            string = "min";
            d *= 60.0;
        }
        if (d < 1.0) {
            string = "s";
            d *= 60.0;
        }
        d = (double)((int)(d * 100.0)) / 100.0;
        string = d + " " + string;
        return string;
    }

    public static double getDist(Coord coord, Coord coord2) {
        return Coo.distance(coord.al, coord.del, coord2.al, coord2.del);
    }
}

