/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Coord;
import cds.aladin.CoteDist;
import cds.aladin.Couleur;
import cds.aladin.Ligne;
import cds.aladin.Plan;
import cds.aladin.PlanImage;
import cds.aladin.PlanImageRGB;
import cds.aladin.PointD;
import cds.aladin.Projection;
import cds.aladin.ViewSimple;
import cds.aladin.prop.Prop;
import cds.aladin.prop.PropAction;
import cds.astro.AstroMath;
import cds.tools.Util;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;

public class Cote
extends Ligne {
    protected double dist = -1.0;
    private double distXY = -1.0;
    private int[] vBresenham = null;
    private int[] repBresenham = null;

    protected Cote(Plan plan, ViewSimple viewSimple, double d, double d2) {
        super(plan, viewSimple, d, d2, (String)null);
        this.bout = (byte)2;
    }

    protected Cote(Plan plan) {
        super(plan);
        this.bout = (byte)2;
    }

    protected Cote(Plan plan, ViewSimple viewSimple, double d, double d2, String string) {
        super(plan, viewSimple, d, d2, string);
        this.bout = (byte)2;
    }

    protected Cote(Plan plan, ViewSimple viewSimple, double d, double d2, Cote cote) {
        this(plan, viewSimple, d, d2, "", cote);
    }

    protected Cote(Plan plan, ViewSimple viewSimple, double d, double d2, String string, Cote cote) {
        super(plan, viewSimple, d, d2, string, (Ligne)cote);
        this.bout = (byte)2;
    }

    protected Cote(double d, double d2, Plan plan, ViewSimple viewSimple, Cote cote) {
        super(d, d2, plan, viewSimple, (Ligne)cote);
        this.bout = (byte)2;
    }

    protected Cote(double d, double d2, Plan plan, ViewSimple viewSimple, Ligne ligne) {
        super(d, d2, plan, viewSimple, ligne);
        this.bout = (byte)2;
    }

    @Override
    public Vector getProp() {
        Cote cote = (Cote)this.getFirstBout();
        Cote cote2 = (Cote)this.getLastBout();
        Vector vector = cote.getProp1();
        vector.addAll(cote2.getProp1());
        final Couleur couleur = new Couleur(this.couleur, true);
        final PropAction propAction = new PropAction(){

            @Override
            public int action() {
                Color color = couleur.getCouleur();
                if (color == Cote.this.couleur) {
                    return -1;
                }
                Cote.this.setColor(color);
                return 1;
            }
        };
        couleur.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                propAction.action();
                Cote.this.plan.aladin.view.repaintAll();
            }
        });
        vector.add(Prop.propFactory("color", "Color", "Alternative color", couleur, null, propAction));
        return vector;
    }

    public Vector getProp1() {
        Vector vector = super.getProp();
        Prop.remove(vector, "color");
        return vector;
    }

    @Override
    public String getObjType() {
        return this.finligne == null ? "Arrow" : "Arrow+";
    }

    @Override
    protected void status(Aladin aladin) {
        this.setId();
        super.status(aladin);
    }

    @Override
    protected boolean in(ViewSimple viewSimple, double d, double d2) {
        if (!super.in(viewSimple, d, d2)) {
            return false;
        }
        this.setId(viewSimple);
        return true;
    }

    protected double getDist() {
        return this.dist;
    }

    protected double getDistXY() {
        return this.distXY;
    }

    @Override
    protected void deltaPosition(ViewSimple viewSimple, double d, double d2) {
        super.deltaPosition(viewSimple, d, d2);
        if (this.finligne != null) {
            ((Cote)this.finligne).setId(viewSimple);
        } else {
            this.setId(viewSimple);
        }
    }

    @Override
    protected void deltaRaDec(double d, double d2) {
        super.deltaRaDec(d, d2);
        if (this.finligne != null) {
            ((Cote)this.finligne).setId();
        } else {
            this.setId();
        }
    }

    @Override
    protected void setPosition(ViewSimple viewSimple, double d, double d2) {
        super.setPosition(viewSimple, d, d2);
        if (this.finligne != null) {
            ((Cote)this.finligne).setId();
        }
        this.setId();
    }

    protected void setId() {
        this.setId(null);
    }

    protected void setId(ViewSimple viewSimple) {
        Ligne ligne;
        Ligne ligne2;
        block11: {
            if (this.debligne != null) {
                ligne2 = this;
                ligne = this.debligne;
            } else {
                ligne2 = this.finligne;
                ligne = this;
            }
            if (viewSimple == null) {
                viewSimple = this.plan.aladin.view.getCurrentView();
            }
            if (viewSimple == null) {
                return;
            }
            int n = this.plan.aladin.localisation.getFrame();
            if (n != 11 && n != 12 && n != 13) {
                try {
                    if (Projection.isOk(viewSimple.getProj())) {
                        Coord coord = new Coord(ligne.raj, ligne.dej);
                        Coord coord2 = new Coord(ligne2.raj, ligne2.dej);
                        if (!Double.isNaN(coord.al) && !Double.isNaN(coord2.al)) {
                            double d;
                            double d2 = coord2.al - coord.al;
                            double d3 = Math.abs(coord.del - coord2.del);
                            double d4 = AstroMath.cosd(coord2.del);
                            double d5 = d4 * AstroMath.sind(d2);
                            double d6 = AstroMath.sind(coord2.del) * AstroMath.cosd(coord.del) - d4 * AstroMath.sind(coord.del) * AstroMath.cosd(d2);
                            double d7 = d2 == 0.0 && d3 == 0.0 ? -1000.0 : (d = d6 == 0.0 ? 90.0 : Math.atan2(d5, d6) * 180.0 / Math.PI);
                            if (d < 0.0) {
                                d += 360.0;
                            }
                            if ((d2 = Math.abs(d2)) > 180.0) {
                                d2 -= 360.0;
                            }
                            double d8 = d2 * AstroMath.cosd(coord.del);
                            this.dist = Coord.getDist(coord, coord2);
                            this.id = this.dist == 0.0 ? "Null distance" : "Dist = " + Coord.getUnit(this.dist) + " (RA=" + Coord.getUnit(d8) + "/" + Coord.getUnitTime(d2 / 15.0) + ", DE=" + Coord.getUnit(d3) + ")" + (d == -1000.0 ? "" : " PA = " + (double)Math.round(d * 10.0) / 10.0 + " deg");
                            viewSimple.getProj().getXY(coord);
                            viewSimple.getProj().getXY(coord2);
                            double d9 = coord.x - coord2.x;
                            double d10 = coord.y - coord2.y;
                            this.distXY = (int)(Math.sqrt(d9 * d9 + d10 * d10) + 0.5);
                            return;
                        }
                    }
                }
                catch (Exception exception) {
                    if (Aladin.levelTrace < 3) break block11;
                    exception.printStackTrace();
                }
            }
        }
        double d = viewSimple.HItoI(ligne.xv[viewSimple.n]) - viewSimple.HItoI(ligne2.xv[viewSimple.n]);
        double d11 = viewSimple.HItoI(ligne.yv[viewSimple.n]) - viewSimple.HItoI(ligne2.yv[viewSimple.n]);
        this.dist = this.distXY = Math.sqrt(d * d + d11 * d11);
        this.id = Util.myRound(this.distXY + "", 1) + " (delta x=" + Util.myRound(d + "", 2) + ", delta y=" + Util.myRound(d11 + "", 2) + ")";
    }

    @Override
    protected boolean inside(ViewSimple viewSimple, double d, double d2) {
        Ligne ligne;
        Ligne ligne2;
        if (!this.isVisible()) {
            return false;
        }
        if (this.nearArrow(viewSimple, d, d2)) {
            return true;
        }
        if (this.debligne == null) {
            ligne = ligne2 = this.finligne;
        } else {
            ligne = this.debligne;
            ligne2 = this;
        }
        return ligne2.in(viewSimple, d, d2) && !ligne.nearArrow(viewSimple, d, d2);
    }

    @Override
    protected void drawID(Graphics graphics, ViewSimple viewSimple, Point point, Point point2) {
        if (!this.isCoteSelected()) {
            return;
        }
        this.drawID1(graphics, viewSimple, point, point2);
    }

    protected void drawID1(Graphics graphics, ViewSimple viewSimple, Point point, Point point2) {
        double d = point2.y - point.y;
        double d2 = point2.x - point.x;
        if (Math.sqrt(d * d + d2 * d2) < 20.0 && viewSimple.getTaille() > 10.0) {
            return;
        }
        int n = (point.x + point2.x) / 2;
        int n2 = (point.y + point2.y) / 2;
        graphics.setFont(Aladin.BOLD);
        int n3 = this.plan.aladin.localisation.getFrame();
        String string = this.raj == Double.NaN || n3 == 11 || n3 == 12 || n3 == 13 ? Util.myRound(this.dist + "", 2) : Coord.getUnit(this.dist);
        int n4 = n + 3;
        int n5 = n2 + (d * d2 > 0.0 ? -2 : 12);
        int n6 = graphics.getFontMetrics().stringWidth(string);
        Color color = graphics.getColor();
        Color color2 = color == Color.red || color == Color.blue ? Color.white : Color.black;
        Util.drawStringOutline(graphics, string, n4, n5, color, color2);
        graphics.setColor(color);
    }

    private boolean isCoteSelected() {
        if (this.debligne != null) {
            return this.isSelected() || this.debligne.isSelected();
        }
        return this.isSelected() || this.finligne.isSelected();
    }

    @Override
    protected int clipXId() {
        return !this.isCoteSelected() ? 0 : 12 * Coord.getUnit(this.dist).length();
    }

    @Override
    protected int clipYId() {
        return !this.isCoteSelected() ? 0 : 15;
    }

    @Override
    protected boolean tooLarge(ViewSimple viewSimple, Point point, Point point2) {
        return false;
    }

    @Override
    protected boolean draw(Graphics graphics, ViewSimple viewSimple, int n, int n2) {
        if (this instanceof CoteDist) {
            return super.draw(graphics, viewSimple, n, n2);
        }
        if (!this.isVisible()) {
            return false;
        }
        if (!super.draw(graphics, viewSimple, n, n2)) {
            this.cutOff();
            return false;
        }
        if ((this.isSelected() || this.debligne != null && this.debligne.isSelected() || this.finligne != null && this.finligne.isSelected()) && this.plan.aladin.view.hasOneCoteSelected()) {
            this.cutOn();
        } else {
            this.cutOff();
        }
        return true;
    }

    protected void cutOff() {
        this.plan.aladin.calque.zoom.zoomView.cutOff(this);
    }

    @Override
    protected boolean cutOn() {
        boolean bl = this.cutOn1();
        if (!bl) {
            this.plan.aladin.calque.zoom.zoomView.setCut(null);
        }
        return bl;
    }

    protected boolean cutOn1() {
        int n;
        int n2;
        int n3;
        int n4;
        ViewSimple viewSimple = this.plan.aladin.view.getCurrentView();
        if (Aladin.OUTREACH) {
            return false;
        }
        if (viewSimple == null || this.plan.aladin.toolBox.getTool() == 8) {
            return false;
        }
        Plan plan = viewSimple.pref;
        if (plan == null || !plan.hasAvailablePixels() && !(plan instanceof PlanImageRGB)) {
            return false;
        }
        PlanImage planImage = (PlanImage)plan;
        if (this.debligne == null) {
            n4 = (int)this.xv[viewSimple.n];
            n3 = (int)this.yv[viewSimple.n];
            n2 = (int)this.finligne.xv[viewSimple.n];
            n = (int)this.finligne.yv[viewSimple.n];
        } else {
            n4 = (int)this.debligne.xv[viewSimple.n];
            n3 = (int)this.debligne.yv[viewSimple.n];
            n2 = (int)this.xv[viewSimple.n];
            n = (int)this.yv[viewSimple.n];
        }
        if (n4 != n2 || n3 != n) {
            Object object;
            if (viewSimple.northUp || viewSimple.isProjSync()) {
                object = new PointD(n4, n3);
                object = viewSimple.northOrSyncToRealPosition((PointD)object);
                n4 = (int)((PointD)object).x;
                n3 = (int)((PointD)object).y;
                object = new PointD(n2, n);
                object = viewSimple.northOrSyncToRealPosition((PointD)object);
                n2 = (int)((PointD)object).x;
                n = (int)((PointD)object).y;
            }
            object = this.bresenham(planImage, n4, n3, n2, n);
            int n5 = planImage.type == 2 || planImage.type == 20 ? 1 : 0;
            this.plan.aladin.calque.zoom.zoomView.setCut(this, (int[])object, n5);
        }
        return true;
    }

    protected int[] bresenham(PlanImage planImage, int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13 = Math.abs(n3 - n);
        int n14 = Math.abs(n4 - n2);
        int n15 = planImage.width;
        int n16 = planImage.height;
        int n17 = 0;
        if (this.vBresenham == null || this.vBresenham.length != n13 + n14 + 2) {
            this.vBresenham = new int[n13 + n14 + 2];
        }
        n17 = 0;
        boolean bl = false;
        if (n13 > n14) {
            if (n < n3) {
                n12 = n;
                n11 = n2;
                n10 = n3;
                n9 = n4;
            } else {
                n12 = n3;
                n11 = n4;
                n10 = n;
                n9 = n2;
                bl = true;
            }
            n8 = 2 * n14 - n13;
            int n18 = 2 * n14;
            n7 = 2 * (n14 - n13);
            n6 = n11 < n9 ? 1 : 0;
            for (n5 = 0; n5 < n13; ++n5) {
                int n19 = this.vBresenham[n17++] = n12 < 0 || n12 >= n15 || n11 < 0 || n11 >= n16 ? -1 : planImage.getPixel8(n12, n11);
                if (n8 > 0) {
                    n11 = n6 != 0 ? ++n11 : --n11;
                    n8 += n7;
                } else {
                    n8 += n18;
                }
                ++n12;
            }
        } else {
            if (n2 < n4) {
                n12 = n;
                n11 = n2;
                n10 = n3;
                n9 = n4;
            } else {
                n12 = n3;
                n11 = n4;
                n10 = n;
                n9 = n2;
                bl = true;
            }
            n8 = 2 * n13 - n14;
            int n20 = 2 * n13;
            n7 = 2 * (n13 - n14);
            n6 = n12 < n10 ? 1 : 0;
            for (n5 = 0; n5 < n14; ++n5) {
                int n21 = this.vBresenham[n17++] = n12 < 0 || n12 >= n15 || n11 < 0 || n11 >= n16 ? -1 : planImage.getPixel8(n12, n11);
                if (n8 > 0) {
                    n12 = n6 != 0 ? ++n12 : --n12;
                    n8 += n7;
                } else {
                    n8 += n20;
                }
                ++n11;
            }
        }
        int n22 = this.vBresenham[n17++] = n10 < 0 || n10 >= n15 || n9 < 0 || n9 >= n16 ? -1 : planImage.getPixel8(n10, n9);
        if (this.repBresenham == null || this.repBresenham.length != n17) {
            this.repBresenham = new int[n17];
        }
        if (bl) {
            for (n6 = 0; n6 < n17; ++n6) {
                this.repBresenham[n17 - n6 - 1] = this.vBresenham[n6];
            }
        } else {
            System.arraycopy(this.vBresenham, 0, this.repBresenham, 0, n17);
        }
        this.vBresenham = null;
        return this.repBresenham;
    }
}

