/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Calque;
import cds.aladin.Plan;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;

public final class Couleur
extends JComponent
implements MouseListener {
    static final int W = 20;
    static final int GAP = 4;
    int w = 16;
    static int iDC = 0;
    int ww = 20;
    int gap = 4;
    private boolean noColor = false;
    static final int NBDEFAULTCOLORS = 22;
    static Color[] DC;
    static Color[] DC1;
    Color[] dc;
    Rectangle[] dcRect;
    int row;
    int current = -1;
    boolean first;
    private Dimension DIM;
    private ActionListener listener = null;

    protected Couleur() {
        this(null);
    }

    protected Couleur(Color color) {
        this(color, false);
    }

    protected Couleur(Color color, boolean bl) {
        this.dc = DC;
        this.noColor = bl;
        this.setCouleur(color);
        this.DIM = new Dimension(this.dc.length / 2 * 20, 40);
        this.first = true;
        this.row = this.dc.length / 2;
        this.addMouseListener(this);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.DIM;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.DIM;
    }

    private static int nextRand() {
        return (int)(Math.random() * 1000.0) % 256;
    }

    private static void initDefaultColors() {
        int n = 22;
        DC = new Color[n];
        for (int i = 0; i < n; ++i) {
            Couleur.DC[i] = i < DC1.length ? DC1[i] : new Color(Couleur.nextRand(), Couleur.nextRand(), Couleur.nextRand());
        }
    }

    protected Couleur(Color color, int n, int n2) {
        this.dc = DC;
        this.setCouleur(color);
        if (n > n2) {
            this.ww = n;
            this.gap = n2;
            this.w = this.ww - this.gap;
        }
        this.DIM = new Dimension(DC.length / 2 * this.ww, 2 * this.ww);
        this.first = true;
        this.row = this.dc.length / 2;
        this.addMouseListener(this);
    }

    protected Couleur(Color color, int n, int n2, Color[] colorArray) {
        int n3;
        this.dc = new Color[DC1.length + colorArray.length];
        for (n3 = 0; n3 < DC1.length; ++n3) {
            this.dc[n3] = DC1[n3];
        }
        for (n3 = 0; n3 < colorArray.length; ++n3) {
            this.dc[n3 + Couleur.DC1.length] = colorArray[n3];
        }
        this.row = this.dc.length / 2;
        this.setCouleur(color);
        if (n > n2) {
            this.ww = n;
            this.gap = n2;
            this.w = this.ww - this.gap;
        }
        this.DIM = new Dimension(this.dc.length / 2 * this.ww, 2 * this.ww);
        this.first = true;
        this.addMouseListener(this);
    }

    protected Couleur(Color[] colorArray, Color color, int n, int n2) {
        this.dc = new Color[colorArray.length];
        for (int i = 0; i < colorArray.length; ++i) {
            this.dc[i] = colorArray[i];
        }
        this.row = this.dc.length / 2;
        this.setCouleur(color);
        if (n > n2) {
            this.ww = n;
            this.gap = n2;
            this.w = this.ww - this.gap;
        }
        this.DIM = new Dimension(this.dc.length / 2 * this.ww, 2 * this.ww);
        this.first = true;
        this.addMouseListener(this);
    }

    protected void setNoColorFlag(boolean bl) {
        this.noColor = bl;
    }

    protected static Color getNextDefault(Calque calque) {
        int n;
        Plan[] planArray = calque.getPlans();
        for (n = 0; n < DC.length; ++n) {
            int n2;
            for (n2 = 0; n2 < planArray.length && (planArray[n2].type == 0 || DC[n] != planArray[n2].c); ++n2) {
            }
            if (n2 == planArray.length) break;
        }
        if (n == DC.length) {
            if (++iDC == DC.length) {
                iDC = 0;
            }
            n = iDC;
        }
        return DC[n];
    }

    protected static boolean isFree(Calque calque, Color color) {
        Plan[] planArray = calque.getPlans();
        for (int i = 0; i < planArray.length; ++i) {
            if (planArray[i].type == 0 || color != planArray[i].c) continue;
            return false;
        }
        return true;
    }

    protected boolean setCouleur(Color color) {
        if (this.noColor && color == null) {
            this.current = this.dc.length - 1;
            return true;
        }
        for (int i = 0; i < this.dc.length; ++i) {
            if (!color.equals(this.dc[i])) continue;
            this.current = i;
            this.repaint();
            return true;
        }
        return false;
    }

    protected Color getCouleur() {
        if (this.current == -1 || this.noColor && this.current == this.dc.length - 1) {
            return null;
        }
        return this.dc[this.current];
    }

    protected static Color getCouleur(int n) {
        return DC[n % DC.length];
    }

    private int getIndice(int n, int n2) {
        if (this.dcRect == null) {
            return -1;
        }
        Point point = new Point(n, n2);
        for (int i = 0; i < this.dcRect.length; ++i) {
            if (!this.dcRect[i].contains(point)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        int n = this.getIndice(mouseEvent.getX(), mouseEvent.getY());
        if (this.current != n) {
            this.current = n;
            if (this.listener != null) {
                this.listener.actionPerformed(new ActionEvent(this, 1001, ""));
            }
            this.repaint();
        }
    }

    @Override
    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    @Override
    public void paint(Graphics graphics) {
        if (this.first) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, this.dc.length / 2 * this.ww, 2 * this.ww);
            this.first = false;
        }
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < this.row; ++j) {
                Color color;
                Color color2;
                int n = i * this.row + j;
                if (this.dcRect == null) {
                    this.dcRect = new Rectangle[this.dc.length];
                }
                if (this.dcRect[n] == null) {
                    this.dcRect[n] = new Rectangle(j * this.ww, i * this.ww, this.w, this.w);
                }
                boolean bl = this.noColor && n == this.dc.length - 1;
                graphics.setColor(bl ? Color.white : this.dc[n]);
                graphics.fillRect(this.dcRect[n].x, this.dcRect[n].y, this.dcRect[n].width, this.dcRect[n].height);
                if (n != this.current) {
                    color2 = Color.white;
                    color = Color.black;
                } else {
                    color = Color.white;
                    color2 = Color.black;
                }
                graphics.setColor(color2);
                graphics.drawLine(this.dcRect[n].x, this.dcRect[n].y + this.dcRect[n].height, this.dcRect[n].x, this.dcRect[n].y);
                graphics.drawLine(this.dcRect[n].x, this.dcRect[n].y, this.dcRect[n].x + this.dcRect[n].width, this.dcRect[n].y);
                graphics.setColor(color);
                graphics.drawLine(this.dcRect[n].x + this.w, this.dcRect[n].y, this.dcRect[n].x + this.dcRect[n].width, this.dcRect[n].y + this.dcRect[n].height);
                graphics.drawLine(this.dcRect[n].x + this.w, this.dcRect[n].y + this.dcRect[n].height, this.dcRect[n].x, this.dcRect[n].y + this.dcRect[n].height);
                if (!bl) continue;
                graphics.setColor(Color.black);
                graphics.drawLine(this.dcRect[n].x, this.dcRect[n].y, this.dcRect[n].x + this.dcRect[n].width, this.dcRect[n].y + this.dcRect[n].height);
                graphics.drawLine(this.dcRect[n].x, this.dcRect[n].y + this.dcRect[n].height, this.dcRect[n].x + this.dcRect[n].width, this.dcRect[n].y);
            }
        }
    }

    protected static Color[] getBrighterColors(Color color, int n) {
        Color[] colorArray = new Color[n];
        float[] fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        float f = (fArray[1] - 0.15f) / (float)Math.max(1, n - 1);
        for (int i = 0; i < n; ++i) {
            colorArray[i] = Color.getHSBColor(fArray[0], fArray[1] - (float)i * f, fArray[2]);
        }
        return colorArray;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void addActionListener(ActionListener actionListener) {
        this.listener = actionListener;
    }

    public void removeActionListener(ActionListener actionListener) {
        this.listener = null;
    }

    static {
        DC1 = new Color[]{Color.red, Color.blue, new Color(153, 204, 0), new Color(255, 255, 0), new Color(0, 0, 102), new Color(0, 255, 255), new Color(153, 0, 204), new Color(0, 153, 204), new Color(204, 153, 0), new Color(204, 0, 153), new Color(0, 254, 153), new Color(102, 51, 51), new Color(255, 204, 154), new Color(255, 154, 204), new Color(154, 255, 51), new Color(102, 0, 0), new Color(255, 154, 51), new Color(255, 0, 255), new Color(0, 255, 0), new Color(0, 0, 0), new Color(255, 255, 255)};
        Couleur.initDefaultColors();
    }
}

