/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Coord;
import cds.aladin.Plan;
import cds.aladin.PlanBG;
import cds.aladin.PlanImage;
import cds.aladin.PlanMoc;
import cds.aladin.PointD;
import cds.aladin.Projection;
import cds.aladin.RectangleD;
import cds.aladin.ViewSimple;
import cds.tools.Util;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.KeyEvent;

public class CropTool {
    static final int IN = 0;
    static final int HG = 1;
    static final int HD = 2;
    static final int BD = 3;
    static final int BG = 4;
    static final int H = 5;
    static final int D = 6;
    static final int B = 7;
    static final int G = 8;
    static final int START = 9;
    static final int[] CURSOR = new int[]{12, 6, 4, 5, 7, 8, 11, 9, 10, 5};
    private static final int OK = 0;
    private static final int CLOSE = 1;
    private static final int LABEL_POS = 2;
    private static final int LABEL_RES = 3;
    private static final int LABEL_WIDTH = 4;
    private static final int LABEL_HEIGHT = 5;
    private static final int CHECKBOX_RES = 6;
    static final int W = 20;
    private Aladin aladin;
    private Color color = Color.red;
    private Plan plan;
    private RectangleD r;
    private double resMult;
    private boolean withFullRes;
    private boolean fullRes;
    private boolean visible = false;
    private int edit = -1;
    private StringBuffer stringEdit = null;
    private int moveLabel = -1;
    private int movePoignee = -1;
    private int dragPoignee = -1;
    private double dragX = -1.0;
    private double dragY = -1.0;
    private RectangleD[] rectButton = new RectangleD[7];
    private boolean hasButton = false;
    private int oCursor = -1;

    public CropTool(Aladin aladin, ViewSimple viewSimple, Plan plan, double d, double d2, boolean bl) {
        this.aladin = aladin;
        this.plan = plan;
        PointD pointD = viewSimple.getPosition(d, d2);
        this.r = new RectangleD(pointD.x, pointD.y, 1.0 / viewSimple.zoom, 1.0 / viewSimple.zoom);
        this.dragX = pointD.x;
        this.dragY = pointD.y;
        this.dragPoignee = 9;
        this.visible = true;
        this.withFullRes = bl;
        this.fullRes = false;
        this.resMult = 1.0;
    }

    public void deltaXY(double d, double d2) {
        this.r.x += d;
        this.r.y += d2;
    }

    public boolean submit(ViewSimple viewSimple, double d, double d2) {
        if (!this.hasButton) {
            return false;
        }
        this.edit = -1;
        if (this.rectButton[0].contains(d, d2)) {
            this.doCrop(viewSimple);
            return true;
        }
        if (this.rectButton[1].contains(d, d2)) {
            return true;
        }
        for (int i = 2; i < 6; ++i) {
            if (this.rectButton[i] == null || !this.rectButton[i].contains(d, d2)) continue;
            this.startEdit(i, viewSimple);
        }
        if (this.rectButton[6] != null && this.rectButton[6].contains(d, d2)) {
            this.switchCheckFullRes(viewSimple);
        }
        return false;
    }

    public void doCrop(ViewSimple viewSimple) {
        if (this.doMocCrop(viewSimple)) {
            return;
        }
        this.aladin.calque.newPlanImageByCrop(viewSimple, this.getRectangle(), this.getResMult(), this.fullRes);
        this.aladin.log("Crop", viewSimple.pref.getLogInfo());
    }

    public boolean doMocCrop(ViewSimple viewSimple) {
        Plan plan = this.plan;
        if (!(plan instanceof PlanMoc)) {
            return false;
        }
        Projection projection = viewSimple.getProj();
        Coord[] coordArray = new Coord[4];
        for (int i = 0; i < 4; ++i) {
            Coord coord = new Coord();
            coord.x = this.r.x + (i == 1 || i == 2 ? this.r.width : 0.0);
            coord.y = this.r.y + (i > 1 ? this.r.height : 0.0);
            projection.getCoord(coord);
            coordArray[i] = coord;
        }
        this.aladin.calque.newPlanMoc("Crop " + plan.label, (PlanMoc)plan, coordArray);
        return true;
    }

    public void switchCheckFullRes(ViewSimple viewSimple) {
        this.fullRes = !this.fullRes;
        this.resMult = this.computeResMult(viewSimple);
        this.aladin.view.repaintAll();
    }

    private double getPixelSizeInView(ViewSimple viewSimple) {
        Coord coord = new Coord();
        Coord coord2 = new Coord();
        Projection projection = viewSimple.getProj();
        coord.x = this.r.x + this.r.width / 2.0;
        coord.y = this.r.y + this.r.height / 2.0;
        coord2.x = this.r.x + this.r.width / 2.0;
        coord2.y = this.r.y + this.r.height;
        projection.getCoord(coord);
        projection.getCoord(coord2);
        double d = Coord.getDist(coord, coord2) * 2.0;
        return d / (this.r.height * viewSimple.zoom);
    }

    private double computeResMult(ViewSimple viewSimple) {
        if (!this.fullRes) {
            return 1.0;
        }
        double d = this.getPixelSizeInView(viewSimple);
        double d2 = ((PlanBG)viewSimple.pref).getPixelResolution();
        return d / d2;
    }

    public void startEdit(int n, ViewSimple viewSimple) {
        this.edit = n;
        this.stringEdit = new StringBuffer("" + (n == 2 ? Util.myRound(this.r.x + "", 0) + "," + Util.myRound((double)((PlanImage)viewSimple.pref).naxis2 - (this.r.y + this.r.height) + "", 0) : (n == 5 ? Util.myRound("" + this.getHeight(viewSimple), 0) : (n == 4 ? Util.myRound("" + this.getWidth(viewSimple)) : Double.valueOf(this.getResMult())))));
        this.aladin.view.startTimer(500);
    }

    public boolean keyPress(ViewSimple viewSimple, KeyEvent keyEvent) {
        if (!this.isEditing()) {
            return false;
        }
        int n = keyEvent.getKeyCode();
        char c = keyEvent.getKeyChar();
        if (n == 27) {
            this.stopEditing();
            return true;
        }
        if (n == 10) {
            try {
                switch (this.edit) {
                    case 2: {
                        int n2 = this.stringEdit.indexOf(",");
                        if (n2 <= 0) break;
                        this.r.x = Double.parseDouble(this.stringEdit.substring(0, n2).trim());
                        this.r.y = Double.parseDouble(this.stringEdit.substring(n2 + 1).trim());
                        this.r.y = (double)((PlanImage)viewSimple.pref).naxis2 - this.r.y - this.r.height;
                        break;
                    }
                    case 4: {
                        this.r.width = Double.parseDouble(this.stringEdit.toString().trim());
                        if (!(viewSimple.pref instanceof PlanBG)) break;
                        this.r.width /= viewSimple.zoom * this.getResMult();
                        break;
                    }
                    case 5: {
                        this.r.height = Double.parseDouble(this.stringEdit.toString().trim());
                        if (!(viewSimple.pref instanceof PlanBG)) break;
                        this.r.height /= viewSimple.zoom * this.getResMult();
                        break;
                    }
                    case 3: {
                        this.resMult = Double.parseDouble(this.stringEdit.toString());
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.stopEditing();
            return true;
        }
        if (n == 8 || n == 127) {
            int n3 = this.stringEdit.length();
            if (n3 == 0) {
                return false;
            }
            this.stringEdit.deleteCharAt(n3 - 1);
            return true;
        }
        if (c >= '\u001f' && c <= '\u00ff') {
            this.stringEdit.append(c);
            return true;
        }
        return false;
    }

    public double getWidth(ViewSimple viewSimple) {
        if (viewSimple.pref instanceof PlanBG) {
            return Math.round(this.r.width * viewSimple.zoom * this.getResMult());
        }
        return this.r.width;
    }

    public double getHeight(ViewSimple viewSimple) {
        if (viewSimple.pref instanceof PlanBG) {
            return Math.round(this.r.height * viewSimple.zoom * this.getResMult());
        }
        return this.r.height;
    }

    public RectangleD getRectangle() {
        return new RectangleD(this.r.x, this.r.y, this.r.width, this.r.height);
    }

    public double getResMult() {
        return !this.withFullRes ? 1.0 : this.resMult;
    }

    public void reset() {
        this.setVisible(true);
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public PointD getFocusPos() {
        if (this.isEditing()) {
            return new PointD(this.rectButton[this.edit].x + this.rectButton[this.edit].width, this.rectButton[this.edit].y);
        }
        return new PointD(this.r.x + this.r.width / 2.0, this.r.y + this.r.height / 2.0);
    }

    public boolean isDragging() {
        return this.visible && this.dragPoignee != -1;
    }

    public boolean isEditing() {
        return this.visible && this.edit != -1;
    }

    public void stopEditing() {
        this.edit = -1;
    }

    public void mouseMove(double d, double d2, ViewSimple viewSimple) {
        if (!this.visible) {
            return;
        }
        this.moveLabel = this.getLabel(d, d2);
        if (this.moveLabel != -1) {
            return;
        }
        PointD pointD = viewSimple.getPosition(d, d2);
        this.movePoignee = this.getPoignee(pointD.x, pointD.y, viewSimple);
    }

    public boolean startDrag(ViewSimple viewSimple, double d, double d2) {
        if (!this.visible) {
            return false;
        }
        PointD pointD = viewSimple.getPosition(d, d2);
        this.dragPoignee = this.getPoignee(pointD.x, pointD.y, viewSimple);
        if (this.dragPoignee == -1) {
            this.dragY = -1.0;
            this.dragX = -1.0;
            return false;
        }
        this.dragX = pointD.x;
        this.dragY = pointD.y;
        return true;
    }

    public void mouseDrag(ViewSimple viewSimple, int n, int n2, boolean bl) {
        if (!this.visible) {
            return;
        }
        PointD pointD = viewSimple.getPosition((double)n, (double)n2);
        double d = pointD.x;
        double d2 = pointD.y;
        double d3 = d - this.dragX;
        double d4 = d2 - this.dragY;
        if (bl && (this.dragPoignee == 1 || this.dragPoignee == 2 || this.dragPoignee == 4 || this.dragPoignee == 3)) {
            if (this.r.width < this.r.height) {
                this.r.width = this.r.height;
            } else {
                this.r.height = this.r.width;
            }
            if (Math.abs(d3) < Math.abs(d4)) {
                d3 = d4;
            } else {
                d4 = d3;
            }
        }
        switch (this.dragPoignee) {
            case 0: {
                this.r.x += d3;
                this.r.y += d4;
                break;
            }
            case 1: {
                this.r.x += d3;
                this.r.y += d4;
                this.r.width -= d3;
                this.r.height -= d4;
                break;
            }
            case 2: {
                this.r.y += d4;
                this.r.width += d3;
                this.r.height -= d4;
                break;
            }
            case 3: 
            case 9: {
                this.r.width += d3;
                this.r.height += d4;
                break;
            }
            case 4: {
                this.r.x += d3;
                this.r.width -= d3;
                this.r.height += d4;
                break;
            }
            case 5: {
                this.r.y += d4;
                this.r.height -= d4;
                break;
            }
            case 6: {
                this.r.width += d3;
                break;
            }
            case 7: {
                this.r.height += d4;
                break;
            }
            case 8: {
                this.r.x += d3;
                this.r.width -= d3;
            }
        }
        if (this.r.width * viewSimple.zoom < 1.0) {
            this.r.width = 1.0 / viewSimple.zoom;
        }
        if (this.r.height * viewSimple.zoom < 1.0) {
            this.r.height = 1.0 / viewSimple.zoom;
        }
        this.dragX = d;
        this.dragY = d2;
    }

    public void endDrag(ViewSimple viewSimple) {
        this.dragPoignee = -1;
        this.dragY = -1.0;
        this.dragX = -1.0;
        if (viewSimple.pref instanceof PlanBG) {
            double d = viewSimple.zoom * this.getResMult();
            this.r.x = (double)Math.round(this.r.x * d) / d;
            this.r.y = (double)Math.round(this.r.y * d) / d;
            this.r.height = (double)Math.round(this.r.height * d) / d;
            this.r.width = (double)Math.round(this.r.width * d) / d;
        } else {
            this.r.x = Math.round(this.r.x);
            this.r.y = Math.round(this.r.y);
            this.r.width = Math.round(this.r.width);
            this.r.height = Math.round(this.r.height);
        }
    }

    private int getLabel(double d, double d2) {
        try {
            for (int i = 2; i <= 5; ++i) {
                if (!this.fullRes && i == 3 || !this.rectButton[i].contains(d, d2)) continue;
                return i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return -1;
    }

    private int getPoignee(double d, double d2, ViewSimple viewSimple) {
        if (!this.visible) {
            return -1;
        }
        if (this.r.width == 1.0 || this.r.height == 1.0) {
            return 3;
        }
        for (int i = 1; i <= 8; ++i) {
            RectangleD rectangleD = this.getRectPoignee(i, viewSimple);
            if (!rectangleD.contains(d, d2)) continue;
            return i;
        }
        return this.r.contains(d, d2) ? 0 : -1;
    }

    private RectangleD getRectPoignee(int n, ViewSimple viewSimple) {
        if (!this.visible) {
            return null;
        }
        double d = 20.0 / viewSimple.zoom;
        double d2 = d / 2.0;
        switch (n) {
            case 1: {
                return new RectangleD(this.r.x - d2, this.r.y - d2, d, d);
            }
            case 2: {
                return new RectangleD(this.r.x + this.r.width - d2, this.r.y - d2, d, d);
            }
            case 3: {
                return new RectangleD(this.r.x + this.r.width - d2, this.r.y + this.r.height - d2, d, d);
            }
            case 4: {
                return new RectangleD(this.r.x - d2, this.r.y + this.r.height - d2, d, d);
            }
            case 5: {
                return new RectangleD(this.r.x + d, this.r.y - d2, this.r.width - 2.0 * d, d);
            }
            case 6: {
                return new RectangleD(this.r.x + this.r.width - d2, this.r.y + d, d, this.r.height - 2.0 * d);
            }
            case 8: {
                return new RectangleD(this.r.x - d2, this.r.y + d, d, this.r.height - 2.0 * d);
            }
            case 7: {
                return new RectangleD(this.r.x + d, this.r.y + this.r.height - d2, this.r.width - 2.0 * d, d);
            }
        }
        return null;
    }

    private void drawCheckbox(Graphics graphics, int n, int n2) {
        if (!this.withFullRes) {
            return;
        }
        String string = "original resolution";
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n3 = fontMetrics.stringWidth(string) + 17;
        int n4 = fontMetrics.getHeight();
        Util.drawCartouche(graphics, n, n2, n3, n4, 0.6f, null, Color.white);
        Util.drawCheckbox(graphics, n, n2 + 3, null, null, Color.red, this.fullRes);
        graphics.setColor(Color.black);
        Font font = graphics.getFont();
        graphics.setFont(font.deriveFont(1));
        graphics.drawString(string, n + 15, n2 + n4 / 2 + 5);
        graphics.setFont(font);
        this.rectButton[6] = new RectangleD(n, n2, n3, n4);
    }

    private void drawButton(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        graphics.setColor(Aladin.BKGD);
        graphics.fillRect(n2, n3, n4, n5);
        this.rectButton[n] = new RectangleD(n2, n3, n4, n5);
        graphics.setColor(Color.white);
        graphics.drawLine(n2, n3, n2 + n4, n3);
        graphics.drawLine(n2, n3, n2, n3 + n5);
        graphics.setColor(Color.black);
        graphics.drawLine(n2, n3 + n5, n2 + n4, n3 + n5);
        graphics.drawLine(n2 + n4, n3, n2 + n4, n3 + n5);
        String string = Aladin.chaine.getString(n == 0 ? "OK" : "CLOSE");
        FontMetrics fontMetrics = graphics.getFontMetrics();
        graphics.drawString(string, n2 + n4 / 2 - fontMetrics.stringWidth(string) / 2, n3 + n5 - 3);
    }

    private void drawLabel(Graphics graphics, int n, ViewSimple viewSimple) {
        PointD pointD = viewSimple.getPositionInView(this.r.x, this.r.y);
        PointD pointD2 = viewSimple.getPositionInView(this.r.x + this.r.width, this.r.y + this.r.height);
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 15;
        boolean bl = this.edit == n;
        String string = bl ? this.stringEdit.toString() : null;
        switch (n) {
            case 3: {
                if (this.fullRes || !this.withFullRes) {
                    return;
                }
                if (string == null) {
                    double d = this.getResMult();
                    string = "res. x " + Util.myRound(d + "", 2);
                }
                n4 = graphics.getFontMetrics().stringWidth(string);
                n2 = (int)(pointD.x + (double)(n5 / 2) + 2.0);
                n3 = (int)(pointD2.y - (double)n5 - 3.0);
                break;
            }
            case 2: {
                if (viewSimple.pref instanceof PlanBG) {
                    return;
                }
                if (string == null) {
                    string = Util.myRound(this.r.x + "", 0) + "," + Util.myRound("" + ((double)((PlanImage)viewSimple.pref).naxis2 - (this.r.y + this.r.height)), 0);
                }
                n4 = graphics.getFontMetrics().stringWidth(string);
                n2 = (int)(pointD.x + (double)(n5 / 2) + 2.0);
                n3 = (int)(pointD2.y - (double)n5 - 3.0);
                break;
            }
            case 4: {
                if (string == null) {
                    string = Util.myRound("" + this.getWidth(viewSimple), 0);
                }
                n4 = graphics.getFontMetrics().stringWidth(string);
                n2 = (int)(pointD2.x + pointD.x) / 2 - n4 / 2;
                n3 = (int)(pointD.y + 3.0);
                break;
            }
            case 5: {
                if (string == null) {
                    string = Util.myRound("" + this.getHeight(viewSimple), 0);
                }
                n4 = graphics.getFontMetrics().stringWidth(string);
                n2 = (int)(pointD2.x - (double)n4 - (double)(n5 / 2) - 1.0);
                n3 = (int)(pointD2.y + pointD.y) / 2 - n5 / 2;
            }
        }
        Util.drawCartouche(graphics, n2, n3, n4, n5, bl ? 1.0f : 0.6f, bl ? Color.black : null, Color.white);
        graphics.setColor(Color.black);
        Font font = graphics.getFont();
        graphics.setFont(font.deriveFont(1));
        graphics.drawString(string, n2, n3 + n5 / 2 + 5);
        graphics.setFont(font);
        this.rectButton[n] = new RectangleD(n2, n3, n4, n5);
        if (bl) {
            boolean bl2;
            n2 = n2 + n4 - 1;
            boolean bl3 = bl2 = System.currentTimeMillis() / 500L % 2L == 0L;
            if (bl2) {
                graphics.setColor(Color.black);
                graphics.drawLine(n2, n3 + 2, n2, n3 + n5 - 2);
                graphics.drawLine(n2 + 1, n3 + 2, n2 + 1, n3 + n5 - 2);
            }
        }
    }

    public void draw(Graphics graphics, ViewSimple viewSimple) {
        if (!this.visible) {
            return;
        }
        this.withFullRes = viewSimple.pref instanceof PlanBG && viewSimple.pref.hasAvailablePixels();
        graphics.setColor(this.color);
        PointD pointD = viewSimple.getPositionInView(this.r.x, this.r.y);
        PointD pointD2 = viewSimple.getPositionInView(this.r.x + this.r.width, this.r.y + this.r.height);
        RectangleD rectangleD = new RectangleD(pointD.x, pointD.y, pointD2.x - pointD.x + 1.0, pointD2.y - pointD.y + 1.0);
        int n = viewSimple.getWidth();
        int n2 = viewSimple.getHeight();
        Util.drawArea(this.aladin, graphics, 0, 0, n, (int)rectangleD.y, this.color, 0.15f, false);
        Util.drawArea(this.aladin, graphics, 0, (int)rectangleD.y, (int)rectangleD.x, (int)rectangleD.height, this.color, 0.15f, false);
        Util.drawArea(this.aladin, graphics, (int)(rectangleD.x + rectangleD.width), (int)rectangleD.y, (int)((double)n - (rectangleD.x + rectangleD.width)), (int)rectangleD.height, this.color, 0.15f, false);
        Util.drawArea(this.aladin, graphics, 0, (int)rectangleD.y + (int)rectangleD.height, n, (int)((double)n2 - (rectangleD.y + rectangleD.height)), this.color, 0.15f, false);
        graphics.drawRect((int)pointD.x, (int)pointD.y, (int)(pointD2.x - pointD.x + 1.0), (int)(pointD2.y - pointD.y + 1.0));
        this.hasButton = false;
        boolean bl = this.plan instanceof PlanMoc;
        if (!bl && pointD2.x - pointD.x > 80.0 && pointD2.y - pointD.y > 50.0) {
            this.drawLabel(graphics, 3, viewSimple);
            this.drawLabel(graphics, 2, viewSimple);
            this.drawLabel(graphics, 4, viewSimple);
            this.drawLabel(graphics, 5, viewSimple);
        }
        int n3 = (int)((pointD2.x + pointD.x) / 2.0 - 45.0);
        int n4 = (int)(pointD2.y + (double)(pointD2.y - pointD.y > 2.0 * (double)viewSimple.getHeight() / 3.0 ? -25 : 15));
        if (this.dragX == -1.0) {
            this.drawButton(graphics, 0, n3, n4, 45, 15);
            this.drawButton(graphics, 1, n3 + 45 + 5, n4, 50, 15);
            this.hasButton = true;
        }
        if (!bl) {
            n3 = (int)(pointD.x + 10.0);
            n4 = (int)(pointD.y + (double)(pointD2.y - pointD.y > 2.0 * (double)viewSimple.getHeight() / 3.0 ? 4 : -20));
            this.drawCheckbox(graphics, n3, n4);
        }
        int n5 = 0;
        if (this.moveLabel != -1) {
            n5 = 2;
        } else {
            int n6;
            int n7 = n6 = this.dragPoignee != -1 ? this.dragPoignee : this.movePoignee;
            if (n6 != -1) {
                n5 = CURSOR[n6];
            }
        }
        if (n5 != this.oCursor) {
            this.oCursor = n5;
            viewSimple.setCursor(new Cursor(n5));
        }
    }
}

