/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.FrameBlink;
import cds.aladin.Plan;
import cds.aladin.PlanBG;
import cds.aladin.PlanBGCube;
import cds.aladin.PlanImageBlink;
import cds.aladin.Tool;
import cds.aladin.ViewSimple;
import cds.tools.Util;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;

public class CubeControl {
    protected static int NOTHING = 0;
    protected static int PAUSE = 1;
    protected static int PLAY = 2;
    protected static int REWIND = 3;
    protected static int FORWARD = 4;
    protected static int PLUS = 5;
    protected static int MOINS = 6;
    protected static int SLIDE = 7;
    protected static int EDIT = 8;
    protected static int SHOULD_REPAINT = 9;
    protected static int IN = 10;
    protected static int CURSOR = 11;
    static final int MAX_TRANSPARENCY = 11;
    protected static String[] HELP = new String[]{"Nothing", "Pause", "Play", "Previous image", "Next image", "Increase the speed", "Decrease the speed", "Change the current frame", "Edit the frame number", "", "", ""};
    private StringBuilder sedit = null;
    protected int mode = PLAY;
    protected int delay;
    protected int nbFrame;
    protected int lastFrame = -1;
    protected double transparency = -1.0;
    protected long startTime;
    private int mouseMove = NOTHING;
    private int X = -1;
    private int Y = -1;
    protected int SIZE = -1;
    private int[] rewX = new int[3];
    private int[] rewY = new int[3];
    private int[] playX1 = new int[4];
    private int[] playY1 = new int[4];
    private int[] playX2 = new int[3];
    private int[] playY2 = new int[3];
    private int[] pauseX1 = new int[4];
    private int[] pauseY1 = new int[4];
    private int[] pauseX2 = new int[4];
    private int[] pauseY2 = new int[4];
    private int[] fowX = new int[3];
    private int[] fowY = new int[3];
    private int[] plusX1 = new int[4];
    private int[] plusY1 = new int[4];
    private int[] plusX2 = new int[4];
    private int[] plusY2 = new int[4];
    private int[] slashX = new int[4];
    private int[] slashY = new int[4];
    private int[] moinsX = new int[4];
    private int[] moinsY = new int[4];
    private int[] edit = new int[2];
    private int[] posX = new int[5];
    private int[] posY = new int[5];
    private int[] sliderX = new int[4];
    private int[] sliderY = new int[4];
    private int labelX;
    private int labelY;
    private int labelPX;
    private int labelPY;
    private int[][] shapeX = new int[][]{this.pauseX1, this.pauseX2, this.playX1, this.playX2, this.rewX, this.fowX, this.plusX1, this.plusX2, this.slashX, this.moinsX, this.sliderX, this.posX};
    private int[][] shapeY = new int[][]{this.pauseY1, this.pauseY2, this.playY1, this.playY2, this.rewY, this.fowY, this.plusY1, this.plusY2, this.slashY, this.moinsY, this.sliderY, this.posY};
    private ViewSimple v;
    private Aladin aladin;
    private Plan p;
    private int step = 0;

    protected CubeControl(ViewSimple viewSimple, Plan plan, int n, boolean bl) {
        this.v = viewSimple;
        this.aladin = viewSimple.aladin;
        this.p = plan;
        this.delay = n;
        this.startTime = System.currentTimeMillis();
        if (this.delay == 0 || bl) {
            this.setMode(PAUSE);
        }
        if (this.delay < 20) {
            this.delay = FrameBlink.getDefaultDelay();
        }
    }

    protected CubeControl copy() {
        CubeControl cubeControl = new CubeControl(this.v, this.p, this.delay, this.mode == PAUSE);
        cubeControl.startTime = this.startTime;
        cubeControl.nbFrame = this.nbFrame;
        cubeControl.lastFrame = this.lastFrame;
        cubeControl.mode = this.mode;
        return cubeControl;
    }

    protected void init(int n) {
        int n2 = 0;
        this.SIZE = n;
        this.pauseX1[0] = 3 + n2;
        this.pauseX1[1] = 3 + n2;
        this.pauseX1[2] = 4 + n2;
        this.pauseX1[3] = 4 + n2;
        this.pauseY1[0] = 0;
        this.pauseY1[1] = n;
        this.pauseY1[2] = n;
        this.pauseY1[3] = 0;
        this.pauseX2[0] = 6 + n2;
        this.pauseX2[1] = 6 + n2;
        this.pauseX2[2] = 7 + n2;
        this.pauseX2[3] = 7 + n2;
        this.pauseY2[0] = 0;
        this.pauseY2[1] = n;
        this.pauseY2[2] = n;
        this.pauseY2[3] = 0;
        this.playX1[0] = n2 = n + n / 2;
        this.playX1[1] = n2;
        this.playX1[2] = 1 + n2;
        this.playX1[3] = 1 + n2;
        this.playY1[0] = 0;
        this.playY1[1] = n;
        this.playY1[2] = n;
        this.playY1[3] = 0;
        this.playX2[0] = 3 + n2;
        this.playX2[1] = 3 + n2;
        this.playX2[2] = n + n2;
        this.playY2[0] = 0;
        this.playY2[1] = n;
        this.playY2[2] = n / 2;
        this.rewX[0] = 2 + (n2 += 2 * n);
        this.rewX[1] = n + n2;
        this.rewX[2] = n + n2;
        this.rewY[0] = n / 2;
        this.rewY[1] = 0;
        this.rewY[2] = n;
        this.fowX[0] = n2 += n + n / 2;
        this.fowX[1] = n2;
        this.fowX[2] = n + n2 - 2;
        this.fowY[0] = 0;
        this.fowY[1] = n;
        this.fowY[2] = n / 2;
        this.plusX1[0] = (n2 += 2 * n) + n / 2 - 1;
        this.plusX1[1] = n2 + n / 2;
        this.plusX1[2] = n2 + n / 2;
        this.plusX1[3] = n2 + n / 2 - 1;
        this.plusY1[0] = 1;
        this.plusY1[1] = 1;
        this.plusY1[2] = n;
        this.plusY1[3] = n;
        this.plusX2[0] = n2;
        this.plusX2[1] = n2 + n - 1;
        this.plusX2[2] = n2 + n - 1;
        this.plusX2[3] = n2;
        this.plusY2[0] = n / 2;
        this.plusY2[1] = n / 2;
        this.plusY2[2] = n / 2 + 1;
        this.plusY2[3] = n / 2 + 1;
        this.slashX[0] = n2 += n;
        this.slashX[1] = n2 + 1;
        this.slashX[2] = n2 + 4;
        this.slashX[3] = n2 + 3;
        this.slashY[0] = n;
        this.slashY[1] = n;
        this.slashY[2] = 0;
        this.slashY[3] = 0;
        this.moinsX[0] = (n2 += n / 2) + 1;
        this.moinsX[1] = n2 + n - 1;
        this.moinsX[2] = n2 + n - 1;
        this.moinsX[3] = n2 + 1;
        this.moinsY[0] = n / 2;
        this.moinsY[1] = n / 2;
        this.moinsY[2] = n / 2 + 1;
        this.moinsY[3] = n / 2 + 1;
        this.labelX = n2 += n + n / 2 + 2;
        this.labelY = n + n / 2 - 2;
        this.labelPX = n2 += 3 * this.SIZE;
        this.labelPY = n + n / 2 - 2;
        int n3 = 2 * n + 2;
        this.posX[0] = this.posX[4] = -n / 2;
        this.posX[1] = this.posX[2] = n / 2;
        this.posX[3] = 0;
        this.posY[0] = this.posY[1] = n3 - 4;
        this.posY[2] = this.posY[4] = n3 + n - 3;
        this.posY[3] = n3 + n - 1;
        this.sliderX[3] = 0;
        this.sliderX[0] = 0;
        this.sliderX[1] = this.sliderX[2] = this.getWidth();
        this.sliderY[0] = this.sliderY[1] = n3;
        this.sliderY[2] = this.sliderY[3] = n3;
    }

    protected int getWidth() {
        return this.SIZE * 12 + this.SIZE / 2 + 4 * this.SIZE;
    }

    protected int getHeight() {
        return this.SIZE * 3;
    }

    private int getLogo(int n, int n2) {
        int n3 = n2 == -1 || n2 > this.Y + this.SIZE && n2 < this.Y + this.getHeight() && n >= this.X - 2 && n < this.X - 2 + this.getWidth() + 5 ? SLIDE : (n2 >= 0 && (n2 < this.Y || n2 > this.Y + this.SIZE || n < this.X || n > this.X + this.getWidth() + 5) ? NOTHING : (n < this.X + this.SIZE ? PAUSE : (n > this.X + this.SIZE + this.SIZE / 2 && n < this.X + 2 * this.SIZE + this.SIZE / 2 ? PLAY : (n > this.X + 3 * this.SIZE + this.SIZE / 2 && n < this.X + 4 * this.SIZE + this.SIZE / 2 ? REWIND : (n > this.X + 4 * this.SIZE + this.SIZE / 2 && n < this.X + 5 * this.SIZE + this.SIZE / 2 ? FORWARD : (n > this.X + 7 * this.SIZE && n < this.X + 8 * this.SIZE ? PLUS : (n > this.X + 8 * this.SIZE + this.SIZE / 2 && n < this.X + 9 * this.SIZE + this.SIZE / 2 ? MOINS : (n > this.X + 9 * this.SIZE + this.SIZE / 2 && n < this.X + this.getWidth() + 5 ? EDIT : IN))))))));
        return n3;
    }

    protected boolean isEditing() {
        return this.sedit != null;
    }

    protected void stopEditing() {
        this.sedit = null;
    }

    public boolean keyPress(KeyEvent keyEvent) {
        if (!this.isEditing()) {
            return false;
        }
        int n = keyEvent.getKeyCode();
        char c = keyEvent.getKeyChar();
        if (n == 27) {
            this.stopEditing();
            return true;
        }
        if (n == 10) {
            try {
                int n2 = Integer.parseInt(this.sedit.toString()) - 1;
                this.setFrameLevel(n2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.stopEditing();
            return true;
        }
        if (n == 8 || n == 127) {
            int n3 = this.sedit.length();
            if (n3 == 0) {
                return false;
            }
            this.sedit.deleteCharAt(n3 - 1);
            return true;
        }
        if (c >= '\u001f' && c <= '\u00ff') {
            this.sedit.append(c);
            return true;
        }
        return false;
    }

    protected int mouseMoved(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        int n3 = this.getLogo(n, n2);
        if (this.mouseMove != NOTHING && n3 == NOTHING) {
            n3 = SHOULD_REPAINT;
        }
        this.mouseMove = n3;
        if (n3 != NOTHING && n3 != SHOULD_REPAINT) {
            String string = "Blink control: " + HELP[this.mouseMove] + (this.aladin.view.isMultiView() ? " (with SHIFT for synchronizing)" : "");
            this.aladin.status.setText(string);
        }
        if (n3 != NOTHING) {
            Aladin.makeCursor(this.aladin, n3 == SHOULD_REPAINT ? 0 : 2);
        }
        Util.toolTip(this.v, n3 == IN || n3 == SHOULD_REPAINT || n3 == NOTHING ? "" : HELP[this.mouseMove]);
        return n3;
    }

    protected int mousePressed(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        boolean bl = false;
        int n3 = this.getLogo(n, n2);
        if (n3 == PLUS) {
            this.mode = PLAY;
            this.decreaseDelay();
        } else if (n3 == MOINS) {
            this.mode = PLAY;
            this.increaseDelay();
        } else if (n3 == PAUSE || n3 == PLAY) {
            this.setMode(n3);
        } else if (n3 == REWIND) {
            this.mode = PAUSE;
            this.transparency = -1.0;
            this.askStep(-1);
        } else if (n3 == FORWARD) {
            this.mode = PAUSE;
            this.transparency = -1.0;
            this.askStep(1);
        } else if (n3 == EDIT) {
            this.sedit = new StringBuilder(Util.align3(this.lastFrame + 1));
            this.setMode(PAUSE);
            bl = true;
        } else if (n3 == SLIDE) {
            this.aladin.view.setCubeFrame(this.v, this.getFrameLevel(n), mouseEvent.isShiftDown());
            this.aladin.view.repaintAll();
        }
        if (!bl) {
            this.stopEditing();
        }
        return n3;
    }

    protected void mouseDragged(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        this.aladin.view.setCubeFrame(this.v, this.getFrameLevel(n), mouseEvent.isShiftDown());
        this.aladin.view.repaintAll();
    }

    protected boolean mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        int n;
        int n2 = mouseWheelEvent.getX();
        int n3 = this.getLogo(n2, n = mouseWheelEvent.getY());
        if (n3 != SLIDE) {
            return false;
        }
        this.mode = PAUSE;
        this.transparency = -1.0;
        this.askStep(-mouseWheelEvent.getWheelRotation());
        this.aladin.calque.repaintAll();
        return true;
    }

    protected double getFrameLevel(int n) {
        double d = n - this.X;
        if (d < 0.0) {
            return 0.0;
        }
        if (d > (double)this.getWidth()) {
            return this.nbFrame - 1;
        }
        double d2 = (double)(this.nbFrame - 1) * (d / (double)this.getWidth());
        if (this.nbFrame >= 11) {
            d2 = (int)d2;
        }
        if (d2 >= (double)this.nbFrame) {
            d2 = this.nbFrame - 1;
        }
        return d2;
    }

    protected int getCurrentFrameIndex() {
        int n;
        if (this.delay == 0 || this.nbFrame <= 0) {
            return this.lastFrame;
        }
        int n2 = -1;
        int n3 = this.getNextFrameInfo();
        if (n3 == 2) {
            long l = System.currentTimeMillis();
            n = this.p instanceof PlanImageBlink ? (int)((l - this.startTime) / (long)this.delay % (long)this.nbFrame) : (l - this.startTime < (long)this.delay ? this.lastFrame : ((n2 = ((PlanBGCube)this.p).getCurrentFrameReady()) != -1 && this.lastFrame + 1 > n2 ? this.lastFrame : this.lastFrame + 1));
        } else {
            n = this.lastFrame + n3;
        }
        if (n >= this.nbFrame) {
            n = 0;
        } else if (n < 0) {
            n = this.nbFrame - 1;
        }
        this.lastFrame = n;
        return n;
    }

    protected double getTransparency() {
        return this.transparency;
    }

    protected void syncBlink(CubeControl cubeControl) {
        this.startTime = cubeControl.startTime;
        this.lastFrame = cubeControl.lastFrame;
        this.delay = cubeControl.delay;
        this.mode = cubeControl.mode;
        this.p.changeImgID();
    }

    protected void setFrameLevel(double d) {
        this.setFrameLevel(d, true);
    }

    protected void setFrameLevel(double d, boolean bl) {
        if (d >= (double)this.nbFrame || d < 0.0) {
            return;
        }
        int n = (int)d;
        this.transparency = (double)n == d || this.v.pref instanceof PlanBG ? -1.0 : d - (double)n;
        this.p.changeImgID();
        long l = System.currentTimeMillis();
        if (this.p instanceof PlanImageBlink) {
            this.startTime = l - (long)(n * this.delay);
            this.lastFrame = (int)((l - this.startTime) / (long)this.delay);
            if (this.nbFrame != 0) {
                this.lastFrame = (int)((l - this.startTime) / (long)this.delay % (long)this.nbFrame);
            }
        } else {
            this.startTime = l;
            this.lastFrame = (int)d;
        }
        this.p.setCubeFrame(d);
        if (bl) {
            this.setMode(PAUSE);
        }
    }

    protected void setTransparency(double d) {
        this.transparency = d;
    }

    protected void resume() {
        long l = System.currentTimeMillis();
        this.startTime = this.p instanceof PlanImageBlink ? l - (long)(this.lastFrame * this.delay) : l;
        this.transparency = -1.0;
    }

    protected void increaseDelay() {
        int n = FrameBlink.getMaxDelay();
        if (this.delay >= n) {
            return;
        }
        this.delay *= 2;
        if (this.delay > n) {
            this.delay = n;
        }
        this.aladin.status.setText("New blink delay: " + this.delay + "ms");
    }

    protected void decreaseDelay() {
        int n = FrameBlink.getMinDelay();
        if (this.delay <= n) {
            return;
        }
        this.delay /= 2;
        if (this.delay < n) {
            this.delay = n;
        }
        this.aladin.status.setText("New blink delay: " + this.delay + "ms");
    }

    protected void setMode(int n) {
        if (!this.p.isCube()) {
            return;
        }
        if (n == PLAY) {
            this.p.setPause(false, this.v);
            this.mode = PLAY;
            this.resume();
            this.askStep(2);
            this.aladin.view.startTimer();
        } else if (n == PAUSE) {
            this.p.setPause(true, this.v);
            this.mode = PAUSE;
            this.askStep(0);
        }
    }

    private synchronized void askStep(int n) {
        this.step = n;
    }

    protected int getNextFrameInfo() {
        int n = 2;
        if (this.mode == PAUSE) {
            n = this.step;
            this.askStep(0);
        }
        return n;
    }

    protected void draw(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        int n6;
        this.X = n;
        this.Y = n2;
        if (n3 != this.SIZE) {
            this.init(n3);
        }
        this.nbFrame = n5;
        double d = n4;
        if (this.transparency != -1.0 && this.transparency != 0.0) {
            d += this.transparency;
        }
        int n7 = n5 > 1 ? (int)((double)this.getWidth() * d / (double)(n5 - 1)) : 0;
        this.posX[0] = this.posX[4] = (n7 -= 2);
        this.posX[1] = this.posX[2] = n7 + n3 / 2;
        this.posX[3] = n7 + n3 / 4;
        graphics.setColor(this.mouseMove == EDIT ? Aladin.GREEN : Color.red);
        graphics.setFont(Aladin.SPLAIN);
        this.edit[0] = n + this.labelX;
        this.edit[1] = n2 + this.labelY;
        graphics.drawString(Util.align3(n4 + 1), this.edit[0], this.edit[1]);
        graphics.setColor(Color.red);
        if (this.transparency != -1.0) {
            graphics.drawString(Util.align2((int)((1.0 - this.transparency) * 100.0)) + "%", n + this.labelPX, n2 + this.labelPY);
        } else {
            graphics.drawString("/  " + Util.align3(n5), n + this.labelPX, n2 + this.labelPY);
        }
        if (n5 < 11) {
            for (n6 = 0; n6 < n5; ++n6) {
                int n8 = (int)(0.5 + (double)(n6 * this.getWidth()) / ((double)n5 - 1.0));
                graphics.drawLine(this.sliderX[0] + n + n8, this.sliderY[0] + n2 - 2, this.sliderX[0] + n + n8, this.sliderY[2] + n2 + 3);
            }
        }
        for (n6 = 0; n6 < this.shapeX.length; ++n6) {
            Polygon polygon = Tool.setPolygon(this.shapeX[n6], this.shapeY[n6], n, n2);
            if (this.mouseMove == PAUSE && (n6 == 0 || n6 == 1) && this.mode == PLAY || this.mouseMove == PLAY && (n6 == 2 || n6 == 3) && this.mode == PAUSE || this.mouseMove == REWIND && n6 == 4 || this.mouseMove == FORWARD && n6 == 5 || this.mouseMove == PLUS && (n6 == 6 || n6 == 7) || this.mouseMove == MOINS && n6 == 9 || this.mouseMove == SLIDE && n6 == 11) {
                graphics.setColor(Aladin.GREEN);
            } else if ((n6 == 0 || n6 == 1) && this.mode == PAUSE || (n6 == 2 || n6 == 3) && this.mode == PLAY) {
                graphics.setColor(Color.blue);
            } else {
                graphics.setColor(Color.red);
            }
            if (n6 != CURSOR || this.transparency == -1.0) {
                graphics.fillPolygon(polygon);
            }
            graphics.drawPolygon(polygon);
        }
        if (this.isEditing()) {
            this.drawEdit(graphics);
        }
    }

    private void drawEdit(Graphics graphics) {
        boolean bl;
        String string = this.sedit.toString();
        Font font = graphics.getFont();
        graphics.setFont(font.deriveFont(1));
        int n = graphics.getFontMetrics().stringWidth(string);
        int n2 = graphics.getFontMetrics().getHeight();
        int n3 = this.edit[0];
        int n4 = this.edit[1] - n2 + 2;
        Util.drawCartouche(graphics, n3, n4, n, n2, 1.0f, Color.black, Color.white);
        graphics.setColor(Color.black);
        graphics.drawString(string, n3, n4 + n2 / 2 + 5);
        graphics.setFont(font);
        n3 = n3 + n - 1;
        boolean bl2 = bl = System.currentTimeMillis() / 500L % 2L == 0L;
        if (bl) {
            graphics.setColor(Color.black);
            graphics.drawLine(n3, n4 + 2, n3, n4 + n2 - 2);
            graphics.drawLine(n3 + 1, n4 + 2, n3 + 1, n4 + n2 - 2);
        }
    }
}

