/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.MyListener;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JComponent;

public class Curseur
extends JComponent
implements MouseListener,
MouseMotionListener {
    static final int NO = -1;
    int[] niveaux;
    int currentTriangle;
    boolean flagDrag = false;
    int nbNiveaux = 0;
    Color[] couleurTriangle;
    private MyListener listener;
    final int mX = 10;
    final int mY = 0;
    final int Hp = 0;
    final int W = 276;
    final int H = 24;

    protected Curseur() {
        this.initNiveaux();
        this.initCouleurs();
        this.enableEvents(64L);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.resize(276, 24);
    }

    protected Curseur(MyListener myListener) {
        this();
        this.listener = myListener;
    }

    private void initCouleurs() {
        this.couleurTriangle = new Color[20];
        for (int i = 0; i < 20; ++i) {
            this.couleurTriangle[i] = Color.black;
        }
    }

    private void initNiveaux() {
        this.niveaux = new int[20];
        this.niveaux[0] = 100;
        this.nbNiveaux = 1;
    }

    @Override
    public Dimension preferredSize() {
        return new Dimension(276, 24);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.preferredSize();
    }

    protected void drawTriangle(Graphics graphics, int n, int n2) {
        int[] nArray = new int[4];
        int[] nArray2 = new int[4];
        nArray[0] = nArray[3] = n + 10;
        nArray[1] = nArray[0] - 7;
        nArray[2] = nArray[0] + 7;
        nArray2[3] = 4;
        nArray2[0] = 4;
        nArray2[1] = nArray2[2] = nArray2[0] + 10;
        graphics.setColor(this.couleurTriangle[n2]);
        graphics.fillPolygon(nArray, nArray2, nArray.length);
        graphics.setColor(Color.black);
        graphics.drawPolygon(nArray, nArray2, nArray.length);
        graphics.setFont(Aladin.SPLAIN);
        graphics.drawString("" + n, 10 + n - 7, 24);
    }

    @Override
    public boolean mouseMove(Event event, int n, int n2) {
        n -= 10;
        if (this.listener != null) {
            this.listener.fireStateChange(-1);
        }
        this.requestFocus();
        for (int i = 0; i < this.nbNiveaux; ++i) {
            if (n <= this.niveaux[i] - 5 || n >= this.niveaux[i] + 5) continue;
            this.currentTriangle = i;
            return true;
        }
        this.currentTriangle = -1;
        return true;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        n -= 10;
        for (int i = 0; i < this.nbNiveaux; ++i) {
            if (n <= this.niveaux[i] - 5 || n >= this.niveaux[i] + 5) continue;
            this.currentTriangle = i;
            if (this.listener != null) {
                this.listener.fireStateChange(this.niveaux[this.currentTriangle]);
            }
            return;
        }
        this.currentTriangle = -1;
        if (this.listener != null) {
            this.listener.fireStateChange(null);
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.currentTriangle == -1) {
            return;
        }
        int n = mouseEvent.getX();
        if ((n -= 10) < 0) {
            n = 0;
        } else if (n > 255) {
            n = 255;
        }
        this.niveaux[this.currentTriangle] = n;
        this.flagDrag = false;
        this.repaint();
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.currentTriangle == -1) {
            return;
        }
        int n = mouseEvent.getX();
        if ((n -= 10) < 0) {
            n = 0;
        } else if (n > 255) {
            n = 255;
        }
        this.niveaux[this.currentTriangle] = n;
        if (this.listener != null) {
            this.listener.fireStateChange(n);
        }
        this.flagDrag = true;
        this.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public void paint(Graphics graphics) {
        graphics.setColor(Color.black);
        graphics.drawLine(10, 3, 265, 3);
        graphics.drawLine(10, 0, 10, 6);
        graphics.drawLine(265, 0, 265, 6);
        for (int i = 0; i < this.nbNiveaux; ++i) {
            this.drawTriangle(graphics, this.niveaux[i], i);
        }
    }

    protected boolean addCurseur() {
        if (this.nbNiveaux >= 20) {
            return false;
        }
        this.niveaux[this.nbNiveaux] = 0;
        ++this.nbNiveaux;
        this.repaint();
        return true;
    }

    protected boolean addCurseur(int n) {
        if (this.nbNiveaux >= 20) {
            return false;
        }
        this.niveaux[this.nbNiveaux] = n;
        ++this.nbNiveaux;
        this.repaint();
        return true;
    }

    protected void reset() {
        this.nbNiveaux = 0;
        this.repaint();
    }

    @Override
    public boolean keyDown(Event event, int n) {
        if (this.currentTriangle == -1) {
            return true;
        }
        boolean bl = false;
        if (n == 1007) {
            bl = true;
            if (this.niveaux[this.currentTriangle] < 255) {
                int n2 = this.currentTriangle;
                this.niveaux[n2] = this.niveaux[n2] + 1;
            }
        } else if (n == 1006) {
            bl = true;
            if (this.niveaux[this.currentTriangle] > 0) {
                int n3 = this.currentTriangle;
                this.niveaux[n3] = this.niveaux[n3] - 1;
            }
        }
        if (bl) {
            if (this.listener != null) {
                this.listener.fireStateChange(this.niveaux[this.currentTriangle]);
            }
            this.repaint();
        }
        return true;
    }
}

