/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Coord;
import cds.aladin.Forme;
import cds.aladin.Plan;
import cds.aladin.PointD;
import cds.aladin.Position;
import cds.aladin.RectangleD;
import cds.aladin.ViewSimple;
import cds.tools.Util;
import java.awt.Graphics;

public class Ellipse
extends Forme {
    protected double angle;

    protected Ellipse(Plan plan, ViewSimple viewSimple, double d, double d2, double d3, double d4, double d5) {
        super(plan, new Position[5]);
        this.angle = d5;
        this.o[0] = new Position(plan, viewSimple, d, d2, 0.0, 0.0, 5, null);
        double d6 = Math.sqrt(d3 * d3 / 4.0 + d4 * d4 / 4.0);
        double d7 = Math.atan2(d4 / 2.0, d3 / 2.0);
        double d8 = Math.toRadians(90.0 + d5);
        double d9 = d8 + d7;
        double d10 = d + d6 * Math.sin(d9);
        double d11 = d2 + d6 * Math.cos(d9);
        this.o[1] = new Position(plan, viewSimple, d10, d11, 0.0, 0.0, 5, null);
        d9 = d8 - d7;
        d10 = d + d6 * Math.sin(d9);
        d11 = d2 + d6 * Math.cos(d9);
        this.o[2] = new Position(plan, viewSimple, d10, d11, 0.0, 0.0, 5, null);
        d9 = d8 + Math.PI - d7;
        d10 = d + d6 * Math.sin(d9);
        d11 = d2 + d6 * Math.cos(d9);
        this.o[4] = new Position(plan, viewSimple, d10, d11, 0.0, 0.0, 5, null);
        d9 = d8 + Math.PI + d7;
        d10 = d + d6 * Math.sin(d9);
        d11 = d2 + d6 * Math.cos(d9);
        this.o[3] = new Position(plan, viewSimple, d10, d11, 0.0, 0.0, 5, null);
        this.setObjet(this.o);
    }

    protected Ellipse(Plan plan, Coord coord, double d, double d2, double d3) {
        super(plan, new Position[5]);
        this.angle = d3;
        double d4 = 90.0;
        this.o[0] = new Position(plan, null, 0.0, 0.0, coord.al, coord.del, 2, null);
        Coord coord2 = this.applySphereRot(coord, d, d4 + d3);
        this.o[1] = new Position(plan, null, 0.0, 0.0, coord2.al, coord2.del, 2, null);
        coord2 = this.applySphereRot(coord, d2, d4 + d3 + 90.0);
        this.o[2] = new Position(plan, null, 0.0, 0.0, coord2.al, coord2.del, 2, null);
        coord2 = this.applySphereRot(coord, d, d4 + d3 + 180.0);
        this.o[3] = new Position(plan, null, 0.0, 0.0, coord2.al, coord2.del, 2, null);
        coord2 = this.applySphereRot(coord, d2, d4 + d3 + 270.0);
        this.o[4] = new Position(plan, null, 0.0, 0.0, coord2.al, coord2.del, 2, null);
        this.setObjet(this.o);
    }

    protected Ellipse(Plan plan, Position[] positionArray) {
        super(plan, positionArray);
    }

    @Override
    public String getObjType() {
        return "ellipse";
    }

    protected double getAngle() {
        return this.angle;
    }

    protected double getSemiMA(ViewSimple viewSimple) {
        double d = this.o[1].yv[viewSimple.n] - this.o[0].yv[viewSimple.n];
        double d2 = this.o[1].xv[viewSimple.n] - this.o[0].xv[viewSimple.n];
        return Math.sqrt(d2 * d2 + d * d);
    }

    protected double getSemiMI(ViewSimple viewSimple) {
        double d = this.o[2].yv[viewSimple.n] - this.o[0].yv[viewSimple.n];
        double d2 = this.o[2].xv[viewSimple.n] - this.o[0].xv[viewSimple.n];
        return Math.sqrt(d2 * d2 + d * d);
    }

    @Override
    protected boolean inside(ViewSimple viewSimple, double d, double d2) {
        return this.in1(viewSimple, d, d2, false);
    }

    @Override
    protected boolean in(ViewSimple viewSimple, double d, double d2) {
        return this.in1(viewSimple, d, d2, true);
    }

    private boolean in1(ViewSimple viewSimple, double d, double d2, boolean bl) {
        if (!this.isVisible()) {
            return false;
        }
        double d3 = Math.abs(d - this.o[0].xv[viewSimple.n]);
        double d4 = Math.abs(d2 - this.o[0].yv[viewSimple.n]);
        double d5 = Math.toRadians(this.angle) - Math.atan2(d4, d3);
        double d6 = Math.sqrt(d3 * d3 + d4 * d4);
        double d7 = this.getSemiMA(viewSimple);
        double d8 = this.getSemiMI(viewSimple);
        double d9 = d7 * Math.cos(d5);
        double d10 = d8 * Math.sin(d5);
        double d11 = Math.sqrt(d9 * d9 + d10 * d10);
        return bl ? Math.abs(d6 - d11) < 3.0 + 9.0 / viewSimple.getZoom() : d6 < d11;
    }

    @Override
    protected boolean inRectangle(ViewSimple viewSimple, RectangleD rectangleD) {
        return this.o[0].inRectangle(viewSimple, rectangleD);
    }

    @Override
    protected boolean inBout(ViewSimple viewSimple, double d, double d2) {
        if (!this.isVisible()) {
            return false;
        }
        for (int i = 1; i < this.o.length; ++i) {
            if (!this.o[i].in(viewSimple, d, d2)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean draw(Graphics graphics, ViewSimple viewSimple, int n, int n2) {
        if (!this.isVisible()) {
            return false;
        }
        PointD[] pointDArray = new PointD[3];
        for (int i = 0; i < pointDArray.length; ++i) {
            pointDArray[i] = viewSimple.getViewCoordDble(this.o[i].xv[viewSimple.n], this.o[i].yv[viewSimple.n]);
            if (pointDArray[i] == null) {
                return false;
            }
            pointDArray[i].x += (double)n;
            pointDArray[i].y += (double)n2;
        }
        double d = pointDArray[1].x - pointDArray[0].x;
        double d2 = pointDArray[1].y - pointDArray[0].y;
        double d3 = pointDArray[2].x - pointDArray[0].x;
        double d4 = pointDArray[2].y - pointDArray[0].y;
        double d5 = Math.sqrt(d * d + d2 * d2);
        double d6 = Math.sqrt(d3 * d3 + d4 * d4);
        double d7 = Math.toDegrees(Math.atan2(d2, d));
        graphics.setColor(this.getColor());
        Util.drawEllipse(graphics, pointDArray[0].x, pointDArray[0].y, d5, d6, d7);
        if (this.isSelected()) {
            for (int i = 1; i < this.o.length; ++i) {
                this.drawSelect(graphics, viewSimple, i);
            }
        }
        return true;
    }
}

