/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Plan;
import cds.aladin.PlanCatalog;
import cds.aladin.PlanImage;
import cds.aladin.Save;
import cds.tools.Util;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.StringTokenizer;

public class Export
implements Runnable {
    static final int DEFAULT_PORT = 4128;
    static final int MAX = 5;
    static final int SERVER = 0;
    static final int SOCKET = 1;
    private static Export export = null;
    private static boolean serverRunning;
    private ServerSocket server;
    private int port;
    private int nbExport;
    private Socket _sk;
    private int _modeRun;
    private boolean lock;
    private boolean isStopping;
    private Aladin aladin;

    protected Export(Aladin aladin) {
        this.aladin = aladin;
        this.nbExport = 0;
    }

    protected static String export(Plan plan) {
        Aladin aladin = plan.aladin;
        try {
            if (export == null) {
                if (!Aladin.confirmation(aladin.dialog, Aladin.chaine.getString("EXPORTWARNING"))) {
                    return null;
                }
                export = new Export(aladin);
            }
            export.setStopping(false);
            if (!export.isServerRunning()) {
                Export.export.port = 4128;
                int n = 0;
                while (n < 5 && !export.launchServer(Export.export.port)) {
                    ++n;
                    ++Export.export.port;
                }
                if (n == 5) {
                    return null;
                }
            }
            export.addNbExport(1);
            String string = InetAddress.getLocalHost().getHostAddress();
            String string2 = "http://" + string + ":" + Export.export.port + "/" + URLEncoder.encode(plan.label);
            Aladin cfr_ignored_0 = Export.export.aladin;
            Aladin.trace(1, "export(" + plan + ") via url=" + string2);
            return string2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    synchronized void addNbExport(int n) {
        this.nbExport += n;
    }

    synchronized void unlock() {
        this.lock = false;
    }

    private void waitLock() {
        while (!this.getLock()) {
            Util.pause(100);
        }
    }

    private synchronized boolean getLock() {
        if (this.lock) {
            return false;
        }
        this.lock = true;
        return true;
    }

    synchronized void setServerRunning(boolean bl) {
        serverRunning = bl;
    }

    synchronized boolean isServerRunning() {
        return serverRunning;
    }

    synchronized void setStopping(boolean bl) {
        this.isStopping = bl;
    }

    synchronized boolean isStopping() {
        return this.isStopping;
    }

    private boolean launchServer(int n) throws Exception {
        try {
            this.server = new ServerSocket(n);
        }
        catch (Exception exception) {
            return false;
        }
        this.waitLock();
        this.setServerRunning(true);
        this._modeRun = 0;
        new Thread((Runnable)this, "AladinHttpd").start();
        return true;
    }

    private void runServer() {
        Aladin.trace(2, "Aladin tiny httpd is starting on port " + this.port);
        this.unlock();
        try {
            while (!this.isStopping()) {
                this.server.setSoTimeout(10000);
                try {
                    Socket socket = this.server.accept();
                    this.waitLock();
                    this._sk = socket;
                    this._modeRun = 1;
                    new Thread((Runnable)this, "AladinHttpdBis").start();
                }
                catch (Exception exception) {}
            }
            this.server.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Aladin.trace(2, "Aladin tiny httpd is stopped !");
        this.setServerRunning(false);
        this.server = null;
    }

    @Override
    public void run() {
        switch (this._modeRun) {
            case 0: {
                this.runServer();
                break;
            }
            case 1: {
                this.runSocket();
            }
        }
    }

    public void runSocket() {
        Socket socket = this._sk;
        this.unlock();
        try {
            String string;
            InputStream inputStream = socket.getInputStream();
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(socket.getOutputStream());
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            String string2 = dataInputStream.readLine();
            while ((string = dataInputStream.readLine()) != null && string.length() > 0) {
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string2);
            if (stringTokenizer.nextToken().equals("GET")) {
                String string3 = URLDecoder.decode(stringTokenizer.nextToken().substring(1));
                Aladin.trace(2, "Sending plane [" + string3 + "] to " + socket.getInetAddress().getHostAddress() + "...");
                this.send(bufferedOutputStream, string3);
            }
            bufferedOutputStream.flush();
            inputStream.close();
            bufferedOutputStream.close();
            socket.close();
            this.addNbExport(-1);
            if (this.nbExport <= 0) {
                this.setStopping(true);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void sendString(OutputStream outputStream, String string) throws Exception {
        char[] cArray = string.toCharArray();
        byte[] byArray = new byte[cArray.length];
        for (int i = 0; i < cArray.length; ++i) {
            byArray[i] = (byte)cArray[i];
        }
        outputStream.write(byArray);
    }

    private void sendError(OutputStream outputStream, String string) throws Exception {
        this.sendString(outputStream, "HTTP/1.0 404 OK\r\nContent-type: text/plain\r\n\r\n" + string);
    }

    private void send(OutputStream outputStream, String string) throws Exception {
        Plan plan = this.aladin.command.getNumber(string);
        if (plan == null) {
            this.sendError(outputStream, "Plane [" + string + "] no longer existing");
            return;
        }
        if (plan.isSimpleImage() && plan.flagOk) {
            this.sendString(outputStream, "HTTP/1.0 200 OK\r\nContent-type: image/x-fits\r\n\r\n");
            if (this.aladin.save == null) {
                this.aladin.save = new Save(this.aladin);
            }
            this.aladin.save.saveImageFITS(outputStream, (PlanImage)plan);
        } else if (plan.isSimpleCatalog() && plan.flagOk) {
            this.sendString(outputStream, "HTTP/1.0 200 OK\r\nContent-type: text/xml\r\n\r\n");
            this.aladin.writePlaneInVOTable((PlanCatalog)plan, outputStream, false);
        } else {
            this.sendError(outputStream, "Plan [" + string + "] is not a valid Aladin plane");
        }
    }
}

