/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.FilterProperties;
import cds.aladin.MyLabel;
import cds.aladin.PlanFilter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Event;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class FilterHelp
extends JFrame
implements ActionListener {
    private static FilterHelp singleton = null;
    private static final String COPY_DEF = "Copy/Paste this definition";
    private static final String TITRE = "Examples of filters";
    private static final Color BKGD = Color.white;
    private static final Font TITLE_FONT = Aladin.BOLD;
    private static final Color TITLE_COLOR = new Color(127, 159, 191);
    private static final Font COMMENT_FONT = Aladin.PLAIN;
    private static final Color COMMENT_COLOR = new Color(63, 127, 95);
    private static final Font DEF_FONT = Aladin.COURIER;
    private static final Color DEF_COLOR = Color.black;
    private static final Color CONDITION_COLOR = new Color(165, 75, 135);

    private FilterHelp() {
        super(TITRE);
        Aladin.setIcon(this);
        this.setSize(550, (int)((double)Aladin.SCREENSIZE.height * 0.7));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(10, 10));
        this.getContentPane().add(jPanel);
        jPanel.add((Component)this.suite(), "Center");
        this.setLocation(350, 200);
    }

    private JScrollPane suite() {
        JPanel jPanel = new JPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        String[] stringArray = PlanFilter.PREDEFFILTERS;
        String[] stringArray2 = PlanFilter.PREDEFLABELS;
        String string = null;
        for (int i = 0; i < stringArray2.length; ++i) {
            String string2 = stringArray2[i];
            this.writeTitle(jPanel, gridBagLayout, gridBagConstraints, string2);
            StringBuffer stringBuffer = new StringBuffer();
            StringTokenizer stringTokenizer = new StringTokenizer(stringArray[i], "\n");
            stringTokenizer.nextToken();
            while (stringTokenizer.hasMoreTokens() && (string = stringTokenizer.nextToken().trim()).startsWith("#")) {
                stringBuffer.append(string.substring(1).trim());
                if (!stringTokenizer.hasMoreElements()) continue;
                stringBuffer.append('\n');
            }
            this.writeComment(jPanel, gridBagLayout, gridBagConstraints, stringBuffer.toString());
            StringBuffer stringBuffer2 = new StringBuffer();
            if (string.length() != 0) {
                stringBuffer2.append(string + "\n");
            }
            while (stringTokenizer.hasMoreTokens() && !(string = stringTokenizer.nextToken().trim()).startsWith("#")) {
                if (string.length() == 0) continue;
                stringBuffer2.append(string);
                if (!stringTokenizer.hasMoreElements()) continue;
                stringBuffer2.append('\n');
            }
            this.writeDefinition(jPanel, gridBagLayout, gridBagConstraints, stringBuffer2.toString());
            JButton jButton = new JButton(COPY_DEF);
            jButton.addActionListener(this);
            jButton.setActionCommand(i + "");
            Insets insets = gridBagConstraints.insets;
            gridBagConstraints.insets = new Insets(10, insets.left, insets.right, 0);
            gridBagConstraints.anchor = 10;
            gridBagLayout.setConstraints(jButton, gridBagConstraints);
            jPanel.add(jButton);
            gridBagConstraints.insets = insets;
        }
        JScrollPane jScrollPane = new JScrollPane(jPanel);
        jScrollPane.setOpaque(false);
        jScrollPane.getVerticalScrollBar().setUnitIncrement(50);
        return jScrollPane;
    }

    private void writeTitle(JPanel jPanel, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, String string) {
        JLabel jLabel = new JLabel(string);
        jLabel.setFont(TITLE_FONT);
        jLabel.setForeground(TITLE_COLOR);
        Insets insets = gridBagConstraints.insets;
        gridBagConstraints.insets = new Insets(10, insets.left, 10, insets.right);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        gridBagConstraints.insets = insets;
    }

    private void writeComment(JPanel jPanel, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, String string) {
        MyLabel myLabel = new MyLabel(string, 0);
        myLabel.setFont(COMMENT_FONT);
        myLabel.setForeground(COMMENT_COLOR);
        Insets insets = gridBagConstraints.insets;
        gridBagConstraints.insets = new Insets(0, 45, 10, 0);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(myLabel, gridBagConstraints);
        jPanel.add(myLabel);
        gridBagConstraints.insets = insets;
    }

    private void writeDefinition(JPanel jPanel, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, String string) {
        Insets insets = gridBagConstraints.insets;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 15, 0, 0);
        gridBagConstraints.gridwidth = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        while (stringTokenizer.hasMoreTokens()) {
            JComponent jComponent;
            String string2 = stringTokenizer.nextToken();
            int n = string2.indexOf(" {");
            if (string2.trim().endsWith("||")) {
                n = string2.length();
            }
            if (n > 0) {
                jComponent = new JPanel(new FlowLayout(0, 0, 0));
                String string3 = string2.substring(0, n);
                String string4 = string2.substring(n);
                JLabel jLabel = new JLabel(string3);
                jLabel.setFont(DEF_FONT);
                jLabel.setForeground(CONDITION_COLOR);
                jComponent.add(jLabel);
                JLabel jLabel2 = new JLabel(string4);
                jLabel2.setFont(DEF_FONT);
                jLabel2.setForeground(DEF_COLOR);
                jComponent.add(jLabel2);
                gridBagLayout.setConstraints(jComponent, gridBagConstraints);
                jPanel.add(jComponent);
                continue;
            }
            jComponent = new JLabel(string2);
            jComponent.setFont(DEF_FONT);
            jComponent.setForeground(DEF_COLOR);
            gridBagConstraints.gridwidth = 0;
            gridBagLayout.setConstraints(jComponent, gridBagConstraints);
            jPanel.add(jComponent);
        }
        gridBagConstraints.insets = insets;
    }

    private void makeAdd(Component component, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, int n, JPanel jPanel) {
        gridBagConstraints.gridwidth = n;
        gridBagLayout.setConstraints(component, gridBagConstraints);
        jPanel.add(component);
    }

    protected static FilterHelp getInstance() {
        if (singleton == null) {
            singleton = new FilterHelp();
        }
        return singleton;
    }

    @Override
    public void toFront() {
        this.move(350, 200);
        super.toFront();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (!(object instanceof JButton)) {
            return;
        }
        int n = Integer.parseInt(actionEvent.getActionCommand());
        final FilterProperties filterProperties = FilterProperties.getCurWindow();
        if (filterProperties != null && filterProperties.isShowing()) {
            filterProperties.filterDef.setText(PlanFilter.PREDEFFILTERS[n]);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                filterProperties.filterDefSp.getVerticalScrollBar().setValue(0);
            }
        });
    }

    @Override
    public boolean handleEvent(Event event) {
        if (event.id == 201) {
            this.hide();
        }
        return super.handleEvent(event);
    }
}

