/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Action;
import cds.aladin.Aladin;
import cds.aladin.CanvasColorMap;
import cds.aladin.FilterHelp;
import cds.aladin.FrameColumnCalculator;
import cds.aladin.MetaDataTree;
import cds.aladin.MyLabel;
import cds.aladin.Obj;
import cds.aladin.Plan;
import cds.aladin.PlanFilter;
import cds.aladin.Properties;
import cds.aladin.Source;
import cds.tools.Util;
import cds.tools.parser.Parser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.text.DefaultEditorKit;

public final class FilterProperties
extends Properties
implements MouseListener,
ActionListener {
    protected String SELECT;
    protected String EXPORT;
    protected String UCD;
    protected String FILTER_EXAMPLES;
    protected String FILTERMANUAL;
    protected String SAVEFILTER;
    protected String LOADFILTER;
    protected String PICKCOLUMN;
    protected String PICKUCD;
    protected String SHAPEFUNC;
    protected String COLORFUNC;
    protected String IOERR;
    protected String CAVEAT;
    protected String MATHS;
    protected String OPEN_COLUMNS;
    protected String LABEL;
    protected String CHOOSE;
    protected String CHOOSE1;
    protected String PREDEF;
    protected String YOUROWN;
    protected String PICK;
    protected String COL;
    protected String ACTION;
    protected String UNIT;
    protected String CPLANE;
    protected String FREQUCD;
    protected String CATUCD;
    protected String SHAPEFCT;
    protected String COLORFCT;
    protected String CAVEATMSG;
    protected String FILTER_EXPLAIN;
    protected String RAINBOWCM;
    protected static String BEGINNER;
    protected static String ADVANCED;
    JTabbedPane modeTabbedPane;
    private static String currentMode;
    static boolean useUcdExplain;
    private static final String[] UCDBASE;
    private static final String[] UNITBASE;
    private static String[] UNITEXPLAIN;
    FileDialog fd = null;
    protected static String[] BEGINNER_FILTER;
    protected static final String[] BEGINNER_FILTERDEF;
    private ButtonGroup beginnerCbg;
    PlanFilter pf;
    String oscript;
    String olabel;
    private JPanel panel;
    private int hcmemo = 0;
    private boolean computeCol = true;
    private static boolean pickUCDMode;
    private static boolean pickColumnMode;
    private static FilterProperties curWindow;
    JButton applyBtn;
    JButton closeBtn;
    JButton showRainbowBtn;
    JTextField label;
    JTextArea filterDef;
    JScrollPane filterDefSp;
    private String saveDef;
    private String saveName;
    private JComboBox predefFilters;
    private JPopupMenu columnMenu;
    private JPopupMenu ucdMenu;
    private JPopupMenu actionMenu;
    private JPopupMenu unitMenu;
    private JMenu currentUcdMenu;
    private static ColumnHelperFrame columnHelper;
    private static MathHelperFrame mathHelper;
    private static PickupHelperFrame pickupHelper;
    private int oldIndex = 0;
    private static final Insets BUTTON_INSETS;
    private static FilterProperties pickupFP;
    private static String[] ucds;
    private boolean firstTime = true;

    @Override
    protected void createChaine() {
        super.createChaine();
        this.SELECT = Aladin.chaine.getString("FTSELECT");
        this.EXPORT = Aladin.chaine.getString("FTEXPORT");
        this.UCD = Aladin.chaine.getString("FTUCD");
        this.FILTER_EXAMPLES = Aladin.chaine.getString("FTFILTER_EXAMPLES");
        this.FILTERMANUAL = Aladin.chaine.getString("FTFILTERMANUAL");
        this.SAVEFILTER = Aladin.chaine.getString("FTSAVEFILTER");
        this.LOADFILTER = Aladin.chaine.getString("FTLOADFILTER");
        this.PICKCOLUMN = Aladin.chaine.getString("FTPICKCOLUMN");
        this.PICKUCD = Aladin.chaine.getString("FTPICKUCD");
        this.SHAPEFUNC = Aladin.chaine.getString("FTSHAPEFUNC");
        this.COLORFUNC = Aladin.chaine.getString("FTCOLORFUNC");
        this.IOERR = Aladin.chaine.getString("FTIOERR");
        this.CAVEAT = Aladin.chaine.getString("FTCAVEAT");
        this.MATHS = Aladin.chaine.getString("FTMATHS");
        this.OPEN_COLUMNS = Aladin.chaine.getString("FTOPEN_COLUMNS");
        this.LABEL = Aladin.chaine.getString("FTLABEL");
        this.CHOOSE = Aladin.chaine.getString("FTCHOOSE");
        this.CHOOSE1 = Aladin.chaine.getString("FTCHOOSE1");
        this.PREDEF = Aladin.chaine.getString("FTPREDEF");
        this.YOUROWN = Aladin.chaine.getString("FTYOUROWN");
        this.PICK = Aladin.chaine.getString("FTPICK");
        this.COL = Aladin.chaine.getString("FTCOL");
        this.ACTION = Aladin.chaine.getString("FTACTION");
        this.UNIT = Aladin.chaine.getString("FTUNIT");
        this.CPLANE = Aladin.chaine.getString("FTCPLANE");
        this.FREQUCD = Aladin.chaine.getString("FTFREQUCD");
        this.CATUCD = Aladin.chaine.getString("FTCATUCD");
        this.SHAPEFCT = Aladin.chaine.getString("FTSHAPEFCT");
        this.COLORFCT = Aladin.chaine.getString("FTCOLORFCT");
        this.CAVEATMSG = Aladin.chaine.getString("FTCAVEATMSG");
        this.FILTER_EXPLAIN = Aladin.chaine.getString("FTFILTER_EXPLAIN");
        this.RAINBOWCM = Aladin.chaine.getString("FTRAINBOWCM");
        String[] stringArray = new String[10];
        stringArray[0] = Aladin.chaine.getString("FTMIN");
        stringArray[1] = Aladin.chaine.getString("FTSEC");
        stringArray[2] = Aladin.chaine.getString("FTDEG");
        stringArray[3] = Aladin.chaine.getString("FTEV");
        stringArray[4] = Aladin.chaine.getString("FTJY");
        stringArray[5] = Aladin.chaine.getString("FTMAG");
        stringArray[6] = Aladin.chaine.getString("FTPSC");
        stringArray[7] = Aladin.chaine.getString("FTRAD");
        stringArray[8] = Aladin.chaine.getString("FTYEAR");
        stringArray[9] = Aladin.chaine.getString("FTWATT");
        UNITEXPLAIN = stringArray;
    }

    protected FilterProperties(Plan plan) {
        super(plan);
        this.pf = (PlanFilter)plan;
        FilterProperties.majFilterProp(true, false);
        this.aladin.lastFilterCreated = this;
    }

    @Override
    void showProp() {
        curWindow = this;
        if (this.panel != null) {
            if (!this.oscript.equals(this.pf.script)) {
                this.filterDef.setText(this.pf.script);
            }
            if (!this.olabel.equals(this.pf.label)) {
                this.label.setText(this.pf.label);
            }
        }
        this.oscript = this.pf.script;
        this.olabel = this.pf.label;
        if (this.hcmemo == this.pf.hashCode()) {
            if (this.isShowing()) {
                return;
            }
            this.setVisible(true);
            return;
        }
        this.hcmemo = this.pf.hashCode();
        this.saveDef = "";
        this.saveName = "";
        if (this.panel != null) {
            this.getContentPane().remove(this.panel);
        }
        this.panel = new JPanel();
        this.panel.setLayout(new BorderLayout(5, 5));
        this.propPanel = this.getPanelProperties();
        Aladin.makeAdd(this.panel, this.propPanel, "Center");
        Aladin.makeAdd(this.panel, this.getPanelValid(), "South");
        this.setTitre(this.LABEL + " \"" + this.pf.label + "\"");
        Aladin.makeAdd(this.getContentPane(), this.panel, "Center");
        this.pack();
        this.setVisible(true);
    }

    @Override
    protected JPanel getPanelValid() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1));
        jPanel.setFont(Aladin.LBOLD);
        this.applyBtn = new JButton(this.APPLY);
        this.applyBtn.addActionListener(this);
        jPanel.add(this.applyBtn);
        this.closeBtn = new JButton(this.CLOSE);
        this.closeBtn.setFont(Aladin.PLAIN);
        this.closeBtn.addActionListener(this);
        jPanel.add(this.closeBtn);
        return jPanel;
    }

    @Override
    protected JPanel getPanelProperties() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 3, 5);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(gridBagLayout);
        JLabel jLabel = new JLabel(this.FILTER_EXPLAIN, 0);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        this.label = new JTextField(this.pf.label, 15);
        FilterProperties.addCouple(jPanel, this.LABEL, this.label, gridBagLayout, gridBagConstraints);
        if (this.pf.script.length() == 0) {
            this.pf.active = true;
        }
        currentMode = this.pf.script != null && this.pf.script.length() > 0 || Aladin.ROBOTSUPPORT && this.aladin.command.robotMode ? ADVANCED : BEGINNER;
        this.modeTabbedPane = new JTabbedPane();
        this.modeTabbedPane.addTab(BEGINNER, this.getBeginnerPanel());
        this.modeTabbedPane.addTab(ADVANCED, this.getAdvancedPanel());
        this.modeTabbedPane.setSelectedIndex(currentMode == BEGINNER ? 0 : 1);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.fill = 1;
        gridBagLayout.setConstraints(this.modeTabbedPane, gridBagConstraints);
        jPanel.add(this.modeTabbedPane);
        return jPanel;
    }

    protected static String[] getBeginnerFilters() {
        String[] stringArray = new String[BEGINNER_FILTER.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = Util.slash(BEGINNER_FILTER[i]);
        }
        return stringArray;
    }

    private JPanel getBeginnerPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagConstraints.fill = 0;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(gridBagLayout);
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(null, this.CHOOSE, 4, 2, Aladin.BOLD), BorderFactory.createEmptyBorder(5, 5, 5, 5))));
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        this.beginnerCbg = new ButtonGroup();
        for (int i = 0; i < BEGINNER_FILTER.length; ++i) {
            String string = " " + BEGINNER_FILTER[i];
            JRadioButton jRadioButton = new JRadioButton(string, false);
            this.beginnerCbg.add(jRadioButton);
            jRadioButton.addActionListener(this);
            gridBagLayout.setConstraints(jRadioButton, gridBagConstraints);
            jPanel.add(jRadioButton);
        }
        gridBagConstraints.insets = new Insets(30, 0, 0, 0);
        gridBagConstraints.anchor = 10;
        JButton jButton = new JButton(this.CAVEAT);
        jButton.addActionListener(this);
        jButton.setFont(Aladin.BOLD);
        gridBagLayout.setConstraints(jButton, gridBagConstraints);
        jPanel.add(jButton);
        return jPanel;
    }

    public static void addCouple(JPanel jPanel, Object object, Component component, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints) {
        Component component2;
        if (object instanceof String) {
            JLabel jLabel = new JLabel((String)object);
            jLabel.setFont(jLabel.getFont().deriveFont(2));
            component2 = jLabel;
        } else {
            component2 = (Component)object;
        }
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(component2, gridBagConstraints);
        jPanel.add(component2);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(component, gridBagConstraints);
        jPanel.add(component);
    }

    private JPanel getAdvancedPanel() {
        JComponent jComponent;
        Serializable serializable;
        Serializable serializable2;
        JComponent jComponent2;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 3));
        this.majPredefFilters();
        JPanel jPanel2 = new JPanel(new FlowLayout(3, 10, 5));
        jPanel2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(null, this.CHOOSE1, 4, 2, Aladin.BOLD), BorderFactory.createEmptyBorder(5, 5, 5, 5))));
        JLabel jLabel = new JLabel(this.PREDEF);
        jPanel2.add(jLabel);
        jLabel.setFont(jLabel.getFont().deriveFont(2));
        jPanel2.add(this.predefFilters);
        jPanel.add(jPanel2);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagConstraints.fill = 1;
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(gridBagLayout);
        jPanel3.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(null, this.YOUROWN, 4, 2, Aladin.BOLD), BorderFactory.createEmptyBorder(5, 5, 5, 5))));
        jPanel.add(jPanel3);
        JLabel jLabel2 = new JLabel("eg: ${Bmag}<10 {draw red square}");
        jLabel2.setFont(Aladin.ITALIC);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(jLabel2, gridBagConstraints);
        jPanel3.add(jLabel2);
        JLabel jLabel3 = new JLabel(this.PICK);
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        jLabel3.setFont(Aladin.BOLD);
        gridBagLayout.setConstraints(jLabel3, gridBagConstraints);
        jPanel3.add(jLabel3);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        JPanel jPanel4 = new JPanel(new FlowLayout(1, 8, 5));
        if (this.columnMenu == null) {
            this.createPopup();
        }
        Insets insets = new Insets(2, 5, 2, 5);
        ImageIcon imageIcon = new ImageIcon(this.aladin.getImagette("arrow.gif"));
        final JButton jButton = new JButton(this.COL);
        jPanel4.add(jButton);
        jButton.setIcon(imageIcon);
        jButton.setHorizontalTextPosition(2);
        jButton.setMargin(insets);
        jButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                FilterProperties.this.columnMenu.show(jButton, mouseEvent.getX(), mouseEvent.getY());
            }
        });
        final JButton jButton2 = new JButton("UCDs");
        jPanel4.add(jButton2);
        jButton2.setIcon(imageIcon);
        jButton2.setHorizontalTextPosition(2);
        jButton2.setMargin(insets);
        jButton2.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                FilterProperties.this.ucdMenu.show(jButton2, mouseEvent.getX(), mouseEvent.getY());
            }
        });
        final JButton jButton3 = new JButton(this.ACTION);
        jPanel4.add(jButton3);
        jButton3.setIcon(imageIcon);
        jButton3.setHorizontalTextPosition(2);
        jButton3.setMargin(insets);
        jButton3.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                FilterProperties.this.actionMenu.show(jButton3, mouseEvent.getX(), mouseEvent.getY());
            }
        });
        JButton jButton4 = new JButton(this.MATHS);
        jPanel4.add(jButton4);
        jButton4.addActionListener(this);
        jButton4.setMargin(insets);
        jButton4.setIcon(null);
        final JButton jButton5 = new JButton(this.UNIT);
        jPanel4.add(jButton5);
        jButton5.setIcon(imageIcon);
        jButton5.setHorizontalTextPosition(2);
        jButton5.setMargin(insets);
        jButton5.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                FilterProperties.this.unitMenu.show(jButton5, mouseEvent.getX(), mouseEvent.getY());
            }
        });
        gridBagConstraints.gridx = 1;
        gridBagLayout.setConstraints(jPanel4, gridBagConstraints);
        jPanel3.add(jPanel4);
        gridBagConstraints.gridx = 0;
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BorderLayout(0, 0));
        JPanel jPanel6 = new JPanel();
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        jPanel6.setLayout(gridBagLayout2);
        JButton jButton6 = this.createButton(this.FILTERMANUAL);
        jButton6.setFont(Aladin.LBOLD);
        JButton jButton7 = this.createButton(this.FILTER_EXAMPLES);
        jButton7.setFont(Aladin.LBOLD);
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.insets = new Insets(5, 0, 5, 3);
        gridBagConstraints2.fill = 2;
        gridBagLayout2.setConstraints(jButton6, gridBagConstraints2);
        jPanel6.add(jButton6);
        gridBagLayout2.setConstraints(jButton7, gridBagConstraints2);
        jPanel6.add(jButton7);
        jPanel5.add((Component)jPanel6, "West");
        this.filterDef = new JTextArea(9, 50);
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem(new DefaultEditorKit.CutAction());
        jMenuItem.setText("Cut");
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(new DefaultEditorKit.CopyAction());
        jMenuItem.setText("Copy");
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(new DefaultEditorKit.PasteAction());
        jMenuItem.setText("Paste");
        jPopupMenu.add(jMenuItem);
        this.filterDef.setLineWrap(true);
        this.filterDef.addMouseListener(this);
        this.filterDef.setFont(Aladin.COURIER);
        this.filterDef.setText(this.pf.script);
        this.filterDefSp = new JScrollPane(this.filterDef, 22, 31);
        jPanel5.add((Component)this.filterDefSp, "Center");
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        gridBagLayout.setConstraints(jPanel5, gridBagConstraints);
        jPanel3.add(jPanel5);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        if (Aladin.hasNoResctriction()) {
            jComponent2 = this.createButton(this.SAVEFILTER);
            jComponent2.setFont(Aladin.PLAIN);
            serializable2 = this.createButton(this.LOADFILTER);
            serializable2.setFont(Aladin.PLAIN);
            serializable = new JPanel();
            ((Container)serializable).setLayout(new FlowLayout(1));
            ((Container)serializable).add(jComponent2);
            ((Container)serializable).add((Component)serializable2);
            jComponent = new JLabel("");
            gridBagConstraints.gridwidth = -1;
            gridBagLayout.setConstraints(jComponent, gridBagConstraints);
            jPanel3.add(jComponent);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridwidth = 0;
            gridBagLayout.setConstraints((Component)serializable, gridBagConstraints);
            jPanel3.add((Component)serializable);
        }
        if (this.computeCol) {
            this.updateUCDAndColumn();
        }
        gridBagConstraints.gridx = 0;
        jComponent2 = new JPanel();
        serializable2 = new GridBagConstraints();
        serializable = new GridBagLayout();
        ((GridBagConstraints)serializable2).fill = 1;
        ((GridBagConstraints)serializable2).insets = new Insets(1, 3, 1, 3);
        jComponent2.setLayout((LayoutManager)((Object)serializable));
        jComponent2.setBorder(BorderFactory.createEmptyBorder(5, 5, 2, 5));
        jComponent = new JButton(this.EXPORT);
        ((AbstractButton)jComponent).addActionListener(this);
        JLabel jLabel4 = new JLabel(this.CPLANE);
        ((GridBagConstraints)serializable2).gridwidth = -1;
        ((GridBagConstraints)serializable2).weightx = 0.0;
        ((GridBagLayout)serializable).setConstraints(jComponent, (GridBagConstraints)serializable2);
        jComponent2.add(jComponent);
        ((GridBagConstraints)serializable2).gridwidth = 0;
        ((GridBagConstraints)serializable2).weightx = 1.0;
        ((GridBagLayout)serializable).setConstraints(jLabel4, (GridBagConstraints)serializable2);
        jComponent2.add(jLabel4);
        ((GridBagConstraints)serializable2).gridwidth = 0;
        ((GridBagConstraints)serializable2).anchor = 17;
        ((GridBagConstraints)serializable2).weightx = 0.0;
        ((GridBagConstraints)serializable2).fill = 0;
        this.showRainbowBtn = new JButton(this.RAINBOWCM);
        this.showRainbowBtn.addActionListener(this);
        this.showRainbowBtn.setEnabled(this.pf.getUCDFilter().hasRainbowFunction());
        ((GridBagLayout)serializable).setConstraints(this.showRainbowBtn, (GridBagConstraints)serializable2);
        jComponent2.add(this.showRainbowBtn);
        jPanel.add(jComponent2);
        return jPanel;
    }

    private JButton createButton(String string) {
        JButton jButton = new JButton(string);
        jButton.setMargin(BUTTON_INSETS);
        jButton.addActionListener(this);
        return jButton;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        curWindow = this;
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    private void createPopup() {
        int n;
        JMenuItem jMenuItem;
        Object object;
        this.columnMenu = new JPopupMenu();
        this.ucdMenu = new JPopupMenu();
        this.actionMenu = new JPopupMenu();
        this.unitMenu = new JPopupMenu();
        JMenu jMenu = new JMenu(this.FREQUCD);
        for (int i = 0; i < UCDBASE.length; ++i) {
            String string;
            String string2 = UCDBASE[i];
            if (useUcdExplain && ((String)(object = FilterProperties.getUCDExplain(string = string2.endsWith("*") ? string2.substring(0, string2.length() - 1) : string2, true))).length() > 0) {
                string2 = string2 + " - " + (String)object;
            }
            jMenuItem = new JMenuItem(string2);
            jMenuItem.addActionListener(this);
            jMenuItem.setActionCommand("$[" + UCDBASE[i] + "]");
            jMenu.add(jMenuItem);
        }
        this.currentUcdMenu = new JMenu(this.CATUCD);
        this.ucdMenu.add(jMenu);
        this.ucdMenu.add(this.currentUcdMenu);
        this.ucdMenu.addSeparator();
        jMenuItem = new JMenuItem(this.PICKUCD);
        this.ucdMenu.add(jMenuItem);
        jMenuItem.addActionListener(this);
        JMenu jMenu2 = new JMenu(this.SHAPEFCT);
        object = new JMenu(this.COLORFCT);
        jMenuItem = new JMenuItem("ellipse".toUpperCase() + "(semi-maj. axis, semi-minor axis, pos. angle)");
        jMenuItem.setActionCommand("draw ellipse(,,)");
        jMenuItem.addActionListener(this);
        jMenu2.add(jMenuItem);
        jMenuItem = new JMenuItem("fillellipse".toUpperCase() + "(semi-maj. axis, semi-minor axis, pos. angle)");
        jMenuItem.setActionCommand("draw fillellipse(,,)");
        jMenuItem.addActionListener(this);
        jMenu2.add(jMenuItem);
        jMenuItem = new JMenuItem("circle".toUpperCase() + "(parameter)");
        jMenuItem.setActionCommand("draw circle()");
        jMenuItem.addActionListener(this);
        jMenu2.add(jMenuItem);
        jMenuItem = new JMenuItem("fillcircle".toUpperCase() + "(parameter)");
        jMenuItem.setActionCommand("draw fillcircle()");
        jMenuItem.addActionListener(this);
        jMenu2.add(jMenuItem);
        jMenuItem = new JMenuItem("fixedcircle".toUpperCase() + "(parameter)");
        jMenuItem.setActionCommand("draw fixedcircle()");
        jMenuItem.addActionListener(this);
        jMenu2.add(jMenuItem);
        jMenuItem = new JMenuItem("pm".toUpperCase() + "(proper motion RA, proper motion Dec)");
        jMenuItem.setActionCommand("draw pm(,)");
        jMenuItem.addActionListener(this);
        jMenu2.add(jMenuItem);
        jMenuItem = new JMenuItem("rectangle".toUpperCase() + "(width, height, pos. angle)");
        jMenuItem.setActionCommand("draw rectangle(,,)");
        jMenuItem.addActionListener(this);
        jMenu2.add(jMenuItem);
        jMenuItem = new JMenuItem("line".toUpperCase() + "(ra1, dec1, ra2, dec2)");
        jMenuItem.setActionCommand("draw line(,,,)");
        jMenuItem.addActionListener(this);
        jMenu2.add(jMenuItem);
        jMenu2.addSeparator();
        for (n = 0; n < Action.NOPARAMSHAPE.length; ++n) {
            jMenuItem = new JMenuItem(Action.NOPARAMSHAPE[n]);
            jMenuItem.addActionListener(this);
            jMenuItem.setActionCommand("draw " + Action.NOPARAMSHAPE[n]);
            jMenu2.add(jMenuItem);
        }
        jMenuItem = new JMenuItem("rgb".toUpperCase() + "(red param., green param., blue param.)");
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("draw rgb(,,)");
        ((JMenu)object).add(jMenuItem);
        jMenuItem = new JMenuItem("rainbow".toUpperCase() + "(parameter)");
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("draw rainbow()");
        ((JMenu)object).add(jMenuItem);
        jMenuItem = new JMenuItem("saturation".toUpperCase() + "(parameter)");
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("draw saturation()");
        ((JMenu)object).add(jMenuItem);
        ((JMenu)object).addSeparator();
        for (n = 0; n < Action.COLORNAME.length; ++n) {
            jMenuItem = new JMenuItem(Action.COLORNAME[n]);
            jMenuItem.addActionListener(this);
            jMenuItem.setActionCommand("draw " + Action.COLORNAME[n]);
            ((JMenu)object).add(jMenuItem);
        }
        this.actionMenu.add(jMenu2);
        this.actionMenu.add((JMenuItem)object);
        for (n = 0; n < UNITBASE.length; ++n) {
            jMenuItem = new JMenuItem(UNITBASE[n] + " - " + UNITEXPLAIN[n]);
            jMenuItem.addActionListener(this);
            jMenuItem.setActionCommand(UNITBASE[n]);
            this.unitMenu.add(jMenuItem);
        }
    }

    private void majPredefFilters() {
        if (this.predefFilters == null) {
            this.predefFilters = new JComboBox();
            this.predefFilters.addActionListener(this);
        }
        this.createPredefFilters();
        this.predefFilters.setSelectedIndex(0);
    }

    private void createPredefFilters() {
        int n;
        this.predefFilters.removeAllItems();
        this.predefFilters.addItem("----");
        for (n = 0; n < PlanFilter.PREDEFLABELS.length; ++n) {
            this.predefFilters.addItem("** " + PlanFilter.PREDEFLABELS[n] + " **");
        }
        for (n = 0; n <= PlanFilter.num; ++n) {
            this.predefFilters.addItem(PlanFilter.saveLabels[n]);
        }
    }

    private void applyBeginnerFilter(JRadioButton jRadioButton) {
        if (jRadioButton == null) {
            this.pf.updateDefinition("", this.label.getText(), this);
            this.filterDef.setText("");
            return;
        }
        int n = Util.indexInArrayOf(jRadioButton.getText().substring(1), BEGINNER_FILTER);
        if (n < 0) {
            return;
        }
        this.pf.updateDefinition(BEGINNER_FILTERDEF[n], this.label.getText(), this);
        this.filterDef.setText(this.pf.script);
        this.aladin.console.printCommand("filter " + this.pf.label + " {\n" + this.pf.script + "\n}");
    }

    private void apply() {
        this.pf.label = this.label.getText();
        String string = currentMode = this.modeTabbedPane.getSelectedIndex() == 0 ? BEGINNER : ADVANCED;
        if (currentMode.equals(ADVANCED)) {
            boolean bl = this.pf.isValid();
            this.pf.updateDefinition(this.filterDef.getText(), this.label.getText(), this);
            if (!bl && this.pf.isValid()) {
                this.pf.setActivated(true);
                this.pf.updateState();
                this.aladin.calque.select.repaint();
            }
            this.filterDef.setText(this.pf.script);
            this.beginnerCbg.setSelected(new JButton().getModel(), true);
            this.aladin.console.printCommand("filter " + this.pf.label + " {\n" + this.pf.script + "\n}");
        } else {
            Enumeration<AbstractButton> enumeration = this.beginnerCbg.getElements();
            JRadioButton jRadioButton = null;
            while (enumeration.hasMoreElements() && !(jRadioButton = (JRadioButton)enumeration.nextElement()).isSelected()) {
            }
            this.applyBeginnerFilter(jRadioButton);
        }
        FilterProperties.majFilterProp(true, false);
        this.label.setText(this.pf.label);
        this.setTitre(this.LABEL + " \"" + this.pf.label + "\"");
        this.saveDef = this.filterDef.getText();
        this.saveName = this.label.getText();
        this.showRainbowBtn.setEnabled(this.pf.getUCDFilter().hasRainbowFunction());
        this.aladin.view.repaintAll();
        this.aladin.calque.select.repaint();
    }

    protected String getCaveat() {
        return this.CAVEATMSG;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        Object object = actionEvent.getSource();
        if (this.APPLY.equals(string)) {
            this.apply();
        } else if (this.CLOSE.equals(string)) {
            this.dispose();
        } else if (this.CAVEAT.equals(string)) {
            Aladin.info(this, this.getCaveat());
        } else if (this.MATHS.equals(string)) {
            this.showMathHelper();
        } else if (object instanceof JRadioButton) {
            this.applyBeginnerFilter((JRadioButton)object);
        } else if (string.equals(this.RAINBOWCM)) {
            double[] dArray = this.pf.getUCDFilter().getRainbowMinMax();
            this.aladin.view.showRainbowFilter(CanvasColorMap.getRainbowCM(false), dArray[0], dArray[1]);
            this.aladin.view.getCurrentView().rainbowF.setTitle(this.pf.label);
            this.aladin.view.getCurrentView().repaint();
        } else if (object instanceof JMenuItem) {
            if (string.equals(this.PICKCOLUMN) || string.equals(this.PICKUCD)) {
                if (pickupHelper == null) {
                    pickupHelper = new PickupHelperFrame();
                }
                pickupHelper.setVisible(true);
                pickupHelper.toFront();
            }
            if (string.equals(this.PICKCOLUMN)) {
                pickColumnMode = true;
                pickUCDMode = false;
                pickupFP = this;
            } else if (string.equals(this.PICKUCD)) {
                pickUCDMode = true;
                pickColumnMode = false;
                pickupFP = this;
            } else if (string.equals(this.OPEN_COLUMNS)) {
                this.showColumnHelper();
            } else {
                int n;
                JMenuItem jMenuItem = (JMenuItem)object;
                String string2 = jMenuItem.getActionCommand();
                string2 = this.adjustText(string2);
                int n2 = n = FilterProperties.insertInTA(this.filterDef, string2, this.filterDef.getCaretPosition());
                int n3 = string2.indexOf(40);
                if (n3 > 0) {
                    n2 = n - string2.length() + n3 + 1;
                }
                this.filterDef.setCaretPosition(n2);
                if (string2.startsWith("${") || string2.startsWith("$[")) {
                    this.adjustCaretPos();
                }
                this.filterDef.requestFocus();
            }
        } else if (this.predefFilters != null && this.predefFilters.equals(object)) {
            if (this.filterDef == null) {
                return;
            }
            int n = this.predefFilters.getSelectedIndex();
            if (this.oldIndex == 0) {
                this.saveDef = this.filterDef.getText();
                this.saveName = this.label.getText();
            }
            this.oldIndex = n;
            if (n == -1) {
                return;
            }
            if (n == 0) {
                this.filterDef.setText(this.saveDef);
                this.label.setText(this.saveName);
            } else if (n - 1 < PlanFilter.PREDEFFILTERS.length) {
                this.filterDef.setText(PlanFilter.PREDEFFILTERS[n - 1]);
                String string3 = this.getPredefName(PlanFilter.PREDEFFILTERS[n - 1]);
                if (string3 != null) {
                    this.label.setText(string3);
                }
            } else {
                this.filterDef.setText(PlanFilter.saveFilters[n - 1 - PlanFilter.PREDEFFILTERS.length]);
                this.label.setText(this.saveName);
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    FilterProperties.this.filterDefSp.getVerticalScrollBar().setValue(0);
                }
            });
        } else if (this.FILTERMANUAL.equals(string)) {
            this.aladin.glu.showDocument("Aladin.filterManual", "");
        } else if (this.EXPORT.equals(string)) {
            this.pf.export();
        } else if (this.FILTER_EXAMPLES.equals(string)) {
            FilterHelp filterHelp = FilterHelp.getInstance();
            if (!filterHelp.isShowing()) {
                filterHelp.setVisible(true);
            }
            filterHelp.toFront();
        } else if (this.SAVEFILTER.equals(string)) {
            this.showFileDialog(1);
            this.saveFilter();
        } else if (this.LOADFILTER.equals(string)) {
            this.showFileDialog(0);
            this.loadFilter();
        }
    }

    private void adjustCaretPos() {
        int n = this.filterDef.getCaretPosition();
        String string = this.filterDef.getText();
        if (string.length() > n && string.charAt(n) == ',') {
            this.filterDef.setCaretPosition(n + 1);
        }
    }

    private String adjustText(String string) {
        int n;
        if (!string.startsWith("draw ")) {
            return string;
        }
        String string2 = this.filterDef.getText().substring(0, this.filterDef.getCaretPosition());
        int n2 = -1;
        for (n = string2.length() - 1; n >= 0; --n) {
            if (string2.charAt(n) == '\n') {
                n2 = n;
                break;
            }
            if (string2.charAt(n) != '{') continue;
            if (n == 0) {
                n2 = n;
            }
            if (string2.charAt(n - 1) == '$') continue;
            n2 = n;
            break;
        }
        if ((n = string2.lastIndexOf("draw")) < 0) {
            return string;
        }
        if (n2 < n) {
            return string.substring(5) + " ";
        }
        return string;
    }

    private void showColumnHelper() {
        curWindow = this;
        if (columnHelper == null) {
            columnHelper = new ColumnHelperFrame();
            Point point = this.getRightTopPos();
            columnHelper.setLocation(point.x, point.y);
        } else {
            columnHelper.updateFrame();
        }
        columnHelper.show();
        columnHelper.toFront();
    }

    private void showMathHelper() {
        curWindow = this;
        if (mathHelper == null) {
            mathHelper = new MathHelperFrame();
            Point point = this.getRightTopPos();
            int n = Aladin.SCREENSIZE.height - point.y;
            if (n < 60) {
                point.y -= 60 - n;
            }
            mathHelper.setLocation(point.x, point.y + 350);
        }
        mathHelper.show();
        mathHelper.toFront();
    }

    private String getPredefName(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        String string2 = "";
        while (stringTokenizer.hasMoreTokens() && (string2 = stringTokenizer.nextToken().trim()).charAt(0) != '#') {
        }
        if (string2.charAt(0) == '#') {
            return string2.substring(1).trim();
        }
        return null;
    }

    static void sortLexico(String[] stringArray) {
        MetaDataTree.sort(stringArray, null, true);
    }

    protected static void notifyNewPlan() {
        FilterProperties.majFilterProp(false, true);
    }

    protected static boolean clickInMesure(Source source, int n) {
        if (pickupFP == null || !pickupFP.isShowing()) {
            return false;
        }
        pickupHelper.setVisible(false);
        if (n >= source.leg.field.length) {
            return true;
        }
        if (pickColumnMode) {
            String string = source.leg.field[n].name;
            string = string != null ? string : "";
            int n2 = FilterProperties.insertInTA(FilterProperties.pickupFP.filterDef, "${" + string + "}", FilterProperties.pickupFP.filterDef.getCaretPosition());
            FilterProperties.pickupFP.filterDef.setCaretPosition(n2);
            pickupFP.adjustCaretPos();
            pickupFP.toFront();
            FilterProperties.pickupFP.filterDef.requestFocus();
            pickColumnMode = false;
            return true;
        }
        if (pickUCDMode) {
            String string = source.leg.field[n].ucd;
            string = string != null ? string : "";
            int n3 = FilterProperties.insertInTA(FilterProperties.pickupFP.filterDef, "$[" + string + "]", FilterProperties.pickupFP.filterDef.getCaretPosition());
            FilterProperties.pickupFP.filterDef.setCaretPosition(n3);
            pickupFP.toFront();
            FilterProperties.pickupFP.filterDef.requestFocus();
            pickUCDMode = false;
            return true;
        }
        return false;
    }

    private void updateUCDAndColumn() {
        JMenuItem jMenuItem;
        Aladin.trace(3, "Updating UCD and column names in FilterProperties");
        if (ucds == null) {
            FilterProperties.getUcdsAndColumns(this.aladin);
        }
        if (this.firstTime) {
            jMenuItem = new JMenuItem(this.OPEN_COLUMNS);
            this.columnMenu.add(jMenuItem);
            jMenuItem.addActionListener(this);
            this.columnMenu.addSeparator();
            jMenuItem = new JMenuItem(this.PICKCOLUMN);
            this.columnMenu.add(jMenuItem);
            jMenuItem.addActionListener(this);
            this.firstTime = false;
        }
        this.currentUcdMenu.removeAll();
        for (int i = 0; i < ucds.length; ++i) {
            String string;
            String string2 = ucds[i];
            if (useUcdExplain && (string = FilterProperties.getUCDExplain(ucds[i], true)).length() > 0) {
                string2 = string2 + " - " + string;
            }
            jMenuItem = new JMenuItem(string2);
            jMenuItem.addActionListener(this);
            jMenuItem.setActionCommand("$[" + ucds[i] + "]");
            this.currentUcdMenu.add(jMenuItem);
        }
        this.computeCol = false;
    }

    static String getUCDExplain(String string, boolean bl) {
        String string2;
        if (string == null) {
            return "";
        }
        int n = 70;
        if (FilterProperties.isUCD1Plus(string)) {
            string = string.toLowerCase();
            StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
            string2 = "";
            int n2 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = Aladin.chaine.getString(stringTokenizer.nextToken());
                if (string3.length() > 0 && string3.charAt(0) == '[') {
                    string3 = "?";
                }
                if (n2 > 0) {
                    string2 = string2 + "/";
                }
                string2 = string2 + string3;
                ++n2;
            }
        } else {
            string2 = Aladin.chaine.getString(string);
            if (string2.length() > 0 && string2.charAt(0) == '[') {
                string2 = "?";
            }
        }
        if (bl && string2.length() > n) {
            string2 = string2.substring(0, n) + "...";
        }
        return string2;
    }

    static boolean isUCD1Plus(String string) {
        if (string.indexOf(95) > 0) {
            return false;
        }
        if (string.indexOf(59) > 0) {
            return true;
        }
        return !string.toUpperCase().equals(string);
    }

    static void getUcdsAndColumns(Aladin aladin) {
        Aladin.trace(3, "Recompute all available columns and UCD");
        Vector<String> vector = new Vector<String>();
        for (int i = aladin.calque.plan.length - 1; i >= 0; --i) {
            Plan plan = aladin.calque.plan[i];
            if (!plan.isCatalog()) continue;
            Iterator<Obj> iterator = plan.iterator();
            while (iterator != null && iterator.hasNext()) {
                Obj obj = iterator.next();
                if (!(obj instanceof Source)) continue;
                Source source = (Source)obj;
                if (source.leg == null || source.leg.field == null) {
                    System.out.println("Bizarre");
                }
                for (int j = source.leg.field.length - 1; j >= 0; --j) {
                    String string = source.leg.field[j].name;
                    string = source.leg.field[j].ucd;
                    if (string == null || string.length() <= 0 || vector.indexOf(string) >= 0) continue;
                    vector.addElement(string);
                }
            }
        }
        ucds = new String[vector.size()];
        vector.copyInto(ucds);
        vector = null;
        FilterProperties.sortLexico(ucds);
    }

    private void saveFilter() {
        String string = this.fd.getDirectory();
        String string2 = this.fd.getFile();
        String string3 = (string == null ? "" : string) + (string2 == null ? "" : string2);
        if (string2 == null) {
            return;
        }
        if (!string3.endsWith(".ajs")) {
            string3 = string3 + ".ajs";
        }
        File file = new File(string3);
        try {
            DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
            dataOutputStream.writeBytes("#AJS" + Util.CR);
            dataOutputStream.writeBytes("filter " + this.pf.label + " {" + Util.CR);
            dataOutputStream.writeBytes(this.pf.script);
            dataOutputStream.writeBytes(Util.CR + "}" + Util.CR);
            dataOutputStream.close();
        }
        catch (IOException iOException) {
            Aladin.warning(this, this.IOERR + " : " + iOException);
        }
    }

    private void loadFilter() {
        String string = this.fd.getDirectory();
        String string2 = this.fd.getFile();
        String string3 = (string == null ? "" : string) + (string2 == null ? "" : string2);
        if (string2 == null) {
            return;
        }
        File file = new File(string3);
        String string4 = new String();
        try {
            String string5;
            DataInputStream dataInputStream = new DataInputStream(new FileInputStream(file));
            while ((string5 = dataInputStream.readLine()) != null) {
                if (string4.length() > 0) {
                    string4 = string4 + Util.CR;
                }
                string4 = string4 + string5;
            }
            dataInputStream.close();
        }
        catch (IOException iOException) {
            Aladin.warning(this, this.IOERR + " : " + iOException, 1);
            return;
        }
        this.pf.updateDefinition(string4, null, this);
        this.showProp();
        this.setTitre(this.LABEL + " \"" + this.pf.label + "\"");
        FilterProperties.majFilterProp(true, false);
        this.aladin.calque.select.repaint();
        this.aladin.view.setMesure();
    }

    protected static void majFilterProp(boolean bl, boolean bl2) {
        if (bl2) {
            FilterProperties.getUcdsAndColumns(Aladin.aladin);
        }
        Enumeration enumeration = frameProp.elements();
        while (enumeration.hasMoreElements()) {
            Properties properties = (Properties)enumeration.nextElement();
            if (properties.plan.type != 12) continue;
            FilterProperties filterProperties = (FilterProperties)properties;
            if (bl) {
                filterProperties.majPredefFilters();
            }
            if (!bl2) continue;
            filterProperties.updateUCDAndColumn();
        }
    }

    static int insertInTA(JTextArea jTextArea, String string, int n) {
        StringBuffer stringBuffer = new StringBuffer(jTextArea.getText());
        stringBuffer.insert(n, string);
        jTextArea.setText(stringBuffer.toString());
        jTextArea.repaint();
        int n2 = Action.countNbOcc('\r', jTextArea.getText().substring(0, n));
        int n3 = n + string.length() - n2;
        jTextArea.setCaretPosition(n3);
        return n3;
    }

    private void showFileDialog(int n) {
        String string = null;
        if (this.fd != null) {
            string = this.fd.getDirectory();
        }
        this.fd = new FileDialog((Frame)this, "", n);
        if (string != null) {
            this.fd.setDirectory(string);
        } else {
            this.aladin.setDefaultDirectory(this.fd);
        }
        if (n == 1) {
            this.fd.setFile(this.pf.label + ".ajs");
            this.fd.setTitle(this.SAVEFILTER);
        } else {
            this.fd.setFile("");
            this.fd.setTitle(this.LOADFILTER);
        }
        this.fd.show();
    }

    @Override
    public void dispose() {
        if (pickupFP == this) {
            pickupFP = null;
            pickupHelper.hide();
        }
        this.closeHelperFrames();
        super.dispose();
    }

    private void closeHelperFrames() {
        if (curWindow != this) {
            return;
        }
        if (columnHelper != null) {
            columnHelper.hide();
        }
        if (mathHelper != null) {
            mathHelper.hide();
        }
    }

    @Override
    public boolean handleEvent(Event event) {
        if (event.id == 201) {
            this.dispose();
        }
        return super.handleEvent(event);
    }

    private Point getRightTopPos() {
        Point point = this.getLocation();
        Dimension dimension = this.getSize();
        point.x += dimension.width;
        int n = Aladin.SCREENSIZE.width - point.x;
        if (n < 100) {
            point.x -= 100 - n;
        }
        return point;
    }

    protected static String getCurrentMode() {
        return currentMode;
    }

    protected static void setCurrentMode(String string) {
        if (!string.equals(BEGINNER) && !string.equals(ADVANCED)) {
            return;
        }
        currentMode = string;
    }

    protected static FilterProperties getCurWindow() {
        return curWindow;
    }

    static {
        currentMode = BEGINNER;
        useUcdExplain = true;
        UCDBASE = new String[]{"phot*", "phot.mag*", "phot.mag;em.opt*", "pos.eq.ra;meta.main", "pos.eq.dec;meta.main", "src.class*", "meta.code*", "meta.id;meta.main", "meta.number"};
        UNITBASE = new String[]{"arcmin", "arcsec", "deg", "eV", "Jy", "mag", "pc", "rad", "yr", "W"};
        BEGINNER_FILTERDEF = new String[]{"{ draw circle(-$[phot.mag*]) }", "$[phot.mag*]<12 { draw }", "$[phot.mag*]>17 { draw }", "{ draw $[src.class] }", "{ draw pm($[pos.pm;pos.eq.ra], $[pos.pm;pos.eq.dec]) }", "{\ndraw\ndraw ellipse(0.5*$[phys.angSize.smajAxis],0.5*$[phys.angSize.sminAxis],$[pos.posAng])\n}"};
        pickUCDMode = false;
        pickColumnMode = false;
        BEGINNER = Aladin.chaine.getString("FTBEGINNER");
        ADVANCED = Aladin.chaine.getString("FTADVANCED");
        String[] stringArray = new String[6];
        stringArray[0] = Aladin.chaine.getString("FTDEMO1");
        stringArray[1] = Aladin.chaine.getString("FTDEMO2");
        stringArray[2] = Aladin.chaine.getString("FTDEMO3");
        stringArray[3] = Aladin.chaine.getString("FTDEMO4");
        stringArray[4] = Aladin.chaine.getString("FTDEMO5");
        stringArray[5] = Aladin.chaine.getString("FTDEMO6");
        BEGINNER_FILTER = stringArray;
        BUTTON_INSETS = new Insets(0, 1, 0, 1);
    }

    class PickupHelperFrame
    extends JFrame
    implements ActionListener {
        static final String HELP = "First, select some sources \n \nThen, click in the measurement panel on the given field \nyou would like to use in your filter.";
        static final String CLOSE = "Close";

        PickupHelperFrame() {
            super("Pick a column/a UCD");
            Aladin.setIcon(this);
            this.getContentPane().setLayout(new BorderLayout(0, 0));
            this.updateFrame();
        }

        void updateFrame() {
            this.getContentPane().removeAll();
            MyLabel myLabel = new MyLabel(HELP);
            this.getContentPane().add((Component)myLabel, "Center");
            myLabel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            JPanel jPanel = new JPanel(new FlowLayout());
            JButton jButton = new JButton(CLOSE);
            jPanel.add(jButton);
            jButton.addActionListener(this);
            this.getContentPane().add((Component)jPanel, "South");
            this.pack();
            Point point = FilterProperties.this.aladin.localisation.getLocation();
            Container container = FilterProperties.this.aladin.localisation;
            while ((container = container.getParent()) != null) {
                Point point2 = container.getLocation();
                point.x += point2.x;
                point.y += point2.y;
            }
            this.setLocation(point.x, point.y + 30);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals(CLOSE)) {
                this.setVisible(false);
            }
        }

        @Override
        public boolean handleEvent(Event event) {
            if (event.id == 201) {
                this.setVisible(false);
            }
            return super.handleEvent(event);
        }
    }

    class MathHelperFrame
    extends JFrame
    implements ActionListener {
        static final String CLOSE = "Close";

        MathHelperFrame() {
            super("Available math operators/functions");
            Aladin.setIcon(this);
            this.getContentPane().setLayout(new BorderLayout(0, 0));
            this.buildFrame();
        }

        private void buildFrame() {
            JButton jButton;
            this.getContentPane().removeAll();
            JPanel jPanel = new JPanel();
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints.anchor = 17;
            jPanel.setLayout(gridBagLayout);
            JLabel jLabel = new JLabel("Operators");
            jLabel.setFont(Aladin.BOLD);
            gridBagLayout.setConstraints(jLabel, gridBagConstraints);
            jPanel.add(jLabel);
            JPanel jPanel2 = new JPanel(new FlowLayout(0));
            for (int i = 0; i < FrameColumnCalculator.OPERATORS.length; ++i) {
                jButton = new JButton(FrameColumnCalculator.OPERATORS[i]);
                jButton.addActionListener(this);
                jButton.setFont(Aladin.BOLD);
                jPanel2.add(jButton);
            }
            gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
            jPanel.add(jPanel2);
            jLabel = new JLabel("Functions");
            jLabel.setFont(Aladin.BOLD);
            gridBagLayout.setConstraints(jLabel, gridBagConstraints);
            jPanel.add(jLabel);
            JPanel jPanel3 = new JPanel(new GridLayout(0, 4, 0, 0));
            String[] stringArray = Parser.getAvailFunc();
            for (int i = 0; i < stringArray.length; ++i) {
                jButton = new JButton(stringArray[i]);
                jButton.addActionListener(this);
                jButton.setActionCommand(stringArray[i] + "()");
                jPanel3.add(jButton);
            }
            gridBagLayout.setConstraints(jPanel3, gridBagConstraints);
            jPanel.add(jPanel3);
            String[] stringArray2 = new String[]{"=", "!=", "<", "<=", ">", ">="};
            jLabel = new JLabel("Comparison operators");
            jLabel.setFont(Aladin.BOLD);
            gridBagLayout.setConstraints(jLabel, gridBagConstraints);
            jPanel.add(jLabel);
            JPanel jPanel4 = new JPanel(new FlowLayout(0));
            for (int i = 0; i < stringArray2.length; ++i) {
                jButton = new JButton(stringArray2[i]);
                jButton.addActionListener(this);
                jButton.setFont(Aladin.BOLD);
                jPanel4.add(jButton);
            }
            gridBagLayout.setConstraints(jPanel4, gridBagConstraints);
            jPanel.add(jPanel4);
            String[] stringArray3 = new String[]{"{", "}", "&&", "||", "\""};
            jLabel = new JLabel("Miscellaneous");
            jLabel.setFont(Aladin.BOLD);
            gridBagLayout.setConstraints(jLabel, gridBagConstraints);
            jPanel.add(jLabel);
            JPanel jPanel5 = new JPanel(new FlowLayout(0));
            for (int i = 0; i < stringArray3.length; ++i) {
                jButton = new JButton(stringArray3[i]);
                jButton.addActionListener(this);
                jButton.setFont(Aladin.BOLD);
                jPanel5.add(jButton);
            }
            gridBagLayout.setConstraints(jPanel5, gridBagConstraints);
            jPanel.add(jPanel5);
            JScrollPane jScrollPane = new JScrollPane(jPanel, 20, 30);
            jScrollPane.setSize(280, 300);
            jScrollPane.setOpaque(false);
            this.getContentPane().add((Component)jScrollPane, "Center");
            jScrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(8, 8, 5, 8), BorderFactory.createTitledBorder("")));
            JPanel jPanel6 = new JPanel(new FlowLayout());
            jButton = new JButton(CLOSE);
            jPanel6.add(jButton);
            jButton.addActionListener(this);
            this.getContentPane().add((Component)jPanel6, "South");
            this.pack();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            Object object = actionEvent.getSource();
            if (CLOSE.equals(string)) {
                this.setVisible(false);
            } else {
                String string2 = ((JButton)object).getActionCommand();
                int n = FilterProperties.insertInTA(curWindow.filterDef, string2, curWindow.filterDef.getCaretPosition());
                curWindow.filterDef.setCaretPosition(n);
                curWindow.toFront();
                curWindow.filterDef.requestFocus();
            }
        }

        @Override
        public boolean handleEvent(Event event) {
            if (event.id == 201) {
                this.setVisible(false);
            }
            return super.handleEvent(event);
        }

        @Override
        public void show() {
            super.show();
        }
    }

    class ColumnHelperFrame
    extends JFrame
    implements ActionListener {
        static final String CLOSE = "Close";

        ColumnHelperFrame() {
            super("Available columns");
            Aladin.setIcon(this);
            this.getContentPane().setLayout(new BorderLayout(0, 0));
            this.updateFrame();
        }

        void updateFrame() {
            Serializable serializable;
            Serializable serializable2;
            this.getContentPane().removeAll();
            JPanel jPanel = new JPanel();
            jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 17;
            jPanel.setLayout(gridBagLayout);
            int n = 4;
            for (int i = 0; i < FilterProperties.this.aladin.calque.plan.length; ++i) {
                Plan plan = FilterProperties.this.aladin.calque.plan[i];
                if (!plan.isCatalog() || !plan.flagOk) continue;
                serializable2 = null;
                JPanel jPanel2 = new JPanel(new GridLayout(0, n, 2, 2));
                jPanel2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4), BorderFactory.createTitledBorder(null, plan.getLabel(), 0, 0, Aladin.BOLD)), BorderFactory.createEmptyBorder(4, 4, 4, 4)));
                int n2 = 0;
                Iterator<Obj> iterator = plan.iterator();
                while (iterator.hasNext()) {
                    Obj obj = iterator.next();
                    if (!(obj instanceof Source)) continue;
                    Source source = (Source)obj;
                    serializable = source.leg;
                    if (serializable2 != null && serializable == serializable2) continue;
                    while (n2 % n != 0) {
                        jPanel2.add(new JLabel());
                        ++n2;
                    }
                    for (int j = 0; j < source.leg.field.length; ++j) {
                        JButton jButton = new JButton(source.leg.field[j].name);
                        jButton.setMargin(BUTTON_INSETS);
                        jButton.addActionListener(this);
                        jButton.setFont(Aladin.PLAIN);
                        jPanel2.add(jButton);
                        ++n2;
                        serializable2 = serializable;
                    }
                }
                gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
                jPanel.add(jPanel2);
            }
            JScrollPane jScrollPane = new JScrollPane(jPanel, 20, 30);
            jScrollPane.setSize(300, 290);
            this.getContentPane().add((Component)jScrollPane, "Center");
            serializable2 = new JPanel(new FlowLayout());
            serializable = new JButton(CLOSE);
            serializable2.add((Component)serializable);
            serializable.addActionListener(this);
            this.getContentPane().add((Component)serializable2, "South");
            this.pack();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            Object object = actionEvent.getSource();
            if (CLOSE.equals(string)) {
                this.setVisible(false);
            } else {
                String string2 = ((JButton)object).getText();
                int n = FilterProperties.insertInTA(curWindow.filterDef, "${" + string2 + "}", curWindow.filterDef.getCaretPosition());
                curWindow.filterDef.setCaretPosition(n);
                FilterProperties.this.adjustCaretPos();
                curWindow.toFront();
                curWindow.filterDef.requestFocus();
            }
        }

        @Override
        public boolean handleEvent(Event event) {
            if (event.id == 201) {
                this.setVisible(false);
            }
            return super.handleEvent(event);
        }

        @Override
        public void show() {
            super.show();
        }
    }
}

