/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Action;
import cds.aladin.Aladin;
import cds.aladin.FootprintBean;
import cds.aladin.MyByteArrayStream;
import cds.aladin.MyInputStream;
import cds.aladin.SubFootprintBean;
import cds.savot.model.FieldSet;
import cds.savot.model.MarkupComment;
import cds.savot.model.ParamSet;
import cds.savot.model.ResourceSet;
import cds.savot.model.SavotField;
import cds.savot.model.SavotParam;
import cds.savot.model.SavotResource;
import cds.savot.model.SavotTR;
import cds.savot.model.SavotTable;
import cds.savot.model.SavotVOTable;
import cds.savot.model.TDSet;
import cds.savot.model.TRSet;
import cds.savot.model.TableSet;
import cds.savot.pull.SavotPullEngine;
import cds.savot.pull.SavotPullParser;
import cds.tools.Util;
import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;

public class FootprintParser {
    private static final String SPHERICAL_COORDS = "stc:AstroCoordSystem.CoordFrame.SPHERICAL";
    private MyInputStream mis;
    private byte[] beginStream;
    private SavotVOTable votable;
    private Hashtable<String, FootprintBean> hash;
    private SavotResource[] resources;
    boolean sphericalCoordinates = false;
    private static Hashtable<String, FootprintBean> footprintHash = new Hashtable();
    private Hashtable<String, MarkupComment> refMem;
    int counter = 0;
    int tabIndex = 0;
    private static int BUF_LENGTH = 10000;

    public FootprintParser(MyInputStream myInputStream, byte[] byArray) {
        this.mis = myInputStream;
        this.beginStream = byArray;
    }

    public FootprintParser(SavotResource[] savotResourceArray) {
        this.resources = savotResourceArray;
    }

    public Hashtable<String, FootprintBean> getFooprintHash() {
        ResourceSet resourceSet = new ResourceSet();
        try {
            if (this.mis != null) {
                InputStream inputStream = this.buildInputStream();
                SavotPullParser savotPullParser = new SavotPullParser(inputStream, SavotPullEngine.FULL, null, false);
                this.votable = savotPullParser.getVOTable();
                resourceSet = this.votable.getResources();
            } else {
                for (int i = 0; i < this.resources.length; ++i) {
                    resourceSet.addItem(this.resources[i]);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Aladin.warning("Problem during parsing of footprints !");
            return null;
        }
        int n = resourceSet.getItemCount();
        this.hash = new Hashtable();
        for (int i = 0; i < n; ++i) {
            Aladin.trace(3, "Footprint: Processing resource: " + i);
            this.processFovResource((SavotResource)resourceSet.getItemAt(i));
        }
        return this.hash;
    }

    private void processFovResource(SavotResource savotResource) {
        FootprintBean footprintBean = new FootprintBean();
        this.sphericalCoordinates = false;
        this.tabIndex = 0;
        this.refMem = new Hashtable();
        String string = savotResource.getId();
        footprintBean.setInstrumentName(string);
        ParamSet paramSet = savotResource.getParams();
        int n = paramSet.getItemCount();
        for (int i = 0; i < n; ++i) {
            SavotParam savotParam = (SavotParam)paramSet.getItemAt(i);
            if (savotParam.getUtype().trim().equalsIgnoreCase(SPHERICAL_COORDS)) {
                this.sphericalCoordinates = true;
            }
            if (savotParam.getUcd().equalsIgnoreCase("pos.eq.ra;meta.main")) {
                footprintBean.setRa(savotParam.getValue());
            } else if (savotParam.getUcd().equalsIgnoreCase("pos.eq.dec;meta.main")) {
                footprintBean.setDe(savotParam.getValue());
            }
            if (savotParam.getUcd().equalsIgnoreCase("pos.eq.ra")) {
                footprintBean.setRaRot(savotParam.getValue());
                continue;
            }
            if (savotParam.getUcd().equalsIgnoreCase("pos.eq.dec")) {
                footprintBean.setDeRot(savotParam.getValue());
                continue;
            }
            if (savotParam.getUcd().equalsIgnoreCase("pos.posAng") || savotParam.getUtype().equals("stc:AstroCoordSystem.CoordFrame.Cart2DRefFrame.Transform2.PosAngle")) {
                double d;
                try {
                    d = Double.valueOf(savotParam.getValue());
                }
                catch (NumberFormatException numberFormatException) {
                    continue;
                }
                footprintBean.setPosAngle(d);
                continue;
            }
            if (savotParam.getName().equalsIgnoreCase("Movable")) {
                boolean bl;
                try {
                    bl = Boolean.valueOf(savotParam.getValue());
                }
                catch (NumberFormatException numberFormatException) {
                    continue;
                }
                footprintBean.setMovable(bl);
                continue;
            }
            if (savotParam.getName().equalsIgnoreCase("Rollable")) {
                boolean bl;
                try {
                    bl = Boolean.valueOf(savotParam.getValue());
                }
                catch (NumberFormatException numberFormatException) {
                    continue;
                }
                footprintBean.setRollable(bl);
                continue;
            }
            if (savotParam.getId().equals("InstrumentDescription")) {
                footprintBean.setInstrumentDesc(savotParam.getValue());
                continue;
            }
            if (savotParam.getId().equals("InstrumentName")) {
                footprintBean.setInstrumentName(savotParam.getValue());
                continue;
            }
            if (savotParam.getId().equals("TelescopeName")) {
                footprintBean.setTelescopeName(savotParam.getValue());
                continue;
            }
            if (!savotParam.getId().equals("Origin")) continue;
            footprintBean.setOrigin(savotParam.getValue());
        }
        SubFootprintBean subFootprintBean = this.processResource(savotResource);
        if (subFootprintBean != null && subFootprintBean.getNbOfSubParts() > 0) {
            footprintBean.addSubFootprintBean(subFootprintBean);
        }
        ResourceSet resourceSet = savotResource.getResources();
        for (int i = 0; i < resourceSet.getItemCount(); ++i) {
            subFootprintBean = this.processResource((SavotResource)resourceSet.getItemAt(i));
            if (subFootprintBean == null) continue;
            footprintBean.addSubFootprintBean(subFootprintBean);
            String string2 = ((SavotResource)resourceSet.getItemAt(i)).getId();
            if (string2 == null || string2.length() <= 0) continue;
            FootprintBean footprintBean2 = new FootprintBean();
            footprintBean2.addSubFootprintBean(subFootprintBean);
            footprintBean2.setDisplayInFovList(false);
            if (this.hash.contains(string2)) continue;
            this.hash.put(string2, footprintBean2);
        }
        this.hash.put(string, footprintBean);
        if (footprintHash.get(string) != null) {
            Aladin.trace(1, "Footprint with ID " + string + "already exists ...\n Existing definition will be erased");
        }
        Aladin.trace(3, "Footprint : add to footprintHash footprint with key " + string + "**");
        footprintHash.put(string, footprintBean);
    }

    private SubFootprintBean processResource(SavotResource savotResource) {
        SubFootprintBean subFootprintBean = new SubFootprintBean();
        subFootprintBean.setInSphericalCoords(this.sphericalCoordinates);
        TableSet tableSet = savotResource.getTables();
        int n = tableSet.getItemCount();
        for (int i = 0; i < n; ++i) {
            SubFootprintBean subFootprintBean2 = this.processTable((SavotTable)tableSet.getItemAt(i));
            if (subFootprintBean2 == null) continue;
            subFootprintBean.addSubFootprintBean(subFootprintBean2);
        }
        String string = savotResource.getName();
        subFootprintBean.setName(string);
        subFootprintBean.setColor(this.getColor(savotResource));
        return subFootprintBean;
    }

    protected static FootprintBean getBeanFromID(String string) {
        if (footprintHash == null) {
            return null;
        }
        Enumeration<String> enumeration = footprintHash.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = enumeration.nextElement();
            if (!string2.equalsIgnoreCase(string)) continue;
            return footprintHash.get(string2);
        }
        return null;
    }

    private SubFootprintBean processTable(SavotTable savotTable) {
        String string = this.getRegionType(savotTable);
        if (!(string != null && (string.equals("Box") || string.equals("Polygon") || string.equals("Circle") || string.equals("Pickle") || string.equals("String")))) {
            return null;
        }
        String string2 = savotTable.getId();
        SubFootprintBean subFootprintBean = null;
        if (string.equals("Polygon")) {
            FieldSet fieldSet = savotTable.getFields();
            int n = fieldSet.getItemCount();
            int n2 = -1;
            int n3 = -1;
            for (int i = 0; i < n; ++i) {
                SavotField savotField = (SavotField)fieldSet.getItemAt(i);
                String string3 = (savotField = this.getField(savotField)).getUtype();
                if (string3.equals("stc:AstroCoordArea/Region/reg:Polygon/Vertex/Position[1]") || string3.equalsIgnoreCase("stc:AstroCoordArea.Polygon.Vertex.Position.C1")) {
                    n2 = i;
                    continue;
                }
                if (!string3.equals("stc:AstroCoordArea/Region/reg:Polygon/Vertex/Position[2]") && !string3.equalsIgnoreCase("stc:AstroCoordArea.Polygon.Vertex.Position.C2")) continue;
                n3 = i;
            }
            if (n2 < 0 || n3 < 0) {
                return null;
            }
            TRSet tRSet = savotTable.getData().getTableData().getTRs();
            int n4 = tRSet.getItemCount();
            double[] dArray = new double[n4];
            double[] dArray2 = new double[n4];
            double d = 0.0;
            double d2 = 0.0;
            this.counter += n4;
            for (int i = 0; i < n4; ++i) {
                SavotTR savotTR = (SavotTR)tRSet.getItemAt(i);
                TDSet tDSet = savotTR.getTDs();
                try {
                    String string4 = tDSet.getContent(n2);
                    d2 = Double.valueOf(string4);
                    string4 = tDSet.getContent(n3);
                    d = Double.valueOf(string4);
                }
                catch (NumberFormatException numberFormatException) {
                    numberFormatException.printStackTrace();
                }
                dArray[i] = d2 / 3600.0;
                dArray2[i] = d / 3600.0;
            }
            subFootprintBean = new SubFootprintBean(dArray, dArray2, string2);
            subFootprintBean.setInSphericalCoords(this.sphericalCoordinates);
            return subFootprintBean;
        }
        if (string.equals("Box")) {
            ParamSet paramSet = savotTable.getParams();
            int n = paramSet.getItemCount();
            SavotParam savotParam = null;
            SavotParam savotParam2 = null;
            SavotParam savotParam3 = null;
            SavotParam savotParam4 = null;
            for (int i = 0; i < n; ++i) {
                SavotParam savotParam5 = (SavotParam)paramSet.getItemAt(i);
                String string5 = (savotParam5 = this.getParam(savotParam5)).getUtype();
                if (string5.equals("stc:AstroCoordArea/Region/reg:Box/Center[1]")) {
                    savotParam = savotParam5;
                    continue;
                }
                if (string5.equals("stc:AstroCoordArea/Region/reg:Box/Center[2]")) {
                    savotParam2 = savotParam5;
                    continue;
                }
                if (string5.equals("stc:AstroCoordArea/Region/reg:Box/Size[1]")) {
                    savotParam3 = savotParam5;
                    continue;
                }
                if (!string5.equals("stc:AstroCoordArea/Region/reg:Box/Size[2]")) continue;
                savotParam4 = savotParam5;
            }
            if (savotParam == null || savotParam2 == null || savotParam3 == null || savotParam4 == null) {
                return null;
            }
            double[] dArray = new double[4];
            double[] dArray3 = new double[4];
            this.counter += 4;
            double d = -1.0;
            double d3 = -1.0;
            double d4 = -1.0;
            double d5 = -1.0;
            try {
                d5 = Double.valueOf(savotParam.getValue());
                d4 = Double.valueOf(savotParam2.getValue());
                d3 = Double.valueOf(savotParam3.getValue());
                d = Double.valueOf(savotParam4.getValue());
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
                return null;
            }
            for (int i = 0; i < 4; ++i) {
                int n5 = i == 1 || i == 2 ? 1 : -1;
                int n6 = i == 0 || i == 1 ? 1 : -1;
                dArray[i] = (d5 + (double)n5 * d3 * 0.5) / 3600.0;
                dArray3[i] = (d4 + (double)n6 * d * 0.5) / 3600.0;
            }
            subFootprintBean = new SubFootprintBean(dArray, dArray3, string2);
            subFootprintBean.setInSphericalCoords(this.sphericalCoordinates);
            return subFootprintBean;
        }
        if (string.equals("Circle")) {
            ParamSet paramSet = savotTable.getParams();
            int n = paramSet.getItemCount();
            SavotParam savotParam = null;
            SavotParam savotParam6 = null;
            SavotParam savotParam7 = null;
            for (int i = 0; i < n; ++i) {
                SavotParam savotParam8 = (SavotParam)paramSet.getItemAt(i);
                String string6 = (savotParam8 = this.getParam(savotParam8)).getUtype();
                if (string6.equals("stc:AstroCoordArea/Region/reg:Sector/Center[1]") || string6.equals("stc:AstroCoordArea.Circle.Center.C1")) {
                    savotParam = savotParam8;
                    continue;
                }
                if (string6.equals("stc:AstroCoordArea/Region/reg:Sector/Center[2]") || string6.equals("stc:AstroCoordArea.Circle.Center.C2")) {
                    savotParam6 = savotParam8;
                    continue;
                }
                if (!string6.equals("stc:AstroCoordArea/Region/reg:Circle/radius") && !string6.equals("stc:AstroCoordArea.Circle.radius")) continue;
                savotParam7 = savotParam8;
            }
            if (savotParam == null || savotParam6 == null || savotParam7 == null) {
                return null;
            }
            try {
                double d = Double.valueOf(savotParam.getValue());
                double d6 = Double.valueOf(savotParam6.getValue());
                double d7 = Double.valueOf(savotParam7.getValue());
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
            subFootprintBean = new SubFootprintBean(d /= 3600.0, d6 /= 3600.0, d7 /= 3600.0, string2);
            subFootprintBean.setInSphericalCoords(this.sphericalCoordinates);
            return subFootprintBean;
        }
        if (string.equals("Pickle")) {
            double d;
            double d8;
            double d9;
            double d10;
            ParamSet paramSet = savotTable.getParams();
            int n = paramSet.getItemCount();
            SavotParam savotParam = null;
            SavotParam savotParam9 = null;
            SavotParam savotParam10 = null;
            SavotParam savotParam11 = null;
            SavotParam savotParam12 = null;
            SavotParam savotParam13 = null;
            for (int i = 0; i < n; ++i) {
                SavotParam savotParam14 = (SavotParam)paramSet.getItemAt(i);
                String string7 = (savotParam14 = this.getParam(savotParam14)).getUtype();
                if (string7.equals("stc:AstroCoordArea/Region/reg:Sector/Center[1]")) {
                    savotParam = savotParam14;
                    continue;
                }
                if (string7.equals("stc:AstroCoordArea/Region/reg:Sector/Center[2]")) {
                    savotParam9 = savotParam14;
                    continue;
                }
                if (string7.equals("stc:AstroCoordArea/Region/reg:Sector/angle1")) {
                    savotParam12 = savotParam14;
                    continue;
                }
                if (string7.equals("stc:AstroCoordArea/Region/reg:Sector/angle2")) {
                    savotParam13 = savotParam14;
                    continue;
                }
                if (string7.equals("stc:AstroCoordArea/Region/reg:Circle/radius") && savotParam10 == null) {
                    savotParam10 = savotParam14;
                    continue;
                }
                if (!string7.equals("stc:AstroCoordArea/Region/reg:Circle/radius")) continue;
                savotParam11 = savotParam14;
            }
            if (savotParam == null || savotParam9 == null || savotParam12 == null || savotParam13 == null || savotParam10 == null || savotParam11 == null) {
                return null;
            }
            try {
                double d11 = Double.valueOf(savotParam.getValue());
                double d12 = Double.valueOf(savotParam9.getValue());
                d10 = Double.valueOf(savotParam12.getValue());
                d9 = Double.valueOf(savotParam13.getValue());
                d8 = Double.valueOf(savotParam10.getValue());
                d = Double.valueOf(savotParam11.getValue());
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
            double d13 = d8;
            if (d8 > d) {
                d8 = d;
                d = d13;
            }
            double d14 = d9 - d10;
            subFootprintBean = new SubFootprintBean(d11 /= 3600.0, d12 /= 3600.0, d10, d14, d8 /= 3600.0, d /= 3600.0, string2);
            subFootprintBean.setInSphericalCoords(this.sphericalCoordinates);
            return subFootprintBean;
        }
        if (string.equals("String")) {
            ParamSet paramSet = savotTable.getParams();
            int n = paramSet.getItemCount();
            SavotParam savotParam = null;
            SavotParam savotParam15 = null;
            SavotParam savotParam16 = null;
            for (int i = 0; i < n; ++i) {
                SavotParam savotParam17 = (SavotParam)paramSet.getItemAt(i);
                String string8 = (savotParam17 = this.getParam(savotParam17)).getUtype();
                if (string8.equals("stc:AstroCoord.Position2D.Value2.C1")) {
                    savotParam = savotParam17;
                    continue;
                }
                if (string8.equals("stc:AstroCoord.Position2D.Value2.C2")) {
                    savotParam15 = savotParam17;
                    continue;
                }
                if (!string8.equals("app:footprint.render.overlay.string.content")) continue;
                savotParam16 = savotParam17;
            }
            if (savotParam == null || savotParam15 == null || savotParam16 == null) {
                System.err.println("something is missing");
                return null;
            }
            try {
                double d = Double.valueOf(savotParam.getValue());
                double d15 = Double.valueOf(savotParam15.getValue());
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
                return null;
            }
            subFootprintBean = new SubFootprintBean(d /= 3600.0, d15 /= 3600.0, "center", savotParam16.getValue());
            subFootprintBean.setInSphericalCoords(this.sphericalCoordinates);
            return subFootprintBean;
        }
        return null;
    }

    private SavotField getField(SavotField savotField) {
        String string = savotField.getRef();
        if (string != null && string.length() > 0) {
            return (SavotField)this.refMem.get(string);
        }
        String string2 = savotField.getId();
        if (string2 != null && string2.length() > 0) {
            this.refMem.put(string2, savotField);
            return savotField;
        }
        return savotField;
    }

    private SavotParam getParam(SavotParam savotParam) {
        String string = savotParam.getRef();
        if (string != null && string.length() > 0) {
            return (SavotParam)this.refMem.get(string);
        }
        String string2 = savotParam.getId();
        if (string2 != null && string2.length() > 0) {
            this.refMem.put(string2, savotParam);
            return savotParam;
        }
        return savotParam;
    }

    private String getRegionType(SavotTable savotTable) {
        ParamSet paramSet = savotTable.getParams();
        int n = paramSet.getItemCount();
        for (int i = 0; i < n; ++i) {
            SavotParam savotParam = (SavotParam)paramSet.getItemAt(i);
            if (savotParam.getName().equals("Region") || savotParam.getUtype().equalsIgnoreCase("dal:footprint.geom.segment.shape")) {
                return savotParam.getValue();
            }
            if (!savotParam.getUtype().equalsIgnoreCase("app:footprint.render.overlay.string")) continue;
            return "String";
        }
        return null;
    }

    private InputStream buildInputStream() throws IOException {
        MyByteArrayStream myByteArrayStream = new MyByteArrayStream();
        myByteArrayStream.write("<?xml version=\"1.0\" ?>\n<VOTABLE>".getBytes());
        if (this.beginStream != null) {
            myByteArrayStream.write(this.beginStream);
        }
        byte[] byArray = new byte[BUF_LENGTH];
        while (this.mis.available() > 0) {
            int n = this.mis.read(byArray);
            myByteArrayStream.write(byArray, 0, n);
        }
        return myByteArrayStream.getInputStream();
    }

    private Color getColor(SavotResource savotResource) {
        ParamSet paramSet = savotResource.getParams();
        int n = paramSet.getItemCount();
        for (int i = 0; i < n; ++i) {
            SavotParam savotParam = (SavotParam)paramSet.getItemAt(i);
            if ((savotParam = this.getParam(savotParam)) == null || !savotParam.getName().equalsIgnoreCase("color")) continue;
            String string = savotParam.getValue();
            int n2 = Util.indexInArrayOf(string, Action.COLORNAME);
            if (n2 >= 0) {
                return Action.MYCOLORS[n2];
            }
            return Action.decodeStaticRGB(string);
        }
        return null;
    }
}

