/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Coord;
import cds.aladin.FootprintBean;
import cds.aladin.Plan;
import cds.aladin.PlanField;
import cds.aladin.PointD;
import cds.aladin.Projection;
import cds.aladin.TreeBuilder;
import cds.aladin.ViewSimple;
import cds.aladin.stc.STCFrame;
import cds.aladin.stc.STCObj;
import cds.aladin.stc.STCPolygon;
import cds.tools.Util;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.util.ArrayList;
import java.util.List;

public class Fov {
    protected static final double X_SPECTRUM = 0.0;
    protected static final double Y_SPECTRUM = 0.02;
    double alpha;
    double delta;
    double x;
    double y;
    double[] xTab;
    double[] yTab;
    double angle;
    double cutout_x;
    double cutout_y;
    Color color = Color.red;
    boolean spectrumFov = false;
    private PointD[] bords = new PointD[4];
    protected PlanField pf;
    private List<STCObj> stcObjects;
    FootprintBean fpBean;
    String key;
    private String size;

    Fov(List<STCObj> list) {
        this.stcObjects = list;
        this.delta = Double.NaN;
        this.alpha = Double.NaN;
    }

    Fov(double d, double d2, double d3, double d4, double d5) {
        this.alpha = d;
        this.delta = d2;
        this.x = d3;
        this.y = d4;
        this.angle = d5;
        this.computePoints();
    }

    Fov(double d, double d2, double[] dArray, double[] dArray2, double d3) {
        this.alpha = d;
        this.delta = d2;
        this.angle = d3;
        this.bords = new PointD[4];
        this.bords[0] = new PointD(dArray[0], dArray[1]);
        this.bords[1] = new PointD(dArray[0], dArray2[1]);
        this.bords[2] = new PointD(dArray2[0], dArray2[1]);
        this.bords[3] = new PointD(dArray2[0], dArray[1]);
    }

    Fov(double d, double d2, ArrayList<PointD[]> arrayList) {
    }

    Fov(double d, double d2, double[] dArray, double[] dArray2, double d3, double d4, double d5) {
        this.alpha = d;
        this.delta = d2;
        this.xTab = dArray;
        this.yTab = dArray2;
        this.angle = d3;
        this.x = d4;
        this.y = d5;
        this.computePoints();
    }

    Fov(String string, double d, double d2, double d3) throws Exception {
        Coord coord = new Coord(string);
        this.alpha = coord.al;
        this.delta = coord.del;
        this.x = d;
        this.y = d2;
        this.angle = d3;
        this.computePoints();
    }

    Fov(double d, double d2, double d3) {
        this.alpha = d;
        this.delta = d2;
        this.angle = d3;
        this.spectrumFov = true;
        this.computePoints();
    }

    Fov(Aladin aladin, FootprintBean footprintBean, String string, double d, double d2, double d3) {
        this.pf = new PlanField(aladin, footprintBean, string);
        this.pf.make(d, d2, d3);
        this.fpBean = footprintBean;
        this.key = string;
        this.alpha = d;
        this.delta = d2;
        this.angle = d3;
    }

    private void computePoints() {
        double d = Fov.deg2rad(-this.angle);
        if (this.xTab != null && this.yTab != null) {
            this.bords = new PointD[this.xTab.length];
            for (int i = 0; i < this.xTab.length; ++i) {
                double d2 = this.delta + this.yTab[i] * Math.cos(d) + this.xTab[i] * Math.sin(d);
                double d3 = this.alpha + (this.xTab[i] * Math.cos(d) - this.yTab[i] * Math.sin(d)) / Math.cos(Fov.deg2rad(d2));
                this.bords[i] = new PointD(d3, d2);
            }
        } else {
            double d4;
            double d5;
            if (this.spectrumFov) {
                d5 = 0.0;
                d4 = 0.02;
            } else {
                d5 = this.x;
                d4 = this.y;
            }
            for (int i = 0; i < 4; ++i) {
                int n = i == 1 || i == 2 ? -1 : 1;
                int n2 = i < 2 ? 1 : -1;
                double d6 = this.delta + (double)n2 * d4 / 2.0 * Math.cos(d) + (double)n * d5 / 2.0 * Math.sin(d);
                double d7 = this.alpha + ((double)n * d5 / 2.0 * Math.cos(d) - (double)n2 * d4 / 2.0 * Math.sin(d)) / Math.cos(Fov.deg2rad(d6));
                this.bords[i] = new PointD(d7, d6);
            }
        }
    }

    private static double deg2rad(double d) {
        return d * Math.PI / 180.0;
    }

    protected Point[] getBorders(PointD[] pointDArray, Projection projection, ViewSimple viewSimple) {
        Point[] pointArray = new Point[pointDArray.length];
        Coord coord = new Coord(this.alpha, this.delta);
        try {
            if (!Double.isNaN(this.alpha)) {
                coord = projection.getXY(coord);
                if (Double.isNaN(coord.x)) {
                    return null;
                }
            }
            for (int i = 0; i < pointDArray.length; ++i) {
                coord = new Coord(pointDArray[i].x, pointDArray[i].y);
                coord = projection.getXY(coord);
                if (Double.isNaN(coord.x)) {
                    return null;
                }
                pointArray[i] = viewSimple.getViewCoord(coord.x, coord.y);
                if (pointArray[i] != null) continue;
                return null;
            }
        }
        catch (Exception exception) {
            return null;
        }
        return pointArray;
    }

    protected PointD[] getBordersSpectrum(Projection projection, ViewSimple viewSimple) {
        PointD[] pointDArray = new PointD[this.bords.length];
        Coord coord = new Coord(this.alpha, this.delta);
        try {
            coord = projection.getXY(coord);
            if (Double.isNaN(coord.x)) {
                return null;
            }
            for (int i = 0; i < this.bords.length; ++i) {
                coord = new Coord(this.bords[i].x, this.bords[i].y);
                coord = projection.getXY(coord);
                if (Double.isNaN(coord.x)) {
                    return null;
                }
                pointDArray[i] = viewSimple.getViewCoordDble(coord.x, coord.y);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return pointDArray;
    }

    protected PointD[] getPoints(Projection projection) {
        PointD[] pointDArray = new PointD[this.bords.length];
        Coord coord = new Coord(this.alpha, this.delta);
        try {
            coord = projection.getXY(coord);
            if (Double.isNaN(coord.x)) {
                return pointDArray;
            }
            for (int i = 0; i < this.bords.length; ++i) {
                coord = new Coord(this.bords[i].x, this.bords[i].y);
                coord = projection.getXY(coord);
                if (Double.isNaN(coord.x)) {
                    return pointDArray;
                }
                pointDArray[i] = new PointD(coord.x, coord.y);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return pointDArray;
    }

    protected List<STCObj> getStcObjects() {
        return this.stcObjects;
    }

    protected void draw(Projection projection, ViewSimple viewSimple, Graphics graphics, int n, int n2, Color color) {
        graphics.setColor(color != null ? color : this.color);
        if (this.spectrumFov) {
            graphics.setFont(Aladin.BOLD);
            Coord coord = new Coord(this.alpha, this.delta);
            coord = projection.getXY(coord);
            PointD pointD = viewSimple.getViewCoordDble(coord.x, coord.y);
            if (Double.isNaN(pointD.x) || Double.isNaN(pointD.y)) {
                return;
            }
            graphics.drawString("S", (int)pointD.x, (int)pointD.y);
            return;
        }
        if (this.pf != null) {
            this.pf.c = this.color;
            this.pf.pcat.draw(graphics, null, viewSimple, true, n, n2);
            return;
        }
        if (this.stcObjects != null) {
            ArrayList<PointD[]> arrayList = new ArrayList<PointD[]>();
            for (STCObj sTCObj : this.stcObjects) {
                STCPolygon sTCPolygon;
                STCFrame sTCFrame;
                if (sTCObj.getShapeType() != STCObj.ShapeType.POLYGON || (sTCFrame = (sTCPolygon = (STCPolygon)sTCObj).getFrame()) != STCFrame.FK5 && sTCFrame != STCFrame.ICRS && sTCFrame != STCFrame.J2000) continue;
                PointD[] pointDArray = new PointD[sTCPolygon.getxCorners().size()];
                for (int i = 0; i < pointDArray.length; ++i) {
                    pointDArray[i] = new PointD(sTCPolygon.getxCorners().get(i), sTCPolygon.getyCorners().get(i));
                }
                arrayList.add(pointDArray);
            }
            this.doDraw(arrayList, projection, viewSimple, graphics, n, n2, color);
            return;
        }
        ArrayList<PointD[]> arrayList = new ArrayList<PointD[]>();
        arrayList.add(this.bords);
        this.doDraw(arrayList, projection, viewSimple, graphics, n, n2, color);
    }

    private void doDraw(List<PointD[]> list, Projection projection, ViewSimple viewSimple, Graphics graphics, int n, int n2, Color color) {
        for (PointD[] pointDArray : list) {
            int n3;
            Point[] pointArray = this.getBorders(pointDArray, projection, viewSimple);
            if (pointArray == null) continue;
            int[] nArray = new int[pointArray.length];
            int[] nArray2 = new int[pointArray.length];
            for (n3 = 0; n3 < pointArray.length; ++n3) {
                nArray[n3] = pointArray[n3].x + n;
                nArray2[n3] = pointArray[n3].y + n2;
            }
            if (Aladin.ENABLE_FOOTPRINT_OPACITY && graphics instanceof Graphics2D) {
                Graphics2D graphics2D = null;
                Composite composite = null;
                graphics2D = (Graphics2D)graphics;
                composite = graphics2D.getComposite();
                Composite composite2 = Util.getFootprintComposite(Aladin.DEFAULT_FOOTPRINT_OPACITY_LEVEL);
                graphics2D.setComposite(composite2);
                graphics2D.fill(new Polygon(nArray, nArray2, nArray.length));
                graphics2D.setComposite(composite);
            }
            for (int i = 0; i < pointArray.length; ++i) {
                n3 = (i + 1) % pointArray.length;
                graphics.drawLine(nArray[i], nArray2[i], nArray[n3], nArray2[n3]);
            }
        }
    }

    protected boolean contains(double d, double d2, Plan plan, ViewSimple viewSimple) {
        if (this.spectrumFov) {
            return false;
        }
        if (this.pf != null) {
            return false;
        }
        int[] nArray = new int[this.bords.length];
        int[] nArray2 = new int[this.bords.length];
        Point[] pointArray = this.getBorders(this.bords, viewSimple.getProj(), viewSimple);
        if (pointArray == null) {
            return false;
        }
        for (int i = 0; i < this.bords.length; ++i) {
            nArray[i] = pointArray[i].x;
            nArray2[i] = pointArray[i].y;
        }
        Polygon polygon = new Polygon(nArray, nArray2, this.bords.length);
        return polygon.contains(d, d2);
    }

    protected PointD[] getPoints() {
        return this.bords;
    }

    protected String getSizeStr(boolean bl) {
        if (this.spectrumFov) {
            return "";
        }
        if (this.pf != null) {
            return "";
        }
        if (this.size == null) {
            this.size = bl ? TreeBuilder.getUnit(Double.toString(this.cutout_x), "deg") + " x " + TreeBuilder.getUnit(Double.toString(this.cutout_y), "deg") : TreeBuilder.getUnit(Double.toString(this.x), "deg") + " x " + TreeBuilder.getUnit(Double.toString(this.y), "deg");
        }
        return this.size;
    }
}

