/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.FrameRGBBlink;
import cds.aladin.Plan;
import cds.aladin.PlanImage;
import cds.tools.Util;
import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public final class FrameBitpix
extends FrameRGBBlink {
    private String TITLE;
    private String INFO;
    private String HELP1;
    private String CUT;
    private String CUTLABEL;
    private String CAST;
    private String PLANE;
    private static int[] BITPIX = new int[]{-64, -32, 64, 32, 16, 8};
    private static String[] CODE = new String[]{"double (-64)", "float (-32)", "long (64)", "integer (32)", "short (16)", "byte (8)"};
    private JRadioButton[] rb;
    private JRadioButton cut;
    private JLabel srcSize;
    private JLabel trgSize;
    private ButtonGroup cbBitpix;

    @Override
    protected void createChaine() {
        super.createChaine();
        this.TITLE = Aladin.chaine.getString("BITPIXTITLE");
        this.INFO = Aladin.chaine.getString("BITPIXINFO");
        this.HELP1 = Aladin.chaine.getString("BITPIXHELP");
        this.CUTLABEL = Aladin.chaine.getString("BITPIXCUTLABEL");
        this.CUT = Aladin.chaine.getString("BITPIXCUT");
        this.CAST = Aladin.chaine.getString("BITPIXCAST");
    }

    protected FrameBitpix(Aladin aladin) {
        super(aladin);
        Aladin.setIcon(this);
    }

    @Override
    protected String getTitre() {
        return this.TITLE;
    }

    @Override
    protected String getInformation() {
        return this.INFO;
    }

    @Override
    protected String getHelp() {
        return this.HELP1;
    }

    @Override
    protected int getToolNumber() {
        return -2;
    }

    @Override
    protected int getNb() {
        return 1;
    }

    @Override
    protected String getLabelSelector(int n) {
        return this.PLANE;
    }

    protected PlanImage[] getPlan() {
        Vector<Plan> vector = this.a.calque.getPlans(1);
        if (vector == null) {
            return new PlanImage[0];
        }
        Object[] objectArray = new PlanImage[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    @Override
    protected Color getColorLabel(int n) {
        return Color.black;
    }

    @Override
    protected JPanel getAddPanel() {
        JRadioButton jRadioButton;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(gridBagLayout);
        this.cbBitpix = new ButtonGroup();
        JPanel jPanel2 = new JPanel();
        JLabel jLabel = new JLabel("Bitpix:");
        jLabel.setFont(jLabel.getFont().deriveFont(1));
        jPanel2.add(jLabel);
        this.rb = new JRadioButton[BITPIX.length];
        JPanel jPanel3 = new JPanel(new GridLayout(2, 3));
        for (int i = 0; i < this.rb.length; ++i) {
            this.rb[i] = jRadioButton = new JRadioButton(CODE[i]);
            jRadioButton.setActionCommand(CODE[i]);
            jPanel3.add(jRadioButton);
            this.cbBitpix.add(jRadioButton);
            jRadioButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    FrameBitpix.this.updateTrg();
                }
            });
        }
        jPanel2.add(jPanel3);
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        jPanel.add(jPanel2);
        ButtonGroup buttonGroup = new ButtonGroup();
        JPanel jPanel4 = new JPanel();
        jLabel = new JLabel(this.CUTLABEL);
        jLabel.setFont(jLabel.getFont().deriveFont(1));
        jPanel4.add(jLabel);
        this.cut = jRadioButton = new JRadioButton(this.CUT);
        jRadioButton.setActionCommand(this.CUT);
        buttonGroup.add(jRadioButton);
        jPanel4.add(jRadioButton);
        jRadioButton.setSelected(true);
        jRadioButton = new JRadioButton(this.CAST);
        jRadioButton.setActionCommand(this.CAST);
        buttonGroup.add(jRadioButton);
        jPanel4.add(jRadioButton);
        gridBagLayout.setConstraints(jPanel4, gridBagConstraints);
        jPanel.add(jPanel4);
        jPanel4 = new JPanel();
        this.srcSize = jLabel = new JLabel(".");
        jLabel.setFont(jLabel.getFont().deriveFont(2));
        jPanel4.add(jLabel);
        gridBagLayout.setConstraints(jPanel4, gridBagConstraints);
        jPanel.add(jPanel4);
        jPanel4 = new JPanel();
        this.trgSize = jLabel = new JLabel(".");
        jLabel.setFont(jLabel.getFont().deriveFont(2));
        jPanel4.add(jLabel);
        gridBagLayout.setConstraints(jPanel4, gridBagConstraints);
        jPanel.add(jPanel4);
        return jPanel;
    }

    @Override
    protected void submit() {
        try {
            PlanImage planImage = (PlanImage)this.getPlan(this.ch[0]);
            String string = this.cbBitpix.getSelection().getActionCommand();
            int n = Util.indexInArrayOf(string, CODE);
            int n2 = this.cut.isSelected() ? 9 : 8;
            this.a.calque.newPlanImageAlgo(null, planImage, null, n2, 0.0, "" + BITPIX[n], 0);
        }
        catch (Exception exception) {
            if (Aladin.levelTrace >= 3) {
                exception.printStackTrace();
            }
            Aladin.warning("Bitpix convertion failed !");
        }
    }

    private void updateTrg() {
        PlanImage planImage = (PlanImage)this.getPlan(this.ch[0]);
        if (planImage == null) {
            return;
        }
        String string = this.cbBitpix.getSelection().getActionCommand();
        int n = Util.indexInArrayOf(string, CODE);
        int n2 = BITPIX[n];
        int n3 = planImage.naxis1;
        int n4 = planImage.naxis2;
        int n5 = Math.abs(n2) / 8;
        long l = (long)n3 * (long)n4 * (long)n5;
        this.trgSize.setText("Target size: " + n3 + "x" + n4 + " x " + n5 + " => " + Util.getUnitDisk(l));
    }

    private void updateSrc(int n, int n2, int n3) {
        int n4;
        for (n4 = 0; n4 < BITPIX.length; ++n4) {
            this.rb[n4].setSelected(BITPIX[n4] == n);
            this.rb[n4].setEnabled(BITPIX[n4] != n);
        }
        n4 = Math.abs(n) / 8;
        long l = (long)n2 * (long)n3 * (long)n4;
        this.srcSize.setText("Current size: " + n2 + "x" + n3 + " x " + n4 + " => " + Util.getUnitDisk(l));
    }

    @Override
    protected void adjustWidgets() {
        this.srcSize.setText("");
        this.trgSize.setText("");
        PlanImage planImage = (PlanImage)this.getPlan(this.ch[0]);
        if (planImage == null) {
            return;
        }
        this.updateSrc(planImage.bitpix, planImage.naxis1, planImage.naxis2);
    }
}

