/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.FrameRGBBlink;
import cds.aladin.PlanImage;
import cds.aladin.Tok;
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.Label;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public final class FrameBlink
extends FrameRGBBlink {
    protected static final int[] DELAY = new int[]{0, 25, 50, 100, 200, 400, 800, 1600, 3200};
    String TITLE;
    String INFO;
    String HELP1;
    String RSAMPREF;
    String BLKDELAY;
    String MOSAIC;
    String BLINK;
    String ERR1;
    String ERR2;
    static final String STOPPED = "-- stopped --";
    static final int DEFAULT_DELAY = 5;
    private ButtonGroup cmb;
    private JRadioButton bcb;
    private JRadioButton mcb;
    private JComboBox cDelay;
    private JTextField textFieldRef;

    @Override
    protected void createChaine() {
        super.createChaine();
        this.TITLE = Aladin.chaine.getString("BLKTITLE");
        this.INFO = Aladin.chaine.getString("BLKINFO");
        this.HELP1 = Aladin.chaine.getString("IMGHELP1");
        this.RSAMPREF = Aladin.chaine.getString("RGBRSAMPREF");
        this.BLKDELAY = Aladin.chaine.getString("BLKDELAY");
        this.BLINK = Aladin.chaine.getString("BLKBLK");
        this.MOSAIC = Aladin.chaine.getString("BLKMOSAIC");
        this.ERR1 = Aladin.chaine.getString("BLKERR1");
        this.ERR2 = Aladin.chaine.getString("BLKERR2");
    }

    protected FrameBlink(Aladin aladin) {
        super(aladin);
        Aladin.setIcon(this);
    }

    @Override
    protected String getTitre() {
        return this.TITLE;
    }

    @Override
    protected String getInformation() {
        return this.INFO;
    }

    @Override
    protected String getHelp() {
        return this.HELP1;
    }

    @Override
    protected int getToolNumber() {
        return 15;
    }

    @Override
    protected int getNb() {
        return 50;
    }

    @Override
    protected String getLabelSelector(int n) {
        return n + 1 + ")";
    }

    @Override
    protected Color getColorLabel(int n) {
        return Color.black;
    }

    protected static JComboBox createChoiceDelay() {
        return FrameBlink.createChoiceDelay(FrameBlink.getDefaultDelay());
    }

    protected static JComboBox createChoiceDelay(int n) {
        JComboBox<String> jComboBox = new JComboBox<String>();
        jComboBox.setFont(Aladin.BOLD);
        int n2 = 0;
        for (int i = 0; i < DELAY.length; ++i) {
            if (DELAY[i] == 0) {
                jComboBox.addItem(STOPPED);
            } else {
                jComboBox.addItem(DELAY[i] + " ms");
            }
            if (n != DELAY[i]) continue;
            n2 = i;
        }
        jComboBox.setSelectedIndex(n2);
        return jComboBox;
    }

    protected int getDelay() {
        String string = (String)this.cDelay.getSelectedItem();
        if (string.equals(STOPPED)) {
            return 0;
        }
        string = string.substring(0, string.indexOf(32));
        return Integer.valueOf(string);
    }

    protected static int getMinDelay() {
        return DELAY[1];
    }

    protected static int getMaxDelay() {
        return DELAY[DELAY.length - 1];
    }

    protected static int getDefaultDelay() {
        return DELAY[5];
    }

    @Override
    protected JPanel getAddPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(0, 1));
        this.cmb = new ButtonGroup();
        JPanel jPanel2 = new JPanel();
        JRadioButton jRadioButton = this.mcb = new JRadioButton(this.MOSAIC);
        jRadioButton.setActionCommand(this.MOSAIC);
        this.cmb.add(jRadioButton);
        jPanel2.add(jRadioButton);
        this.bcb = jRadioButton = new JRadioButton(this.BLINK);
        jRadioButton.setActionCommand(this.BLINK);
        this.cmb.add(jRadioButton);
        jRadioButton.setSelected(true);
        jPanel2.add(jRadioButton);
        jPanel2.add(new Label(this.BLKDELAY));
        this.cDelay = FrameBlink.createChoiceDelay();
        jPanel2.add(this.cDelay);
        jPanel.add(jPanel2);
        jPanel2 = new JPanel();
        jPanel2.add(new Label(this.RSAMPREF));
        this.textFieldRef = new JTextField("1");
        jPanel2.add(this.textFieldRef);
        jPanel.add(jPanel2);
        return jPanel;
    }

    @Override
    protected void adjustWidgets() {
        this.cDelay.setEnabled(this.cmb.getSelection().getActionCommand().equals(this.BLINK));
    }

    @Override
    protected void reset() {
        super.reset();
        this.textFieldRef.setText("1");
        this.cDelay.setSelectedIndex(5);
    }

    protected void setMode(int n) {
        if (n == 0) {
            this.bcb.setSelected(true);
        } else {
            this.mcb.setSelected(true);
        }
    }

    @Override
    protected void submit() {
        Object object;
        int n = -1;
        try {
            n = Integer.parseInt(this.textFieldRef.getText()) - 1;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n < 0 || n >= this.ch.length) {
            Aladin.warning(this, this.ERR1 + " [1.." + (this.ch.length - 1) + "] !");
            return;
        }
        int n2 = this.getNb();
        Vector<PlanImage> vector = new Vector<PlanImage>(10);
        int n3 = 0;
        while (n3 < n2) {
            if (n >= this.ch.length) {
                n = 0;
            }
            if ((object = (PlanImage)this.getPlan(this.ch[n])) != null) {
                vector.addElement((PlanImage)object);
            }
            ++n3;
            ++n;
        }
        if (vector.size() == 1) {
            Aladin.warning(this, this.ERR2);
            return;
        }
        n3 = this.cmb.getSelection().getActionCommand().equals(this.BLINK) ? 1 : 0;
        object = new StringBuffer(n3 != 0 ? "blink" : "mosaic");
        PlanImage[] planImageArray = new PlanImage[vector.size()];
        Enumeration enumeration = vector.elements();
        int n4 = 0;
        while (enumeration.hasMoreElements()) {
            planImageArray[n4] = (PlanImage)enumeration.nextElement();
            ((StringBuffer)object).append(" " + Tok.quote(planImageArray[n4].label));
            ++n4;
        }
        this.a.console.printCommand(((StringBuffer)object).toString());
        if (n3 != 0) {
            this.a.calque.newPlanImageBlink(planImageArray, null, this.getDelay());
        } else {
            this.a.calque.newPlanImageMosaic(planImageArray, null, null);
        }
        this.hide();
    }
}

