/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.CDSXMatch;
import cds.aladin.ColFilter;
import cds.aladin.Legende;
import cds.aladin.MyButton;
import cds.aladin.Plan;
import cds.aladin.PlanCatalog;
import cds.tools.Util;
import cds.xml.Field;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.ScrollPane;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

public class FrameCDSXMatch
extends JFrame
implements Runnable,
ActionListener {
    static final String ADVANCED_OPTIONS = "Advanced options";
    static final String POS_XMATCH_ELLIPSES = "Ellipses";
    static String TITRE;
    static String CLOSE;
    static String XMATCH;
    static String POS_XMATCH;
    static String CROSS_ID;
    static String ONLYPOS;
    static String THRESHOLD;
    static String THRESHOLD1;
    static String CHOOSEMATCH;
    static String BESTMATCH;
    static String ALLMATCH;
    static String NOMATCH;
    static String JOIN;
    static String XID;
    static String ERR1;
    static String ERR2;
    static final String[] LIST_UCD_MAJOR_AXIS;
    static final String[] LIST_UCD_MINOR_AXIS;
    static final String[] LIST_UCD_PA;
    static final String[] xmatchNames;
    Aladin aladin;
    JCheckBox allMatch;
    JCheckBox bestMatch;
    JCheckBox noMatch;
    JCheckBox ellAllMatch;
    JCheckBox ellBestMatch;
    JCheckBox ellNoMatch;
    JTabbedPane tabbedPane;
    JComboBox RAChoiceA;
    JComboBox RAChoiceB;
    JComboBox DEChoiceA;
    JComboBox DEChoiceB;
    JComboBox XIDChoiceA;
    JComboBox XIDChoiceB;
    JComboBox ellRAChoiceA;
    JComboBox ellRAChoiceB;
    JComboBox ellDEChoiceA;
    JComboBox ellDEChoiceB;
    JComboBox ellMAChoiceA;
    JComboBox ellMAChoiceB;
    JComboBox ellMIChoiceA;
    JComboBox ellMIChoiceB;
    JComboBox ellPAChoiceA;
    JComboBox ellPAChoiceB;
    JTextField minDist;
    JTextField maxDist;
    JTextField nbSigmaMin;
    JTextField nbSigmaMax;
    JComboBox labelAXMatch;
    JComboBox labelBXMatch;
    JComboBox labelAXID;
    JComboBox labelBXID;
    JComboBox ellLabelA;
    JComboBox ellLabelB;
    Thread runme;
    JPanel xIDOptionsP;
    private OptionFrame optionFrame;
    Plan[] cats;
    String memPlanA;
    String memPlanB;
    private static String[] tabbedPaneComponents;
    ColFilter colFilterT;
    Plan p1T;
    Plan p2T;
    String labelT;
    double[] seuilsT;
    int index1T;
    int index2T;
    int[] coordTab1T;
    int[] coordTab2T;
    int[] ellipseParam1T;
    int[] ellipseParam2T;
    int methodeT;
    int typeT;

    protected void createChaine() {
        TITRE = Aladin.chaine.getString("XMTITRE");
        CLOSE = Aladin.chaine.getString("CLOSE");
        XMATCH = Aladin.chaine.getString("XMXMATCH");
        POS_XMATCH = Aladin.chaine.getString("XMPOS_XMATCH");
        CROSS_ID = Aladin.chaine.getString("XMCROSS_ID");
        ONLYPOS = Aladin.chaine.getString("XMONLYPOS");
        THRESHOLD = Aladin.chaine.getString("XMTHRESHOLD");
        THRESHOLD1 = Aladin.chaine.getString("XMTHRESHOLD1");
        CHOOSEMATCH = Aladin.chaine.getString("XMCHOOSEMATCH");
        BESTMATCH = Aladin.chaine.getString("XMBESTMATCH");
        ALLMATCH = Aladin.chaine.getString("XMALLMATCH");
        NOMATCH = Aladin.chaine.getString("XMNOMATCH");
        JOIN = Aladin.chaine.getString("XMJOIN");
        XID = Aladin.chaine.getString("XMXID");
        ERR1 = Aladin.chaine.getString("XMERR1");
        ERR2 = Aladin.chaine.getString("XMERR2");
        String[] stringArray = new String[]{POS_XMATCH, CROSS_ID, POS_XMATCH_ELLIPSES};
        tabbedPaneComponents = stringArray;
    }

    public FrameCDSXMatch(Aladin aladin) {
        Aladin.setIcon(this);
        this.aladin = aladin;
        this.createChaine();
        this.setTitle(TITRE);
        Util.setCloseShortcut(this, false, aladin);
        this.setLocation(Aladin.computeLocation(this));
    }

    private void buildFrame() {
        this.getContentPane().removeAll();
        this.getContentPane().setLayout(new BorderLayout());
        this.memPlanB = null;
        this.memPlanA = null;
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 0;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(gridBagLayout);
        JLabel jLabel = new JLabel(TITRE, 0);
        jLabel.setFont(Aladin.LBOLD);
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.addTab(POS_XMATCH, this.posXMatchPanel());
        this.tabbedPane.addTab(CROSS_ID, this.posXIDPanel());
        this.tabbedPane.addTab(POS_XMATCH_ELLIPSES, this.posXMatchEllipsesPanel());
        gridBagLayout.setConstraints(this.tabbedPane, gridBagConstraints);
        jPanel.add(this.tabbedPane);
        this.populateChoicesWithPlanes();
        gridBagLayout.setConstraints(this.tabbedPane, gridBagConstraints);
        jPanel.add(this.tabbedPane);
        this.initComboBoxes();
        this.getContentPane().add((Component)jPanel, "Center");
        JPanel jPanel2 = this.bottomPanel();
        this.getContentPane().add((Component)jPanel2, "South");
        ((JPanel)this.getContentPane()).setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.pack();
    }

    protected void update() {
        this.buildFrame();
        this.setVisible(true);
        this.toFront();
    }

    private JPanel bottomPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1));
        JButton jButton = new JButton(ADVANCED_OPTIONS);
        jPanel.add(jButton);
        jButton.addActionListener(this);
        jButton = new JButton(XMATCH);
        jButton.addActionListener(this);
        jButton.setFont(Aladin.BOLD);
        jPanel.add(jButton);
        jButton = new JButton(CLOSE);
        jPanel.add(jButton);
        jButton.addActionListener(this);
        return jPanel;
    }

    private void initComboBoxes() {
        if (this.cats.length > 0) {
            Plan plan = this.cats[0];
            this.memPlanA = plan.label;
            this.populateRADECChoices(this.RAChoiceA, this.DEChoiceA, plan, true);
            this.labelAXMatch.setSelectedItem(plan.label);
            this.populateRADECChoices(this.XIDChoiceA, null, plan, false);
            this.labelAXID.setSelectedItem(plan.label);
            this.populateRADECChoices(this.ellRAChoiceA, this.ellDEChoiceA, plan, true);
            this.populateChoice(this.ellMAChoiceA, plan, LIST_UCD_MAJOR_AXIS);
            this.populateChoice(this.ellMIChoiceA, plan, LIST_UCD_MINOR_AXIS);
            this.populateChoice(this.ellPAChoiceA, plan, LIST_UCD_PA);
            this.ellLabelA.setSelectedItem(plan.label);
            plan = this.cats.length > 1 ? this.cats[1] : this.cats[0];
            this.memPlanB = plan.label;
            this.populateRADECChoices(this.RAChoiceB, this.DEChoiceB, plan, true);
            this.labelBXMatch.setSelectedItem(plan.label);
            this.populateRADECChoices(this.XIDChoiceB, null, plan, false);
            this.labelBXID.setSelectedItem(plan.label);
            this.populateRADECChoices(this.ellRAChoiceB, this.ellDEChoiceB, plan, true);
            this.populateChoice(this.ellMAChoiceB, plan, LIST_UCD_MAJOR_AXIS);
            this.populateChoice(this.ellMIChoiceB, plan, LIST_UCD_MINOR_AXIS);
            this.populateChoice(this.ellPAChoiceB, plan, LIST_UCD_PA);
            this.ellLabelB.setSelectedItem(plan.label);
        }
    }

    private JPanel posXMatchPanel() {
        this.labelAXMatch = new JComboBox();
        this.labelAXMatch.addActionListener(this);
        this.labelAXMatch.setFont(Aladin.BOLD);
        this.labelBXMatch = new JComboBox();
        this.labelBXMatch.addActionListener(this);
        this.labelBXMatch.setFont(Aladin.BOLD);
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(null, POS_XMATCH, 4, 2, Aladin.BOLD), BorderFactory.createEmptyBorder(5, 5, 5, 5))));
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 0;
        jPanel.setLayout(gridBagLayout);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        JLabel jLabel = new JLabel(ONLYPOS, 0);
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.gridheight = 1;
        gridBagConstraints2.fill = 0;
        gridBagConstraints2.insets = new Insets(0, 3, 0, 3);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(gridBagLayout2);
        JComponent[][] jComponentArray = new JComponent[2][6];
        jComponentArray[0][0] = this.labelAXMatch;
        jComponentArray[1][0] = this.labelBXMatch;
        jComponentArray[0][1] = new JLabel("");
        jComponentArray[1][1] = new JLabel("");
        jComponentArray[0][2] = new JLabel("RA");
        jComponentArray[1][2] = new JLabel("RA");
        this.RAChoiceA = new JComboBox();
        this.RAChoiceB = new JComboBox();
        jComponentArray[0][3] = this.RAChoiceA;
        jComponentArray[1][3] = this.RAChoiceB;
        jComponentArray[0][4] = new JLabel("DEC");
        jComponentArray[1][4] = new JLabel("DEC");
        this.DEChoiceA = new JComboBox();
        this.DEChoiceB = new JComboBox();
        jComponentArray[0][5] = this.DEChoiceA;
        jComponentArray[1][5] = this.DEChoiceB;
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 6; ++j) {
                gridBagConstraints2.gridx = j;
                gridBagConstraints2.gridy = i;
                gridBagConstraints2.anchor = j == 0 ? 17 : 13;
                gridBagConstraints2.fill = jComponentArray[i][j] instanceof JComboBox ? 2 : 0;
                gridBagLayout2.setConstraints(jComponentArray[i][j], gridBagConstraints2);
                jPanel2.add(jComponentArray[i][j]);
            }
        }
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        jPanel.add(jPanel2);
        JPanel jPanel3 = new JPanel();
        GridBagLayout gridBagLayout3 = new GridBagLayout();
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.fill = 0;
        jPanel3.setLayout(gridBagLayout3);
        JLabel jLabel2 = new JLabel(THRESHOLD, 0);
        gridBagConstraints3.gridwidth = 0;
        gridBagConstraints3.anchor = 10;
        gridBagLayout3.setConstraints(jLabel2, gridBagConstraints3);
        jPanel3.add(jLabel2);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new FlowLayout(1));
        this.minDist = new JTextField("0", 4);
        jPanel4.add(this.minDist);
        jPanel4.add(new JLabel(THRESHOLD1));
        this.maxDist = new JTextField("4", 4);
        jPanel4.add(this.maxDist);
        gridBagConstraints3.gridwidth = 0;
        gridBagLayout3.setConstraints(jPanel4, gridBagConstraints3);
        jPanel3.add(jPanel4);
        JLabel jLabel3 = new JLabel(CHOOSEMATCH);
        jLabel3.setFont(Aladin.BOLD);
        gridBagLayout3.setConstraints(jLabel3, gridBagConstraints3);
        jPanel3.add(jLabel3);
        gridBagConstraints3.anchor = 17;
        gridBagConstraints3.insets = new Insets(0, 40, 0, 0);
        this.bestMatch = new JCheckBox(BESTMATCH);
        this.bestMatch.addActionListener(this);
        this.bestMatch.setSelected(true);
        gridBagLayout3.setConstraints(this.bestMatch, gridBagConstraints3);
        jPanel3.add(this.bestMatch);
        this.allMatch = new JCheckBox(ALLMATCH);
        this.allMatch.addActionListener(this);
        gridBagLayout3.setConstraints(this.allMatch, gridBagConstraints3);
        jPanel3.add(this.allMatch);
        this.noMatch = new JCheckBox(NOMATCH);
        this.noMatch.addActionListener(this);
        gridBagLayout3.setConstraints(this.noMatch, gridBagConstraints3);
        jPanel3.add(this.noMatch);
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(jPanel3, gridBagConstraints);
        jPanel.add(jPanel3);
        return jPanel;
    }

    private ColFilter getColFilter() {
        if (this.optionFrame == null) {
            return null;
        }
        this.optionFrame.saveValues();
        Field[] fieldArray = this.getSelectedFields(this.optionFrame.col1);
        Field[] fieldArray2 = this.getSelectedFields(this.optionFrame.col2);
        return new ColFilter(fieldArray, fieldArray2, this.optionFrame.prefix1, this.optionFrame.prefix2, this.optionFrame.suffix1, this.optionFrame.suffix2);
    }

    private Field[] getSelectedFields(ColButton[] colButtonArray) {
        Vector<Field> vector = new Vector<Field>();
        for (int i = 0; i < colButtonArray.length; ++i) {
            if (colButtonArray[i].mode != -1) continue;
            vector.addElement(colButtonArray[i].field);
        }
        Object[] objectArray = new Field[vector.size()];
        vector.copyInto(objectArray);
        vector = null;
        return objectArray;
    }

    private JPanel posXMatchEllipsesPanel() {
        this.ellLabelA = new JComboBox();
        this.ellLabelA.addActionListener(this);
        this.ellLabelA.setFont(Aladin.BOLD);
        this.ellLabelB = new JComboBox();
        this.ellLabelB.addActionListener(this);
        this.ellLabelB.setFont(Aladin.BOLD);
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(null, POS_XMATCH_ELLIPSES, 4, 2, Aladin.BOLD), BorderFactory.createEmptyBorder(5, 5, 5, 5))));
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 0;
        jPanel.setLayout(gridBagLayout);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        JLabel jLabel = new JLabel("Only positional offset is used to find the matches.", 0);
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.gridheight = 1;
        gridBagConstraints2.fill = 0;
        gridBagConstraints2.insets = new Insets(0, 3, 0, 3);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(gridBagLayout2);
        JComponent[][] jComponentArray = new JComponent[4][6];
        JLabel jLabel2 = new JLabel("Catalogue A");
        jLabel2.setFont(Aladin.BOLD);
        jComponentArray[0][0] = jLabel2;
        jLabel2 = new JLabel("Catalogue B");
        jLabel2.setFont(Aladin.BOLD);
        jComponentArray[2][0] = jLabel2;
        jComponentArray[0][1] = this.ellLabelA;
        jComponentArray[2][1] = this.ellLabelB;
        jComponentArray[0][2] = new JLabel("RA");
        jComponentArray[2][2] = new JLabel("RA");
        this.ellRAChoiceA = new JComboBox();
        this.ellRAChoiceB = new JComboBox();
        jComponentArray[0][3] = this.ellRAChoiceA;
        jComponentArray[2][3] = this.ellRAChoiceB;
        jComponentArray[0][4] = new JLabel("DEC");
        jComponentArray[2][4] = new JLabel("DEC");
        this.ellDEChoiceA = new JComboBox();
        this.ellDEChoiceB = new JComboBox();
        jComponentArray[0][5] = this.ellDEChoiceA;
        jComponentArray[2][5] = this.ellDEChoiceB;
        jComponentArray[1][0] = new JLabel("Maj. axis");
        jComponentArray[3][0] = new JLabel("Maj. axis");
        this.ellMAChoiceA = new JComboBox();
        this.ellMAChoiceB = new JComboBox();
        jComponentArray[1][1] = this.ellMAChoiceA;
        jComponentArray[3][1] = this.ellMAChoiceB;
        jComponentArray[1][2] = new JLabel("Min. axis");
        jComponentArray[3][2] = new JLabel("Min. axis");
        this.ellMIChoiceA = new JComboBox();
        this.ellMIChoiceB = new JComboBox();
        jComponentArray[1][3] = this.ellMIChoiceA;
        jComponentArray[3][3] = this.ellMIChoiceB;
        jComponentArray[1][4] = new JLabel("PA");
        jComponentArray[3][4] = new JLabel("PA");
        this.ellPAChoiceA = new JComboBox();
        this.ellPAChoiceB = new JComboBox();
        jComponentArray[1][5] = this.ellPAChoiceA;
        jComponentArray[3][5] = this.ellPAChoiceB;
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 6; ++j) {
                gridBagConstraints2.gridx = j;
                gridBagConstraints2.gridy = i;
                gridBagConstraints2.anchor = j == 0 ? 17 : 13;
                gridBagConstraints2.fill = jComponentArray[i][j] instanceof JComboBox ? 2 : 0;
                gridBagLayout2.setConstraints(jComponentArray[i][j], gridBagConstraints2);
                jPanel2.add(jComponentArray[i][j]);
            }
        }
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        jPanel.add(jPanel2);
        JPanel jPanel3 = new JPanel();
        GridBagLayout gridBagLayout3 = new GridBagLayout();
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.fill = 0;
        jPanel3.setLayout(gridBagLayout3);
        JLabel jLabel3 = new JLabel("Number of sigmas threshold", 0);
        gridBagConstraints3.gridwidth = 0;
        gridBagConstraints3.anchor = 10;
        gridBagLayout3.setConstraints(jLabel3, gridBagConstraints3);
        jPanel3.add(jLabel3);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new FlowLayout(1));
        this.nbSigmaMin = new JTextField("0", 4);
        jPanel4.add(this.nbSigmaMin);
        jPanel4.add(new JLabel("<= nbSigmas <="));
        this.nbSigmaMax = new JTextField("3", 4);
        jPanel4.add(this.nbSigmaMax);
        gridBagConstraints3.gridwidth = 0;
        gridBagLayout3.setConstraints(jPanel4, gridBagConstraints3);
        jPanel3.add(jPanel4);
        JLabel jLabel4 = new JLabel("Choose match method");
        jLabel4.setFont(Aladin.BOLD);
        gridBagLayout3.setConstraints(jLabel4, gridBagConstraints3);
        jPanel3.add(jLabel4);
        gridBagConstraints3.anchor = 17;
        gridBagConstraints3.insets = new Insets(0, 40, 0, 0);
        this.ellBestMatch = new JCheckBox("Best matches");
        this.ellBestMatch.addActionListener(this);
        this.ellBestMatch.setSelected(true);
        gridBagLayout3.setConstraints(this.ellBestMatch, gridBagConstraints3);
        jPanel3.add(this.ellBestMatch);
        this.ellAllMatch = new JCheckBox("All matches");
        this.ellAllMatch.addActionListener(this);
        gridBagLayout3.setConstraints(this.ellAllMatch, gridBagConstraints3);
        jPanel3.add(this.ellAllMatch);
        this.ellNoMatch = new JCheckBox("Sources without match");
        this.ellNoMatch.addActionListener(this);
        gridBagLayout3.setConstraints(this.ellNoMatch, gridBagConstraints3);
        jPanel3.add(this.ellNoMatch);
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(jPanel3, gridBagConstraints);
        jPanel.add(jPanel3);
        return jPanel;
    }

    private JPanel posXIDPanel() {
        this.labelAXID = new JComboBox();
        this.labelAXID.addActionListener(this);
        this.labelAXID.setFont(Aladin.BOLD);
        this.labelBXID = new JComboBox();
        this.labelBXID.addActionListener(this);
        this.labelBXID.setFont(Aladin.BOLD);
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(null, CROSS_ID, 4, 2, Aladin.BOLD), BorderFactory.createEmptyBorder(5, 5, 5, 5))));
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 0;
        jPanel.setLayout(gridBagLayout);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        JLabel jLabel = new JLabel(JOIN, 0);
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.gridheight = 1;
        gridBagConstraints2.fill = 0;
        gridBagConstraints2.insets = new Insets(0, 3, 0, 3);
        this.xIDOptionsP = new JPanel();
        this.xIDOptionsP.setLayout(gridBagLayout2);
        JComponent[][] jComponentArray = new JComponent[2][4];
        jComponentArray[0][0] = this.labelAXID;
        jComponentArray[1][0] = this.labelBXID;
        jComponentArray[0][1] = new JLabel("");
        jComponentArray[1][1] = new JLabel("");
        jComponentArray[0][2] = new JLabel(XID);
        jComponentArray[1][2] = new JLabel(XID);
        this.XIDChoiceA = new JComboBox();
        this.XIDChoiceB = new JComboBox();
        jComponentArray[0][3] = this.XIDChoiceA;
        jComponentArray[1][3] = this.XIDChoiceB;
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 4; ++j) {
                gridBagConstraints2.gridx = j;
                gridBagConstraints2.gridy = i;
                gridBagConstraints2.fill = jComponentArray[i][j] instanceof JComboBox ? 2 : 0;
                gridBagConstraints2.anchor = j == 0 ? 17 : 13;
                gridBagLayout2.setConstraints(jComponentArray[i][j], gridBagConstraints2);
                this.xIDOptionsP.add(jComponentArray[i][j]);
            }
        }
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.xIDOptionsP, gridBagConstraints);
        jPanel.add(this.xIDOptionsP);
        return jPanel;
    }

    private void populateChoicesWithPlanes() {
        Vector<Plan> vector = new Vector<Plan>();
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < this.aladin.calque.plan.length; ++i) {
            Plan plan = this.aladin.calque.plan[i];
            if (!plan.isSimpleCatalog() || !plan.flagOk) continue;
            if (plan.selected && plan.active) {
                vector.insertElementAt(plan, n++);
            } else if (plan.active) {
                vector.insertElementAt(plan, n + n2++);
            } else {
                vector.addElement(plan);
            }
            this.labelAXMatch.addItem(plan.label);
            this.labelAXID.addItem(plan.label);
            this.ellLabelA.addItem(plan.label);
            this.labelBXMatch.addItem(plan.label);
            this.labelBXID.addItem(plan.label);
            this.ellLabelB.addItem(plan.label);
        }
        this.cats = new Plan[vector.size()];
        vector.copyInto(this.cats);
        vector = null;
    }

    private void populateRADECChoices(JComboBox jComboBox, JComboBox jComboBox2, Plan plan, boolean bl) {
        Legende legende;
        jComboBox.removeAllItems();
        if (jComboBox2 != null) {
            if (jComboBox2.getItemCount() > 0) {
                jComboBox2.setSelectedIndex(0);
            }
            jComboBox2.removeAllItems();
        }
        if ((legende = plan.getFirstLegende()) == null) {
            return;
        }
        for (int i = 0; i < legende.field.length; ++i) {
            jComboBox.addItem(legende.field[i].name);
            if (jComboBox2 == null) continue;
            jComboBox2.addItem(legende.field[i].name);
        }
        if (bl) {
            int[] nArray = CDSXMatch.findCoord(plan);
            if (nArray == null) {
                return;
            }
            if (nArray[0] >= 0) {
                jComboBox.setSelectedIndex(nArray[0]);
            }
            if (nArray[1] >= 0 && jComboBox2 != null) {
                jComboBox2.setSelectedIndex(nArray[1]);
            }
        }
    }

    private void populateChoice(JComboBox jComboBox, Plan plan, String[] stringArray) {
        int n;
        jComboBox.removeAllItems();
        Legende legende = plan.getFirstLegende();
        if (plan == null) {
            return;
        }
        for (n = 0; n < legende.field.length; ++n) {
            jComboBox.addItem(legende.field[n].name);
        }
        if (stringArray != null && (n = CDSXMatch.findIdx(plan, stringArray)) >= 0) {
            jComboBox.setSelectedIndex(n);
        }
    }

    @Override
    public void setVisible(boolean bl) {
        this.aladin.toolBox.setMode(17, bl ? -1 : 1);
        super.setVisible(bl);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        Object object = actionEvent.getSource();
        if (string.equals(CLOSE)) {
            this.setVisible(false);
        } else if (string.equals(ADVANCED_OPTIONS)) {
            this.showOptionsFrame();
        } else if (string.equals(XMATCH)) {
            this.launchXMatch();
        } else if (object == this.labelAXMatch || object == this.labelAXID || object == this.ellLabelA) {
            String string2 = ((JComboBox)object).getSelectedItem().toString();
            if (this.memPlanA != null && this.memPlanA.equals(string2)) {
                return;
            }
            this.memPlanA = string2;
            int n = this.aladin.calque.getIndexPlan(string2);
            if (n < 0) {
                return;
            }
            Plan plan = this.aladin.calque.plan[n];
            this.populateRADECChoices(this.RAChoiceA, this.DEChoiceA, plan, true);
            this.populateRADECChoices(this.XIDChoiceA, null, plan, false);
            this.populateRADECChoices(this.ellRAChoiceA, this.ellDEChoiceA, plan, true);
            this.populateChoice(this.ellMAChoiceA, plan, LIST_UCD_MAJOR_AXIS);
            this.populateChoice(this.ellMIChoiceA, plan, LIST_UCD_MINOR_AXIS);
            this.populateChoice(this.ellPAChoiceA, plan, LIST_UCD_PA);
            if (object != this.labelAXMatch) {
                this.labelAXMatch.setSelectedItem(plan.label);
            }
            if (object != this.labelAXID) {
                this.labelAXID.setSelectedItem(plan.label);
            }
            if (object != this.ellLabelA) {
                this.ellLabelA.setSelectedItem(plan.label);
            }
            if (this.optionFrame != null) {
                this.optionFrame.update(plan, this.optionFrame.pc2);
            }
        } else if (object == this.labelBXMatch || object == this.labelBXID || object == this.ellLabelB) {
            String string3 = ((JComboBox)object).getSelectedItem().toString();
            if (this.memPlanB != null && this.memPlanB.equals(string3)) {
                return;
            }
            this.memPlanB = string3;
            int n = this.aladin.calque.getIndexPlan(string3);
            if (n < 0) {
                return;
            }
            Plan plan = this.aladin.calque.plan[n];
            this.populateRADECChoices(this.RAChoiceB, this.DEChoiceB, plan, true);
            this.populateRADECChoices(this.XIDChoiceB, null, plan, false);
            this.populateRADECChoices(this.ellRAChoiceB, this.ellDEChoiceB, plan, true);
            this.populateChoice(this.ellMAChoiceB, plan, LIST_UCD_MAJOR_AXIS);
            this.populateChoice(this.ellMIChoiceB, plan, LIST_UCD_MINOR_AXIS);
            this.populateChoice(this.ellPAChoiceB, plan, LIST_UCD_PA);
            if (object != this.labelBXMatch) {
                this.labelBXMatch.setSelectedItem(plan.label);
            }
            if (object != this.labelBXID) {
                this.labelBXID.setSelectedItem(plan.label);
            }
            if (object != this.ellLabelB) {
                this.ellLabelB.setSelectedItem(plan.label);
            }
            if (this.optionFrame != null) {
                this.optionFrame.update(this.optionFrame.pc1, plan);
            }
        } else if (object.equals(this.allMatch)) {
            if (this.allMatch.isSelected() && this.bestMatch.isSelected()) {
                this.bestMatch.setSelected(false);
            } else if (!this.allMatch.isSelected() && !this.noMatch.isSelected()) {
                this.allMatch.setSelected(true);
            }
        } else if (object.equals(this.bestMatch)) {
            if (this.allMatch.isSelected() && this.bestMatch.isSelected()) {
                this.allMatch.setSelected(false);
            } else if (!this.bestMatch.isSelected() && !this.noMatch.isSelected()) {
                this.bestMatch.setSelected(true);
            }
        } else if (object.equals(this.ellAllMatch)) {
            if (this.ellAllMatch.isSelected() && this.ellBestMatch.isSelected()) {
                this.ellBestMatch.setSelected(false);
            } else if (!this.ellAllMatch.isSelected() && !this.ellNoMatch.isSelected()) {
                this.ellAllMatch.setSelected(true);
            }
        } else if (object.equals(this.ellBestMatch)) {
            if (this.ellAllMatch.isSelected() && this.ellBestMatch.isSelected()) {
                this.ellAllMatch.setSelected(false);
            } else if (!this.ellBestMatch.isSelected() && !this.ellNoMatch.isSelected()) {
                this.ellBestMatch.setSelected(true);
            }
        }
    }

    private void launchXMatch() {
        this.colFilterT = this.getColFilter();
        String string = tabbedPaneComponents[this.tabbedPane.getSelectedIndex()];
        if (string.equals(POS_XMATCH)) {
            this.launchPosXMatch();
        } else if (string.equals(CROSS_ID)) {
            this.launchXID();
        } else if (string.equals(POS_XMATCH_ELLIPSES)) {
            this.launchPosXMatchEllipses();
        }
    }

    private void launchXID() {
        this.typeT = 2;
        this.index1T = this.XIDChoiceA.getSelectedIndex();
        this.index2T = this.XIDChoiceB.getSelectedIndex();
        this.p1T = (PlanCatalog)this.aladin.calque.plan[this.aladin.calque.getIndexPlan(this.labelAXID.getSelectedItem().toString())];
        this.p2T = (PlanCatalog)this.aladin.calque.plan[this.aladin.calque.getIndexPlan(this.labelBXID.getSelectedItem().toString())];
        this.runme = new Thread((Runnable)this, "AladinXmatch");
        Util.decreasePriority(Thread.currentThread(), this.runme);
        this.runme.start();
    }

    private void launchPosXMatch() {
        this.typeT = 1;
        this.methodeT = 0;
        if (this.allMatch.isSelected()) {
            this.methodeT |= 2;
        }
        if (this.bestMatch.isSelected()) {
            this.methodeT |= 1;
        }
        if (this.noMatch.isSelected()) {
            this.methodeT |= 4;
        }
        if (this.methodeT == 0) {
            Aladin.warning(this, ERR1, 1);
            return;
        }
        this.seuilsT = new double[2];
        try {
            this.seuilsT[0] = Double.valueOf(this.minDist.getText());
            this.seuilsT[1] = Double.valueOf(this.maxDist.getText());
        }
        catch (NumberFormatException numberFormatException) {
            Aladin.warning(this, ERR2, 1);
            return;
        }
        this.p1T = this.aladin.calque.plan[this.aladin.calque.getIndexPlan(this.labelAXMatch.getSelectedItem().toString())];
        this.p2T = this.aladin.calque.plan[this.aladin.calque.getIndexPlan(this.labelBXMatch.getSelectedItem().toString())];
        this.coordTab1T = new int[2];
        this.coordTab1T[0] = this.RAChoiceA.getSelectedIndex();
        this.coordTab1T[1] = this.DEChoiceA.getSelectedIndex();
        this.coordTab2T = new int[2];
        this.coordTab2T[0] = this.RAChoiceB.getSelectedIndex();
        this.coordTab2T[1] = this.DEChoiceB.getSelectedIndex();
        this.runme = new Thread((Runnable)this, "AladinXmatchPos");
        Util.decreasePriority(Thread.currentThread(), this.runme);
        this.runme.start();
    }

    private void launchPosXMatchEllipses() {
        this.typeT = 3;
        this.methodeT = 0;
        if (this.ellAllMatch.isSelected()) {
            this.methodeT |= 2;
        }
        if (this.ellBestMatch.isSelected()) {
            this.methodeT |= 1;
        }
        if (this.ellNoMatch.isSelected()) {
            this.methodeT |= 4;
        }
        if (this.methodeT == 0) {
            Aladin.warning(this, "No cross-match method chosen !", 1);
            return;
        }
        this.seuilsT = new double[2];
        try {
            this.seuilsT[0] = Double.valueOf(this.nbSigmaMin.getText());
            this.seuilsT[1] = Double.valueOf(this.nbSigmaMax.getText());
        }
        catch (NumberFormatException numberFormatException) {
            Aladin.warning(this, "Could not parse min or max distance !", 1);
            return;
        }
        this.p1T = (PlanCatalog)this.aladin.calque.plan[this.aladin.calque.getIndexPlan(this.ellLabelA.getSelectedItem().toString())];
        this.p2T = (PlanCatalog)this.aladin.calque.plan[this.aladin.calque.getIndexPlan(this.ellLabelB.getSelectedItem().toString())];
        this.coordTab1T = new int[2];
        this.coordTab1T[0] = this.ellRAChoiceA.getSelectedIndex();
        this.coordTab1T[1] = this.ellDEChoiceA.getSelectedIndex();
        this.coordTab2T = new int[2];
        this.coordTab2T[0] = this.RAChoiceB.getSelectedIndex();
        this.coordTab2T[1] = this.DEChoiceB.getSelectedIndex();
        this.ellipseParam1T = new int[3];
        this.ellipseParam1T[0] = this.ellMAChoiceA.getSelectedIndex();
        this.ellipseParam1T[1] = this.ellMIChoiceA.getSelectedIndex();
        this.ellipseParam1T[2] = this.ellPAChoiceA.getSelectedIndex();
        this.ellipseParam2T = new int[3];
        this.ellipseParam2T[0] = this.ellMAChoiceB.getSelectedIndex();
        this.ellipseParam2T[1] = this.ellMIChoiceB.getSelectedIndex();
        this.ellipseParam2T[2] = this.ellPAChoiceB.getSelectedIndex();
        this.runme = new Thread((Runnable)this, "AladinXmatchEllipse");
        Util.decreasePriority(Thread.currentThread(), this.runme);
        this.runme.start();
    }

    @Override
    public void run() {
        CDSXMatch cDSXMatch = new CDSXMatch(this.aladin);
        cDSXMatch.setColFilter(this.colFilterT);
        if (this.typeT == 1) {
            cDSXMatch.posXMatch(this.p1T, this.p2T, null, this.coordTab1T, this.coordTab2T, this.seuilsT, this.methodeT, this.aladin);
        } else if (this.typeT == 2) {
            cDSXMatch.xID(this.p1T, this.p2T, this.labelT, this.index1T, this.index2T, this.aladin);
        } else if (this.typeT == 3) {
            cDSXMatch.posXMatchEllipses(this.p1T, this.p2T, null, this.coordTab1T, this.coordTab2T, this.ellipseParam1T, this.ellipseParam2T, this.seuilsT[0], this.seuilsT[1], this.methodeT, this.aladin);
        }
    }

    @Override
    public boolean handleEvent(Event event) {
        if (event.id == 201) {
            this.hide();
        }
        return super.handleEvent(event);
    }

    private void showOptionsFrame() {
        if (this.optionFrame == null) {
            this.optionFrame = new OptionFrame(this.aladin);
        }
        PlanCatalog planCatalog = (PlanCatalog)this.aladin.calque.plan[this.aladin.calque.getIndexPlan(this.memPlanA)];
        PlanCatalog planCatalog2 = (PlanCatalog)this.aladin.calque.plan[this.aladin.calque.getIndexPlan(this.memPlanB)];
        this.optionFrame.update(planCatalog, planCatalog2);
        this.optionFrame.setVisible(true);
        this.optionFrame.toFront();
    }

    static {
        LIST_UCD_MAJOR_AXIS = new String[]{"EXTENSION_DIAM", "phys.angSize.smajAxis;pos.errorEllipse", "phys.angSize.smajAxis"};
        LIST_UCD_MINOR_AXIS = new String[]{"EXTENSION_MIN", "phys.angSize.sminAxis;pos.errorEllipse", "phys.angSize.sminAxis"};
        LIST_UCD_PA = new String[]{"POS_POS-ANG", "pos.posAng;pos.errorEllipse", "pos.posAng"};
        xmatchNames = new String[]{POS_XMATCH, CROSS_ID};
    }

    class OptionFrame
    extends JFrame {
        static final String SELECT_ALL = "Select all";
        static final String SELECT_NONE = "Deselect all";
        Aladin aladin;
        String prefix1;
        String prefix2;
        String suffix1;
        String suffix2;
        JButton bAll1;
        JButton bAll2;
        Field[] fields1;
        Field[] fields2;
        JTextField prefix1TF;
        JTextField prefix2TF;
        JTextField suffix1TF;
        JTextField suffix2TF;
        Plan pc1;
        Plan pc2;
        ColButton[] col1;
        ColButton[] col2;
        JLabel ucdLabel;
        Vector conflict;

        OptionFrame(Aladin aladin) {
            super("Options for xmatch ouput");
            this.prefix1 = "";
            this.prefix2 = "";
            this.suffix1 = "_tab1";
            this.suffix2 = "_tab2";
            this.conflict = new Vector();
            this.aladin = aladin;
            Aladin.setIcon(this);
            Util.setCloseShortcut(this, false, aladin);
            this.getContentPane().setLayout(new BorderLayout());
            this.setLocation(100, 100);
        }

        void hilightBtnsWithUcd(String string) {
            this.conflict.clear();
            this.hilightBtnsWithUcd(string, this.col1);
            this.hilightBtnsWithUcd(string, this.col2);
            if (this.conflict.size() >= 2) {
                Enumeration enumeration = this.conflict.elements();
                while (enumeration.hasMoreElements()) {
                    ((ColButton)enumeration.nextElement()).hilight(true, Color.RED);
                }
            }
        }

        void hilightBtnsWithUcd(String string, ColButton[] colButtonArray) {
            if (string != null) {
                string = this.getUcdRoot(string.toLowerCase());
            }
            for (int i = 0; i < colButtonArray.length; ++i) {
                if (string == null) {
                    colButtonArray[i].hilight(false);
                    continue;
                }
                if (colButtonArray[i].field.ucd == null || colButtonArray[i].field.ucd.length() == 0) continue;
                String string2 = colButtonArray[i].field.ucd.toLowerCase();
                String string3 = this.getUcdRoot(string2);
                if (string3.equals(string)) {
                    colButtonArray[i].hilight(true);
                    if (string2.indexOf(";meta.main") < 0 && string2.indexOf("_main") < 0) continue;
                    this.conflict.addElement(colButtonArray[i]);
                    continue;
                }
                if (!colButtonArray[i].hl) continue;
                colButtonArray[i].hilight(false);
            }
        }

        private String getUcdRoot(String string) {
            String string2 = string.toLowerCase();
            int n = string2.indexOf(";meta.main");
            if (n < 0) {
                n = string2.indexOf("_main");
            }
            if (n >= 0) {
                string2 = string2.substring(0, n);
            }
            return string2;
        }

        void update(Plan plan, Plan plan2) {
            this.pc1 = plan;
            this.pc2 = plan2;
            if (this.prefix1TF != null) {
                this.saveValues();
            }
            this.getContentPane().removeAll();
            this.buildFrame();
        }

        private void buildFrame() {
            JPanel jPanel = new JPanel();
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(0, 5, 0, 5);
            gridBagConstraints.fill = 1;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.5;
            jPanel.setLayout(gridBagLayout);
            jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(null, "Output options", 2, 2, Aladin.BOLD), BorderFactory.createEmptyBorder(5, 5, 5, 5))));
            this.prefix1TF = new JTextField(this.prefix1, 5);
            this.suffix1TF = new JTextField(this.suffix1, 5);
            JPanel jPanel2 = this.getPanelForCat("Catalogue A : " + this.pc1.getLabel(), this.pc1, this.prefix1TF, this.suffix1TF, this.col1, this.fields1, true);
            gridBagConstraints.anchor = 17;
            gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
            jPanel.add(jPanel2);
            this.prefix2TF = new JTextField(this.prefix2, 5);
            this.suffix2TF = new JTextField(this.suffix2, 5);
            JPanel jPanel3 = this.getPanelForCat("Catalogue B : " + this.pc2.getLabel(), this.pc2, this.prefix2TF, this.suffix2TF, this.col2, this.fields2, false);
            gridBagConstraints.anchor = 17;
            gridBagLayout.setConstraints(jPanel3, gridBagConstraints);
            jPanel.add(jPanel3);
            gridBagConstraints.anchor = 10;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            JLabel jLabel = new JLabel("UCD: ");
            jLabel.setFont(Aladin.ITALIC);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridwidth = -1;
            gridBagLayout.setConstraints(jLabel, gridBagConstraints);
            jPanel.add(jLabel);
            this.ucdLabel = new JLabel("                                  ");
            this.ucdLabel.setFont(Aladin.BOLD);
            this.ucdLabel.setForeground(Aladin.MYBLUE);
            gridBagConstraints.fill = 1;
            gridBagConstraints.gridwidth = 0;
            gridBagLayout.setConstraints(this.ucdLabel, gridBagConstraints);
            jPanel.add(this.ucdLabel);
            this.getContentPane().add((Component)jPanel, "Center");
            this.getContentPane().add((Component)this.bottomPanel(), "South");
            this.pack();
        }

        JPanel getPanelForCat(String string, Plan plan, JTextField jTextField, JTextField jTextField2, ColButton[] colButtonArray, Field[] fieldArray, boolean bl) {
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 3));
            jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2), BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(null, string, 4, 2, Aladin.LITALIC), BorderFactory.createEmptyBorder(2, 2, 2, 2))));
            JPanel jPanel2 = new JPanel(new FlowLayout());
            JLabel jLabel = new JLabel("Column prefix");
            jPanel2.add(jLabel);
            jPanel2.add(jTextField);
            JLabel jLabel2 = new JLabel("Column suffix");
            jPanel2.add(jLabel2);
            jPanel2.add(jTextField2);
            jPanel.add(jPanel2);
            jPanel.add(Box.createRigidArea(new Dimension(0, 10)));
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout(new BoxLayout(jPanel3, 3));
            jPanel3.setBorder(BorderFactory.createTitledBorder(null, "Choose columns to keep", 2, 2));
            JButton jButton = new JButton(SELECT_NONE);
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    OptionFrame.this.switchState((JButton)actionEvent.getSource());
                }
            });
            jButton.setFont(Aladin.ITALIC);
            jButton.setForeground(Color.blue);
            jButton.setAlignmentX(0.5f);
            jPanel3.add(jButton);
            if (bl) {
                this.bAll1 = jButton;
            } else {
                this.bAll2 = jButton;
            }
            JPanel jPanel4 = this.createButtons(plan, colButtonArray, fieldArray, bl);
            jPanel4.setAlignmentY(0.5f);
            jPanel3.add(jPanel4);
            jPanel.add(jPanel3);
            return jPanel;
        }

        private JPanel createButtons(Plan plan, ColButton[] colButtonArray, Field[] fieldArray, boolean bl) {
            fieldArray = plan.getFirstLegende().field;
            int n = 4;
            int n2 = 5;
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new GridLayout(0, n, 0, 0));
            colButtonArray = new ColButton[fieldArray.length];
            boolean bl2 = fieldArray.length > n * n2;
            int n3 = 0;
            FontMetrics fontMetrics = null;
            if (bl2) {
                fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(Aladin.SPLAIN);
            }
            for (int i = 0; i < fieldArray.length; ++i) {
                int n4;
                colButtonArray[i] = new ColButton(this.aladin, fieldArray[i].name, fieldArray[i]);
                colButtonArray[i].setFont(Aladin.SPLAIN);
                if (bl2 && (n4 = fontMetrics.stringWidth(fieldArray[i].name)) > n3) {
                    n3 = n4;
                }
                jPanel.add(colButtonArray[i]);
            }
            if (bl) {
                this.col1 = colButtonArray;
                this.fields1 = fieldArray;
            } else {
                this.col2 = colButtonArray;
                this.fields2 = fieldArray;
            }
            if (bl2) {
                ScrollPane scrollPane = new ScrollPane(0);
                scrollPane.setSize((n3 + 20) * n + 30, 140);
                scrollPane.add(jPanel);
                JPanel jPanel2 = new JPanel();
                jPanel2.add(scrollPane);
                return jPanel2;
            }
            return jPanel;
        }

        private void saveValues() {
            this.prefix1 = this.prefix1TF.getText();
            this.prefix2 = this.prefix2TF.getText();
            this.suffix1 = this.suffix1TF.getText();
            this.suffix2 = this.suffix2TF.getText();
        }

        private JPanel bottomPanel() {
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new FlowLayout(1));
            JButton jButton = new JButton(CLOSE);
            jPanel.add(jButton);
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    OptionFrame.this.setVisible(false);
                }
            });
            return jPanel;
        }

        private void switchState(JButton jButton) {
            boolean bl = jButton.getText().equals(SELECT_ALL);
            this.selectAll(bl, jButton == this.bAll1 ? this.col1 : this.col2);
            jButton.setText(bl ? SELECT_NONE : SELECT_ALL);
        }

        private void selectAll(boolean bl, ColButton[] colButtonArray) {
            for (int i = 0; i < colButtonArray.length; ++i) {
                if (bl) {
                    colButtonArray[i].push();
                    continue;
                }
                colButtonArray[i].pop();
            }
        }

        @Override
        public boolean handleEvent(Event event) {
            if (event.id == 201) {
                this.setVisible(false);
            }
            return super.handleEvent(event);
        }
    }

    class ColButton
    extends MyButton {
        Field field;
        Color hlColor;
        boolean hl;

        ColButton(Aladin aladin, String string, Field field) {
            super(aladin, string);
            this.hlColor = Color.black;
            this.hl = false;
            this.enableEvents(64L);
            this.field = field;
            this.setAlwaysUp(true);
            this.push();
        }

        private void hilight(boolean bl) {
            this.hilight(bl, Aladin.MYBLUE);
        }

        private void hilight(boolean bl, Color color) {
            Color color2;
            this.hl = bl;
            Color color3 = color2 = bl ? color : Color.black;
            if (!color2.equals(this.hlColor)) {
                this.hlColor = color2;
                this.repaint();
            }
        }

        @Override
        void draw(Graphics graphics) {
            if (this.getColor() == Aladin.GREEN && !this.hl) {
                graphics.setColor(Aladin.MYBLUE);
                graphics.fillRect(1, 1, this.W - 2, this.H - 2);
            } else {
                if (!this.hl) {
                    graphics.setColor(this.getBackground());
                } else {
                    graphics.setColor(this.hlColor);
                }
                graphics.fillRect(0, 0, this.W, this.H);
            }
            if (this.mode == -1) {
                graphics.setColor(this.hl ? this.hlColor : Color.gray);
                graphics.fillRect(0, 1, this.W, this.H - 1);
            }
            if (this.image != null) {
                int n = this.image.getHeight(this);
                if (n > this.H) {
                    graphics.drawImage(this.image, 2, 2, this.W - 4, this.H - 4, this);
                } else {
                    graphics.drawImage(this.image, 2, 2 + (this.H - n) / 2, this);
                }
            }
            graphics.setColor(Color.black);
            if (this.type != 0 && this.mode == -1) {
                graphics.setColor(Color.black);
                graphics.drawLine(0, 1, this.W - 1, 1);
                if (this.type != 3) {
                    graphics.drawLine(0, 1, 0, this.H - 1);
                }
                graphics.setColor(Color.white);
                if (this.type != 4) {
                    graphics.drawLine(1, this.H - 1, this.W - 1, this.H - 1);
                }
                if (this.type != 2) {
                    graphics.drawLine(this.W - 1, 1, this.W - 1, this.H - 1);
                }
            } else if (!this.modeMenu || this.modeMenu && this.getColor() == Aladin.GREEN) {
                graphics.setColor(this.mode != -1 ? Color.white : Color.darkGray);
                graphics.drawLine(1, 1, this.W - 2, 1);
                graphics.drawLine(1, 1, 1, this.H - 2);
                graphics.setColor(this.mode != -1 ? Color.darkGray : Color.white);
                graphics.drawLine(this.W - 2, 1, this.W - 2, this.H - 2);
                graphics.drawLine(this.W - 2, this.H - 2, 1, this.H - 2);
            }
            if (this.withTriangle) {
                graphics.setColor(this.mode == -1 ? LIGHT_GREY : GREY);
                graphics.drawLine(this.W - 16, this.H / 2 + 5, this.W - 9, this.H / 2 + 1);
                graphics.setColor(this.mode == -1 ? GREY : LIGHT_GREY);
                graphics.drawLine(this.W - 9, this.H / 2, this.W - 16, this.H / 2 - 4);
                graphics.drawLine(this.W - 16, this.H / 2 - 3, this.W - 16, this.H / 2 + 5);
            }
        }

        private void switchUcdMain() {
            String string = this.field.ucd;
            if (string == null) {
                return;
            }
            int n = string.toLowerCase().indexOf(";meta.main");
            String string2 = n >= 0 ? string.substring(0, n) : ((n = string.toLowerCase().indexOf("_main")) >= 0 ? string.substring(0, n) : (string.toUpperCase().equals(string) ? string + "_MAIN" : string + ";meta.main"));
            this.field.ucd = string2;
            ((FrameCDSXMatch)FrameCDSXMatch.this).optionFrame.ucdLabel.setText(this.field.ucd == null ? "" : this.field.ucd);
            FrameCDSXMatch.this.optionFrame.hilightBtnsWithUcd(this.field.ucd);
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.pm == null) {
                this.postEvent(new Event(new JButton(this.text), 1001, this.text));
            }
            if ((mouseEvent.getModifiers() & 2) > 0) {
                this.switchUcdMain();
                return;
            }
            if (this.mode == -1) {
                this.pop();
            } else if (this.mode == 1) {
                this.push();
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            if (FrameCDSXMatch.this.optionFrame != null && ((FrameCDSXMatch)FrameCDSXMatch.this).optionFrame.ucdLabel != null && this.field != null) {
                ((FrameCDSXMatch)FrameCDSXMatch.this).optionFrame.ucdLabel.setText(this.field.ucd == null ? "" : this.field.ucd);
                FrameCDSXMatch.this.optionFrame.hilightBtnsWithUcd(this.field.ucd);
            }
            super.mouseEntered(mouseEvent);
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            if (FrameCDSXMatch.this.optionFrame != null && ((FrameCDSXMatch)FrameCDSXMatch.this).optionFrame.ucdLabel != null) {
                ((FrameCDSXMatch)FrameCDSXMatch.this).optionFrame.ucdLabel.setText("");
                FrameCDSXMatch.this.optionFrame.hilightBtnsWithUcd(null);
            }
            super.mouseExited(mouseEvent);
        }
    }
}

