/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.CanvasColorMap;
import cds.aladin.CanvasPixelRange;
import cds.aladin.Plan;
import cds.aladin.PlanBG;
import cds.aladin.PlanImage;
import cds.aladin.PlanImageRGB;
import cds.tools.Util;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.image.IndexColorModel;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public final class FrameColorMap
extends JFrame
implements MouseListener {
    public static final String[] CM = new String[]{"gray", "BB", "A", "stern"};
    public static final String[] CMA = new String[]{"gray", "BB", "A", "stern"};
    private String CMTITRE;
    private String CMREVERSE;
    private String CMLIMITS;
    private String CMERRORRANGE;
    private String CMRESET;
    private String CMLOCALCUT;
    private String CMCLOSE;
    private String CMONVIEW;
    private String CMAPPLYALL;
    private String CMAPPLYCCD;
    private String CMMETHODERGB;
    private String CMMESSAGE;
    private String CMPIXTOOL;
    private String CMPREVIEW;
    private String CMFULLFITS;
    private String CMLOCALCUTTIP;
    private String CMMESSAGE1;
    private String CMMESSAGE2;
    private String CMAPPLYALLTIP;
    private String CMAPPLYCCDTIP;
    private String CMMETHOD;
    private String CMRESET1TIP;
    private String CMRESET2TIP;
    private String CMBACK;
    private String CMBACKTIP;
    private String CMNOCUT;
    private String CMNOCUTTIP;
    private String CMPREVIEWTIP;
    private String CMFULLFITSTIP;
    private String CMPIXTOOLTIP;
    private String CMONVIEWTIP;
    protected String CMCM;
    protected String CMRANGE;
    protected String CMRANGE1;
    private PlanImage pimg;
    private boolean isPlanImageRGB = false;
    private boolean isPlanBGRGB = false;
    private Vector<PlanImage> vimg;
    private Aladin aladin;
    private CanvasPixelRange canvasPixelRange = null;
    protected CanvasColorMap cm = null;
    protected CanvasColorMap cm2 = null;
    protected CanvasColorMap cm3 = null;
    private JPanel p = null;
    private JTextField pixelCutMinField;
    private JTextField pixelCutMaxField;
    private JComboBox<String> comboCM;
    private JButton localCutButton;
    private JButton getAllButton;
    private JButton resetAllButton;
    private JButton resetDistribButton;
    private JButton resetCMButton;
    private JButton applyOnAll;
    private JComboBox<String> cmCombo;
    private JComboBox<String> fctCombo;
    private JCheckBox reverseCb;
    private JRadioButton rPreview;
    private JRadioButton rFull;
    private DefaultConf defaultConf = new DefaultConf();
    private int imgID = -1;
    private static Insets MARGIN = new Insets(1, 3, 1, 3);

    protected void createChaine() {
        this.CMTITRE = Aladin.chaine.getString("CMTITRE");
        this.CMREVERSE = Aladin.chaine.getString("CMREVERSE");
        this.CMLIMITS = Aladin.chaine.getString("CMLIMITS");
        this.CMERRORRANGE = Aladin.chaine.getString("CMERRORRANGE");
        this.CMRESET = Aladin.chaine.getString("CMRESET");
        this.CMLOCALCUT = Aladin.chaine.getString("CMLOCALCUT");
        this.CMLOCALCUTTIP = Aladin.chaine.getString("CMLOCALCUTTIP");
        this.CMNOCUT = Aladin.chaine.getString("CMNOCUT");
        this.CMNOCUTTIP = Aladin.chaine.getString("CMNOCUTTIP");
        this.CMCLOSE = Aladin.chaine.getString("CMCLOSE");
        this.CMAPPLYALL = Aladin.chaine.getString("CMAPPLYALL");
        this.CMAPPLYCCD = Aladin.chaine.getString("CMAPPLYCCD");
        this.CMAPPLYALLTIP = Aladin.chaine.getString("CMAPPLYALLTIP");
        this.CMAPPLYCCDTIP = Aladin.chaine.getString("CMAPPLYCCDTIP");
        this.CMMETHODERGB = Aladin.chaine.getString("CMMETHODERGB");
        this.CMMESSAGE = Aladin.chaine.getString("CMMESSAGE");
        this.CMMESSAGE1 = Aladin.chaine.getString("CMMESSAGE1");
        this.CMMESSAGE2 = Aladin.chaine.getString("CMMESSAGE2");
        this.CMPIXTOOL = Aladin.chaine.getString("CMPIXTOOL");
        this.CMONVIEW = Aladin.chaine.getString("CMONVIEW");
        this.CMPREVIEW = Aladin.chaine.getString("CMPREVIEW");
        this.CMFULLFITS = Aladin.chaine.getString("CMFULLFITS");
        this.CMMETHOD = Aladin.chaine.getString("CMMETHOD");
        this.CMRESET1TIP = Aladin.chaine.getString("CMRESET1TIP");
        this.CMRESET2TIP = Aladin.chaine.getString("CMRESET2TIP");
        this.CMBACK = Aladin.chaine.getString("CMBACK");
        this.CMBACKTIP = Aladin.chaine.getString("CMBACKTIP");
        this.CMCM = Aladin.chaine.getString("CMCM");
        this.CMRANGE = Aladin.chaine.getString("CMRANGE");
        this.CMRANGE1 = Aladin.chaine.getString("CMRANGE1");
        this.CMPREVIEWTIP = Aladin.chaine.getString("CMPREVIEWTIP");
        this.CMFULLFITSTIP = Aladin.chaine.getString("CMFULLFITSTIP");
        this.CMPIXTOOLTIP = Aladin.chaine.getString("CMPIXTOOLTIP");
        this.CMONVIEWTIP = Aladin.chaine.getString("CMONVIEWTIP");
    }

    protected FrameColorMap(Aladin aladin) {
        this.aladin = aladin;
        Aladin.setIcon(this);
        this.createChaine();
        this.setTitle(this.CMTITRE);
        this.enableEvents(64L);
        Util.setCloseShortcut(this, true, aladin);
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        this.setLocation(Aladin.computeLocation(this));
        this.addMouseListener(this);
    }

    void majCMByScript(PlanImage planImage) {
        if (planImage != this.pimg || planImage instanceof PlanImageRGB || planImage instanceof PlanBG && ((PlanBG)this.pimg).isColored()) {
            return;
        }
        this.pixelCutMinField.setText(planImage.getDataMinInfo());
        this.pixelCutMaxField.setText(planImage.getDataMaxInfo());
        this.comboCM.setSelectedIndex(planImage.typeCM);
    }

    protected void majCM() {
        this.majCM(false);
    }

    protected void majCM(boolean bl) {
        if (bl) {
            this.pimg = null;
        }
        if (this.aladin.toolBox.tool[9].mode == -1) {
            this.memoControl();
            PlanImage planImage = this.aladin.calque.getFirstSelectedPlanImage();
            if (this.pimg != null && this.pimg.selected && !planImage.isPixel()) {
                planImage = this.pimg;
            }
            if (planImage != null && planImage.flagOk) {
                if (this.p == null || this.pimg != planImage) {
                    this.setTitle(this.CMTITRE + ": " + planImage.label);
                    this.initCM(planImage);
                    this.showCM();
                    if (!this.isPlanImageRGB && !this.isPlanBGRGB) {
                        this.cm.getCM();
                    }
                } else {
                    int n = this.pimg.getImgID();
                    if (this.imgID == -1 || this.imgID != n) {
                        this.cm.repaint();
                        if (this.cm2 != null) {
                            this.cm2.repaint();
                        }
                        if (this.cm3 != null) {
                            this.cm3.repaint();
                        }
                        this.imgID = n;
                    }
                }
                if (!this.isVisible()) {
                    this.setVisible(true);
                }
                return;
            }
        }
        if (this.isVisible()) {
            this.dispose();
        }
    }

    protected void blinkUpdate(Plan plan) {
        if (this.pimg != plan) {
            return;
        }
        this.pimg.resetHist();
        this.imgID = -1;
        if (this.isVisible()) {
            this.majCM();
        }
    }

    protected void initCM(PlanImage planImage) {
        if (planImage == null) {
            return;
        }
        this.pimg = planImage;
        this.isPlanImageRGB = planImage instanceof PlanImageRGB;
        boolean bl = this.isPlanBGRGB = planImage instanceof PlanBG && ((PlanBG)planImage).isColored();
        if (this.isPlanImageRGB) {
            PlanImageRGB planImageRGB = (PlanImageRGB)planImage;
            if (planImageRGB.flagRed) {
                this.cm = new CanvasColorMap(this, planImage, 0);
            }
            if (planImageRGB.flagGreen) {
                this.cm2 = new CanvasColorMap(this, planImage, 1);
            }
            if (planImageRGB.flagBlue) {
                this.cm3 = new CanvasColorMap(this, planImage, 2);
            }
            this.cm.setOtherColorMap(this.cm2, this.cm3);
            if (this.cm2 != null) {
                this.cm2.setOtherColorMap(this.cm, this.cm3);
            }
            if (this.cm3 != null) {
                this.cm3.setOtherColorMap(this.cm, this.cm2);
            }
        } else if (this.isPlanBGRGB) {
            this.cm = new CanvasColorMap(this, planImage, 0);
            this.cm2 = new CanvasColorMap(this, planImage, 1);
            this.cm3 = new CanvasColorMap(this, planImage, 2);
            this.cm.setOtherColorMap(this.cm2, this.cm3);
            this.cm2.setOtherColorMap(this.cm, this.cm3);
            this.cm3.setOtherColorMap(this.cm, this.cm2);
        } else {
            this.canvasPixelRange = new CanvasPixelRange(this, planImage);
            this.cm = new CanvasColorMap(this, planImage);
        }
    }

    private void switchMode(PlanBG planBG) {
        planBG.switchFormat();
        this.showCM();
        this.aladin.view.repaintAll();
    }

    protected void showCM() {
        if (this.isPlanImageRGB || this.isPlanBGRGB) {
            this.showCMRGB();
        } else {
            this.showCMGrey();
        }
        this.resumeWidgets();
    }

    protected void resumeWidgets() {
        boolean bl;
        int n = this.pimg.typeCM;
        int n2 = this.pimg.getTransfertFct();
        int n3 = this.pimg.video;
        boolean bl2 = this.pimg.hasAvailablePixels();
        boolean bl3 = this.pimg instanceof PlanBG && (((PlanBG)this.pimg).inJPEG || ((PlanBG)this.pimg).inPNG) || !bl2;
        boolean bl4 = this.pimg instanceof PlanBG && ((PlanBG)this.pimg).inFits || bl2;
        boolean bl5 = this.pimg.pixelMin == this.pimg.dataMin && this.pimg.pixelMax == this.pimg.dataMax;
        boolean bl6 = bl = this.pimg.aladin.calque.getSelectedImagesWithPixels().size() >= 2;
        if (this.localCutButton != null) {
            this.localCutButton.setEnabled(bl2);
        }
        if (this.getAllButton != null) {
            this.getAllButton.setEnabled(bl2 && !bl5);
        }
        if (this.applyOnAll != null) {
            this.applyOnAll.setEnabled(bl && bl2 || this.pimg.planMultiCCD != null);
        }
        if (this.applyOnAll != null) {
            this.applyOnAll.setText(this.pimg.planMultiCCD != null ? this.CMAPPLYCCD : this.CMAPPLYALL);
            Util.toolTip(this.applyOnAll, this.pimg.planMultiCCD != null ? this.CMAPPLYCCDTIP : this.CMAPPLYALLTIP, true);
        }
        if (this.rFull != null) {
            this.rFull.setSelected(bl2);
            this.rFull.setEnabled(bl4);
        }
        if (this.rPreview != null) {
            this.rPreview.setSelected(!bl2);
            this.rPreview.setEnabled(bl3);
        }
        if (this.resetAllButton != null) {
            this.resetAllButton.setEnabled(this.defaultConf.isModif());
        }
        if (this.resetDistribButton != null) {
            this.resetDistribButton.setEnabled(this.defaultConf.isModifTriangle());
        }
        if (this.resetCMButton != null) {
            this.resetCMButton.setEnabled(this.defaultConf.isModifCM());
        }
        if (this.reverseCb != null) {
            this.reverseCb.setSelected(n3 == 1);
        }
        if (this.cmCombo != null) {
            this.cmCombo.setSelectedIndex(n);
        }
        if (this.fctCombo != null) {
            this.fctCombo.setSelectedIndex(n2);
        }
        if (this.pixelCutMinField != null) {
            this.pixelCutMinField.setText(this.pimg.getPixelMinInfo());
            this.pixelCutMinField.setEnabled(bl2);
        }
        if (this.pixelCutMaxField != null) {
            this.pixelCutMaxField.setText(this.pimg.getPixelMaxInfo());
            this.pixelCutMaxField.setEnabled(bl2);
        }
        if (this.aladin.frameAllsky != null) {
            this.aladin.frameAllsky.updateCurrentCM();
        }
        this.cm.resumePixelTool();
        if (this.canvasPixelRange != null) {
            this.canvasPixelRange.repaint();
        }
        this.cm.repaint();
        this.pimg.aladin.calque.repaintAll();
        this.defaultConf.memo();
    }

    private JPanel createPanelTop() {
        JButton jButton;
        JRadioButton jRadioButton;
        ButtonGroup buttonGroup = new ButtonGroup();
        JPanel jPanel = new JPanel(new BorderLayout(0, 0));
        JPanel jPanel2 = new JPanel(new FlowLayout());
        this.rPreview = jRadioButton = new JRadioButton(this.CMPREVIEW);
        jPanel2.add(jRadioButton);
        buttonGroup.add(jRadioButton);
        Util.toolTip(jRadioButton, this.CMPREVIEWTIP, true);
        jRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FrameColorMap.this.switchMode((PlanBG)FrameColorMap.this.pimg);
            }
        });
        this.rFull = jRadioButton = new JRadioButton(this.CMFULLFITS);
        jPanel2.add(jRadioButton);
        buttonGroup.add(jRadioButton);
        Util.toolTip(jRadioButton, this.CMFULLFITSTIP, true);
        jRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FrameColorMap.this.switchMode((PlanBG)FrameColorMap.this.pimg);
            }
        });
        jPanel.add((Component)jPanel2, "West");
        JPanel jPanel3 = new JPanel(new FlowLayout());
        this.localCutButton = jButton = this.getButton(this.CMLOCALCUT);
        Util.toolTip(jButton, this.CMLOCALCUTTIP, true);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FrameColorMap.this.localcut();
                FrameColorMap.this.resumeWidgets();
            }
        });
        jPanel3.add(jButton);
        this.getAllButton = jButton = this.getButton(this.CMNOCUT);
        Util.toolTip(jButton, this.CMNOCUTTIP, true);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FrameColorMap.this.getAll();
                FrameColorMap.this.resumeWidgets();
            }
        });
        jPanel3.add(jButton);
        this.resetAllButton = jButton = this.getButton(this.CMBACK);
        Util.toolTip(jButton, this.CMBACKTIP, true);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FrameColorMap.this.defaultConf.resetAll();
                FrameColorMap.this.resumeWidgets();
            }
        });
        jPanel3.add(jButton);
        jPanel3.add(Util.getHelpButton(this, this.CMMESSAGE));
        jPanel.add((Component)jPanel3, "East");
        return jPanel;
    }

    private JPanel createPanelDistribution() {
        JPanel jPanel = new JPanel(new BorderLayout(0, 2));
        jPanel.add((Component)this.createPanelPixelCut(), "North");
        jPanel.add((Component)this.cm, "Center");
        jPanel.add((Component)this.createPanelClose(), "South");
        JPanel jPanel2 = new JPanel(new GridLayout(2, 1, 0, 140));
        JButton jButton = Util.getHelpButton(this, this.CMMESSAGE1);
        jPanel2.add(jButton);
        jButton = Util.getHelpButton(this, this.CMMESSAGE2);
        jPanel2.add(jButton);
        JPanel jPanel3 = new JPanel(new FlowLayout());
        jPanel3.add(jPanel2);
        jPanel3.add(jPanel);
        jPanel3.add(this.createPanelDistributionButton());
        return jPanel3;
    }

    private JPanel createPanelDistributionButton() {
        JCheckBox jCheckBox;
        JButton jButton;
        GridBagLayout gridBagLayout = new GridBagLayout();
        JPanel jPanel = new JPanel(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        JLabel jLabel = new JLabel(Util.fold(this.CMMETHOD, 30, true));
        jLabel.setForeground(Aladin.MYBLUE);
        gridBagConstraints.insets.bottom = 10;
        gridBagConstraints.insets.top = 10;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        this.resetDistribButton = jButton = this.getButton(this.CMRESET);
        Util.toolTip(jButton, this.CMRESET1TIP, true);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FrameColorMap.this.defaultConf.resetTriangle();
                FrameColorMap.this.resumeWidgets();
            }
        });
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets.top = 2;
        gridBagConstraints.insets.bottom = 2;
        ++gridBagConstraints.gridy;
        gridBagLayout.setConstraints(jButton, gridBagConstraints);
        jPanel.add(jButton);
        this.reverseCb = jCheckBox = new JCheckBox(this.CMREVERSE);
        jCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FrameColorMap.this.reverse();
                FrameColorMap.this.resumeWidgets();
            }
        });
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets.top = 25;
        ++gridBagConstraints.gridy;
        gridBagConstraints.anchor = 21;
        gridBagLayout.setConstraints(jCheckBox, gridBagConstraints);
        jPanel.add(jCheckBox);
        JPanel jPanel2 = new JPanel(new GridLayout(1, 2, 1, 1));
        JComboBox<String> jComboBox = FrameColorMap.createComboCM();
        this.cmCombo = jComboBox;
        jComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FrameColorMap.this.changeCM((JComboBox)actionEvent.getSource());
                FrameColorMap.this.resumeWidgets();
            }
        });
        jPanel2.add(jComboBox);
        jComboBox = FrameColorMap.createComboFct();
        this.fctCombo = jComboBox;
        jComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FrameColorMap.this.changeTransfertFct();
                FrameColorMap.this.resumeWidgets();
            }
        });
        jPanel2.add(jComboBox);
        gridBagConstraints.insets.top = 2;
        ++gridBagConstraints.gridy;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        jPanel.add(jPanel2);
        this.resetCMButton = jButton = this.getButton(this.CMRESET);
        Util.toolTip(jButton, this.CMRESET2TIP, true);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FrameColorMap.this.defaultConf.resetCM();
                FrameColorMap.this.resumeWidgets();
            }
        });
        gridBagConstraints.gridwidth = 1;
        ++gridBagConstraints.gridy;
        gridBagLayout.setConstraints(jButton, gridBagConstraints);
        jPanel.add(jButton);
        jButton = this.getButton(this.CMONVIEW);
        Util.toolTip(jButton, this.CMONVIEWTIP, true);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ((FrameColorMap)FrameColorMap.this).aladin.view.showRainbow(true);
                ((FrameColorMap)FrameColorMap.this).aladin.view.repaintAll();
            }
        });
        ++gridBagConstraints.gridx;
        gridBagConstraints.anchor = 22;
        gridBagLayout.setConstraints(jButton, gridBagConstraints);
        jPanel.add(jButton);
        return jPanel;
    }

    private JPanel createPanelPixelCut() {
        JPanel jPanel = new JPanel(new BorderLayout(0, 0));
        jPanel.setBorder(BorderFactory.createEmptyBorder());
        this.pixelCutMinField = new JTextField(this.pimg.getPixelMinInfo(), 8);
        this.pixelCutMinField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    FrameColorMap.this.changeCut();
                }
            }
        });
        jPanel.add((Component)this.pixelCutMinField, "West");
        this.pixelCutMaxField = new JTextField(this.pimg.getPixelMaxInfo(), 8);
        this.pixelCutMaxField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    FrameColorMap.this.changeCut();
                }
            }
        });
        jPanel.add((Component)this.pixelCutMaxField, "East");
        JPanel jPanel2 = new JPanel();
        JLabel jLabel = new JLabel(this.CMLIMITS);
        jLabel.setForeground(Aladin.MYBLUE);
        jPanel2.add(jLabel);
        jPanel.add((Component)jPanel2, "Center");
        return jPanel;
    }

    private JPanel createPanelClose() {
        JButton jButton;
        JPanel jPanel = new JPanel();
        this.applyOnAll = jButton = this.getButton(this.CMAPPLYALL);
        Util.toolTip(jButton, this.CMAPPLYALLTIP, true);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FrameColorMap.this.applyOnOtherImg();
                FrameColorMap.this.resumeWidgets();
            }
        });
        jPanel.add(jButton);
        jButton = this.getButton(this.CMPIXTOOL);
        Util.toolTip(jButton, this.CMPIXTOOLTIP, true);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FrameColorMap.this.aladin.pixelTool();
            }
        });
        jPanel.add(jButton);
        jButton = this.getButton(this.CMCLOSE);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FrameColorMap.this.dispose();
            }
        });
        jPanel.add(jButton);
        return jPanel;
    }

    private void showCMGrey() {
        if (this.p != null) {
            this.getContentPane().remove(this.p);
        }
        JPanel jPanel = new JPanel(new BorderLayout(0, 0));
        jPanel.add((Component)this.createPanelTop(), "North");
        jPanel.add((Component)this.canvasPixelRange, "Center");
        this.p = new JPanel(new BorderLayout(0, 0));
        this.p.add((Component)jPanel, "North");
        this.p.add((Component)this.createPanelDistribution(), "Center");
        this.getContentPane().add((Component)this.p, "Center");
        this.pack();
        this.setVisible(true);
        this.toFront();
    }

    private void showCMRGB() {
        if (this.p != null) {
            this.getContentPane().remove(this.p);
        }
        this.p = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.p.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        JPanel jPanel = new JPanel();
        JLabel jLabel = new JLabel(Util.fold(this.CMMETHODERGB, 80, true));
        jLabel.setFont(jLabel.getFont().deriveFont(2));
        jPanel.add(jLabel);
        jPanel.add(Util.getHelpButton(this, this.CMMESSAGE));
        gridBagLayout.setConstraints(jPanel, gridBagConstraints);
        this.p.add(jPanel);
        if (this.isPlanBGRGB) {
            gridBagLayout.setConstraints(this.cm, gridBagConstraints);
            this.p.add(this.cm);
            gridBagLayout.setConstraints(this.cm2, gridBagConstraints);
            this.p.add(this.cm2);
            gridBagLayout.setConstraints(this.cm3, gridBagConstraints);
            this.p.add(this.cm3);
        } else {
            if (((PlanImageRGB)this.pimg).flagRed) {
                gridBagLayout.setConstraints(this.cm, gridBagConstraints);
                this.p.add(this.cm);
            }
            if (((PlanImageRGB)this.pimg).flagGreen) {
                gridBagLayout.setConstraints(this.cm2, gridBagConstraints);
                this.p.add(this.cm2);
            }
            if (((PlanImageRGB)this.pimg).flagBlue) {
                gridBagLayout.setConstraints(this.cm3, gridBagConstraints);
                this.p.add(this.cm3);
            }
        }
        JPanel jPanel2 = new JPanel();
        JButton jButton = this.getButton(this.CMREVERSE);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FrameColorMap.this.reverse();
                FrameColorMap.this.resumeWidgets();
            }
        });
        jPanel2.add(jButton);
        jPanel2.add(new JLabel("  "));
        jButton = this.getButton(this.CMRESET);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FrameColorMap.this.resetRGB();
                FrameColorMap.this.resumeWidgets();
            }
        });
        jPanel2.add(jButton);
        jButton = this.getButton(this.CMCLOSE);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FrameColorMap.this.dispose();
            }
        });
        jPanel2.add(jButton);
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        this.p.add(jPanel2);
        this.getContentPane().add((Component)this.p, "Center");
        this.pack();
        this.setVisible(true);
        this.toFront();
    }

    private void resetRGB() {
        if (this.isPlanBGRGB) {
            ((PlanBG)this.pimg).filterRGB(new int[]{0, 128, 255}, 0);
            ((PlanBG)this.pimg).filterRGB(new int[]{0, 128, 255}, 1);
            ((PlanBG)this.pimg).filterRGB(new int[]{0, 128, 255}, 2);
            this.cm.reset();
            this.cm2.reset();
            this.cm3.reset();
        } else {
            if (((PlanImageRGB)this.pimg).flagRed) {
                this.cm.reset();
            }
            if (((PlanImageRGB)this.pimg).flagGreen) {
                this.cm2.reset();
            }
            if (((PlanImageRGB)this.pimg).flagBlue) {
                this.cm3.reset();
            }
            ((PlanImageRGB)this.pimg).createImgRGB();
        }
    }

    private JButton getButton(String string) {
        JButton jButton = new JButton(string);
        jButton.setMargin(MARGIN);
        return jButton;
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(200, 300);
    }

    protected static JComboBox<String> createComboCM() {
        JComboBox<String> jComboBox = new JComboBox<String>();
        for (String string : CanvasColorMap.getCMList()) {
            jComboBox.addItem(string);
        }
        jComboBox.addItem(" -- ");
        return jComboBox;
    }

    protected static JComboBox<String> createComboFct() {
        JComboBox<String> jComboBox = new JComboBox<String>(PlanImage.TRANSFERTFCT);
        return jComboBox;
    }

    protected final boolean isDragging() {
        return this.cm == null ? false : this.cm.isDragging();
    }

    private void localcut() {
        this.localcut(this.pimg);
        this.resumeWidgets();
    }

    public void localcut(PlanImage planImage) {
        if (planImage instanceof PlanBG) {
            ((PlanBG)planImage).forceReload();
        } else {
            planImage.recut(0.0, 0.0, true);
        }
        this.aladin.view.repaintAll();
    }

    private void reverse() {
        this.pimg.video = this.pimg.video == 0 ? 1 : 0;
        this.aladin.console.printCommand("cm " + (this.pimg.video == 0 ? "noreverse" : "reverse"));
        if (this.pimg.type == 2) {
            if (((PlanImageRGB)this.pimg).flagRed) {
                this.cm.pimg.video = this.pimg.video;
                this.cm.repaint();
            }
            if (((PlanImageRGB)this.pimg).flagGreen) {
                this.cm2.pimg.video = this.pimg.video;
                this.cm2.repaint();
            }
            if (((PlanImageRGB)this.pimg).flagBlue) {
                this.cm3.pimg.video = this.pimg.video;
                this.cm3.repaint();
            }
            ((PlanImageRGB)this.pimg).inverseRGB();
        } else {
            this.cm.repaint();
            this.setCM(this.cm.getCM());
        }
        this.aladin.view.repaintAll();
        this.aladin.calque.zoom.zoomView.repaint();
    }

    private void getAll() {
        if (this.pimg == null) {
            return;
        }
        Aladin.makeCursor(this, 1);
        this.pixelCutMinField.setText(this.pimg.getDataMinInfo());
        this.pixelCutMaxField.setText(this.pimg.getDataMaxInfo());
        Aladin.makeCursor(this, 1);
        if (!this.pimg.recut(this.pimg.dataMin, this.pimg.dataMax, false)) {
            Aladin.makeCursor(this, 0);
            return;
        }
        Aladin.makeCursor(this, 0);
        this.aladin.console.printCommand("cm all");
        this.cm.repaint();
        this.canvasPixelRange.repaint();
        this.setCM(this.cm.getCM());
        this.aladin.view.repaintAll();
        this.aladin.calque.zoom.zoomView.repaint();
    }

    private void changeTransfertFct() {
        int n = this.fctCombo.getSelectedIndex();
        if (this.pimg.getTransfertFct() == n) {
            return;
        }
        this.aladin.console.printCommand("cm " + PlanImage.TRANSFERTFCT[n]);
        this.pimg.setTransfertFct(n);
        this.setCM(this.cm.getCM());
        this.aladin.view.repaintAll();
        this.aladin.calque.zoom.zoomView.repaint();
        this.repaint();
    }

    private void applyOnOtherImg() {
        this.vimg = this.pimg.planMultiCCD != null ? this.pimg.planMultiCCD.getCCD() : this.aladin.calque.getSelectedImagesWithPixels();
        this.vimg.remove(this.pimg);
        final String string = this.pixelCutMinField.getText();
        final String string2 = this.pixelCutMaxField.getText();
        final int n = this.pimg.video;
        final int n2 = this.pimg.typeCM;
        final int n3 = this.pimg.getTransfertFct();
        final int[] nArray = new int[3];
        for (int i = 0; i < 3; ++i) {
            nArray[i] = this.pimg.cmControl[i];
        }
        new Thread("changeAutocut"){

            @Override
            public void run() {
                Enumeration enumeration = FrameColorMap.this.vimg.elements();
                while (enumeration.hasMoreElements()) {
                    PlanImage planImage = (PlanImage)enumeration.nextElement();
                    double d = planImage.getPixelValue(string);
                    double d2 = planImage.getPixelValue(string2);
                    planImage.recut(d, d2, false);
                    planImage.setTransfertFct(n3);
                    planImage.video = n;
                    planImage.typeCM = n2;
                    CanvasColorMap cfr_ignored_0 = FrameColorMap.this.cm;
                    planImage.setCM(CanvasColorMap.getCM(nArray[0], nArray[1], nArray[2], n == 1, n2, n3, planImage.isTransparent()));
                    for (int i = 0; i < 3; ++i) {
                        planImage.cmControl[i] = nArray[i];
                    }
                    ((FrameColorMap)FrameColorMap.this).aladin.view.repaintAll();
                }
                FrameColorMap.this.vimg = null;
            }
        }.start();
    }

    protected void setMinMax(double d, double d2, boolean bl) {
        this.pixelCutMinField.setText(Util.myRound(d));
        this.pixelCutMaxField.setText(Util.myRound(d2));
        if (bl) {
            this.changeCut();
            this.resumeWidgets();
        }
    }

    private void changeCut() {
        try {
            double d = this.pimg.getPixelValue(this.pixelCutMinField.getText());
            double d2 = this.pimg.getPixelValue(this.pixelCutMaxField.getText());
            if (d > d2) {
                Aladin.warning(this, this.CMERRORRANGE);
                return;
            }
            this.aladin.console.printCommand("cm " + this.pixelCutMinField.getText() + ".." + this.pixelCutMaxField.getText());
            if (!this.pimg.recut(d, d2, false)) {
                return;
            }
            this.pimg.resetHist();
            this.setCM(this.cm.getCM());
            this.pixelCutMinField.setText(this.pimg.getPixelMinInfo());
            this.pixelCutMaxField.setText(this.pimg.getPixelMaxInfo());
            this.canvasPixelRange.repaint();
            this.aladin.view.repaintAll();
            this.aladin.calque.zoom.zoomView.repaint();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void changeCM(JComboBox<String> jComboBox) {
        int n = jComboBox.getSelectedIndex();
        if (n == this.pimg.typeCM) {
            return;
        }
        this.pimg.typeCM = n;
        this.cm.repaint();
        if (n < CMA.length) {
            this.aladin.console.printCommand("cm " + CMA[n]);
        } else {
            try {
                this.aladin.console.printCommand("cm " + CanvasColorMap.customCMName.get(n - 3 - 1));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            this.setCM(this.cm.getCM());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.aladin.view.repaintAll();
        this.aladin.calque.zoom.zoomView.repaint();
    }

    private void setCM(IndexColorModel indexColorModel) {
        this.pimg.setCM(indexColorModel);
        this.pimg.aladin.calque.zoom.zoomView.setCM(indexColorModel);
    }

    private void memoControl() {
        if (this.pimg == null || this.cm == null) {
            return;
        }
        if (this.isPlanImageRGB) {
            for (int i = 0; i < 3; ++i) {
                PlanImageRGB planImageRGB = (PlanImageRGB)this.pimg;
                if (planImageRGB.flagRed) {
                    planImageRGB.RGBControl[i] = this.cm.triangle[i];
                }
                if (planImageRGB.flagGreen) {
                    planImageRGB.RGBControl[3 + i] = this.cm2.triangle[i];
                }
                if (!planImageRGB.flagBlue) continue;
                planImageRGB.RGBControl[6 + i] = this.cm3.triangle[i];
            }
        } else if (this.isPlanBGRGB) {
            for (int i = 0; i < 3; ++i) {
                PlanBG planBG = (PlanBG)this.pimg;
                planBG.RGBControl[i] = this.cm.triangle[i];
                planBG.RGBControl[3 + i] = this.cm2.triangle[i];
                planBG.RGBControl[6 + i] = this.cm3.triangle[i];
            }
        } else {
            for (int i = 0; i < 3; ++i) {
                this.pimg.cmControl[i] = this.cm.triangle[i];
            }
        }
    }

    protected void disposeFrameCM(Plan plan) {
        if (plan != this.pimg) {
            return;
        }
        this.pimg = null;
        this.imgID = -1;
        if (this.isVisible()) {
            this.aladin.toolBox.tool[9].setMode(1);
            this.aladin.toolBox.repaint();
            this.setVisible(false);
        }
    }

    @Override
    public void dispose() {
        this.setVisible(false);
        this.aladin.gc();
        this.memoControl();
        if (this.aladin.calque.getPlanBase() != null) {
            this.aladin.toolBox.tool[9].setMode(1);
        } else {
            this.aladin.toolBox.tool[9].setMode(0);
        }
        this.aladin.toolBox.repaint();
        this.imgID = -1;
    }

    @Override
    protected void processWindowEvent(WindowEvent windowEvent) {
        if (windowEvent.getID() == 201) {
            this.dispose();
        }
        super.processWindowEvent(windowEvent);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        if (this.ignoreMouse(mouseEvent)) {
            return;
        }
        this.resumeWidgets();
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        if (this.ignoreMouse(mouseEvent)) {
            return;
        }
        if (this.pixelCutMinField != null && this.pixelCutMaxField != null) {
            String string = this.pixelCutMinField.getText();
            String string2 = this.pixelCutMaxField.getText();
            if (!string.equals(this.pimg.getPixelMinInfo()) || !string2.equals(this.pimg.getPixelMaxInfo())) {
                this.resumeWidgets();
            }
        } else {
            this.resumeWidgets();
        }
    }

    private boolean ignoreMouse(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        return n >= 10 && n2 >= 30 && n <= this.getWidth() - 10 && n2 <= this.getHeight() - 10;
    }

    class DefaultConf {
        double rawPixelCutMin;
        double rawPixelCutMax;
        int cmIndex;
        int fctIndex;
        int videoIndex;
        long pimgHash;

        DefaultConf() {
        }

        boolean memo() {
            if ((long)FrameColorMap.this.pimg.hashCode() == this.pimgHash) {
                return false;
            }
            this.pimgHash = FrameColorMap.this.pimg.hashCode();
            this.rawPixelCutMin = ((FrameColorMap)FrameColorMap.this).pimg.pixelMin;
            this.rawPixelCutMax = ((FrameColorMap)FrameColorMap.this).pimg.pixelMax;
            this.cmIndex = ((FrameColorMap)FrameColorMap.this).pimg.typeCM;
            this.fctIndex = FrameColorMap.this.pimg.getTransfertFct();
            this.videoIndex = ((FrameColorMap)FrameColorMap.this).pimg.video;
            return true;
        }

        void resetAll() {
            this.resetMinMax();
            this.resetCM();
            this.resetTriangle();
        }

        boolean isModif() {
            return this.isModifCM() || this.isModifTriangle() || this.isModifMinMax();
        }

        boolean isModifCM() {
            return FrameColorMap.this.pimg.getTransfertFct() != this.fctIndex || ((FrameColorMap)FrameColorMap.this).pimg.typeCM != this.cmIndex || ((FrameColorMap)FrameColorMap.this).pimg.video != this.videoIndex;
        }

        void resetCM() {
            if (!this.isModifCM()) {
                return;
            }
            FrameColorMap.this.pimg.setTransfertFct(this.fctIndex);
            ((FrameColorMap)FrameColorMap.this).pimg.typeCM = this.cmIndex;
            ((FrameColorMap)FrameColorMap.this).pimg.video = this.videoIndex;
            FrameColorMap.this.setCM(FrameColorMap.this.cm.getCM());
        }

        boolean isModifTriangle() {
            return 0 != FrameColorMap.this.cm.triangle[0] || 128 != FrameColorMap.this.cm.triangle[1] || 255 != FrameColorMap.this.cm.triangle[2];
        }

        void resetTriangle() {
            if (!this.isModifTriangle()) {
                return;
            }
            FrameColorMap.this.cm.reset();
            FrameColorMap.this.setCM(FrameColorMap.this.cm.getCM());
        }

        boolean isModifMinMax() {
            return this.rawPixelCutMin != ((FrameColorMap)FrameColorMap.this).pimg.pixelMin || this.rawPixelCutMax != ((FrameColorMap)FrameColorMap.this).pimg.pixelMax;
        }

        void resetMinMax() {
            if (!this.isModifMinMax()) {
                return;
            }
            FrameColorMap.this.pimg.recut(this.rawPixelCutMin, this.rawPixelCutMax, false);
            FrameColorMap.this.setCM(FrameColorMap.this.cm.getCM());
            FrameColorMap.this.pixelCutMinField.setText(FrameColorMap.this.pimg.getPixelMinInfo());
            FrameColorMap.this.pixelCutMaxField.setText(FrameColorMap.this.pimg.getPixelMaxInfo());
        }
    }
}

