/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.ColumnCalculator;
import cds.aladin.FilterProperties;
import cds.aladin.MetaDataTree;
import cds.aladin.Obj;
import cds.aladin.Plan;
import cds.aladin.Source;
import cds.savot.model.SavotField;
import cds.tools.Util;
import cds.tools.parser.Parser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class FrameColumnCalculator
extends JFrame
implements ActionListener {
    private static String TITLE;
    private static String ADDCOL;
    private static String ADDNEW;
    private static String NAME;
    private static String UNIT;
    private static String DECI;
    private static String KEEP;
    private static String EXPR;
    private static String NOEXPR;
    private static String COL;
    private static String CREATIONOK;
    private static String PICKNAME;
    private static String PICKOP;
    private static String FUNCT;
    private static String NEEDNAME;
    private static String ALLREADYEXIST;
    private static String ERROR;
    private static String CLOSE;
    protected static String[] OPERATORS;
    private static final Insets BUTTON_INSETS;
    private Plan pc;
    private JButton[] buttons;
    private JTextField nameTF;
    private JTextField ucdTF;
    private JTextField unitTF;
    private JTextArea expressionTA;
    private JComboBox nbDecChoice;
    private Vector vCol;
    private JComboBox funcChoice;
    private Aladin a;

    public FrameColumnCalculator(Aladin aladin) {
        this.a = aladin;
        Aladin.setIcon(this);
        this.getContentPane().setLayout(new BorderLayout());
        Util.setCloseShortcut(this, true, aladin);
        this.setLocation(Aladin.computeLocation(this));
    }

    protected void createChaine() {
        if (TITLE != null) {
            return;
        }
        TITLE = Aladin.chaine.getString("CCTITLE");
        ADDCOL = Aladin.chaine.getString("CCADDCOL");
        ADDNEW = Aladin.chaine.getString("CCADDNEW");
        NAME = Aladin.chaine.getString("CCNAME");
        UNIT = Aladin.chaine.getString("CCUNIT");
        DECI = Aladin.chaine.getString("CCDECI");
        KEEP = Aladin.chaine.getString("CCKEEP");
        EXPR = Aladin.chaine.getString("CCEXPR");
        PICKNAME = Aladin.chaine.getString("CCPICKNAME");
        PICKOP = Aladin.chaine.getString("CCPICKOP");
        FUNCT = Aladin.chaine.getString("CCFUNCT");
        NEEDNAME = Aladin.chaine.getString("CCNEEDNAME");
        NOEXPR = Aladin.chaine.getString("CCNOEXPR");
        ALLREADYEXIST = Aladin.chaine.getString("CCALLREADYEXIST");
        ERROR = Aladin.chaine.getString("ERROR");
        CLOSE = Aladin.chaine.getString("CLOSE");
        COL = Aladin.chaine.getString("CCCOL");
        CREATIONOK = Aladin.chaine.getString("CCCREATIONOK");
        this.setTitle(TITLE);
    }

    protected void update(Plan plan) {
        this.pc = plan;
        this.createChaine();
        this.vCol = null;
        this.getContentPane().removeAll();
        this.buildFrame();
    }

    private void buildFrame() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 3));
        JPanel jPanel2 = this.topPanel();
        jPanel.add(jPanel2);
        JPanel jPanel3 = this.createButtons();
        jPanel.add(jPanel3);
        JPanel jPanel4 = this.funcPanel();
        jPanel.add(jPanel4);
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(15, 5, 5, 5), BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(null, ADDNEW + " " + this.pc.label, 2, 2), BorderFactory.createEmptyBorder(5, 5, 5, 5))));
        this.getContentPane().add((Component)jPanel, "Center");
        this.getContentPane().add((Component)this.bottomPanel(), "South");
        this.pack();
    }

    private JPanel topPanel() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 0;
        jPanel.setLayout(gridBagLayout);
        gridBagConstraints.anchor = 17;
        this.nameTF = new JTextField(20);
        JLabel jLabel = new JLabel(NAME);
        jLabel.setFont(Aladin.BOLD);
        FilterProperties.addCouple(jPanel, jLabel, this.nameTF, gridBagLayout, gridBagConstraints);
        this.ucdTF = new JTextField(20);
        FilterProperties.addCouple(jPanel, "UCD", this.ucdTF, gridBagLayout, gridBagConstraints);
        this.unitTF = new JTextField(20);
        FilterProperties.addCouple(jPanel, UNIT, this.unitTF, gridBagLayout, gridBagConstraints);
        this.nbDecChoice = new JComboBox();
        this.nbDecChoice.setFont(Aladin.PLAIN);
        for (int i = 1; i < 13; ++i) {
            this.nbDecChoice.addItem(i + "");
        }
        this.nbDecChoice.setSelectedIndex(3);
        JPanel jPanel2 = new JPanel(new FlowLayout(1, 0, 2));
        jPanel2.add(this.nbDecChoice);
        JLabel jLabel2 = new JLabel(" " + DECI);
        jLabel2.setFont(Aladin.ITALIC);
        jPanel2.add(jLabel2);
        FilterProperties.addCouple(jPanel, KEEP, jPanel2, gridBagLayout, gridBagConstraints);
        this.expressionTA = new JTextArea("", 5, 35);
        this.expressionTA.setLineWrap(true);
        this.expressionTA.setWrapStyleWord(true);
        this.expressionTA.setFont(Aladin.COURIER);
        JLabel jLabel3 = new JLabel(EXPR);
        jLabel3.setFont(Aladin.BOLD);
        gridBagConstraints.gridwidth = -1;
        gridBagLayout.setConstraints(jLabel3, gridBagConstraints);
        jPanel.add(jLabel3);
        JLabel jLabel4 = new JLabel("eg: ${Bmag}-${Vmag}");
        jLabel4.setFont(Aladin.ITALIC);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(jLabel4, gridBagConstraints);
        jPanel.add(jLabel4);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        JScrollPane jScrollPane = new JScrollPane(this.expressionTA, 20, 31);
        gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
        jPanel.add(jScrollPane);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        return jPanel;
    }

    private JPanel funcPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 2));
        for (int i = 0; i < OPERATORS.length; ++i) {
            JButton jButton = this.createButton(OPERATORS[i]);
            jButton.setMaximumSize(new Dimension(30, 35));
            jButton.setPreferredSize(new Dimension(30, 35));
            jButton.setFont(Aladin.COURIER);
            jPanel.add(jButton);
            jPanel.add(Box.createHorizontalGlue());
        }
        this.funcChoice = new JComboBox();
        this.funcChoice.setFont(Aladin.PLAIN);
        this.funcChoice.addActionListener(this);
        this.funcChoice.addItem(FUNCT);
        String[] stringArray = Parser.getAvailFunc();
        FilterProperties.sortLexico(stringArray);
        for (int i = 0; i < stringArray.length; ++i) {
            this.funcChoice.addItem(stringArray[i]);
        }
        jPanel.add(this.funcChoice);
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(null, PICKOP, 2, 2, Aladin.COURIER), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        return jPanel;
    }

    private JPanel bottomPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1));
        JButton jButton = this.createButton(ADDCOL);
        jPanel.add(jButton);
        jButton.setFont(Aladin.BOLD);
        jButton.setMargin(null);
        jButton = this.createButton(CLOSE);
        jPanel.add(jButton);
        jButton.setFont(Aladin.PLAIN);
        jButton.setMargin(null);
        return jPanel;
    }

    private JButton createButton(String string) {
        JButton jButton = new JButton(string);
        jButton.setMargin(BUTTON_INSETS);
        jButton.addActionListener(this);
        return jButton;
    }

    private JPanel createButtons() {
        JPanel jPanel;
        String[] stringArray = this.getCol(this.pc);
        int n = 4;
        int n2 = 5;
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(0, n, 3, 3));
        this.buttons = new JButton[stringArray.length];
        boolean bl = stringArray.length > n * n2;
        int n3 = 0;
        FontMetrics fontMetrics = null;
        if (bl) {
            fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(Aladin.PLAIN);
        }
        for (int i = stringArray.length - 1; i >= 0; --i) {
            int n4;
            this.buttons[i] = this.createButton(stringArray[i]);
            this.buttons[i].setFont(Aladin.PLAIN);
            if (bl && (n4 = fontMetrics.stringWidth(stringArray[i])) > n3) {
                n3 = n4;
            }
            jPanel2.add(this.buttons[i]);
        }
        if (bl) {
            JScrollPane jScrollPane = new JScrollPane(jPanel2, 20, 31);
            jScrollPane.setPreferredSize(new Dimension((n3 + 20) * n + 40, 140));
            JPanel jPanel3 = new JPanel();
            jPanel3.add(jScrollPane);
            jPanel = jPanel3;
        } else {
            jPanel = jPanel2;
        }
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(null, PICKNAME, 2, 2, Aladin.COURIER), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        return jPanel;
    }

    private String[] getCol(Plan plan) {
        Object object;
        if (this.vCol == null) {
            this.vCol = new Vector();
            Iterator<Obj> iterator = plan.iterator();
            while (iterator.hasNext()) {
                Obj obj = iterator.next();
                if (!(obj instanceof Source)) continue;
                object = (Source)obj;
                for (int i = object.leg.field.length - 1; i >= 0; --i) {
                    String string = object.leg.field[i].name;
                    if (this.vCol.indexOf(string) >= 0) continue;
                    this.vCol.addElement(string);
                }
            }
        }
        object = new String[this.vCol.size()];
        this.vCol.copyInto((Object[])object);
        return object;
    }

    protected static String[] getCol(Plan plan, Vector vector) {
        Object[] objectArray;
        vector = new Vector<String>();
        Iterator<Obj> iterator = plan.iterator();
        while (iterator.hasNext()) {
            objectArray = iterator.next();
            if (!(objectArray instanceof Source)) continue;
            Source source = (Source)objectArray;
            for (int i = source.leg.field.length - 1; i >= 0; --i) {
                String string = source.leg.field[i].name;
                if (vector.indexOf(string) >= 0) continue;
                vector.addElement(string);
            }
        }
        objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        String string = actionEvent.getActionCommand();
        if (string.equals(CLOSE)) {
            this.setVisible(false);
        } else if (string.equals(ADDCOL)) {
            this.addColumn();
        } else if (object.equals(this.funcChoice)) {
            int n = this.funcChoice.getSelectedIndex();
            if (n > 0) {
                int n2 = FilterProperties.insertInTA(this.expressionTA, this.funcChoice.getItemAt(n).toString() + "()", this.expressionTA.getCaretPosition());
                this.expressionTA.setCaretPosition(n2 - 1);
                this.expressionTA.requestFocus();
                this.funcChoice.setSelectedIndex(0);
            }
        } else if (object instanceof JButton) {
            String string2 = ((JButton)object).getText();
            if (this.vCol.contains(string2)) {
                FilterProperties.insertInTA(this.expressionTA, "${" + string2 + "}", this.expressionTA.getCaretPosition());
            } else {
                FilterProperties.insertInTA(this.expressionTA, string2, this.expressionTA.getCaretPosition());
            }
            this.expressionTA.requestFocus();
        }
    }

    private void addColumn() {
        int n;
        String string = this.nameTF.getText();
        String string2 = this.ucdTF.getText();
        String string3 = this.unitTF.getText();
        String string4 = MetaDataTree.replace(MetaDataTree.replace(this.expressionTA.getText(), "\n", "", -1), "\r", "", -1);
        try {
            n = Integer.parseInt(this.nbDecChoice.getSelectedItem().toString());
        }
        catch (NumberFormatException numberFormatException) {
            n = 4;
        }
        if (string.length() == 0) {
            Aladin.warning(this, NEEDNAME, 1);
            return;
        }
        if (string4.length() == 0) {
            Aladin.warning(this, NOEXPR, 1);
            return;
        }
        if (this.colExist(string)) {
            Aladin.warning(this, ALLREADYEXIST + string + "]");
            return;
        }
        Aladin.trace(3, "expr is : " + string4);
        SavotField savotField = new SavotField();
        savotField.setName(string);
        savotField.setUcd(string2);
        savotField.setUnit(string3);
        this.a.console.printCommand("addcol " + this.pc.label + "," + string + "," + string4 + "," + string3 + "," + string2 + "," + n);
        ColumnCalculator columnCalculator = new ColumnCalculator(new SavotField[]{savotField}, new String[]{string4}, this.pc, n, this.a);
        if (!columnCalculator.createParser()) {
            Aladin.warning(this, ERROR + " : " + columnCalculator.getError(), 1);
            return;
        }
        columnCalculator.compute();
        Aladin.info(COL + " '" + string + "' " + CREATIONOK);
        this.setVisible(false);
    }

    private boolean colExist(String string) {
        String[] stringArray = this.getCol(this.pc);
        return Util.indexInArrayOf(string, stringArray) >= 0;
    }

    protected static boolean colExist(String string, Plan plan) {
        String[] stringArray = FrameColumnCalculator.getCol(plan, new Vector());
        return Util.indexInArrayOf(string, stringArray) >= 0;
    }

    static {
        OPERATORS = new String[]{"+", "-", "*", "/", "^", "(", ")"};
        BUTTON_INSETS = new Insets(1, 2, 1, 2);
    }
}

