/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.ContourPlot;
import cds.aladin.Couleur;
import cds.aladin.Curseur;
import cds.aladin.Histogramme;
import cds.aladin.MyLabel;
import cds.aladin.Plan;
import cds.aladin.PlanBG;
import cds.aladin.PlanContour;
import cds.aladin.PlanImage;
import cds.aladin.RectangleD;
import cds.aladin.ViewSimple;
import cds.tools.Util;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Event;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public final class FrameContour
extends JFrame
implements ActionListener {
    protected String TITRE;
    protected String CLOSE;
    protected String RESET;
    protected String SUBMIT;
    protected String NEWLEVEL;
    protected String SHOWHELP;
    protected String HIDEHELP;
    protected String SMOOTHINFO;
    protected String NOISEINFO;
    protected String ZOOMINFO;
    protected String CHOOSELEVEL;
    protected String GENERATE;
    protected String SMOOTH;
    protected String LEVEL;
    protected String MANUALLY;
    protected String USESM;
    protected String REDUCE;
    protected String CONSIDER;
    protected String TITRE2;
    static final Font HELPFONT = new Font("Monospaced", 0, 10);
    boolean showHelp = false;
    boolean flagHide = true;
    JPanel p;
    JLabel lab1;
    MyLabel smoothInfo;
    MyLabel noiseInfo;
    MyLabel zoomInfo;
    JButton helpBtn;
    JButton submitBtn;
    JCheckBox smoothCb;
    JCheckBox noisecb;
    PlanImage pimg;
    JComboBox nbLevelsChoice;
    JComboBox smooothLevelChoice;
    JCheckBox currentZoomOnly;
    private Histogramme hist;
    private Color[] couleurs = null;
    private double[] levels;
    Aladin a;
    Curseur curs;
    int etat = -4;
    private RectangleD memoRzoom = null;
    private static final Insets BUTTON_INSETS = new Insets(0, 2, 0, 2);

    protected void createChaine() {
        this.TITRE = Aladin.chaine.getString("CPTITRE");
        this.TITRE2 = Aladin.chaine.getString("CPTITRE2");
        this.CLOSE = Aladin.chaine.getString("CLOSE");
        this.RESET = Aladin.chaine.getString("RESET");
        this.SUBMIT = Aladin.chaine.getString("CPSUBMIT");
        this.NEWLEVEL = Aladin.chaine.getString("CPNEWLEVEL");
        this.SHOWHELP = Aladin.chaine.getString("CPSHOWHELP");
        this.HIDEHELP = Aladin.chaine.getString("CPHIDEHELP");
        this.SMOOTHINFO = Aladin.chaine.getString("CPSMOOTHINFO");
        this.NOISEINFO = Aladin.chaine.getString("CPNOISEINFO");
        this.ZOOMINFO = Aladin.chaine.getString("CPZOOMINFO");
        this.CHOOSELEVEL = Aladin.chaine.getString("CPCHOOSELEVEL");
        this.GENERATE = Aladin.chaine.getString("CPGENERATE");
        this.SMOOTH = Aladin.chaine.getString("CPSMOOTH");
        this.LEVEL = Aladin.chaine.getString("CPLEVEL");
        this.MANUALLY = Aladin.chaine.getString("CPMANUALLY");
        this.USESM = Aladin.chaine.getString("CPUSESM");
        this.REDUCE = Aladin.chaine.getString("CPREDUCE");
        this.CONSIDER = Aladin.chaine.getString("CPCONSIDER");
    }

    protected FrameContour(Aladin aladin) {
        this.a = aladin;
        Aladin.setIcon(this);
        this.createChaine();
        this.setTitle(this.TITRE);
        this.lab1 = new JLabel(" " + this.SMOOTH);
        this.smoothInfo = new MyLabel(this.SMOOTHINFO, 0, HELPFONT);
        this.noiseInfo = new MyLabel(this.NOISEINFO, 0, HELPFONT);
        this.zoomInfo = new MyLabel(this.ZOOMINFO, 0, HELPFONT);
        this.pimg = this.a.calque.getFirstSelectedSimpleImage();
        this.setLocation(350, 200);
        this.hist = new Histogramme();
        this.curs = new Curseur(this.hist);
        this.enableEvents(64L);
        Util.setCloseShortcut(this, false, aladin);
        this.initCouleurs();
        this.fillCouleurTriangle();
    }

    private JPanel getTopPanel() {
        int n;
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(1, 3, 2, 3);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(gridBagLayout);
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(null, this.CHOOSELEVEL, 4, 2, Aladin.PLAIN), BorderFactory.createEmptyBorder(5, 5, 3, 5))));
        this.hist.setImage(this.pimg);
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(this.hist, gridBagConstraints);
        jPanel.add(this.hist);
        gridBagLayout.setConstraints(this.curs, gridBagConstraints);
        jPanel.add(this.curs);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(0, 7, 5));
        JLabel jLabel = new JLabel(this.GENERATE);
        jPanel2.add(jLabel);
        jLabel.setFont(Aladin.PLAIN);
        this.nbLevelsChoice = new JComboBox();
        this.nbLevelsChoice.addActionListener(this);
        for (n = 1; n <= 10; ++n) {
            this.nbLevelsChoice.addItem(new Integer(n));
        }
        for (n = 12; n <= 20; n += 2) {
            this.nbLevelsChoice.addItem(new Integer(n));
        }
        n = 4;
        this.nbLevelsChoice.setSelectedIndex(n - 1);
        jPanel2.add(this.nbLevelsChoice);
        jLabel = new JLabel(this.LEVEL);
        jPanel2.add(jLabel);
        jLabel.setFont(Aladin.PLAIN);
        this.createLevels(n);
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        jPanel.add(jPanel2);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(0, 7, 5));
        jLabel = new JLabel(this.MANUALLY);
        jPanel3.add(jLabel);
        jLabel.setFont(Aladin.PLAIN);
        jPanel3.add(this.createButton(this.NEWLEVEL));
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagLayout.setConstraints(jPanel3, gridBagConstraints);
        jPanel.add(jPanel3);
        return jPanel;
    }

    private JPanel getOptionsPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(1, 3, 2, 3);
        gridBagConstraints.anchor = 17;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(gridBagLayout);
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(null, "", 4, 2, Aladin.PLAIN), BorderFactory.createEmptyBorder(5, 5, 3, 5))));
        JPanel jPanel2 = new JPanel(new FlowLayout(0, 7, 0));
        this.smoothInfo = new MyLabel(this.SMOOTHINFO, 0, HELPFONT);
        this.smoothInfo.setVisible(this.showHelp);
        jPanel2.add(this.smoothInfo);
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        jPanel.add(jPanel2);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(0, 7, 0));
        this.smoothCb = new JCheckBox(this.USESM, null, true);
        this.smoothCb.setFont(Aladin.PLAIN);
        this.smoothCb.addActionListener(this);
        this.smooothLevelChoice = new JComboBox();
        for (int i = 2; i <= 4; ++i) {
            this.smooothLevelChoice.addItem(new Integer(i));
        }
        this.smooothLevelChoice.setSelectedIndex(0);
        this.smooothLevelChoice.setEnabled(true);
        this.lab1.setFont(Aladin.PLAIN);
        this.lab1.setEnabled(true);
        jPanel3.add(this.smoothCb);
        jPanel3.add(this.lab1);
        jPanel3.add(this.smooothLevelChoice);
        gridBagLayout.setConstraints(jPanel3, gridBagConstraints);
        jPanel.add(jPanel3);
        JPanel jPanel4 = new JPanel(new FlowLayout(0, 7, 0));
        this.noiseInfo = new MyLabel(this.NOISEINFO, 0, HELPFONT);
        this.noiseInfo.setVisible(this.showHelp);
        jPanel4.add(this.noiseInfo);
        gridBagLayout.setConstraints(jPanel4, gridBagConstraints);
        jPanel.add(jPanel4);
        JPanel jPanel5 = new JPanel(new FlowLayout(0, 7, 0));
        this.noisecb = new JCheckBox(this.REDUCE, null, true);
        this.noisecb.setFont(Aladin.PLAIN);
        jPanel5.add(this.noisecb);
        gridBagLayout.setConstraints(jPanel5, gridBagConstraints);
        jPanel.add(jPanel5);
        JPanel jPanel6 = new JPanel(new FlowLayout(0, 7, 0));
        this.zoomInfo = new MyLabel(this.ZOOMINFO, 0, HELPFONT);
        this.zoomInfo.setVisible(this.showHelp);
        jPanel6.add(this.zoomInfo);
        gridBagLayout.setConstraints(jPanel6, gridBagConstraints);
        jPanel.add(jPanel6);
        JPanel jPanel7 = new JPanel(new FlowLayout(0, 7, 0));
        this.currentZoomOnly = new JCheckBox(this.CONSIDER, false);
        this.currentZoomOnly.setFont(Aladin.PLAIN);
        jPanel7.add(this.currentZoomOnly);
        gridBagLayout.setConstraints(jPanel7, gridBagConstraints);
        jPanel.add(jPanel7);
        try {
            this.currentZoomOnly.setEnabled(this.a.calque.getFirstSelectedSimpleImage().ref);
        }
        catch (Exception exception) {
            this.currentZoomOnly.setEnabled(false);
        }
        this.helpBtn = this.createButton(this.showHelp ? this.HIDEHELP : this.SHOWHELP);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagLayout.setConstraints(this.helpBtn, gridBagConstraints);
        jPanel.add(this.helpBtn);
        return jPanel;
    }

    private JPanel getBottomPanel() {
        Insets insets = new Insets(0, 4, 0, 4);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1));
        this.submitBtn = this.createButton(this.SUBMIT);
        this.submitBtn.setFont(Aladin.BOLD);
        this.submitBtn.setMargin(insets);
        jPanel.add(this.submitBtn);
        jPanel.add(this.createButton(this.RESET));
        jPanel.add(this.createButton(this.CLOSE));
        return jPanel;
    }

    private void createAllPanels() {
        this.getContentPane().removeAll();
        this.getContentPane().setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 3));
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createTitledBorder(null, this.TITRE2, 2, 2, Aladin.LBOLD)));
        jPanel.add(this.getTopPanel());
        JPanel jPanel2 = this.getOptionsPanel();
        if (!Aladin.OUTREACH) {
            jPanel.add(jPanel2);
        }
        this.getContentPane().add((Component)jPanel, "Center");
        this.getContentPane().add((Component)this.getBottomPanel(), "South");
        this.pack();
        this.show();
        this.flagHide = false;
    }

    @Override
    public void show() {
        this.initCouleurs();
        this.fillCouleurTriangle();
        super.show();
        this.flagHide = false;
    }

    @Override
    public void hide() {
        this.a.toolBox.tool[12].mode = this.a.calque.getFirstSelectedPlanImage() != null ? 1 : 0;
        this.a.toolBox.repaint();
        this.flagHide = true;
        this.etat = -1;
        super.hide();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void majContour() {
        if (this.a.toolBox.tool[12].mode == -1) {
            int n;
            PlanImage planImage = this.a.calque.getFirstSelectedPlanImage();
            if (planImage == null || !planImage.flagOk || !planImage.isPixel() || this.etat == (n = planImage.getImgID())) return;
            this.etat = n;
            try {
                if (planImage instanceof PlanBG) {
                    ViewSimple viewSimple = this.a.view.getView(planImage);
                    if (viewSimple.rzoom.equals(this.memoRzoom)) return;
                    this.pimg = this.getCropImage(planImage);
                    this.memoRzoom = viewSimple.rzoom;
                } else {
                    this.pimg = planImage;
                }
            }
            catch (Exception exception) {
                Aladin.warning(this, exception.getMessage());
                return;
            }
            this.createAllPanels();
            return;
        }
        this.hide();
    }

    PlanImage getCropImage(Plan plan) throws Exception {
        if (!(plan instanceof PlanBG)) {
            throw new Exception("Contour cropping only on all-sky image");
        }
        ViewSimple viewSimple = this.a.view.getCurrentView();
        if (viewSimple.pref != plan) {
            throw new Exception("All-sky image contour is only available on current view !");
        }
        return this.a.calque.createCropImage(viewSimple);
    }

    private void fillCouleurTriangle() {
        for (int i = 0; i < this.curs.couleurTriangle.length; ++i) {
            this.curs.couleurTriangle[i] = this.couleurs[i];
        }
    }

    private void initCouleurs() {
        if (this.couleurs == null) {
            this.couleurs = new Color[20];
        }
        Color color = PlanContour.getNextColor(this.a.calque);
        Color[] colorArray = Couleur.getBrighterColors(color, 4);
        for (int i = 0; i < this.couleurs.length; ++i) {
            this.couleurs[i] = colorArray[i % colorArray.length];
        }
    }

    private void adjustsmooothLevelChoice() {
        if (!this.smoothCb.isSelected()) {
            this.smooothLevelChoice.setEnabled(false);
            this.lab1.setEnabled(false);
        } else {
            this.smooothLevelChoice.setEnabled(true);
            this.lab1.setEnabled(true);
        }
    }

    private void parseLevels() {
        int n;
        this.levels = new double[this.curs.nbNiveaux];
        for (n = 0; n < this.curs.nbNiveaux; ++n) {
            this.levels[n] = this.curs.niveaux[n];
        }
        for (n = 0; n < this.levels.length; ++n) {
            double d = this.levels[n];
            Color color = this.couleurs[n];
            for (int i = n + 1; i < this.levels.length; ++i) {
                if (!(this.levels[i] < d)) continue;
                double d2 = d;
                d = this.levels[i];
                this.levels[i] = d2;
                Color color2 = color;
                color = this.couleurs[i];
                this.couleurs[i] = color2;
                this.couleurs[n] = color;
            }
            this.levels[n] = d;
        }
    }

    protected static int[] generateLevels(int n) {
        int n2 = 0;
        int n3 = 255;
        int[] nArray = new int[n];
        double d = (n3 - n2) / (n + 1);
        for (int i = 0; i < n; ++i) {
            nArray[i] = (int)(d + d * (double)i);
        }
        return nArray;
    }

    protected void reset() {
        this.curs.reset();
        this.curs.niveaux[0] = 100;
        this.curs.nbNiveaux = 1;
    }

    private void createLevels(int n) {
        this.curs.nbNiveaux = 0;
        int[] nArray = FrameContour.generateLevels(n);
        for (int i = 0; i < nArray.length; ++i) {
            this.curs.addCurseur(nArray[i]);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        Object object = actionEvent.getSource();
        if (this.CLOSE.equals(string)) {
            this.hide();
        } else if (this.RESET.equals(string)) {
            this.reset();
        } else if (this.nbLevelsChoice.equals(object)) {
            int n = (Integer)this.nbLevelsChoice.getSelectedItem();
            this.createLevels(n);
        } else if (this.smoothCb.equals(object)) {
            this.adjustsmooothLevelChoice();
        } else if (this.helpBtn.equals(object)) {
            boolean bl = this.showHelp = !this.showHelp;
            if (this.showHelp) {
                this.helpBtn.setText(this.HIDEHELP);
            } else {
                this.helpBtn.setText(this.SHOWHELP);
            }
            this.smoothInfo.setVisible(this.showHelp);
            this.noiseInfo.setVisible(this.showHelp);
            this.zoomInfo.setVisible(this.showHelp);
            if (this.showHelp) {
                this.setLocation(this.getLocation().x, 70);
            } else {
                this.setLocation(this.getLocation().x, 200);
            }
            this.pack();
        } else if (this.SUBMIT.equals(string)) {
            this.hide();
            this.parseLevels();
            this.a.calque.newPlanContour("Contours", this.pimg, this.levels, new ContourPlot(), this.smoothCb.isSelected(), (Integer)this.smooothLevelChoice.getSelectedItem(), this.currentZoomOnly.isSelected(), this.noisecb.isSelected(), this.couleurs);
            this.a.console.printCommand("contour " + this.levels.length + (this.smoothCb.isSelected() ? "" : " nosmooth") + (this.currentZoomOnly.isSelected() ? " zoom" : ""));
            this.initCouleurs();
            this.fillCouleurTriangle();
            this.curs.repaint();
        } else if (this.NEWLEVEL.equals(string)) {
            this.curs.addCurseur();
        }
    }

    private JButton createButton(String string) {
        JButton jButton = new JButton(string);
        jButton.setFont(Aladin.PLAIN);
        jButton.setMargin(BUTTON_INSETS);
        jButton.addActionListener(this);
        return jButton;
    }

    @Override
    public boolean handleEvent(Event event) {
        if (event.id == 201) {
            this.hide();
        }
        return super.handleEvent(event);
    }
}

